// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.agg;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.exceptions.AnalysisException;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.functions.PropagateNullable;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.IntegerType;
import org.apache.doris.nereids.types.StringType;
import org.apache.doris.nereids.types.VarcharType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * AggregateFunction 'topn'. This class is generated by GenerateFunction.
 */
public class TopN extends AggregateFunction
        implements ExplicitlyCastableSignature, PropagateNullable {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.ret(VarcharType.SYSTEM_DEFAULT).args(VarcharType.SYSTEM_DEFAULT, IntegerType.INSTANCE),
            FunctionSignature.ret(VarcharType.SYSTEM_DEFAULT).args(StringType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(VarcharType.SYSTEM_DEFAULT)
                    .args(VarcharType.SYSTEM_DEFAULT, IntegerType.INSTANCE, IntegerType.INSTANCE),
            FunctionSignature.ret(VarcharType.SYSTEM_DEFAULT)
                    .args(StringType.INSTANCE, IntegerType.INSTANCE, IntegerType.INSTANCE)
    );

    /**
     * constructor with 2 arguments.
     */
    public TopN(Expression arg0, Expression arg1) {
        super("topn", arg0, arg1);
    }

    /**
     * constructor with 2 arguments.
     */
    public TopN(boolean distinct, Expression arg0, Expression arg1) {
        super("topn", distinct, arg0, arg1);
    }

    /**
     * constructor with 3 arguments.
     */
    public TopN(Expression arg0, Expression arg1, Expression arg2) {
        super("topn", arg0, arg1, arg2);
    }

    /**
     * constructor with 3 arguments.
     */
    public TopN(boolean distinct, Expression arg0, Expression arg1, Expression arg2) {
        super("topn", distinct, arg0, arg1, arg2);
    }

    @Override
    public void checkLegalityBeforeTypeCoercion() {
        if (!getArgument(1).isConstant() || !getArgumentType(1).isIntegerLikeType()) {
            throw new AnalysisException(
                    "topn requires second parameter must be a constant Integer Type: " + this.toSql());
        }
        if (arity() == 3) {
            if (!getArgument(2).isConstant() || !getArgumentType(2).isIntegerLikeType()) {
                throw new AnalysisException(
                        "topn requires the third parameter must be a constant Integer Type: " + this.toSql());
            }
        }
    }

    /**
     * withDistinctAndChildren.
     */
    @Override
    public TopN withDistinctAndChildren(boolean distinct, List<Expression> children) {
        Preconditions.checkArgument(children.size() == 2
                || children.size() == 3);
        if (children.size() == 2) {
            return new TopN(distinct, children.get(0), children.get(1));
        } else {
            return new TopN(distinct, children.get(0), children.get(1), children.get(2));
        }
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitTopN(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }
}
