#!/usr/bin/env python
# encoding: utf-8

# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
# This file is copied from
# https://github.com/apache/impala/blob/branch-2.9.0/common/function-registry/impala_functions.py
# and modified by Doris

# This is a list of all the functions that are not auto-generated.
# It contains all the meta data that describes the function.

# The format is:
#   [sql aliases], <return_type>, [<args>], <backend symbol>,
# With an optional
#   <prepare symbol>, <close symbol>, <vec>, <nullable mode>
#
# 'sql aliases' are the function names that can be used from sql. There must be at least
# one per function.
#
# 'vec' means that whether the vec engine support this function. There are two values of
# this params: 'vec', ''. If the value is 'vec', it means both normal and vec engine support
# this function. If the value is '', it means only normal engine support this function.
#
# 'nullable mode' reflects whether the return value of the function is null. See @Function.NullableMode
# for the specific mode and meaning.
#
# The symbol can be empty for functions that are not yet implemented or are special-cased
# in Expr::CreateExpr() (i.e., functions that are implemented via a custom Expr class
# rather than a single function).
visible_functions = [
    # Bit and Byte functions
    # For functions corresponding to builtin operators, we can reuse the implementations
    [['bitand'], 'TINYINT', ['TINYINT', 'TINYINT'],
        '_ZN5doris9Operators32bitand_tiny_int_val_tiny_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_10TinyIntValES6_', '', '', 'vec', ''],
    [['bitand'], 'SMALLINT', ['SMALLINT', 'SMALLINT'],
        '_ZN5doris9Operators34bitand_small_int_val_small_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_11SmallIntValES6_', '', '', 'vec', ''],
    [['bitand'], 'INT', ['INT', 'INT'],
        '_ZN5doris9Operators22bitand_int_val_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_6IntValES6_', '', '', 'vec', ''],
    [['bitand'], 'BIGINT', ['BIGINT', 'BIGINT'],
        '_ZN5doris9Operators30bitand_big_int_val_big_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_9BigIntValES6_', '', '', 'vec', ''],
    [['bitand'], 'LARGEINT', ['LARGEINT', 'LARGEINT'],
        '_ZN5doris9Operators34bitand_large_int_val_large_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_11LargeIntValES6_', '', '', 'vec', ''],

    [['bitor'], 'TINYINT', ['TINYINT', 'TINYINT'],
        '_ZN5doris9Operators31bitor_tiny_int_val_tiny_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_10TinyIntValES6_', '', '', 'vec', ''],
    [['bitor'], 'SMALLINT', ['SMALLINT', 'SMALLINT'],
        '_ZN5doris9Operators33bitor_small_int_val_small_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_11SmallIntValES6_', '', '', 'vec', ''],
    [['bitor'], 'INT', ['INT', 'INT'],
        '_ZN5doris9Operators21bitor_int_val_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_6IntValES6_', '', '', 'vec', ''],
    [['bitor'], 'BIGINT', ['BIGINT', 'BIGINT'],
        '_ZN5doris9Operators29bitor_big_int_val_big_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_9BigIntValES6_', '', '', 'vec', ''],
    [['bitor'], 'LARGEINT', ['LARGEINT', 'LARGEINT'],
        '_ZN5doris9Operators33bitor_large_int_val_large_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_11LargeIntValES6_', '', '', 'vec', ''],

    [['bitxor'], 'TINYINT', ['TINYINT', 'TINYINT'],
        '_ZN5doris9Operators32bitxor_tiny_int_val_tiny_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_10TinyIntValES6_', '', '', 'vec', ''],
    [['bitxor'], 'SMALLINT', ['SMALLINT', 'SMALLINT'],
        '_ZN5doris9Operators34bitxor_small_int_val_small_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_11SmallIntValES6_', '', '', 'vec', ''],
    [['bitxor'], 'INT', ['INT', 'INT'],
        '_ZN5doris9Operators22bitxor_int_val_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_6IntValES6_', '', '', 'vec', ''],
    [['bitxor'], 'BIGINT', ['BIGINT', 'BIGINT'],
        '_ZN5doris9Operators30bitxor_big_int_val_big_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_9BigIntValES6_', '', '', 'vec', ''],
    [['bitxor'], 'LARGEINT', ['LARGEINT', 'LARGEINT'],
        '_ZN5doris9Operators34bitxor_large_int_val_large_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_11LargeIntValES6_', '', '', 'vec', ''],

    [['bitnot'], 'TINYINT', ['TINYINT'],
        '_ZN5doris9Operators19bitnot_tiny_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_10TinyIntValE', '', '', 'vec', ''],
    [['bitnot'], 'SMALLINT', ['SMALLINT'],
        '_ZN5doris9Operators20bitnot_small_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_11SmallIntValE', '', '', 'vec', ''],
    [['bitnot'], 'INT', ['INT'],
        '_ZN5doris9Operators14bitnot_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_6IntValE', '', '', 'vec', ''],
    [['bitnot'], 'BIGINT', ['BIGINT'],
        '_ZN5doris9Operators18bitnot_big_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_9BigIntValE', '', '', 'vec', ''],
    [['bitnot'], 'LARGEINT', ['LARGEINT'],
        '_ZN5doris9Operators20bitnot_large_int_valEPN9doris_udf'
        '15FunctionContextERKNS1_11LargeIntValE', '', '', 'vec', ''],

    # array functions
    [['array'], 'ARRAY', ['BOOLEAN', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['TINYINT', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['SMALLINT', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['INT', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['BIGINT', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['LARGEINT', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['DATETIME', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['DATE', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['DATETIMEV2', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['DATEV2', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['FLOAT', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['DOUBLE', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['DECIMALV2', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['DECIMAL32', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['DECIMAL64', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['DECIMAL128', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['VARCHAR', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array'], 'ARRAY', ['STRING', '...'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],

    [['element_at', '%element_extract%'], 'BOOLEAN', ['ARRAY_BOOLEAN', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'TINYINT', ['ARRAY_TINYINT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'SMALLINT', ['ARRAY_SMALLINT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'INT', ['ARRAY_INT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'BIGINT', ['ARRAY_BIGINT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'LARGEINT', ['ARRAY_LARGEINT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'DATETIME', ['ARRAY_DATETIME', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'DATE', ['ARRAY_DATE', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'DATETIMEV2', ['ARRAY_DATETIMEV2', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'DATEV2', ['ARRAY_DATEV2', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'FLOAT', ['ARRAY_FLOAT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'DOUBLE', ['ARRAY_DOUBLE', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'DECIMALV2', ['ARRAY_DECIMALV2', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'DECIMAL32', ['ARRAY_DECIMAL32', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'DECIMAL64', ['ARRAY_DECIMAL64', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'DECIMAL128', ['ARRAY_DECIMAL128', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'VARCHAR', ['ARRAY_VARCHAR', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['element_at', '%element_extract%'], 'STRING', ['ARRAY_STRING', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_BOOLEAN', 'ARRAY_BOOLEAN'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_TINYINT', 'ARRAY_TINYINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_SMALLINT', 'ARRAY_SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_INT', 'ARRAY_INT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_BIGINT', 'ARRAY_BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_LARGEINT', 'ARRAY_LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_DATETIME', 'ARRAY_DATETIME'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_DATE', 'ARRAY_DATE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_DATETIMEV2', 'ARRAY_DATETIMEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_DATEV2', 'ARRAY_DATEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_FLOAT', 'ARRAY_FLOAT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_DOUBLE', 'ARRAY_DOUBLE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_DECIMALV2', 'ARRAY_DECIMALV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_DECIMAL32', 'ARRAY_DECIMAL32'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_DECIMAL64', 'ARRAY_DECIMAL64'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_DECIMAL128', 'ARRAY_DECIMAL128'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_VARCHAR', 'ARRAY_VARCHAR'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['arrays_overlap'], 'BOOLEAN', ['ARRAY_STRING', 'ARRAY_STRING'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['array_contains'], 'BOOLEAN', ['ARRAY_BOOLEAN', 'BOOLEAN'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_TINYINT', 'TINYINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_SMALLINT', 'SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_INT', 'INT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_BIGINT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_LARGEINT', 'LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_DATETIME', 'DATETIME'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_DATE', 'DATE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_DATETIMEV2', 'DATETIMEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_DATEV2', 'DATEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_FLOAT', 'FLOAT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_DOUBLE', 'DOUBLE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_DECIMALV2', 'DECIMALV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_DECIMAL32', 'DECIMAL32'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_DECIMAL64', 'DECIMAL64'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_DECIMAL128', 'DECIMAL128'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_VARCHAR', 'VARCHAR'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_contains'], 'BOOLEAN', ['ARRAY_STRING', 'STRING'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],


    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_BOOLEAN'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_TINYINT'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_INT'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_BIGINT'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_DATETIME'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_DATE'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_DATETIMEV2'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_DATEV2'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_FLOAT'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_DECIMAL128'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_VARCHAR'], '', '', '', 'vec', ''],
    [['array_enumerate'], 'ARRAY_BIGINT', ['ARRAY_STRING'], '', '', '', 'vec', ''],

    [['countequal'], 'BIGINT', ['ARRAY_BOOLEAN', 'BOOLEAN'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_TINYINT', 'TINYINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_SMALLINT', 'SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_INT', 'INT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_BIGINT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_LARGEINT', 'LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_DATETIME', 'DATETIME'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_DATE', 'DATE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_DATETIMEV2', 'DATETIMEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_DATEV2', 'DATEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_FLOAT', 'FLOAT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_DOUBLE', 'DOUBLE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_DECIMALV2', 'DECIMALV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_DECIMAL32', 'DECIMAL32'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_DECIMAL64', 'DECIMAL64'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_DECIMAL128', 'DECIMAL128'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_VARCHAR', 'VARCHAR'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['countequal'], 'BIGINT', ['ARRAY_STRING', 'STRING'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['array_position'], 'BIGINT', ['ARRAY_BOOLEAN', 'BOOLEAN'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_TINYINT', 'TINYINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_SMALLINT', 'SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_INT', 'INT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_BIGINT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_LARGEINT', 'LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_DATETIME', 'DATETIME'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_DATE', 'DATE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_DATETIMEV2', 'DATETIMEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_DATEV2', 'DATEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_FLOAT', 'FLOAT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_DOUBLE', 'DOUBLE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_DECIMALV2', 'DECIMALV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_DECIMAL32', 'DECIMAL32'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_DECIMAL64', 'DECIMAL64'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_DECIMAL128', 'DECIMAL128'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_VARCHAR', 'VARCHAR'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_position'], 'BIGINT', ['ARRAY_STRING', 'STRING'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['cardinality', 'size', 'array_size'], 'BIGINT', ['ARRAY'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_BOOLEAN',   ['ARRAY_BOOLEAN'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_TINYINT',   ['ARRAY_TINYINT'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_SMALLINT',  ['ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_INT',       ['ARRAY_INT'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_BIGINT',    ['ARRAY_BIGINT'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_LARGEINT',  ['ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_DATETIME',  ['ARRAY_DATETIME'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_DATE',      ['ARRAY_DATE'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_DATETIMEV2',  ['ARRAY_DATETIMEV2'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_DATEV2',      ['ARRAY_DATEV2'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_FLOAT',     ['ARRAY_FLOAT'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_DOUBLE',    ['ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_VARCHAR',   ['ARRAY_VARCHAR'], '', '', '', 'vec', ''],
    [['array_distinct'], 'ARRAY_STRING',    ['ARRAY_STRING'], '', '', '', 'vec', ''],

    [['array_difference'], 'ARRAY_SMALLINT',  ['ARRAY_TINYINT'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_INT',       ['ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_BIGINT',    ['ARRAY_INT'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_LARGEINT',  ['ARRAY_BIGINT'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_LARGEINT',  ['ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_DOUBLE',    ['ARRAY_FLOAT'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_DOUBLE',    ['ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['array_difference'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128'], '', '', '', 'vec', ''],

    [['array_sort'], 'ARRAY_BOOLEAN',   ['ARRAY_BOOLEAN'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_TINYINT',   ['ARRAY_TINYINT'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_SMALLINT',  ['ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_INT',       ['ARRAY_INT'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_BIGINT',    ['ARRAY_BIGINT'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_LARGEINT',  ['ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_DATETIME',  ['ARRAY_DATETIME'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_DATE',      ['ARRAY_DATE'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_DATETIMEV2',  ['ARRAY_DATETIMEV2'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_DATEV2',      ['ARRAY_DATEV2'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_FLOAT',     ['ARRAY_FLOAT'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_DOUBLE',    ['ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_VARCHAR',   ['ARRAY_VARCHAR'], '', '', '', 'vec', ''],
    [['array_sort'], 'ARRAY_STRING',    ['ARRAY_STRING'], '', '', '', 'vec', ''],

    # array_join takes two params
    [['array_join'], 'STRING',   ['ARRAY_BOOLEAN','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',   ['ARRAY_TINYINT','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',  ['ARRAY_SMALLINT','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',       ['ARRAY_INT','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',    ['ARRAY_BIGINT','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',  ['ARRAY_LARGEINT','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',  ['ARRAY_DATETIME','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',      ['ARRAY_DATE','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',  ['ARRAY_DATETIMEV2','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',      ['ARRAY_DATEV2','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',     ['ARRAY_FLOAT','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',    ['ARRAY_DOUBLE','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING', ['ARRAY_DECIMALV2','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING', ['ARRAY_DECIMAL32','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING', ['ARRAY_DECIMAL64','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING', ['ARRAY_DECIMAL128','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',   ['ARRAY_VARCHAR','VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',    ['ARRAY_STRING','VARCHAR'], '', '', '', 'vec', ''],
    # array_join takes three params
    [['array_join'], 'STRING',   ['ARRAY_BOOLEAN','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',   ['ARRAY_TINYINT','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',  ['ARRAY_SMALLINT','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',       ['ARRAY_INT','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',    ['ARRAY_BIGINT','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',  ['ARRAY_LARGEINT','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',  ['ARRAY_DATETIME','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',      ['ARRAY_DATE','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',  ['ARRAY_DATETIMEV2','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',      ['ARRAY_DATEV2','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',     ['ARRAY_FLOAT','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',    ['ARRAY_DOUBLE','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING', ['ARRAY_DECIMALV2','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING', ['ARRAY_DECIMAL32','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING', ['ARRAY_DECIMAL64','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING', ['ARRAY_DECIMAL128','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',   ['ARRAY_VARCHAR','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_join'], 'STRING',    ['ARRAY_STRING','VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],

    [['array_min'],     'BOOLEAN',  ['ARRAY_BOOLEAN'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'TINYINT',  ['ARRAY_TINYINT'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'SMALLINT', ['ARRAY_SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'INT',      ['ARRAY_INT'],      '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'BIGINT',   ['ARRAY_BIGINT'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'LARGEINT', ['ARRAY_LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'FLOAT',    ['ARRAY_FLOAT'],    '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'DOUBLE',   ['ARRAY_DOUBLE'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'DECIMALV2',['ARRAY_DECIMALV2'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'DECIMAL32',['ARRAY_DECIMAL32'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'DECIMAL64',['ARRAY_DECIMAL64'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'DECIMAL128',['ARRAY_DECIMAL128'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'DATE',     ['ARRAY_DATE'],     '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'DATETIME', ['ARRAY_DATETIME'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'DATEV2',     ['ARRAY_DATEV2'],     '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_min'],     'DATETIMEV2', ['ARRAY_DATETIMEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'BOOLEAN',  ['ARRAY_BOOLEAN'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'TINYINT',  ['ARRAY_TINYINT'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'SMALLINT', ['ARRAY_SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'INT',      ['ARRAY_INT'],      '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'BIGINT',   ['ARRAY_BIGINT'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'LARGEINT', ['ARRAY_LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'FLOAT',    ['ARRAY_FLOAT'],    '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'DOUBLE',   ['ARRAY_DOUBLE'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'DECIMALV2',['ARRAY_DECIMALV2'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'DECIMAL32',['ARRAY_DECIMAL32'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'DECIMAL64',['ARRAY_DECIMAL64'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'DECIMAL128',['ARRAY_DECIMAL128'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'DATE',     ['ARRAY_DATE'],     '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'DATETIME', ['ARRAY_DATETIME'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'DATEV2',     ['ARRAY_DATEV2'],     '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_max'],     'DATETIMEV2', ['ARRAY_DATETIMEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'BIGINT',   ['ARRAY_BOOLEAN'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'BIGINT',   ['ARRAY_TINYINT'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'BIGINT',   ['ARRAY_SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'BIGINT',   ['ARRAY_INT'],      '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'BIGINT',   ['ARRAY_BIGINT'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'LARGEINT', ['ARRAY_LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'DOUBLE',   ['ARRAY_FLOAT'],    '', '', '','vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'DOUBLE',   ['ARRAY_DOUBLE'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'DECIMALV2',['ARRAY_DECIMALV2'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'DECIMAL32',['ARRAY_DECIMAL32'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'DECIMAL64',['ARRAY_DECIMAL64'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_sum'],     'DECIMAL128',['ARRAY_DECIMAL128'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DOUBLE',   ['ARRAY_BOOLEAN'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DOUBLE',   ['ARRAY_TINYINT'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DOUBLE',   ['ARRAY_SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DOUBLE',   ['ARRAY_INT'],      '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DOUBLE',   ['ARRAY_BIGINT'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DOUBLE',   ['ARRAY_LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DOUBLE',   ['ARRAY_FLOAT'],    '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DOUBLE',   ['ARRAY_DOUBLE'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DECIMALV2',['ARRAY_DECIMALV2'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DECIMAL32',['ARRAY_DECIMAL32'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DECIMAL64',['ARRAY_DECIMAL64'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_avg'],     'DECIMAL128',['ARRAY_DECIMAL128'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DOUBLE',   ['ARRAY_BOOLEAN'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DOUBLE',   ['ARRAY_TINYINT'],  '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DOUBLE',   ['ARRAY_SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DOUBLE',   ['ARRAY_INT'],      '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DOUBLE',   ['ARRAY_BIGINT'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DOUBLE',   ['ARRAY_LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DOUBLE',   ['ARRAY_FLOAT'],    '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DOUBLE',   ['ARRAY_DOUBLE'],   '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DECIMALV2',['ARRAY_DECIMALV2'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DECIMAL32',['ARRAY_DECIMAL32'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DECIMAL64',['ARRAY_DECIMAL64'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_product'], 'DECIMAL128',['ARRAY_DECIMAL128'],'', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['array_remove'], 'ARRAY_BOOLEAN',   ['ARRAY_BOOLEAN', 'BOOLEAN'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_TINYINT',   ['ARRAY_TINYINT', 'TINYINT'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_SMALLINT',  ['ARRAY_SMALLINT', 'SMALLINT'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_INT',       ['ARRAY_INT', 'INT'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_BIGINT',    ['ARRAY_BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_LARGEINT',  ['ARRAY_LARGEINT', 'LARGEINT'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_FLOAT',     ['ARRAY_FLOAT', 'FLOAT'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_DOUBLE',    ['ARRAY_DOUBLE', 'DOUBLE'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2', 'DECIMALV2'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32', 'DECIMAL32'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64', 'DECIMAL64'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128', 'DECIMAL128'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_DATETIME',  ['ARRAY_DATETIME', 'DATETIME'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_DATE',      ['ARRAY_DATE', 'DATE'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_DATETIMEV2',  ['ARRAY_DATETIMEV2', 'DATETIMEV2'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_DATEV2',      ['ARRAY_DATEV2', 'DATEV2'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_VARCHAR',   ['ARRAY_VARCHAR', 'VARCHAR'], '', '', '', 'vec', ''],
    [['array_remove'], 'ARRAY_STRING',    ['ARRAY_STRING', 'STRING'], '', '', '', 'vec', ''],

    [['array_union'], 'ARRAY_BOOLEAN',  ['ARRAY_BOOLEAN', 'ARRAY_BOOLEAN'],  '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_TINYINT',  ['ARRAY_TINYINT', 'ARRAY_TINYINT'],  '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_SMALLINT', ['ARRAY_SMALLINT', 'ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_INT',      ['ARRAY_INT', 'ARRAY_INT'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_BIGINT',   ['ARRAY_BIGINT', 'ARRAY_BIGINT'],   '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_LARGEINT', ['ARRAY_LARGEINT', 'ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_FLOAT',     ['ARRAY_FLOAT', 'ARRAY_FLOAT'],  '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_DOUBLE',    ['ARRAY_DOUBLE', 'ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2', 'ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32', 'ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64', 'ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128', 'ARRAY_DECIMAL128'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_DATETIME',  ['ARRAY_DATETIME', 'ARRAY_DATETIME'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_DATE',      ['ARRAY_DATE', 'ARRAY_DATE'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_DATETIMEV2',  ['ARRAY_DATETIMEV2', 'ARRAY_DATETIMEV2'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_DATEV2',      ['ARRAY_DATEV2', 'ARRAY_DATEV2'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_VARCHAR',   ['ARRAY_VARCHAR', 'ARRAY_VARCHAR'], '', '', '', 'vec', ''],
    [['array_union'], 'ARRAY_STRING',    ['ARRAY_STRING', 'ARRAY_STRING'], '', '', '', 'vec', ''],

    [['array_except'], 'ARRAY_BOOLEAN',  ['ARRAY_BOOLEAN', 'ARRAY_BOOLEAN'],  '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_TINYINT',  ['ARRAY_TINYINT', 'ARRAY_TINYINT'],  '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_SMALLINT', ['ARRAY_SMALLINT', 'ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_INT',      ['ARRAY_INT', 'ARRAY_INT'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_BIGINT',   ['ARRAY_BIGINT', 'ARRAY_BIGINT'],   '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_LARGEINT', ['ARRAY_LARGEINT', 'ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_FLOAT',     ['ARRAY_FLOAT', 'ARRAY_FLOAT'],  '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_DOUBLE',    ['ARRAY_DOUBLE', 'ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2', 'ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32', 'ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64', 'ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128', 'ARRAY_DECIMAL128'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_DATETIME',  ['ARRAY_DATETIME', 'ARRAY_DATETIME'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_DATE',      ['ARRAY_DATE', 'ARRAY_DATE'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_DATETIMEV2',  ['ARRAY_DATETIMEV2', 'ARRAY_DATETIMEV2'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_DATEV2',      ['ARRAY_DATEV2', 'ARRAY_DATEV2'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_VARCHAR',   ['ARRAY_VARCHAR', 'ARRAY_VARCHAR'], '', '', '', 'vec', ''],
    [['array_except'], 'ARRAY_STRING',    ['ARRAY_STRING', 'ARRAY_STRING'], '', '', '', 'vec', ''],

    [['array_compact'], 'ARRAY_BOOLEAN',   ['ARRAY_BOOLEAN'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_TINYINT',   ['ARRAY_TINYINT'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_SMALLINT',  ['ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_INT',       ['ARRAY_INT'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_BIGINT',    ['ARRAY_BIGINT'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_LARGEINT',  ['ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_DATETIME',  ['ARRAY_DATETIME'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_DATE',      ['ARRAY_DATE'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_DATETIMEV2',  ['ARRAY_DATETIMEV2'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_DATEV2',      ['ARRAY_DATEV2'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_FLOAT',     ['ARRAY_FLOAT'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_DOUBLE',    ['ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128'], '', '', '', 'vec', ''],
    [['array_compact'], 'ARRAY_VARCHAR',   ['ARRAY_VARCHAR'], '', '', '', 'vec', ''],

    [['array_intersect'], 'ARRAY_BOOLEAN',  ['ARRAY_BOOLEAN', 'ARRAY_BOOLEAN'],  '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_TINYINT',  ['ARRAY_TINYINT', 'ARRAY_TINYINT'],  '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_SMALLINT', ['ARRAY_SMALLINT', 'ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_INT',      ['ARRAY_INT', 'ARRAY_INT'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_BIGINT',   ['ARRAY_BIGINT', 'ARRAY_BIGINT'],   '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_LARGEINT', ['ARRAY_LARGEINT', 'ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_FLOAT',     ['ARRAY_FLOAT', 'ARRAY_FLOAT'],  '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_DOUBLE',    ['ARRAY_DOUBLE', 'ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2', 'ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32', 'ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64', 'ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128', 'ARRAY_DECIMAL128'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_DATETIME',  ['ARRAY_DATETIME', 'ARRAY_DATETIME'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_DATE',      ['ARRAY_DATE', 'ARRAY_DATE'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_DATETIMEV2',  ['ARRAY_DATETIMEV2', 'ARRAY_DATETIMEV2'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_DATEV2',      ['ARRAY_DATEV2', 'ARRAY_DATEV2'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_VARCHAR',   ['ARRAY_VARCHAR', 'ARRAY_VARCHAR'], '', '', '', 'vec', ''],
    [['array_intersect'], 'ARRAY_STRING',    ['ARRAY_STRING', 'ARRAY_STRING'], '', '', '', 'vec', ''],

    [['array_slice', '%element_slice%'], 'ARRAY_BOOLEAN', ['ARRAY_BOOLEAN', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_TINYINT', ['ARRAY_TINYINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_SMALLINT', ['ARRAY_SMALLINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_INT', ['ARRAY_INT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_BIGINT', ['ARRAY_BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_LARGEINT', ['ARRAY_LARGEINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DATETIME', ['ARRAY_DATETIME', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DATE', ['ARRAY_DATE', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_FLOAT', ['ARRAY_FLOAT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DOUBLE', ['ARRAY_DOUBLE', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_VARCHAR', ['ARRAY_VARCHAR', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_STRING', ['ARRAY_STRING', 'BIGINT'], '', '', '', 'vec', ''],

    [['array_slice', '%element_slice%'], 'ARRAY_BOOLEAN', ['ARRAY_BOOLEAN', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_TINYINT', ['ARRAY_TINYINT', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_SMALLINT', ['ARRAY_SMALLINT', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_INT', ['ARRAY_INT', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_BIGINT', ['ARRAY_BIGINT', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_LARGEINT', ['ARRAY_LARGEINT', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DATETIME', ['ARRAY_DATETIME', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DATE', ['ARRAY_DATE', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_FLOAT', ['ARRAY_FLOAT', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DOUBLE', ['ARRAY_DOUBLE', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_VARCHAR', ['ARRAY_VARCHAR', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],
    [['array_slice', '%element_slice%'], 'ARRAY_STRING', ['ARRAY_STRING', 'BIGINT', 'BIGINT'], '', '', '', 'vec', ''],

    [['array_popback'], 'ARRAY_BOOLEAN', ['ARRAY_BOOLEAN'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_TINYINT', ['ARRAY_TINYINT'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_SMALLINT', ['ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_INT', ['ARRAY_INT'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_BIGINT', ['ARRAY_BIGINT'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_LARGEINT', ['ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_DATETIME', ['ARRAY_DATETIME'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_DATE', ['ARRAY_DATE'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_FLOAT', ['ARRAY_FLOAT'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_DOUBLE', ['ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_VARCHAR', ['ARRAY_VARCHAR'], '', '', '', 'vec', ''],
    [['array_popback'], 'ARRAY_STRING', ['ARRAY_STRING'], '', '', '', 'vec', ''],

    [['array_with_constant'], 'ARRAY_BOOLEAN', ['BIGINT', 'BOOLEAN'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_TINYINT', ['BIGINT', 'TINYINT'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_SMALLINT', ['BIGINT','SMALLINT'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_INT', ['BIGINT', 'INT'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_BIGINT', ['BIGINT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_LARGEINT', ['BIGINT', 'LARGEINT'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_DATETIME', ['BIGINT', 'DATETIME'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_DATE', ['BIGINT', 'DATE'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_FLOAT', ['BIGINT', 'FLOAT'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_DOUBLE', ['BIGINT', 'DOUBLE'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_DECIMALV2', ['BIGINT', 'DECIMALV2'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_DECIMAL32', ['BIGINT', 'DECIMAL32'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_DECIMAL64', ['BIGINT', 'DECIMAL64'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_DECIMAL128', ['BIGINT', 'DECIMAL128'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_VARCHAR', ['BIGINT', 'VARCHAR'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['array_with_constant'], 'ARRAY_STRING', ['BIGINT', 'STRING'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    
    [['array_range'], 'ARRAY_INT',       ['INT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_range'], 'ARRAY_INT',       ['INT', 'INT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['array_range'], 'ARRAY_INT',       ['INT', 'INT', 'INT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    # reverse function for string builtin
    [['reverse'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris15StringFunctions7reverseEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    # reverse function support the longtext
    [['reverse'], 'STRING', ['STRING'],
            '_ZN5doris15StringFunctions7reverseEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    # reverse function support the array type
    [['reverse'], 'ARRAY_TINYINT',   ['ARRAY_TINYINT'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_SMALLINT',  ['ARRAY_SMALLINT'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_INT',       ['ARRAY_INT'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_BIGINT',    ['ARRAY_BIGINT'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_LARGEINT',  ['ARRAY_LARGEINT'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_DATETIME',  ['ARRAY_DATETIME'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_DATE',      ['ARRAY_DATE'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_FLOAT',     ['ARRAY_FLOAT'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_DOUBLE',    ['ARRAY_DOUBLE'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_DECIMALV2', ['ARRAY_DECIMALV2'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_DECIMAL32', ['ARRAY_DECIMAL32'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_DECIMAL64', ['ARRAY_DECIMAL64'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_DECIMAL128', ['ARRAY_DECIMAL128'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_VARCHAR',   ['ARRAY_VARCHAR'], '', '', '', 'vec', ''],
    [['reverse'], 'ARRAY_STRING',    ['ARRAY_STRING'], '', '', '', 'vec', ''],

    # Timestamp functions
    [['unix_timestamp'], 'INT', [],
        '_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['unix_timestamp'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['unix_timestamp'], 'INT', ['DATE'],
        '_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['unix_timestamp'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_11DateV2TimeValE',
     '', '', 'vec', ''],
    [['unix_timestamp'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['unix_timestamp'], 'INT', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['unix_timestamp'], 'INT', ['STRING', 'STRING'],
        '_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['from_unixtime'], 'VARCHAR', ['INT'],
        '_ZN5doris18TimestampFunctions9from_unixEPN9doris_udf15FunctionContextERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['from_unixtime'], 'VARCHAR', ['INT', 'VARCHAR'],
        '_ZN5doris18TimestampFunctions9from_unixEPN9doris_udf'
        '15FunctionContextERKNS1_6IntValERKNS1_9StringValE',
        '_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf'
        '15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf'
        '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['from_unixtime'], 'VARCHAR', ['INT', 'STRING'],
        '_ZN5doris18TimestampFunctions9from_unixEPN9doris_udf'
        '15FunctionContextERKNS1_6IntValERKNS1_9StringValE',
        '_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf'
        '15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf'
        '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['now', 'current_timestamp', 'localtime', 'localtimestamp'], 'DATETIME', [],
        '_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['now', 'current_timestamp', 'localtime', 'localtimestamp'], 'DATETIMEV2', ['INT'],
     '_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE',
     '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['curtime', 'current_time'], 'TIME', [],
        '_ZN5doris18TimestampFunctions7curtimeEPN9doris_udf15FunctionContextE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['curdate', 'current_date'], 'DATE', [],
        '_ZN5doris18TimestampFunctions7curdateEPN9doris_udf15FunctionContextE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['utc_timestamp'], 'DATETIME', [],
        '_ZN5doris18TimestampFunctions13utc_timestampEPN9doris_udf15FunctionContextE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['timestamp'], 'DATETIME', ['DATETIME'],
        '_ZN5doris18TimestampFunctions9timestampEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['from_days'], 'DATE', ['INT'],
        '_ZN5doris18TimestampFunctions9from_daysEPN9doris_udf15FunctionContextERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['last_day'], 'DATE', ['DATETIME'],
        '_ZN5doris18TimestampFunctions8last_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['last_day'], 'DATE', ['DATE'],
        '_ZN5doris18TimestampFunctions8last_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['last_day'], 'DATEV2', ['DATETIMEV2'],
        '_ZN5doris18TimestampFunctions8last_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', ''],
    [['last_day'], 'DATEV2', ['DATEV2'],
        '_ZN5doris18TimestampFunctions8last_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', ''],
    [['to_monday'], 'DATEV2', ['DATETIMEV2'],
        '', '', '', 'vec', ''],
    [['to_monday'], 'DATEV2', ['DATEV2'],
        '','', '', 'vec', ''],
    [['to_monday'], 'DATE', ['DATETIME'],
        '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['to_monday'], 'DATE', ['DATE'],
        '','', '', 'vec', 'ALWAYS_NULLABLE'],
    [['to_days'], 'INT', ['DATE'],
        '_ZN5doris18TimestampFunctions7to_daysEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['date_trunc'], 'DATETIME', ['DATETIME', 'VARCHAR'],
        '', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['date_trunc'], 'DATETIMEV2', ['DATETIMEV2', 'VARCHAR'],
        '', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['year'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions4yearEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions5monthEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['quarter'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions7quarterEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['dayofweek'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions11day_of_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['weekday'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions8week_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day', 'dayofmonth'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions12day_of_monthEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['dayofyear'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions11day_of_yearEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['weekofyear'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions12week_of_yearEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['yearweek'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['yearweek'], 'INT', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week'], 'INT', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions4hourEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions6minuteEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second'], 'INT', ['DATETIME'],
        '_ZN5doris18TimestampFunctions6secondEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['makedate'], 'DATE', ['INT', 'INT'],
        '_ZN5doris18TimestampFunctions9make_dateEPN9doris_udf15FunctionContextERKNS1_6IntValES6_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['years_add'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions9years_addEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['years_sub'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions9years_subEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['months_add', 'add_months'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions10months_addEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['months_sub'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions10months_subEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['weeks_add'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions9weeks_addEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['weeks_sub'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions9weeks_subEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['days_add', 'date_add', 'adddate'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions8days_addEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['days_sub', 'date_sub', 'subdate'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions8days_subEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hours_add'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions9hours_addEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hours_sub'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions9hours_subEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minutes_add'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions11minutes_addEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minutes_sub'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions11minutes_subEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['seconds_add'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions11seconds_addEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['seconds_sub'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions11seconds_subEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['microseconds_add'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions10micros_addEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['microseconds_sub'], 'DATETIME', ['DATETIME', 'INT'],
        '_ZN5doris18TimestampFunctions10micros_subEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['datediff'], 'INT', ['DATETIME', 'DATETIME'],
        '_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['timediff'], 'TIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf'
            '15FunctionContextERKNS1_11DateTimeValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['str_to_date'], 'DATETIME', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris18TimestampFunctions11str_to_dateEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['str_to_date'], 'DATETIME', ['STRING', 'STRING'],
        '_ZN5doris18TimestampFunctions11str_to_dateEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['date_format'], 'VARCHAR', ['DATETIME', 'VARCHAR'],
        '_ZN5doris18TimestampFunctions11date_formatEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_9StringValE',
        '_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf'
        '15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf'
        '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['date_format'], 'VARCHAR', ['DATE', 'VARCHAR'],
        '_ZN5doris18TimestampFunctions11date_formatEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValERKNS1_9StringValE',
        '_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf'
        '15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf'
        '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['date', 'to_date'], 'DATE', ['DATETIME'],
        '_ZN5doris18TimestampFunctions7to_dateEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['dayname'], 'VARCHAR', ['DATETIME'],
        '_ZN5doris18TimestampFunctions8day_nameEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['monthname'], 'VARCHAR', ['DATETIME'],
        '_ZN5doris18TimestampFunctions10month_nameEPN9doris_udf'
        '15FunctionContextERKNS1_11DateTimeValE', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['convert_tz'], 'DATETIME', ['DATETIME', 'VARCHAR', 'VARCHAR'],
            '_ZN5doris18TimestampFunctions10convert_tzEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_9StringValES9_',
            '_ZN5doris18TimestampFunctions18convert_tz_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris18TimestampFunctions16convert_tz_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
            'vec', 'ALWAYS_NULLABLE'],

    [['years_diff'], 'BIGINT', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['months_diff'], 'BIGINT', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['weeks_diff'], 'BIGINT', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['days_diff'], 'BIGINT', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hours_diff'], 'BIGINT', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minutes_diff'], 'BIGINT', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['seconds_diff'], 'BIGINT', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['year_floor'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_floor'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_floor'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_floor'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_floor'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_floor'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_floor'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_floor'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_ceil'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_ceil'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_ceil'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_ceil'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_floor'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_floor'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_floor'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_floor'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_ceil'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_ceil'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_ceil'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_ceil'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_floor'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_floor'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_floor'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_floor'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_ceil'], 'DATETIME', ['DATETIME'],
            '_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_ceil'], 'DATETIME', ['DATETIME', 'DATETIME'],
            '_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_ceil'], 'DATETIME', ['DATETIME', 'INT'],
            '_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_ceil'], 'DATETIME', ['DATETIME', 'INT', 'DATETIME'],
            '_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['timestamp'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9timestampEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],

    [['to_days'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions7to_daysEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],

    [['year'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions4yearEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['month'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions5monthEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['quarter'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions7quarterEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['dayofweek'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11day_of_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['weekday'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions8week_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['day', 'dayofmonth'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12day_of_monthEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValE', '', '', 'vec', ''],
    [['dayofyear'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11day_of_yearEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValE', '', '', 'vec', ''],
    [['weekofyear'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12week_of_yearEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValE', '', '', 'vec', ''],
    [['yearweek'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['yearweek'], 'INT', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['week'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['week'], 'INT', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['hour'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions4hourEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['minute'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions6minuteEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],
    [['second'], 'INT', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions6secondEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', ''],

    [['year'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions4yearEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],
    [['month'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions5monthEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],
    [['quarter'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions7quarterEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],
    [['dayofweek'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions11day_of_weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],
    [['weekday'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions8week_dayEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],
    [['day', 'dayofmonth'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions12day_of_monthEPN9doris_udf'
     '15FunctionContextERKNS1_11DateV2ValE', '', '', 'vec', ''],
    [['dayofyear'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions11day_of_yearEPN9doris_udf'
     '15FunctionContextERKNS1_11DateV2ValE', '', '', 'vec', ''],
    [['weekofyear'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions12week_of_yearEPN9doris_udf'
     '15FunctionContextERKNS1_11DateV2ValE', '', '', 'vec', ''],
    [['yearweek'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],
    [['yearweek'], 'INT', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['week'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],
    [['week'], 'INT', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['hour'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions4hourEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],
    [['minute'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions6minuteEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],
    [['second'], 'INT', ['DATEV2'],
     '_ZN5doris18TimestampFunctions6secondEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE',
     '', '', 'vec', ''],

    [['years_add'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9years_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['years_sub'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9years_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['months_add', 'add_months'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10months_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['months_sub'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10months_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['weeks_add'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9weeks_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['weeks_sub'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9weeks_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['days_add', 'date_add', 'adddate'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions8days_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['days_sub', 'date_sub', 'subdate'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions8days_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['hours_add'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9hours_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['hours_sub'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9hours_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['minutes_add'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11minutes_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['minutes_sub'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11minutes_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['seconds_add'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11seconds_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['seconds_sub'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11seconds_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['microseconds_add'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10micros_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['microseconds_sub'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10micros_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],

    [['years_add'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9years_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['years_sub'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9years_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['months_add', 'add_months'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10months_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['months_sub'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10months_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['weeks_add'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9weeks_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['weeks_sub'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9weeks_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['days_add', 'date_add', 'adddate'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions8days_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['days_sub', 'date_sub', 'subdate'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions8days_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['hours_add'], 'DATETIMEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9hours_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['hours_sub'], 'DATETIMEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9hours_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['minutes_add'], 'DATETIMEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11minutes_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['minutes_sub'], 'DATETIMEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11minutes_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['seconds_add'], 'DATETIMEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11seconds_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['seconds_sub'], 'DATETIMEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11seconds_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['microseconds_add'], 'DATETIMEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10micros_addEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],
    [['microseconds_sub'], 'DATETIMEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10micros_subEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', ''],

    [['datediff'], 'INT', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],
    [['timediff'], 'TIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],

    [['datediff'], 'INT', ['DATETIMEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],
    [['timediff'], 'TIMEV2', ['DATETIMEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],

    [['datediff'], 'INT', ['DATEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],
    [['timediff'], 'TIMEV2', ['DATEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],

    [['datediff'], 'INT', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],
    [['timediff'], 'TIMEV2', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],

    [['datediff'], 'INT', ['DATETIMEV2', 'DATETIME'],
     '_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],
    [['timediff'], 'TIMEV2', ['DATETIMEV2', 'DATETIME'],
     '_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],

    [['datediff'], 'INT', ['DATEV2', 'DATETIME'],
     '_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],
    [['timediff'], 'TIMEV2', ['DATEV2', 'DATETIME'],
     '_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValES6_', '', '', 'vec', ''],

    [['date_format'], 'VARCHAR', ['DATETIMEV2', 'VARCHAR'],
     '_ZN5doris18TimestampFunctions11date_formatEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_9StringValE',
     '_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf'
     '15FunctionContextENS2_18FunctionStateScopeE',
     '_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf'
     '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['date_format'], 'VARCHAR', ['DATEV2', 'VARCHAR'],
     '_ZN5doris18TimestampFunctions11date_formatEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValERKNS1_9StringValE',
     '_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf'
     '15FunctionContextENS2_18FunctionStateScopeE',
     '_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf'
     '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['date', 'to_date', 'datev2', 'to_datev2'], 'DATEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions7to_dateEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['dayname'], 'VARCHAR', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions8day_nameEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValE', '', '', 'vec', ''],
    [['monthname'], 'VARCHAR', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10month_nameEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValE', '', '', 'vec', ''],

    [['dayname'], 'VARCHAR', ['DATEV2'],
     '_ZN5doris18TimestampFunctions8day_nameEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValE', '', '', 'vec', ''],
    [['monthname'], 'VARCHAR', ['DATEV2'],
     '_ZN5doris18TimestampFunctions10month_nameEPN9doris_udf'
     '15FunctionContextERKNS1_11DateTimeV2ValE', '', '', 'vec', ''],

    [['convert_tz'], 'DATETIMEV2', ['DATETIMEV2', 'VARCHAR', 'VARCHAR'],
     '_ZN5doris18TimestampFunctions10convert_tzEPN9doris_udf15FunctionContextERKNS1_11DateV2ValERKNS1_9StringValES9_',
     '_ZN5doris18TimestampFunctions18convert_tz_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
     '_ZN5doris18TimestampFunctions16convert_tz_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
     'vec', 'ALWAYS_NULLABLE'],

    [['convert_tz'], 'DATEV2', ['DATEV2', 'VARCHAR', 'VARCHAR'],
     '_ZN5doris18TimestampFunctions10convert_tzEPN9doris_udf15FunctionContextERKNS1_11DateV2ValERKNS1_9StringValES9_',
     '_ZN5doris18TimestampFunctions18convert_tz_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
     '_ZN5doris18TimestampFunctions16convert_tz_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
     'vec', 'ALWAYS_NULLABLE'],

    [['years_diff'], 'BIGINT', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['months_diff'], 'BIGINT', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['weeks_diff'], 'BIGINT', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['days_diff'], 'BIGINT', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['hours_diff'], 'BIGINT', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['minutes_diff'], 'BIGINT', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['seconds_diff'], 'BIGINT', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],

    [['years_diff'], 'BIGINT', ['DATEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['months_diff'], 'BIGINT', ['DATEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['weeks_diff'], 'BIGINT', ['DATEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['days_diff'], 'BIGINT', ['DATEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['hours_diff'], 'BIGINT', ['DATEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['minutes_diff'], 'BIGINT', ['DATEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['seconds_diff'], 'BIGINT', ['DATEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],

    [['years_diff'], 'BIGINT', ['DATETIMEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['months_diff'], 'BIGINT', ['DATETIMEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['weeks_diff'], 'BIGINT', ['DATETIMEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['days_diff'], 'BIGINT', ['DATETIMEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['hours_diff'], 'BIGINT', ['DATETIMEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['minutes_diff'], 'BIGINT', ['DATETIMEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['seconds_diff'], 'BIGINT', ['DATETIMEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['years_diff'], 'BIGINT', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['months_diff'], 'BIGINT', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['weeks_diff'], 'BIGINT', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['days_diff'], 'BIGINT', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['hours_diff'], 'BIGINT', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['minutes_diff'], 'BIGINT', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],
    [['seconds_diff'], 'BIGINT', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', ''],

    [['year_floor'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_floor'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_floor'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_floor'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_ceil'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['hour_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_floor'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_floor'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_ceil'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['minute_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_floor'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_floor'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_floor'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_ceil'], 'DATETIMEV2', ['DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['second_ceil'], 'DATETIMEV2', ['DATETIMEV2', 'INT', 'DATETIMEV2'],
     '_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['year_floor'], 'DATEV2', ['DATEV2'],
     '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_floor'], 'DATEV2', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_floor'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_floor'], 'DATEV2', ['DATEV2', 'INT', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATEV2', ['DATEV2'],
     '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATEV2', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['year_ceil'], 'DATEV2', ['DATEV2', 'INT', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATEV2', ['DATEV2'],
     '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATEV2', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_floor'], 'DATEV2', ['DATEV2', 'INT', 'DATEV2'],
     '_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATEV2', ['DATEV2'],
     '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATEV2', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['month_ceil'], 'DATEV2', ['DATEV2', 'INT', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATEV2', ['DATEV2'],
     '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATEV2', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_floor'], 'DATEV2', ['DATEV2', 'INT', 'DATEV2'],
     '_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATEV2', ['DATEV2'],
     '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATEV2', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['week_ceil'], 'DATEV2', ['DATEV2', 'INT', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATEV2', ['DATEV2'],
     '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATEV2', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_floor'], 'DATEV2', ['DATEV2', 'INT', 'DATEV2'],
     '_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATEV2', ['DATEV2'],
     '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATEV2', ['DATEV2', 'DATEV2'],
     '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATEV2', ['DATEV2', 'INT'],
     '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE',
     '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['day_ceil'], 'DATEV2', ['DATEV2', 'INT', 'DATEV2'],
     '_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_',
     '', '', 'vec', 'ALWAYS_NULLABLE'],

    # Math builtin functions
    [['pi'], 'DOUBLE', [],
        '_ZN5doris13MathFunctions2piEPN9doris_udf15FunctionContextE', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['e'], 'DOUBLE', [],
        '_ZN5doris13MathFunctions1eEPN9doris_udf15FunctionContextE', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],

    [['abs'], 'DOUBLE', ['DOUBLE'],
        '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['abs'], 'FLOAT', ['FLOAT'],
        '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_8FloatValE', '', '', 'vec', ''],
    [['abs'], 'LARGEINT', ['LARGEINT'],
        '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_11LargeIntValE', '', '', 'vec', ''],
    [['abs'], 'LARGEINT', ['BIGINT'],
        '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_9BigIntValE', '', '', 'vec', ''],
    [['abs'], 'INT', ['SMALLINT'],
        '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_11SmallIntValE', '', '', 'vec', ''],
    [['abs'], 'BIGINT', ['INT'],
        '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_6IntValE', '', '', 'vec', ''],
    [['abs'], 'SMALLINT', ['TINYINT'],
        '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_10TinyIntValE', '', '', 'vec', ''],
    [['abs'], 'DECIMALV2', ['DECIMALV2'],
        '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['abs'], 'DECIMAL32', ['DECIMAL32'],
     '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['abs'], 'DECIMAL64', ['DECIMAL64'],
     '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['abs'], 'DECIMAL128', ['DECIMAL128'],
     '_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],

    [['sign'], 'TINYINT', ['DOUBLE'],
        '_ZN5doris13MathFunctions4signEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],

    [['sin'], 'DOUBLE', ['DOUBLE'],
        '_ZN5doris13MathFunctions3sinEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['asin'], 'DOUBLE', ['DOUBLE'],
        '_ZN5doris13MathFunctions4asinEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['cos'], 'DOUBLE', ['DOUBLE'],
        '_ZN5doris13MathFunctions3cosEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['acos'], 'DOUBLE', ['DOUBLE'],
        '_ZN5doris13MathFunctions4acosEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['tan'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions3tanEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['atan'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions4atanEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],

    [['ceil', 'ceiling', 'dceil'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['floor', 'dfloor'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['round', 'dround'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['truncate'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],

    [['ceil', 'ceiling', 'dceil'], 'DOUBLE', ['DOUBLE', 'INT'],
            '_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['floor', 'dfloor'], 'DOUBLE', ['DOUBLE', 'INT'],
            '_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['round', 'dround'], 'DOUBLE', ['DOUBLE', 'INT'],
            '_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['truncate'], 'DOUBLE', ['DOUBLE', 'INT'],
             '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
             '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],

    [['ceil', 'ceiling', 'dceil'], 'DECIMAL32', ['DECIMAL32'],
            '_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['floor', 'dfloor'], 'DECIMAL32', ['DECIMAL32'],
            '_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['round', 'dround'], 'DECIMAL32', ['DECIMAL32'],
            '_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['ceil', 'ceiling', 'dceil'], 'DECIMAL64', ['DECIMAL64'],
            '_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['floor', 'dfloor'], 'DECIMAL64', ['DECIMAL64'],
            '_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['round', 'dround'], 'DECIMAL64', ['DECIMAL64'],
            '_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['ceil', 'ceiling', 'dceil'], 'DECIMAL128', ['DECIMAL128'],
            '_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['floor', 'dfloor'], 'DECIMAL128', ['DECIMAL128'],
            '_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['round', 'dround'], 'DECIMAL128', ['DECIMAL128'],
            '_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['round', 'dround'], 'DOUBLE', ['DOUBLE', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['round', 'dround'], 'DECIMAL32', ['DECIMAL32', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['round', 'dround'], 'DECIMAL64', ['DECIMAL64', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['round', 'dround'], 'DECIMAL128', ['DECIMAL128', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['floor', 'dfloor'], 'DECIMAL32', ['DECIMAL32', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['floor', 'dfloor'], 'DECIMAL64', ['DECIMAL64', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['floor', 'dfloor'], 'DECIMAL128', ['DECIMAL128', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['ceil', 'dceil'], 'DECIMAL32', ['DECIMAL32', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['ceil', 'dceil'], 'DECIMAL64', ['DECIMAL64', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['ceil', 'dceil'], 'DECIMAL128', ['DECIMAL128', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['truncate'], 'DOUBLE', ['DOUBLE', 'INT'],
            '_ZN5doris13MathFunctions8truncateEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['truncate'], 'DECIMAL32', ['DECIMAL32', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['truncate'], 'DECIMAL64', ['DECIMAL64', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],
    [['truncate'], 'DECIMAL128', ['DECIMAL128', 'INT'],
            '_ZN5doris13MathFunctions11round_up_toEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE', '', '', 'vec', ''],

    [['ln', 'dlog1'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions2lnEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['log'], 'DOUBLE', ['DOUBLE', 'DOUBLE'],
            '_ZN5doris13MathFunctions3logEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['log2'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions4log2EPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['log10', 'dlog10'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions5log10EPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['exp', 'dexp'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions3expEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],

    [['radians'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions7radiansEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['degrees'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions7degreesEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],

    [['sqrt', 'dsqrt'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions4sqrtEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['cbrt'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions4cbrtEPN9doris_udf15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['pow', 'power', 'dpow', 'fpow'], 'DOUBLE', ['DOUBLE', 'DOUBLE'],
            '_ZN5doris13MathFunctions3powEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_', '', '', 'vec', ''],

    [['rand', 'random'], 'DOUBLE', [],
            '_ZN5doris13MathFunctions4randEPN9doris_udf15FunctionContextE',
            '_ZN5doris13MathFunctions12rand_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris13MathFunctions10rand_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['rand', 'random'], 'DOUBLE', ['BIGINT'],
            '_ZN5doris13MathFunctions9rand_seedEPN9doris_udf15FunctionContextERKNS1_9BigIntValE',
            '_ZN5doris13MathFunctions12rand_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris13MathFunctions10rand_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', ''],

    [['bin'], 'VARCHAR', ['BIGINT'],
            '_ZN5doris13MathFunctions3binEPN9doris_udf15FunctionContextERKNS1_9BigIntValE', '', '', 'vec', ''],
    [['hex'], 'VARCHAR', ['BIGINT'],
            '_ZN5doris13MathFunctions7hex_intEPN9doris_udf15FunctionContextERKNS1_9BigIntValE', '', '', 'vec', ''],
    [['hex'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris13MathFunctions10hex_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['hex'], 'STRING', ['STRING'],
            '_ZN5doris13MathFunctions10hex_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['unhex'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris13MathFunctions5unhexEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['unhex'], 'STRING', ['STRING'],
            '_ZN5doris13MathFunctions5unhexEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['conv'], 'VARCHAR', ['BIGINT', 'TINYINT', 'TINYINT'],
            '_ZN5doris13MathFunctions8conv_intEPN9doris_udf'
            '15FunctionContextERKNS1_9BigIntValERKNS1_10TinyIntValES9_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['conv'], 'VARCHAR', ['VARCHAR', 'TINYINT', 'TINYINT'],
            '_ZN5doris13MathFunctions11conv_stringEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValERKNS1_10TinyIntValES9_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['conv'], 'VARCHAR', ['STRING', 'TINYINT', 'TINYINT'],
            '_ZN5doris13MathFunctions11conv_stringEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValERKNS1_10TinyIntValES9_', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['pmod'], 'BIGINT', ['BIGINT', 'BIGINT'],
            '_ZN5doris13MathFunctions11pmod_bigintEPN9doris_udf'
            '15FunctionContextERKNS1_9BigIntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['pmod'], 'DOUBLE', ['DOUBLE', 'DOUBLE'],
            '_ZN5doris13MathFunctions11pmod_doubleEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod'], 'TINYINT', ['TINYINT', 'TINYINT'],
            '_ZN5doris9Operators29mod_tiny_int_val_tiny_int_valEPN9doris_udf'
            '15FunctionContextERKNS1_10TinyIntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod'], 'SMALLINT', ['SMALLINT', 'SMALLINT'],
            '_ZN5doris9Operators31mod_small_int_val_small_int_valEPN9doris_udf'
            '15FunctionContextERKNS1_11SmallIntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod'], 'INT', ['INT', 'INT'],
            '_ZN5doris9Operators19mod_int_val_int_valEPN9doris_udf'
            '15FunctionContextERKNS1_6IntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod'], 'BIGINT', ['BIGINT', 'BIGINT'],
            '_ZN5doris9Operators27mod_big_int_val_big_int_valEPN9doris_udf'
            '15FunctionContextERKNS1_9BigIntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod'], 'LARGEINT', ['LARGEINT', 'LARGEINT'],
            '_ZN5doris9Operators31mod_large_int_val_large_int_valEPN9doris_udf'
            '15FunctionContextERKNS1_11LargeIntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod'], 'DECIMALV2', ['DECIMALV2', 'DECIMALV2'],
            '_ZN5doris18DecimalV2Operators31mod_decimalv2_val_decimalv2_valEPN9doris_udf'
            '15FunctionContextERKNS1_12DecimalV2ValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod'], 'DECIMAL32', ['DECIMAL32', 'DECIMAL32'],
     '_ZN5doris18DecimalV2Operators31mod_decimalv2_val_decimalv2_valEPN9doris_udf'
     '15FunctionContextERKNS1_12DecimalV2ValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod'], 'DECIMAL64', ['DECIMAL64', 'DECIMAL64'],
     '_ZN5doris18DecimalV2Operators31mod_decimalv2_val_decimalv2_valEPN9doris_udf'
     '15FunctionContextERKNS1_12DecimalV2ValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod'], 'DECIMAL128', ['DECIMAL128', 'DECIMAL128'],
     '_ZN5doris18DecimalV2Operators31mod_decimalv2_val_decimalv2_valEPN9doris_udf'
     '15FunctionContextERKNS1_12DecimalV2ValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod', 'fmod'], 'FLOAT', ['FLOAT', 'FLOAT'],
        '_ZN5doris13MathFunctions10fmod_floatEPN9doris_udf15FunctionContextERKNS1_8FloatValES6_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mod', 'fmod'], 'DOUBLE', ['DOUBLE', 'DOUBLE'],
        '_ZN5doris13MathFunctions11fmod_doubleEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['positive'], 'BIGINT', ['BIGINT'],
            '_ZN5doris13MathFunctions15positive_bigintEPN9doris_udf'
            '15FunctionContextERKNS1_9BigIntValE', '', '', 'vec', ''],
    [['positive'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions15positive_doubleEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['positive'], 'DECIMALV2', ['DECIMALV2'],
            '_ZN5doris13MathFunctions16positive_decimalEPN9doris_udf'
            '15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['positive'], 'DECIMAL32', ['DECIMAL32'],
            '_ZN5doris13MathFunctions16positive_decimalEPN9doris_udf'
            '15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['positive'], 'DECIMAL64', ['DECIMAL64'],
            '_ZN5doris13MathFunctions16positive_decimalEPN9doris_udf'
            '15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['positive'], 'DECIMAL128', ['DECIMAL128'],
            '_ZN5doris13MathFunctions16positive_decimalEPN9doris_udf'
            '15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['negative'], 'BIGINT', ['BIGINT'],
            '_ZN5doris13MathFunctions15negative_bigintEPN9doris_udf'
            '15FunctionContextERKNS1_9BigIntValE', '', '', 'vec', ''],
    [['negative'], 'DOUBLE', ['DOUBLE'],
            '_ZN5doris13MathFunctions15negative_doubleEPN9doris_udf'
            '15FunctionContextERKNS1_9DoubleValE', '', '', 'vec', ''],
    [['negative'], 'DECIMALV2', ['DECIMALV2'],
            '_ZN5doris13MathFunctions16negative_decimalEPN9doris_udf'
            '15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['negative'], 'DECIMAL32', ['DECIMAL32'],
            '_ZN5doris13MathFunctions16negative_decimalEPN9doris_udf'
            '15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['negative'], 'DECIMAL64', ['DECIMAL64'],
            '_ZN5doris13MathFunctions16negative_decimalEPN9doris_udf'
            '15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],
    [['negative'], 'DECIMAL128', ['DECIMAL128'],
            '_ZN5doris13MathFunctions16negative_decimalEPN9doris_udf'
            '15FunctionContextERKNS1_12DecimalV2ValE', '', '', 'vec', ''],

    [['least'], 'TINYINT', ['TINYINT', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_10TinyIntValE',
            '', '', 'vec', ''],
    [['least'], 'SMALLINT', ['SMALLINT', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_11SmallIntValE',
            '', '', 'vec', ''],
    [['least'], 'INT', ['INT', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_6IntValE',
            '', '', 'vec', ''],
    [['least'], 'BIGINT', ['BIGINT', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_9BigIntValE',
            '', '', 'vec', ''],
    [['least'], 'LARGEINT', ['LARGEINT', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_11LargeIntValE',
            '', '', 'vec', ''],
    [['least'], 'FLOAT', ['FLOAT', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_8FloatValE',
            '', '', 'vec', ''],
    [['least'], 'DOUBLE', ['DOUBLE', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_9DoubleValE',
            '', '', 'vec', ''],
    [['least'], 'DATETIME', ['DATETIME', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_11DateTimeValE',
            '', '', 'vec', ''],
    [['least'], 'DECIMALV2', ['DECIMALV2', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE',
            '', '', 'vec', ''],
    [['least'], 'DECIMAL32', ['DECIMAL32', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE',
            '', '', 'vec', ''],
    [['least'], 'DECIMAL64', ['DECIMAL64', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE',
            '', '', 'vec', ''],
    [['least'], 'DECIMAL128', ['DECIMAL128', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE',
            '', '', 'vec', ''],
    [['least'], 'VARCHAR', ['VARCHAR', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
            '', '', 'vec', ''],
    [['least'], 'STRING', ['STRING', '...'],
            '_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
            '', '', 'vec', ''],

    [['greatest'], 'TINYINT', ['TINYINT', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_10TinyIntValE',
            '', '', 'vec', ''],
    [['greatest'], 'SMALLINT', ['SMALLINT', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_11SmallIntValE',
            '', '', 'vec', ''],
    [['greatest'], 'INT', ['INT', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_6IntValE',
            '', '', 'vec', ''],
    [['greatest'], 'BIGINT', ['BIGINT', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_9BigIntValE',
            '', '', 'vec', ''],
    [['greatest'], 'LARGEINT', ['LARGEINT', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_11LargeIntValE',
            '', '', 'vec', ''],
    [['greatest'], 'FLOAT', ['FLOAT', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_8FloatValE',
            '', '', 'vec', ''],
    [['greatest'], 'DOUBLE', ['DOUBLE', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_9DoubleValE',
            '', '', 'vec', ''],
    [['greatest'], 'DECIMALV2', ['DECIMALV2', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE',
            '', '', 'vec', ''],
    [['greatest'], 'DECIMAL32', ['DECIMAL32', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE',
            '', '', 'vec', ''],
    [['greatest'], 'DECIMAL64', ['DECIMAL64', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE',
            '', '', 'vec', ''],
    [['greatest'], 'DECIMAL128', ['DECIMAL128', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE',
            '', '', 'vec', ''],
    [['greatest'], 'DATETIME', ['DATETIME', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_11DateTimeValE',
            '', '', 'vec', ''],
    [['greatest'], 'DATETIMEV2', ['DATETIMEV2', '...'],
             '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_11DateTimeValE',
             '', '', 'vec', ''],
    [['greatest'], 'VARCHAR', ['VARCHAR', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
            '', '', 'vec', ''],
    [['greatest'], 'STRING', ['STRING', '...'],
            '_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
            '', '', 'vec', ''],

    # Conditional Functions
    # Some of these have empty symbols because the BE special-cases them based on the
    # function name
    [['if'], 'BOOLEAN', ['BOOLEAN', 'BOOLEAN', 'BOOLEAN'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'TINYINT', ['BOOLEAN', 'TINYINT', 'TINYINT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'SMALLINT', ['BOOLEAN', 'SMALLINT', 'SMALLINT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'INT', ['BOOLEAN', 'INT', 'INT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'BIGINT', ['BOOLEAN', 'BIGINT', 'BIGINT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'LARGEINT', ['BOOLEAN', 'LARGEINT', 'LARGEINT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'FLOAT', ['BOOLEAN', 'FLOAT', 'FLOAT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'DOUBLE', ['BOOLEAN', 'DOUBLE', 'DOUBLE'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'DATETIME', ['BOOLEAN', 'DATETIME', 'DATETIME'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'DATE', ['BOOLEAN', 'DATE', 'DATE'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'DATETIMEV2', ['BOOLEAN', 'DATETIMEV2', 'DATETIMEV2'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'DATEV2', ['BOOLEAN', 'DATEV2', 'DATEV2'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'DECIMALV2', ['BOOLEAN', 'DECIMALV2', 'DECIMALV2'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'DECIMAL32', ['BOOLEAN', 'DECIMAL32', 'DECIMAL32'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'DECIMAL64', ['BOOLEAN', 'DECIMAL64', 'DECIMAL64'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'DECIMAL128', ['BOOLEAN', 'DECIMAL128', 'DECIMAL128'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'BITMAP', ['BOOLEAN', 'BITMAP', 'BITMAP'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'HLL', ['BOOLEAN', 'HLL', 'HLL'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'JSONB', ['BOOLEAN', 'JSONB', 'JSONB'], '', '', '', 'vec', 'CUSTOM'],
    # The priority of varchar should be lower than decimal in IS_SUPERTYPE_OF mode.
    [['if'], 'VARCHAR', ['BOOLEAN', 'VARCHAR', 'VARCHAR'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'STRING', ['BOOLEAN', 'STRING', 'STRING'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_BOOLEAN', ['BOOLEAN', 'ARRAY_BOOLEAN', 'ARRAY_BOOLEAN'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_TINYINT', ['BOOLEAN', 'ARRAY_TINYINT', 'ARRAY_TINYINT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_SMALLINT', ['BOOLEAN', 'ARRAY_SMALLINT', 'ARRAY_SMALLINT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_INT', ['BOOLEAN', 'ARRAY_INT', 'ARRAY_INT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_BIGINT', ['BOOLEAN', 'ARRAY_BIGINT', 'ARRAY_BIGINT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_LARGEINT', ['BOOLEAN', 'ARRAY_LARGEINT', 'ARRAY_LARGEINT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_FLOAT', ['BOOLEAN', 'ARRAY_FLOAT', 'ARRAY_FLOAT'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_DOUBLE', ['BOOLEAN', 'ARRAY_DOUBLE', 'ARRAY_DOUBLE'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_DATETIME', ['BOOLEAN', 'ARRAY_DATETIME', 'ARRAY_DATETIME'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_DATE', ['BOOLEAN', 'ARRAY_DATE', 'ARRAY_DATE'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_DATETIMEV2', ['BOOLEAN', 'ARRAY_DATETIMEV2', 'ARRAY_DATETIMEV2'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_DATEV2', ['BOOLEAN', 'ARRAY_DATEV2', 'ARRAY_DATEV2'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_DECIMALV2', ['BOOLEAN', 'ARRAY_DECIMALV2', 'ARRAY_DECIMALV2'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_VARCHAR', ['BOOLEAN', 'ARRAY_VARCHAR', 'ARRAY_VARCHAR'], '', '', '', 'vec', 'CUSTOM'],
    [['if'], 'ARRAY_STRING', ['BOOLEAN', 'ARRAY_STRING', 'ARRAY_STRING'], '', '', '', 'vec', 'CUSTOM'],

    [['nullif'], 'BOOLEAN', ['BOOLEAN', 'BOOLEAN'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'TINYINT', ['TINYINT', 'TINYINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'SMALLINT', ['SMALLINT', 'SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'INT', ['INT', 'INT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'BIGINT', ['BIGINT', 'BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'LARGEINT', ['LARGEINT', 'LARGEINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'FLOAT', ['FLOAT', 'FLOAT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'DOUBLE', ['DOUBLE', 'DOUBLE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'DATETIME', ['DATETIME', 'DATETIME'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'DATE', ['DATE', 'DATE'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'DATEV2', ['DATEV2', 'DATEV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'DECIMALV2', ['DECIMALV2', 'DECIMALV2'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'DECIMAL32', ['DECIMAL32', 'DECIMAL32'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'DECIMAL64', ['DECIMAL64', 'DECIMAL64'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'DECIMAL128', ['DECIMAL128', 'DECIMAL128'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    # The priority of varchar should be lower than decimal in IS_SUPERTYPE_OF mode.
    [['nullif'], 'VARCHAR', ['VARCHAR', 'VARCHAR'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['nullif'], 'STRING', ['STRING', 'STRING'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['ifnull', 'nvl'], 'BOOLEAN', ['BOOLEAN', 'BOOLEAN'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'TINYINT', ['TINYINT', 'TINYINT'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'SMALLINT', ['SMALLINT', 'SMALLINT'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'INT', ['INT', 'INT'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'BIGINT', ['BIGINT', 'BIGINT'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'LARGEINT', ['LARGEINT', 'LARGEINT'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'FLOAT', ['FLOAT', 'FLOAT'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DOUBLE', ['DOUBLE', 'DOUBLE'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DATE', ['DATE', 'DATE'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DATETIME', ['DATETIME', 'DATETIME'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DATETIME', ['DATE', 'DATETIME'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DATETIME', ['DATETIME', 'DATE'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DATEV2', ['DATEV2', 'DATEV2'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DATETIMEV2', ['DATETIMEV2', 'DATETIMEV2'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DECIMALV2', ['DECIMALV2', 'DECIMALV2'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DECIMAL32', ['DECIMAL32', 'DECIMAL32'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DECIMAL64', ['DECIMAL64', 'DECIMAL64'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'DECIMAL128', ['DECIMAL128', 'DECIMAL128'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'BITMAP', ['BITMAP', 'BITMAP'], '', '', '', 'vec', 'CUSTOM'],
    # The priority of varchar should be lower than decimal in IS_SUPERTYPE_OF mode.
    [['ifnull', 'nvl'], 'VARCHAR', ['VARCHAR', 'VARCHAR'], '', '', '', 'vec', 'CUSTOM'],
    [['ifnull', 'nvl'], 'STRING', ['STRING', 'STRING'], '', '', '', 'vec', 'CUSTOM'],

    [['coalesce'], 'BOOLEAN', ['BOOLEAN', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'TINYINT', ['TINYINT', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'SMALLINT', ['SMALLINT', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'INT', ['INT', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'BIGINT', ['BIGINT', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'LARGEINT', ['LARGEINT', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'FLOAT', ['FLOAT', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'DOUBLE', ['DOUBLE', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'DATETIME', ['DATETIME', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'DATE', ['DATE', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'DATETIMEV2', ['DATETIMEV2', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'DATEV2', ['DATEV2', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'DECIMALV2', ['DECIMALV2', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'DECIMAL32', ['DECIMAL32', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'DECIMAL64', ['DECIMAL64', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'DECIMAL128', ['DECIMAL128', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'BITMAP', ['BITMAP', '...'], '', '', '', 'vec', 'CUSTOM'],
    # The priority of varchar should be lower than decimal in IS_SUPERTYPE_OF mode.
    [['coalesce'], 'VARCHAR', ['VARCHAR', '...'], '', '', '', 'vec', 'CUSTOM'],
    [['coalesce'], 'STRING', ['STRING', '...'], '', '', '', 'vec', 'CUSTOM'],

    # esquery's first arg is suitable for all types
    [['esquery'], 'BOOLEAN', ['BOOLEAN', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['TINYINT', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['SMALLINT', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['INT', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['BIGINT', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['LARGEINT', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['FLOAT', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['DOUBLE', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['DATE', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['DATETIME', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['CHAR', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['VARCHAR', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['JSONB', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['DECIMALV2', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['DECIMAL32', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['DECIMAL64', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['DECIMAL128', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['TIME', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['DATEV2', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['DATETIMEV2', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['TIMEV2', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['ARRAY', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['MAP', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['esquery'], 'BOOLEAN', ['STRING', 'VARCHAR'],
     '_ZN5doris11ESFunctions5matchEPN'
     '9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],

    # String builtin functions
    [['substr', 'substring'], 'VARCHAR', ['VARCHAR', 'INT'],
        '_ZN5doris15StringFunctions9substringEPN'
        '9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['substr', 'substring'], 'VARCHAR', ['VARCHAR', 'INT', 'INT'],
        '_ZN5doris15StringFunctions9substringEPN'
        '9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES9_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['mask'], 'STRING', ['STRING', '...'], '', '', '', 'vec', ''],
    [['mask_first_n'], 'STRING', ['STRING'], '', '', '', 'vec', ''],
    [['mask_first_n'], 'STRING', ['STRING', 'INT'], '', '', '', 'vec', ''],
    [['mask_last_n'], 'STRING', ['STRING'], '', '', '', 'vec', ''],
    [['mask_last_n'], 'STRING', ['STRING', 'INT'], '', '', '', 'vec', ''],
    [['strleft', 'left'], 'VARCHAR', ['VARCHAR', 'INT'],
        '_ZN5doris15StringFunctions4leftEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValERKNS1_6IntValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['strright', 'right'], 'VARCHAR', ['VARCHAR', 'INT'],
        '_ZN5doris15StringFunctions5rightEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValERKNS1_6IntValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['ends_with'], 'BOOLEAN', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris15StringFunctions9ends_withEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['starts_with'], 'BOOLEAN', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris15StringFunctions11starts_withEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['null_or_empty'], 'BOOLEAN', ['VARCHAR'],
        '_ZN5doris15StringFunctions13null_or_emptyEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['not_null_or_empty'], 'BOOLEAN', ['VARCHAR'],
     '_ZN5doris15StringFunctions17not_null_or_emptyEPN9doris_udf15FunctionContextERKNS1_9StringValE',
     '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['space'], 'VARCHAR', ['INT'],
        '_ZN5doris15StringFunctions5spaceEPN9doris_udf15FunctionContextERKNS1_6IntValE', '', '', 'vec', ''],
    [['repeat'], 'VARCHAR', ['VARCHAR', 'INT'],
        '_ZN5doris15StringFunctions6repeatEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValERKNS1_6IntValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['lpad'], 'VARCHAR', ['VARCHAR', 'INT', 'VARCHAR'],
            '_ZN5doris15StringFunctions4lpadEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValERKNS1_6IntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['rpad'], 'VARCHAR', ['VARCHAR', 'INT', 'VARCHAR'],
            '_ZN5doris15StringFunctions4rpadEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValERKNS1_6IntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['append_trailing_char_if_absent'], 'VARCHAR', ['VARCHAR', 'VARCHAR'],
            '_ZN5doris15StringFunctions30append_trailing_char_if_absentEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['length'], 'INT', ['VARCHAR'],
            '_ZN5doris15StringFunctions6lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE',
            '', '', 'vec', ''],
    [['bit_length'], 'INT', ['VARCHAR'],
            '_ZN5doris15StringFunctions10bit_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE','', '', 'vec', ''],

    [['char_length', 'character_length'], 'INT', ['VARCHAR'],
            '_ZN5doris15StringFunctions16char_utf8_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE',
            '', '', 'vec', ''],
    [['lower', 'lcase'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris15StringFunctions5lowerEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['upper', 'ucase'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris15StringFunctions5upperEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['initcap'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris15StringFunctions7initcapEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['trim'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris15StringFunctions4trimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['trim'], 'VARCHAR', ['VARCHAR','VARCHAR'],
            '_ZN5doris15StringFunctions4trimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['ltrim'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris15StringFunctions5ltrimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['ltrim'], 'VARCHAR', ['VARCHAR','VARCHAR'],
            '_ZN5doris15StringFunctions5ltrimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['rtrim'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris15StringFunctions5rtrimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['rtrim'], 'VARCHAR', ['VARCHAR','VARCHAR'],
            '_ZN5doris15StringFunctions5rtrimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['ascii'], 'INT', ['VARCHAR'],
            '_ZN5doris15StringFunctions5asciiEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['instr'], 'INT', ['VARCHAR', 'VARCHAR'],
            '_ZN5doris15StringFunctions5instrEPN9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['locate'], 'INT', ['VARCHAR', 'VARCHAR'],
            '_ZN5doris15StringFunctions6locateEPN9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['locate'], 'INT', ['VARCHAR', 'VARCHAR', 'INT'],
            '_ZN5doris15StringFunctions10locate_posEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE', '', '', 'vec', ''],
    [['regexp_extract'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'BIGINT'],
            '_ZN5doris15StringFunctions14regexp_extractEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_RKNS1_9BigIntValE',
            '_ZN5doris15StringFunctions14regexp_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris15StringFunctions12regexp_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['regexp_replace'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'VARCHAR'],
            '_ZN5doris15StringFunctions14regexp_replaceEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_S6_',
            '_ZN5doris15StringFunctions14regexp_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris15StringFunctions12regexp_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['regexp_replace_one'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'VARCHAR'],
     '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['regexp_extract_all'], 'VARCHAR', ['VARCHAR', 'VARCHAR'],
     '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['concat'], 'VARCHAR', ['VARCHAR', '...'],
            '_ZN5doris15StringFunctions6concatEPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
            '', '', 'vec', ''],
    [['elt'], 'VARCHAR', ['INT', 'VARCHAR', '...'],
            '_ZN5doris15StringFunctions3eltEPN9doris_udf15FunctionContextERKNS1_6IntValEiPKNS1_9StringValE',
            '', '', 'vec', ''],
    [['elt'], 'STRING', ['INT', 'STRING', '...'],
            '_ZN5doris15StringFunctions3eltEPN9doris_udf15FunctionContextERKNS1_6IntValEiPKNS1_9StringValE',
            '', '', 'vec', ''],
    [['replace'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'VARCHAR'],
            '_ZN5doris15StringFunctions7replaceEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_',
            '', '', 'vec', ''],
    [['concat_ws'], 'VARCHAR', ['VARCHAR', 'VARCHAR', '...'],
            '_ZN5doris15StringFunctions9concat_wsEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValEiPS5_', '', '', 'vec', 'CUSTOM'],
    [['concat_ws'], 'VARCHAR', ['VARCHAR', 'ARRAY_VARCHAR'],
            '_ZN5doris15StringFunctions9concat_wsEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValEiPS5_', '', '', 'vec', 'CUSTOM'],
    [['find_in_set'], 'INT', ['VARCHAR', 'VARCHAR'],
            '_ZN5doris15StringFunctions11find_in_setEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['parse_url'], 'VARCHAR', ['VARCHAR', 'VARCHAR'],
            '_ZN5doris15StringFunctions9parse_urlEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_',
            '_ZN5doris15StringFunctions17parse_url_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris15StringFunctions15parse_url_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['parse_url'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'VARCHAR'],
            '_ZN5doris15StringFunctions13parse_url_keyEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_S6_',
            '_ZN5doris15StringFunctions17parse_url_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris15StringFunctions15parse_url_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['money_format'], 'VARCHAR', ['BIGINT'],
        '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_9BigIntValE',
        '', '', 'vec', ''],
    [['money_format'], 'VARCHAR', ['LARGEINT'],
        '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_11LargeIntValE',
        '', '', 'vec', ''],
    [['money_format'], 'VARCHAR', ['DOUBLE'],
        '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_9DoubleValE',
        '', '', 'vec', ''],
    [['money_format'], 'VARCHAR', ['DECIMALV2'],
        '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE',
        '', '', 'vec', ''],
    [['money_format'], 'VARCHAR', ['DECIMAL32'],
     '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE',
     '', '', 'vec', ''],
    [['money_format'], 'VARCHAR', ['DECIMAL64'],
     '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE',
     '', '', 'vec', ''],
    [['money_format'], 'VARCHAR', ['DECIMAL128'],
     '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE',
     '', '', 'vec', ''],
    [['split_by_string'],'ARRAY_VARCHAR',['STRING','STRING'],
        '', '', '', 'vec', ''],
    [['split_part'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'INT'],
        '_ZN5doris15StringFunctions10split_partEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['substring_index'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'INT'],
        '_ZN5doris15StringFunctions15substring_indexEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['extract_url_parameter'], 'VARCHAR', ['VARCHAR', 'VARCHAR'],'','', '', 'vec', ''],

    [['sub_replace'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'INT'],'','', '', 'vec', 'ALWAYS_NULLABLE'],
    [['sub_replace'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'INT', 'INT'],'','', '', 'vec', 'ALWAYS_NULLABLE'],

    # width_bucket
    [['width_bucket'], 'BIGINT', ['TINYINT','TINYINT','TINYINT','TINYINT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['SMALLINT','SMALLINT','SMALLINT','SMALLINT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['INT','INT','INT','INT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['BIGINT','BIGINT','BIGINT','BIGINT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['FLOAT','FLOAT','FLOAT','BIGINT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['DOUBLE','DOUBLE','DOUBLE','BIGINT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['DECIMALV2','DECIMALV2','DECIMALV2','BIGINT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['DATE','DATE','DATE','BIGINT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['DATEV2','DATEV2','DATEV2','BIGINT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['DATETIME','DATETIME','DATETIME','BIGINT'], '', '', '', 'vec', ''],
    [['width_bucket'], 'BIGINT', ['DATETIMEV2','DATETIMEV2','DATETIMEV2','BIGINT'], '', '', '', 'vec', ''],

    # runningdifference
    [['running_difference'], 'SMALLINT', ['TINYINT'], '', '', '', 'vec', ''],
    [['running_difference'], 'INT', ['SMALLINT'], '', '', '', 'vec', ''],
    [['running_difference'], 'BIGINT', ['INT'], '', '', '', 'vec', ''],
    [['running_difference'], 'LARGEINT', ['BIGINT'], '', '', '', 'vec', ''],
    [['running_difference'], 'LARGEINT', ['LARGEINT'], '', '', '', 'vec', ''],
    [['running_difference'], 'DOUBLE', ['FLOAT'], '', '', '', 'vec', ''],
    [['running_difference'], 'DOUBLE', ['DOUBLE'], '', '', '', 'vec', ''],
    [['running_difference'], 'DECIMALV2', ['DECIMALV2'], '', '', '', 'vec', ''],
    [['running_difference'], 'DECIMAL32', ['DECIMAL32'], '', '', '', 'vec', ''],
    [['running_difference'], 'DECIMAL64', ['DECIMAL64'], '', '', '', 'vec', ''],
    [['running_difference'], 'DECIMAL128', ['DECIMAL128'], '', '', '', 'vec', ''],
    [['running_difference'], 'INT', ['DATE'], '', '', '', 'vec', ''],
    [['running_difference'], 'INT', ['DATEV2'], '', '', '', 'vec', ''],
    [['running_difference'], 'TIME', ['DATETIME'], '', '', '', 'vec', ''],
    [['running_difference'], 'TIMEV2', ['DATETIMEV2'], '', '', '', 'vec', ''],

    # Longtext function
    [['substr', 'substring'], 'STRING', ['STRING', 'INT'],
        '_ZN5doris15StringFunctions9substringEPN'
        '9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['substr', 'substring'], 'STRING', ['STRING', 'INT', 'INT'],
        '_ZN5doris15StringFunctions9substringEPN'
        '9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES9_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['strleft', 'left'], 'STRING', ['STRING', 'INT'],
        '_ZN5doris15StringFunctions4leftEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValERKNS1_6IntValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['strright', 'right'], 'STRING', ['STRING', 'INT'],
        '_ZN5doris15StringFunctions5rightEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValERKNS1_6IntValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['ends_with'], 'BOOLEAN', ['STRING', 'STRING'],
        '_ZN5doris15StringFunctions9ends_withEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['starts_with'], 'BOOLEAN', ['STRING', 'STRING'],
        '_ZN5doris15StringFunctions11starts_withEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['null_or_empty'], 'BOOLEAN', ['STRING'],
        '_ZN5doris15StringFunctions13null_or_emptyEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['not_null_or_empty'], 'BOOLEAN', ['STRING'],
     '_ZN5doris15StringFunctions17not_null_or_emptyEPN9doris_udf15FunctionContextERKNS1_9StringValE',
     '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['space'], 'STRING', ['INT'],
        '_ZN5doris15StringFunctions5spaceEPN9doris_udf15FunctionContextERKNS1_6IntValE', '', '', 'vec', ''],
    [['repeat'], 'STRING', ['STRING', 'INT'],
        '_ZN5doris15StringFunctions6repeatEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValERKNS1_6IntValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['lpad'], 'STRING', ['STRING', 'INT', 'STRING'],
            '_ZN5doris15StringFunctions4lpadEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValERKNS1_6IntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['rpad'], 'STRING', ['STRING', 'INT', 'STRING'],
            '_ZN5doris15StringFunctions4rpadEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValERKNS1_6IntValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['append_trailing_char_if_absent'], 'STRING', ['STRING', 'STRING'],
            '_ZN5doris15StringFunctions30append_trailing_char_if_absentEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
            '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['length'], 'INT', ['STRING'],
            '_ZN5doris15StringFunctions6lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE',
            '', '', 'vec', ''],
    [['bit_length'], 'INT', ['STRING'],
            '_ZN5doris15StringFunctions10bit_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE','', '', 'vec', ''],

    [['char_length', 'character_length'], 'INT', ['STRING'],
            '_ZN5doris15StringFunctions16char_utf8_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE',
            '', '', 'vec', ''],
    [['lower', 'lcase'], 'STRING', ['STRING'],
            '_ZN5doris15StringFunctions5lowerEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['upper', 'ucase'], 'STRING', ['STRING'],
            '_ZN5doris15StringFunctions5upperEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['trim'], 'STRING', ['STRING'],
            '_ZN5doris15StringFunctions4trimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['trim'], 'STRING', ['STRING','STRING'],
        '_ZN5doris15StringFunctions4trimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['ltrim'], 'STRING', ['STRING'],
            '_ZN5doris15StringFunctions5ltrimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['ltrim'], 'STRING', ['STRING','STRING'],
            '_ZN5doris15StringFunctions5ltrimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['rtrim'], 'STRING', ['STRING'],
            '_ZN5doris15StringFunctions5rtrimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['rtrim'], 'STRING', ['STRING','STRING'],
            '_ZN5doris15StringFunctions5rtrimEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['ascii'], 'INT', ['STRING'],
            '_ZN5doris15StringFunctions5asciiEPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['instr'], 'INT', ['STRING', 'STRING'],
            '_ZN5doris15StringFunctions5instrEPN9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['locate'], 'INT', ['STRING', 'STRING'],
            '_ZN5doris15StringFunctions6locateEPN9doris_udf15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['locate'], 'INT', ['STRING', 'STRING', 'INT'],
            '_ZN5doris15StringFunctions10locate_posEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE', '', '', 'vec', ''],
    [['regexp_extract'], 'STRING', ['STRING', 'STRING', 'BIGINT'],
            '_ZN5doris15StringFunctions14regexp_extractEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_RKNS1_9BigIntValE',
            '_ZN5doris15StringFunctions14regexp_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris15StringFunctions12regexp_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['regexp_replace'], 'STRING', ['STRING', 'STRING', 'STRING'],
            '_ZN5doris15StringFunctions14regexp_replaceEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_S6_',
            '_ZN5doris15StringFunctions14regexp_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris15StringFunctions12regexp_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['regexp_replace_one'], 'STRING', ['STRING', 'STRING', 'STRING'],
     '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['regexp_extract_all'], 'STRING', ['STRING', 'STRING'],
     '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['concat'], 'STRING', ['STRING', '...'],
            '_ZN5doris15StringFunctions6concatEPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
            '', '', 'vec', ''],
    [['replace'], 'STRING', ['STRING', 'STRING', 'STRING'],
            '_ZN5doris15StringFunctions7replaceEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_',
            '', '', 'vec', ''],
    [['concat_ws'], 'STRING', ['STRING', 'STRING', '...'],
            '_ZN5doris15StringFunctions9concat_wsEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValEiPS5_', '', '', 'vec', 'CUSTOM'],
    [['find_in_set'], 'INT', ['STRING', 'STRING'],
            '_ZN5doris15StringFunctions11find_in_setEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', ''],
    [['parse_url'], 'STRING', ['STRING', 'STRING'],
            '_ZN5doris15StringFunctions9parse_urlEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_',
            '_ZN5doris15StringFunctions17parse_url_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris15StringFunctions15parse_url_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['parse_url'], 'STRING', ['STRING', 'STRING', 'STRING'],
            '_ZN5doris15StringFunctions13parse_url_keyEPN9doris_udf'
            '15FunctionContextERKNS1_9StringValES6_S6_',
            '_ZN5doris15StringFunctions17parse_url_prepareEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE',
            '_ZN5doris15StringFunctions15parse_url_closeEPN9doris_udf'
            '15FunctionContextENS2_18FunctionStateScopeE', 'vec', 'ALWAYS_NULLABLE'],
    [['money_format'], 'STRING', ['BIGINT'],
        '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_9BigIntValE',
        '', '', 'vec', ''],
    [['money_format'], 'STRING', ['LARGEINT'],
        '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_11LargeIntValE',
        '', '', 'vec', ''],
    [['money_format'], 'STRING', ['DOUBLE'],
        '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_9DoubleValE',
        '', '', 'vec', ''],
    [['money_format'], 'STRING', ['DECIMALV2'],
        '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE',
        '', '', 'vec', ''],
    [['money_format'], 'STRING', ['DECIMAL32'],
     '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE',
     '', '', 'vec', ''],
    [['money_format'], 'STRING', ['DECIMAL64'],
     '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE',
     '', '', 'vec', ''],
    [['money_format'], 'STRING', ['DECIMAL128'],
     '_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE',
     '', '', 'vec', ''],
    [['split_part'], 'STRING', ['STRING', 'STRING', 'INT'],
        '_ZN5doris15StringFunctions10split_partEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['substring_index'], 'STRING', ['STRING', 'STRING', 'INT'],
        '_ZN5doris15StringFunctions15substring_indexEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],

    # Utility functions
    [['convert_to'], 'VARCHAR', ['VARCHAR','VARCHAR'], '','', '', 'vec', ''],
    [['sleep'], 'BOOLEAN', ['INT'],
        '_ZN5doris16UtilityFunctions5sleepEPN9doris_udf15FunctionContextERKNS1_6IntValE',
        '', '', 'vec', ''],
    [['version'], 'VARCHAR', [],
        '_ZN5doris16UtilityFunctions7versionEPN9doris_udf15FunctionContextE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['field'], 'INT', ['TINYINT', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['SMALLINT', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['INT', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['BIGINT', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['LARGEINT', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['FLOAT', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['DOUBLE', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['DECIMALV2', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['DATEV2', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['DATETIMEV2', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['VARCHAR', '...'], '','', '', 'vec', ''],
    [['field'], 'INT', ['STRING', '...'], '','', '', 'vec', ''],

    # Jsonb functions
    [['jsonb_parse'], 'JSONB', ['VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],
    [['jsonb_parse_error_to_null'], 'JSONB', ['VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_parse_error_to_value'], 'JSONB', ['VARCHAR', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],
    [['jsonb_parse_error_to_invalid'], 'JSONB', ['VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],
    [['jsonb_parse_nullable'], 'JSONB', ['VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_parse_nullable_error_to_null'], 'JSONB', ['VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_parse_nullable_error_to_value'], 'JSONB', ['VARCHAR', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_parse_nullable_error_to_invalid'], 'JSONB', ['VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_parse_notnull'], 'JSONB', ['VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],
    [['jsonb_parse_notnull_error_to_value'], 'JSONB', ['VARCHAR', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],
    [['jsonb_parse_notnull_error_to_invalid'], 'JSONB', ['VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],

    [['jsonb_exists_path'], 'BOOLEAN', ['JSONB', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],
    [['jsonb_exists_path'], 'BOOLEAN', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],
    [['jsonb_type'], 'STRING', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_type'], 'STRING', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],

    [['jsonb_extract'], 'JSONB', ['JSONB', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract'], 'JSONB', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_isnull'], 'BOOLEAN', ['JSONB', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_isnull'], 'BOOLEAN', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_bool'], 'BOOLEAN', ['JSONB', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_bool'], 'BOOLEAN', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_int'], 'INT', ['JSONB', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_int'], 'INT', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_bigint'], 'BIGINT', ['JSONB', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_bigint'], 'BIGINT', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_double'], 'DOUBLE', ['JSONB', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_double'], 'DOUBLE', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_string'], 'STRING', ['JSONB', 'VARCHAR'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],
    [['jsonb_extract_string'], 'STRING', ['JSONB', 'STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', 'ALWAYS_NULLABLE'],

    # Json functions
    [['get_json_int'], 'INT', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris13JsonFunctions12get_json_intEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],
    [['get_json_double'], 'DOUBLE', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris13JsonFunctions15get_json_doubleEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],
    [['get_json_string'], 'VARCHAR', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris13JsonFunctions15get_json_stringEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
     'vec', 'ALWAYS_NULLABLE'],
    [['get_json_int'], 'INT', ['STRING', 'STRING'],
        '_ZN5doris13JsonFunctions12get_json_intEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],
    [['get_json_double'], 'DOUBLE', ['STRING', 'STRING'],
        '_ZN5doris13JsonFunctions15get_json_doubleEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],
    [['get_json_string'], 'STRING', ['STRING', 'STRING'],
        '_ZN5doris13JsonFunctions15get_json_stringEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],

    [['json_array'], 'VARCHAR', ['VARCHAR', '...'],
            '_ZN5doris13JsonFunctions10json_arrayEPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
            '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['json_object'], 'VARCHAR', ['VARCHAR', '...'],
            '_ZN5doris13JsonFunctions11json_objectEPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
            '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['json_quote'], 'VARCHAR', ['VARCHAR'],
            '_ZN5doris13JsonFunctions10json_quoteEPN9doris_udf15FunctionContextERKNS1_9StringValE',
            '', '', 'vec', ''],

    #hll function
    [['hll_cardinality'], 'BIGINT', ['HLL'],
        '_ZN5doris12HllFunctions15hll_cardinalityEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['hll_hash'], 'HLL', ['VARCHAR'],
        '_ZN5doris12HllFunctions8hll_hashEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['hll_empty'], 'HLL', [],
        '_ZN5doris12HllFunctions9hll_emptyEPN9doris_udf15FunctionContextE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['hll_hash'], 'HLL', ['STRING'],
        '_ZN5doris12HllFunctions8hll_hashEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],

    #bitmap function

    [['to_bitmap'], 'BITMAP', ['VARCHAR'],
        '_ZN5doris15BitmapFunctions9to_bitmapEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['to_bitmap_with_check'], 'BITMAP', ['VARCHAR'],
        '_ZN5doris15BitmapFunctions20to_bitmap_with_checkEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['to_bitmap'], 'BITMAP', ['STRING'],
        '_ZN5doris15BitmapFunctions9to_bitmapEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['to_bitmap_with_check'], 'BITMAP', ['STRING'],
        '_ZN5doris15BitmapFunctions20to_bitmap_with_checkEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['to_bitmap'], 'BITMAP', ['BIGINT'],
        '_ZN5doris15BitmapFunctions9to_bitmapEPN9doris_udf15FunctionContextERKNS1_9BigIntValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['to_bitmap_with_check'], 'BITMAP', ['BIGINT'],
        '_ZN5doris15BitmapFunctions20to_bitmap_with_checkEPN9doris_udf15FunctionContextERKNS1_9BigIntValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['bitmap_hash'], 'BITMAP', ['VARCHAR'],
        '_ZN5doris15BitmapFunctions11bitmap_hashEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['bitmap_hash64'], 'BITMAP', ['VARCHAR'],
        '_ZN5doris15BitmapFunctions11bitmap_hash64EPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['bitmap_hash'], 'BITMAP', ['STRING'],
        '_ZN5doris15BitmapFunctions11bitmap_hash64EPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['bitmap_hash64'], 'BITMAP', ['STRING'],
        '_ZN5doris15BitmapFunctions11bitmap_hashEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['bitmap_count'], 'BIGINT', ['BITMAP'],
        '_ZN5doris15BitmapFunctions12bitmap_countEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['bitmap_and_not_count'], 'BIGINT', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions20bitmap_and_not_countEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_empty'], 'BITMAP', [],
        '_ZN5doris15BitmapFunctions12bitmap_emptyEPN9doris_udf15FunctionContextE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['bitmap_or'], 'BITMAP', ['BITMAP','BITMAP','...'],
        '_ZN5doris15BitmapFunctions9bitmap_orEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_',
        '', '', 'vec', ''],
    [['bitmap_or'], 'BITMAP', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions9bitmap_orEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_xor'], 'BITMAP', ['BITMAP','BITMAP','...'],
        '_ZN5doris15BitmapFunctions10bitmap_xorEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_',
        '', '', 'vec', ''],
    [['bitmap_xor'], 'BITMAP', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions10bitmap_xorEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_xor_count'], 'BIGINT', ['BITMAP','BITMAP','...'],
        '_ZN5doris15BitmapFunctions16bitmap_xor_countEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_',
        '', '', 'vec', ''],
    [['bitmap_xor_count'], 'BIGINT', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions16bitmap_xor_countEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_not'], 'BITMAP', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions10bitmap_notEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_and'], 'BITMAP', ['BITMAP','BITMAP','...'],
        '_ZN5doris15BitmapFunctions10bitmap_andEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_',
        '', '', 'vec', ''],
    [['bitmap_and'], 'BITMAP', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions10bitmap_andEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_and_not'], 'BITMAP', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions14bitmap_and_notEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_to_string'], 'STRING', ['BITMAP'],
        '_ZN5doris15BitmapFunctions16bitmap_to_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', ''],
    [['bitmap_from_string'], 'BITMAP', ['VARCHAR'],
        '_ZN5doris15BitmapFunctions18bitmap_from_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_from_string'], 'BITMAP', ['STRING'],
        '_ZN5doris15BitmapFunctions18bitmap_from_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_from_array'], 'BITMAP', ['ARRAY_TINYINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_from_array'], 'BITMAP', ['ARRAY_SMALLINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_from_array'], 'BITMAP', ['ARRAY_INT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_from_array'], 'BITMAP', ['ARRAY_BIGINT'], '', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_contains'], 'BOOLEAN', ['BITMAP','BIGINT'],
        '_ZN5doris15BitmapFunctions15bitmap_containsEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_9BigIntValE',
        '', '', 'vec', ''],
    [['bitmap_has_any'], 'BOOLEAN', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions14bitmap_has_anyEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_has_all'], 'BOOLEAN', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions14bitmap_has_allEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_min'], 'BIGINT', ['BITMAP'],
        '_ZN5doris15BitmapFunctions10bitmap_minEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_max'], 'BIGINT', ['BITMAP'],
        '_ZN5doris15BitmapFunctions10bitmap_maxEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_subset_in_range'], 'BITMAP', ['BITMAP', 'BIGINT', 'BIGINT'],
        '_ZN5doris15BitmapFunctions22bitmap_subset_in_rangeEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_9BigIntValES9_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_subset_limit'], 'BITMAP', ['BITMAP', 'BIGINT', 'BIGINT'],
        '_ZN5doris15BitmapFunctions19bitmap_subset_limitEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_9BigIntValES9_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_and_count'], 'BIGINT', ['BITMAP','BITMAP','...'],
        '_ZN5doris15BitmapFunctions16bitmap_and_countEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_',
        '', '', 'vec', ''],
    [['bitmap_and_count'], 'BIGINT', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions16bitmap_and_countEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['bitmap_or_count'], 'BIGINT', ['BITMAP','BITMAP','...'],
        '_ZN5doris15BitmapFunctions15bitmap_or_countEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_',
        '', '', 'vec', ''],
    [['bitmap_or_count'], 'BIGINT', ['BITMAP','BITMAP'],
        '_ZN5doris15BitmapFunctions15bitmap_or_countEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '', '', 'vec', ''],
    [['sub_bitmap'], 'BITMAP', ['BITMAP', 'BIGINT', 'BIGINT'],
        '_ZN5doris15BitmapFunctions10sub_bitmapEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_9BigIntValES9_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['bitmap_to_array'], 'ARRAY_BIGINT', ['BITMAP'], '', '', '', 'vec', ''],
    # quantile_function
    [['to_quantile_state'], 'QUANTILE_STATE', ['VARCHAR', 'FLOAT'],
        '_ZN5doris22QuantileStateFunctions17to_quantile_stateEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '_ZN5doris22QuantileStateFunctions25to_quantile_state_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE', '', 'vec', ''],

    [['quantile_percent'], 'DOUBLE', ['QUANTILE_STATE', 'FLOAT'],
        '_ZN5doris22QuantileStateFunctions16quantile_percentEPN9doris_udf15FunctionContextERNS1_9StringValE',
        '_ZN5doris22QuantileStateFunctions24quantile_percent_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE', '', 'vec', ''],


    # hash functions
    [['murmur_hash3_32'], 'INT', ['VARCHAR', '...'],
        '_ZN5doris13HashFunctions15murmur_hash3_32EPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
        '', '', 'vec', ''],
    [['murmur_hash3_32'], 'INT', ['STRING', '...'],
        '_ZN5doris13HashFunctions15murmur_hash3_32EPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
        '', '', 'vec', ''],
    [['murmur_hash3_64'], 'BIGINT', ['VARCHAR', '...'],
        '_ZN5doris13HashFunctions15murmur_hash3_64EPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
        '', '', 'vec', ''],
    [['murmur_hash3_64'], 'BIGINT', ['STRING', '...'],
        '_ZN5doris13HashFunctions15murmur_hash3_64EPN9doris_udf15FunctionContextEiPKNS1_9StringValE',
        '', '', 'vec', ''],

    # aes and base64 function
    [['aes_encrypt'], 'VARCHAR', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris19EncryptionFunctions11aes_encryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['aes_decrypt'], 'VARCHAR', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris19EncryptionFunctions11aes_decryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['aes_encrypt'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'VARCHAR', 'VARCHAR'],
        '_ZN5doris19EncryptionFunctions11aes_encryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_S6_S6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['aes_decrypt'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'VARCHAR', 'VARCHAR'],
        '_ZN5doris19EncryptionFunctions11aes_decryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_S6_S6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['sm4_encrypt'], 'VARCHAR', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris19EncryptionFunctions11sm4_encryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['sm4_decrypt'], 'VARCHAR', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris19EncryptionFunctions11sm4_decryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['sm4_encrypt'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'VARCHAR', 'VARCHAR'],
        '_ZN5doris19EncryptionFunctions11sm4_encryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_S6_S6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['sm4_decrypt'], 'VARCHAR', ['VARCHAR', 'VARCHAR', 'VARCHAR', 'VARCHAR'],
        '_ZN5doris19EncryptionFunctions11sm4_decryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_S6_S6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['from_base64'], 'VARCHAR', ['VARCHAR'],
        '_ZN5doris19EncryptionFunctions11from_base64EPN9doris_udf'
        '15FunctionContextERKNS1_9StringValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['aes_encrypt'], 'STRING', ['STRING', 'STRING'],
        '_ZN5doris19EncryptionFunctions11aes_encryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['aes_decrypt'], 'STRING', ['STRING', 'STRING'],
        '_ZN5doris19EncryptionFunctions11aes_decryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['aes_encrypt'], 'STRING', ['STRING', 'STRING', 'STRING', 'STRING'],
        '_ZN5doris19EncryptionFunctions11aes_encryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_S6_S6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['aes_decrypt'], 'STRING', ['STRING', 'STRING', 'STRING', 'STRING'],
        '_ZN5doris19EncryptionFunctions11aes_decryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_S6_S6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['sm4_encrypt'], 'STRING', ['STRING', 'STRING'],
        '_ZN5doris19EncryptionFunctions11sm4_encryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['sm4_decrypt'], 'STRING', ['STRING', 'STRING'],
        '_ZN5doris19EncryptionFunctions11sm4_decryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['sm4_encrypt'], 'STRING', ['STRING', 'STRING', 'STRING', 'STRING'],
        '_ZN5doris19EncryptionFunctions11sm4_encryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_S6_S6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['sm4_decrypt'], 'STRING', ['STRING', 'STRING', 'STRING', 'STRING'],
        '_ZN5doris19EncryptionFunctions11sm4_decryptEPN9doris_udf'
        '15FunctionContextERKNS1_9StringValES6_S6_S6_', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['from_base64'], 'STRING', ['STRING'],
        '_ZN5doris19EncryptionFunctions11from_base64EPN9doris_udf'
        '15FunctionContextERKNS1_9StringValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['to_base64'], 'STRING', ['STRING'],
        '_ZN5doris19EncryptionFunctions9to_base64EPN9doris_udf'
        '15FunctionContextERKNS1_9StringValE', '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['to_base64'], 'VARCHAR', ['VARCHAR'],
        '_ZN5doris19EncryptionFunctions9to_base64EPN9doris_udf'
        '15FunctionContextERKNS1_9StringValE', '', '', 'vec', 'ALWAYS_NULLABLE'],

    # for compatable with MySQL
    [['md5'], 'VARCHAR', ['VARCHAR'],
        '_ZN5doris19EncryptionFunctions3md5EPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['md5sum'], 'VARCHAR', ['VARCHAR', '...'],
        '_ZN5doris19EncryptionFunctions6md5sumEPN9doris_udf15FunctionContextEiPKNS1_9StringValE', '', '', 'vec', ''],
    [['md5'], 'VARCHAR', ['STRING'],
        '_ZN5doris19EncryptionFunctions3md5EPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['md5sum'], 'VARCHAR', ['STRING', '...'],
        '_ZN5doris19EncryptionFunctions6md5sumEPN9doris_udf15FunctionContextEiPKNS1_9StringValE', '', '', 'vec', ''],

    [['sm3'], 'VARCHAR', ['VARCHAR'],
        '_ZN5doris19EncryptionFunctions3sm3EPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['sm3sum'], 'VARCHAR', ['VARCHAR', '...'],
        '_ZN5doris19EncryptionFunctions6sm3sumEPN9doris_udf15FunctionContextEiPKNS1_9StringValE', '', '', 'vec', ''],
    [['sm3'], 'VARCHAR', ['STRING'],
        '_ZN5doris19EncryptionFunctions3sm3EPN9doris_udf15FunctionContextERKNS1_9StringValE', '', '', 'vec', ''],
    [['sm3sum'], 'VARCHAR', ['STRING', '...'],
        '_ZN5doris19EncryptionFunctions6sm3sumEPN9doris_udf15FunctionContextEiPKNS1_9StringValE', '', '', 'vec', ''],

    # geo functions
    [['ST_Point'], 'VARCHAR', ['DOUBLE', 'DOUBLE'],
        '_ZN5doris12GeoFunctions8st_pointEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['ST_X'], 'DOUBLE', ['VARCHAR'],
        '_ZN5doris12GeoFunctions4st_xEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['ST_Y'], 'DOUBLE', ['VARCHAR'],
        '_ZN5doris12GeoFunctions4st_yEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['ST_X'], 'DOUBLE', ['STRING'],
        '_ZN5doris12GeoFunctions4st_xEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['ST_Y'], 'DOUBLE', ['STRING'],
        '_ZN5doris12GeoFunctions4st_yEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['ST_Distance_Sphere'], 'DOUBLE', ['DOUBLE', 'DOUBLE', 'DOUBLE', 'DOUBLE'],
        '_ZN5doris12GeoFunctions18st_distance_sphereEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_S6_S6_',
        '', '', 'vec', 'ALWAYS_NULLABLE'],

    [['ST_AsText', 'ST_AsWKT'], 'VARCHAR', ['VARCHAR'],
        '_ZN5doris12GeoFunctions9st_as_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['ST_AsText', 'ST_AsWKT'], 'VARCHAR', ['STRING'],
        '_ZN5doris12GeoFunctions9st_as_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '', '', 'vec', 'ALWAYS_NULLABLE'],
    [['ST_GeometryFromText', 'ST_GeomFromText'], 'VARCHAR', ['VARCHAR'],
        '_ZN5doris12GeoFunctions11st_from_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '_ZN5doris12GeoFunctions19st_from_wkt_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],
    [['ST_GeometryFromText', 'ST_GeomFromText'], 'VARCHAR', ['STRING'],
        '_ZN5doris12GeoFunctions11st_from_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '_ZN5doris12GeoFunctions19st_from_wkt_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],

    [['ST_LineFromText', 'ST_LineStringFromText'], 'VARCHAR', ['VARCHAR'],
        '_ZN5doris12GeoFunctions7st_lineEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '_ZN5doris12GeoFunctions15st_line_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],
    [['ST_LineFromText', 'ST_LineStringFromText'], 'VARCHAR', ['STRING'],
        '_ZN5doris12GeoFunctions7st_lineEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '_ZN5doris12GeoFunctions15st_line_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],

    [['ST_Polygon', 'ST_PolyFromText', 'ST_PolygonFromText'], 'VARCHAR', ['VARCHAR'],
        '_ZN5doris12GeoFunctions10st_polygonEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '_ZN5doris12GeoFunctions18st_polygon_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],
    [['ST_Polygon', 'ST_PolyFromText', 'ST_PolygonFromText'], 'VARCHAR', ['STRING'],
        '_ZN5doris12GeoFunctions10st_polygonEPN9doris_udf15FunctionContextERKNS1_9StringValE',
        '_ZN5doris12GeoFunctions18st_polygon_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],

    [['ST_Circle'], 'VARCHAR', ['DOUBLE', 'DOUBLE', 'DOUBLE'],
        '_ZN5doris12GeoFunctions9st_circleEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_S6_',
        '_ZN5doris12GeoFunctions17st_circle_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],

    [['ST_Contains'], 'BOOLEAN', ['VARCHAR', 'VARCHAR'],
        '_ZN5doris12GeoFunctions11st_containsEPN9doris_udf15FunctionContextERKNS1_9StringValES6_',
        '_ZN5doris12GeoFunctions19st_contains_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        '_ZN5doris12GeoFunctions17st_contains_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE',
        'vec', 'ALWAYS_NULLABLE'],
    # grouping sets functions
    [['grouping_id'], 'BIGINT', ['BIGINT'],
        '_ZN5doris21GroupingSetsFunctions11grouping_idEPN9doris_udf15FunctionContextERKNS1_9BigIntValE',
        '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['grouping'], 'BIGINT', ['BIGINT'],
        '_ZN5doris21GroupingSetsFunctions8groupingEPN9doris_udf15FunctionContextERKNS1_9BigIntValE',
        '' ,'', 'vec', 'ALWAYS_NOT_NULLABLE'],

    # url functions
    [['domain'], 'STRING', ['STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],
    [['domain_without_www'], 'STRING', ['STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],
    [['protocol'], 'STRING', ['STRING'],
        'fake_symble_for_no_vec', '', '',
        'vec', ''],

    # search functions
    [['multi_search_all_positions'], 'ARRAY_INT', ['STRING', 'ARRAY_STRING'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
    [['multi_match_any'], 'TINYINT', ['STRING', 'ARRAY_STRING'], '', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],

    [['uuid'], 'VARCHAR', [], '_ZN5doris15StringFunctions4uuidEPN9doris_udf15FunctionContextE', '', '', 'vec', 'ALWAYS_NOT_NULLABLE'],
]

# Except the following functions, other function will directly return
# null if there is null parameters.
# Functions in this set will handle null values, not just return null.
#
# This set is only used to replace 'functions with null parameters' with NullLiteral
# when applying FoldConstantsRule rules on the FE side.
# TODO(cmy): Are these functions only required to handle null values?
non_null_result_with_null_param_functions = [
    'if',
    'hll_hash',
    'concat_ws',
    'ifnull',
    'nvl',
    'nullif',
    'null_or_empty',
    'not_null_or_empty'
    'coalesce',
    'array',
    'json_array',
    'json_object'
]

# Nondeterministic functions may return different results each time they are called
nondeterministic_functions = [
    'rand',
    'now',
    'current_timestamp',
    'localtime',
    'localtimestamp',
    'curdate',
    'current_date',
    'curtime',
    'current_time',
    'utc_timestamp',
    'uuid'
]
# This is the subset of ALWAYS_NULLABLE
# The function belongs to @null_result_with_one_null_param_functions,
# as long as one parameter is null, the function must return null.
null_result_with_one_null_param_functions = [
    'unix_timestamp',
    'str_to_date',
    'convert_tz',
    'pi',
    'e',
    'divide',
    'int_divide',
    'pmod',
    'mod',
    'fmod',
    'substr',
    'substring',
    'append_trailing_char_if_absent',
    'ST_X',
    'ST_Y',
    'ST_AsText',
    'ST_GeometryFromText',
    'ST_LineFromText',
    'ST_Polygon',
    'ST_Contains'
]

invisible_functions = [
]
