/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TSimpleServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftServer {
    private static final Logger LOG = Logger.getLogger(ThriftServer.class);
    private ThriftServerType type = ThriftServerType.THREAD_POOL;
    private int port;
    private TProcessor processor;
    private TServer server;
    private Thread serverThread;

    public ThriftServer(int port, TProcessor processor) {
        this.port = port;
        this.processor = processor;
    }

    private void createSimpleServer() throws TTransportException {
        TServer.Args args = (TServer.Args)((TServer.Args)new TServer.Args((TServerTransport)new TServerSocket(this.port)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).processor(this.processor);
        this.server = new TSimpleServer((TServer.AbstractServerArgs)args);
    }

    private void createThreadedServer() throws TTransportException {
        TThreadedSelectorServer.Args args = (TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)new TThreadedSelectorServer.Args((TNonblockingServerTransport)new TNonblockingServerSocket(this.port)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).processor(this.processor);
        this.server = new TThreadedSelectorServer(args);
    }

    private void createThreadPoolServer() throws TTransportException {
        TThreadPoolServer.Args args = (TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)new TServerSocket(this.port)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).processor(this.processor);
        this.server = new TThreadPoolServer(args);
    }

    public void start() throws IOException {
        try {
            switch (this.type) {
                case SIMPLE: {
                    this.createSimpleServer();
                    break;
                }
                case THREADED: {
                    this.createThreadedServer();
                    break;
                }
                case THREAD_POOL: {
                    this.createThreadPoolServer();
                    break;
                }
            }
        }
        catch (TTransportException ex) {
            LOG.warn((Object)"create thrift server failed.", (Throwable)ex);
            throw new IOException("create thrift server failed.", ex);
        }
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ThriftServer.this.server.serve();
            }
        });
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void join() throws InterruptedException {
        if (this.server != null && this.server.isServing()) {
            this.server.stop();
        }
        this.serverThread.join();
    }

    public static enum ThriftServerType {
        SIMPLE,
        THREADED,
        THREAD_POOL;

    }
}

