/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.broker.hdfs;

import com.google.common.base.Stopwatch;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.doris.broker.hdfs.BrokerException;
import org.apache.doris.broker.hdfs.FileSystemManager;
import org.apache.doris.common.BrokerPerfMonitor;
import org.apache.doris.thrift.TBrokerCheckPathExistRequest;
import org.apache.doris.thrift.TBrokerCheckPathExistResponse;
import org.apache.doris.thrift.TBrokerCloseReaderRequest;
import org.apache.doris.thrift.TBrokerCloseWriterRequest;
import org.apache.doris.thrift.TBrokerDeletePathRequest;
import org.apache.doris.thrift.TBrokerFD;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TBrokerListPathRequest;
import org.apache.doris.thrift.TBrokerListResponse;
import org.apache.doris.thrift.TBrokerOpenReaderRequest;
import org.apache.doris.thrift.TBrokerOpenReaderResponse;
import org.apache.doris.thrift.TBrokerOpenWriterRequest;
import org.apache.doris.thrift.TBrokerOpenWriterResponse;
import org.apache.doris.thrift.TBrokerOperationStatus;
import org.apache.doris.thrift.TBrokerOperationStatusCode;
import org.apache.doris.thrift.TBrokerPReadRequest;
import org.apache.doris.thrift.TBrokerPWriteRequest;
import org.apache.doris.thrift.TBrokerPingBrokerRequest;
import org.apache.doris.thrift.TBrokerReadResponse;
import org.apache.doris.thrift.TBrokerRenamePathRequest;
import org.apache.doris.thrift.TBrokerSeekRequest;
import org.apache.doris.thrift.TPaloBrokerService;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class HDFSBrokerServiceImpl
implements TPaloBrokerService.Iface {
    private static Logger logger = Logger.getLogger((String)HDFSBrokerServiceImpl.class.getName());
    private FileSystemManager fileSystemManager = new FileSystemManager();

    private TBrokerOperationStatus generateOKStatus() {
        return new TBrokerOperationStatus(TBrokerOperationStatusCode.OK);
    }

    @Override
    public TBrokerListResponse listPath(TBrokerListPathRequest request) throws TException {
        logger.info((Object)("received a list path request, request detail: " + request));
        TBrokerListResponse response = new TBrokerListResponse();
        try {
            boolean fileNameOnly = false;
            if (request.isSetFileNameOnly()) {
                fileNameOnly = request.isFileNameOnly();
            }
            List<TBrokerFileStatus> fileStatuses = this.fileSystemManager.listPath(request.path, fileNameOnly, request.properties);
            response.setOpStatus(this.generateOKStatus());
            response.setFiles(fileStatuses);
            return response;
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to list path: " + request.path), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            response.setOpStatus(errorStatus);
            return response;
        }
    }

    @Override
    public TBrokerOperationStatus deletePath(TBrokerDeletePathRequest request) throws TException {
        logger.info((Object)("receive a delete path request, request detail: " + request));
        try {
            this.fileSystemManager.deletePath(request.path, request.properties);
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to delete path: " + request.path), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            return errorStatus;
        }
        return this.generateOKStatus();
    }

    @Override
    public TBrokerOperationStatus renamePath(TBrokerRenamePathRequest request) throws TException {
        logger.info((Object)("receive a rename path request, request detail: " + request));
        try {
            this.fileSystemManager.renamePath(request.srcPath, request.destPath, request.properties);
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to rename path: " + request.srcPath + " to " + request.destPath), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            return errorStatus;
        }
        return this.generateOKStatus();
    }

    @Override
    public TBrokerCheckPathExistResponse checkPathExist(TBrokerCheckPathExistRequest request) throws TException {
        logger.info((Object)("receive a check path request, request detail: " + request));
        TBrokerCheckPathExistResponse response = new TBrokerCheckPathExistResponse();
        try {
            boolean isPathExist = this.fileSystemManager.checkPathExist(request.path, request.properties);
            response.setIsPathExist(isPathExist);
            response.setOpStatus(this.generateOKStatus());
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to check path exist: " + request.path), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            response.setOpStatus(errorStatus);
        }
        return response;
    }

    @Override
    public TBrokerOpenReaderResponse openReader(TBrokerOpenReaderRequest request) throws TException {
        logger.info((Object)("receive a open reader request, request detail: " + request));
        TBrokerOpenReaderResponse response = new TBrokerOpenReaderResponse();
        try {
            TBrokerFD fd = this.fileSystemManager.openReader(request.clientId, request.path, request.startOffset, request.properties);
            response.setFd(fd);
            response.setOpStatus(this.generateOKStatus());
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to open reader for path: " + request.path), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            response.setOpStatus(errorStatus);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TBrokerReadResponse pread(TBrokerPReadRequest request) throws TException {
        logger.debug((Object)("receive a read request, request detail: " + request));
        Stopwatch stopwatch = BrokerPerfMonitor.startWatch();
        TBrokerReadResponse response = new TBrokerReadResponse();
        try {
            ByteBuffer readBuf = this.fileSystemManager.pread(request.fd, request.offset, request.length);
            response.setData(readBuf);
            response.setOpStatus(this.generateOKStatus());
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to pread: " + request.fd), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            response.setOpStatus(errorStatus);
            TBrokerReadResponse tBrokerReadResponse = response;
            return tBrokerReadResponse;
        }
        finally {
            stopwatch.stop();
            logger.debug((Object)("read request fd: " + request.fd.high + "" + request.fd.low + " cost " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " millis"));
        }
        return response;
    }

    @Override
    public TBrokerOperationStatus seek(TBrokerSeekRequest request) throws TException {
        logger.debug((Object)("receive a seek request, request detail: " + request));
        try {
            this.fileSystemManager.seek(request.fd, request.offset);
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to seek: " + request.fd), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            return errorStatus;
        }
        return this.generateOKStatus();
    }

    @Override
    public TBrokerOperationStatus closeReader(TBrokerCloseReaderRequest request) throws TException {
        logger.info((Object)("receive a close reader request, request detail: " + request));
        try {
            this.fileSystemManager.closeReader(request.fd);
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to close reader: " + request.fd), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            return errorStatus;
        }
        return this.generateOKStatus();
    }

    @Override
    public TBrokerOpenWriterResponse openWriter(TBrokerOpenWriterRequest request) throws TException {
        logger.info((Object)("receive a open writer request, request detail: " + request));
        TBrokerOpenWriterResponse response = new TBrokerOpenWriterResponse();
        try {
            TBrokerFD fd = this.fileSystemManager.openWriter(request.clientId, request.path, request.properties);
            response.setFd(fd);
            response.setOpStatus(this.generateOKStatus());
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to open writer: " + request.path), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            response.setOpStatus(errorStatus);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TBrokerOperationStatus pwrite(TBrokerPWriteRequest request) throws TException {
        logger.debug((Object)("receive a pwrite request, request detail: " + request));
        Stopwatch stopwatch = BrokerPerfMonitor.startWatch();
        try {
            this.fileSystemManager.pwrite(request.fd, request.offset, request.getData());
        }
        catch (BrokerException e) {
            TBrokerOperationStatus errorStatus;
            logger.warn((Object)("failed to pwrite: " + request.fd), (Throwable)e);
            TBrokerOperationStatus tBrokerOperationStatus = errorStatus = e.generateFailedOperationStatus();
            return tBrokerOperationStatus;
        }
        finally {
            stopwatch.stop();
            logger.debug((Object)("write request fd: " + request.fd.high + "" + request.fd.low + " cost " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " millis"));
        }
        return this.generateOKStatus();
    }

    @Override
    public TBrokerOperationStatus closeWriter(TBrokerCloseWriterRequest request) throws TException {
        logger.info((Object)("receive a close writer request, request detail: " + request));
        try {
            this.fileSystemManager.closeWriter(request.fd);
        }
        catch (BrokerException e) {
            logger.warn((Object)("failed to close writer: " + request.fd), (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            return errorStatus;
        }
        return this.generateOKStatus();
    }

    @Override
    public TBrokerOperationStatus ping(TBrokerPingBrokerRequest request) throws TException {
        logger.debug((Object)("receive a ping request, request detail: " + request));
        try {
            this.fileSystemManager.ping(request.clientId);
        }
        catch (BrokerException e) {
            logger.warn((Object)"failed to ping: ", (Throwable)e);
            TBrokerOperationStatus errorStatus = e.generateFailedOperationStatus();
            return errorStatus;
        }
        return this.generateOKStatus();
    }
}

