/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.fs.CosNCopyFileContext;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNCopyFileTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CosNCopyFileTask.class);
    private final NativeFileSystemStore store;
    private final String srcKey;
    private final String dstKey;
    private final CosNCopyFileContext cosCopyFileContext;

    public CosNCopyFileTask(NativeFileSystemStore store, String srcKey, String dstKey, CosNCopyFileContext cosCopyFileContext) {
        this.store = store;
        this.srcKey = srcKey;
        this.dstKey = dstKey;
        this.cosCopyFileContext = cosCopyFileContext;
    }

    @Override
    public void run() {
        boolean fail = false;
        try {
            this.store.copy(this.srcKey, this.dstKey);
        }
        catch (IOException e) {
            LOG.warn("Exception thrown when copy from {} to {}, exception:{}", new Object[]{this.srcKey, this.dstKey, e});
            fail = true;
        }
        finally {
            this.cosCopyFileContext.lock();
            if (fail) {
                this.cosCopyFileContext.setCopySuccess(false);
            }
            this.cosCopyFileContext.incCopiesFinish();
            this.cosCopyFileContext.signalAll();
            this.cosCopyFileContext.unlock();
        }
    }
}

