/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.Constants;
import com.obs.services.internal.IConvertor;
import com.obs.services.internal.IHeaders;
import com.obs.services.internal.RepeatableRequestEntity;
import com.obs.services.internal.RestStorageService;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.SimpleProgressManager;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.io.ProgressInputStream;
import com.obs.services.internal.utils.AbstractAuthentication;
import com.obs.services.internal.utils.Mimetypes;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.utils.V4Authentication;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.AvailableZoneEnum;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketLocationResponse;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketPolicyResponse;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyObjectResult;
import com.obs.services.model.CopyPartRequest;
import com.obs.services.model.CopyPartResult;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.ExtensionBucketPermissionEnum;
import com.obs.services.model.ExtensionObjectPermissionEnum;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ListBucketsResult;
import com.obs.services.model.ListMultipartUploadsRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ListPartsRequest;
import com.obs.services.model.ListPartsResult;
import com.obs.services.model.ListVersionsRequest;
import com.obs.services.model.ListVersionsResult;
import com.obs.services.model.MultipartUploadListing;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.OptionsInfoRequest;
import com.obs.services.model.Permission;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.PutObjectBasicRequest;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.SseCHeader;
import com.obs.services.model.SseKmsHeader;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import com.obs.services.model.V4PostSignatureResponse;
import com.obs.services.model.VersionOrDeleteMarker;
import com.obs.services.model.VersioningStatusEnum;
import com.obs.services.model.WebsiteConfiguration;
import com.obs.services.model.fs.FSStatusEnum;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import com.obs.services.model.fs.NewBucketRequest;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.ReadFileResult;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;
import com.obs.services.model.fs.SetBucketFSStatusRequest;
import com.obs.services.model.fs.TruncateFileRequest;
import com.obs.services.model.fs.TruncateFileResult;
import com.obs.services.model.fs.WriteFileRequest;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObsService
extends RestStorageService {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    protected ObsService() {
    }

    protected HeaderResponse setBucketVersioningImpl(String bucketName, VersioningStatusEnum status) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.VERSIONING.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String xml = this.getIConvertor().transVersioningConfiguration(bucketName, status != null ? status.getCode() : null);
        Response response = this.performRestPut(bucketName, null, metadata, requestParams, this.createRequestBody("application/xml", xml), true);
        return this.build(response);
    }

    protected RequestBody createRequestBody(String mimeType, String content) throws ServiceException {
        try {
            if (log.isTraceEnabled()) {
                try {
                    log.trace("Entity Content:" + content);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return RequestBody.create((MediaType)MediaType.parse((String)mimeType), (byte[])content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException(e);
        }
    }

    protected void verifyResponseContentType(Response response) throws ServiceException {
        String contentType;
        if (this.obsProperties.getBoolProperty("obs.verify-content-type", true) && !"application/xml".equalsIgnoreCase(contentType = response.header("Content-Type")) && !"text/xml".equalsIgnoreCase(contentType)) {
            throw new ServiceException("Expected XML document response from OBS but received content type " + contentType);
        }
    }

    protected BucketVersioningConfiguration getBucketVersioningImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.VERSIONING.getOriginalStringCode(), "");
        Response response = this.performRestGet(bucketName, null, requestParams, null);
        this.verifyResponseContentType(response);
        BucketVersioningConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketVersioningHandler.class, false).getVersioningStatus();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    TransResult transListVersionsRequest(ListVersionsRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.VERSIONS.getOriginalStringCode(), "");
        if (request.getPrefix() != null) {
            params.put("prefix", request.getPrefix());
        }
        if (request.getDelimiter() != null) {
            params.put("delimiter", request.getDelimiter());
        }
        if (request.getMaxKeys() > 0) {
            params.put("max-keys", String.valueOf(request.getMaxKeys()));
        }
        if (request.getKeyMarker() != null) {
            params.put("key-marker", request.getKeyMarker());
        }
        if (request.getVersionIdMarker() != null) {
            params.put("version-id-marker", request.getVersionIdMarker());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request.getListTimeout() > 0) {
            this.putHeader(headers, this.getIHeaders().listTimeoutHeader(), String.valueOf(request.getListTimeout()));
        }
        return new TransResult(headers, params, null);
    }

    protected ListVersionsResult listVersionsImpl(ListVersionsRequest request) throws ServiceException {
        TransResult result = this.transListVersionsRequest(request);
        Response response = this.performRestGet(request.getBucketName(), null, result.getParams(), null);
        this.verifyResponseContentType(response);
        XmlResponsesSaxParser.ListVersionsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.ListVersionsHandler.class, true);
        List<VersionOrDeleteMarker> partialItems = handler.getItems();
        ListVersionsResult listVersionsResult = new ListVersionsResult(handler.getBucketName() == null ? request.getBucketName() : handler.getBucketName(), handler.getRequestPrefix() == null ? request.getPrefix() : handler.getRequestPrefix(), handler.getKeyMarker() == null ? request.getKeyMarker() : handler.getKeyMarker(), handler.getNextKeyMarker(), handler.getVersionIdMarker() == null ? request.getVersionIdMarker() : handler.getVersionIdMarker(), handler.getNextVersionIdMarker(), String.valueOf(handler.getRequestMaxKeys()), handler.isListingTruncated(), partialItems.toArray(new VersionOrDeleteMarker[partialItems.size()]), handler.getCommonPrefixes(), response.header(this.getIHeaders().bucketRegionHeader()), handler.getDelimiter() == null ? request.getDelimiter() : handler.getDelimiter());
        ObsService.setResponseHeaders(listVersionsResult, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(listVersionsResult, response.code());
        return listVersionsResult;
    }

    protected BucketPolicyResponse getBucketPolicyImpl(String bucketName) throws ServiceException {
        try {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(SpecialParamEnum.POLICY.getOriginalStringCode(), "");
            Response response = this.performRestGet(bucketName, null, requestParameters, null);
            BucketPolicyResponse ret = new BucketPolicyResponse(response.body().string());
            ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
            ObsService.setStatusCode(ret, response.code());
            return ret;
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    protected BucketNotificationConfiguration getBucketNotificationConfigurationImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.NOTIFICATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        BucketNotificationConfiguration result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketNotificationConfigurationHandler.class, false).getBucketNotificationConfiguration();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected HeaderResponse setBucketNotificationImpl(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.NOTIFICATION.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String xml = this.getIConvertor().transBucketNotificationConfiguration(bucketNotificationConfiguration);
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketPolicyImpl(String bucketName, String policyDocument) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.POLICY.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "text/plain");
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("text/plain", policyDocument), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketPolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.POLICY.getOriginalStringCode(), "");
        Response response = this.performRestDelete(bucketName, null, requestParameters);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    TransResult transInitiateMultipartUploadRequest(InitiateMultipartUploadRequest request) throws ServiceException {
        Object contentType;
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders();
        IConvertor iconvertor = this.getIConvertor();
        ObjectMetadata objectMetadata = request.getMetadata() == null ? new ObjectMetadata() : request.getMetadata();
        for (Map.Entry<String, Object> entry : objectMetadata.getMetadata().entrySet()) {
            String key = entry.getKey();
            if (!ServiceUtils.isValid(key) || Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains((key = key.trim()).toLowerCase())) continue;
            headers.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
        }
        if (objectMetadata.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(objectMetadata.getObjectStorageClass()));
        }
        if (request.getExpires() > 0) {
            this.putHeader(headers, iheaders.expiresHeader(), String.valueOf(request.getExpires()));
        }
        if (ServiceUtils.isValid(objectMetadata.getWebSiteRedirectLocation())) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), objectMetadata.getWebSiteRedirectLocation());
        }
        if (ServiceUtils.isValid(request.getSuccessRedirectLocation())) {
            this.putHeader(headers, iheaders.successRedirectLocationHeader(), request.getSuccessRedirectLocation());
        }
        if (ServiceUtils.isValid(objectMetadata.getContentEncoding())) {
            headers.put("Content-Encoding", objectMetadata.getContentEncoding().trim());
        }
        this.transExtensionPermissions(request, headers);
        this.transSseHeaders(request, headers, iheaders);
        Object object = contentType = objectMetadata.getContentType() == null ? objectMetadata.getValue("Content-Type") : objectMetadata.getContentType();
        if (contentType == null) {
            contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
        }
        String _contentType = contentType.toString().trim();
        headers.put("Content-Type", _contentType);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.UPLOADS.getOriginalStringCode(), "");
        return new TransResult(headers, params, null);
    }

    protected InitiateMultipartUploadResult initiateMultipartUploadImpl(InitiateMultipartUploadRequest request) throws ServiceException {
        TransResult result = this.transInitiateMultipartUploadRequest(request);
        this.prepareRESTHeaderAcl(result.getHeaders(), request.getAcl());
        Response httpResponse = this.performRestPost(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), null, false);
        this.verifyResponseContentType(httpResponse);
        InitiateMultipartUploadResult multipartUpload = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.InitiateMultipartUploadHandler.class, true).getInitiateMultipartUploadResult();
        ObsService.setResponseHeaders(multipartUpload, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(multipartUpload, httpResponse.code());
        return multipartUpload;
    }

    protected HeaderResponse abortMultipartUploadImpl(String uploadId, String bucketName, String objectKey) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", uploadId);
        Response response = this.performRestDelete(bucketName, objectKey, requestParameters);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected CompleteMultipartUploadResult completeMultipartUploadImpl(CompleteMultipartUploadRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", request.getUploadId());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        Response response = this.performRestPost(request.getBucketName(), request.getObjectKey(), metadata, requestParameters, this.createRequestBody("application/xml", this.getIConvertor().transCompleteMultipartUpload(request.getPartEtag())), false);
        this.verifyResponseContentType(response);
        XmlResponsesSaxParser.CompleteMultipartUploadHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CompleteMultipartUploadHandler.class, true);
        String versionId = response.header(this.getIHeaders().versionIdHeader());
        CompleteMultipartUploadResult ret = new CompleteMultipartUploadResult(handler.getBucketName(), handler.getObjectKey(), handler.getEtag(), handler.getLocation(), versionId, this.getObjectUrl(handler.getBucketName(), handler.getObjectKey()));
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected MultipartUploadListing listMultipartUploadsImpl(ListMultipartUploadsRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.UPLOADS.getOriginalStringCode(), "");
        if (request.getPrefix() != null) {
            requestParameters.put("prefix", request.getPrefix());
        }
        if (request.getDelimiter() != null) {
            requestParameters.put("delimiter", request.getDelimiter());
        }
        if (request.getMaxUploads() != null) {
            requestParameters.put("max-uploads", request.getMaxUploads().toString());
        }
        if (request.getKeyMarker() != null) {
            requestParameters.put("key-marker", request.getKeyMarker());
        }
        if (request.getUploadIdMarker() != null) {
            requestParameters.put("upload-id-marker", request.getUploadIdMarker());
        }
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListMultipartUploadsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListMultipartUploadsHandler.class, true);
        MultipartUploadListing listResult = new MultipartUploadListing(handler.getBucketName() == null ? request.getBucketName() : handler.getBucketName(), handler.getKeyMarker() == null ? request.getKeyMarker() : handler.getKeyMarker(), handler.getUploadIdMarker() == null ? request.getUploadIdMarker() : handler.getUploadIdMarker(), handler.getNextKeyMarker(), handler.getNextUploadIdMarker(), handler.getPrefix() == null ? request.getPrefix() : handler.getPrefix(), handler.getMaxUploads(), handler.isTruncated(), handler.getMultipartUploadList(), handler.getDelimiter() == null ? request.getDelimiter() : handler.getDelimiter(), handler.getCommonPrefixes().toArray(new String[handler.getCommonPrefixes().size()]));
        ObsService.setResponseHeaders(listResult, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(listResult, httpResponse.code());
        return listResult;
    }

    protected ListPartsResult listPartsImpl(ListPartsRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", request.getUploadId());
        if (null != request.getMaxParts()) {
            requestParameters.put("max-parts", request.getMaxParts().toString());
        }
        if (null != request.getPartNumberMarker()) {
            requestParameters.put("part-number-marker", request.getPartNumberMarker().toString());
        }
        Response httpResponse = this.performRestGet(request.getBucketName(), request.getKey(), requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListPartsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListPartsHandler.class, true);
        ListPartsResult result = new ListPartsResult(handler.getBucketName() == null ? request.getBucketName() : handler.getBucketName(), handler.getObjectKey() == null ? request.getKey() : handler.getObjectKey(), handler.getUploadId() == null ? request.getUploadId() : handler.getUploadId(), handler.getInitiator(), handler.getOwner(), StorageClassEnum.getValueFromCode(handler.getStorageClass()), handler.getMultiPartList(), handler.getMaxParts(), handler.isTruncated(), (String)(handler.getPartNumberMarker() == null ? (request.getPartNumberMarker() == null ? null : request.getPartNumberMarker().toString()) : handler.getPartNumberMarker()), handler.getNextPartNumberMarker());
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected WebsiteConfiguration getBucketWebsiteConfigurationImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        WebsiteConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketWebsiteConfigurationHandler.class, false).getWebsiteConfig();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected HeaderResponse setBucketWebsiteConfigurationImpl(String bucketName, WebsiteConfiguration config) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String xml = this.getIConvertor().transWebsiteConfiguration(config);
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketWebsiteConfigurationImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        Response response = this.performRestDelete(bucketName, null, requestParameters);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected LifecycleConfiguration getBucketLifecycleConfigurationImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        Response response = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(response);
        LifecycleConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketLifecycleConfigurationHandler.class, false).getLifecycleConfig();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketLifecycleConfigurationImpl(String bucketName, LifecycleConfiguration config) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        String xml = this.getIConvertor().transLifecycleConfiguration(config);
        metadata.put("Content-MD5", ServiceUtils.computeMD5(xml));
        metadata.put("Content-Type", "application/xml");
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketLifecycleConfigurationImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        Response response = this.performRestDelete(bucketName, null, requestParameters);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected DeleteObjectsResult deleteObjectsImpl(DeleteObjectsRequest deleteObjectsRequest) throws ServiceException {
        String xml = this.getIConvertor().transKeyAndVersion(deleteObjectsRequest.getKeyAndVersions(), deleteObjectsRequest.isQuiet());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-MD5", ServiceUtils.computeMD5(xml));
        metadata.put("Content-Type", "application/xml");
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DELETE.getOriginalStringCode(), "");
        Response httpResponse = this.performRestPost(deleteObjectsRequest.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), false);
        this.verifyResponseContentType(httpResponse);
        DeleteObjectsResult ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.DeleteObjectsHandler.class, true).getMultipleDeleteResult();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected boolean headBucketImpl(String bucketName) throws ServiceException {
        try {
            this.performRestHead(bucketName, null, null, null);
            return true;
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    protected HeaderResponse setBucketFSStatusImpl(SetBucketFSStatusRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.FILEINTERFACE.getOriginalStringCode(), "");
        String xml = this.getIConvertor().transBucketFileInterface(request.getStatus());
        Response response = this.performRestPut(request.getBucketName(), null, null, requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected TruncateFileResult truncateFileImpl(TruncateFileRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TRUNCATE.getOriginalStringCode(), "");
        requestParameters.put("length", String.valueOf(request.getNewLength()));
        Response response = this.performRestPut(request.getBucketName(), request.getObjectKey(), null, requestParameters, null, true);
        TruncateFileResult result = new TruncateFileResult();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected RenameResult renameObjectImpl(RenameRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.RENAME.getOriginalStringCode(), "");
        requestParameters.put("name", request.getNewObjectKey());
        Response response = this.performRestPost(request.getBucketName(), request.getObjectKey(), null, requestParameters, null, true);
        RenameResult result = new RenameResult();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected GetBucketFSStatusResult getBucketMetadataImpl(BucketMetadataInfoRequest bucketMetadataInfoRequest) throws ServiceException {
        GetBucketFSStatusResult output = null;
        String origin = bucketMetadataInfoRequest.getOrigin();
        List<String> requestHeaders = bucketMetadataInfoRequest.getRequestHeaders();
        if (origin != null && requestHeaders != null && requestHeaders.size() > 0) {
            for (int i = 0; i < requestHeaders.size(); ++i) {
                String value = requestHeaders.get(i);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Origin", origin);
                headers.put("Access-Control-Request-Headers", value);
                Response response = this.performRestHead(bucketMetadataInfoRequest.getBucketName(), null, null, headers);
                if (output == null) {
                    output = this.getOptionInfoResult(response);
                } else {
                    String header = response.header("Access-Control-Allow-Headers");
                    if (header != null && !output.getAllowHeaders().contains(header)) {
                        output.getAllowHeaders().add(header);
                    }
                }
                response.close();
            }
        } else {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (origin != null) {
                headers.put("Origin", origin);
            }
            Response response = this.performRestHead(bucketMetadataInfoRequest.getBucketName(), null, null, headers);
            output = this.getOptionInfoResult(response);
            response.close();
        }
        return output;
    }

    protected RestoreObjectRequest.RestoreObjectStatus restoreObjectImpl(RestoreObjectRequest restoreObjectRequest) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.RESTORE.getOriginalStringCode(), "");
        if (restoreObjectRequest.getVersionId() != null) {
            requestParameters.put("versionId", restoreObjectRequest.getVersionId());
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transRestoreObjectRequest(restoreObjectRequest);
        metadata.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        metadata.put("Content-Type", "application/xml");
        Response response = this.performRestPost(restoreObjectRequest.getBucketName(), restoreObjectRequest.getObjectKey(), metadata, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        RestoreObjectRequest.RestoreObjectStatus ret = RestoreObjectRequest.RestoreObjectStatus.valueOf(response.code());
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected BucketTagInfo getBucketTaggingImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        BucketTagInfo result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketTagInfoHandler.class, false).getBucketTagInfo();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected HeaderResponse setBucketTaggingImpl(String bucketName, BucketTagInfo bucketTagInfo) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transBucketTagInfo(bucketTagInfo);
        headers.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        headers.put("Content-Type", "application/xml");
        Response response = this.performRestPut(bucketName, null, headers, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketTaggingImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        Response response = this.performRestDelete(bucketName, null, requestParameters);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected ReplicationConfiguration getBucketReplicationConfigurationImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        ReplicationConfiguration result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketReplicationConfigurationHandler.class, false).getReplicationConfiguration();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected HeaderResponse setBucketReplicationConfigurationImpl(String bucketName, ReplicationConfiguration replicationConfiguration) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transReplicationConfiguration(replicationConfiguration);
        headers.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        headers.put("Content-Type", "application/xml");
        Response response = this.performRestPut(bucketName, null, headers, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketReplicationConfigurationImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        Response response = this.performRestDelete(bucketName, null, requestParameters);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected TemporarySignatureResponse _createTemporarySignature(TemporarySignatureRequest request) throws Exception {
        String key;
        String securityToken;
        long secondsSinceEpoch = request.getExpires() <= 0L ? 300L : request.getExpires();
        secondsSinceEpoch += System.currentTimeMillis() / 1000L;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(request.getHeaders());
        TreeMap<String, Object> queryParams = new TreeMap<String, Object>();
        queryParams.putAll(request.getQueryParams());
        if (!queryParams.containsKey(this.getIHeaders().securityTokenHeader()) && ServiceUtils.isValid(securityToken = this.getProviderCredentials().getSecurityToken())) {
            queryParams.put(this.getIHeaders().securityTokenHeader(), securityToken);
        }
        String endpoint = this.getEndpoint();
        String bucketName = request.getBucketName();
        String objectKey = request.getObjectKey();
        String hostname = ServiceUtils.generateHostnameForBucket(bucketName, this.isPathStyle(), endpoint);
        String virtualBucketPath = "";
        String uriPath = "";
        if (!endpoint.equals(hostname)) {
            int subdomainOffset = hostname.lastIndexOf("." + endpoint);
            if (subdomainOffset > 0) {
                virtualBucketPath = hostname.substring(0, subdomainOffset) + "/";
            }
            uriPath = objectKey != null ? RestUtils.encodeUrlPath(objectKey, "/") : "";
        } else {
            uriPath = (!ServiceUtils.isValid(bucketName) ? "" : bucketName.trim()) + (objectKey != null ? "/" + RestUtils.encodeUrlPath(objectKey, "/") : "");
        }
        if (request.getSpecialParam() != null) {
            if (request.getSpecialParam() == SpecialParamEnum.STORAGECLASS || request.getSpecialParam() == SpecialParamEnum.STORAGEPOLICY) {
                request.setSpecialParam(this.getSpecialParamForStorageClass());
            }
            uriPath = uriPath + "?" + request.getSpecialParam().getOriginalStringCode() + "&";
        } else {
            uriPath = uriPath + "?";
        }
        if (this.isCname()) {
            hostname = endpoint;
        }
        headers.put("Host", hostname + ":" + (this.getHttpsOnly() ? this.getHttpsPort() : this.getHttpPort()));
        String accessKeyIdPrefix = this.getProviderCredentials().getAuthType() == AuthTypeEnum.V2 ? "AWSAccessKeyId=" : "AccessKeyId=";
        uriPath = uriPath + accessKeyIdPrefix + this.getProviderCredentials().getAccessKey();
        uriPath = uriPath + "&Expires=" + secondsSinceEpoch;
        String requestMethod = request.getMethod() != null ? request.getMethod().getOperationType() : "GET";
        TreeMap<String, String> actualSignedRequestHeaders = new TreeMap<String, String>();
        for (Map.Entry entry : headers.entrySet()) {
            String value;
            if (!ServiceUtils.isValid((String)entry.getKey())) continue;
            key = ((String)entry.getKey()).toLowerCase().trim();
            boolean validKey = false;
            if (Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key) || key.startsWith(this.getRestHeaderPrefix()) || key.startsWith("x-obs-")) {
                validKey = true;
            } else if (requestMethod.equals("PUT") || requestMethod.equals("POST")) {
                key = this.getRestMetadataPrefix() + key;
                validKey = true;
            }
            if (!validKey) continue;
            String string = value = entry.getValue() == null ? "" : ((String)entry.getValue()).trim();
            if (key.startsWith(this.getRestMetadataPrefix())) {
                value = RestUtils.uriEncode(value, true);
            }
            actualSignedRequestHeaders.put(((String)entry.getKey()).trim(), value);
        }
        for (Map.Entry entry : queryParams.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            key = RestUtils.uriEncode((CharSequence)entry.getKey(), false);
            uriPath = uriPath + "&";
            uriPath = uriPath + key;
            uriPath = uriPath + "=";
            String value = RestUtils.uriEncode(entry.getValue().toString(), false);
            uriPath = uriPath + value;
        }
        String canonicalString = this.getAuthentication().makeServiceCanonicalString(requestMethod, "/" + virtualBucketPath + uriPath, actualSignedRequestHeaders, String.valueOf(secondsSinceEpoch), Constants.ALLOWED_RESOURCE_PARAMTER_NAMES);
        if (log.isDebugEnabled()) {
            log.debug("CanonicalString is :" + canonicalString);
        }
        String signedCanonical = ServiceUtils.signWithHmacSha1(this.credentials.getSecretKey(), canonicalString);
        String encodedCanonical = RestUtils.encodeUrlString(signedCanonical);
        uriPath = uriPath + "&Signature=" + encodedCanonical;
        String signedUrl = this.getHttpsOnly() ? "https://" : "http://";
        signedUrl = signedUrl + (String)headers.get("Host") + "/" + uriPath;
        TemporarySignatureResponse response = new TemporarySignatureResponse(signedUrl);
        response.getActualSignedRequestHeaders().putAll(actualSignedRequestHeaders);
        return response;
    }

    protected PostSignatureResponse _createPostSignature(PostSignatureRequest request, boolean isV4) throws Exception {
        Date requestDate = request.getRequestDate() != null ? request.getRequestDate() : new Date();
        SimpleDateFormat expirationDateFormat = ServiceUtils.getExpirationDateFormat();
        Date expiryDate = request.getExpiryDate() == null ? new Date(requestDate.getTime() + (request.getExpires() <= 0L ? 300L : request.getExpires()) * 1000L) : request.getExpiryDate();
        String expiration = expirationDateFormat.format(expiryDate);
        StringBuilder originPolicy = new StringBuilder();
        originPolicy.append("{\"expiration\":").append("\"").append(expiration).append("\",").append("\"conditions\":[");
        String shortDate = ServiceUtils.getShortDateFormat().format(requestDate);
        String longDate = ServiceUtils.getLongDateFormat().format(requestDate);
        String credential = this.getCredential(shortDate);
        if (request.getConditions() != null && !request.getConditions().isEmpty()) {
            originPolicy.append(ServiceUtils.join(request.getConditions(), ",")).append(",");
        } else {
            String securityToken;
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            if (isV4) {
                params.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
                params.put("X-Amz-Date", longDate);
                params.put("X-Amz-Credential", credential);
            }
            params.putAll(request.getFormParams());
            if (!params.containsKey(this.getIHeaders().securityTokenHeader()) && ServiceUtils.isValid(securityToken = this.getProviderCredentials().getSecurityToken())) {
                params.put(this.getIHeaders().securityTokenHeader(), securityToken);
            }
            if (ServiceUtils.isValid(request.getBucketName())) {
                params.put("bucket", request.getBucketName());
            }
            if (ServiceUtils.isValid(request.getObjectKey())) {
                params.put("key", request.getObjectKey());
            }
            boolean matchAnyBucket = true;
            boolean matchAnyKey = true;
            for (Map.Entry entry : params.entrySet()) {
                if (!ServiceUtils.isValid((String)entry.getKey())) continue;
                String key = ((String)entry.getKey()).toLowerCase().trim();
                if (key.equals("bucket")) {
                    matchAnyBucket = false;
                } else if (key.equals("key")) {
                    matchAnyKey = false;
                }
                if (!Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key) && !key.startsWith(this.getRestHeaderPrefix()) && !key.startsWith("x-obs-") && !key.equals("acl") && !key.equals("bucket") && !key.equals("key") && !key.equals("success_action_redirect") && !key.equals("redirect") && !key.equals("success_action_status")) continue;
                String value = entry.getValue() == null ? "" : entry.getValue().toString();
                originPolicy.append("{\"").append(key).append("\":").append("\"").append(value).append("\"},");
            }
            if (matchAnyBucket) {
                originPolicy.append("[\"starts-with\", \"$bucket\", \"\"],");
            }
            if (matchAnyKey) {
                originPolicy.append("[\"starts-with\", \"$key\", \"\"],");
            }
        }
        originPolicy.append("]}");
        String policy = ServiceUtils.toBase64(originPolicy.toString().getBytes("UTF-8"));
        if (isV4) {
            String signature = V4Authentication.caculateSignature(policy, shortDate, this.getProviderCredentials().getSecretKey());
            return new V4PostSignatureResponse(policy, originPolicy.toString(), "AWS4-HMAC-SHA256", credential, longDate, signature, expiration);
        }
        String signature = AbstractAuthentication.caculateSignature(policy, this.getProviderCredentials().getSecretKey());
        return new PostSignatureResponse(policy, originPolicy.toString(), signature, expiration);
    }

    protected TemporarySignatureResponse createV4TemporarySignature(TemporarySignatureRequest request) throws Exception {
        String securityToken;
        StringBuilder canonicalUri = new StringBuilder();
        String bucketName = request.getBucketName();
        String endpoint = this.getEndpoint();
        String objectKey = request.getObjectKey();
        if (ServiceUtils.isValid(bucketName)) {
            if (this.isPathStyle() || !ServiceUtils.isBucketNameValidDNSName(bucketName)) {
                canonicalUri.append("/").append(bucketName.trim());
            } else {
                endpoint = bucketName.trim() + "." + endpoint;
            }
            if (ServiceUtils.isValid(objectKey)) {
                canonicalUri.append("/").append(RestUtils.uriEncode(objectKey, false));
            }
        }
        if (this.isCname()) {
            endpoint = this.getEndpoint();
        }
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.putAll(request.getHeaders());
        TreeMap<String, Object> queryParams = new TreeMap<String, Object>();
        queryParams.putAll(request.getQueryParams());
        Date requestDate = request.getRequestDate();
        if (requestDate == null) {
            requestDate = new Date();
        }
        if (this.getHttpsOnly() && this.getHttpsPort() == 443 || !this.getHttpsOnly() && this.getHttpPort() == 80) {
            headers.put("Host", endpoint);
        } else {
            headers.put("Host", endpoint + ":" + (this.getHttpsOnly() ? this.getHttpsPort() : this.getHttpPort()));
        }
        if (!queryParams.containsKey(this.getIHeaders().securityTokenHeader()) && ServiceUtils.isValid(securityToken = this.getProviderCredentials().getSecurityToken())) {
            queryParams.put(this.getIHeaders().securityTokenHeader(), securityToken);
        }
        String requestMethod = request.getMethod() != null ? request.getMethod().getOperationType() : "GET";
        StringBuilder signedHeaders = new StringBuilder();
        StringBuilder canonicalHeaders = new StringBuilder();
        int index = 0;
        TreeMap<String, String> actualSignedRequestHeaders = new TreeMap<String, String>();
        for (Map.Entry entry : headers.entrySet()) {
            String value;
            if (!ServiceUtils.isValid((String)entry.getKey())) continue;
            String key = ((String)entry.getKey()).toLowerCase().trim();
            boolean validKey = false;
            if (Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key) || key.startsWith(this.getRestHeaderPrefix()) || key.startsWith("x-obs-")) {
                validKey = true;
            } else if (requestMethod.equals("PUT") || requestMethod.equals("POST")) {
                key = this.getRestMetadataPrefix() + key;
                validKey = true;
            }
            if (!validKey) continue;
            String string = value = entry.getValue() == null ? "" : ((String)entry.getValue()).trim();
            if (key.startsWith(this.getRestMetadataPrefix())) {
                value = RestUtils.uriEncode(value, true);
            }
            signedHeaders.append(key);
            canonicalHeaders.append(key).append(":").append(value).append("\n");
            if (index++ != headers.size() - 1) {
                signedHeaders.append(";");
            }
            actualSignedRequestHeaders.put(((String)entry.getKey()).trim(), value);
        }
        String shortDate = ServiceUtils.getShortDateFormat().format(requestDate);
        String longDate = ServiceUtils.getLongDateFormat().format(requestDate);
        queryParams.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        queryParams.put("X-Amz-Credential", this.getCredential(shortDate));
        queryParams.put("X-Amz-Date", longDate);
        queryParams.put("X-Amz-Expires", request.getExpires() <= 0L ? 300L : request.getExpires());
        queryParams.put("X-Amz-SignedHeaders", signedHeaders.toString());
        StringBuilder canonicalQueryString = new StringBuilder();
        StringBuilder signedUrl = new StringBuilder();
        if (this.getHttpsOnly()) {
            signedUrl.append("https://").append(endpoint).append(":").append(this.getHttpsPort());
        } else {
            signedUrl.append("http://").append(endpoint).append(":").append(this.getHttpPort());
        }
        signedUrl.append((CharSequence)canonicalUri).append("?");
        if (request.getSpecialParam() != null) {
            if (request.getSpecialParam() == SpecialParamEnum.STORAGECLASS || request.getSpecialParam() == SpecialParamEnum.STORAGEPOLICY) {
                request.setSpecialParam(this.getSpecialParamForStorageClass());
            }
            queryParams.put(request.getSpecialParam().getOriginalStringCode(), null);
        }
        index = 0;
        for (Map.Entry entry : queryParams.entrySet()) {
            if (!ServiceUtils.isValid((String)entry.getKey())) continue;
            String key = RestUtils.uriEncode((CharSequence)entry.getKey(), false);
            canonicalQueryString.append(key).append("=");
            signedUrl.append(key);
            if (entry.getValue() != null) {
                String value = RestUtils.uriEncode(entry.getValue().toString(), false);
                canonicalQueryString.append(value);
                signedUrl.append("=").append(value);
            } else {
                canonicalQueryString.append("");
            }
            if (index++ == queryParams.size() - 1) continue;
            canonicalQueryString.append("&");
            signedUrl.append("&");
        }
        StringBuilder canonicalRequest = new StringBuilder(requestMethod).append("\n").append(canonicalUri.length() == 0 ? "/" : canonicalUri).append("\n").append((CharSequence)canonicalQueryString).append("\n").append((CharSequence)canonicalHeaders).append("\n").append((CharSequence)signedHeaders).append("\n").append("UNSIGNED-PAYLOAD");
        StringBuilder stringToSign = new StringBuilder("AWS4-HMAC-SHA256").append("\n").append(longDate).append("\n").append(shortDate).append("/").append("region").append("/").append("s3").append("/").append("aws4_request").append("\n").append(V4Authentication.byteToHex(V4Authentication.sha256encode(canonicalRequest.toString())));
        signedUrl.append("&").append("X-Amz-").append("Signature=").append(V4Authentication.caculateSignature(stringToSign.toString(), shortDate, this.getProviderCredentials().getSecretKey()));
        TemporarySignatureResponse response = new TemporarySignatureResponse(signedUrl.toString());
        response.getActualSignedRequestHeaders().putAll(actualSignedRequestHeaders);
        return response;
    }

    protected String getCredential(String shortDate) {
        return this.getProviderCredentials().getAccessKey() + "/" + shortDate + "/" + "region" + "/" + "s3" + "/" + "aws4_request";
    }

    GetBucketFSStatusResult getOptionInfoResult(Response response) {
        Headers headers = response.headers();
        Map map = headers.toMultimap();
        String maxAge = headers.get("Access-Control-Max-Age");
        IHeaders iheaders = this.getIHeaders();
        FSStatusEnum status = FSStatusEnum.getValueFromCode(headers.get(iheaders.fsFileInterfaceHeader()));
        GetBucketFSStatusResult output = new GetBucketFSStatusResult(headers.get("Access-Control-Allow-Origin"), (List)map.get("Access-Control-Allow-Headers"), maxAge == null ? 0 : Integer.parseInt(maxAge), (List)map.get("Access-Control-Allow-Methods"), (List)map.get("Access-Control-Expose-Headers"), StorageClassEnum.getValueFromCode(headers.get(iheaders.defaultStorageClassHeader())), headers.get(iheaders.bucketRegionHeader()), headers.get(iheaders.serverVersionHeader()), status, AvailableZoneEnum.getValueFromCode(headers.get(iheaders.azRedundancyHeader())));
        ObsService.setResponseHeaders(output, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(output, response.code());
        return output;
    }

    protected BucketMetadataInfoResult optionsImpl(String bucketName, String ObjectName, OptionsInfoRequest option) throws ServiceException {
        int i;
        IdentityHashMap<String, String> metadata = new IdentityHashMap<String, String>();
        if (ServiceUtils.isValid(option.getOrigin())) {
            metadata.put("Origin", option.getOrigin().trim());
        }
        for (i = 0; option.getRequestMethod() != null && i < option.getRequestMethod().size(); ++i) {
            metadata.put(new String("Access-Control-Request-Method"), option.getRequestMethod().get(i));
        }
        for (i = 0; option.getRequestHeaders() != null && i < option.getRequestHeaders().size(); ++i) {
            metadata.put(new String("Access-Control-Request-Headers"), option.getRequestHeaders().get(i));
        }
        Response rsult = this.performRestOptions(bucketName, ObjectName, metadata, null, true);
        return this.getOptionInfoResult(rsult);
    }

    protected HeaderResponse deleteBucketCorsImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        Response response = this.performRestDelete(bucketName, null, requestParameters);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected BucketCors getBucketCorsImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        BucketCors ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketCorsHandler.class, false).getConfiguration();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected HeaderResponse setBucketCorsImpl(String bucketName, BucketCors bucketCors) throws ServiceException {
        String corsXML = bucketCors == null ? "" : this.getIConvertor().transBucketCors(bucketCors);
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        metadata.put("Content-MD5", ServiceUtils.computeMD5(corsXML));
        metadata.put("Content-Length", String.valueOf(corsXML.length()));
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/xml", corsXML), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketQuotaImpl(String bucketName, BucketQuota quota) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.QUOTA.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String quotaAsXml = quota == null ? "" : this.getIConvertor().transBucketQuota(quota);
        metadata.put("Content-Length", String.valueOf(quotaAsXml.length()));
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/xml", quotaAsXml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketStorageImpl(String bucketName, BucketStoragePolicyConfiguration storagePolicy) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(this.getSpecialParamForStorageClass().getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String xml = storagePolicy == null ? "" : this.getIConvertor().transStoragePolicy(storagePolicy);
        metadata.put("Content-Length", String.valueOf(xml.length()));
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    void putAclImpl(String bucketName, String objectKey, AccessControlList acl, String versionId) throws ServiceException {
        if (acl != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
            if (versionId != null) {
                requestParameters.put("versionId", versionId);
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("Content-Type", "application/xml");
            String aclAsXml = this.getIConvertor().transAccessControlList(acl, !ServiceUtils.isValid(objectKey));
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            this.performRestPut(bucketName, objectKey, metadata, requestParameters, this.createRequestBody("application/xml", aclAsXml), true);
        }
    }

    protected HeaderResponse setObjectAclImpl(String bucketName, String objectKey, String cannedACL, AccessControlList acl, String versionId) throws ServiceException {
        boolean isExtraAclPutRequired;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        RequestBody entity = null;
        if (ServiceUtils.isValid(cannedACL)) {
            acl = this.getIConvertor().transCannedAcl(cannedACL.trim());
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAclObject(metadata, acl);
        if (isExtraAclPutRequired) {
            String aclAsXml = acl == null ? "" : this.getIConvertor().transAccessControlList(acl, false);
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            entity = this.createRequestBody("application/xml", aclAsXml);
        }
        Response response = this.performRestPut(bucketName, objectKey, metadata, requestParameters, entity, true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketAclImpl(String bucketName, String cannedACL, AccessControlList acl) throws ServiceException {
        boolean isExtraAclPutRequired;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        RequestBody entity = null;
        if (ServiceUtils.isValid(cannedACL)) {
            acl = this.getIConvertor().transCannedAcl(cannedACL.trim());
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAcl(metadata, acl);
        if (isExtraAclPutRequired) {
            String aclAsXml = acl == null ? "" : this.getIConvertor().transAccessControlList(acl, true);
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            entity = this.createRequestBody("application/xml", aclAsXml);
        }
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, entity, true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    AbstractAuthentication getAuthentication() {
        return Constants.AUTHTICATION_MAP.get((Object)this.getProviderCredentials().getAuthType());
    }

    SpecialParamEnum getSpecialParamForStorageClass() {
        return this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS ? SpecialParamEnum.STORAGECLASS : SpecialParamEnum.STORAGEPOLICY;
    }

    void putHeader(Map<String, String> headers, String key, String value) {
        if (ServiceUtils.isValid(key)) {
            headers.put(key, value);
        }
    }

    TransResult transCreateBucketRequest(CreateBucketRequest request) throws ServiceException {
        Set<ExtensionBucketPermissionEnum> extensionPermissionEnums;
        HashMap<String, String> headers = new HashMap<String, String>();
        IConvertor convertor = this.getIConvertor();
        if (request.getBucketStorageClass() != null) {
            this.putHeader(headers, this.getIHeaders().defaultStorageClassHeader(), convertor.transStorageClass(request.getBucketStorageClass()));
        }
        if (request instanceof NewBucketRequest) {
            this.putHeader(headers, this.getIHeaders().fsFileInterfaceHeader(), "Enabled");
        }
        if (request.getAvailableZone() != null) {
            this.putHeader(headers, this.getIHeaders().azRedundancyHeader(), request.getAvailableZone().getCode());
        }
        if (!(extensionPermissionEnums = request.getAllGrantPermissions()).isEmpty()) {
            for (ExtensionBucketPermissionEnum extensionPermissionEnum : extensionPermissionEnums) {
                Set<String> domainIds = request.getDomainIdsByGrantPermission(extensionPermissionEnum);
                ArrayList<String> domainIdList = new ArrayList<String>(domainIds.size());
                for (String domainId : domainIds) {
                    domainIdList.add("id=" + domainId);
                }
                this.putHeader(headers, this.getHeaderByMethodName(extensionPermissionEnum.getCode()), ServiceUtils.join(domainIdList, ","));
            }
        }
        String contentType = "application/xml";
        headers.put("Content-Type", contentType);
        TransResult result = new TransResult(headers);
        if (ServiceUtils.isValid(request.getLocation())) {
            String configXml = convertor.transBucketLoction(request.getLocation());
            headers.put("Content-Length", String.valueOf(configXml.length()));
            RequestBody requestEntity = this.createRequestBody(contentType, configXml);
            result.body = requestEntity;
        }
        return result;
    }

    String getHeaderByMethodName(String code) {
        try {
            IHeaders iheaders = this.getIHeaders();
            Method m = iheaders.getClass().getMethod(code, new Class[0]);
            Object result = m.invoke((Object)iheaders, new Object[0]);
            return result == null ? "" : result.toString();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn("Invoke getHeaderByMethodName error", e);
            }
            return null;
        }
    }

    protected ObsBucket createBucketImpl(CreateBucketRequest request) throws ServiceException {
        Response response;
        AccessControlList acl;
        String bucketName;
        block4: {
            TransResult result = this.transCreateBucketRequest(request);
            bucketName = request.getBucketName();
            acl = request.getAcl();
            boolean isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
            response = this.performRestPut(bucketName, null, result.getHeaders(), null, result.body, true);
            if (isExtraAclPutRequired && acl != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating bucket with a non-canned ACL using REST, so an extra ACL Put is required");
                }
                try {
                    this.putAclImpl(bucketName, null, acl, null);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Try to set bucket acl error", e);
                }
            }
        }
        Map<String, Object> map = this.cleanResponseHeaders(response);
        ObsBucket bucket = new ObsBucket();
        bucket.setBucketName(bucketName);
        bucket.setLocation(request.getLocation());
        bucket.setAcl(acl);
        bucket.setBucketStorageClass(request.getBucketStorageClass());
        ObsService.setResponseHeaders(bucket, map);
        ObsService.setStatusCode(bucket, response.code());
        return bucket;
    }

    boolean prepareRESTHeaderAclForV2(Map<String, String> metadata, AccessControlList acl) {
        String restHeaderAclValue = null;
        if (acl == AccessControlList.REST_CANNED_PRIVATE) {
            restHeaderAclValue = "private";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_AUTHENTICATED_READ) {
            restHeaderAclValue = "authenticated-read";
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_READ) {
            restHeaderAclValue = "bucket-owner-read";
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL) {
            restHeaderAclValue = "bucket-owner-full-control";
        } else if (acl == AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE) {
            restHeaderAclValue = "log-delivery-write";
        }
        String aclHeader = this.getIHeaders().aclHeader();
        if (restHeaderAclValue != null) {
            metadata.put(aclHeader, restHeaderAclValue);
        }
        return metadata.containsKey(aclHeader);
    }

    boolean prepareRESTHeaderAclForOBS(Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        String restHeaderAclValue = null;
        boolean invalid = false;
        if (acl == AccessControlList.REST_CANNED_PRIVATE) {
            restHeaderAclValue = "private";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED) {
            restHeaderAclValue = "public-read-delivered";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED) {
            restHeaderAclValue = "public-read-write-delivered";
        } else if (acl == AccessControlList.REST_CANNED_AUTHENTICATED_READ) {
            restHeaderAclValue = "authenticated-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_READ) {
            restHeaderAclValue = "bucket-owner-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL) {
            restHeaderAclValue = "bucket-owner-full-control";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE) {
            restHeaderAclValue = "log-delivery-write";
            invalid = true;
        }
        if (invalid) {
            log.info("Invalid Canned ACL:" + restHeaderAclValue);
        }
        String aclHeader = this.getIHeaders().aclHeader();
        if (restHeaderAclValue != null) {
            metadata.put(aclHeader, restHeaderAclValue);
        }
        return metadata.containsKey(aclHeader);
    }

    boolean prepareRESTHeaderAclObject(Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        return this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS ? this.prepareRESTHeaderAclForOBSObject(metadata, acl) : this.prepareRESTHeaderAclForV2(metadata, acl);
    }

    boolean prepareRESTHeaderAclForOBSObject(Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        String restHeaderAclValue = null;
        boolean invalid = false;
        if (acl == AccessControlList.REST_CANNED_PRIVATE) {
            restHeaderAclValue = "private";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED) {
            restHeaderAclValue = "public-read";
        } else if (acl == AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED) {
            restHeaderAclValue = "public-read-write";
        } else if (acl == AccessControlList.REST_CANNED_AUTHENTICATED_READ) {
            restHeaderAclValue = "authenticated-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_READ) {
            restHeaderAclValue = "bucket-owner-read";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL) {
            restHeaderAclValue = "bucket-owner-full-control";
            invalid = true;
        } else if (acl == AccessControlList.REST_CANNED_LOG_DELIVERY_WRITE) {
            restHeaderAclValue = "log-delivery-write";
            invalid = true;
        }
        if (invalid) {
            log.info("Invalid Canned ACL:" + restHeaderAclValue);
        }
        String aclHeader = this.getIHeaders().aclHeader();
        if (restHeaderAclValue != null) {
            metadata.put(aclHeader, restHeaderAclValue);
        }
        return metadata.containsKey(aclHeader);
    }

    boolean prepareRESTHeaderAcl(Map<String, String> metadata, AccessControlList acl) throws ServiceException {
        return this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS ? this.prepareRESTHeaderAclForOBS(metadata, acl) : this.prepareRESTHeaderAclForV2(metadata, acl);
    }

    protected BucketLocationResponse getBucketLocationImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOCATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        BucketLocationResponse ret = new BucketLocationResponse(this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketLocationHandler.class, false).getLocation());
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected BucketLoggingConfiguration getBucketLoggingConfigurationImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOGGING.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        BucketLoggingConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketLoggingHandler.class, false).getBucketLoggingStatus();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    HeaderResponse setBucketLoggingConfigurationImpl(String bucketName, BucketLoggingConfiguration status) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOGGING.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String statusAsXml = status == null ? "" : this.getIConvertor().transBucketLoggingConfiguration(status);
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/xml", statusAsXml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    TransResult transPutObjectRequest(PutObjectRequest request) throws ServiceException {
        Object contentLength;
        Object contentType;
        HashMap<String, String> headers = new HashMap<String, String>();
        IConvertor iconvertor = this.getIConvertor();
        IHeaders iheaders = this.getIHeaders();
        ObjectMetadata objectMetadata = request.getMetadata() == null ? new ObjectMetadata() : request.getMetadata();
        for (Map.Entry<String, Object> entry : objectMetadata.getMetadata().entrySet()) {
            String key = entry.getKey();
            if (!ServiceUtils.isValid(key) || Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains((key = key.trim()).toLowerCase())) continue;
            headers.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
        }
        if (ServiceUtils.isValid(objectMetadata.getContentMd5())) {
            headers.put("Content-MD5", objectMetadata.getContentMd5().trim());
        }
        if (ServiceUtils.isValid(objectMetadata.getContentEncoding())) {
            headers.put("Content-Encoding", objectMetadata.getContentEncoding().trim());
        }
        if (objectMetadata.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(objectMetadata.getObjectStorageClass()));
        }
        if (request.getExpires() >= 0) {
            this.putHeader(headers, iheaders.expiresHeader(), String.valueOf(request.getExpires()));
        }
        if (objectMetadata.getWebSiteRedirectLocation() != null) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), objectMetadata.getWebSiteRedirectLocation());
        }
        if (request.getSuccessRedirectLocation() != null) {
            this.putHeader(headers, iheaders.successRedirectLocationHeader(), request.getSuccessRedirectLocation());
        }
        this.transExtensionPermissions(request, headers);
        this.transSseHeaders(request, headers, iheaders);
        Object object = contentType = objectMetadata.getContentType() == null ? objectMetadata.getValue("Content-Type") : objectMetadata.getContentType();
        if (contentType == null) {
            contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
        }
        if ((contentLength = objectMetadata.getContentLength()) == null) {
            contentLength = objectMetadata.getValue("Content-Length");
        }
        long _contentLength = contentLength == null ? -1L : Long.parseLong(contentLength.toString());
        InputStream input = null;
        if (request.getFile() != null) {
            if ("application/octet-stream".equals(contentType)) {
                contentType = Mimetypes.getInstance().getMimetype(request.getFile());
            }
            try {
                input = new FileInputStream(request.getFile());
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File doesnot exist", e);
            }
            long fileSize = request.getFile().length();
            if (request.getOffset() > 0L && request.getOffset() < fileSize) {
                _contentLength = _contentLength > 0L && _contentLength <= fileSize - request.getOffset() ? _contentLength : fileSize - request.getOffset();
                try {
                    input.skip(request.getOffset());
                }
                catch (IOException e) {
                    ServiceUtils.closeStream(input);
                    throw new ServiceException(e);
                }
            } else if (_contentLength < 0L || _contentLength > fileSize) {
                _contentLength = fileSize;
            }
            if (request.getProgressListener() != null) {
                SimpleProgressManager progressManager = new SimpleProgressManager(_contentLength, 0L, request.getProgressListener(), request.getProgressInterval() > 0L ? request.getProgressInterval() : 102400L);
                input = new ProgressInputStream(input, progressManager);
            }
        } else {
            input = request.getInput();
            if (input != null && request.getProgressListener() != null) {
                SimpleProgressManager progressManager = new SimpleProgressManager(_contentLength, 0L, request.getProgressListener(), request.getProgressInterval() > 0L ? request.getProgressInterval() : 102400L);
                input = new ProgressInputStream(input, progressManager);
            }
        }
        String _contentType = contentType.toString().trim();
        headers.put("Content-Type", _contentType);
        if (_contentLength > -1L) {
            this.putHeader(headers, "Content-Length", String.valueOf(_contentLength));
        }
        RepeatableRequestEntity body = input == null ? null : new RepeatableRequestEntity(input, _contentType, _contentLength, this.obsProperties);
        return new TransResult(headers, body);
    }

    TransResult transWriteFileRequest(WriteFileRequest request) throws ServiceException {
        TransResult result = this.transPutObjectRequest(request);
        if (request.getPosition() > 0L) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SpecialParamEnum.MODIFY.getOriginalStringCode(), "");
            params.put("position", String.valueOf(request.getPosition()));
            result.params = params;
        }
        return result;
    }

    TransResult transAppendObjectRequest(AppendObjectRequest request) throws ServiceException {
        TransResult result = this.transPutObjectRequest(request);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.APPEND.getOriginalStringCode(), "");
        params.put("position", String.valueOf(request.getPosition()));
        result.params = params;
        return result;
    }

    void transSseKmsHeaders(SseKmsHeader kmsHeader, Map<String, String> headers, IHeaders iheaders) {
        if (kmsHeader == null) {
            return;
        }
        String sseKmsEncryption = null;
        if (null != kmsHeader.getEncryption()) {
            sseKmsEncryption = this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "aws:" + kmsHeader.getEncryption().getServerEncryption() : kmsHeader.getEncryption().getServerEncryption();
        }
        this.putHeader(headers, iheaders.sseKmsHeader(), ServiceUtils.toValid(sseKmsEncryption));
        if (null != kmsHeader.getKmsKeyId()) {
            this.putHeader(headers, iheaders.sseKmsKeyHeader(), kmsHeader.getKmsKeyId());
        }
    }

    void transSseCHeaders(SseCHeader cHeader, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (cHeader == null) {
            return;
        }
        String sseCAlgorithm = null;
        if (null != cHeader.getAlgorithm()) {
            sseCAlgorithm = cHeader.getAlgorithm().getServerAlgorithm();
        }
        this.putHeader(headers, iheaders.sseCHeader(), ServiceUtils.toValid(sseCAlgorithm));
        if (cHeader.getSseCKeyBase64() != null) {
            try {
                this.putHeader(headers, iheaders.sseCKeyHeader(), cHeader.getSseCKeyBase64());
                this.putHeader(headers, iheaders.sseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(ServiceUtils.fromBase64(cHeader.getSseCKeyBase64()))));
            }
            catch (IOException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
        }
        if (null != cHeader.getSseCKey()) {
            try {
                byte[] data = cHeader.getSseCKey();
                this.putHeader(headers, iheaders.sseCKeyHeader(), ServiceUtils.toBase64(data));
                this.putHeader(headers, iheaders.sseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(data)));
            }
            catch (IOException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("fail to read sseCkey", e);
            }
        }
    }

    void transSseHeaders(PutObjectBasicRequest request, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (null != request.getSseCHeader()) {
            this.transSseCHeaders(request.getSseCHeader(), headers, iheaders);
        } else if (null != request.getSseKmsHeader()) {
            this.transSseKmsHeaders(request.getSseKmsHeader(), headers, iheaders);
        }
    }

    void transExtensionPermissions(PutObjectBasicRequest request, Map<String, String> headers) {
        Set<ExtensionObjectPermissionEnum> extensionPermissionEnums = request.getAllGrantPermissions();
        if (!extensionPermissionEnums.isEmpty()) {
            for (ExtensionObjectPermissionEnum extensionPermissionEnum : extensionPermissionEnums) {
                Set<String> domainIds = request.getDomainIdsByGrantPermission(extensionPermissionEnum);
                ArrayList<String> domainIdList = new ArrayList<String>(domainIds.size());
                for (String domainId : domainIds) {
                    domainIdList.add("id=" + domainId);
                }
                this.putHeader(headers, this.getHeaderByMethodName(extensionPermissionEnum.getCode()), ServiceUtils.join(domainIdList, ","));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppendObjectResult appendObjectImpl(AppendObjectRequest request) throws ServiceException {
        AppendObjectResult ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transAppendObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPost(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.body, true);
            }
            finally {
                if (result != null && result.body != null && request.isAutoClose()) {
                    RepeatableRequestEntity entity = (RepeatableRequestEntity)result.body;
                    ServiceUtils.closeStream(entity);
                }
            }
            String nextPosition = response.header(this.getIHeaders().nextPositionHeader());
            ret = new AppendObjectResult(request.getBucketName(), request.getObjectKey(), response.header("ETag"), nextPosition != null ? Long.parseLong(nextPosition) : -1L, StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey()));
            Map<String, Object> map = this.cleanResponseHeaders(response);
            ObsService.setResponseHeaders(ret, map);
            ObsService.setStatusCode(ret, response.code());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObsFSFile writeFileImpl(WriteFileRequest request) throws ServiceException {
        ObsFSFile ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transWriteFileRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.body, true);
            }
            finally {
                if (result != null && result.body != null && request.isAutoClose() && result.body instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)result.body);
                }
            }
            ret = new ObsFSFile(request.getBucketName(), request.getObjectKey(), response.header("ETag"), response.header(this.getIHeaders().versionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey()));
            Map<String, Object> map = this.cleanResponseHeaders(response);
            ObsService.setResponseHeaders(ret, map);
            ObsService.setStatusCode(ret, response.code());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObsFSFile putObjectImpl(PutObjectRequest request) throws ServiceException {
        ObsFSFile ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transPutObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), null, result.body, true);
            }
            finally {
                if (result != null && result.body != null && request.isAutoClose() && result.body instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)result.body);
                }
            }
            ret = new ObsFSFile(request.getBucketName(), request.getObjectKey(), response.header("ETag"), response.header(this.getIHeaders().versionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey()));
            Map<String, Object> map = this.cleanResponseHeaders(response);
            ObsService.setResponseHeaders(ret, map);
            ObsService.setStatusCode(ret, response.code());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    TransResult transCopyObjectRequest(CopyObjectRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        IConvertor iconvertor = this.getIConvertor();
        IHeaders iheaders = this.getIHeaders();
        ObjectMetadata objectMetadata = request.getNewObjectMetadata() == null ? new ObjectMetadata() : request.getNewObjectMetadata();
        this.putHeader(headers, iheaders.metadataDirectiveHeader(), request.isReplaceMetadata() ? "REPLACE" : "COPY");
        if (request.isReplaceMetadata()) {
            objectMetadata.getMetadata().remove(iheaders.requestIdHeader());
            objectMetadata.getMetadata().remove(iheaders.requestId2Header());
            for (Map.Entry<String, Object> entry : objectMetadata.getMetadata().entrySet()) {
                String key = entry.getKey();
                if (!ServiceUtils.isValid(key) || Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains((key = key.trim()).toLowerCase())) continue;
                headers.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
            }
        }
        if (objectMetadata.getContentType() != null) {
            headers.put("Content-Type", objectMetadata.getContentType().trim());
        }
        if (objectMetadata.getContentEncoding() != null) {
            headers.put("Content-Encoding", objectMetadata.getContentEncoding().trim());
        }
        if (objectMetadata.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(objectMetadata.getObjectStorageClass()));
        }
        if (objectMetadata.getWebSiteRedirectLocation() != null) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), objectMetadata.getWebSiteRedirectLocation());
        }
        if (request.getSuccessRedirectLocation() != null) {
            this.putHeader(headers, iheaders.successRedirectLocationHeader(), request.getSuccessRedirectLocation());
        }
        this.transExtensionPermissions(request, headers);
        this.transSseHeaders(request, headers, iheaders);
        this.transSseCSourceHeaders(request.getSseCHeaderSource(), headers, iheaders);
        this.transConditionCopyHeaders(request, headers, iheaders);
        String sourceKey = RestUtils.encodeUrlString(request.getSourceBucketName()) + "/" + RestUtils.encodeUrlString(request.getSourceObjectKey());
        if (ServiceUtils.isValid(request.getVersionId())) {
            sourceKey = sourceKey + "?versionId=" + request.getVersionId().trim();
        }
        this.putHeader(headers, iheaders.copySourceHeader(), sourceKey);
        return new TransResult(headers);
    }

    void transSseCSourceHeaders(SseCHeader sseCHeader, Map<String, String> headers, IHeaders iheaders) throws ServiceException {
        if (sseCHeader != null) {
            String algorithm = null;
            if (null != sseCHeader.getAlgorithm()) {
                algorithm = sseCHeader.getAlgorithm().getServerAlgorithm();
            }
            this.putHeader(headers, iheaders.copySourceSseCHeader(), ServiceUtils.toValid(algorithm));
            if (sseCHeader.getSseCKeyBase64() != null) {
                try {
                    this.putHeader(headers, iheaders.copySourceSseCKeyHeader(), sseCHeader.getSseCKeyBase64());
                    this.putHeader(headers, iheaders.copySourceSseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(ServiceUtils.fromBase64(sseCHeader.getSseCKeyBase64()))));
                }
                catch (IOException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
            }
            if (null != sseCHeader.getSseCKey()) {
                try {
                    byte[] data = sseCHeader.getSseCKey();
                    this.putHeader(headers, iheaders.copySourceSseCKeyHeader(), ServiceUtils.toBase64(data));
                    this.putHeader(headers, iheaders.copySourceSseCKeyMd5Header(), ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(data)));
                }
                catch (IOException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("fail to read sseCkey", e);
                }
            }
        }
    }

    void transConditionCopyHeaders(CopyObjectRequest request, Map<String, String> headers, IHeaders iheaders) {
        if (request.getIfModifiedSince() != null) {
            this.putHeader(headers, iheaders.copySourceIfModifiedSinceHeader(), ServiceUtils.formatRfc822Date(request.getIfModifiedSince()));
        }
        if (request.getIfUnmodifiedSince() != null) {
            this.putHeader(headers, iheaders.copySourceIfUnmodifiedSinceHeader(), ServiceUtils.formatRfc822Date(request.getIfUnmodifiedSince()));
        }
        if (ServiceUtils.isValid(request.getIfMatchTag())) {
            this.putHeader(headers, iheaders.copySourceIfMatchHeader(), request.getIfMatchTag().trim());
        }
        if (ServiceUtils.isValid(request.getIfNoneMatchTag())) {
            this.putHeader(headers, iheaders.copySourceIfNoneMatchHeader(), request.getIfNoneMatchTag().trim());
        }
    }

    protected CopyObjectResult copyObjectImpl(CopyObjectRequest request) throws ServiceException {
        CopyObjectResult copyRet;
        block4: {
            TransResult result = this.transCopyObjectRequest(request);
            AccessControlList acl = request.getAcl();
            boolean isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
            Response response = this.performRestPut(request.getDestinationBucketName(), request.getDestinationObjectKey(), result.getHeaders(), null, null, false);
            this.verifyResponseContentType(response);
            XmlResponsesSaxParser.CopyObjectResultHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CopyObjectResultHandler.class, false);
            copyRet = new CopyObjectResult(handler.getETag(), handler.getLastModified(), response.header(this.getIHeaders().versionIdHeader()), response.header(this.getIHeaders().copySourceVersionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())));
            Map<String, Object> map = this.cleanResponseHeaders(response);
            ObsService.setResponseHeaders(copyRet, map);
            ObsService.setStatusCode(copyRet, response.code());
            if (isExtraAclPutRequired && acl != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
                }
                try {
                    this.putAclImpl(request.getDestinationBucketName(), request.getDestinationObjectKey(), acl, null);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return copyRet;
    }

    protected ObsFSAttribute getObjectMetadataImpl(GetObjectMetadataRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders());
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
        return (ObsFSAttribute)this.getObjectImpl(true, request.getBucketName(), request.getObjectKey(), headers, params, null, -1L);
    }

    TransResult transSetObjectMetadataRequest(SetObjectMetadataRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders();
        IConvertor iconvertor = this.getIConvertor();
        for (Map.Entry<String, String> entry : request.getMetadata().entrySet()) {
            String key = entry.getKey();
            if (!ServiceUtils.isValid(key)) continue;
            key = key.trim();
            headers.put(key, entry.getValue() == null ? "" : entry.getValue().toString());
        }
        if (request.getObjectStorageClass() != null) {
            this.putHeader(headers, iheaders.storageClassHeader(), iconvertor.transStorageClass(request.getObjectStorageClass()));
        }
        if (request.getWebSiteRedirectLocation() != null) {
            this.putHeader(headers, iheaders.websiteRedirectLocationHeader(), request.getWebSiteRedirectLocation());
        }
        if (request.getContentDisposition() != null) {
            this.putHeader(headers, "Content-Disposition", request.getContentDisposition());
        }
        if (request.getContentEncoding() != null) {
            this.putHeader(headers, "Content-Encoding", request.getContentEncoding());
        }
        if (request.getContentLanguage() != null) {
            this.putHeader(headers, "Content-Language", request.getContentLanguage());
        }
        if (request.getContentType() != null) {
            this.putHeader(headers, "Content-Type", request.getContentType());
        }
        if (request.getCacheControl() != null) {
            this.putHeader(headers, "Cache-Control", request.getCacheControl());
        }
        if (request.getExpires() != null) {
            this.putHeader(headers, "Expires", request.getExpires());
        }
        this.putHeader(headers, iheaders.metadataDirectiveHeader(), request.isRemoveUnset() ? "REPLACE" : "REPLACE_NEW");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SpecialParamEnum.METADATA.getOriginalStringCode(), "");
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
        return new TransResult(headers, params, null);
    }

    protected ObjectMetadata setObjectMetadataImpl(SetObjectMetadataRequest request) {
        TransResult result = this.transSetObjectMetadataRequest(request);
        Response response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.headers, result.params, result.body, true);
        return this.getObsFSAttributeFromResponse(response);
    }

    TransResult transGetObjectRequest(GetObjectRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders());
        this.transConditionGetObjectHeaders(request, headers);
        if (request.getRangeStart() != null && request.getRangeEnd() != null) {
            String range = String.format("bytes=%s-%s", request.getRangeStart(), request.getRangeEnd());
            headers.put("Range", range);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        this.transGetObjectParams(request, params);
        return new TransResult(headers, params, null);
    }

    void transGetObjectParams(GetObjectRequest request, Map<String, String> params) {
        if (null != request.getReplaceMetadata()) {
            if (ServiceUtils.isValid(request.getReplaceMetadata().getCacheControl())) {
                params.put("response-cache-control", request.getReplaceMetadata().getCacheControl());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentDisposition())) {
                params.put("response-content-disposition", request.getReplaceMetadata().getContentDisposition());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentEncoding())) {
                params.put("response-content-encoding", request.getReplaceMetadata().getContentEncoding());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentLanguage())) {
                params.put("response-content-language", request.getReplaceMetadata().getContentLanguage());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getContentType())) {
                params.put("response-content-type", request.getReplaceMetadata().getContentType());
            }
            if (ServiceUtils.isValid(request.getReplaceMetadata().getExpires())) {
                params.put("response-expires", request.getReplaceMetadata().getExpires());
            }
        }
        if (ServiceUtils.isValid(request.getImageProcess())) {
            params.put("x-image-process", request.getImageProcess());
        }
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
    }

    void transConditionGetObjectHeaders(GetObjectRequest request, Map<String, String> headers) {
        if (request.getIfModifiedSince() != null) {
            headers.put("If-Modified-Since", ServiceUtils.formatRfc822Date(request.getIfModifiedSince()));
        }
        if (request.getIfUnmodifiedSince() != null) {
            headers.put("If-Unmodified-Since", ServiceUtils.formatRfc822Date(request.getIfUnmodifiedSince()));
        }
        if (ServiceUtils.isValid(request.getIfMatchTag())) {
            headers.put("If-Match", request.getIfMatchTag().trim());
        }
        if (ServiceUtils.isValid(request.getIfNoneMatchTag())) {
            headers.put("If-None-Match", request.getIfNoneMatchTag().trim());
        }
    }

    protected ObsObject getObjectImpl(GetObjectRequest request) throws ServiceException {
        TransResult result = this.transGetObjectRequest(request);
        return (ObsObject)this.getObjectImpl(false, request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), request.getProgressListener(), request.getProgressInterval());
    }

    private ObsFSAttribute getObsFSAttributeFromResponse(Response response) {
        ObsFSAttribute objMetadata;
        block15: {
            String fsMode;
            block14: {
                Date _lastModified;
                block13: {
                    _lastModified = null;
                    String lastModified = response.header("Last-Modified");
                    if (lastModified != null) {
                        try {
                            _lastModified = ServiceUtils.parseRfc822Date(lastModified);
                        }
                        catch (ParseException e) {
                            if (!log.isWarnEnabled()) break block13;
                            log.warn("Response last-modified is not well-format", e);
                        }
                    }
                }
                objMetadata = new ObsFSAttribute();
                objMetadata.setLastModified(_lastModified);
                objMetadata.setContentEncoding(response.header("Content-Encoding"));
                objMetadata.setContentType(response.header("Content-Type"));
                String contentLength = response.header("Content-Length");
                if (contentLength != null) {
                    try {
                        objMetadata.setContentLength(Long.parseLong(contentLength));
                    }
                    catch (NumberFormatException e) {
                        if (!log.isWarnEnabled()) break block14;
                        log.warn("Response content-length is not well-format", e);
                    }
                }
            }
            if ((fsMode = response.header(this.getIHeaders().fsModeHeader())) != null) {
                objMetadata.setMode(Integer.parseInt(fsMode));
            }
            objMetadata.setWebSiteRedirectLocation(response.header(this.getIHeaders().websiteRedirectLocationHeader()));
            objMetadata.setObjectStorageClass(StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())));
            String etag = response.header("ETag");
            objMetadata.setEtag(etag);
            if (etag != null && !etag.contains("-")) {
                String md5 = etag;
                if (md5.startsWith("\"")) {
                    md5 = md5.substring(1);
                }
                if (md5.endsWith("\"")) {
                    md5 = md5.substring(0, md5.length() - 1);
                }
                try {
                    objMetadata.setContentMd5(ServiceUtils.toBase64(ServiceUtils.fromHex(md5)));
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block15;
                    log.debug(e.getMessage(), e);
                }
            }
        }
        objMetadata.setAppendable("Appendable".equals(response.header(this.getIHeaders().objectTypeHeader())));
        if (objMetadata.isAppendable()) {
            String nextPosition = response.header(this.getIHeaders().nextPositionHeader());
            objMetadata.setNextPosition(nextPosition == null ? -1L : Long.parseLong(nextPosition));
        }
        objMetadata.getMetadata().putAll(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(objMetadata, response.code());
        return objMetadata;
    }

    protected Object getObjectImpl(boolean headOnly, String bucketName, String objectKey, Map<String, String> headers, Map<String, String> params, ProgressListener progressListener, long progressInterval) throws ServiceException {
        int readBufferSize;
        Response response = headOnly ? this.performRestHead(bucketName, objectKey, params, headers) : this.performRestGet(bucketName, objectKey, params, headers);
        ObsFSAttribute objMetadata = this.getObsFSAttributeFromResponse(response);
        if (headOnly) {
            response.close();
            return objMetadata;
        }
        ReadFileResult obsObject = new ReadFileResult();
        obsObject.setObjectKey(objectKey);
        obsObject.setBucketName(bucketName);
        obsObject.setMetadata(objMetadata);
        InputStream input = response.body().byteStream();
        if (progressListener != null) {
            SimpleProgressManager progressManager = new SimpleProgressManager(objMetadata.getContentLength(), 0L, progressListener, progressInterval > 0L ? progressInterval : 102400L);
            input = new ProgressInputStream(input, progressManager);
        }
        if ((readBufferSize = this.obsProperties.getIntProperty("httpclient.read-buffer-size", 8192)) > 0) {
            input = new BufferedInputStream(input, readBufferSize);
        }
        obsObject.setObjectContent(input);
        return obsObject;
    }

    protected BucketQuota getBucketQuotaImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.QUOTA.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        BucketQuota ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketQuotaHandler.class, false).getQuota();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected BucketStoragePolicyConfiguration getBucketStoragePolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(this.getSpecialParamForStorageClass().getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        BucketStoragePolicyConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketStoragePolicyHandler.class, false).getStoragePolicy();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected BucketStorageInfo getBucketStorageInfoImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.STORAGEINFO.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        BucketStorageInfo ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketStorageInfoHandler.class, false).getStorageInfo();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected AccessControlList getBucketAclImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        AccessControlList ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.AccessControlListHandler.class, false).getAccessControlList();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected AccessControlList getObjectAclImpl(String bucketName, String objectKey, String versionId) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        if (ServiceUtils.isValid(versionId)) {
            requestParameters.put("versionId", versionId.trim());
        }
        Response httpResponse = this.performRestGet(bucketName, objectKey, requestParameters, null);
        this.verifyResponseContentType(httpResponse);
        AccessControlList ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.AccessControlListHandler.class, false).getAccessControlList();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected DeleteObjectResult deleteObjectImpl(String bucketName, String objectKey, String versionId) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (versionId != null) {
            requestParameters.put("versionId", versionId);
        }
        Response response = this.performRestDelete(bucketName, objectKey, requestParameters);
        DeleteObjectResult result = new DeleteObjectResult(Boolean.valueOf(response.header(this.getIHeaders().deleteMarkerHeader())), response.header(this.getIHeaders().versionIdHeader()));
        Map<String, Object> map = this.cleanResponseHeaders(response);
        ObsService.setResponseHeaders(result, map);
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    TransResult transListObjectsRequest(ListObjectsRequest listObjectsRequest) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (listObjectsRequest.getPrefix() != null) {
            params.put("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            params.put("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() > 0) {
            params.put("max-keys", String.valueOf(listObjectsRequest.getMaxKeys()));
        }
        if (listObjectsRequest.getMarker() != null) {
            params.put("marker", listObjectsRequest.getMarker());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (listObjectsRequest.getListTimeout() > 0) {
            this.putHeader(headers, this.getIHeaders().listTimeoutHeader(), String.valueOf(listObjectsRequest.getListTimeout()));
        }
        return new TransResult(headers, params, null);
    }

    protected ObjectListing listObjectsImpl(ListObjectsRequest listObjectsRequest) throws ServiceException {
        TransResult result = this.transListObjectsRequest(listObjectsRequest);
        Response httpResponse = this.performRestGet(listObjectsRequest.getBucketName(), null, result.getParams(), null);
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListObjectsHandler listObjectsHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListObjectsHandler.class, true);
        ObjectListing objList = new ObjectListing(listObjectsHandler.getObjects(), listObjectsHandler.getCommonPrefixes(), listObjectsHandler.getBucketName() == null ? listObjectsRequest.getBucketName() : listObjectsHandler.getBucketName(), listObjectsHandler.isListingTruncated(), listObjectsHandler.getRequestPrefix() == null ? listObjectsRequest.getPrefix() : listObjectsHandler.getRequestPrefix(), listObjectsHandler.getRequestMarker() == null ? listObjectsRequest.getMarker() : listObjectsHandler.getRequestMarker(), listObjectsHandler.getRequestMaxKeys(), listObjectsHandler.getRequestDelimiter() == null ? listObjectsRequest.getDelimiter() : listObjectsHandler.getRequestDelimiter(), listObjectsHandler.getMarkerForNextListing(), httpResponse.header(this.getIHeaders().bucketRegionHeader()));
        ObsService.setResponseHeaders(objList, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(objList, httpResponse.code());
        return objList;
    }

    protected ListBucketsResult listAllBucketsImpl(ListBucketsRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request != null && request.isQueryLocation()) {
            this.putHeader(headers, this.getIHeaders().locationHeader(), "true");
        }
        Response httpResponse = this.performRestGet("", null, null, headers);
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListBucketsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListBucketsHandler.class, true);
        Map<String, Object> responseHeaders = this.cleanResponseHeaders(httpResponse);
        ListBucketsResult result = new ListBucketsResult(handler.getBuckets(), handler.getOwner());
        ObsService.setResponseHeaders(result, responseHeaders);
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected HeaderResponse setBucketLoggingConfigurationImpl(String bucketName, BucketLoggingConfiguration status, boolean updateTargetACLifRequired) throws ServiceException {
        if (status.isLoggingEnabled() && updateTargetACLifRequired && this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS) {
            boolean isSetLoggingGroupWrite = false;
            boolean isSetLoggingGroupReadACP = false;
            String groupIdentifier = "http://acs.amazonaws.com/groups/s3/LogDelivery";
            AccessControlList logBucketACL = this.getBucketAclImpl(status.getTargetBucketName());
            for (GrantAndPermission gap : logBucketACL.getGrantAndPermissions()) {
                if (!(gap.getGrantee() instanceof GroupGrantee)) continue;
                GroupGrantee grantee = (GroupGrantee)gap.getGrantee();
                if (!groupIdentifier.equals(this.getIConvertor().transGroupGrantee(grantee.getGroupGranteeType()))) continue;
                if (Permission.PERMISSION_WRITE.equals(gap.getPermission())) {
                    isSetLoggingGroupWrite = true;
                    continue;
                }
                if (!Permission.PERMISSION_READ_ACP.equals(gap.getPermission())) continue;
                isSetLoggingGroupReadACP = true;
            }
            if (!isSetLoggingGroupWrite || !isSetLoggingGroupReadACP) {
                if (log.isWarnEnabled()) {
                    log.warn("Target logging bucket '" + status.getTargetBucketName() + "' does not have the necessary ACL settings, updating ACL now");
                }
                if (logBucketACL.getOwner() != null) {
                    logBucketACL.getOwner().setDisplayName(null);
                }
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_WRITE);
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_READ_ACP);
                this.setBucketAclImpl(status.getTargetBucketName(), null, logBucketACL);
            } else if (log.isDebugEnabled()) {
                log.debug("Target logging bucket '" + status.getTargetBucketName() + "' has the necessary ACL settings");
            }
        }
        return this.setBucketLoggingConfigurationImpl(bucketName, status);
    }

    protected HeaderResponse deleteBucketImpl(String bucketName) throws ServiceException {
        Response response = this.performRestDelete(bucketName, null, null);
        return this.build(response);
    }

    Map<String, Object> cleanResponseHeaders(Response response) {
        Map map = response.headers().toMultimap();
        return ServiceUtils.cleanRestMetadataMap(map, this.getIHeaders().headerPrefix(), this.getIHeaders().headerMetaPrefix());
    }

    TransResult transUploadPartRequest(UploadPartRequest request) throws ServiceException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("partNumber", String.valueOf(request.getPartNumber()));
        params.put("uploadId", request.getUploadId());
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders();
        if (ServiceUtils.isValid(request.getContentMd5())) {
            headers.put("Content-MD5", request.getContentMd5().trim());
        }
        this.transSseCHeaders(request.getSseCHeader(), headers, iheaders);
        InputStream input = null;
        long contentLength = -1L;
        if (null != request.getFile()) {
            long partSize;
            long fileSize = request.getFile().length();
            long offset = request.getOffset() >= 0L && request.getOffset() < fileSize ? request.getOffset() : 0L;
            contentLength = partSize = request.getPartSize() != null && request.getPartSize() > 0L && request.getPartSize() <= fileSize - offset ? request.getPartSize() : fileSize - offset;
            try {
                if (request.isAttachMd5() && !ServiceUtils.isValid(request.getContentMd5())) {
                    headers.put("Content-MD5", ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(new FileInputStream(request.getFile()), partSize, offset)));
                }
                input = new FileInputStream(request.getFile());
                input.skip(offset);
            }
            catch (Exception e) {
                ServiceUtils.closeStream(input);
                throw new ServiceException(e);
            }
            if (request.getProgressListener() != null) {
                SimpleProgressManager progressManager = new SimpleProgressManager(contentLength, 0L, request.getProgressListener(), request.getProgressInterval() > 0L ? request.getProgressInterval() : 102400L);
                input = new ProgressInputStream(input, progressManager);
            }
        } else if (null != request.getInput()) {
            if (request.getPartSize() != null && request.getPartSize() > 0L) {
                contentLength = request.getPartSize();
            }
            if ((input = request.getInput()) != null && request.getProgressListener() != null) {
                SimpleProgressManager progressManager = new SimpleProgressManager(contentLength, 0L, request.getProgressListener(), request.getProgressInterval() > 0L ? request.getProgressInterval() : 102400L);
                input = new ProgressInputStream(input, progressManager);
            }
        }
        String contentType = Mimetypes.getInstance().getMimetype(request.getObjectKey());
        headers.put("Content-Type", contentType);
        if (contentLength > -1L) {
            this.putHeader(headers, "Content-Length", String.valueOf(contentLength));
        }
        RepeatableRequestEntity body = input == null ? null : new RepeatableRequestEntity(input, contentType, contentLength, this.obsProperties);
        return new TransResult(headers, params, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UploadPartResult uploadPartImpl(UploadPartRequest request) throws ServiceException {
        Response response;
        TransResult result = null;
        try {
            result = this.transUploadPartRequest(request);
            response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.body, true);
        }
        finally {
            if (result != null && result.body != null && request.isAutoClose()) {
                RepeatableRequestEntity entity = (RepeatableRequestEntity)result.body;
                ServiceUtils.closeStream(entity);
            }
        }
        UploadPartResult ret = new UploadPartResult();
        ret.setEtag(response.header("ETag"));
        ret.setPartNumber(request.getPartNumber());
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    TransResult transCopyPartRequest(CopyPartRequest request) throws ServiceException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("partNumber", String.valueOf(request.getPartNumber()));
        params.put("uploadId", request.getUploadId());
        HashMap<String, String> headers = new HashMap<String, String>();
        IHeaders iheaders = this.getIHeaders();
        String sourceKey = RestUtils.encodeUrlString(request.getSourceBucketName()) + "/" + RestUtils.encodeUrlString(request.getSourceObjectKey());
        if (ServiceUtils.isValid(request.getVersionId())) {
            sourceKey = sourceKey + "?versionId=" + request.getVersionId().trim();
        }
        this.putHeader(headers, iheaders.copySourceHeader(), sourceKey);
        if (request.getByteRangeStart() != null && request.getByteRangeEnd() != null) {
            String range = String.format("bytes=%s-%s", request.getByteRangeStart(), request.getByteRangeEnd());
            this.putHeader(headers, iheaders.copySourceRangeHeader(), range);
        }
        this.transSseCHeaders(request.getSseCHeaderDestination(), headers, iheaders);
        this.transSseCSourceHeaders(request.getSseCHeaderSource(), headers, iheaders);
        return new TransResult(headers, params, null);
    }

    protected CopyPartResult copyPartImpl(CopyPartRequest request) throws ServiceException {
        TransResult result = this.transCopyPartRequest(request);
        Response response = this.performRestPut(request.getDestinationBucketName(), request.getDestinationObjectKey(), result.getHeaders(), result.getParams(), null, false);
        this.verifyResponseContentType(response);
        CopyPartResult ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CopyPartResultHandler.class, true).getCopyPartResult(request.getPartNumber());
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    HeaderResponse build(Response res) {
        HeaderResponse response = new HeaderResponse();
        ObsService.setResponseHeaders(response, this.cleanResponseHeaders(res));
        ObsService.setStatusCode(response, res.code());
        return response;
    }

    static HeaderResponse build(Map<String, Object> responseHeaders) {
        HeaderResponse response = new HeaderResponse();
        ObsService.setResponseHeaders(response, responseHeaders);
        return response;
    }

    static void setStatusCode(HeaderResponse response, int statusCode) {
        response.setStatusCode(statusCode);
    }

    static void setResponseHeaders(HeaderResponse response, Map<String, Object> responseHeaders) {
        response.setResponseHeaders(responseHeaders);
    }

    private String getObjectUrl(String bucketName, String objectKey) {
        boolean pathStyle = this.isPathStyle();
        boolean https = this.getHttpsOnly();
        boolean isCname = this.isCname();
        return (https ? "https://" : "http://") + (pathStyle || isCname ? "" : bucketName + ".") + this.getEndpoint() + ":" + (https ? this.getHttpsPort() : this.getHttpPort()) + "/" + (pathStyle ? bucketName + "/" : "") + RestUtils.uriEncode(objectKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthTypeEnum getApiVersion(String bucketName) throws ServiceException {
        if (!ServiceUtils.isValid(bucketName)) {
            return this.parseAuthTypeInResponse("");
        }
        AuthTypeEnum apiVersion = this.apiVersionCache.getApiVersionInCache(bucketName);
        if (apiVersion == null) {
            try {
                this.segmentLock.lock(bucketName);
                apiVersion = this.apiVersionCache.getApiVersionInCache(bucketName);
                if (apiVersion == null) {
                    apiVersion = this.parseAuthTypeInResponse(bucketName);
                    this.apiVersionCache.addApiVersion(bucketName, apiVersion);
                }
            }
            finally {
                this.segmentLock.unlock(bucketName);
            }
        }
        return apiVersion;
    }

    private AuthTypeEnum parseAuthTypeInResponse(String bucketName) throws ServiceException {
        String apiVersion;
        Response response;
        try {
            response = this.getAuthTypeNegotiationResponseImpl(bucketName);
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404 || e.getResponseCode() <= 0 || e.getResponseCode() == 408 || e.getResponseCode() >= 500) {
                throw e;
            }
            return AuthTypeEnum.V2;
        }
        return response.code() == 200 && (apiVersion = response.headers().get("x-obs-api")) != null && apiVersion.compareTo("3.0") >= 0 ? AuthTypeEnum.OBS : AuthTypeEnum.V2;
    }

    private Response getAuthTypeNegotiationResponseImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("apiversion", "");
        return this.performRestForApiVersion(bucketName, null, requestParameters, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransResult {
        private Map<String, String> headers;
        private Map<String, String> params;
        private RequestBody body;

        TransResult(Map<String, String> headers) {
            this(headers, null, null);
        }

        TransResult(Map<String, String> headers, RequestBody body) {
            this(headers, null, body);
        }

        TransResult(Map<String, String> headers, Map<String, String> params, RequestBody body) {
            this.headers = headers;
            this.params = params;
            this.body = body;
        }

        Map<String, String> getHeaders() {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            return this.headers;
        }

        Map<String, String> getParams() {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            return this.params;
        }
    }
}

