/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.thirdparty.com.fasterxml.jackson.annotation.JsonProperty;
import com.qcloud.cos.transfer.PersistableTransfer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class PersistableResumeDownload
extends PersistableTransfer {
    static final String TYPE = "resumedownload";
    @JsonProperty
    private final String pauseType = "resumedownload";
    @JsonProperty
    private final long lastModified;
    @JsonProperty
    private final String contentLength;
    @JsonProperty
    private final String etag;
    @JsonProperty
    private final String crc64ecma;
    @JsonProperty
    private final HashMap<String, Integer> downloadedBlocks;
    private File dumpFile;

    public PersistableResumeDownload() {
        this(0L, null, null, null, null);
    }

    public PersistableResumeDownload(@JsonProperty(value="lastModified") long lastModified, @JsonProperty(value="contentLength") String contentLength, @JsonProperty(value="etag") String etag, @JsonProperty(value="crc64ecma") String crc64ecma, @JsonProperty(value="downloadedBlocks") HashMap<String, Integer> downloadedBlocks) {
        this.lastModified = lastModified;
        this.contentLength = contentLength;
        this.etag = etag;
        this.crc64ecma = crc64ecma;
        this.downloadedBlocks = downloadedBlocks;
    }

    long getLastModified() {
        return this.lastModified;
    }

    String getContentLength() {
        return this.contentLength;
    }

    String getEtag() {
        return this.etag;
    }

    String getCrc64ecma() {
        return this.crc64ecma;
    }

    HashMap<String, Integer> getDownloadedBlocks() {
        return this.downloadedBlocks;
    }

    public synchronized void putDownloadedBlocks(String block) {
        this.downloadedBlocks.put(block, 1);
    }

    public synchronized boolean hasDownloadedBlocks(String block) {
        return this.downloadedBlocks.getOrDefault(block, 0) == 1;
    }

    public synchronized void reset() {
        this.downloadedBlocks.clear();
    }

    public void setDumpFile(File dumpFile) {
        this.dumpFile = dumpFile;
    }

    public File getDumpFile() {
        return this.dumpFile;
    }

    public synchronized void dump() throws Exception {
        FileOutputStream out = new FileOutputStream(this.dumpFile);
        this.serialize(out);
        ((OutputStream)out).close();
    }
}

