/*
 * Decompiled with CFR 0.152.
 */
package shade.kotlin.time;

import java.util.concurrent.TimeUnit;
import shade.jetbrains.annotations.NotNull;
import shade.kotlin.Metadata;
import shade.kotlin.SinceKotlin;
import shade.kotlin.jvm.internal.DefaultConstructorMarker;
import shade.kotlin.jvm.internal.Intrinsics;
import shade.kotlin.time.Duration;
import shade.kotlin.time.DurationKt;
import shade.kotlin.time.ExperimentalTime;
import shade.kotlin.time.TimeMark;
import shade.kotlin.time.TimeSource;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\fB\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH$R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lshade/kotlin/time/AbstractDoubleTimeSource;", "Lshade/kotlin/time/TimeSource;", "unit", "Ljava/util/concurrent/TimeUnit;", "Lshade/kotlin/time/DurationUnit;", "(Ljava/util/concurrent/TimeUnit;)V", "getUnit", "()Ljava/util/concurrent/TimeUnit;", "markNow", "Lshade/kotlin/time/TimeMark;", "read", "", "DoubleTimeMark", "shade.kotlin-stdlib"})
@SinceKotlin(version="1.3")
@ExperimentalTime
public abstract class AbstractDoubleTimeSource
implements TimeSource {
    @NotNull
    private final TimeUnit unit;

    protected abstract double read();

    @Override
    @NotNull
    public TimeMark markNow() {
        return new DoubleTimeMark(this.read(), this, Duration.Companion.getZERO(), null);
    }

    @NotNull
    protected final TimeUnit getUnit() {
        return this.unit;
    }

    public AbstractDoubleTimeSource(@NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        this.unit = unit;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u0007H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0007H\u0096\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lshade/kotlin/time/AbstractDoubleTimeSource$DoubleTimeMark;", "Lshade/kotlin/time/TimeMark;", "startedAt", "", "timeSource", "Lshade/kotlin/time/AbstractDoubleTimeSource;", "offset", "Lshade/kotlin/time/Duration;", "(DLkotlin/time/AbstractDoubleTimeSource;DLkotlin/jvm/internal/DefaultConstructorMarker;)V", "D", "elapsedNow", "()D", "plus", "duration", "plus-LRDsOJo", "(D)Lkotlin/time/TimeMark;", "shade.kotlin-stdlib"})
    private static final class DoubleTimeMark
    extends TimeMark {
        private final double startedAt;
        private final AbstractDoubleTimeSource timeSource;
        private final double offset;

        @Override
        public double elapsedNow() {
            return Duration.minus-LRDsOJo(DurationKt.toDuration(this.timeSource.read() - this.startedAt, this.timeSource.getUnit()), this.offset);
        }

        @Override
        @NotNull
        public TimeMark plus-LRDsOJo(double duration) {
            return new DoubleTimeMark(this.startedAt, this.timeSource, Duration.plus-LRDsOJo(this.offset, duration), null);
        }

        private DoubleTimeMark(double startedAt, AbstractDoubleTimeSource timeSource, double offset) {
            this.startedAt = startedAt;
            this.timeSource = timeSource;
            this.offset = offset;
        }

        public /* synthetic */ DoubleTimeMark(double startedAt, AbstractDoubleTimeSource timeSource, double offset, DefaultConstructorMarker $constructor_marker) {
            this(startedAt, timeSource, offset);
        }
    }
}

