/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import java.io.EOFException;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.obs.MultiReadTask;
import org.apache.hadoop.fs.obs.OBSFileSystem;
import org.apache.hadoop.fs.obs.OBSInputPolicy;
import org.apache.hadoop.fs.obs.OBSInstrumentation;
import org.apache.hadoop.fs.obs.OBSUtils;
import org.apache.hadoop.fs.obs.ReadBuffer;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OBSReadaheadInputStream
extends FSInputStream
implements CanSetReadahead {
    private volatile boolean closed;
    private final FileSystem.Statistics stats;
    private final ObsClient client;
    private final String bucket;
    private final String key;
    private final long contentLength;
    private final String uri;
    public static final Logger LOG = OBSFileSystem.LOG;
    private final OBSInstrumentation.InputStreamStatistics streamStatistics;
    private final OBSInputPolicy inputPolicy;
    private long readahead = 65536L;
    private ThreadPoolExecutor readThreadPool;
    private int bufferPartSize;
    private Deque<ReadBuffer> buffers = new LinkedList<ReadBuffer>();
    private int readPartRemain;
    private byte[] buffer;
    private long bufferStart;
    private final long MAX_RANGE;
    private long nextReadPos;
    private long contentRangeFinish;
    private long contentRangeStart;

    public OBSReadaheadInputStream(String bucket, String key, long contentLength, ObsClient client, FileSystem.Statistics stats, OBSInstrumentation instrumentation, long readahead, OBSInputPolicy inputPolicy, ThreadPoolExecutor readThreadPool, int bufferPartSize, long maxRange) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)bucket), (Object)"No Bucket");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)key), (Object)"No Key");
        Preconditions.checkArgument((contentLength >= 0L ? 1 : 0) != 0, (Object)"Negative content length");
        this.bucket = bucket;
        this.key = key;
        this.contentLength = contentLength;
        this.client = client;
        this.stats = stats;
        this.uri = "obs://" + this.bucket + "/" + this.key;
        this.streamStatistics = instrumentation.newInputStreamStatistics();
        this.inputPolicy = inputPolicy;
        this.setReadahead(readahead);
        this.readThreadPool = readThreadPool;
        this.bufferPartSize = bufferPartSize;
        this.MAX_RANGE = maxRange;
        this.nextReadPos = 0L;
        this.bufferStart = -1L;
    }

    private synchronized void applyBuffersWithinRange(long targetPos, long length, boolean append) {
        Future<Void> task;
        ReadBuffer readBuffer;
        long tmpTargetPos;
        long tmpEndPos;
        if (targetPos >= this.contentRangeFinish) {
            return;
        }
        if (length > this.contentRangeFinish) {
            length = this.contentRangeFinish;
        }
        boolean randomReadBuffered = false;
        LinkedList<ReadBuffer> tmpBuffers = new LinkedList<ReadBuffer>();
        while (length - targetPos > (long)this.bufferPartSize) {
            tmpEndPos = targetPos + (long)this.bufferPartSize - 1L;
            tmpTargetPos = targetPos;
            readBuffer = new ReadBuffer(tmpTargetPos, tmpEndPos);
            task = this.readThreadPool.submit(new MultiReadTask(this.bucket, this.key, this.client, readBuffer));
            readBuffer.setTask(task);
            tmpBuffers.offer(readBuffer);
            targetPos += (long)this.bufferPartSize;
        }
        tmpEndPos = length - 1L;
        tmpTargetPos = targetPos;
        if (!randomReadBuffered) {
            readBuffer = new ReadBuffer(tmpTargetPos, tmpEndPos);
            if (readBuffer.getBuffer().length == 0) {
                readBuffer.setState(ReadBuffer.STATE.FINISH);
            } else {
                task = this.readThreadPool.submit(new MultiReadTask(this.bucket, this.key, this.client, readBuffer));
                readBuffer.setTask(task);
            }
            tmpBuffers.offer(readBuffer);
        }
        if (append) {
            while (!tmpBuffers.isEmpty()) {
                this.buffers.offer((ReadBuffer)tmpBuffers.poll());
            }
        } else {
            while (!tmpBuffers.isEmpty()) {
                this.buffers.offerFirst((ReadBuffer)tmpBuffers.pollLast());
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("hello");
        LinkedList<ReadBuffer> deque = new LinkedList<ReadBuffer>();
        deque.offer(new ReadBuffer(1L, 2L));
        deque.offer(new ReadBuffer(2L, 3L));
        deque.offer(new ReadBuffer(3L, 4L));
        deque.offer(new ReadBuffer(4L, 5L));
        ReadBuffer a = (ReadBuffer)deque.peek();
        Iterator iterator = deque.descendingIterator();
        while (deque.size() != 0) {
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            System.out.println(a);
            System.out.println(deque);
            System.out.println(deque.peek());
        }
    }

    private synchronized void closeAndClearBuffers() {
        for (ReadBuffer buffer : this.buffers) {
            if (buffer.getTask() == null) continue;
            buffer.getTask().cancel(true);
        }
        this.buffers.clear();
    }

    private synchronized void reopen(String reason, long targetPos, long length) throws IOException {
        if (targetPos < 0L) {
            throw new IOException("io exception");
        }
        this.contentRangeFinish = OBSReadaheadInputStream.calculateRequestLimit(this.inputPolicy, targetPos, length, this.contentLength, this.readahead);
        LOG.debug("reopen({}) for {} range[{}-{}], length={}, , nextReadPosition={}", new Object[]{this.uri, reason, targetPos, this.contentRangeFinish, length, this.nextReadPos});
        this.contentRangeStart = targetPos;
        this.streamStatistics.streamOpened();
        boolean bufferExist = false;
        while (this.buffers.size() != 0) {
            ReadBuffer buf;
            Iterator<ReadBuffer> iterator;
            ReadBuffer buffer = this.buffers.peek();
            ReadBuffer lastbuffer = this.buffers.peekLast();
            if (buffer.getStart() <= targetPos && targetPos <= buffer.getEnd()) {
                bufferExist = true;
                break;
            }
            if (targetPos < buffer.getStart()) {
                ReadBuffer buf2;
                iterator = this.buffers.descendingIterator();
                while (iterator.hasNext() && (buf2 = iterator.next()).getEnd() - targetPos > this.MAX_RANGE) {
                    if (buf2.getTask() != null) {
                        buf2.getTask().cancel(true);
                    }
                    iterator.remove();
                }
                buffer = this.buffers.peek();
                lastbuffer = this.buffers.peekLast();
                if (buffer == null) {
                    this.applyBuffersWithinRange(targetPos, targetPos + this.MAX_RANGE, false);
                } else {
                    if (lastbuffer.getEnd() - targetPos != this.MAX_RANGE) {
                        this.applyBuffersWithinRange(lastbuffer.getEnd() + 1L, targetPos + this.MAX_RANGE, true);
                    }
                    this.applyBuffersWithinRange(targetPos, buffer.getStart(), false);
                }
                bufferExist = true;
                break;
            }
            if (targetPos > lastbuffer.getEnd()) {
                this.closeAndClearBuffers();
                continue;
            }
            iterator = this.buffers.iterator();
            while (iterator.hasNext() && (buf = iterator.next()).getEnd() < targetPos) {
                if (buf.getTask() != null) {
                    buf.getTask().cancel(true);
                }
                iterator.remove();
            }
            buffer = this.buffers.peek();
            lastbuffer = this.buffers.peekLast();
            if (lastbuffer.getEnd() < buffer.getStart() + this.MAX_RANGE) {
                this.applyBuffersWithinRange(lastbuffer.getEnd() + 1L, buffer.getStart() + this.MAX_RANGE, true);
            }
            bufferExist = true;
            break;
        }
        boolean randomReadBuffered = false;
        try {
            ReadBuffer readBuffer;
            if (!bufferExist) {
                this.applyBuffersWithinRange(targetPos, targetPos + this.MAX_RANGE, false);
            }
            if ((readBuffer = this.buffers.peek()) == null) {
                this.buffer = null;
                this.bufferStart = -1L;
                this.readPartRemain = 0;
                throw new IOException("exception null buffer");
            }
            try {
                readBuffer.getTask().get();
                if (ReadBuffer.STATE.ERROR.equals((Object)readBuffer.getState())) {
                    this.buffer = null;
                    this.readPartRemain = 0;
                    this.bufferStart = -1L;
                }
                this.buffer = readBuffer.getBuffer();
                this.readPartRemain = (int)(readBuffer.getEnd() - targetPos + 1L);
                this.bufferStart = readBuffer.getStart();
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted waiting for reading data");
            }
            catch (ExecutionException e) {
                this.buffer = null;
                this.readPartRemain = 0;
                this.bufferStart = -1L;
                LOG.warn("Execute get buffer task fail cause: ", e.getCause());
            }
        }
        catch (ObsException e) {
            throw OBSUtils.translateException("Reopen at position " + targetPos, this.uri, e);
        }
    }

    public synchronized long getPos() throws IOException {
        return this.nextReadPos < 0L ? 0L : this.nextReadPos;
    }

    public synchronized void seek(long targetPos) throws IOException {
        this.checkNotClosed();
        if (targetPos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + targetPos);
        }
        if (this.contentLength <= 0L) {
            return;
        }
        if (this.bufferStart != -1L) {
            long bufferEnd = this.bufferStart + (long)this.buffer.length - 1L;
            this.readPartRemain = targetPos >= this.bufferStart && targetPos <= bufferEnd ? (int)(bufferEnd - targetPos + 1L) : 0;
        }
        this.nextReadPos = targetPos;
    }

    private void seekQuietly(long positiveTargetPos) {
        try {
            this.seek(positiveTargetPos);
        }
        catch (IOException ioe) {
            LOG.debug("Ignoring IOE on seek of {} to {}", new Object[]{this.uri, positiveTargetPos, ioe});
        }
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized int read() throws IOException {
        this.checkNotClosed();
        if (this.contentLength == 0L || this.nextReadPos >= this.contentLength) {
            return -1;
        }
        if (this.readPartRemain <= 0 && this.nextReadPos < this.contentLength) {
            this.reopen("open", this.nextReadPos, this.contentLength);
        }
        int byteRead = -1;
        if (this.readPartRemain != 0) {
            byteRead = this.buffer[this.buffer.length - this.readPartRemain] & 0xFF;
        }
        if (byteRead >= 0) {
            ++this.nextReadPos;
            --this.readPartRemain;
        }
        return byteRead;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        this.checkNotClosed();
        this.validatePositionedReadArgs(this.nextReadPos, buf, off, len);
        if (len == 0) {
            return 0;
        }
        if (this.contentLength == 0L || this.nextReadPos >= this.contentLength) {
            return -1;
        }
        long bytescount = 0L;
        while (this.nextReadPos < this.contentLength && bytescount < (long)len) {
            if (this.readPartRemain == 0) {
                this.reopen("continue buffer read", this.nextReadPos, (long)len - bytescount);
            }
            int bytes = 0;
            for (int i = this.buffer.length - this.readPartRemain; i < this.buffer.length; ++i) {
                buf[(int)((long)off + bytescount)] = this.buffer[i];
                ++bytes;
                if (++bytescount >= (long)len) break;
            }
            if (bytes > 0) {
                this.nextReadPos += (long)bytes;
                this.readPartRemain -= bytes;
                continue;
            }
            if (this.readPartRemain == 0) continue;
            throw new IOException("Sfailed to read , remain :" + this.readPartRemain);
        }
        if (bytescount == 0L && len > 0) {
            return -1;
        }
        return (int)bytescount;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException(this.uri + ": " + "Stream is closed!");
        }
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.closeAndClearBuffers();
                super.close();
            }
            finally {
                this.streamStatistics.close();
            }
        }
    }

    public synchronized int available() throws IOException {
        this.checkNotClosed();
        long remaining = this.remainingInFile();
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long remainingInFile() {
        return this.contentLength - this.nextReadPos;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long remainingInCurrentRequest() {
        return this.contentRangeFinish - this.nextReadPos;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long getContentRangeFinish() {
        return this.contentRangeFinish;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public synchronized long getContentRangeStart() {
        return this.contentRangeStart;
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceStability.Unstable
    public String toString() {
        String s = this.streamStatistics.toString();
        OBSReadaheadInputStream oBSReadaheadInputStream = this;
        synchronized (oBSReadaheadInputStream) {
            StringBuilder sb = new StringBuilder("OBSReadaheadInputStream{");
            sb.append(this.uri);
            sb.append(" read policy=").append((Object)this.inputPolicy);
            sb.append(" nextReadPos=").append(this.nextReadPos);
            sb.append(" contentLength=").append(this.contentLength);
            sb.append(" contentRangeStart=").append(this.contentRangeStart);
            sb.append(" contentRangeFinish=").append(this.contentRangeFinish);
            sb.append(" remainingInCurrentRequest=").append(this.remainingInCurrentRequest());
            sb.append('\n').append(s);
            sb.append('}');
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.checkNotClosed();
        this.validatePositionedReadArgs(position, buffer, offset, length);
        this.streamStatistics.readFullyOperationStarted(position, length);
        if (length == 0) {
            return;
        }
        OBSReadaheadInputStream oBSReadaheadInputStream = this;
        synchronized (oBSReadaheadInputStream) {
            long oldPos = this.getPos();
            try {
                int nbytes;
                this.seek(position);
                for (int nread = 0; nread < length; nread += nbytes) {
                    nbytes = this.read(buffer, offset + nread, length - nread);
                    if (nbytes >= 0) continue;
                    throw new EOFException("End of file reached before reading fully.");
                }
            }
            finally {
                this.seekQuietly(oldPos);
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public OBSInstrumentation.InputStreamStatistics getS3AStreamStatistics() {
        return this.streamStatistics;
    }

    public synchronized void setReadahead(Long readahead) {
        if (readahead == null) {
            this.readahead = 65536L;
        } else {
            Preconditions.checkArgument((readahead >= 0L ? 1 : 0) != 0, (Object)"Negative readahead value");
            this.readahead = readahead;
        }
    }

    public synchronized long getReadahead() {
        return this.readahead;
    }

    static long calculateRequestLimit(OBSInputPolicy inputPolicy, long targetPos, long length, long contentLength, long readahead) {
        long rangeLimit = contentLength;
        rangeLimit = Math.min(contentLength, rangeLimit);
        return rangeLimit;
    }

    @VisibleForTesting
    public Deque<ReadBuffer> getBuffers() {
        return this.buffers;
    }
}

