/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.obs.services.exception.ObsException;
import com.obs.services.model.ObjectMetadata;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.obs.OBSFileSystem;
import org.apache.hadoop.fs.obs.OBSUtils;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OBSOutputStream
extends OutputStream {
    private final OutputStream backupStream;
    private final File backupFile;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final String key;
    private final Progressable progress;
    private final OBSFileSystem fs;
    public static final Logger LOG = OBSFileSystem.LOG;

    public OBSOutputStream(Configuration conf, OBSFileSystem fs, String key, Progressable progress) throws IOException {
        this.key = key;
        this.progress = progress;
        this.fs = fs;
        this.backupFile = fs.createTmpFileForWrite("output-", -1L, conf);
        LOG.debug("OutputStream for key '{}' writing to tempfile: {}", (Object)key, (Object)this.backupFile);
        this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFile));
    }

    void checkOpen() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Output Stream closed");
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkOpen();
        this.backupStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.backupStream.close();
        LOG.debug("OutputStream for key '{}' closed. Now beginning upload", (Object)this.key);
        try {
            ObjectMetadata om = this.fs.newObjectMetadata(this.backupFile.length());
            Future upload = this.fs.putObject(this.fs.newPutObjectRequest(this.key, om, this.backupFile));
            upload.get();
            this.fs.incrementPutCompletedStatistics(true, this.backupFile.length());
            this.fs.finishedWrite(this.key);
        }
        catch (InterruptedException e) {
            this.fs.incrementPutCompletedStatistics(false, this.backupFile.length());
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ObsException e) {
            this.fs.incrementPutCompletedStatistics(false, this.backupFile.length());
            throw OBSUtils.translateException("saving output", this.key, e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObsException) {
                throw OBSUtils.translateException("saving output", this.key, (ObsException)e.getCause());
            }
            throw OBSUtils.translateException("saving output", this.key, new ObsException("obs exception: ", e.getCause()));
        }
        finally {
            if (!this.backupFile.delete()) {
                LOG.warn("Could not delete temporary obs file: {}", (Object)this.backupFile);
            }
            super.close();
        }
        LOG.debug("OutputStream for key '{}' upload complete", (Object)this.key);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkOpen();
        this.backupStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        this.backupStream.write(b, off, len);
    }
}

