/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OBSFileStatus
extends FileStatus {
    private boolean isEmptyDirectory;

    public OBSFileStatus(boolean isemptydir, Path path, String owner) {
        super(0L, true, 1, 0L, 0L, path);
        this.isEmptyDirectory = isemptydir;
        this.setOwner(owner);
        this.setGroup(owner);
    }

    public OBSFileStatus(long length, long modification_time, Path path, long blockSize, String owner) {
        super(length, false, 1, blockSize, modification_time, path);
        this.isEmptyDirectory = false;
        this.setOwner(owner);
        this.setGroup(owner);
    }

    public boolean isEmptyDirectory() {
        return this.isEmptyDirectory;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public long getModificationTime() {
        if (this.isDirectory()) {
            return System.currentTimeMillis();
        }
        return super.getModificationTime();
    }

    public String toString() {
        return super.toString() + String.format(" isEmptyDirectory=%s", this.isEmptyDirectory());
    }
}

