/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.obs.services.exception.ObsException;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObsObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.obs.OBSFileStatus;
import org.apache.hadoop.fs.obs.OBSFileSystem;
import org.apache.hadoop.fs.obs.OBSUtils;
import org.slf4j.Logger;

public class Listing {
    private final OBSFileSystem owner;
    private static final Logger LOG = OBSFileSystem.LOG;
    static final PathFilter ACCEPT_ALL = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }

        public String toString() {
            return "ACCEPT_ALL";
        }
    };

    public Listing(OBSFileSystem owner) {
        this.owner = owner;
    }

    FileStatusListingIterator createFileStatusListingIterator(Path listPath, ListObjectsRequest request, PathFilter filter, FileStatusAcceptor acceptor) throws IOException {
        return new FileStatusListingIterator(new ObjectListingIterator(listPath, request), filter, acceptor);
    }

    LocatedFileStatusIterator createLocatedFileStatusIterator(RemoteIterator<FileStatus> statusIterator) {
        return new LocatedFileStatusIterator(statusIterator);
    }

    static class AcceptAllButSelfAndS3nDirs
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptAllButSelfAndS3nDirs(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, ObsObject summary) {
            return !keyPath.equals((Object)this.qualifiedPath) && !summary.getObjectKey().endsWith("_$folder$");
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.equals((Object)this.qualifiedPath);
        }
    }

    class LocatedFileStatusIterator
    implements RemoteIterator<LocatedFileStatus> {
        private final RemoteIterator<FileStatus> statusIterator;

        LocatedFileStatusIterator(RemoteIterator<FileStatus> statusIterator) {
            this.statusIterator = statusIterator;
        }

        public boolean hasNext() throws IOException {
            return this.statusIterator.hasNext();
        }

        public LocatedFileStatus next() throws IOException {
            return Listing.this.owner.toLocatedFileStatus((FileStatus)this.statusIterator.next());
        }
    }

    static class AcceptFilesOnly
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptFilesOnly(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, ObsObject summary) {
            return !keyPath.equals((Object)this.qualifiedPath) && !summary.getObjectKey().endsWith("_$folder$") && !OBSUtils.objectRepresentsDirectory(summary.getObjectKey(), summary.getMetadata().getContentLength());
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return false;
        }
    }

    class ObjectListingIterator
    implements RemoteIterator<ObjectListing> {
        private final Path listPath;
        private ObjectListing objects;
        private boolean firstListing = true;
        private int listingCount = 1;
        private int maxKeys;
        private String delimiter;

        ObjectListingIterator(Path listPath, ListObjectsRequest request) {
            this.listPath = listPath;
            this.maxKeys = Listing.this.owner.getMaxKeys();
            this.delimiter = request.getDelimiter();
            this.objects = Listing.this.owner.listObjects(request);
        }

        public boolean hasNext() throws IOException {
            return this.firstListing || this.objects.isTruncated();
        }

        public ObjectListing next() throws IOException {
            if (this.firstListing) {
                this.firstListing = false;
            } else {
                try {
                    if (!this.objects.isTruncated()) {
                        throw new NoSuchElementException("No more results in listing of " + this.listPath);
                    }
                    LOG.debug("[{}], Requesting next {} objects under {}", new Object[]{this.listingCount, this.maxKeys, this.listPath});
                    this.objects = Listing.this.owner.continueListObjects(this.objects);
                    ++this.listingCount;
                    LOG.debug("New listing status: {}", (Object)this);
                }
                catch (ObsException e) {
                    throw OBSUtils.translateException("listObjects()", this.listPath, e);
                }
            }
            return this.objects;
        }

        public String toString() {
            return "Object listing iterator against " + this.listPath + "; listing count " + this.listingCount + "; isTruncated=" + this.objects.isTruncated();
        }

        public Path getListPath() {
            return this.listPath;
        }

        public int getListingCount() {
            return this.listingCount;
        }
    }

    class FileStatusListingIterator
    implements RemoteIterator<FileStatus> {
        private final ObjectListingIterator source;
        private final PathFilter filter;
        private final FileStatusAcceptor acceptor;
        private int batchSize;
        private ListIterator<FileStatus> statusBatchIterator;

        FileStatusListingIterator(ObjectListingIterator source, PathFilter filter, FileStatusAcceptor acceptor) throws IOException {
            this.source = source;
            this.filter = filter;
            this.acceptor = acceptor;
            this.requestNextBatch();
        }

        public boolean hasNext() throws IOException {
            return this.statusBatchIterator.hasNext() || this.requestNextBatch();
        }

        public FileStatus next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.statusBatchIterator.next();
        }

        private boolean requestNextBatch() throws IOException {
            while (this.source.hasNext()) {
                if (this.buildNextStatusBatch(this.source.next())) {
                    return true;
                }
                LOG.debug("All entries in batch were filtered...continuing");
            }
            return false;
        }

        private boolean buildNextStatusBatch(ObjectListing objects) {
            int added = 0;
            int ignored = 0;
            ArrayList<OBSFileStatus> stats = new ArrayList<OBSFileStatus>(objects.getObjects().size() + objects.getCommonPrefixes().size());
            for (ObsObject summary : objects.getObjects()) {
                String key = summary.getObjectKey();
                Path keyPath = Listing.this.owner.keyToQualifiedPath(key);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: {}", (Object)keyPath, (Object)OBSUtils.stringify(summary));
                }
                if (this.acceptor.accept(keyPath, summary) && this.filter.accept(keyPath)) {
                    OBSFileStatus status = OBSUtils.createFileStatus(keyPath, summary, Listing.this.owner.getDefaultBlockSize(keyPath), Listing.this.owner.getUsername());
                    LOG.debug("Adding: {}", (Object)status);
                    stats.add(status);
                    ++added;
                    continue;
                }
                LOG.debug("Ignoring: {}", (Object)keyPath);
                ++ignored;
            }
            for (String prefix : objects.getCommonPrefixes()) {
                Path keyPath = Listing.this.owner.keyToQualifiedPath(prefix);
                if (this.acceptor.accept(keyPath, prefix) && this.filter.accept(keyPath)) {
                    OBSFileStatus status = new OBSFileStatus(false, keyPath, Listing.this.owner.getUsername());
                    LOG.debug("Adding directory: {}", (Object)status);
                    ++added;
                    stats.add(status);
                    continue;
                }
                LOG.debug("Ignoring directory: {}", (Object)keyPath);
                ++ignored;
            }
            this.batchSize = stats.size();
            this.statusBatchIterator = stats.listIterator();
            boolean hasNext = this.statusBatchIterator.hasNext();
            LOG.debug("Added {} entries; ignored {}; hasNext={}; hasMoreObjects={}", new Object[]{added, ignored, hasNext, objects.isTruncated()});
            return hasNext;
        }

        public int getBatchSize() {
            return this.batchSize;
        }
    }

    static final class SingleStatusRemoteIterator
    implements RemoteIterator<LocatedFileStatus> {
        private LocatedFileStatus status;

        public SingleStatusRemoteIterator(LocatedFileStatus status) {
            this.status = status;
        }

        public boolean hasNext() throws IOException {
            return this.status != null;
        }

        public LocatedFileStatus next() throws IOException {
            if (this.hasNext()) {
                LocatedFileStatus s = this.status;
                this.status = null;
                return s;
            }
            throw new NoSuchElementException();
        }
    }

    static interface FileStatusAcceptor {
        public boolean accept(Path var1, ObsObject var2);

        public boolean accept(Path var1, String var2);
    }
}

