/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.obs.ObsClientFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class Constants {
    public static final int MULTIPART_MIN_SIZE = 0x500000;
    public static final String ACCESS_KEY = "fs.obs.access.key";
    public static final String SECRET_KEY = "fs.obs.secret.key";
    public static final String OBS_CREDENTIALS_PROVIDER = "fs.obs.credentials.provider";
    public static final String OBS_SECURITY_CREDENTIAL_PROVIDER_PATH = "fs.obs.security.credential.provider.path";
    public static final String SESSION_TOKEN = "fs.obs.session.token";
    public static final String MAXIMUM_CONNECTIONS = "fs.obs.connection.maximum";
    public static final int DEFAULT_MAXIMUM_CONNECTIONS = 1000;
    public static final String SECURE_CONNECTIONS = "fs.obs.connection.ssl.enabled";
    public static final boolean DEFAULT_SECURE_CONNECTIONS = false;
    public static final String ENDPOINT = "fs.obs.endpoint";
    public static final String PATH_STYLE_ACCESS = "fs.obs.path.style.access";
    public static final String PROXY_HOST = "fs.obs.proxy.host";
    public static final String PROXY_PORT = "fs.obs.proxy.port";
    public static final String PROXY_USERNAME = "fs.obs.proxy.username";
    public static final String PROXY_PASSWORD = "fs.obs.proxy.password";
    public static final String PROXY_DOMAIN = "fs.obs.proxy.domain";
    public static final String PROXY_WORKSTATION = "fs.obs.proxy.workstation";
    public static final String MAX_ERROR_RETRIES = "fs.obs.attempts.maximum";
    public static final int DEFAULT_MAX_ERROR_RETRIES = 3;
    public static final String ESTABLISH_TIMEOUT = "fs.obs.connection.establish.timeout";
    public static final int DEFAULT_ESTABLISH_TIMEOUT = 60000;
    public static final String SOCKET_TIMEOUT = "fs.obs.connection.timeout";
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    public static final String SOCKET_SEND_BUFFER = "fs.obs.socket.send.buffer";
    public static final int DEFAULT_SOCKET_SEND_BUFFER = 8192;
    public static final String SOCKET_RECV_BUFFER = "fs.obs.socket.recv.buffer";
    public static final int DEFAULT_SOCKET_RECV_BUFFER = 8192;
    public static final String MAX_PAGING_KEYS = "fs.obs.paging.maximum";
    public static final int DEFAULT_MAX_PAGING_KEYS = 1000;
    public static final String MAX_THREADS = "fs.obs.threads.max";
    public static final int DEFAULT_MAX_THREADS = 20;
    public static final String MAX_TOTAL_TASKS = "fs.obs.max.total.tasks";
    public static final int DEFAULT_MAX_TOTAL_TASKS = 20;
    public static final String MAX_COPY_THREADS = "fs.obs.copy.threads.max";
    public static final int DEFAULT_MAX_COPY_THREADS = 20;
    public static final String MAX_COPY_QUEUE = "fs.obs.copy.queue.max";
    public static final int DEFAULT_MAX_COPY_QUEUE = 10;
    public static final String MAX_DELETE_THREADS = "fs.obs.delete.threads.max";
    public static final int DEFAULT_MAX_DELETE_THREADS = 10;
    public static final String MAX_DELETE_QUEUE = "fs.obs.delete.queue.max";
    public static final int DEFAULT_MAX_DELETE_QUEUE = 10;
    public static final String MAX_READ_THREADS = "fs.obs.threads.read.max";
    public static final int DEFAULT_MAX_READ_THREADS = 20;
    public static final String CORE_READ_THREADS = "fs.obs.threads.read.core";
    public static final int DEFAULT_CORE_READ_THREADS = 5;
    public static final String READAHEAD_INPUTSTREAM_ENABLED = "fs.obs.readahead.inputstream.enabled";
    public static final boolean READAHEAD_INPUTSTREAM_ENABLED_DEFAULT = false;
    public static final String BUFFER_PART_SIZE = "fs.obs.buffer.part.size";
    public static final int DEFAULT_BUFFER_PART_SIZE = 65536;
    public static final String BUFFER_MAX_RANGE = "fs.obs.buffer.max.range";
    public static final int DEFAULT_BUFFER_MAX_RANGE = 0x1400000;
    @Deprecated
    public static final String CORE_THREADS = "fs.obs.threads.core";
    public static final String KEEPALIVE_TIME = "fs.obs.threads.keepalivetime";
    public static final int DEFAULT_KEEPALIVE_TIME = 60;
    public static final String MULTIPART_SIZE = "fs.obs.multipart.size";
    public static final long DEFAULT_MULTIPART_SIZE = 0x6400000L;
    public static final String MIN_MULTIPART_THRESHOLD = "fs.obs.multipart.threshold";
    public static final long DEFAULT_MIN_MULTIPART_THRESHOLD = Integer.MAX_VALUE;
    public static final String ENABLE_MULTI_DELETE = "fs.obs.multiobjectdelete.enable";
    public static final String MULTI_DELETE_MAX_NUMBER = "fs.obs.multiobjectdelete.maximum";
    public static final int MULTI_DELETE_DEFAULT_NUMBER = 1000;
    public static final String MULTI_DELETE_RECURSION = "fs.obs.multiobjectdelete.recursion";
    public static final String RENAME_TO_EMPTY_FOLDER = "fs.obs.rename.to_empty_folder";
    public static final String BUFFER_DIR = "fs.obs.buffer.dir";
    public static final String FAST_UPLOAD = "fs.obs.fast.upload";
    public static final boolean DEFAULT_FAST_UPLOAD = true;
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BUFFER = "fs.obs.fast.upload.buffer";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BUFFER_DISK = "disk";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BUFFER_ARRAY = "array";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_BYTEBUFFER = "bytebuffer";
    @InterfaceStability.Unstable
    public static final String DEFAULT_FAST_UPLOAD_BUFFER = "disk";
    @InterfaceStability.Unstable
    public static final String FAST_UPLOAD_ACTIVE_BLOCKS = "fs.obs.fast.upload.active.blocks";
    @InterfaceStability.Unstable
    public static final int DEFAULT_FAST_UPLOAD_ACTIVE_BLOCKS = 4;
    public static final String CANNED_ACL = "fs.obs.acl.default";
    public static final String DEFAULT_CANNED_ACL = "";
    public static final String PURGE_EXISTING_MULTIPART = "fs.obs.multipart.purge";
    public static final boolean DEFAULT_PURGE_EXISTING_MULTIPART = false;
    public static final String PURGE_EXISTING_MULTIPART_AGE = "fs.obs.multipart.purge.age";
    public static final long DEFAULT_PURGE_EXISTING_MULTIPART_AGE = 86400L;
    public static final String SERVER_SIDE_ENCRYPTION_ALGORITHM = "fs.obs.server-side-encryption-algorithm";
    public static final String SERVER_SIDE_ENCRYPTION_AES256 = "AES256";
    public static final String SIGNING_ALGORITHM = "fs.obs.signing-algorithm";
    public static final String OBS_FOLDER_SUFFIX = "_$folder$";
    public static final String FS_OBS_BLOCK_SIZE = "fs.obs.block.size";
    public static final String FS_OBS = "obs";
    public static final String FS_OBS_PREFIX = "fs.obs.";
    public static final String FS_OBS_BUCKET_PREFIX = "fs.obs.bucket.";
    public static final int OBS_DEFAULT_PORT = -1;
    public static final String USER_AGENT_PREFIX = "fs.obs.user.agent.prefix";
    public static final String READAHEAD_RANGE = "fs.obs.readahead.range";
    public static final long DEFAULT_READAHEAD_RANGE = 65536L;
    @InterfaceStability.Unstable
    public static final String INPUT_FADVISE = "fs.obs.experimental.input.fadvise";
    @InterfaceStability.Unstable
    public static final String INPUT_FADV_NORMAL = "normal";
    @InterfaceStability.Unstable
    public static final String INPUT_FADV_SEQUENTIAL = "sequential";
    @InterfaceStability.Unstable
    public static final String INPUT_FADV_RANDOM = "random";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String OBS_CLIENT_FACTORY_IMPL = "fs.obs.s3.client.factory.impl";
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final Class<? extends ObsClientFactory> DEFAULT_OBS_CLIENT_FACTORY_IMPL = ObsClientFactory.DefaultObsClientFactory.class;
    @InterfaceAudience.Private
    public static final int MAX_MULTIPART_COUNT = 10000;
    public static final String IDLE_CONNECTION_TIME = "fs.obs.idle.connection.time";
    public static final int DEFAULT_IDLE_CONNECTION_TIME = 30000;
    public static final String MAX_IDLE_CONNECTIONS = "fs.obs.max.idle.connections";
    public static final int DEFAULT_MAX_IDLE_CONNECTIONS = 10;
    public static final String KEEP_ALIVE = "fs.obs.keep.alive";
    public static final boolean DEFAULT_KEEP_ALIVE = true;
    public static final String VALIDATE_CERTIFICATE = "fs.obs.validate.certificate";
    public static final boolean DEFAULT_VALIDATE_CERTIFICATE = false;
    public static final String VERIFY_RESPONSE_CONTENT_TYPE = "fs.obs.verify.response.content.type";
    public static final boolean DEFAULT_VERIFY_RESPONSE_CONTENT_TYPE = true;
    public static final String UPLOAD_STREAM_RETRY_SIZE = "fs.obs.upload.stream.retry.buffer.size";
    public static final int DEFAULT_UPLOAD_STREAM_RETRY_SIZE = 524288;
    public static final String READ_BUFFER_SIZE = "fs.obs.read.buffer.size";
    public static final int DEFAULT_READ_BUFFER_SIZE = 8192;
    public static final String WRITE_BUFFER_SIZE = "fs.obs.write.buffer.size";
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 8192;
    public static final String CNAME = "fs.obs.cname";
    public static final boolean DEFAULT_CNAME = false;
    public static final String STRICT_HOSTNAME_VERIFICATION = "fs.obs.strict.hostname.verification";
    public static final boolean DEFAULT_STRICT_HOSTNAME_VERIFICATION = false;
    public static final String PATH_LOCAL_TEST = "fs.obs.test.local.path";
    public static final String COPY_PART_SIZE = "fs.obs.copypart.size";
    public static final long DEFAULT_COPY_PART_SIZE = 0x6400000L;
    public static final String MAX_COPY_PART_THREADS = "fs.obs.copypart.threads.max";
    public static final int DEFAULT_MAX_COPY_PART_THREADS = 20;
    public static final String MAX_COPY_PART_QUEUE = "fs.obs.copypart.queue.max";
    public static final int DEFAULT_MAX_COPY_PART_QUEUE = 10;

    private Constants() {
    }
}

