/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.chdfs.fs;

import com.qcloud.chdfs.fs.CHDFSHadoopFileSystemJarLoader;
import com.qcloud.chdfs.fs.FileSystemWithLockCleaner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHDFSHadoopFileSystemAdapter
extends FileSystemWithLockCleaner {
    static final String SCHEME = "ofs";
    private static final Logger log = LoggerFactory.getLogger(CHDFSHadoopFileSystemAdapter.class);
    private static final String MOUNT_POINT_ADDR_PATTERN_CHDFS_TYPE = "^([a-zA-Z0-9-]+)\\.chdfs(-dualstack)?(\\.inner)?\\.([a-z0-9-]+)\\.([a-z0-9-.]+)";
    private static final String MOUNT_POINT_ADDR_PATTERN_COS_TYPE = "^([a-z0-9-]+)-([a-zA-Z0-9]+)$";
    private static final String CHDFS_USER_APPID_KEY = "fs.ofs.user.appid";
    private static final String CHDFS_TMP_CACHE_DIR_KEY = "fs.ofs.tmp.cache.dir";
    private static final String CHDFS_META_SERVER_PORT_KEY = "fs.ofs.meta.server.port";
    private static final String CHDFS_META_TRANSFER_USE_TLS_KEY = "fs.ofs.meta.transfer.tls";
    private static final String CHDFS_BUCKET_REGION = "fs.ofs.bucket.region";
    private static final boolean DEFAULT_CHDFS_META_TRANSFER_USE_TLS = true;
    private static final int DEFAULT_CHDFS_META_SERVER_PORT = 443;
    private final CHDFSHadoopFileSystemJarLoader jarLoader = new CHDFSHadoopFileSystemJarLoader();
    private FileSystemWithLockCleaner actualImplFS = null;
    private URI uri = null;
    private Path workingDir = null;
    private long initStartMs;

    public String getScheme() {
        return SCHEME;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        log.debug("CHDFSHadoopFileSystemAdapter adapter initialize");
        this.initStartMs = System.currentTimeMillis();
        log.debug("CHDFSHadoopFileSystemAdapter start-init-start time: {}", (Object)this.initStartMs);
        try {
            String ofsHost;
            super.initialize(name, conf);
            this.setConf(conf);
            String mountPointAddr = name.getHost();
            if (mountPointAddr == null) {
                String errMsg = String.format("mountPointAddr is null, fullUri: %s, exp. f4mabcdefgh-xyzw.chdfs.ap-guangzhou.myqcloud.com or examplebucket-1250000000 or f4mabcdefgh-xyzw", name.toString());
                log.error(errMsg);
                throw new IOException(errMsg);
            }
            if (this.isValidMountPointAddrChdfsType(mountPointAddr)) {
                ofsHost = mountPointAddr;
            } else if (this.isValidMountPointAddrCosType(mountPointAddr)) {
                String bucketRegion = this.getChdfsBucketRegion(conf);
                ofsHost = String.format("%s.chdfs.%s.myqcloud.com", mountPointAddr, bucketRegion);
            } else {
                String errMsg = String.format("mountPointAddr %s is invalid, fullUri: %s, exp. f4mabcdefgh-xyzw.chdfs.ap-guangzhou.myqcloud.com or examplebucket-1250000000 or f4mabcdefgh-xyzw", mountPointAddr, name.toString());
                log.error(errMsg);
                throw new IOException(errMsg);
            }
            long appid = this.getAppid(conf);
            int jarPluginServerPort = this.getJarPluginServerPort(conf);
            String tmpDirPath = this.initCacheTmpDir(conf);
            boolean jarPluginServerHttpsFlag = this.isJarPluginServerHttps(conf);
            this.initJarLoadWithRetry(ofsHost, appid, jarPluginServerPort, tmpDirPath, jarPluginServerHttpsFlag);
            this.actualImplFS = this.jarLoader.getActualFileSystem();
            if (this.actualImplFS == null) {
                throw new IOException("impl filesystem is null");
            }
            long actualInitStartMs = System.currentTimeMillis();
            this.actualImplFS.initialize(name, conf);
            log.debug("init actual file system, [elapse-ms: {}]", (Object)(System.currentTimeMillis() - actualInitStartMs));
            this.uri = this.actualImplFS.getUri();
            this.workingDir = this.actualImplFS.getWorkingDirectory();
        }
        catch (IOException ioe) {
            log.error("initialize failed! a ioException occur!", (Throwable)ioe);
            throw ioe;
        }
        catch (Exception e) {
            log.error("initialize failed! a unexpected exception occur!", (Throwable)e);
            throw new IOException("initialize failed! oops! a unexpected exception occur! " + e.toString(), e);
        }
        log.debug("total init file system, [elapse-ms: {}]", (Object)(System.currentTimeMillis() - this.initStartMs));
    }

    boolean isValidMountPointAddrChdfsType(String mountPointAddr) {
        return Pattern.matches(MOUNT_POINT_ADDR_PATTERN_CHDFS_TYPE, mountPointAddr);
    }

    boolean isValidMountPointAddrCosType(String mountPointAddr) {
        return Pattern.matches(MOUNT_POINT_ADDR_PATTERN_COS_TYPE, mountPointAddr);
    }

    private String getChdfsBucketRegion(Configuration conf) throws IOException {
        String bucketRegion = conf.get(CHDFS_BUCKET_REGION);
        if (bucketRegion == null) {
            String errMsg = String.format("ofs config %s is missing", CHDFS_BUCKET_REGION);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        return bucketRegion;
    }

    private long getAppid(Configuration conf) throws IOException {
        long appid = 0L;
        try {
            appid = conf.getLong(CHDFS_USER_APPID_KEY, 0L);
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format("config for %s is invalid appid number", CHDFS_USER_APPID_KEY));
        }
        if (appid <= 0L) {
            throw new IOException(String.format("config for %s is missing or invalid appid number", CHDFS_USER_APPID_KEY));
        }
        return appid;
    }

    private int getJarPluginServerPort(Configuration conf) {
        return conf.getInt(CHDFS_META_SERVER_PORT_KEY, 443);
    }

    private String initCacheTmpDir(Configuration conf) throws IOException {
        String chdfsTmpCacheDirPath = conf.get(CHDFS_TMP_CACHE_DIR_KEY);
        if (chdfsTmpCacheDirPath == null) {
            String errMsg = String.format("chdfs config %s is missing", CHDFS_TMP_CACHE_DIR_KEY);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        if (!chdfsTmpCacheDirPath.startsWith("/")) {
            String errMsg = String.format("chdfs config [%s: %s] must be absolute path", CHDFS_TMP_CACHE_DIR_KEY, chdfsTmpCacheDirPath);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        File chdfsTmpCacheDir = new File(chdfsTmpCacheDirPath);
        if (!chdfsTmpCacheDir.exists()) {
            if (!chdfsTmpCacheDir.mkdirs() && !chdfsTmpCacheDir.exists()) {
                String errMsg = String.format("mkdir for chdfs tmp dir %s failed", chdfsTmpCacheDir.getAbsolutePath());
                log.error(errMsg);
                throw new IOException(errMsg);
            }
            chdfsTmpCacheDir.setReadable(true, false);
            chdfsTmpCacheDir.setWritable(true, false);
            chdfsTmpCacheDir.setExecutable(true, false);
        }
        if (!chdfsTmpCacheDir.isDirectory()) {
            String errMsg = String.format("chdfs config [%s: %s] is invalid directory", CHDFS_TMP_CACHE_DIR_KEY, chdfsTmpCacheDir.getAbsolutePath());
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        if (!chdfsTmpCacheDir.canRead()) {
            String errMsg = String.format("chdfs config [%s: %s] is not readable", CHDFS_TMP_CACHE_DIR_KEY, chdfsTmpCacheDirPath);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        if (!chdfsTmpCacheDir.canWrite()) {
            String errMsg = String.format("chdfs config [%s: %s] is not writeable", CHDFS_TMP_CACHE_DIR_KEY, chdfsTmpCacheDirPath);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        return chdfsTmpCacheDirPath;
    }

    private boolean isJarPluginServerHttps(Configuration conf) {
        return conf.getBoolean(CHDFS_META_TRANSFER_USE_TLS_KEY, true);
    }

    private void initJarLoadWithRetry(String mountPointAddr, long appid, int jarPluginServerPort, String tmpDirPath, boolean jarPluginServerHttps) throws IOException {
        int maxRetry = 5;
        for (int retryIndex = 0; retryIndex <= maxRetry; ++retryIndex) {
            try {
                this.jarLoader.init(mountPointAddr, appid, jarPluginServerPort, tmpDirPath, jarPluginServerHttps);
                return;
            }
            catch (IOException e) {
                if (retryIndex >= maxRetry) {
                    log.error("init chdfs impl failed", (Throwable)e);
                    throw new IOException("init chdfs impl failed", e);
                }
                log.warn(String.format("init chdfs impl failed, we will retry again, retryInfo: %d/%d", retryIndex, maxRetry), (Throwable)e);
                try {
                    Thread.sleep(ThreadLocalRandom.current().nextLong(500L, 2000L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public URI getUri() {
        return this.uri;
    }

    private void judgeActualFSInitialized() {
        if (this.actualImplFS == null) {
            throw new RuntimeException("please init the fileSystem first!");
        }
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.open(f, bufferSize);
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.createNonRecursive(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.append(f, bufferSize, progress);
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.truncate(f, newLength);
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.concat(trg, psrcs);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.rename(src, dst);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.delete(f, recursive);
    }

    public boolean deleteOnExit(Path f) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.deleteOnExit(f);
    }

    public boolean cancelDeleteOnExit(Path f) {
        this.judgeActualFSInitialized();
        return this.actualImplFS.cancelDeleteOnExit(f);
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.listStatus(f);
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(Path new_dir) {
        this.workingDir = new_dir;
        if (this.actualImplFS == null) {
            log.warn("fileSystem is not init yet!");
        } else {
            this.actualImplFS.setWorkingDirectory(new_dir);
        }
    }

    public Path getHomeDirectory() {
        if (this.actualImplFS == null) {
            return super.getHomeDirectory();
        }
        return this.actualImplFS.getHomeDirectory();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.mkdirs(f, permission);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getFileStatus(f);
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.createSymlink(target, link, createParent);
    }

    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getFileLinkStatus(f);
    }

    public boolean supportsSymlinks() {
        if (this.actualImplFS == null) {
            return super.supportsSymlinks();
        }
        return this.actualImplFS.supportsSymlinks();
    }

    public Path getLinkTarget(Path f) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getLinkTarget(f);
    }

    protected Path resolveLink(Path f) throws IOException {
        return this.getLinkTarget(f);
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getFileChecksum(f, length);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.judgeActualFSInitialized();
        this.actualImplFS.setVerifyChecksum(verifyChecksum);
    }

    public void setWriteChecksum(boolean writeChecksum) {
        this.judgeActualFSInitialized();
        this.actualImplFS.setWriteChecksum(writeChecksum);
    }

    public FsStatus getStatus(Path p) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getStatus(p);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.setPermission(p, permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.setOwner(p, username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.setTimes(p, mtime, atime);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.createSnapshot(path, snapshotName);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.deleteSnapshot(path, snapshotName);
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.modifyAclEntries(path, aclSpec);
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.removeAclEntries(path, aclSpec);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.removeDefaultAcl(path);
    }

    public void removeAcl(Path path) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.removeAcl(path);
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.setAcl(path, aclSpec);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getAclStatus(path);
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.setXAttr(path, name, value, flag);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getXAttr(path, name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getXAttrs(path);
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getXAttrs(path, names);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.listXAttrs(path);
    }

    public void removeXAttr(Path path, String name) throws IOException {
        this.judgeActualFSInitialized();
        this.actualImplFS.removeXAttr(path, name);
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getDelegationToken(renewer);
    }

    public String getCanonicalServiceName() {
        if (this.actualImplFS == null) {
            return null;
        }
        return this.actualImplFS.getCanonicalServiceName();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        this.judgeActualFSInitialized();
        return this.actualImplFS.getContentSummary(f);
    }

    @Override
    public void releaseFileLock(Path p) throws IOException {
        if (this.actualImplFS == null) {
            throw new IOException("please init the fileSystem first!");
        }
        this.actualImplFS.releaseFileLock(p);
    }

    public void close() throws IOException {
        this.judgeActualFSInitialized();
        super.close();
        this.actualImplFS.close();
    }
}

