/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.chdfs.fs;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.qcloud.chdfs.fs.AlreadyLoadedFileSystemInfo;
import com.qcloud.chdfs.fs.FileSystemWithLockCleaner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.nio.channels.OverlappingFileLockException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CHDFSHadoopFileSystemJarLoader {
    private static final Logger log = LoggerFactory.getLogger(CHDFSHadoopFileSystemJarLoader.class);
    private static AlreadyLoadedFileSystemInfo alreadyLoadedFileSystemInfo;
    private String versionId;
    private String jarPath;
    private String jarMd5;
    private FileSystemWithLockCleaner actualFileSystem;

    CHDFSHadoopFileSystemJarLoader() {
    }

    synchronized void init(String mountPointAddr, long appid, int jarPluginServerPort, String tmpDirPath, boolean jarPluginServerHttps) throws IOException {
        if (this.actualFileSystem == null) {
            long queryStartMs = System.currentTimeMillis();
            this.queryJarPluginInfo(mountPointAddr, appid, jarPluginServerPort, jarPluginServerHttps);
            log.debug("query jar plugin info usedMs: {}", (Object)(System.currentTimeMillis() - queryStartMs));
            this.actualFileSystem = CHDFSHadoopFileSystemJarLoader.getAlreadyLoadedClassInfo(this.getClass().getClassLoader(), this.jarPath, this.versionId, this.jarMd5, tmpDirPath);
            if (this.actualFileSystem == null) {
                String errMsg = "CHDFSHadoopFileSystemJarLoader getAlreadyLoadedClassInfo return null";
                throw new IOException(errMsg);
            }
        }
    }

    private void parseJarPluginInfoResp(String respStr) throws IOException {
        JsonObject respJson = new JsonParser().parse(respStr).getAsJsonObject();
        if (!respJson.has("Response")) {
            String errMsg = String.format("resp json miss element Response, resp: %s", respStr);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        if (!respJson.get("Response").getAsJsonObject().has("HadoopPluginJar")) {
            String errMsg = String.format("resp json miss element Response.HadoopPluginJar, resp: %s", respStr);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        JsonObject jarInfoJson = respJson.get("Response").getAsJsonObject().get("HadoopPluginJar").getAsJsonObject();
        if (!jarInfoJson.has("VersionId")) {
            String errMsg = String.format("resp miss config Response.HadoopPluginJar.VersionId, resp: %s", respStr);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        this.versionId = jarInfoJson.get("VersionId").getAsString();
        if (!jarInfoJson.has("JarPath")) {
            String errMsg = String.format("resp miss config Response.HadoopPluginJar.JarPath, resp: %s", respStr);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        this.jarPath = jarInfoJson.get("JarPath").getAsString();
        if (!jarInfoJson.has("JarMd5")) {
            String errMsg = String.format("resp miss config Response.HadoopPluginJar.JarMd5, resp: %s", respStr);
            log.error(errMsg);
            throw new IOException(errMsg);
        }
        this.jarMd5 = jarInfoJson.get("JarMd5").getAsString();
    }

    private void queryJarPluginInfo(String mountPointAddr, long appid, int jarPluginServerPort, boolean jarPluginServerHttpsFlag) throws IOException {
        ByteArrayOutputStream bos;
        HttpURLConnection conn;
        long startTimeNs;
        block13: {
            String hadoopVersion = VersionInfo.getVersion();
            if (hadoopVersion == null) {
                hadoopVersion = "unknown";
            }
            URL queryJarUrl = null;
            String queryJarUrlStr = "";
            try {
                queryJarUrlStr = String.format("%s://%s:%d/chdfs-hadoop-plugin?appid=%d&hadoop_version=%s", jarPluginServerHttpsFlag ? "https" : "http", mountPointAddr, jarPluginServerPort, appid, URLEncoder.encode(hadoopVersion.trim(), "UTF-8"));
                queryJarUrl = new URL(queryJarUrlStr);
            }
            catch (UnsupportedEncodingException | MalformedURLException e) {
                String errMsg = String.format("invalid url %s", queryJarUrlStr);
                log.error(errMsg, (Throwable)e);
                throw new IOException(errMsg, e);
            }
            startTimeNs = System.nanoTime();
            conn = null;
            BufferedInputStream bis = null;
            bos = null;
            try {
                conn = (HttpURLConnection)queryJarUrl.openConnection();
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setReadTimeout(120000);
                conn.connect();
                bis = new BufferedInputStream(conn.getInputStream());
                bos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                int readLen = 0;
                while ((readLen = bis.read(buf)) != -1) {
                    bos.write(buf, 0, readLen);
                }
                String respStr = bos.toString();
                this.parseJarPluginInfoResp(respStr);
                if (bis == null) break block13;
            }
            catch (IOException e) {
                try {
                    String errMsg = "queryJarPluginInfo occur an io exception";
                    log.error(errMsg, (Throwable)e);
                    throw new IOException(errMsg, e);
                }
                catch (Throwable throwable) {
                    if (bis != null) {
                        IOUtils.closeStream(bis);
                    }
                    if (bos != null) {
                        IOUtils.closeStream(bos);
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                    throw throwable;
                }
            }
            IOUtils.closeStream((Closeable)bis);
        }
        if (bos != null) {
            IOUtils.closeStream((Closeable)bos);
        }
        if (conn != null) {
            conn.disconnect();
        }
        log.debug("query jarPluginInfo, usedTimeMs: {}", (Object)((double)(System.nanoTime() - startTimeNs) * 1.0 / 1000000.0));
    }

    private static synchronized FileSystemWithLockCleaner getAlreadyLoadedClassInfo(ClassLoader currentClassLoader, String jarPath, String versionId, String jarMd5, String tmpDirPath) throws IOException {
        if (alreadyLoadedFileSystemInfo != null && CHDFSHadoopFileSystemJarLoader.alreadyLoadedFileSystemInfo.jarPath.equals(jarPath) && CHDFSHadoopFileSystemJarLoader.alreadyLoadedFileSystemInfo.versionId.equals(versionId) && CHDFSHadoopFileSystemJarLoader.alreadyLoadedFileSystemInfo.jarMd5.equals(jarMd5)) {
            try {
                return (FileSystemWithLockCleaner)CHDFSHadoopFileSystemJarLoader.alreadyLoadedFileSystemInfo.chdfsFSClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                String errMsg = String.format("load chdfs class failed, className: %s", CHDFSHadoopFileSystemJarLoader.alreadyLoadedFileSystemInfo.chdfsFSClass.getName());
                log.error(errMsg, (Throwable)e);
                throw new IOException(errMsg, e);
            }
        }
        File jarFile = CHDFSHadoopFileSystemJarLoader.downloadJarPath(jarPath, versionId, jarMd5, tmpDirPath);
        URL jarUrl = null;
        try {
            jarUrl = jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            String errMsg = String.format("get jar file url failed, jarPath: %s", jarFile.getAbsolutePath());
            log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
        URLClassLoader chdfsJarClassLoader = new URLClassLoader(new URL[]{jarUrl}, currentClassLoader);
        String className = String.format("chdfs.%s.com.qcloud.chdfs.fs.CHDFSHadoopFileSystem", versionId);
        try {
            Class<?> chdfsFSClass = chdfsJarClassLoader.loadClass(className);
            FileSystemWithLockCleaner actualFileSystem = (FileSystemWithLockCleaner)chdfsFSClass.newInstance();
            alreadyLoadedFileSystemInfo = new AlreadyLoadedFileSystemInfo(versionId, jarPath, jarMd5, chdfsFSClass);
            return actualFileSystem;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String errMsg = String.format("load class failed, className: %s", className);
            log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static File downloadJarPath(String jarPath, String versionId, String jarMd5, String tmpDirPath) throws IOException {
        localCacheJarFile = new File(String.format("%s/chdfs_hadoop_plugin-%s-shaded.jar", new Object[]{tmpDirPath, versionId}));
        localCacheJarLockFile = new File(String.format("%s/chdfs_hadoop_plugin-%s-shaded.jar.LOCK", new Object[]{tmpDirPath, versionId}));
        if (localCacheJarFile.exists() && (md5Hex = CHDFSHadoopFileSystemJarLoader.getFileHexMd5(localCacheJarFile)).equalsIgnoreCase(jarMd5)) {
            return localCacheJarFile;
        }
        fileLockOutPut = null;
        fileLock = null;
        try {
            fileLockOutPut = new FileOutputStream(localCacheJarLockFile);
        }
        catch (IOException e) {
            errMsg = String.format("download jar failed, open lock file failed, lockPath: %s", new Object[]{localCacheJarLockFile.getAbsolutePath()});
            CHDFSHadoopFileSystemJarLoader.log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
        while (true) lbl-1000:
        // 2 sources

        {
            try {
                fileLock = fileLockOutPut.getChannel().lock();
                break;
            }
            catch (OverlappingFileLockException ofle) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    try {
                        fileLockOutPut.close();
                    }
                    catch (IOException var10_17) {
                        // empty catch block
                    }
                    errMsg = String.format("download jar failed, lock file failed, lockPath: %s", new Object[]{localCacheJarLockFile.getAbsolutePath()});
                    CHDFSHadoopFileSystemJarLoader.log.error(errMsg, (Throwable)e);
                    throw new IOException(errMsg, e);
                }
            }
            ** while (true)
            catch (IOException e) {
                try {
                    fileLockOutPut.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                errMsg = String.format("download jar failed, lock file failed, lockPath: %s", new Object[]{localCacheJarLockFile.getAbsolutePath()});
                CHDFSHadoopFileSystemJarLoader.log.error(errMsg, (Throwable)e);
                throw new IOException(errMsg, e);
            }
            break;
        }
        bis = null;
        fos = null;
        if (localCacheJarFile.exists() && (md5Hex = CHDFSHadoopFileSystemJarLoader.getFileHexMd5(localCacheJarFile)).equalsIgnoreCase(jarMd5)) {
            var11_20 = localCacheJarFile;
            return var11_20;
        }
        downloadJarUrl = null;
        try {
            downloadJarUrl = new URL(jarPath);
        }
        catch (MalformedURLException e) {
            errMsg = String.format("invalid download jar url %s", new Object[]{jarPath});
            CHDFSHadoopFileSystemJarLoader.log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
        try {
            conn = downloadJarUrl.openConnection();
            conn.connect();
            bis = new BufferedInputStream(conn.getInputStream());
            fos = new BufferedOutputStream(new FileOutputStream(localCacheJarFile));
            IOUtils.copyBytes((InputStream)bis, (OutputStream)fos, (int)4096, (boolean)true);
            localCacheJarFile.setReadable(true, false);
            localCacheJarFile.setWritable(true, false);
            localCacheJarFile.setExecutable(true, false);
            localCacheJarLockFile.setReadable(true, false);
            localCacheJarLockFile.setWritable(true, false);
            localCacheJarLockFile.setExecutable(true, false);
            bis = null;
            fos = null;
            fileLock.release();
            fileLock = null;
            fileLockOutPut.close();
            fileLockOutPut = null;
        }
        catch (IOException e) {
            errMsg = String.format("download jar failed, localJarPath: %s", new Object[]{localCacheJarFile.getAbsolutePath()});
            CHDFSHadoopFileSystemJarLoader.log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg);
        }
        md5Hex = CHDFSHadoopFileSystemJarLoader.getFileHexMd5(localCacheJarFile);
        if (!md5Hex.equalsIgnoreCase(jarMd5)) {
            errMsg = String.format("download jar md5 check failed, local jar md5: %s, query jar md5: %s", new Object[]{md5Hex, jarMd5});
            CHDFSHadoopFileSystemJarLoader.log.error(errMsg);
            throw new IOException(errMsg);
        }
        var12_31 = localCacheJarFile;
        return var12_31;
        finally {
            if (fileLock != null) {
                try {
                    fileLock.release();
                }
                catch (IOException var12_24) {}
            }
            if (fileLockOutPut != null) {
                try {
                    fileLockOutPut.close();
                }
                catch (IOException var12_25) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException var12_26) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException var12_27) {}
            }
        }
    }

    private static String getFileHexMd5(File inFile) throws IOException {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(inFile);
            byte[] md5Byte = MD5Hash.digest((InputStream)in).getDigest();
            string = Hex.encodeHexString((byte[])md5Byte);
        }
        catch (IOException e) {
            try {
                String errMsg = String.format("getFileHexMd5 failed, inFile path: %s", inFile.getAbsolutePath());
                log.error(errMsg, (Throwable)e);
                throw new IOException(errMsg, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(in);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)in);
        return string;
    }

    FileSystemWithLockCleaner getActualFileSystem() {
        return this.actualFileSystem;
    }
}

