/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.doris.broker.hdfs.BrokerException;
import org.apache.doris.thrift.TBrokerOperationStatusCode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WildcardURI {
    private static Logger logger = LogManager.getLogger((String)WildcardURI.class.getName());
    private URI uri;

    public WildcardURI(String path) {
        try {
            String encodedPath = URLEncoder.encode(path, StandardCharsets.UTF_8.toString()).replaceAll("%3A", ":").replaceAll("%2F", "/").replaceAll("\\+", "%20");
            this.uri = new URI(encodedPath);
            this.uri.normalize();
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            logger.warn("failed to encoded uri: " + path, (Throwable)e);
            e.printStackTrace();
            throw new BrokerException(TBrokerOperationStatusCode.INVALID_INPUT_FILE_PATH, (Throwable)e, "invalid input path {} ", path);
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public String getAuthority() {
        return this.uri.getAuthority();
    }

    public String getPath() {
        return this.uri.getPath();
    }
}

