/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import java.io.FileReader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigBase {
    public static Properties props;
    public static Class<? extends ConfigBase> confClass;

    public void init(String propfile) throws Exception {
        props = new Properties();
        confClass = this.getClass();
        props.load(new FileReader(propfile));
        ConfigBase.replacedByEnv();
        ConfigBase.setFields();
    }

    public static HashMap<String, String> dump() throws Exception {
        Field[] fields;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field f : fields = confClass.getFields()) {
            if (f.getAnnotation(ConfField.class) == null) continue;
            if (f.getType().isArray()) {
                switch (f.getType().getSimpleName()) {
                    case "short[]": {
                        map.put(f.getName(), Arrays.toString((short[])f.get(null)));
                        break;
                    }
                    case "int[]": {
                        map.put(f.getName(), Arrays.toString((int[])f.get(null)));
                        break;
                    }
                    case "long[]": {
                        map.put(f.getName(), Arrays.toString((long[])f.get(null)));
                        break;
                    }
                    case "double[]": {
                        map.put(f.getName(), Arrays.toString((double[])f.get(null)));
                        break;
                    }
                    case "boolean[]": {
                        map.put(f.getName(), Arrays.toString((boolean[])f.get(null)));
                        break;
                    }
                    case "String[]": {
                        map.put(f.getName(), Arrays.toString((String[])f.get(null)));
                        break;
                    }
                    default: {
                        throw new Exception("unknown type: " + f.getType().getSimpleName());
                    }
                }
                continue;
            }
            map.put(f.getName(), f.get(null).toString());
        }
        return map;
    }

    private static void replacedByEnv() throws Exception {
        Pattern pattern = Pattern.compile("\\$\\{([^\\}]*)\\}");
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            Matcher m = pattern.matcher(value);
            while (m.find()) {
                String envValue = System.getProperty(m.group(1));
                String string = envValue = envValue != null ? envValue : System.getenv(m.group(1));
                if (envValue != null) {
                    value = value.replace("${" + m.group(1) + "}", envValue);
                    continue;
                }
                throw new Exception("no such env variable: " + m.group(1));
            }
            props.setProperty(key, value);
        }
    }

    private static void setFields() throws Exception {
        Field[] fields;
        block28: for (Field f : fields = confClass.getFields()) {
            String confStr;
            String confVal;
            ConfField anno = f.getAnnotation(ConfField.class);
            if (anno == null || (confVal = props.getProperty(confStr = anno.value().equals("") ? f.getName() : anno.value())) == null) continue;
            confVal = confVal.trim();
            String[] sa = confVal.split(",");
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = sa[i].trim();
            }
            switch (f.getType().getSimpleName()) {
                case "short": {
                    f.setShort(null, Short.parseShort(confVal));
                    continue block28;
                }
                case "int": {
                    f.setInt(null, Integer.parseInt(confVal));
                    continue block28;
                }
                case "long": {
                    f.setLong(null, Long.parseLong(confVal));
                    continue block28;
                }
                case "double": {
                    f.setDouble(null, Double.parseDouble(confVal));
                    continue block28;
                }
                case "boolean": {
                    f.setBoolean(null, Boolean.parseBoolean(confVal));
                    continue block28;
                }
                case "String": {
                    f.set(null, confVal);
                    continue block28;
                }
                case "short[]": {
                    short[] sha = new short[sa.length];
                    for (int i = 0; i < sha.length; ++i) {
                        sha[i] = Short.parseShort(sa[i]);
                    }
                    f.set(null, sha);
                    continue block28;
                }
                case "int[]": {
                    int[] ia = new int[sa.length];
                    for (int i = 0; i < ia.length; ++i) {
                        ia[i] = Integer.parseInt(sa[i]);
                    }
                    f.set(null, ia);
                    continue block28;
                }
                case "long[]": {
                    long[] la = new long[sa.length];
                    for (int i = 0; i < la.length; ++i) {
                        la[i] = Long.parseLong(sa[i]);
                    }
                    f.set(null, la);
                    continue block28;
                }
                case "double[]": {
                    double[] da = new double[sa.length];
                    for (int i = 0; i < da.length; ++i) {
                        da[i] = Double.parseDouble(sa[i]);
                    }
                    f.set(null, da);
                    continue block28;
                }
                case "boolean[]": {
                    boolean[] ba = new boolean[sa.length];
                    for (int i = 0; i < ba.length; ++i) {
                        ba[i] = Boolean.parseBoolean(sa[i]);
                    }
                    f.set(null, ba);
                    continue block28;
                }
                case "String[]": {
                    f.set(null, sa);
                    continue block28;
                }
                default: {
                    throw new Exception("unknown type: " + f.getType().getSimpleName());
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConfField {
        public String value() default "";
    }
}

