/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.broker.hdfs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.broker.hdfs.BrokerConfig;
import org.apache.doris.broker.hdfs.HDFSBrokerServiceImpl;
import org.apache.doris.common.ThriftServer;
import org.apache.doris.thrift.TPaloBrokerService;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class BrokerBootstrap {
    public static void main(String[] args) {
        try {
            String brokerHome = System.getenv("BROKER_HOME");
            if (brokerHome == null || StringUtils.isEmpty((CharSequence)brokerHome)) {
                System.out.println("BROKER_HOME is not set, exit");
                return;
            }
            System.setProperty("BROKER_LOG_DIR", System.getenv("BROKER_LOG_DIR"));
            PropertyConfigurator.configure((String)(brokerHome + "/conf/log4j.properties"));
            Logger logger = Logger.getLogger(BrokerBootstrap.class);
            logger.info((Object)"starting apache hdfs broker....");
            new BrokerConfig().init(brokerHome + "/conf/apache_hdfs_broker.conf");
            TPaloBrokerService.Processor<HDFSBrokerServiceImpl> tprocessor = new TPaloBrokerService.Processor<HDFSBrokerServiceImpl>(new HDFSBrokerServiceImpl());
            ThriftServer server = new ThriftServer(BrokerConfig.broker_ipc_port, tprocessor);
            server.start();
            logger.info((Object)"starting apache hdfs broker....succeed");
            while (true) {
                Thread.sleep(2000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
    }

    private static boolean createAndLockPidFile(String pidFilePath) throws IOException {
        File pid = new File(pidFilePath);
        RandomAccessFile file = new RandomAccessFile(pid, "rws");
        try {
            FileLock lock = file.getChannel().tryLock();
            if (lock == null) {
                return false;
            }
            pid.deleteOnExit();
            String name = ManagementFactory.getRuntimeMXBean().getName();
            file.write(name.split("@")[0].getBytes(Charsets.UTF_8));
            return true;
        }
        catch (OverlappingFileLockException e) {
            file.close();
            return false;
        }
        catch (IOException e) {
            file.close();
            throw e;
        }
    }
}

