/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.qcloud.cos.thirdparty.org.apache.commons.codec.binary.Hex;
import com.qcloud.cos.thirdparty.org.apache.commons.codec.digest.DigestUtils;
import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Md5Utils {
    public static byte[] computeMD5Hash(InputStream is) throws IOException {
        return DigestUtils.md5(is);
    }

    public static String md5AsBase64(InputStream is) throws IOException {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(is));
    }

    public static byte[] computeMD5Hash(byte[] input) {
        return DigestUtils.md5(input);
    }

    public static String md5AsBase64(byte[] input) {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(input));
    }

    public static String md5Hex(File file) throws FileNotFoundException, IOException {
        return Hex.encodeHexString(Md5Utils.computeMD5Hash(file));
    }

    public static String md5Hex(String utf8Content) {
        return Hex.encodeHexString(Md5Utils.computeMD5Hash(utf8Content.getBytes(StringUtils.UTF8)));
    }

    public static String md5Hex(byte[] input) {
        return Hex.encodeHexString(Md5Utils.computeMD5Hash(input));
    }

    public static byte[] computeMD5Hash(File file) throws FileNotFoundException, IOException {
        try (FileInputStream input = null;){
            input = new FileInputStream(file);
            byte[] byArray = Md5Utils.computeMD5Hash(input);
            return byArray;
        }
    }

    public static String md5AsBase64(File file) throws FileNotFoundException, IOException {
        return Base64.encodeAsString(Md5Utils.computeMD5Hash(file));
    }
}

