/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.internal.COSDirect;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.InputSubstream;
import com.qcloud.cos.internal.LengthCheckInputStream;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.ResettableInputStream;
import com.qcloud.cos.internal.SdkFilterInputStream;
import com.qcloud.cos.internal.crypto.COSCryptoModule;
import com.qcloud.cos.internal.crypto.COSCryptoScheme;
import com.qcloud.cos.internal.crypto.COSObjectWrapper;
import com.qcloud.cos.internal.crypto.CipherLite;
import com.qcloud.cos.internal.crypto.CipherLiteInputStream;
import com.qcloud.cos.internal.crypto.ContentCryptoMaterial;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsAccessor;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsFactory;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.KMSSecuredCEK;
import com.qcloud.cos.internal.crypto.MultipartUploadCryptoContext;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.internal.crypto.RenewableCipherLiteInputStream;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.AbstractPutObjectRequest;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.CosDataSource;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.InstructionFileId;
import com.qcloud.cos.model.MaterialsDescriptionProvider;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutInstructionFileRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.thirdparty.com.fasterxml.jackson.core.JsonProcessingException;
import com.qcloud.cos.thirdparty.com.fasterxml.jackson.databind.ObjectMapper;
import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.Jackson;
import com.qcloud.cos.utils.StringUtils;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyRequest;
import com.tencentcloudapi.kms.v20190118.models.GenerateDataKeyResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class COSCryptoModuleBase
extends COSCryptoModule {
    private static final boolean IS_MULTI_PART = true;
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterialsProvider kekMaterialsProvider;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final COSCryptoScheme cryptoScheme;
    protected final ContentCryptoScheme contentCryptoScheme;
    protected final CryptoConfiguration cryptoConfig;
    protected final Map<String, MultipartUploadCryptoContext> multipartUploadContexts = Collections.synchronizedMap(new HashMap());
    protected final COSDirect cos;
    protected final QCLOUDKMS kms;

    protected COSCryptoModuleBase(QCLOUDKMS kms, COSDirect cos, COSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, CryptoConfiguration cryptoConfig) {
        if (!cryptoConfig.isReadOnly()) {
            throw new IllegalArgumentException("The cryto configuration parameter is required to be read-only");
        }
        this.kekMaterialsProvider = kekMaterialsProvider;
        this.cos = cos;
        this.cryptoConfig = cryptoConfig;
        this.cryptoScheme = COSCryptoScheme.from(cryptoConfig.getCryptoMode());
        this.contentCryptoScheme = this.cryptoScheme.getContentCryptoScheme();
        this.kms = kms;
        this.contentCryptoScheme.setIV(cryptoConfig.getIV());
    }

    protected COSCryptoModuleBase(COSDirect cos, COSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this.kekMaterialsProvider = kekMaterialsProvider;
        this.cos = cos;
        this.cryptoConfig = cryptoConfig;
        this.cryptoScheme = COSCryptoScheme.from(cryptoConfig.getCryptoMode());
        this.contentCryptoScheme = this.cryptoScheme.getContentCryptoScheme();
        this.kms = null;
    }

    protected abstract long ciphertextLength(long var1);

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest req) {
        return this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile ? this.putObjectUsingInstructionFile(req) : this.putObjectUsingMetadata(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PutObjectResult putObjectUsingMetadata(PutObjectRequest req) {
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(req);
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        PutObjectRequest wrappedReq = this.wrapWithCipher(req, cekMaterial);
        req.setMetadata(this.updateMetadataWithContentCryptoMaterial(req.getMetadata(), req.getFile(), cekMaterial));
        try {
            PutObjectResult putObjectResult = this.cos.putObject(wrappedReq);
            return putObjectResult;
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(req, fileOrig, isOrig, wrappedReq.getInputStream(), this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PutObjectResult putObjectUsingInstructionFile(PutObjectRequest putObjectRequest) {
        PutObjectResult result;
        File fileOrig = putObjectRequest.getFile();
        InputStream isOrig = putObjectRequest.getInputStream();
        PutObjectRequest putInstFileRequest = putObjectRequest.clone().withFile(null).withInputStream(null);
        putInstFileRequest.setKey(putInstFileRequest.getKey() + "." + "instruction");
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(putObjectRequest);
        PutObjectRequest req = this.wrapWithCipher(putObjectRequest, cekMaterial);
        try {
            result = this.cos.putObject(req);
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(putObjectRequest, fileOrig, isOrig, req.getInputStream(), this.log);
        }
        this.cos.putObject(this.updateInstructionPutRequest(putInstFileRequest, cekMaterial));
        return result;
    }

    @Override
    public final void abortMultipartUploadSecurely(AbortMultipartUploadRequest req) {
        this.cos.abortMultipartUpload(req);
        this.multipartUploadContexts.remove(req.getUploadId());
    }

    @Override
    public final CopyPartResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        String uploadId = copyPartRequest.getUploadId();
        MultipartUploadCryptoContext uploadContext = this.multipartUploadContexts.get(uploadId);
        CopyPartResult result = this.cos.copyPart(copyPartRequest);
        if (uploadContext != null && !uploadContext.hasFinalPartBeenSeen()) {
            uploadContext.setHasFinalPartBeenSeen(true);
        }
        return result;
    }

    abstract MultipartUploadCryptoContext newUploadContext(InitiateMultipartUploadRequest var1, ContentCryptoMaterial var2);

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest req) {
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(req);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            ObjectMetadata metadata = req.getObjectMetadata();
            if (metadata == null) {
                metadata = new ObjectMetadata();
            }
            long dataSize = req.getDataSize();
            long partSize = req.getPartSize();
            if (dataSize < 0L || partSize < 0L) {
                throw new CosClientException("initiate multipart upload with encryption client must set dataSize and partSize");
            }
            if (partSize % 16L != 0L) {
                throw new CosClientException("initiat multipart uplaod with encryption client must set part size a mutiple of 16but got " + partSize);
            }
            metadata.addUserMetadata("client-side-encryption-data-size", Long.toString(dataSize));
            metadata.addUserMetadata("client-side-encryption-part-size", Long.toString(partSize));
            req.setObjectMetadata(this.updateMetadataWithContentCryptoMaterial(metadata, null, cekMaterial));
        }
        InitiateMultipartUploadResult result = this.cos.initiateMultipartUpload(req);
        MultipartUploadCryptoContext uploadContext = this.newUploadContext(req, cekMaterial);
        if (req instanceof MaterialsDescriptionProvider) {
            MaterialsDescriptionProvider p = (MaterialsDescriptionProvider)((Object)req);
            uploadContext.setMaterialsDescription(p.getMaterialsDescription());
        }
        this.multipartUploadContexts.put(result.getUploadId(), uploadContext);
        return result;
    }

    abstract CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext var1);

    abstract long computeLastPartSize(UploadPartRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest req) {
        UploadPartResult result;
        boolean partSizeMultipleOfCipherBlockSize;
        int blockSize = this.contentCryptoScheme.getBlockSizeInBytes();
        boolean isLastPart = req.isLastPart();
        String uploadId = req.getUploadId();
        long partSize = req.getPartSize();
        boolean bl = partSizeMultipleOfCipherBlockSize = 0L == partSize % (long)blockSize;
        if (!isLastPart && !partSizeMultipleOfCipherBlockSize) {
            throw new CosClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + blockSize + ") with the exception of the last part.");
        }
        MultipartUploadCryptoContext uploadContext = this.multipartUploadContexts.get(uploadId);
        if (uploadContext == null) {
            throw new CosClientException("No client-side information available on upload ID " + uploadId);
        }
        uploadContext.beginPartUpload(req.getPartNumber());
        CipherLite cipherLite = this.cipherLiteForNextPart(uploadContext);
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        CipherLiteInputStream isCurr = null;
        try {
            CipherLiteInputStream clis;
            isCurr = clis = this.newMultipartCOSCipherInputStream(req, cipherLite);
            req.setInputStream(isCurr);
            req.setFile(null);
            req.setFileOffset(0L);
            if (isLastPart) {
                long lastPartSize = this.computeLastPartSize(req);
                if (lastPartSize > -1L) {
                    req.setPartSize(lastPartSize);
                }
                if (uploadContext.hasFinalPartBeenSeen()) {
                    throw new CosClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part.");
                }
            }
            result = this.cos.uploadPart(req);
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(req, fileOrig, isOrig, isCurr, this.log);
            uploadContext.endPartUpload();
        }
        if (isLastPart) {
            uploadContext.setHasFinalPartBeenSeen(true);
        }
        return result;
    }

    protected final CipherLiteInputStream newMultipartCOSCipherInputStream(UploadPartRequest req, CipherLite cipherLite) {
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        InputStream isCurr = null;
        try {
            if (fileOrig == null) {
                if (isOrig == null) {
                    throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
                }
                isCurr = isOrig;
            } else {
                isCurr = new ResettableInputStream(fileOrig);
            }
            isCurr = new InputSubstream(isCurr, req.getFileOffset(), req.getPartSize(), req.isLastPart());
            return cipherLite.markSupported() ? new CipherLiteInputStream(isCurr, cipherLite, 2048, true, req.isLastPart()) : new RenewableCipherLiteInputStream(isCurr, cipherLite, 2048, true, req.isLastPart());
        }
        catch (Exception e) {
            CosDataSource.Utils.cleanupDataSource(req, fileOrig, isOrig, isCurr, this.log);
            throw new CosClientException("Unable to create cipher input stream", e);
        }
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest req) {
        String uploadId = req.getUploadId();
        MultipartUploadCryptoContext uploadContext = this.multipartUploadContexts.get(uploadId);
        if (uploadContext != null && !uploadContext.hasFinalPartBeenSeen()) {
            throw new CosClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in COS is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult result = this.cos.completeMultipartUpload(req);
        if (uploadContext != null && this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            this.cos.putObject(this.createInstructionPutRequest(uploadContext.getBucketName(), uploadContext.getKey(), uploadContext.getContentCryptoMaterial()));
        }
        this.multipartUploadContexts.remove(uploadId);
        return result;
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata metadata, File file, ContentCryptoMaterial instruction) {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        return instruction.toObjectMetadata(metadata, this.cryptoConfig.getCryptoMode());
    }

    protected final ContentCryptoMaterial createContentCryptoMaterial(CosServiceRequest req) {
        EncryptionMaterialsFactory f;
        EncryptionMaterials materials;
        if (req instanceof EncryptionMaterialsFactory && (materials = (f = (EncryptionMaterialsFactory)((Object)req)).getEncryptionMaterials()) != null) {
            return this.buildContentCryptoMaterial(materials, this.cryptoConfig.getCryptoProvider(), req);
        }
        if (req instanceof MaterialsDescriptionProvider) {
            EncryptionMaterials material;
            MaterialsDescriptionProvider mdp = (MaterialsDescriptionProvider)((Object)req);
            Map<String, String> matdesc_req = mdp.getMaterialsDescription();
            ContentCryptoMaterial ccm = this.newContentCryptoMaterial(this.kekMaterialsProvider, matdesc_req, this.cryptoConfig.getCryptoProvider(), req);
            if (ccm != null) {
                return ccm;
            }
            if (matdesc_req != null && !(material = this.kekMaterialsProvider.getEncryptionMaterials()).isKMSEnabled()) {
                throw new CosClientException("No material available from the encryption material provider for description " + matdesc_req);
            }
        }
        return this.newContentCryptoMaterial(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), req);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Map<String, String> materialsDescription, Provider provider, CosServiceRequest req) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials(materialsDescription);
        if (kekMaterials == null) {
            return null;
        }
        return this.buildContentCryptoMaterial(kekMaterials, provider, req);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Provider provider, CosServiceRequest req) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials();
        if (kekMaterials == null) {
            throw new CosClientException("No material available from the encryption material provider");
        }
        return this.buildContentCryptoMaterial(kekMaterials, provider, req);
    }

    private ContentCryptoMaterial buildContentCryptoMaterial(EncryptionMaterials materials, Provider provider, CosServiceRequest req) {
        byte[] iv = this.contentCryptoScheme.getIV();
        if (iv == null) {
            iv = new byte[this.contentCryptoScheme.getIVLengthInBytes()];
            this.cryptoScheme.getSecureRandom().nextBytes(iv);
        }
        if (materials.isKMSEnabled()) {
            Map<String, String> encryptionContext = ContentCryptoMaterial.mergeMaterialDescriptions(materials, req);
            GenerateDataKeyRequest keyGenReq = new GenerateDataKeyRequest();
            try {
                ObjectMapper mapper = new ObjectMapper();
                keyGenReq.setEncryptionContext(mapper.writeValueAsString(encryptionContext));
            }
            catch (JsonProcessingException e) {
                throw new CosClientException("generate datakey request set encryption context got json processing exception", e);
            }
            keyGenReq.setKeyId(materials.getCustomerMasterKeyId());
            keyGenReq.setKeySpec(this.contentCryptoScheme.getKeySpec());
            GenerateDataKeyResponse keyGenRes = this.kms.generateDataKey(keyGenReq);
            byte[] key = Base64.decode(keyGenRes.getPlaintext());
            SecretKeySpec cek = new SecretKeySpec(key, this.contentCryptoScheme.getKeyGeneratorAlgorithm());
            byte[] keyBlob = keyGenRes.getCiphertextBlob().getBytes();
            byte[] securedIV = ContentCryptoMaterial.encryptIV(iv, materials, this.cryptoScheme.getKeyWrapScheme(), this.cryptoScheme.getSecureRandom(), provider, this.kms, req);
            return ContentCryptoMaterial.wrap(cek, iv, this.contentCryptoScheme, provider, new KMSSecuredCEK(keyBlob, encryptionContext), securedIV);
        }
        return ContentCryptoMaterial.create(this.generateCEK(materials, provider), iv, materials, this.cryptoScheme, provider, this.kms, req);
    }

    protected final SecretKey generateCEK(EncryptionMaterials kekMaterials, Provider providerIn) {
        String keygenAlgo = this.contentCryptoScheme.getKeyGeneratorAlgorithm();
        try {
            String keyWrapAlgo;
            KeyGenerator generator = providerIn == null ? KeyGenerator.getInstance(keygenAlgo) : KeyGenerator.getInstance(keygenAlgo, providerIn);
            generator.init(this.contentCryptoScheme.getKeyLengthInBits(), this.cryptoScheme.getSecureRandom());
            boolean involvesBCPublicKey = false;
            KeyPair keypair = kekMaterials.getKeyPair();
            if (keypair != null && (keyWrapAlgo = this.cryptoScheme.getKeyWrapScheme().getKeyWrapAlgorithm(keypair.getPublic())) == null) {
                Provider provider = generator.getProvider();
                String providerName = provider == null ? null : provider.getName();
                involvesBCPublicKey = "BC".equals(providerName);
            }
            SecretKey secretKey = generator.generateKey();
            if (!involvesBCPublicKey || secretKey.getEncoded()[0] != 0) {
                return secretKey;
            }
            for (int retry = 0; retry < 10; ++retry) {
                secretKey = generator.generateKey();
                if (secretKey.getEncoded()[0] == 0) continue;
                return secretKey;
            }
            throw new CosClientException("Failed to generate secret key");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CosClientException("Unable to generate envelope symmetric key:" + e.getMessage(), e);
        }
    }

    protected final <R extends AbstractPutObjectRequest> R wrapWithCipher(R request, ContentCryptoMaterial cekMaterial) {
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (metadata.getContentMD5() != null) {
            metadata.addUserMetadata("client-side-encryption-unencrypted-content-md5", metadata.getContentMD5());
        }
        metadata.setContentMD5(null);
        long plaintextLength = this.plaintextLength(request, metadata);
        if (plaintextLength >= 0L) {
            metadata.addUserMetadata("client-side-encryption-unencrypted-content-length", Long.toString(plaintextLength));
            metadata.setContentLength(this.ciphertextLength(plaintextLength));
        }
        request.setMetadata(metadata);
        request.setInputStream(this.newCOSCipherLiteInputStream(request, cekMaterial, plaintextLength));
        request.setFile(null);
        return request;
    }

    private CipherLiteInputStream newCOSCipherLiteInputStream(AbstractPutObjectRequest req, ContentCryptoMaterial cekMaterial, long plaintextLength) {
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        SdkFilterInputStream isCurr = null;
        try {
            CipherLite cipherLite;
            isCurr = fileOrig == null ? (isOrig == null ? null : ReleasableInputStream.wrap(isOrig)) : new ResettableInputStream(fileOrig);
            if (plaintextLength > -1L) {
                isCurr = new LengthCheckInputStream(isCurr, plaintextLength, false);
            }
            if ((cipherLite = cekMaterial.getCipherLite()).markSupported()) {
                return new CipherLiteInputStream(isCurr, cipherLite, 2048);
            }
            return new RenewableCipherLiteInputStream(isCurr, cipherLite, 2048);
        }
        catch (Exception e) {
            CosDataSource.Utils.cleanupDataSource(req, fileOrig, isOrig, isCurr, this.log);
            throw new CosClientException("Unable to create cipher input stream", e);
        }
    }

    protected final long plaintextLength(AbstractPutObjectRequest request, ObjectMetadata metadata) {
        if (request.getFile() != null) {
            return request.getFile().length();
        }
        if (request.getInputStream() != null && metadata.getRawMetadataValue("Content-Length") != null) {
            return metadata.getContentLength();
        }
        return -1L;
    }

    public final COSCryptoScheme getCOSCryptoScheme() {
        return this.cryptoScheme;
    }

    protected final PutObjectRequest updateInstructionPutRequest(PutObjectRequest req, ContentCryptoMaterial cekMaterial) {
        byte[] bytes = cekMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ObjectMetadata metadata = req.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
            req.setMetadata(metadata);
        }
        metadata.setContentLength(bytes.length);
        metadata.addUserMetadata("x-cos-crypto-instr-file", "");
        req.setMetadata(metadata);
        req.setInputStream(new ByteArrayInputStream(bytes));
        return req;
    }

    protected final PutObjectRequest createInstructionPutRequest(String bucketName, String key, ContentCryptoMaterial cekMaterial) {
        byte[] bytes = cekMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(bytes.length);
        metadata.addUserMetadata("x-cos-crypto-instr-file", "");
        InstructionFileId ifileId = new COSObjectId(bucketName, key).instructionFileId();
        return new PutObjectRequest(ifileId.getBucket(), ifileId.getKey(), is, metadata);
    }

    protected void securityCheck(ContentCryptoMaterial cekMaterial, COSObjectWrapper retrieved) {
    }

    final COSObjectWrapper fetchInstructionFile(COSObjectId cosObjectId, String instFileSuffix) {
        try {
            COSObject o = this.cos.getObject(this.createInstructionGetRequest(cosObjectId, instFileSuffix));
            return o == null ? null : new COSObjectWrapper(o, cosObjectId);
        }
        catch (CosServiceException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to retrieve instruction file : " + e.getMessage());
            }
            return null;
        }
    }

    @Override
    public final PutObjectResult putInstructionFileSecurely(PutInstructionFileRequest req) {
        COSObjectId id = req.getCOSObjectId();
        GetObjectRequest getreq = new GetObjectRequest(id);
        COSObject retrieved = this.cos.getObject(getreq);
        IOUtils.closeQuietly(retrieved, this.log);
        if (retrieved == null) {
            throw new IllegalArgumentException("The specified COS object (" + id + ") doesn't exist.");
        }
        COSObjectWrapper wrapped = new COSObjectWrapper(retrieved, id);
        try {
            ContentCryptoMaterial origCCM = this.contentCryptoMaterialOf(wrapped);
            this.securityCheck(origCCM, wrapped);
            EncryptionMaterials newKEK = req.getEncryptionMaterials();
            ContentCryptoMaterial newCCM = newKEK == null ? origCCM.recreate(req.getMaterialsDescription(), (EncryptionMaterialsAccessor)this.kekMaterialsProvider, this.cryptoScheme, this.cryptoConfig.getCryptoProvider(), this.kms, (CosServiceRequest)req) : origCCM.recreate(newKEK, (EncryptionMaterialsAccessor)this.kekMaterialsProvider, this.cryptoScheme, this.cryptoConfig.getCryptoProvider(), this.kms, (CosServiceRequest)req);
            PutObjectRequest putInstFileRequest = req.createPutObjectRequest(retrieved);
            return this.cos.putObject(this.updateInstructionPutRequest(putInstFileRequest, newCCM));
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw ex;
        }
        catch (Error error) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw error;
        }
    }

    private ContentCryptoMaterial contentCryptoMaterialOf(COSObjectWrapper cosObjWrap) {
        if (cosObjWrap.hasEncryptionInfo()) {
            return ContentCryptoMaterial.fromObjectMetadata(cosObjWrap.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), false, this.kms);
        }
        COSObjectWrapper orig_ifile = this.fetchInstructionFile(cosObjWrap.getCOSObjectId(), null);
        if (orig_ifile == null) {
            throw new IllegalArgumentException("COS object is not encrypted: " + cosObjWrap);
        }
        String json = orig_ifile.toJsonString();
        return this.ccmFromJson(json);
    }

    private ContentCryptoMaterial ccmFromJson(String json) {
        Map<String, String> instruction = Collections.unmodifiableMap(Jackson.fromJsonString(json, Map.class));
        return ContentCryptoMaterial.fromInstructionFile(instruction, this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), false, this.kms);
    }

    final GetObjectRequest createInstructionGetRequest(COSObjectId id) {
        return this.createInstructionGetRequest(id, null);
    }

    final GetObjectRequest createInstructionGetRequest(COSObjectId cosobjectId, String instFileSuffix) {
        return new GetObjectRequest(cosobjectId.instructionFileId(instFileSuffix));
    }

    static long[] getAdjustedCryptoRange(long[] range) {
        if (range == null || range[0] > range[1]) {
            return null;
        }
        long[] adjustedCryptoRange = new long[]{COSCryptoModuleBase.getCipherBlockLowerBound(range[0]), COSCryptoModuleBase.getCipherBlockUpperBound(range[1])};
        return adjustedCryptoRange;
    }

    private static long getCipherBlockLowerBound(long leftmostBytePosition) {
        long cipherBlockSize = 16L;
        long offset = leftmostBytePosition % cipherBlockSize;
        long lowerBound = leftmostBytePosition - offset - cipherBlockSize;
        return lowerBound < 0L ? 0L : lowerBound;
    }

    private static long getCipherBlockUpperBound(long rightmostBytePosition) {
        long cipherBlockSize = 16L;
        long offset = cipherBlockSize - rightmostBytePosition % cipherBlockSize;
        long upperBound = rightmostBytePosition + offset + cipherBlockSize;
        return upperBound < 0L ? Long.MAX_VALUE : upperBound;
    }
}

