/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.AbstractPFSClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.DownloadResumableClient;
import com.obs.services.internal.UploadResumableClient;
import com.obs.services.internal.task.DefaultTaskProgressStatus;
import com.obs.services.internal.task.DropFolderTask;
import com.obs.services.internal.task.LazyTaksCallback;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.DownloadFileRequest;
import com.obs.services.model.DownloadFileResult;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.MonitorableProgressListener;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObsObject;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.TaskProgressListener;
import com.obs.services.model.TaskProgressStatus;
import com.obs.services.model.UploadFileRequest;
import com.obs.services.model.fs.DropFolderRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class AbstractFileClient
extends AbstractPFSClient {
    private static final ILogger ILOG = LoggerBuilder.getLogger(AbstractFileClient.class);

    @Override
    public CompleteMultipartUploadResult uploadFile(UploadFileRequest uploadFileRequest) throws ObsException {
        return new UploadResumableClient(this).uploadFileResume(uploadFileRequest);
    }

    @Override
    public DownloadFileResult downloadFile(DownloadFileRequest downloadFileRequest) throws ObsException {
        try {
            DownloadFileResult downloadFileResult = new DownloadResumableClient(this).downloadFileResume(downloadFileRequest);
            return downloadFileResult;
        }
        finally {
            if (null != downloadFileRequest.getProgressListener() && downloadFileRequest.getProgressListener() instanceof MonitorableProgressListener) {
                ((MonitorableProgressListener)downloadFileRequest.getProgressListener()).finishOneTask();
            }
        }
    }

    @Override
    public TaskProgressStatus dropFolder(DropFolderRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "DropFolderRequest is null");
        if (!this.isCname()) {
            ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        }
        ThreadPoolExecutor executor = this.initThreadPool(request);
        DefaultTaskProgressStatus progressStatus = new DefaultTaskProgressStatus();
        try {
            String folderName = request.getFolderName();
            String delimiter = this.getFileSystemDelimiter();
            if (!folderName.endsWith(delimiter)) {
                folderName = folderName + delimiter;
            }
            LazyTaksCallback<DeleteObjectResult, String> callback = request.getCallback() == null ? new LazyTaksCallback() : request.getCallback();
            TaskProgressListener listener = request.getProgressListener();
            int interval = request.getProgressInterval();
            int[] totalTasks = new int[]{0};
            boolean isSubDeleted = this.recurseFolders(request, folderName, callback, progressStatus, executor, totalTasks);
            HashMap futures = new HashMap();
            totalTasks[0] = totalTasks[0] + 1;
            progressStatus.setTotalTaskNum(totalTasks[0]);
            if (isSubDeleted) {
                this.submitDropTask(request, folderName, callback, progressStatus, executor, futures);
                this.checkDropFutures(futures, progressStatus, callback, listener, interval);
            } else {
                progressStatus.failTaskIncrement();
                callback.onException(new ObsException("Failed to delete due to child file deletion failed"), folderName);
                this.recordBulkTaskStatus(progressStatus, callback, listener, interval);
            }
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (ObsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
        return progressStatus;
    }

    private boolean recurseFolders(DropFolderRequest dropRequest, String folders, TaskCallback<DeleteObjectResult, String> callback, DefaultTaskProgressStatus progressStatus, ThreadPoolExecutor executor, int[] count) {
        ObjectListing result;
        ListObjectsRequest request = new ListObjectsRequest(dropRequest.getBucketName());
        request.setDelimiter("/");
        request.setPrefix(folders);
        request.setRequesterPays(dropRequest.isRequesterPays());
        request.setEncodingType(dropRequest.getEncodingType());
        boolean isDeleted = true;
        do {
            result = this.listObjects(request);
            HashMap futures = new HashMap();
            for (ObsObject o : result.getObjects()) {
                if (o.getObjectKey().endsWith("/")) continue;
                count[0] = count[0] + 1;
                boolean bl = isDeleted = this.submitDropTask(dropRequest, o.getObjectKey(), callback, progressStatus, executor, futures) && isDeleted;
                if (!ILOG.isInfoEnabled() || count[0] % 1000 != 0) continue;
                ILOG.info("DropFolder: " + Arrays.toString(count) + " tasks have submitted to delete objects");
            }
            for (String prefix : result.getCommonPrefixes()) {
                boolean isSubDeleted = this.recurseFolders(dropRequest, prefix, callback, progressStatus, executor, count);
                count[0] = count[0] + 1;
                if (isSubDeleted) {
                    isDeleted = this.submitDropTask(dropRequest, prefix, callback, progressStatus, executor, futures) && isDeleted;
                } else {
                    progressStatus.failTaskIncrement();
                    callback.onException(new ObsException("Failed to delete due to child file deletion failed"), prefix);
                    this.recordBulkTaskStatus(progressStatus, callback, dropRequest.getProgressListener(), dropRequest.getProgressInterval());
                }
                if (!ILOG.isInfoEnabled() || count[0] % 1000 != 0) continue;
                ILOG.info("DropFolder: " + Arrays.toString(count) + " tasks have submitted to delete objects");
            }
            request.setMarker(result.getNextMarker());
            boolean bl = isDeleted = this.checkDropFutures(futures, progressStatus, callback, dropRequest.getProgressListener(), dropRequest.getProgressInterval()) && isDeleted;
        } while (result.isTruncated());
        return isDeleted;
    }

    private boolean submitDropTask(DropFolderRequest request, String key, TaskCallback<DeleteObjectResult, String> callback, DefaultTaskProgressStatus progreStatus, ThreadPoolExecutor executor, Map<String, Future<?>> futures) {
        DropFolderTask task = new DropFolderTask(this, request.getBucketName(), key, progreStatus, request.getProgressListener(), request.getProgressInterval(), callback, request.isRequesterPays());
        try {
            futures.put(key, executor.submit(task));
        }
        catch (RejectedExecutionException e) {
            progreStatus.failTaskIncrement();
            callback.onException(new ObsException(e.getMessage(), e), key);
            return false;
        }
        return true;
    }

    private boolean checkDropFutures(Map<String, Future<?>> futures, DefaultTaskProgressStatus progressStatus, TaskCallback<DeleteObjectResult, String> callback, TaskProgressListener listener, int interval) {
        boolean isDeleted = true;
        for (Map.Entry<String, Future<?>> entry : futures.entrySet()) {
            try {
                entry.getValue().get();
            }
            catch (ExecutionException e) {
                progressStatus.failTaskIncrement();
                if (e.getCause() instanceof ObsException) {
                    callback.onException((ObsException)e.getCause(), entry.getKey());
                } else {
                    callback.onException(new ObsException(e.getMessage(), e), entry.getKey());
                }
                isDeleted = false;
            }
            catch (InterruptedException e) {
                progressStatus.failTaskIncrement();
                callback.onException(new ObsException(e.getMessage(), e), entry.getKey());
                isDeleted = false;
            }
            this.recordBulkTaskStatus(progressStatus, callback, listener, interval);
        }
        return isDeleted;
    }
}

