/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.auth;

import com.google.common.collect.ImmutableMap;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.auth.CredentialsEndpointProvider;
import com.qcloud.cos.auth.HttpCredentialsEndpointProvider;
import com.qcloud.cos.auth.InstanceCredentialsFetcher;
import com.qcloud.cos.auth.InstanceCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.auth.AbstractCOSCredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLFInstanceCredentialsProvider
extends AbstractCOSCredentialProvider
implements COSCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DLFInstanceCredentialsProvider.class);
    private final COSCredentialsProvider cosCredentialsProvider;
    private static final String UIN = "Uin";
    private static final String REQUEST_ID = "RequestId";
    private static final String TYPE = "Type";
    private String url;
    private String path;
    private String uin;
    private String requestId;

    public DLFInstanceCredentialsProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
        if (null != conf) {
            this.url = conf.get("fs.cosn.remote-credential-provider.url");
            this.path = conf.get("fs.cosn.remote-credential-provider.path");
            this.uin = conf.get("fs.cosn.userinfo.uin");
            this.requestId = conf.get("fs.cosn.request.id");
        }
        if (this.uin == null || this.requestId == null) {
            throw new IllegalArgumentException("uin and request id must be exist");
        }
        ImmutableMap header = ImmutableMap.of((Object)UIN, (Object)this.uin, (Object)REQUEST_ID, (Object)this.requestId, (Object)TYPE, (Object)"DLF");
        HttpCredentialsEndpointProvider endpointProvider = new HttpCredentialsEndpointProvider(this.url, this.path, (Map)header);
        InstanceCredentialsFetcher instanceCredentialsFetcher = new InstanceCredentialsFetcher((CredentialsEndpointProvider)endpointProvider);
        this.cosCredentialsProvider = new InstanceCredentialsProvider(instanceCredentialsFetcher);
    }

    public COSCredentials getCredentials() {
        try {
            return this.cosCredentialsProvider.getCredentials();
        }
        catch (CosClientException e) {
            LOG.error("Failed to obtain the credentials from DLFInstanceCredentialsProvider.", (Throwable)e);
            return null;
        }
    }

    public void refresh() {
        this.cosCredentialsProvider.refresh();
    }
}

