/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.auth;

import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.auth.CredentialsEndpointProvider;
import com.qcloud.cos.auth.InstanceCredentialsFetcher;
import com.qcloud.cos.auth.InstanceCredentialsProvider;
import com.qcloud.cos.auth.InstanceMetadataCredentialsEndpointProvider;
import com.qcloud.cos.auth.InstanceProfileCredentials;
import com.qcloud.cos.exception.CosClientException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.auth.AbstractCOSCredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPMInstanceCredentialsProvider
extends AbstractCOSCredentialProvider
implements COSCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CPMInstanceCredentialsProvider.class);
    private String appId;
    private final COSCredentialsProvider cosCredentialsProvider;

    public CPMInstanceCredentialsProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
        if (null != conf) {
            this.appId = conf.get("fs.cosn.userinfo.appid");
        }
        InstanceMetadataCredentialsEndpointProvider endpointProvider = new InstanceMetadataCredentialsEndpointProvider(InstanceMetadataCredentialsEndpointProvider.Instance.CPM);
        InstanceCredentialsFetcher instanceCredentialsFetcher = new InstanceCredentialsFetcher((CredentialsEndpointProvider)endpointProvider);
        this.cosCredentialsProvider = new InstanceCredentialsProvider(instanceCredentialsFetcher);
    }

    public COSCredentials getCredentials() {
        try {
            COSCredentials cosCredentials = this.cosCredentialsProvider.getCredentials();
            if (null != this.appId && cosCredentials instanceof InstanceProfileCredentials) {
                return new InstanceProfileCredentials(this.appId, cosCredentials.getCOSAccessKeyId(), cosCredentials.getCOSSecretKey(), ((InstanceProfileCredentials)cosCredentials).getSessionToken(), ((InstanceProfileCredentials)cosCredentials).getExpiredTime());
            }
            return cosCredentials;
        }
        catch (CosClientException e) {
            LOG.error("Failed to obtain the credentials from CAMCPMInstanceCredentialsProvider.", (Throwable)e);
            return null;
        }
    }

    public void refresh() {
        this.cosCredentialsProvider.refresh();
    }
}

