/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.qcloud.chdfs.permission.RangerAccessType;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CosNFileSystem;
import org.apache.hadoop.fs.CosNUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.auth.RangerCredentialsProvider;
import org.apache.hadoop.fs.cosn.ranger.client.RangerQcloudObjectStorageClient;
import org.apache.hadoop.fs.cosn.ranger.security.authorization.AccessType;
import org.apache.hadoop.fs.cosn.ranger.security.authorization.PermissionRequest;
import org.apache.hadoop.fs.cosn.ranger.security.authorization.PermissionResponse;
import org.apache.hadoop.fs.cosn.ranger.security.authorization.RangerAuthPolicyResponse;
import org.apache.hadoop.fs.cosn.ranger.security.authorization.ServiceType;
import org.apache.hadoop.fs.cosn.ranger.security.sts.GetSTSResponse;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerCredentialsClient {
    private static final Logger log = LoggerFactory.getLogger(RangerCredentialsClient.class);
    private Configuration conf;
    private String bucket;
    public RangerQcloudObjectStorageClient rangerQcloudObjectStorageStorageClient = null;
    private boolean enableRangerPluginPermissionCheck = false;
    private String rangerPolicyUrl;
    private String authJarMd5;

    public void doInitialize(Configuration conf, String bucket) throws IOException {
        this.conf = conf;
        this.bucket = bucket;
        this.initRangerClientImpl(conf);
    }

    public RangerCredentialsClient withBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public void doCheckPermission(Path f, RangerAccessType rangerAccessType, String ownerId, Path workingDirectory) throws IOException {
        if (!this.enableRangerPluginPermissionCheck) {
            return;
        }
        AccessType accessType = null;
        switch (rangerAccessType) {
            case LIST: {
                accessType = AccessType.LIST;
                break;
            }
            case WRITE: {
                accessType = AccessType.WRITE;
                break;
            }
            case READ: {
                accessType = AccessType.READ;
                break;
            }
            case DELETE: {
                accessType = AccessType.DELETE;
                break;
            }
            default: {
                throw new IOException(String.format("unknown access type %s", rangerAccessType.toString()));
            }
        }
        Path absolutePath = this.makeAbsolute(f, workingDirectory);
        String allowKey = CosNFileSystem.pathToKey(absolutePath);
        if (allowKey.startsWith("/")) {
            allowKey = allowKey.substring(1);
        }
        PermissionRequest permissionReq = new PermissionRequest(ServiceType.COS, accessType, CosNUtils.getBucketNameWithoutAppid(this.bucket, this.conf.get("fs.cosn.userinfo.appid")), allowKey, "", "");
        boolean allowed = false;
        String checkPermissionActualUserName = ownerId;
        PermissionResponse permission = this.rangerQcloudObjectStorageStorageClient.checkPermission(permissionReq);
        if (permission != null) {
            allowed = permission.isAllowed();
            if (permission.getRealUserName() != null && !permission.getRealUserName().isEmpty()) {
                checkPermissionActualUserName = permission.getRealUserName();
            }
        }
        if (!allowed) {
            throw new IOException(String.format("Permission denied, [key: %s], [user: %s], [operation: %s]", allowKey, checkPermissionActualUserName, rangerAccessType.name()));
        }
    }

    public void doCheckCustomAuth(Configuration conf) throws IOException {
        GetSTSResponse stsResp;
        if (!this.enableRangerPluginPermissionCheck) {
            return;
        }
        String bucketRegion = conf.get("fs.cosn.bucket.region");
        if (bucketRegion == null || bucketRegion.isEmpty()) {
            bucketRegion = conf.get("fs.cosn.userinfo.region");
        }
        if (!(stsResp = this.rangerQcloudObjectStorageStorageClient.getSTS(bucketRegion, this.bucket)).isCheckAuthPass()) {
            throw new IOException(String.format("Permission denied, [operation: %s], please check user and password", "custom authentication"));
        }
    }

    public Token<?> doGetDelegationToken(String renewer) throws IOException {
        log.info("getDelegationToken, renewer: {}, stack: {}", (Object)renewer, (Object)Arrays.toString(Thread.currentThread().getStackTrace()).replace(',', '\n'));
        if (this.rangerQcloudObjectStorageStorageClient != null) {
            return this.rangerQcloudObjectStorageStorageClient.getDelegationToken(renewer);
        }
        return null;
    }

    public String doGetCanonicalServiceName() {
        if (this.rangerQcloudObjectStorageStorageClient != null) {
            return this.rangerQcloudObjectStorageStorageClient.getCanonicalServiceName();
        }
        return null;
    }

    private Path makeAbsolute(Path path, Path workingDirectory) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(workingDirectory, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRangerClientImpl(Configuration conf) throws IOException {
        Object[] cosClasses = CosNUtils.loadCosProviderClasses(conf, "fs.cosn.credentials.provider", new Class[0]);
        log.info("begin to init ranger client, impl {}", (Object)Arrays.toString(cosClasses));
        if (cosClasses.length == 0) {
            this.enableRangerPluginPermissionCheck = false;
            return;
        }
        for (Object credClass : cosClasses) {
            if (!((Class)credClass).getName().contains(RangerCredentialsProvider.class.getName())) continue;
            this.enableRangerPluginPermissionCheck = true;
            break;
        }
        log.info("begin to init ranger client, enable ranger plugins {}", (Object)this.enableRangerPluginPermissionCheck);
        if (!this.enableRangerPluginPermissionCheck) {
            return;
        }
        Class rangerClientImplClass = conf.getClass("fs.cosn.ranger.plugin.client.impl", null);
        if (rangerClientImplClass == null) {
            try {
                rangerClientImplClass = conf.getClassByName("org.apache.hadoop.fs.cosn.ranger.client.RangerQcloudObjectStorageClientImpl");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.rangerQcloudObjectStorageStorageClient == null) {
            Class<RangerCredentialsClient> clazz = RangerCredentialsClient.class;
            synchronized (RangerCredentialsClient.class) {
                if (this.rangerQcloudObjectStorageStorageClient == null) {
                    try {
                        RangerQcloudObjectStorageClient tmpClient = (RangerQcloudObjectStorageClient)rangerClientImplClass.newInstance();
                        tmpClient.init(conf);
                        this.rangerQcloudObjectStorageStorageClient = tmpClient;
                        log.info("begin to init ranger client, to get auth policy url");
                        RangerAuthPolicyResponse rangerAuthPolicyResp = this.rangerQcloudObjectStorageStorageClient.getRangerAuthPolicy();
                        if (rangerAuthPolicyResp != null) {
                            if (rangerAuthPolicyResp.getRangerPolicyUrl() != null) {
                                this.rangerPolicyUrl = rangerAuthPolicyResp.getRangerPolicyUrl();
                            }
                            if (rangerAuthPolicyResp.getAuthJarMd5() != null) {
                                this.authJarMd5 = rangerAuthPolicyResp.getAuthJarMd5();
                            }
                        }
                        log.info("begin to init ranger client, finish to get auth policy url {}, auth md5 {}", (Object)this.rangerPolicyUrl, (Object)this.authJarMd5);
                    }
                    catch (Exception e) {
                        log.error(String.format("init %s failed", "fs.cosn.ranger.plugin.client.impl"), (Throwable)e);
                        throw new IOException(String.format("init %s failed", "fs.cosn.ranger.plugin.client.impl"), e);
                    }
                }
                // ** MonitorExit[var4_6] (shouldn't be in output)
            }
        }
        log.info("begin to init ranger client, but client is not null, impossible!");
    }

    public String getRangerPolicyUrl() {
        return this.rangerPolicyUrl;
    }

    public String getAuthJarMd5() {
        return this.authJarMd5;
    }

    public boolean isEnableRangerPluginPermissionCheck() {
        return this.enableRangerPluginPermissionCheck;
    }

    public GetSTSResponse getSTS(String bucketRegion, String bucketNameWithoutAppid) throws IOException {
        if (this.rangerQcloudObjectStorageStorageClient != null) {
            return this.rangerQcloudObjectStorageStorageClient.getSTS(bucketRegion, bucketNameWithoutAppid);
        }
        return null;
    }

    public void close() {
        if (this.rangerQcloudObjectStorageStorageClient != null) {
            this.rangerQcloudObjectStorageStorageClient.close();
            this.rangerQcloudObjectStorageStorageClient = null;
        }
    }
}

