/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.obs.OBSFileSystem;
import org.apache.hadoop.fs.obs.OBSLoginHelper;
import org.apache.hadoop.fs.obs.OBSUtils;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
interface ObsClientFactory {
    public ObsClient createObsClient(URI var1) throws IOException;

    public static class DefaultObsClientFactory
    extends Configured
    implements ObsClientFactory {
        private static final Logger LOG = OBSFileSystem.LOG;

        @Override
        public ObsClient createObsClient(URI name) throws IOException {
            Configuration conf = this.getConf();
            ObsConfiguration obsConf = new ObsConfiguration();
            DefaultObsClientFactory.initConnectionSettings(conf, obsConf);
            DefaultObsClientFactory.initProxySupport(conf, obsConf);
            return DefaultObsClientFactory.createHuaweiObsClient(conf, obsConf, name);
        }

        private static void initConnectionSettings(Configuration conf, ObsConfiguration obsConf) {
            obsConf.setMaxConnections(OBSUtils.intOption(conf, "fs.obs.connection.maximum", 1000, 1));
            boolean secureConnections = conf.getBoolean("fs.obs.connection.ssl.enabled", false);
            obsConf.setHttpsOnly(secureConnections);
            obsConf.setMaxErrorRetry(OBSUtils.intOption(conf, "fs.obs.attempts.maximum", 3, 0));
            obsConf.setConnectionTimeout(OBSUtils.intOption(conf, "fs.obs.connection.establish.timeout", 60000, 0));
            obsConf.setSocketTimeout(OBSUtils.intOption(conf, "fs.obs.connection.timeout", 60000, 0));
            obsConf.setIdleConnectionTime(OBSUtils.intOption(conf, "fs.obs.idle.connection.time", 30000, 1));
            obsConf.setMaxIdleConnections(OBSUtils.intOption(conf, "fs.obs.max.idle.connections", 10, 1));
            obsConf.setReadBufferSize(OBSUtils.intOption(conf, "fs.obs.read.buffer.size", 8192, -1));
            obsConf.setWriteBufferSize(OBSUtils.intOption(conf, "fs.obs.write.buffer.size", 8192, -1));
            obsConf.setUploadStreamRetryBufferSize(OBSUtils.intOption(conf, "fs.obs.upload.stream.retry.buffer.size", 524288, 1));
            obsConf.setSocketReadBufferSize(OBSUtils.intOption(conf, "fs.obs.socket.recv.buffer", 8192, -1));
            obsConf.setSocketWriteBufferSize(OBSUtils.intOption(conf, "fs.obs.socket.send.buffer", 8192, -1));
            obsConf.setKeepAlive(conf.getBoolean("fs.obs.keep.alive", true));
            obsConf.setValidateCertificate(conf.getBoolean("fs.obs.validate.certificate", false));
            obsConf.setVerifyResponseContentType(conf.getBoolean("fs.obs.verify.response.content.type", true));
            obsConf.setCname(conf.getBoolean("fs.obs.cname", false));
            obsConf.setIsStrictHostnameVerification(conf.getBoolean("fs.obs.strict.hostname.verification", false));
        }

        private static void initProxySupport(Configuration conf, ObsConfiguration obsConf) throws IllegalArgumentException, IOException {
            String proxyHost = conf.getTrimmed("fs.obs.proxy.host", "");
            int proxyPort = conf.getInt("fs.obs.proxy.port", -1);
            if (!proxyHost.isEmpty() && proxyPort < 0) {
                if (conf.getBoolean("fs.obs.connection.ssl.enabled", false)) {
                    LOG.warn("Proxy host set without port. Using HTTPS default 443");
                    obsConf.getHttpProxy().setProxyPort(443);
                } else {
                    LOG.warn("Proxy host set without port. Using HTTP default 80");
                    obsConf.getHttpProxy().setProxyPort(80);
                }
            }
            String proxyUsername = conf.getTrimmed("fs.obs.proxy.username");
            String proxyPassword = null;
            char[] proxyPass = conf.getPassword("fs.obs.proxy.password");
            if (proxyPass != null) {
                proxyPassword = new String(proxyPass).trim();
            }
            if (proxyUsername == null != (proxyPassword == null)) {
                String msg = "Proxy error: fs.obs.proxy.username or fs.obs.proxy.password set without the other.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            obsConf.setHttpProxy(proxyHost, proxyPort, proxyUsername, proxyPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using proxy server {}:{} as user {} on domain {} as workstation {}", new Object[]{obsConf.getHttpProxy().getProxyAddr(), obsConf.getHttpProxy().getProxyPort(), String.valueOf(obsConf.getHttpProxy().getProxyUName()), obsConf.getHttpProxy().getDomain(), obsConf.getHttpProxy().getWorkstation()});
            }
        }

        private static ObsClient createHuaweiObsClient(Configuration conf, ObsConfiguration obsConf, URI name) throws IOException {
            OBSLoginHelper.Login creds = OBSUtils.getOBSAccessKeys(name, conf);
            String Ak = creds.getUser();
            String Sk = creds.getPassword();
            String endPoint = conf.getTrimmed("fs.obs.endpoint", "");
            obsConf.setEndPoint(endPoint);
            ObsClient obsClient = new ObsClient(Ak, Sk, obsConf);
            return obsClient;
        }
    }
}

