/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.obs.services.exception.ObsException;
import com.obs.services.model.ObsObject;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.obs.OBSFileStatus;
import org.apache.hadoop.fs.obs.OBSFileSystem;
import org.apache.hadoop.fs.obs.OBSIOException;
import org.apache.hadoop.fs.obs.OBSLoginHelper;
import org.apache.hadoop.security.ProviderUtils;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class OBSUtils {
    private static final Logger LOG = OBSFileSystem.LOG;
    static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";

    private OBSUtils() {
    }

    public static IOException extractException(String operation, String path, ExecutionException ee) {
        Throwable cause = ee.getCause();
        IOException ioe = cause instanceof ObsException ? OBSUtils.translateException(operation, path, (ObsException)cause) : (cause instanceof IOException ? (IOException)cause : new IOException(operation + " failed: " + cause, cause));
        return ioe;
    }

    static boolean containsInterruptedException(Throwable thrown) {
        if (thrown == null) {
            return false;
        }
        if (thrown instanceof InterruptedException || thrown instanceof InterruptedIOException) {
            return true;
        }
        return OBSUtils.containsInterruptedException(thrown.getCause());
    }

    public static OBSFileStatus createFileStatus(Path keyPath, ObsObject summary, long blockSize, String owner) {
        if (OBSUtils.objectRepresentsDirectory(summary.getObjectKey(), summary.getMetadata().getContentLength())) {
            return new OBSFileStatus(true, keyPath, owner);
        }
        return new OBSFileStatus(summary.getMetadata().getContentLength(), OBSUtils.dateToLong(summary.getMetadata().getLastModified()), keyPath, blockSize, owner);
    }

    public static boolean objectRepresentsDirectory(String name, long size) {
        return !name.isEmpty() && name.charAt(name.length() - 1) == '/' && size == 0L;
    }

    public static long dateToLong(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public static OBSLoginHelper.Login getOBSAccessKeys(URI name, Configuration conf) throws IOException {
        OBSLoginHelper.Login login = OBSLoginHelper.extractLoginDetailsWithWarnings(name);
        Configuration c = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)conf, OBSFileSystem.class);
        String accessKey = OBSUtils.getPassword(c, "fs.obs.access.key", login.getUser());
        String secretKey = OBSUtils.getPassword(c, "fs.obs.secret.key", login.getPassword());
        return new OBSLoginHelper.Login(accessKey, secretKey);
    }

    static String getPassword(Configuration conf, String key, String val) throws IOException {
        return StringUtils.isEmpty((String)val) ? OBSUtils.lookupPassword(conf, key, "") : val;
    }

    static String lookupPassword(Configuration conf, String key, String defVal) throws IOException {
        try {
            char[] pass = conf.getPassword(key);
            return pass != null ? new String(pass).trim() : defVal;
        }
        catch (IOException ioe) {
            throw new IOException("Cannot find password option " + key, ioe);
        }
    }

    public static String stringify(ObsObject summary) {
        StringBuilder builder = new StringBuilder(summary.getObjectKey().length() + 100);
        builder.append(summary.getObjectKey()).append(' ');
        builder.append("size=").append(summary.getMetadata().getContentLength());
        return builder.toString();
    }

    static int intOption(Configuration conf, String key, int defVal, int min) {
        int v = conf.getInt(key, defVal);
        Preconditions.checkArgument((v >= min ? 1 : 0) != 0, (Object)String.format("Value of %s: %d is below the minimum value %d", key, v, min));
        LOG.debug("Value of {} is {}", (Object)key, (Object)v);
        return v;
    }

    static long longOption(Configuration conf, String key, long defVal, long min) {
        long v = conf.getLong(key, defVal);
        Preconditions.checkArgument((v >= min ? 1 : 0) != 0, (Object)String.format("Value of %s: %d is below the minimum value %d", key, v, min));
        LOG.debug("Value of {} is {}", (Object)key, (Object)v);
        return v;
    }

    static long longBytesOption(Configuration conf, String key, long defVal, long min) {
        long v = conf.getLongBytes(key, defVal);
        Preconditions.checkArgument((v >= min ? 1 : 0) != 0, (Object)String.format("Value of %s: %d is below the minimum value %d", key, v, min));
        LOG.debug("Value of {} is {}", (Object)key, (Object)v);
        return v;
    }

    public static long getMultipartSizeProperty(Configuration conf, String property, long defVal) {
        long partSize = conf.getLongBytes(property, defVal);
        if (partSize < 0x500000L) {
            LOG.warn("{} must be at least 5 MB; configured value is {}", (Object)property, (Object)partSize);
            partSize = 0x500000L;
        }
        return partSize;
    }

    public static int ensureOutputParameterInRange(String name, long size) {
        if (size > Integer.MAX_VALUE) {
            LOG.warn("obs: {} capped to ~2.14GB (maximum allowed size with current output mechanism)", (Object)name);
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    private static Constructor<?> getConstructor(Class<?> cl, Class<?> ... args) {
        try {
            Constructor<?> cons = cl.getDeclaredConstructor(args);
            return Modifier.isPublic(cons.getModifiers()) ? cons : null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private static Method getFactoryMethod(Class<?> cl, Class<?> returnType, String methodName) {
        try {
            Method m = cl.getDeclaredMethod(methodName, new Class[0]);
            if (Modifier.isPublic(m.getModifiers()) && Modifier.isStatic(m.getModifiers()) && returnType.isAssignableFrom(m.getReturnType())) {
                return m;
            }
            return null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    public static Configuration propagateBucketOptions(Configuration source, String bucket) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)bucket), (Object)"bucket");
        String bucketPrefix = "fs.obs.bucket." + bucket + '.';
        LOG.debug("Propagating entries under {}", (Object)bucketPrefix);
        Configuration dest = new Configuration(source);
        for (Map.Entry entry : source) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(bucketPrefix) || bucketPrefix.equals(key)) continue;
            String stripped = key.substring(bucketPrefix.length());
            if (stripped.startsWith("bucket.") || "impl".equals(stripped)) {
                LOG.debug("Ignoring bucket option {}", (Object)key);
                continue;
            }
            String generic = "fs.obs." + stripped;
            LOG.debug("Updating {}", (Object)generic);
            dest.set(generic, value, key);
        }
        return dest;
    }

    static void patchSecurityCredentialProviders(Configuration conf) {
        Collection customCredentials = conf.getStringCollection("fs.obs.security.credential.provider.path");
        Collection hadoopCredentials = conf.getStringCollection(CREDENTIAL_PROVIDER_PATH);
        if (!customCredentials.isEmpty()) {
            ArrayList all = Lists.newArrayList((Iterable)customCredentials);
            all.addAll(hadoopCredentials);
            String joined = StringUtils.join((Collection)all, (char)',');
            LOG.debug("Setting {} to {}", (Object)CREDENTIAL_PROVIDER_PATH, (Object)joined);
            conf.set(CREDENTIAL_PROVIDER_PATH, joined, "patch of fs.obs.security.credential.provider.path");
        }
    }

    public static void closeAll(Logger log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                if (log != null) {
                    log.debug("Closing {}", (Object)c);
                }
                c.close();
            }
            catch (Exception e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug("Exception in closing {}", (Object)c, (Object)e);
            }
        }
    }

    public static String stringify(ObsException e) {
        StringBuilder builder = new StringBuilder(String.format("request id: %s, response code: %d, error code: %s, hostid: %s, message: %s", e.getErrorRequestId(), e.getResponseCode(), e.getErrorCode(), e.getErrorHostId(), e.getErrorMessage()));
        return builder.toString();
    }

    public static IOException translateException(String operation, String path, ObsException exception) {
        IOException ioe;
        String message = String.format("%s%s: %s", new Object[]{operation, path != null ? " on " + path : "", exception});
        int status = exception.getResponseCode();
        switch (status) {
            case 301: {
                message = String.format("Received permanent redirect response , message %s", exception.getErrorMessage());
                ioe = new OBSIOException(message, exception);
                break;
            }
            case 401: 
            case 403: {
                ioe = new AccessDeniedException(path, null, message);
                ioe.initCause(exception);
                break;
            }
            case 404: 
            case 410: {
                ioe = new FileNotFoundException(message);
                ioe.initCause(exception);
                break;
            }
            case 416: {
                ioe = new EOFException(message);
                break;
            }
            default: {
                ioe = new OBSIOException(message, exception);
            }
        }
        return ioe;
    }

    public static IOException translateException(String operation, Path path, ObsException exception) {
        return OBSUtils.translateException(operation, path.toString(), exception);
    }
}

