/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import java.io.Closeable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.obs.Statistic;
import org.apache.hadoop.metrics2.MetricStringBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metrics(about="Metrics for OBS", context="OBSFileSystem")
@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OBSInstrumentation {
    private static final Logger LOG = LoggerFactory.getLogger(OBSInstrumentation.class);
    public static final String CONTEXT = "OBSFileSystem";
    private final MetricsRegistry registry = new MetricsRegistry("OBSFileSystem").setContext("OBSFileSystem");
    private final MutableCounterLong streamOpenOperations;
    private final MutableCounterLong streamCloseOperations;
    private final MutableCounterLong streamClosed;
    private final MutableCounterLong streamAborted;
    private final MutableCounterLong streamSeekOperations;
    private final MutableCounterLong streamReadExceptions;
    private final MutableCounterLong streamForwardSeekOperations;
    private final MutableCounterLong streamBackwardSeekOperations;
    private final MutableCounterLong streamBytesSkippedOnSeek;
    private final MutableCounterLong streamBytesBackwardsOnSeek;
    private final MutableCounterLong streamBytesRead;
    private final MutableCounterLong streamReadOperations;
    private final MutableCounterLong streamReadFullyOperations;
    private final MutableCounterLong streamReadsIncomplete;
    private final MutableCounterLong streamBytesReadInClose;
    private final MutableCounterLong streamBytesDiscardedInAbort;
    private final MutableCounterLong ignoredErrors;
    private final OBSCounter counterOfFilesCreated;
    private final OBSCounter counterOfFilesCopied;
    private final OBSCounter counterOfFilesDeleted;
    private final OBSCounter counterOfFakeDirectoryDeletes;
    private final OBSCounter counterOfBatchDeletes;
    private final OBSCounter counterOfDirectoriesCreated;
    private final OBSCounter counterOfDirectoriesDeleted;
    private final OBSCounter counterOfFrontEndFilesDeleted;
    private final OBSCounter counterOfFrontEndDirectoryDeletes;
    private final OBSCounter counterOfFilesRenamed;
    private final OBSCounter counterOfDirectoriesRenamed;
    private final OBSCounter counterOfFrontEndFilesRenamed;
    private final OBSCounter counterOfFrontEndDirectoriesRenamed;
    private final OBSCounter counterOfFrontEndExistedDirectoriesRenamed;
    private final OBSCounter counterOfListObjectsInRename;
    private final Map<String, MutableCounterLong> streamMetrics = new HashMap<String, MutableCounterLong>(30);
    private static final Statistic[] COUNTERS_TO_CREATE = new Statistic[]{Statistic.INVOCATION_COPY_FROM_LOCAL_FILE, Statistic.INVOCATION_EXISTS, Statistic.INVOCATION_GET_FILE_STATUS, Statistic.INVOCATION_GLOB_STATUS, Statistic.INVOCATION_IS_DIRECTORY, Statistic.INVOCATION_IS_FILE, Statistic.INVOCATION_LIST_FILES, Statistic.INVOCATION_LIST_LOCATED_STATUS, Statistic.INVOCATION_LIST_STATUS, Statistic.INVOCATION_MKDIRS, Statistic.INVOCATION_RENAME, Statistic.OBJECT_COPY_REQUESTS, Statistic.OBJECT_DELETE_REQUESTS, Statistic.OBJECT_LIST_REQUESTS, Statistic.OBJECT_CONTINUE_LIST_REQUESTS, Statistic.OBJECT_METADATA_REQUESTS, Statistic.OBJECT_MULTIPART_UPLOAD_ABORTED, Statistic.OBJECT_PUT_BYTES, Statistic.OBJECT_PUT_REQUESTS, Statistic.OBJECT_PUT_REQUESTS_COMPLETED, Statistic.STREAM_WRITE_FAILURES, Statistic.STREAM_WRITE_BLOCK_UPLOADS, Statistic.STREAM_WRITE_BLOCK_UPLOADS_COMMITTED, Statistic.STREAM_WRITE_BLOCK_UPLOADS_ABORTED, Statistic.STREAM_WRITE_TOTAL_TIME, Statistic.STREAM_WRITE_TOTAL_DATA};
    private static final Statistic[] GAUGES_TO_CREATE = new Statistic[]{Statistic.OBJECT_PUT_REQUESTS_ACTIVE, Statistic.OBJECT_PUT_BYTES_PENDING, Statistic.STREAM_WRITE_BLOCK_UPLOADS_ACTIVE, Statistic.STREAM_WRITE_BLOCK_UPLOADS_PENDING, Statistic.STREAM_WRITE_BLOCK_UPLOADS_DATA_PENDING};

    public OBSInstrumentation(URI name) {
        UUID fileSystemInstanceId = UUID.randomUUID();
        this.registry.tag("FileSystemId", "A unique identifier for the FS ", fileSystemInstanceId.toString() + "-" + name.getHost());
        this.registry.tag("fsURI", "URI of this filesystem", name.toString());
        this.streamOpenOperations = this.streamCounter(Statistic.STREAM_OPENED);
        this.streamCloseOperations = this.streamCounter(Statistic.STREAM_CLOSE_OPERATIONS);
        this.streamClosed = this.streamCounter(Statistic.STREAM_CLOSED);
        this.streamAborted = this.streamCounter(Statistic.STREAM_ABORTED);
        this.streamSeekOperations = this.streamCounter(Statistic.STREAM_SEEK_OPERATIONS);
        this.streamReadExceptions = this.streamCounter(Statistic.STREAM_READ_EXCEPTIONS);
        this.streamForwardSeekOperations = this.streamCounter(Statistic.STREAM_FORWARD_SEEK_OPERATIONS);
        this.streamBackwardSeekOperations = this.streamCounter(Statistic.STREAM_BACKWARD_SEEK_OPERATIONS);
        this.streamBytesSkippedOnSeek = this.streamCounter(Statistic.STREAM_SEEK_BYTES_SKIPPED);
        this.streamBytesBackwardsOnSeek = this.streamCounter(Statistic.STREAM_SEEK_BYTES_BACKWARDS);
        this.streamBytesRead = this.streamCounter(Statistic.STREAM_SEEK_BYTES_READ);
        this.streamReadOperations = this.streamCounter(Statistic.STREAM_READ_OPERATIONS);
        this.streamReadFullyOperations = this.streamCounter(Statistic.STREAM_READ_FULLY_OPERATIONS);
        this.streamReadsIncomplete = this.streamCounter(Statistic.STREAM_READ_OPERATIONS_INCOMPLETE);
        this.streamBytesReadInClose = this.streamCounter(Statistic.STREAM_CLOSE_BYTES_READ);
        this.streamBytesDiscardedInAbort = this.streamCounter(Statistic.STREAM_ABORT_BYTES_DISCARDED);
        this.counterOfFilesCreated = this.newOBSCounter(Statistic.FILES_CREATED);
        this.counterOfFilesCopied = this.newOBSCounter(Statistic.FILES_COPIED);
        this.counterOfFilesDeleted = this.newOBSCounter(Statistic.FILES_DELETED);
        this.counterOfFakeDirectoryDeletes = this.newOBSCounter(Statistic.FAKE_DIRECTORIES_DELETED);
        this.counterOfFrontEndFilesDeleted = this.newOBSCounter(Statistic.FRONT_END_FILES_DELETED);
        this.counterOfFrontEndDirectoryDeletes = this.newOBSCounter(Statistic.FRONT_END_DIRECTORIES_DELETED);
        this.counterOfBatchDeletes = this.newOBSCounter(Statistic.BATCH_DELETED);
        this.counterOfDirectoriesCreated = this.newOBSCounter(Statistic.DIRECTORIES_CREATED);
        this.counterOfDirectoriesDeleted = this.newOBSCounter(Statistic.DIRECTORIES_DELETED);
        this.counterOfFilesRenamed = this.newOBSCounter(Statistic.FILES_RENAMED);
        this.counterOfDirectoriesRenamed = this.newOBSCounter(Statistic.DIRECTORIES_RENAMED);
        this.counterOfFrontEndFilesRenamed = this.newOBSCounter(Statistic.FRONT_END_FILES_RENAMED);
        this.counterOfFrontEndDirectoriesRenamed = this.newOBSCounter(Statistic.FRONT_END_DIRECTORIES_RENAMED);
        this.counterOfFrontEndExistedDirectoriesRenamed = this.newOBSCounter(Statistic.FRONT_END_EXISTED_DIRECTORIES_RENAMED);
        this.counterOfListObjectsInRename = this.newOBSCounter(Statistic.LIST_OBJECTS_IN_RENAME);
        this.ignoredErrors = this.counter(Statistic.IGNORED_ERRORS);
        for (Statistic statistic : COUNTERS_TO_CREATE) {
            this.counter(statistic);
        }
        for (Statistic statistic : GAUGES_TO_CREATE) {
            this.gauge(statistic.getSymbol(), statistic.getDescription());
        }
    }

    protected final MutableCounterLong counter(String name, String desc) {
        return this.registry.newCounter(name, desc, 0L);
    }

    protected final MutableCounterLong streamCounter(String name, String desc) {
        MutableCounterLong counter = new MutableCounterLong(Interns.info((String)name, (String)desc), 0L);
        this.streamMetrics.put(name, counter);
        return counter;
    }

    protected final MutableCounterLong counter(Statistic op) {
        return this.counter(op.getSymbol(), op.getDescription());
    }

    protected final OBSCounter newOBSCounter(Statistic op) {
        return new OBSCounter(op);
    }

    protected final MutableCounterLong streamCounter(Statistic op) {
        return this.streamCounter(op.getSymbol(), op.getDescription());
    }

    protected final MutableGaugeLong gauge(String name, String desc) {
        return this.registry.newGauge(name, desc, 0L);
    }

    public MetricsRegistry getRegistry() {
        return this.registry;
    }

    public String dump(String prefix, String separator, String suffix, boolean all) {
        MetricStringBuilder metricBuilder = new MetricStringBuilder(null, prefix, separator, suffix);
        this.registry.snapshot((MetricsRecordBuilder)metricBuilder, all);
        for (Map.Entry<String, MutableCounterLong> entry : this.streamMetrics.entrySet()) {
            metricBuilder.tuple(entry.getKey(), Long.toString(entry.getValue().value()));
        }
        return metricBuilder.toString();
    }

    public long getCounterValue(Statistic statistic) {
        return this.getCounterValue(statistic.getSymbol());
    }

    public long getCounterValue(String name) {
        MutableCounterLong counter = this.lookupCounter(name);
        return counter == null ? 0L : counter.value();
    }

    private MutableCounterLong lookupCounter(String name) {
        MutableMetric metric = this.lookupMetric(name);
        if (metric == null) {
            return null;
        }
        if (!(metric instanceof MutableCounterLong)) {
            throw new IllegalStateException("Metric " + name + " is not a MutableCounterLong: " + metric);
        }
        return (MutableCounterLong)metric;
    }

    public MutableGaugeLong lookupGauge(String name) {
        MutableMetric metric = this.lookupMetric(name);
        if (metric == null) {
            LOG.debug("No gauge {}", (Object)name);
        }
        return (MutableGaugeLong)metric;
    }

    public MutableMetric lookupMetric(String name) {
        MutableMetric metric = this.getRegistry().get(name);
        if (metric == null) {
            metric = (MutableMetric)this.streamMetrics.get(name);
        }
        return metric;
    }

    public void filesCreated(long count, long delay) {
        this.counterOfFilesCreated.incrSuccess(count, delay);
    }

    public void filesCreated() {
        this.counterOfFilesCreated.incrSuccess(1L, 0L);
    }

    public void filesCreatedTotal(long count) {
        this.counterOfFilesCreated.incr(count);
    }

    public void filesDeleted(long count, long delay) {
        this.counterOfFilesDeleted.incrSuccess(count, delay);
    }

    public void filesDeletedTotal(long count) {
        this.counterOfFilesDeleted.incr(count);
    }

    public void fakeDirsDeleted(long count, long delay) {
        this.counterOfFakeDirectoryDeletes.incrSuccess(count, delay);
    }

    public void fakeDirsDeletedTotal(long count) {
        this.counterOfFakeDirectoryDeletes.incr(count);
    }

    public void directoriesCreated(long count, long delay) {
        this.counterOfDirectoriesCreated.incrSuccess(count, delay);
    }

    public void directoriesCreatedTotal(long count) {
        this.counterOfDirectoriesCreated.incr(count);
    }

    public void directoriesDeleted(long count, long delay) {
        this.counterOfDirectoriesDeleted.incrSuccess(count, delay);
    }

    public void directoriesDeletedTotal(long count) {
        this.counterOfDirectoriesDeleted.incr(count);
    }

    public void filesCopied(long count, long delay, long size) {
        this.counterOfFilesCopied.incrSuccess(count, delay, size);
    }

    public void filesCopiedTotal(long count) {
        this.counterOfFilesCopied.incr(count);
    }

    public void filesRenamed(long count, long delay) {
        this.counterOfFilesRenamed.incrSuccess(count, delay);
    }

    public void filesRenamedTotal(long count) {
        this.counterOfFilesRenamed.incr(count);
    }

    public void directoriesRenamed(long count, long delay) {
        this.counterOfDirectoriesRenamed.incrSuccess(count, delay);
    }

    public void directoriesRenamedTotal(long count) {
        this.counterOfDirectoriesRenamed.incr(count);
    }

    public void frontendFilesRenamed(long count, long delay) {
        this.counterOfFrontEndFilesRenamed.incrSuccess(count, delay);
    }

    public void frontendFilesRenamedTotal(long count) {
        this.counterOfFrontEndFilesRenamed.incr(count);
    }

    public String frontendFilesRenamedToString() {
        return this.counterOfFrontEndFilesRenamed.toString();
    }

    public void frontendDirectoriesRenamed(boolean isExisted, long count, long delay) {
        this.counterOfFrontEndDirectoriesRenamed.incrSuccess(count, delay);
        if (isExisted) {
            this.counterOfFrontEndExistedDirectoriesRenamed.incrSuccess(count, delay);
        }
    }

    public void frontendDirectoriesRenamed(boolean isExisted, long delay) {
        this.frontendDirectoriesRenamed(isExisted, 1L, delay);
    }

    public void frontendDirectoriesRenamedTotal(boolean isExisted, long count) {
        this.counterOfFrontEndDirectoriesRenamed.incr(count);
        if (isExisted) {
            this.counterOfFrontEndExistedDirectoriesRenamed.incr(count);
        }
    }

    public String frontendDirectoriesRenamedToString() {
        return this.counterOfFrontEndDirectoriesRenamed.toString() + ", " + this.counterOfFrontEndExistedDirectoriesRenamed.toString();
    }

    public void listObjectsInRename(long count, long delay) {
        this.counterOfListObjectsInRename.incrSuccess(count, delay);
    }

    public void listObjectsInRename(long delay) {
        this.counterOfListObjectsInRename.incrSuccess(1L, delay);
    }

    public void listObjectsInRenameTotal(long count) {
        this.counterOfListObjectsInRename.incr(count);
    }

    public String listObjectsInRenameToString() {
        return this.counterOfListObjectsInRename.toString();
    }

    public void frontendFileDeleted(long count, long delay) {
        this.counterOfFrontEndFilesDeleted.incrSuccess(count, delay);
    }

    public void frontendFileDeletedTotal(long count) {
        this.counterOfFrontEndFilesDeleted.incr(count);
    }

    public void frontendDirectoryDeleted(long count, long delay) {
        this.counterOfFrontEndDirectoryDeletes.incrSuccess(count, delay);
    }

    public void frontendDirectoryDeletedTotal(long count) {
        this.counterOfFrontEndDirectoryDeletes.incr(count);
    }

    public void batchDeleted(long count, long delay) {
        this.counterOfBatchDeletes.incrSuccess(count, delay);
    }

    public void batchDeletedTotal(long count) {
        this.counterOfBatchDeletes.incr(count);
    }

    public void errorIgnored() {
        this.ignoredErrors.incr();
    }

    public void incrementCounter(Statistic op, long count) {
        MutableCounterLong counter = this.lookupCounter(op.getSymbol());
        if (counter != null) {
            counter.incr(count);
        }
    }

    public void incrementCounter(Statistic op, AtomicLong count) {
        this.incrementCounter(op, count.get());
    }

    public void incrementGauge(Statistic op, long count) {
        MutableGaugeLong gauge = this.lookupGauge(op.getSymbol());
        if (gauge != null) {
            gauge.incr(count);
        } else {
            LOG.debug("No Gauge: " + (Object)((Object)op));
        }
    }

    public void decrementGauge(Statistic op, long count) {
        MutableGaugeLong gauge = this.lookupGauge(op.getSymbol());
        if (gauge != null) {
            gauge.decr(count);
        } else {
            LOG.debug("No Gauge: {}", (Object)op);
        }
    }

    InputStreamStatistics newInputStreamStatistics() {
        return new InputStreamStatistics();
    }

    private void mergeInputStreamStatistics(InputStreamStatistics statistics) {
        this.streamOpenOperations.incr(statistics.openOperations);
        this.streamCloseOperations.incr(statistics.closeOperations);
        this.streamClosed.incr(statistics.closed);
        this.streamAborted.incr(statistics.aborted);
        this.streamSeekOperations.incr(statistics.seekOperations);
        this.streamReadExceptions.incr(statistics.readExceptions);
        this.streamForwardSeekOperations.incr(statistics.forwardSeekOperations);
        this.streamBytesSkippedOnSeek.incr(statistics.bytesSkippedOnSeek);
        this.streamBackwardSeekOperations.incr(statistics.backwardSeekOperations);
        this.streamBytesBackwardsOnSeek.incr(statistics.bytesBackwardsOnSeek);
        this.streamBytesRead.incr(statistics.bytesRead);
        this.streamReadOperations.incr(statistics.readOperations);
        this.streamReadFullyOperations.incr(statistics.readFullyOperations);
        this.streamReadsIncomplete.incr(statistics.readsIncomplete);
    }

    OutputStreamStatistics newOutputStreamStatistics(FileSystem.Statistics statistics) {
        return new OutputStreamStatistics(statistics);
    }

    private void mergeOutputStreamStatistics(OutputStreamStatistics statistics) {
        this.incrementCounter(Statistic.STREAM_WRITE_TOTAL_TIME, statistics.totalUploadDuration());
        this.incrementCounter(Statistic.STREAM_WRITE_QUEUE_DURATION, statistics.queueDuration);
        this.incrementCounter(Statistic.STREAM_WRITE_TOTAL_DATA, statistics.bytesUploaded);
        this.incrementCounter(Statistic.STREAM_WRITE_BLOCK_UPLOADS, statistics.blockUploadsCompleted);
    }

    public String renameToString() {
        StringBuilder sb = new StringBuilder("RenameStatistics{ ");
        sb.append(this.counterOfFilesRenamed.toString());
        sb.append(", ").append(this.counterOfDirectoriesRenamed.toString());
        sb.append(", ").append(this.counterOfFrontEndFilesRenamed.toString());
        sb.append(", ").append(this.counterOfFrontEndDirectoriesRenamed.toString());
        sb.append(", ").append(this.counterOfFrontEndExistedDirectoriesRenamed.toString());
        sb.append(", ").append(this.counterOfListObjectsInRename.toString());
        sb.append(", ").append(this.counterOfFilesCreated.toString());
        sb.append(", ").append(this.counterOfFilesCopied.toString());
        sb.append(", ").append(this.counterOfFilesDeleted.toString());
        sb.append(", ").append(this.counterOfFakeDirectoryDeletes.toString());
        sb.append(", ").append(this.counterOfBatchDeletes.toString());
        sb.append(", ").append(this.counterOfDirectoriesCreated.toString());
        sb.append(", ").append(this.counterOfDirectoriesDeleted.toString());
        sb.append(", ").append(this.counterOfFrontEndFilesDeleted.toString());
        sb.append(", ").append(this.counterOfFrontEndDirectoryDeletes.toString());
        sb.append("' }");
        return sb.toString();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public final class OutputStreamStatistics
    implements Closeable {
        private final AtomicLong blocksSubmitted = new AtomicLong(0L);
        private final AtomicLong blocksInQueue = new AtomicLong(0L);
        private final AtomicLong blocksActive = new AtomicLong(0L);
        private final AtomicLong blockUploadsCompleted = new AtomicLong(0L);
        private final AtomicLong blockUploadsFailed = new AtomicLong(0L);
        private final AtomicLong bytesPendingUpload = new AtomicLong(0L);
        private final AtomicLong bytesUploaded = new AtomicLong(0L);
        private final AtomicLong transferDuration = new AtomicLong(0L);
        private final AtomicLong queueDuration = new AtomicLong(0L);
        private final AtomicLong exceptionsInMultipartFinalize = new AtomicLong(0L);
        private final AtomicInteger blocksAllocated = new AtomicInteger(0);
        private final AtomicInteger blocksReleased = new AtomicInteger(0);
        private FileSystem.Statistics statistics;

        public OutputStreamStatistics(FileSystem.Statistics statistics) {
            this.statistics = statistics;
        }

        void blockAllocated() {
            this.blocksAllocated.incrementAndGet();
        }

        void blockReleased() {
            this.blocksReleased.incrementAndGet();
        }

        void blockUploadQueued(int blockSize) {
            this.blocksSubmitted.incrementAndGet();
            this.blocksInQueue.incrementAndGet();
            this.bytesPendingUpload.addAndGet(blockSize);
            OBSInstrumentation.this.incrementGauge(Statistic.STREAM_WRITE_BLOCK_UPLOADS_PENDING, 1L);
            OBSInstrumentation.this.incrementGauge(Statistic.STREAM_WRITE_BLOCK_UPLOADS_DATA_PENDING, blockSize);
        }

        void blockUploadStarted(long duration, int blockSize) {
            this.queueDuration.addAndGet(duration);
            this.blocksInQueue.decrementAndGet();
            this.blocksActive.incrementAndGet();
            OBSInstrumentation.this.incrementGauge(Statistic.STREAM_WRITE_BLOCK_UPLOADS_PENDING, -1L);
            OBSInstrumentation.this.incrementGauge(Statistic.STREAM_WRITE_BLOCK_UPLOADS_ACTIVE, 1L);
        }

        void blockUploadCompleted(long duration, int blockSize) {
            this.transferDuration.addAndGet(duration);
            OBSInstrumentation.this.incrementGauge(Statistic.STREAM_WRITE_BLOCK_UPLOADS_ACTIVE, -1L);
            this.blocksActive.decrementAndGet();
            this.blockUploadsCompleted.incrementAndGet();
        }

        void blockUploadFailed(long duration, int blockSize) {
            this.blockUploadsFailed.incrementAndGet();
        }

        void bytesTransferred(long byteCount) {
            this.bytesUploaded.addAndGet(byteCount);
            this.statistics.incrementBytesWritten(byteCount);
            this.bytesPendingUpload.addAndGet(-byteCount);
            OBSInstrumentation.this.incrementGauge(Statistic.STREAM_WRITE_BLOCK_UPLOADS_DATA_PENDING, -byteCount);
        }

        void exceptionInMultipartComplete() {
            this.exceptionsInMultipartFinalize.incrementAndGet();
        }

        void exceptionInMultipartAbort() {
            this.exceptionsInMultipartFinalize.incrementAndGet();
        }

        public long getBytesPendingUpload() {
            return this.bytesPendingUpload.get();
        }

        @Override
        public void close() {
            if (this.bytesPendingUpload.get() > 0L) {
                LOG.debug("Closing output stream statistics while data is still marked as pending upload in {}", (Object)this);
            }
            OBSInstrumentation.this.mergeOutputStreamStatistics(this);
        }

        long averageQueueTime() {
            return this.blocksSubmitted.get() > 0L ? this.queueDuration.get() / this.blocksSubmitted.get() : 0L;
        }

        double effectiveBandwidth() {
            double duration = (double)this.totalUploadDuration() / 1000.0;
            return duration > 0.0 ? (double)this.bytesUploaded.get() / duration : 0.0;
        }

        long totalUploadDuration() {
            return this.queueDuration.get() + this.transferDuration.get();
        }

        public int blocksAllocated() {
            return this.blocksAllocated.get();
        }

        public int blocksReleased() {
            return this.blocksReleased.get();
        }

        public int blocksActivelyAllocated() {
            return this.blocksAllocated.get() - this.blocksReleased.get();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("OutputStreamStatistics{");
            sb.append("blocksSubmitted=").append(this.blocksSubmitted);
            sb.append(", blocksInQueue=").append(this.blocksInQueue);
            sb.append(", blocksActive=").append(this.blocksActive);
            sb.append(", blockUploadsCompleted=").append(this.blockUploadsCompleted);
            sb.append(", blockUploadsFailed=").append(this.blockUploadsFailed);
            sb.append(", bytesPendingUpload=").append(this.bytesPendingUpload);
            sb.append(", bytesUploaded=").append(this.bytesUploaded);
            sb.append(", blocksAllocated=").append(this.blocksAllocated);
            sb.append(", blocksReleased=").append(this.blocksReleased);
            sb.append(", blocksActivelyAllocated=").append(this.blocksActivelyAllocated());
            sb.append(", exceptionsInMultipartFinalize=").append(this.exceptionsInMultipartFinalize);
            sb.append(", transferDuration=").append(this.transferDuration).append(" ms");
            sb.append(", queueDuration=").append(this.queueDuration).append(" ms");
            sb.append(", averageQueueTime=").append(this.averageQueueTime()).append(" ms");
            sb.append(", totalUploadDuration=").append(this.totalUploadDuration()).append(" ms");
            sb.append(", effectiveBandwidth=").append(this.effectiveBandwidth()).append(" bytes/s");
            sb.append('}');
            return sb.toString();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public final class InputStreamStatistics
    implements AutoCloseable {
        public long openOperations;
        public long closeOperations;
        public long closed;
        public long aborted;
        public long seekOperations;
        public long readExceptions;
        public long forwardSeekOperations;
        public long backwardSeekOperations;
        public long bytesRead;
        public long bytesSkippedOnSeek;
        public long bytesBackwardsOnSeek;
        public long readOperations;
        public long readFullyOperations;
        public long readsIncomplete;

        private InputStreamStatistics() {
        }

        public void seekBackwards(long negativeOffset) {
            ++this.seekOperations;
            ++this.backwardSeekOperations;
            this.bytesBackwardsOnSeek -= negativeOffset;
        }

        public void seekForwards(long skipped) {
            ++this.seekOperations;
            ++this.forwardSeekOperations;
            if (skipped > 0L) {
                this.bytesSkippedOnSeek += skipped;
            }
        }

        public void streamOpened() {
            ++this.openOperations;
        }

        public void streamClose() {
            ++this.closeOperations;
        }

        public void readException() {
            ++this.readExceptions;
        }

        public void bytesRead(long bytes) {
            if (bytes > 0L) {
                this.bytesRead += bytes;
            }
        }

        public void readOperationStarted(long pos, long len) {
            ++this.readOperations;
        }

        public void readFullyOperationStarted(long pos, long len) {
            ++this.readFullyOperations;
        }

        public void readOperationCompleted(int requested, int actual) {
            if (requested > actual) {
                ++this.readsIncomplete;
            }
        }

        @Override
        public void close() {
            OBSInstrumentation.this.mergeInputStreamStatistics(this);
        }

        @InterfaceStability.Unstable
        public String toString() {
            StringBuilder sb = new StringBuilder("StreamStatistics{");
            sb.append("OpenOperations=").append(this.openOperations);
            sb.append(", CloseOperations=").append(this.closeOperations);
            sb.append(", Closed=").append(this.closed);
            sb.append(", Aborted=").append(this.aborted);
            sb.append(", SeekOperations=").append(this.seekOperations);
            sb.append(", ReadExceptions=").append(this.readExceptions);
            sb.append(", ForwardSeekOperations=").append(this.forwardSeekOperations);
            sb.append(", BackwardSeekOperations=").append(this.backwardSeekOperations);
            sb.append(", BytesSkippedOnSeek=").append(this.bytesSkippedOnSeek);
            sb.append(", BytesBackwardsOnSeek=").append(this.bytesBackwardsOnSeek);
            sb.append(", BytesRead=").append(this.bytesRead);
            sb.append(", BytesRead excluding skipped=").append(this.bytesRead - this.bytesSkippedOnSeek);
            sb.append(", ReadOperations=").append(this.readOperations);
            sb.append(", ReadFullyOperations=").append(this.readFullyOperations);
            sb.append(", ReadsIncomplete=").append(this.readsIncomplete);
            sb.append('}');
            return sb.toString();
        }
    }

    public class OBSCounter {
        private String name;
        private MutableCounterLong total;
        private MutableCounterLong success;
        private MutableCounterLong delay;
        private MutableCounterLong bytes;

        public OBSCounter(Statistic op) {
            this.name = op.getSymbol();
            this.total = OBSInstrumentation.this.counter(this.name, op.getDescription());
            this.success = OBSInstrumentation.this.counter(this.name + "_success", op.getDescription().replaceFirst("Total number of", "Total success number of"));
            this.delay = OBSInstrumentation.this.counter(this.name + "_time", op.getDescription().replaceFirst("Total number of", "Total time of"));
            this.bytes = OBSInstrumentation.this.counter(this.name + "_bytes", op.getDescription().replaceFirst("Total number of", "Total bytes of"));
        }

        private void incrCounter(MutableCounterLong counter, long count) {
            if (count > 0L) {
                counter.incr(count);
            }
        }

        public void incr(long count) {
            this.incrCounter(this.total, count);
        }

        public void incrSuccess(long count, long delay, long bytes) {
            this.incrCounter(this.success, count);
            this.incrCounter(this.delay, delay);
            this.incrCounter(this.bytes, bytes);
        }

        public void incrSuccess(long count, long delay) {
            this.incrSuccess(count, delay, 0L);
        }

        public long getTotal() {
            return this.total.value();
        }

        public long getSuccess() {
            return this.success.value();
        }

        public long getDelay() {
            return this.delay.value();
        }

        public long getBytes() {
            return this.bytes.value();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            sb.append("{");
            sb.append("total=").append(this.getTotal());
            sb.append(",succ=").append(this.getSuccess());
            sb.append(",delay=").append(this.getDelay());
            sb.append(",bytes=").append(this.getBytes());
            sb.append('}');
            return sb.toString();
        }
    }
}

