/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import java.util.Locale;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum OBSInputPolicy {
    Normal("normal"),
    Sequential("sequential"),
    Random("random");

    private static final Logger LOG;
    private final String policy;

    private OBSInputPolicy(String policy) {
        this.policy = policy;
    }

    public String toString() {
        return this.policy;
    }

    public static OBSInputPolicy getPolicy(String name) {
        String trimmed;
        switch (trimmed = name.trim().toLowerCase(Locale.ENGLISH)) {
            case "normal": {
                return Normal;
            }
            case "random": {
                return Random;
            }
            case "sequential": {
                return Sequential;
            }
        }
        LOG.warn("Unrecognized fs.obs.experimental.input.fadvise value: \"{}\"", (Object)trimmed);
        return Normal;
    }

    static {
        LOG = LoggerFactory.getLogger(OBSInputPolicy.class);
    }
}

