/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.obs;

import com.google.common.io.ByteStreams;
import com.obs.services.ObsClient;
import com.obs.services.internal.io.UnrecoverableIOException;
import com.obs.services.model.GetObjectRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.obs.ReadBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiReadTask
implements Callable<Void> {
    private final int RETRY_TIME = 3;
    private String bucket;
    private String key;
    private ObsClient client;
    private ReadBuffer readBuffer;
    private static final Logger LOG = LoggerFactory.getLogger(MultiReadTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        GetObjectRequest request = new GetObjectRequest(this.bucket, this.key);
        request.setRangeStart(Long.valueOf(this.readBuffer.getStart()));
        request.setRangeEnd(Long.valueOf(this.readBuffer.getEnd()));
        InputStream stream = null;
        this.readBuffer.setState(ReadBuffer.STATE.ERROR);
        boolean interrupted = false;
        for (int i = 0; i < 3; ++i) {
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Interrupted read task");
                }
                stream = this.client.getObject(request).getObjectContent();
                ByteStreams.readFully((InputStream)stream, (byte[])this.readBuffer.getBuffer(), (int)0, (int)((int)(this.readBuffer.getEnd() - this.readBuffer.getStart() + 1L)));
                this.readBuffer.setState(ReadBuffer.STATE.FINISH);
                Void void_ = null;
                return void_;
            }
            catch (IOException e) {
                if (e instanceof InterruptedIOException) {
                    interrupted = true;
                    throw e;
                }
                LOG.warn("IOException occurred in Read task", (Throwable)e);
                this.readBuffer.setState(ReadBuffer.STATE.ERROR);
                if (i != 2) continue;
                throw e;
            }
            catch (Exception e) {
                this.readBuffer.setState(ReadBuffer.STATE.ERROR);
                if (e instanceof UnrecoverableIOException) {
                    interrupted = true;
                    throw e;
                }
                LOG.warn("Exception occurred in Read task", (Throwable)e);
                if (i != 2) continue;
                throw e;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                if (!interrupted && this.readBuffer.getState() != ReadBuffer.STATE.FINISH) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        throw e;
                    }
                }
            }
        }
        return null;
    }

    public MultiReadTask(String bucket, String key, ObsClient client, ReadBuffer readBuffer) {
        this.bucket = bucket;
        this.key = key;
        this.client = client;
        this.readBuffer = readBuffer;
    }
}

