/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.utils.ServiceUtils;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AccessLoggerUtils {
    private static final ILogger accessLog = LoggerBuilder.getLogger("com.obs.log.AccessLogger");
    private static final ThreadLocal<StringBuilder> threadLocalLog = new ThreadLocal();
    private static final ThreadLocal<SoftReference<SimpleDateFormat>> simpleDateFormateHolder = new ThreadLocal();
    private static final int INDEX = 5;
    public static volatile boolean ACCESSLOG_ENABLED = true;

    private static String getLogPrefix() {
        if (!ACCESSLOG_ENABLED) {
            return "";
        }
        StackTraceElement[] stacktraces = Thread.currentThread().getStackTrace();
        StackTraceElement stacktrace = null;
        stacktrace = stacktraces.length > 5 ? stacktraces[5] : stacktraces[stacktraces.length - 1];
        return stacktrace.getClassName() + "|" + stacktrace.getMethodName() + "|" + stacktrace.getLineNumber() + "|";
    }

    private static StringBuilder getLog() {
        StringBuilder logSb = threadLocalLog.get();
        if (logSb == null) {
            logSb = new StringBuilder();
            threadLocalLog.set(logSb);
        }
        return logSb;
    }

    public static void appendLog(Object log, String level) {
        if (!ACCESSLOG_ENABLED) {
            return;
        }
        Boolean isLog = false;
        if ("info".equalsIgnoreCase(level)) {
            isLog = accessLog.isInfoEnabled();
        } else if ("debug".equalsIgnoreCase(level)) {
            isLog = accessLog.isDebugEnabled();
        } else if ("warn".equalsIgnoreCase(level)) {
            isLog = accessLog.isWarnEnabled();
        } else if ("error".equalsIgnoreCase(level)) {
            isLog = accessLog.isErrorEnabled();
        } else if ("trace".equalsIgnoreCase(level)) {
            isLog = accessLog.isTraceEnabled();
        }
        if (isLog.booleanValue()) {
            StringBuilder sb = new StringBuilder(AccessLoggerUtils.getFormat().format(new Date()));
            sb.append("|").append(AccessLoggerUtils.getLogPrefix()).append(log.toString()).append("\n");
            AccessLoggerUtils.getLog().append(sb.toString());
        }
    }

    public static SimpleDateFormat getFormat() {
        SimpleDateFormat format;
        SoftReference<SimpleDateFormat> holder = simpleDateFormateHolder.get();
        if (holder == null || (format = holder.get()) == null) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
            holder = new SoftReference<SimpleDateFormat>(format);
            simpleDateFormateHolder.set(holder);
        }
        return format;
    }

    public static void printLog() {
        if (!ACCESSLOG_ENABLED) {
            return;
        }
        String message = AccessLoggerUtils.getLog().toString();
        if (ServiceUtils.isValid(message)) {
            accessLog.accessRecord(message);
        }
        threadLocalLog.remove();
    }
}

