/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.handler;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.DefaultXmlHandler;
import com.obs.services.internal.handler.SimpleHandler;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketCorsRule;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CanonicalGrantee;
import com.obs.services.model.CopyPartResult;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.EventTypeEnum;
import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GranteeInterface;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.Multipart;
import com.obs.services.model.MultipartUpload;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.Owner;
import com.obs.services.model.Permission;
import com.obs.services.model.ProtocolEnum;
import com.obs.services.model.Redirect;
import com.obs.services.model.RedirectAllRequest;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RouteRule;
import com.obs.services.model.RouteRuleCondition;
import com.obs.services.model.RuleStatusEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TopicConfiguration;
import com.obs.services.model.VersionOrDeleteMarker;
import com.obs.services.model.VersioningStatusEnum;
import com.obs.services.model.WebsiteConfiguration;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlResponsesSaxParser {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.internal.RestStorageService");
    private XMLReader xr = ServiceUtils.loadXMLReader();

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws ServiceException {
        if (inputStream == null) {
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Parsing XML response document with handler: " + handler.getClass());
            }
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(inputStream));
        }
        catch (Exception t) {
            throw new ServiceException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
        finally {
            ServiceUtils.closeStream(inputStream);
        }
    }

    protected InputStream sanitizeXmlDocument(InputStream inputStream) throws ServiceException {
        ByteArrayInputStream byteArrayInputStream;
        if (inputStream == null) {
            return null;
        }
        BufferedReader br = null;
        try {
            StringBuilder listingDocBuffer = new StringBuilder();
            br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br.read(buf)) != -1) {
                listingDocBuffer.append(buf, 0, read);
            }
            String listingDoc = listingDocBuffer.toString().replaceAll("\r", "&#013;");
            if (log.isTraceEnabled()) {
                log.trace("Response entity: " + listingDoc);
            }
            byteArrayInputStream = new ByteArrayInputStream(listingDoc.getBytes("UTF-8"));
        }
        catch (Throwable t) {
            try {
                throw new ServiceException("Failed to sanitize XML document destined", t);
            }
            catch (Throwable throwable) {
                ServiceUtils.closeStream(br);
                ServiceUtils.closeStream(inputStream);
                throw throwable;
            }
        }
        ServiceUtils.closeStream(br);
        ServiceUtils.closeStream(inputStream);
        return byteArrayInputStream;
    }

    public <T> T parse(InputStream inputStream, Class<T> handlerClass, boolean sanitize) throws ServiceException {
        try {
            T handler = null;
            if (SimpleHandler.class.isAssignableFrom(handlerClass)) {
                Constructor<T> c = handlerClass.getConstructor(XMLReader.class);
                handler = c.newInstance(this.xr);
            } else {
                handler = handlerClass.newInstance();
            }
            if (handler instanceof DefaultHandler) {
                if (sanitize) {
                    inputStream = this.sanitizeXmlDocument(inputStream);
                }
                this.parseXmlInputStream((DefaultHandler)handler, inputStream);
            }
            return handler;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static class BucketReplicationConfigurationHandler
    extends DefaultXmlHandler {
        private ReplicationConfiguration replicationConfiguration = new ReplicationConfiguration();
        private ReplicationConfiguration.Rule currentRule;

        public ReplicationConfiguration getReplicationConfiguration() {
            return this.replicationConfiguration;
        }

        public void startElement(String name) {
            if ("Rule".equals(name)) {
                this.currentRule = new ReplicationConfiguration.Rule();
            } else if ("Destination".equals(name)) {
                this.currentRule.setDestination(new ReplicationConfiguration.Destination());
            }
        }

        public void endElement(String name, String elementText) {
            block15: {
                try {
                    if ("Agency".equals(name)) {
                        this.replicationConfiguration.setAgency(elementText);
                    } else if ("Rule".equals(name)) {
                        this.replicationConfiguration.getRules().add(this.currentRule);
                    } else if ("ID".equals(name)) {
                        this.currentRule.setId(elementText);
                    } else if ("Status".equals(name)) {
                        this.currentRule.setStatus(RuleStatusEnum.getValueFromCode(elementText));
                    } else if ("Prefix".equals(name)) {
                        this.currentRule.setPrefix(elementText);
                    } else if ("Bucket".equals(name)) {
                        this.currentRule.getDestination().setBucket(elementText);
                    } else if ("StorageClass".equals(name)) {
                        this.currentRule.getDestination().setObjectStorageClass(StorageClassEnum.getValueFromCode(elementText));
                    }
                }
                catch (NullPointerException e) {
                    if (!log.isErrorEnabled()) break block15;
                    log.error("Response xml is not well-formt", e);
                }
            }
        }
    }

    public static class BucketStorageInfoHandler
    extends DefaultXmlHandler {
        private BucketStorageInfo storageInfo;

        public BucketStorageInfo getStorageInfo() {
            return this.storageInfo;
        }

        public void startElement(String name) {
            if (name.equals("GetBucketStorageInfoResult")) {
                this.storageInfo = new BucketStorageInfo();
            }
        }

        public void endElement(String name, String elementText) {
            block5: {
                try {
                    if (name.equals("Size")) {
                        this.storageInfo.setSize(Long.parseLong(elementText));
                    } else if (name.equals("ObjectNumber")) {
                        this.storageInfo.setObjectNumber(Long.parseLong(elementText));
                    }
                }
                catch (NullPointerException e) {
                    if (!log.isWarnEnabled()) break block5;
                    log.warn("Response xml is not well-formt", e);
                }
            }
        }
    }

    public static class BucketStoragePolicyHandler
    extends DefaultXmlHandler {
        protected BucketStoragePolicyConfiguration storagePolicyConfiguration;

        public BucketStoragePolicyConfiguration getStoragePolicy() {
            return this.storagePolicyConfiguration;
        }

        public void startElement(String name) {
            if (name.equals("StoragePolicy") || name.equals("StorageClass")) {
                this.storagePolicyConfiguration = new BucketStoragePolicyConfiguration();
            }
        }

        public void endElement(String name, String elementText) {
            if ((name.equals("DefaultStorageClass") || name.equals("StorageClass")) && this.storagePolicyConfiguration != null) {
                this.storagePolicyConfiguration.setBucketStorageClass(StorageClassEnum.getValueFromCode(elementText));
            }
        }
    }

    public static class BucketQuotaHandler
    extends DefaultXmlHandler {
        protected BucketQuota quota;

        public BucketQuota getQuota() {
            return this.quota;
        }

        public void startElement(String name) {
            if (name.equals("Quota")) {
                this.quota = new BucketQuota();
            }
        }

        public void endElement(String name, String elementText) {
            if (name.equals("StorageQuota") && this.quota != null) {
                this.quota.setBucketQuota(Long.parseLong(elementText));
            }
        }
    }

    public static class AccessControlListHandler
    extends DefaultXmlHandler {
        protected AccessControlList accessControlList;
        protected Owner owner;
        protected GranteeInterface currentGrantee;
        protected Permission currentPermission;
        protected boolean currentDelivered;
        protected boolean insideACL = false;

        public AccessControlList getAccessControlList() {
            return this.accessControlList;
        }

        public void startElement(String name) {
            if (name.equals("AccessControlPolicy")) {
                this.accessControlList = new AccessControlList();
            } else if (name.equals("Owner")) {
                this.owner = new Owner();
                this.accessControlList.setOwner(this.owner);
            } else if (name.equals("AccessControlList")) {
                this.insideACL = true;
            }
        }

        public void endElement(String name, String elementText) {
            if (name.equals("ID") && !this.insideACL) {
                this.owner.setId(elementText);
            } else if (name.equals("DisplayName") && !this.insideACL) {
                this.owner.setDisplayName(elementText);
            } else if (name.equals("ID")) {
                this.currentGrantee = new CanonicalGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("URI") || name.equals("Canned")) {
                this.currentGrantee = new GroupGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("DisplayName")) {
                if (this.currentGrantee instanceof CanonicalGrantee) {
                    ((CanonicalGrantee)this.currentGrantee).setDisplayName(elementText);
                }
            } else if (name.equals("Permission")) {
                this.currentPermission = Permission.parsePermission(elementText);
            } else if (name.equals("Delivered")) {
                if (this.insideACL) {
                    this.currentDelivered = Boolean.parseBoolean(elementText);
                } else {
                    this.accessControlList.setDelivered(Boolean.parseBoolean(elementText));
                }
            } else if (name.equals("Grant")) {
                GrantAndPermission obj = this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
                obj.setDelivered(this.currentDelivered);
            } else if (name.equals("AccessControlList")) {
                this.insideACL = false;
            }
        }
    }

    public static class BucketLifecycleConfigurationHandler
    extends SimpleHandler {
        private LifecycleConfiguration config = new LifecycleConfiguration();
        private LifecycleConfiguration.Rule latestRule;
        private LifecycleConfiguration.TimeEvent latestTimeEvent;

        public BucketLifecycleConfigurationHandler(XMLReader xr) {
            super(xr);
        }

        public LifecycleConfiguration getLifecycleConfig() {
            return this.config;
        }

        public void startExpiration() {
            this.latestTimeEvent = new LifecycleConfiguration.Expiration(this.config);
            this.latestRule.setExpiration((LifecycleConfiguration.Expiration)this.latestTimeEvent);
        }

        public void startNoncurrentVersionExpiration() {
            this.latestTimeEvent = new LifecycleConfiguration.NoncurrentVersionExpiration(this.config);
            this.latestRule.setNoncurrentVersionExpiration((LifecycleConfiguration.NoncurrentVersionExpiration)this.latestTimeEvent);
        }

        public void startTransition() {
            this.latestTimeEvent = new LifecycleConfiguration.Transition(this.config);
            this.latestRule.getTransitions().add((LifecycleConfiguration.Transition)this.latestTimeEvent);
        }

        public void startNoncurrentVersionTransition() {
            this.latestTimeEvent = new LifecycleConfiguration.NoncurrentVersionTransition(this.config);
            this.latestRule.getNoncurrentVersionTransitions().add((LifecycleConfiguration.NoncurrentVersionTransition)this.latestTimeEvent);
        }

        public void endStorageClass(String text) {
            LifecycleConfiguration.setStorageClass(this.latestTimeEvent, StorageClassEnum.getValueFromCode(text));
        }

        public void endDate(String text) throws ParseException {
            LifecycleConfiguration.setDate(this.latestTimeEvent, ServiceUtils.parseIso8601Date(text));
        }

        public void endNoncurrentDays(String text) {
            LifecycleConfiguration.setDays(this.latestTimeEvent, Integer.parseInt(text));
        }

        public void endDays(String text) {
            LifecycleConfiguration.setDays(this.latestTimeEvent, Integer.parseInt(text));
        }

        public void startRule() {
            this.latestRule = new LifecycleConfiguration.Rule(this.config);
        }

        public void endID(String text) {
            this.latestRule.setId(text);
        }

        public void endPrefix(String text) {
            this.latestRule.setPrefix(text);
        }

        public void endStatus(String text) {
            this.latestRule.setEnabled("Enabled".equals(text));
        }

        public void endRule(String text) {
            this.config.addRule(this.latestRule);
        }
    }

    public static class BucketNotificationConfigurationHandler
    extends DefaultXmlHandler {
        private BucketNotificationConfiguration bucketNotificationConfiguration = new BucketNotificationConfiguration();
        private TopicConfiguration config;
        private String currentName;
        private String currentValue;

        public BucketNotificationConfiguration getBucketNotificationConfiguration() {
            return this.bucketNotificationConfiguration;
        }

        public void startElement(String name) {
            if ("TopicConfiguration".equals(name)) {
                this.config = new TopicConfiguration();
            } else if ("Filter".equals(name) && this.config != null) {
                this.config.setFilter(new TopicConfiguration.Filter());
            }
        }

        public void endElement(String name, String elementText) {
            block15: {
                try {
                    if ("Id".equals(name)) {
                        this.config.setId(elementText);
                    } else if ("Topic".equals(name)) {
                        this.config.setTopic(elementText);
                    } else if ("Event".equals(name)) {
                        this.config.getEventTypes().add(EventTypeEnum.getValueFromCode(elementText));
                    } else if ("Name".equals(name)) {
                        this.currentName = elementText;
                    } else if ("Value".equals(name)) {
                        this.currentValue = elementText;
                    } else if ("FilterRule".equals(name)) {
                        this.config.getFilter().addFilterRule(this.currentName, this.currentValue);
                    } else if ("TopicConfiguration".equals(name)) {
                        this.bucketNotificationConfiguration.addTopicConfiguration(this.config);
                    }
                }
                catch (NullPointerException e) {
                    if (!log.isErrorEnabled()) break block15;
                    log.error("Response xml is not well-formt", e);
                }
            }
        }
    }

    public static class BucketTagInfoHandler
    extends DefaultXmlHandler {
        private BucketTagInfo tagInfo = new BucketTagInfo();
        private String currentKey;
        private String currentValue;

        public BucketTagInfo getBucketTagInfo() {
            return this.tagInfo;
        }

        public void endElement(String name, String elementText) {
            if ("Key".equals(name)) {
                this.currentKey = elementText;
            } else if ("Value".equals(name)) {
                this.currentValue = elementText;
            } else if ("Tag".equals(name)) {
                this.tagInfo.getTagSet().addTag(this.currentKey, this.currentValue);
            }
        }
    }

    public static class DeleteObjectsHandler
    extends DefaultXmlHandler {
        private DeleteObjectsResult result;
        private List<DeleteObjectsResult.DeleteObjectResult> deletedObjectResults = new ArrayList<DeleteObjectsResult.DeleteObjectResult>();
        private List<DeleteObjectsResult.ErrorResult> errorResults = new ArrayList<DeleteObjectsResult.ErrorResult>();
        private String key;
        private String version;
        private String deleteMarkerVersion;
        private String errorCode;
        private String message;
        private boolean withDeleteMarker;

        public DeleteObjectsResult getMultipleDeleteResult() {
            return this.result;
        }

        public void startElement(String name) {
            if (name.equals("DeleteResult")) {
                this.result = new DeleteObjectsResult();
            }
        }

        public void endElement(String name, String elementText) {
            if ("Key".equals(name)) {
                this.key = elementText;
            } else if ("VersionId".equals(name)) {
                this.version = elementText;
            } else if ("DeleteMarker".equals(name)) {
                this.withDeleteMarker = Boolean.parseBoolean(elementText);
            } else if ("DeleteMarkerVersionId".equals(name)) {
                this.deleteMarkerVersion = elementText;
            } else if ("Code".equals(name)) {
                this.errorCode = elementText;
            } else if ("Message".equals(name)) {
                this.message = elementText;
            } else if ("Deleted".equals(name)) {
                DeleteObjectsResult deleteObjectsResult = this.result;
                deleteObjectsResult.getClass();
                DeleteObjectsResult.DeleteObjectResult r = new DeleteObjectsResult.DeleteObjectResult(deleteObjectsResult, this.key, this.version, this.withDeleteMarker, this.deleteMarkerVersion);
                this.deletedObjectResults.add(r);
                this.deleteMarkerVersion = null;
                this.version = null;
                this.key = null;
                this.withDeleteMarker = false;
            } else if ("Error".equals(name)) {
                DeleteObjectsResult deleteObjectsResult = this.result;
                deleteObjectsResult.getClass();
                this.errorResults.add(new DeleteObjectsResult.ErrorResult(deleteObjectsResult, this.key, this.version, this.errorCode, this.message));
                this.message = null;
                this.errorCode = null;
                this.version = null;
                this.key = null;
            } else if (name.equals("DeleteResult")) {
                this.result.getDeletedObjectResults().addAll(this.deletedObjectResults);
                this.result.getErrorResults().addAll(this.errorResults);
            }
        }
    }

    public static class BucketWebsiteConfigurationHandler
    extends DefaultXmlHandler {
        private WebsiteConfiguration config = new WebsiteConfiguration();
        private Redirect currentRedirectRule;
        private RedirectAllRequest currentRedirectAllRule;
        private RouteRule currentRoutingRule;
        private RouteRuleCondition currentCondition;

        public WebsiteConfiguration getWebsiteConfig() {
            return this.config;
        }

        public void startElement(String name) {
            if (name.equals("RedirectAllRequestsTo")) {
                this.currentRedirectAllRule = new RedirectAllRequest();
                this.config.setRedirectAllRequestsTo(this.currentRedirectAllRule);
            } else if (name.equals("RoutingRule")) {
                this.currentRoutingRule = new RouteRule();
                this.config.getRouteRules().add(this.currentRoutingRule);
            } else if (name.equals("Condition")) {
                this.currentCondition = new RouteRuleCondition();
                this.currentRoutingRule.setCondition(this.currentCondition);
            } else if (name.equals("Redirect")) {
                this.currentRedirectRule = new Redirect();
                this.currentRoutingRule.setRedirect(this.currentRedirectRule);
            }
        }

        public void endElement(String name, String elementText) {
            block25: {
                try {
                    if (name.equals("Suffix")) {
                        this.config.setSuffix(elementText);
                    } else if (name.equals("Key")) {
                        this.config.setKey(elementText);
                    } else if (name.equals("KeyPrefixEquals")) {
                        this.currentCondition.setKeyPrefixEquals(elementText);
                    } else if (name.equals("HttpErrorCodeReturnedEquals")) {
                        this.currentCondition.setHttpErrorCodeReturnedEquals(elementText);
                    } else if (name.equals("Protocol")) {
                        if (this.currentRedirectAllRule != null) {
                            this.currentRedirectAllRule.setRedirectProtocol(ProtocolEnum.getValueFromCode(elementText));
                        } else if (this.currentRedirectRule != null) {
                            this.currentRedirectRule.setRedirectProtocol(ProtocolEnum.getValueFromCode(elementText));
                        }
                    } else if (name.equals("HostName")) {
                        if (this.currentRedirectAllRule != null) {
                            this.currentRedirectAllRule.setHostName(elementText);
                        } else if (this.currentRedirectRule != null) {
                            this.currentRedirectRule.setHostName(elementText);
                        }
                    } else if (name.equals("ReplaceKeyPrefixWith")) {
                        this.currentRedirectRule.setReplaceKeyPrefixWith(elementText);
                    } else if (name.equals("ReplaceKeyWith")) {
                        this.currentRedirectRule.setReplaceKeyWith(elementText);
                    } else if (name.equals("HttpRedirectCode")) {
                        this.currentRedirectRule.setHttpRedirectCode(elementText);
                    }
                }
                catch (NullPointerException e) {
                    if (!log.isErrorEnabled()) break block25;
                    log.error("Response xml is not well-formt", e);
                }
            }
        }
    }

    public static class CompleteMultipartUploadHandler
    extends SimpleHandler {
        private String location;
        private String bucketName;
        private String objectKey;
        private String etag;

        public CompleteMultipartUploadHandler(XMLReader xr) {
            super(xr);
        }

        public void endLocation(String text) {
            this.location = text;
        }

        public void endBucket(String text) {
            this.bucketName = text;
        }

        public void endKey(String text) {
            this.objectKey = text;
        }

        public void endETag(String text) {
            this.etag = text;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getObjectKey() {
            return this.objectKey;
        }

        public String getEtag() {
            return this.etag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListPartsHandler
    extends SimpleHandler {
        private final List<Multipart> parts = new ArrayList<Multipart>();
        private String bucketName;
        private String objectKey;
        private String uploadId;
        private Owner initiator;
        private Owner owner;
        private String storageClass;
        private String partNumberMarker;
        private String nextPartNumberMarker;
        private int maxParts;
        private boolean isTruncated = false;
        private boolean inInitiator = false;

        public ListPartsHandler(XMLReader xr) {
            super(xr);
        }

        public List<Multipart> getMultiPartList() {
            return this.parts;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getObjectKey() {
            return this.objectKey;
        }

        public String getUploadId() {
            return this.uploadId;
        }

        public Owner getInitiator() {
            return this.initiator;
        }

        public Owner getOwner() {
            return this.owner;
        }

        public String getStorageClass() {
            return this.storageClass;
        }

        public String getPartNumberMarker() {
            return this.partNumberMarker;
        }

        public String getNextPartNumberMarker() {
            return this.nextPartNumberMarker;
        }

        public int getMaxParts() {
            return this.maxParts;
        }

        public void startPart() {
            this.transferControlToHandler(new PartResultHandler(this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            if (childHandler instanceof PartResultHandler) {
                this.parts.add(((PartResultHandler)childHandler).getMultipartPart());
            } else if (this.inInitiator) {
                this.initiator = ((OwnerHandler)childHandler).getOwner();
            } else {
                this.owner = ((OwnerHandler)childHandler).getOwner();
            }
        }

        public void startInitiator() {
            this.inInitiator = true;
            this.transferControlToHandler(new OwnerHandler(this.xr));
        }

        public void startOwner() {
            this.inInitiator = false;
            this.transferControlToHandler(new OwnerHandler(this.xr));
        }

        public void endBucket(String text) {
            this.bucketName = text;
        }

        public void endKey(String text) {
            this.objectKey = text;
        }

        public void endStorageClass(String text) {
            this.storageClass = text;
        }

        public void endUploadId(String text) {
            this.uploadId = text;
        }

        public void endPartNumberMarker(String text) {
            this.partNumberMarker = text;
        }

        public void endNextPartNumberMarker(String text) {
            this.nextPartNumberMarker = text;
        }

        public void endMaxParts(String text) {
            this.maxParts = Integer.parseInt(text);
        }

        public void endIsTruncated(String text) {
            this.isTruncated = Boolean.parseBoolean(text);
        }
    }

    public static class PartResultHandler
    extends SimpleHandler {
        private int partNumber;
        private Date lastModified;
        private String etag;
        private long size;

        public PartResultHandler(XMLReader xr) {
            super(xr);
        }

        public Multipart getMultipartPart() {
            return new Multipart(this.partNumber, this.lastModified, this.etag, this.size);
        }

        public void endPartNumber(String text) {
            this.partNumber = Integer.parseInt(text);
        }

        public void endLastModified(String text) {
            try {
                this.lastModified = ServiceUtils.parseIso8601Date(text);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public void endETag(String text) {
            this.etag = text;
        }

        public void endSize(String text) {
            this.size = Long.parseLong(text);
        }

        public void endPart(String text) {
            this.returnControlToParentHandler();
        }
    }

    public static class CopyPartResultHandler
    extends SimpleHandler {
        private Date lastModified;
        private String etag;

        public CopyPartResultHandler(XMLReader xr) {
            super(xr);
        }

        public CopyPartResult getCopyPartResult(int partNumber) {
            CopyPartResult result = new CopyPartResult(partNumber, this.etag, this.lastModified);
            return result;
        }

        public void endLastModified(String text) {
            try {
                this.lastModified = ServiceUtils.parseIso8601Date(text);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public void endETag(String text) {
            this.etag = text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListMultipartUploadsHandler
    extends SimpleHandler {
        private final List<MultipartUpload> uploads = new ArrayList<MultipartUpload>();
        private final List<String> commonPrefixes = new ArrayList<String>();
        private boolean insideCommonPrefixes;
        private String bucketName;
        private String keyMarker;
        private String uploadIdMarker;
        private String nextKeyMarker;
        private String nextUploadIdMarker;
        private String delimiter;
        private int maxUploads;
        private String prefix;
        private boolean isTruncated = false;

        public ListMultipartUploadsHandler(XMLReader xr) {
            super(xr);
        }

        public List<MultipartUpload> getMultipartUploadList() {
            for (MultipartUpload upload : this.uploads) {
                upload.setBucketName(this.bucketName);
            }
            return this.uploads;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getKeyMarker() {
            return this.keyMarker;
        }

        public String getUploadIdMarker() {
            return this.uploadIdMarker;
        }

        public String getNextKeyMarker() {
            return this.nextKeyMarker;
        }

        public String getNextUploadIdMarker() {
            return this.nextUploadIdMarker;
        }

        public int getMaxUploads() {
            return this.maxUploads;
        }

        public List<String> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void startUpload() {
            this.transferControlToHandler(new MultipartUploadHandler(this.xr));
        }

        public void startCommonPrefixes() {
            this.insideCommonPrefixes = true;
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            this.uploads.add(((MultipartUploadHandler)childHandler).getMultipartUpload());
        }

        public void endDelimiter(String text) {
            this.delimiter = text;
        }

        public void endBucket(String text) {
            this.bucketName = text;
        }

        public void endKeyMarker(String text) {
            this.keyMarker = text;
        }

        public void endUploadIdMarker(String text) {
            this.uploadIdMarker = text;
        }

        public void endNextKeyMarker(String text) {
            this.nextKeyMarker = text;
        }

        public void endNextUploadIdMarker(String text) {
            this.nextUploadIdMarker = text;
        }

        public void endMaxUploads(String text) {
            block2: {
                try {
                    this.maxUploads = Integer.parseInt(text);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block2;
                    log.error("Response xml is not well-format", e);
                }
            }
        }

        public void endIsTruncated(String text) {
            this.isTruncated = Boolean.parseBoolean(text);
        }

        public void endPrefix(String text) {
            if (this.insideCommonPrefixes) {
                this.commonPrefixes.add(text);
            } else {
                this.prefix = text;
            }
        }

        public void endCommonPrefixes() {
            this.insideCommonPrefixes = false;
        }
    }

    public static class MultipartUploadHandler
    extends SimpleHandler {
        private String uploadId;
        private String objectKey;
        private String storageClass;
        private Owner owner;
        private Owner initiator;
        private Date initiatedDate;
        private boolean inInitiator = false;

        public MultipartUploadHandler(XMLReader xr) {
            super(xr);
        }

        public MultipartUpload getMultipartUpload() {
            MultipartUpload multipartUpload = new MultipartUpload(this.uploadId, this.objectKey, this.initiatedDate, StorageClassEnum.getValueFromCode(this.storageClass), this.owner, this.initiator);
            return multipartUpload;
        }

        public void endUploadId(String text) {
            this.uploadId = text;
        }

        public void endKey(String text) {
            this.objectKey = text;
        }

        public void endStorageClass(String text) {
            this.storageClass = text;
        }

        public void endInitiated(String text) {
            try {
                this.initiatedDate = ServiceUtils.parseIso8601Date(text);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public void startOwner() {
            this.inInitiator = false;
            this.transferControlToHandler(new OwnerHandler(this.xr));
        }

        public void startInitiator() {
            this.inInitiator = true;
            this.transferControlToHandler(new OwnerHandler(this.xr));
        }

        public void controlReturned(SimpleHandler childHandler) {
            if (this.inInitiator) {
                this.owner = ((OwnerHandler)childHandler).getOwner();
            } else {
                this.initiator = ((OwnerHandler)childHandler).getOwner();
            }
        }

        public void endUpload(String text) {
            this.returnControlToParentHandler();
        }
    }

    public static class InitiateMultipartUploadHandler
    extends SimpleHandler {
        private String uploadId;
        private String bucketName;
        private String objectKey;

        public InitiateMultipartUploadHandler(XMLReader xr) {
            super(xr);
        }

        public InitiateMultipartUploadResult getInitiateMultipartUploadResult() {
            InitiateMultipartUploadResult result = new InitiateMultipartUploadResult(this.bucketName, this.objectKey, this.uploadId);
            return result;
        }

        public void endUploadId(String text) {
            this.uploadId = text;
        }

        public void endBucket(String text) {
            this.bucketName = text;
        }

        public void endKey(String text) {
            this.objectKey = text;
        }
    }

    public static class OwnerHandler
    extends SimpleHandler {
        private String id;
        private String displayName;

        public OwnerHandler(XMLReader xr) {
            super(xr);
        }

        public Owner getOwner() {
            Owner owner = new Owner();
            owner.setId(this.id);
            owner.setDisplayName(this.displayName);
            return owner;
        }

        public void endID(String text) {
            this.id = text;
        }

        public void endDisplayName(String text) {
            this.displayName = text;
        }

        public void endOwner(String text) {
            this.returnControlToParentHandler();
        }

        public void endInitiator(String text) {
            this.returnControlToParentHandler();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListVersionsHandler
    extends DefaultXmlHandler {
        private final List<VersionOrDeleteMarker> items = new ArrayList<VersionOrDeleteMarker>();
        private final List<String> commonPrefixes = new ArrayList<String>();
        private String key;
        private String versionId;
        private boolean isLatest = false;
        private Date lastModified;
        private Owner owner;
        private String etag;
        private long size = 0L;
        private String storageClass;
        private boolean isAppendable;
        private boolean insideCommonPrefixes = false;
        private String bucketName;
        private String requestPrefix;
        private String keyMarker;
        private String versionIdMarker;
        private long requestMaxKeys = 0L;
        private boolean listingTruncated = false;
        private String nextMarker;
        private String nextVersionIdMarker;
        private String delimiter;

        public String getDelimiter() {
            return this.delimiter;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public List<VersionOrDeleteMarker> getItems() {
            return this.items;
        }

        public List<String> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        public String getRequestPrefix() {
            return this.requestPrefix;
        }

        public String getKeyMarker() {
            return this.keyMarker;
        }

        public String getVersionIdMarker() {
            return this.versionIdMarker;
        }

        public String getNextKeyMarker() {
            return this.nextMarker;
        }

        public String getNextVersionIdMarker() {
            return this.nextVersionIdMarker;
        }

        public long getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        private void reset() {
            this.key = null;
            this.versionId = null;
            this.isLatest = false;
            this.lastModified = null;
            this.etag = null;
            this.isAppendable = false;
            this.size = 0L;
            this.storageClass = null;
            this.owner = null;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("Owner")) {
                this.owner = new Owner();
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = true;
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            block52: {
                try {
                    if (name.equals("Name")) {
                        this.bucketName = elementText;
                    } else if (!this.insideCommonPrefixes && name.equals("Prefix")) {
                        this.requestPrefix = elementText;
                    } else if (name.equals("KeyMarker")) {
                        this.keyMarker = elementText;
                    } else if (name.equals("NextKeyMarker")) {
                        this.nextMarker = elementText;
                    } else if (name.equals("VersionIdMarker")) {
                        this.versionIdMarker = elementText;
                    } else if (name.equals("NextVersionIdMarker")) {
                        this.nextVersionIdMarker = elementText;
                    } else if (name.equals("MaxKeys")) {
                        this.requestMaxKeys = Long.parseLong(elementText);
                    } else if (name.equals("IsTruncated")) {
                        this.listingTruncated = Boolean.valueOf(elementText);
                    } else if (name.equals("Delimiter")) {
                        this.delimiter = elementText;
                    } else if (name.equals("Version")) {
                        VersionOrDeleteMarker item = new VersionOrDeleteMarker(this.bucketName, this.key, this.versionId, this.isLatest, this.lastModified, this.owner, this.etag, this.size, StorageClassEnum.getValueFromCode(this.storageClass), false, this.isAppendable);
                        this.items.add(item);
                        this.reset();
                    } else if (name.equals("DeleteMarker")) {
                        VersionOrDeleteMarker item = new VersionOrDeleteMarker(this.bucketName, this.key, this.versionId, this.isLatest, this.lastModified, this.owner, null, 0L, null, true, false);
                        this.items.add(item);
                        this.reset();
                    } else if (name.equals("Key")) {
                        this.key = elementText;
                    } else if (name.equals("VersionId")) {
                        this.versionId = elementText;
                    } else if (name.equals("IsLatest")) {
                        this.isLatest = Boolean.valueOf(elementText);
                    } else if (name.equals("LastModified")) {
                        try {
                            this.lastModified = ServiceUtils.parseIso8601Date(elementText);
                        }
                        catch (ParseException e) {
                            if (log.isWarnEnabled()) {
                                log.warn("Non-ISO8601 date for LastModified in bucket's versions listing output: " + elementText, e);
                            }
                        }
                    } else if (name.equals("ETag")) {
                        this.etag = elementText;
                    } else if (name.equals("Size")) {
                        this.size = Long.parseLong(elementText);
                    } else if (name.equals("StorageClass")) {
                        this.storageClass = elementText;
                    } else if (name.equals("Type")) {
                        this.isAppendable = "Appendable".equals(elementText);
                    } else if (name.equals("ID")) {
                        if (this.owner == null) {
                            this.owner = new Owner();
                        }
                        this.owner.setId(elementText);
                    } else if (name.equals("DisplayName")) {
                        if (this.owner != null) {
                            this.owner.setDisplayName(elementText);
                        }
                    } else if (this.insideCommonPrefixes && name.equals("Prefix")) {
                        this.commonPrefixes.add(elementText);
                    } else if (name.equals("CommonPrefixes")) {
                        this.insideCommonPrefixes = false;
                    }
                }
                catch (NullPointerException e) {
                    if (!log.isErrorEnabled()) break block52;
                    log.error("Response xml is not well-formt", e);
                }
            }
        }
    }

    public static class BucketVersioningHandler
    extends DefaultXmlHandler {
        private BucketVersioningConfiguration versioningStatus;
        private String status;

        public BucketVersioningConfiguration getVersioningStatus() {
            return this.versioningStatus;
        }

        public void endElement(String name, String elementText) {
            if (name.equals("Status")) {
                this.status = elementText;
            } else if (name.equals("VersioningConfiguration")) {
                this.versioningStatus = new BucketVersioningConfiguration(VersioningStatusEnum.getValueFromCode(this.status));
            }
        }
    }

    public static class RequestPaymentConfigurationHandler
    extends DefaultXmlHandler {
        private String payer = null;

        public boolean isRequesterPays() {
            return "Requester".equals(this.payer);
        }

        public void endElement(String name, String elementText) {
            if (name.equals("Payer")) {
                this.payer = elementText;
            }
        }
    }

    public static class CopyObjectResultHandler
    extends DefaultXmlHandler {
        private String etag;
        private Date lastModified;

        public Date getLastModified() {
            return this.lastModified;
        }

        public String getETag() {
            return this.etag;
        }

        public void endElement(String name, String elementText) {
            if (name.equals("LastModified")) {
                try {
                    this.lastModified = ServiceUtils.parseIso8601Date(elementText);
                }
                catch (ParseException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Non-ISO8601 date for LastModified in copy object output: " + elementText, e);
                    }
                }
            } else if (name.equals("ETag")) {
                this.etag = elementText;
            }
        }
    }

    public static class BucketCorsHandler
    extends DefaultXmlHandler {
        private final BucketCors configuration = new BucketCors();
        private BucketCorsRule currentRule;
        private List<String> allowedMethods = null;
        private List<String> allowedOrigins = null;
        private List<String> exposedHeaders = null;
        private List<String> allowedHeaders = null;

        public BucketCors getConfiguration() {
            return this.configuration;
        }

        public void startElement(String name) {
            if ("CORSRule".equals(name)) {
                this.currentRule = new BucketCorsRule();
            }
            if ("AllowedOrigin".equals(name)) {
                if (this.allowedOrigins == null) {
                    this.allowedOrigins = new ArrayList<String>();
                }
            } else if ("AllowedMethod".equals(name)) {
                if (this.allowedMethods == null) {
                    this.allowedMethods = new ArrayList<String>();
                }
            } else if ("ExposeHeader".equals(name)) {
                if (this.exposedHeaders == null) {
                    this.exposedHeaders = new ArrayList<String>();
                }
            } else if ("AllowedHeader".equals(name) && this.allowedHeaders == null) {
                this.allowedHeaders = new LinkedList<String>();
            }
        }

        public void endElement(String name, String elementText) {
            if (name.equals("CORSRule")) {
                this.currentRule.setAllowedHeader(this.allowedHeaders);
                this.currentRule.setAllowedMethod(this.allowedMethods);
                this.currentRule.setAllowedOrigin(this.allowedOrigins);
                this.currentRule.setExposeHeader(this.exposedHeaders);
                this.configuration.getRules().add(this.currentRule);
                this.allowedHeaders = null;
                this.allowedMethods = null;
                this.allowedOrigins = null;
                this.exposedHeaders = null;
                this.currentRule = null;
            }
            if (name.equals("ID") && null != this.currentRule) {
                this.currentRule.setId(elementText);
            } else if (name.equals("AllowedOrigin") && null != this.allowedOrigins) {
                this.allowedOrigins.add(elementText);
            } else if (name.equals("AllowedMethod") && null != this.allowedMethods) {
                this.allowedMethods.add(elementText);
            } else if (name.equals("MaxAgeSeconds") && null != this.currentRule) {
                this.currentRule.setMaxAgeSecond(Integer.parseInt(elementText));
            } else if (name.equals("ExposeHeader") && null != this.exposedHeaders) {
                this.exposedHeaders.add(elementText);
            } else if (name.equals("AllowedHeader") && null != this.allowedHeaders) {
                this.allowedHeaders.add(elementText);
            }
        }
    }

    public static class BucketLocationHandler
    extends DefaultXmlHandler {
        private String location;

        public String getLocation() {
            return this.location;
        }

        public void endElement(String name, String elementText) {
            if (name.equals("LocationConstraint") || name.equals("Location")) {
                this.location = elementText;
            }
        }
    }

    public static class BucketLoggingHandler
    extends DefaultXmlHandler {
        private BucketLoggingConfiguration bucketLoggingStatus = new BucketLoggingConfiguration();
        private String targetBucket;
        private String targetPrefix;
        private GranteeInterface currentGrantee;
        private Permission currentPermission;
        private boolean currentDelivered;

        public BucketLoggingConfiguration getBucketLoggingStatus() {
            return this.bucketLoggingStatus;
        }

        public void endElement(String name, String elementText) {
            if (name.equals("TargetBucket")) {
                this.targetBucket = elementText;
            } else if (name.equals("TargetPrefix")) {
                this.targetPrefix = elementText;
            } else if (name.equals("LoggingEnabled")) {
                this.bucketLoggingStatus.setTargetBucketName(this.targetBucket);
                this.bucketLoggingStatus.setLogfilePrefix(this.targetPrefix);
            } else if (name.equals("Agency")) {
                this.bucketLoggingStatus.setAgency(elementText);
            } else if (name.equals("ID")) {
                this.currentGrantee = new CanonicalGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("URI") || name.equals("Canned")) {
                this.currentGrantee = new GroupGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("DisplayName")) {
                if (this.currentGrantee instanceof CanonicalGrantee) {
                    ((CanonicalGrantee)this.currentGrantee).setDisplayName(elementText);
                }
            } else if (name.equals("Delivered")) {
                this.currentDelivered = Boolean.parseBoolean(elementText);
            } else if (name.equals("Permission")) {
                this.currentPermission = Permission.parsePermission(elementText);
            } else if (name.equals("Grant")) {
                GrantAndPermission gap = new GrantAndPermission(this.currentGrantee, this.currentPermission);
                gap.setDelivered(this.currentDelivered);
                this.bucketLoggingStatus.addTargetGrant(gap);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListBucketsHandler
    extends DefaultXmlHandler {
        private Owner bucketsOwner;
        private ObsBucket currentBucket;
        private final List<ObsBucket> buckets = new ArrayList<ObsBucket>();

        public List<ObsBucket> getBuckets() {
            return this.buckets;
        }

        public Owner getOwner() {
            return this.bucketsOwner;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("Bucket")) {
                this.currentBucket = new ObsBucket();
            } else if (name.equals("Owner")) {
                this.bucketsOwner = new Owner();
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            block16: {
                try {
                    if (name.equals("ID")) {
                        this.bucketsOwner.setId(elementText);
                    } else if (name.equals("DisplayName")) {
                        this.bucketsOwner.setDisplayName(elementText);
                    } else if (name.equals("Bucket")) {
                        this.currentBucket.setOwner(this.bucketsOwner);
                        this.buckets.add(this.currentBucket);
                    } else if (name.equals("Name")) {
                        this.currentBucket.setBucketName(elementText);
                    } else if (name.equals("Location")) {
                        this.currentBucket.setLocation(elementText);
                    } else if (name.equals("CreationDate")) {
                        elementText = elementText + ".000Z";
                        try {
                            this.currentBucket.setCreationDate(ServiceUtils.parseIso8601Date(elementText));
                        }
                        catch (ParseException e) {
                            if (log.isWarnEnabled()) {
                                log.warn("Non-ISO8601 date for CreationDate in list buckets output: " + elementText, e);
                            }
                        }
                    }
                }
                catch (NullPointerException e) {
                    if (!log.isErrorEnabled()) break block16;
                    log.error("Response xml is not well-formt", e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListObjectsHandler
    extends DefaultXmlHandler {
        private ObsObject currentObject;
        private Owner currentOwner;
        private boolean insideCommonPrefixes = false;
        private final List<ObsObject> objects = new ArrayList<ObsObject>();
        private final List<String> commonPrefixes = new ArrayList<String>();
        private String bucketName;
        private String requestPrefix;
        private String requestMarker;
        private String requestDelimiter;
        private int requestMaxKeys = 0;
        private boolean listingTruncated = false;
        private String lastKey;
        private String nextMarker;

        public String getMarkerForNextListing() {
            return this.listingTruncated ? (this.nextMarker == null ? this.lastKey : this.nextMarker) : null;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public List<ObsObject> getObjects() {
            return this.objects;
        }

        public List<String> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        public String getRequestPrefix() {
            return this.requestPrefix;
        }

        public String getRequestMarker() {
            return this.requestMarker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public int getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        public String getRequestDelimiter() {
            return this.requestDelimiter;
        }

        @Override
        public void startElement(String name) {
            if (name.equals("Contents")) {
                this.currentObject = new ObsObject();
                this.currentObject.setBucketName(this.bucketName);
            } else if (name.equals("Owner")) {
                this.currentOwner = new Owner();
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = true;
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            block42: {
                try {
                    if (name.equals("Name")) {
                        this.bucketName = elementText;
                    } else if (!this.insideCommonPrefixes && name.equals("Prefix")) {
                        this.requestPrefix = elementText;
                    } else if (name.equals("Marker")) {
                        this.requestMarker = elementText;
                    } else if (name.equals("NextMarker")) {
                        this.nextMarker = elementText;
                    } else if (name.equals("MaxKeys")) {
                        this.requestMaxKeys = Integer.parseInt(elementText);
                    } else if (name.equals("Delimiter")) {
                        this.requestDelimiter = elementText;
                    } else if (name.equals("IsTruncated")) {
                        this.listingTruncated = Boolean.valueOf(elementText);
                    } else if (name.equals("Contents")) {
                        this.objects.add(this.currentObject);
                    } else if (name.equals("Key")) {
                        this.currentObject.setObjectKey(elementText);
                        this.lastKey = elementText;
                    } else if (name.equals("LastModified")) {
                        try {
                            this.currentObject.getMetadata().setLastModified(ServiceUtils.parseIso8601Date(elementText));
                        }
                        catch (ParseException e) {
                            if (log.isErrorEnabled()) {
                                log.error("Non-ISO8601 date for LastModified in bucket's object listing output: " + elementText, e);
                            }
                        }
                    } else if (name.equals("ETag")) {
                        this.currentObject.getMetadata().setEtag(elementText);
                    } else if (name.equals("Size")) {
                        this.currentObject.getMetadata().setContentLength(Long.parseLong(elementText));
                    } else if (name.equals("StorageClass")) {
                        this.currentObject.getMetadata().setObjectStorageClass(StorageClassEnum.getValueFromCode(elementText));
                    } else if (name.equals("ID")) {
                        if (this.currentOwner == null) {
                            this.currentOwner = new Owner();
                        }
                        this.currentObject.setOwner(this.currentOwner);
                        this.currentOwner.setId(elementText);
                    } else if (name.equals("Type")) {
                        this.currentObject.getMetadata().setAppendable("Appendable".equals(elementText));
                    } else if (name.equals("DisplayName")) {
                        if (this.currentOwner != null) {
                            this.currentOwner.setDisplayName(elementText);
                        }
                    } else if (this.insideCommonPrefixes && name.equals("Prefix")) {
                        this.commonPrefixes.add(elementText);
                    } else if (name.equals("CommonPrefixes")) {
                        this.insideCommonPrefixes = false;
                    }
                }
                catch (NullPointerException e) {
                    if (!log.isErrorEnabled()) break block42;
                    log.error("Response xml is not well-formt", e);
                }
            }
        }
    }
}

