/**
 * vis-timeline and vis-graph2d
 * https://visjs.github.io/vis-timeline/
 *
 * Create a fully customizable, interactive timeline with items and ranges.
 *
 * @version 7.3.4
 * @date    2020-03-18T17:03:58.105Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t=t||self).vis=t.vis||{})}(this,(function(t){"use strict";var e="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function i(){throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs")}function n(t,e){return t(e={exports:{}},e.exports),e.exports}function o(t){return t&&t.default||t}var s=n((function(t,e){t.exports=function(){var e,n;function o(){return e.apply(null,arguments)}function s(t){return t instanceof Array||"[object Array]"===Object.prototype.toString.call(t)}function r(t){return null!=t&&"[object Object]"===Object.prototype.toString.call(t)}function a(t){return void 0===t}function l(t){return"number"==typeof t||"[object Number]"===Object.prototype.toString.call(t)}function h(t){return t instanceof Date||"[object Date]"===Object.prototype.toString.call(t)}function d(t,e){var i,n=[];for(i=0;i<t.length;++i)n.push(e(t[i],i));return n}function u(t,e){return Object.prototype.hasOwnProperty.call(t,e)}function c(t,e){for(var i in e)u(e,i)&&(t[i]=e[i]);return u(e,"toString")&&(t.toString=e.toString),u(e,"valueOf")&&(t.valueOf=e.valueOf),t}function p(t,e,i,n){return De(t,e,i,n,!0).utc()}function m(t){return null==t._pf&&(t._pf={empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],meridiem:null,rfc2822:!1,weekdayMismatch:!1}),t._pf}function f(t){if(null==t._isValid){var e=m(t),i=n.call(e.parsedDateParts,(function(t){return null!=t})),o=!isNaN(t._d.getTime())&&e.overflow<0&&!e.empty&&!e.invalidMonth&&!e.invalidWeekday&&!e.weekdayMismatch&&!e.nullInput&&!e.invalidFormat&&!e.userInvalidated&&(!e.meridiem||e.meridiem&&i);if(t._strict&&(o=o&&0===e.charsLeftOver&&0===e.unusedTokens.length&&void 0===e.bigHour),null!=Object.isFrozen&&Object.isFrozen(t))return o;t._isValid=o}return t._isValid}function g(t){var e=p(NaN);return null!=t?c(m(e),t):m(e).userInvalidated=!0,e}n=Array.prototype.some?Array.prototype.some:function(t){for(var e=Object(this),i=e.length>>>0,n=0;n<i;n++)if(n in e&&t.call(this,e[n],n,e))return!0;return!1};var v=o.momentProperties=[];function b(t,e){var i,n,o;if(a(e._isAMomentObject)||(t._isAMomentObject=e._isAMomentObject),a(e._i)||(t._i=e._i),a(e._f)||(t._f=e._f),a(e._l)||(t._l=e._l),a(e._strict)||(t._strict=e._strict),a(e._tzm)||(t._tzm=e._tzm),a(e._isUTC)||(t._isUTC=e._isUTC),a(e._offset)||(t._offset=e._offset),a(e._pf)||(t._pf=m(e)),a(e._locale)||(t._locale=e._locale),v.length>0)for(i=0;i<v.length;i++)a(o=e[n=v[i]])||(t[n]=o);return t}var y=!1;function x(t){b(this,t),this._d=new Date(null!=t._d?t._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===y&&(y=!0,o.updateOffset(this),y=!1)}function w(t){return t instanceof x||null!=t&&null!=t._isAMomentObject}function _(t){return t<0?Math.ceil(t)||0:Math.floor(t)}function k(t){var e=+t,i=0;return 0!==e&&isFinite(e)&&(i=_(e)),i}function D(t,e,i){var n,o=Math.min(t.length,e.length),s=Math.abs(t.length-e.length),r=0;for(n=0;n<o;n++)(i&&t[n]!==e[n]||!i&&k(t[n])!==k(e[n]))&&r++;return r+s}function I(t){!1===o.suppressDeprecationWarnings&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+t)}function C(t,e){var i=!0;return c((function(){if(null!=o.deprecationHandler&&o.deprecationHandler(null,t),i){for(var n,s=[],r=0;r<arguments.length;r++){if(n="","object"==typeof arguments[r]){for(var a in n+="\n["+r+"] ",arguments[0])n+=a+": "+arguments[0][a]+", ";n=n.slice(0,-2)}else n=arguments[r];s.push(n)}I(t+"\nArguments: "+Array.prototype.slice.call(s).join("")+"\n"+(new Error).stack),i=!1}return e.apply(this,arguments)}),e)}var L,G={};function M(t,e){null!=o.deprecationHandler&&o.deprecationHandler(t,e),G[t]||(I(e),G[t]=!0)}function S(t){return t instanceof Function||"[object Function]"===Object.prototype.toString.call(t)}function Q(t,e){var i,n=c({},t);for(i in e)u(e,i)&&(r(t[i])&&r(e[i])?(n[i]={},c(n[i],t[i]),c(n[i],e[i])):null!=e[i]?n[i]=e[i]:delete n[i]);for(i in t)u(t,i)&&!u(e,i)&&r(t[i])&&(n[i]=c({},n[i]));return n}function N(t){null!=t&&this.set(t)}o.suppressDeprecationWarnings=!1,o.deprecationHandler=null,L=Object.keys?Object.keys:function(t){var e,i=[];for(e in t)u(t,e)&&i.push(e);return i};var F={};function Z(t,e){var i=t.toLowerCase();F[i]=F[i+"s"]=F[e]=t}function B(t){return"string"==typeof t?F[t]||F[t.toLowerCase()]:void 0}function O(t){var e,i,n={};for(i in t)u(t,i)&&(e=B(i))&&(n[e]=t[i]);return n}var W={};function A(t,e){W[t]=e}function X(t,e,i){var n=""+Math.abs(t),o=e-n.length;return(t>=0?i?"+":"":"-")+Math.pow(10,Math.max(0,o)).toString().substr(1)+n}var T=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,Y=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,E={},R={};function U(t,e,i,n){var o=n;"string"==typeof n&&(o=function(){return this[n]()}),t&&(R[t]=o),e&&(R[e[0]]=function(){return X(o.apply(this,arguments),e[1],e[2])}),i&&(R[i]=function(){return this.localeData().ordinal(o.apply(this,arguments),t)})}function z(t,e){return t.isValid()?(e=V(e,t.localeData()),E[e]=E[e]||function(t){var e,i,n,o=t.match(T);for(e=0,i=o.length;e<i;e++)R[o[e]]?o[e]=R[o[e]]:o[e]=(n=o[e]).match(/\[[\s\S]/)?n.replace(/^\[|\]$/g,""):n.replace(/\\/g,"");return function(e){var n,s="";for(n=0;n<i;n++)s+=S(o[n])?o[n].call(e,t):o[n];return s}}(e),E[e](t)):t.localeData().invalidDate()}function V(t,e){var i=5;function n(t){return e.longDateFormat(t)||t}for(Y.lastIndex=0;i>=0&&Y.test(t);)t=t.replace(Y,n),Y.lastIndex=0,i-=1;return t}var j=/\d/,H=/\d\d/,P=/\d{3}/,J=/\d{4}/,K=/[+-]?\d{6}/,q=/\d\d?/,$=/\d\d\d\d?/,tt=/\d\d\d\d\d\d?/,et=/\d{1,3}/,it=/\d{1,4}/,nt=/[+-]?\d{1,6}/,ot=/\d+/,st=/[+-]?\d+/,rt=/Z|[+-]\d\d:?\d\d/gi,at=/Z|[+-]\d\d(?::?\d\d)?/gi,lt=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,ht={};function dt(t,e,i){ht[t]=S(e)?e:function(t,n){return t&&i?i:e}}function ut(t,e){return u(ht,t)?ht[t](e._strict,e._locale):new RegExp(ct(t.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,(function(t,e,i,n,o){return e||i||n||o}))))}function ct(t){return t.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}var pt={};function mt(t,e){var i,n=e;for("string"==typeof t&&(t=[t]),l(e)&&(n=function(t,i){i[e]=k(t)}),i=0;i<t.length;i++)pt[t[i]]=n}function ft(t,e){mt(t,(function(t,i,n,o){n._w=n._w||{},e(t,n._w,n,o)}))}function gt(t,e,i){null!=e&&u(pt,t)&&pt[t](e,i._a,i,t)}function vt(t){return bt(t)?366:365}function bt(t){return t%4==0&&t%100!=0||t%400==0}U("Y",0,0,(function(){var t=this.year();return t<=9999?""+t:"+"+t})),U(0,["YY",2],0,(function(){return this.year()%100})),U(0,["YYYY",4],0,"year"),U(0,["YYYYY",5],0,"year"),U(0,["YYYYYY",6,!0],0,"year"),Z("year","y"),A("year",1),dt("Y",st),dt("YY",q,H),dt("YYYY",it,J),dt("YYYYY",nt,K),dt("YYYYYY",nt,K),mt(["YYYYY","YYYYYY"],0),mt("YYYY",(function(t,e){e[0]=2===t.length?o.parseTwoDigitYear(t):k(t)})),mt("YY",(function(t,e){e[0]=o.parseTwoDigitYear(t)})),mt("Y",(function(t,e){e[0]=parseInt(t,10)})),o.parseTwoDigitYear=function(t){return k(t)+(k(t)>68?1900:2e3)};var yt,xt=wt("FullYear",!0);function wt(t,e){return function(i){return null!=i?(kt(this,t,i),o.updateOffset(this,e),this):_t(this,t)}}function _t(t,e){return t.isValid()?t._d["get"+(t._isUTC?"UTC":"")+e]():NaN}function kt(t,e,i){t.isValid()&&!isNaN(i)&&("FullYear"===e&&bt(t.year())&&1===t.month()&&29===t.date()?t._d["set"+(t._isUTC?"UTC":"")+e](i,t.month(),Dt(i,t.month())):t._d["set"+(t._isUTC?"UTC":"")+e](i))}function Dt(t,e){if(isNaN(t)||isNaN(e))return NaN;var i,n=(e%(i=12)+i)%i;return t+=(e-n)/12,1===n?bt(t)?29:28:31-n%7%2}yt=Array.prototype.indexOf?Array.prototype.indexOf:function(t){var e;for(e=0;e<this.length;++e)if(this[e]===t)return e;return-1},U("M",["MM",2],"Mo",(function(){return this.month()+1})),U("MMM",0,0,(function(t){return this.localeData().monthsShort(this,t)})),U("MMMM",0,0,(function(t){return this.localeData().months(this,t)})),Z("month","M"),A("month",8),dt("M",q),dt("MM",q,H),dt("MMM",(function(t,e){return e.monthsShortRegex(t)})),dt("MMMM",(function(t,e){return e.monthsRegex(t)})),mt(["M","MM"],(function(t,e){e[1]=k(t)-1})),mt(["MMM","MMMM"],(function(t,e,i,n){var o=i._locale.monthsParse(t,n,i._strict);null!=o?e[1]=o:m(i).invalidMonth=t}));var It=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,Ct="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),Lt="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_");function Gt(t,e,i){var n,o,s,r=t.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],n=0;n<12;++n)s=p([2e3,n]),this._shortMonthsParse[n]=this.monthsShort(s,"").toLocaleLowerCase(),this._longMonthsParse[n]=this.months(s,"").toLocaleLowerCase();return i?"MMM"===e?-1!==(o=yt.call(this._shortMonthsParse,r))?o:null:-1!==(o=yt.call(this._longMonthsParse,r))?o:null:"MMM"===e?-1!==(o=yt.call(this._shortMonthsParse,r))||-1!==(o=yt.call(this._longMonthsParse,r))?o:null:-1!==(o=yt.call(this._longMonthsParse,r))||-1!==(o=yt.call(this._shortMonthsParse,r))?o:null}function Mt(t,e){var i;if(!t.isValid())return t;if("string"==typeof e)if(/^\d+$/.test(e))e=k(e);else if(!l(e=t.localeData().monthsParse(e)))return t;return i=Math.min(t.date(),Dt(t.year(),e)),t._d["set"+(t._isUTC?"UTC":"")+"Month"](e,i),t}function St(t){return null!=t?(Mt(this,t),o.updateOffset(this,!0),this):_t(this,"Month")}var Qt=lt,Nt=lt;function Ft(){function t(t,e){return e.length-t.length}var e,i,n=[],o=[],s=[];for(e=0;e<12;e++)i=p([2e3,e]),n.push(this.monthsShort(i,"")),o.push(this.months(i,"")),s.push(this.months(i,"")),s.push(this.monthsShort(i,""));for(n.sort(t),o.sort(t),s.sort(t),e=0;e<12;e++)n[e]=ct(n[e]),o[e]=ct(o[e]);for(e=0;e<24;e++)s[e]=ct(s[e]);this._monthsRegex=new RegExp("^("+s.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+o.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+n.join("|")+")","i")}function Zt(t,e,i,n,o,s,r){var a;return t<100&&t>=0?(a=new Date(t+400,e,i,n,o,s,r),isFinite(a.getFullYear())&&a.setFullYear(t)):a=new Date(t,e,i,n,o,s,r),a}function Bt(t){var e;if(t<100&&t>=0){var i=Array.prototype.slice.call(arguments);i[0]=t+400,e=new Date(Date.UTC.apply(null,i)),isFinite(e.getUTCFullYear())&&e.setUTCFullYear(t)}else e=new Date(Date.UTC.apply(null,arguments));return e}function Ot(t,e,i){var n=7+e-i;return-(7+Bt(t,0,n).getUTCDay()-e)%7+n-1}function Wt(t,e,i,n,o){var s,r,a=1+7*(e-1)+(7+i-n)%7+Ot(t,n,o);return a<=0?r=vt(s=t-1)+a:a>vt(t)?(s=t+1,r=a-vt(t)):(s=t,r=a),{year:s,dayOfYear:r}}function At(t,e,i){var n,o,s=Ot(t.year(),e,i),r=Math.floor((t.dayOfYear()-s-1)/7)+1;return r<1?n=r+Xt(o=t.year()-1,e,i):r>Xt(t.year(),e,i)?(n=r-Xt(t.year(),e,i),o=t.year()+1):(o=t.year(),n=r),{week:n,year:o}}function Xt(t,e,i){var n=Ot(t,e,i),o=Ot(t+1,e,i);return(vt(t)-n+o)/7}function Tt(t,e){return t.slice(e,7).concat(t.slice(0,e))}U("w",["ww",2],"wo","week"),U("W",["WW",2],"Wo","isoWeek"),Z("week","w"),Z("isoWeek","W"),A("week",5),A("isoWeek",5),dt("w",q),dt("ww",q,H),dt("W",q),dt("WW",q,H),ft(["w","ww","W","WW"],(function(t,e,i,n){e[n.substr(0,1)]=k(t)})),U("d",0,"do","day"),U("dd",0,0,(function(t){return this.localeData().weekdaysMin(this,t)})),U("ddd",0,0,(function(t){return this.localeData().weekdaysShort(this,t)})),U("dddd",0,0,(function(t){return this.localeData().weekdays(this,t)})),U("e",0,0,"weekday"),U("E",0,0,"isoWeekday"),Z("day","d"),Z("weekday","e"),Z("isoWeekday","E"),A("day",11),A("weekday",11),A("isoWeekday",11),dt("d",q),dt("e",q),dt("E",q),dt("dd",(function(t,e){return e.weekdaysMinRegex(t)})),dt("ddd",(function(t,e){return e.weekdaysShortRegex(t)})),dt("dddd",(function(t,e){return e.weekdaysRegex(t)})),ft(["dd","ddd","dddd"],(function(t,e,i,n){var o=i._locale.weekdaysParse(t,n,i._strict);null!=o?e.d=o:m(i).invalidWeekday=t})),ft(["d","e","E"],(function(t,e,i,n){e[n]=k(t)}));var Yt="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),Et="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),Rt="Su_Mo_Tu_We_Th_Fr_Sa".split("_");function Ut(t,e,i){var n,o,s,r=t.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],n=0;n<7;++n)s=p([2e3,1]).day(n),this._minWeekdaysParse[n]=this.weekdaysMin(s,"").toLocaleLowerCase(),this._shortWeekdaysParse[n]=this.weekdaysShort(s,"").toLocaleLowerCase(),this._weekdaysParse[n]=this.weekdays(s,"").toLocaleLowerCase();return i?"dddd"===e?-1!==(o=yt.call(this._weekdaysParse,r))?o:null:"ddd"===e?-1!==(o=yt.call(this._shortWeekdaysParse,r))?o:null:-1!==(o=yt.call(this._minWeekdaysParse,r))?o:null:"dddd"===e?-1!==(o=yt.call(this._weekdaysParse,r))||-1!==(o=yt.call(this._shortWeekdaysParse,r))||-1!==(o=yt.call(this._minWeekdaysParse,r))?o:null:"ddd"===e?-1!==(o=yt.call(this._shortWeekdaysParse,r))||-1!==(o=yt.call(this._weekdaysParse,r))||-1!==(o=yt.call(this._minWeekdaysParse,r))?o:null:-1!==(o=yt.call(this._minWeekdaysParse,r))||-1!==(o=yt.call(this._weekdaysParse,r))||-1!==(o=yt.call(this._shortWeekdaysParse,r))?o:null}var zt=lt,Vt=lt,jt=lt;function Ht(){function t(t,e){return e.length-t.length}var e,i,n,o,s,r=[],a=[],l=[],h=[];for(e=0;e<7;e++)i=p([2e3,1]).day(e),n=this.weekdaysMin(i,""),o=this.weekdaysShort(i,""),s=this.weekdays(i,""),r.push(n),a.push(o),l.push(s),h.push(n),h.push(o),h.push(s);for(r.sort(t),a.sort(t),l.sort(t),h.sort(t),e=0;e<7;e++)a[e]=ct(a[e]),l[e]=ct(l[e]),h[e]=ct(h[e]);this._weekdaysRegex=new RegExp("^("+h.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+l.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+r.join("|")+")","i")}function Pt(){return this.hours()%12||12}function Jt(t,e){U(t,0,0,(function(){return this.localeData().meridiem(this.hours(),this.minutes(),e)}))}function Kt(t,e){return e._meridiemParse}U("H",["HH",2],0,"hour"),U("h",["hh",2],0,Pt),U("k",["kk",2],0,(function(){return this.hours()||24})),U("hmm",0,0,(function(){return""+Pt.apply(this)+X(this.minutes(),2)})),U("hmmss",0,0,(function(){return""+Pt.apply(this)+X(this.minutes(),2)+X(this.seconds(),2)})),U("Hmm",0,0,(function(){return""+this.hours()+X(this.minutes(),2)})),U("Hmmss",0,0,(function(){return""+this.hours()+X(this.minutes(),2)+X(this.seconds(),2)})),Jt("a",!0),Jt("A",!1),Z("hour","h"),A("hour",13),dt("a",Kt),dt("A",Kt),dt("H",q),dt("h",q),dt("k",q),dt("HH",q,H),dt("hh",q,H),dt("kk",q,H),dt("hmm",$),dt("hmmss",tt),dt("Hmm",$),dt("Hmmss",tt),mt(["H","HH"],3),mt(["k","kk"],(function(t,e,i){var n=k(t);e[3]=24===n?0:n})),mt(["a","A"],(function(t,e,i){i._isPm=i._locale.isPM(t),i._meridiem=t})),mt(["h","hh"],(function(t,e,i){e[3]=k(t),m(i).bigHour=!0})),mt("hmm",(function(t,e,i){var n=t.length-2;e[3]=k(t.substr(0,n)),e[4]=k(t.substr(n)),m(i).bigHour=!0})),mt("hmmss",(function(t,e,i){var n=t.length-4,o=t.length-2;e[3]=k(t.substr(0,n)),e[4]=k(t.substr(n,2)),e[5]=k(t.substr(o)),m(i).bigHour=!0})),mt("Hmm",(function(t,e,i){var n=t.length-2;e[3]=k(t.substr(0,n)),e[4]=k(t.substr(n))})),mt("Hmmss",(function(t,e,i){var n=t.length-4,o=t.length-2;e[3]=k(t.substr(0,n)),e[4]=k(t.substr(n,2)),e[5]=k(t.substr(o))}));var qt,$t=wt("Hours",!0),te={calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},longDateFormat:{LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},invalidDate:"Invalid date",ordinal:"%d",dayOfMonthOrdinalParse:/\d{1,2}/,relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},months:Ct,monthsShort:Lt,week:{dow:0,doy:6},weekdays:Yt,weekdaysMin:Rt,weekdaysShort:Et,meridiemParse:/[ap]\.?m?\.?/i},ee={},ie={};function ne(t){return t?t.toLowerCase().replace("_","-"):t}function oe(e){var n=null;if(!ee[e]&&t&&t.exports)try{n=qt._abbr,i(),se(n)}catch(t){}return ee[e]}function se(t,e){var i;return t&&((i=a(e)?ae(t):re(t,e))?qt=i:"undefined"!=typeof console&&console.warn&&console.warn("Locale "+t+" not found. Did you forget to load it?")),qt._abbr}function re(t,e){if(null!==e){var i,n=te;if(e.abbr=t,null!=ee[t])M("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),n=ee[t]._config;else if(null!=e.parentLocale)if(null!=ee[e.parentLocale])n=ee[e.parentLocale]._config;else{if(null==(i=oe(e.parentLocale)))return ie[e.parentLocale]||(ie[e.parentLocale]=[]),ie[e.parentLocale].push({name:t,config:e}),null;n=i._config}return ee[t]=new N(Q(n,e)),ie[t]&&ie[t].forEach((function(t){re(t.name,t.config)})),se(t),ee[t]}return delete ee[t],null}function ae(t){var e;if(t&&t._locale&&t._locale._abbr&&(t=t._locale._abbr),!t)return qt;if(!s(t)){if(e=oe(t))return e;t=[t]}return function(t){for(var e,i,n,o,s=0;s<t.length;){for(e=(o=ne(t[s]).split("-")).length,i=(i=ne(t[s+1]))?i.split("-"):null;e>0;){if(n=oe(o.slice(0,e).join("-")))return n;if(i&&i.length>=e&&D(o,i,!0)>=e-1)break;e--}s++}return qt}(t)}function le(t){var e,i=t._a;return i&&-2===m(t).overflow&&(e=i[1]<0||i[1]>11?1:i[2]<1||i[2]>Dt(i[0],i[1])?2:i[3]<0||i[3]>24||24===i[3]&&(0!==i[4]||0!==i[5]||0!==i[6])?3:i[4]<0||i[4]>59?4:i[5]<0||i[5]>59?5:i[6]<0||i[6]>999?6:-1,m(t)._overflowDayOfYear&&(e<0||e>2)&&(e=2),m(t)._overflowWeeks&&-1===e&&(e=7),m(t)._overflowWeekday&&-1===e&&(e=8),m(t).overflow=e),t}function he(t,e,i){return null!=t?t:null!=e?e:i}function de(t){var e,i,n,s,r,a=[];if(!t._d){for(n=function(t){var e=new Date(o.now());return t._useUTC?[e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate()]:[e.getFullYear(),e.getMonth(),e.getDate()]}(t),t._w&&null==t._a[2]&&null==t._a[1]&&function(t){var e,i,n,o,s,r,a,l;if(null!=(e=t._w).GG||null!=e.W||null!=e.E)s=1,r=4,i=he(e.GG,t._a[0],At(Ie(),1,4).year),n=he(e.W,1),((o=he(e.E,1))<1||o>7)&&(l=!0);else{s=t._locale._week.dow,r=t._locale._week.doy;var h=At(Ie(),s,r);i=he(e.gg,t._a[0],h.year),n=he(e.w,h.week),null!=e.d?((o=e.d)<0||o>6)&&(l=!0):null!=e.e?(o=e.e+s,(e.e<0||e.e>6)&&(l=!0)):o=s}n<1||n>Xt(i,s,r)?m(t)._overflowWeeks=!0:null!=l?m(t)._overflowWeekday=!0:(a=Wt(i,n,o,s,r),t._a[0]=a.year,t._dayOfYear=a.dayOfYear)}(t),null!=t._dayOfYear&&(r=he(t._a[0],n[0]),(t._dayOfYear>vt(r)||0===t._dayOfYear)&&(m(t)._overflowDayOfYear=!0),i=Bt(r,0,t._dayOfYear),t._a[1]=i.getUTCMonth(),t._a[2]=i.getUTCDate()),e=0;e<3&&null==t._a[e];++e)t._a[e]=a[e]=n[e];for(;e<7;e++)t._a[e]=a[e]=null==t._a[e]?2===e?1:0:t._a[e];24===t._a[3]&&0===t._a[4]&&0===t._a[5]&&0===t._a[6]&&(t._nextDay=!0,t._a[3]=0),t._d=(t._useUTC?Bt:Zt).apply(null,a),s=t._useUTC?t._d.getUTCDay():t._d.getDay(),null!=t._tzm&&t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),t._nextDay&&(t._a[3]=24),t._w&&void 0!==t._w.d&&t._w.d!==s&&(m(t).weekdayMismatch=!0)}}var ue=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,ce=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/,pe=/Z|[+-]\d\d(?::?\d\d)?/,me=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/]],fe=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],ge=/^\/?Date\((\-?\d+)/i;function ve(t){var e,i,n,o,s,r,a=t._i,l=ue.exec(a)||ce.exec(a);if(l){for(m(t).iso=!0,e=0,i=me.length;e<i;e++)if(me[e][1].exec(l[1])){o=me[e][0],n=!1!==me[e][2];break}if(null==o)return void(t._isValid=!1);if(l[3]){for(e=0,i=fe.length;e<i;e++)if(fe[e][1].exec(l[3])){s=(l[2]||" ")+fe[e][0];break}if(null==s)return void(t._isValid=!1)}if(!n&&null!=s)return void(t._isValid=!1);if(l[4]){if(!pe.exec(l[4]))return void(t._isValid=!1);r="Z"}t._f=o+(s||"")+(r||""),_e(t)}else t._isValid=!1}var be=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;function ye(t){var e=parseInt(t,10);return e<=49?2e3+e:e<=999?1900+e:e}var xe={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function we(t){var e,i,n,o,s,r,a,l=be.exec(t._i.replace(/\([^)]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s\s*/,"").replace(/\s\s*$/,""));if(l){var h=(e=l[4],i=l[3],n=l[2],o=l[5],s=l[6],r=l[7],a=[ye(e),Lt.indexOf(i),parseInt(n,10),parseInt(o,10),parseInt(s,10)],r&&a.push(parseInt(r,10)),a);if(!function(t,e,i){return!t||Et.indexOf(t)===new Date(e[0],e[1],e[2]).getDay()||(m(i).weekdayMismatch=!0,i._isValid=!1,!1)}(l[1],h,t))return;t._a=h,t._tzm=function(t,e,i){if(t)return xe[t];if(e)return 0;var n=parseInt(i,10),o=n%100;return(n-o)/100*60+o}(l[8],l[9],l[10]),t._d=Bt.apply(null,t._a),t._d.setUTCMinutes(t._d.getUTCMinutes()-t._tzm),m(t).rfc2822=!0}else t._isValid=!1}function _e(t){if(t._f!==o.ISO_8601)if(t._f!==o.RFC_2822){t._a=[],m(t).empty=!0;var e,i,n,s,r,a=""+t._i,l=a.length,h=0;for(n=V(t._f,t._locale).match(T)||[],e=0;e<n.length;e++)s=n[e],(i=(a.match(ut(s,t))||[])[0])&&((r=a.substr(0,a.indexOf(i))).length>0&&m(t).unusedInput.push(r),a=a.slice(a.indexOf(i)+i.length),h+=i.length),R[s]?(i?m(t).empty=!1:m(t).unusedTokens.push(s),gt(s,i,t)):t._strict&&!i&&m(t).unusedTokens.push(s);m(t).charsLeftOver=l-h,a.length>0&&m(t).unusedInput.push(a),t._a[3]<=12&&!0===m(t).bigHour&&t._a[3]>0&&(m(t).bigHour=void 0),m(t).parsedDateParts=t._a.slice(0),m(t).meridiem=t._meridiem,t._a[3]=function(t,e,i){var n;return null==i?e:null!=t.meridiemHour?t.meridiemHour(e,i):null!=t.isPM?((n=t.isPM(i))&&e<12&&(e+=12),n||12!==e||(e=0),e):e}(t._locale,t._a[3],t._meridiem),de(t),le(t)}else we(t);else ve(t)}function ke(t){var e=t._i,i=t._f;return t._locale=t._locale||ae(t._l),null===e||void 0===i&&""===e?g({nullInput:!0}):("string"==typeof e&&(t._i=e=t._locale.preparse(e)),w(e)?new x(le(e)):(h(e)?t._d=e:s(i)?function(t){var e,i,n,o,s;if(0===t._f.length)return m(t).invalidFormat=!0,void(t._d=new Date(NaN));for(o=0;o<t._f.length;o++)s=0,e=b({},t),null!=t._useUTC&&(e._useUTC=t._useUTC),e._f=t._f[o],_e(e),f(e)&&(s+=m(e).charsLeftOver,s+=10*m(e).unusedTokens.length,m(e).score=s,(null==n||s<n)&&(n=s,i=e));c(t,i||e)}(t):i?_e(t):function(t){var e=t._i;a(e)?t._d=new Date(o.now()):h(e)?t._d=new Date(e.valueOf()):"string"==typeof e?function(t){var e=ge.exec(t._i);null===e?(ve(t),!1===t._isValid&&(delete t._isValid,we(t),!1===t._isValid&&(delete t._isValid,o.createFromInputFallback(t)))):t._d=new Date(+e[1])}(t):s(e)?(t._a=d(e.slice(0),(function(t){return parseInt(t,10)})),de(t)):r(e)?function(t){if(!t._d){var e=O(t._i);t._a=d([e.year,e.month,e.day||e.date,e.hour,e.minute,e.second,e.millisecond],(function(t){return t&&parseInt(t,10)})),de(t)}}(t):l(e)?t._d=new Date(e):o.createFromInputFallback(t)}(t),f(t)||(t._d=null),t))}function De(t,e,i,n,o){var a,l={};return!0!==i&&!1!==i||(n=i,i=void 0),(r(t)&&function(t){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(t).length;var e;for(e in t)if(t.hasOwnProperty(e))return!1;return!0}(t)||s(t)&&0===t.length)&&(t=void 0),l._isAMomentObject=!0,l._useUTC=l._isUTC=o,l._l=i,l._i=t,l._f=e,l._strict=n,(a=new x(le(ke(l))))._nextDay&&(a.add(1,"d"),a._nextDay=void 0),a}function Ie(t,e,i,n){return De(t,e,i,n,!1)}o.createFromInputFallback=C("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged and will be removed in an upcoming major release. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",(function(t){t._d=new Date(t._i+(t._useUTC?" UTC":""))})),o.ISO_8601=function(){},o.RFC_2822=function(){};var Ce=C("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var t=Ie.apply(null,arguments);return this.isValid()&&t.isValid()?t<this?this:t:g()})),Le=C("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",(function(){var t=Ie.apply(null,arguments);return this.isValid()&&t.isValid()?t>this?this:t:g()}));function Ge(t,e){var i,n;if(1===e.length&&s(e[0])&&(e=e[0]),!e.length)return Ie();for(i=e[0],n=1;n<e.length;++n)e[n].isValid()&&!e[n][t](i)||(i=e[n]);return i}var Me=["year","quarter","month","week","day","hour","minute","second","millisecond"];function Se(t){var e=O(t),i=e.year||0,n=e.quarter||0,o=e.month||0,s=e.week||e.isoWeek||0,r=e.day||0,a=e.hour||0,l=e.minute||0,h=e.second||0,d=e.millisecond||0;this._isValid=function(t){for(var e in t)if(-1===yt.call(Me,e)||null!=t[e]&&isNaN(t[e]))return!1;for(var i=!1,n=0;n<Me.length;++n)if(t[Me[n]]){if(i)return!1;parseFloat(t[Me[n]])!==k(t[Me[n]])&&(i=!0)}return!0}(e),this._milliseconds=+d+1e3*h+6e4*l+1e3*a*60*60,this._days=+r+7*s,this._months=+o+3*n+12*i,this._data={},this._locale=ae(),this._bubble()}function Qe(t){return t instanceof Se}function Ne(t){return t<0?-1*Math.round(-1*t):Math.round(t)}function Fe(t,e){U(t,0,0,(function(){var t=this.utcOffset(),i="+";return t<0&&(t=-t,i="-"),i+X(~~(t/60),2)+e+X(~~t%60,2)}))}Fe("Z",":"),Fe("ZZ",""),dt("Z",at),dt("ZZ",at),mt(["Z","ZZ"],(function(t,e,i){i._useUTC=!0,i._tzm=Be(at,t)}));var Ze=/([\+\-]|\d\d)/gi;function Be(t,e){var i=(e||"").match(t);if(null===i)return null;var n=((i[i.length-1]||[])+"").match(Ze)||["-",0,0],o=60*n[1]+k(n[2]);return 0===o?0:"+"===n[0]?o:-o}function Oe(t,e){var i,n;return e._isUTC?(i=e.clone(),n=(w(t)||h(t)?t.valueOf():Ie(t).valueOf())-i.valueOf(),i._d.setTime(i._d.valueOf()+n),o.updateOffset(i,!1),i):Ie(t).local()}function We(t){return 15*-Math.round(t._d.getTimezoneOffset()/15)}function Ae(){return!!this.isValid()&&this._isUTC&&0===this._offset}o.updateOffset=function(){};var Xe=/^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/,Te=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function Ye(t,e){var i,n,o,s,r,a,h=t,d=null;return Qe(t)?h={ms:t._milliseconds,d:t._days,M:t._months}:l(t)?(h={},e?h[e]=t:h.milliseconds=t):(d=Xe.exec(t))?(i="-"===d[1]?-1:1,h={y:0,d:k(d[2])*i,h:k(d[3])*i,m:k(d[4])*i,s:k(d[5])*i,ms:k(Ne(1e3*d[6]))*i}):(d=Te.exec(t))?(i="-"===d[1]?-1:1,h={y:Ee(d[2],i),M:Ee(d[3],i),w:Ee(d[4],i),d:Ee(d[5],i),h:Ee(d[6],i),m:Ee(d[7],i),s:Ee(d[8],i)}):null==h?h={}:"object"==typeof h&&("from"in h||"to"in h)&&(s=Ie(h.from),r=Ie(h.to),o=s.isValid()&&r.isValid()?(r=Oe(r,s),s.isBefore(r)?a=Re(s,r):((a=Re(r,s)).milliseconds=-a.milliseconds,a.months=-a.months),a):{milliseconds:0,months:0},(h={}).ms=o.milliseconds,h.M=o.months),n=new Se(h),Qe(t)&&u(t,"_locale")&&(n._locale=t._locale),n}function Ee(t,e){var i=t&&parseFloat(t.replace(",","."));return(isNaN(i)?0:i)*e}function Re(t,e){var i={};return i.months=e.month()-t.month()+12*(e.year()-t.year()),t.clone().add(i.months,"M").isAfter(e)&&--i.months,i.milliseconds=+e-+t.clone().add(i.months,"M"),i}function Ue(t,e){return function(i,n){var o;return null===n||isNaN(+n)||(M(e,"moment()."+e+"(period, number) is deprecated. Please use moment()."+e+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),o=i,i=n,n=o),ze(this,Ye(i="string"==typeof i?+i:i,n),t),this}}function ze(t,e,i,n){var s=e._milliseconds,r=Ne(e._days),a=Ne(e._months);t.isValid()&&(n=null==n||n,a&&Mt(t,_t(t,"Month")+a*i),r&&kt(t,"Date",_t(t,"Date")+r*i),s&&t._d.setTime(t._d.valueOf()+s*i),n&&o.updateOffset(t,r||a))}Ye.fn=Se.prototype,Ye.invalid=function(){return Ye(NaN)};var Ve=Ue(1,"add"),je=Ue(-1,"subtract");function He(t,e){var i=12*(e.year()-t.year())+(e.month()-t.month()),n=t.clone().add(i,"months");return-(i+(e-n<0?(e-n)/(n-t.clone().add(i-1,"months")):(e-n)/(t.clone().add(i+1,"months")-n)))||0}function Pe(t){var e;return void 0===t?this._locale._abbr:(null!=(e=ae(t))&&(this._locale=e),this)}o.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",o.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";var Je=C("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",(function(t){return void 0===t?this.localeData():this.locale(t)}));function Ke(){return this._locale}function qe(t,e){return(t%e+e)%e}function $e(t,e,i){return t<100&&t>=0?new Date(t+400,e,i)-126227808e5:new Date(t,e,i).valueOf()}function ti(t,e,i){return t<100&&t>=0?Date.UTC(t+400,e,i)-126227808e5:Date.UTC(t,e,i)}function ei(t,e){U(0,[t,t.length],0,e)}function ii(t,e,i,n,o){var s;return null==t?At(this,n,o).year:(e>(s=Xt(t,n,o))&&(e=s),ni.call(this,t,e,i,n,o))}function ni(t,e,i,n,o){var s=Wt(t,e,i,n,o),r=Bt(s.year,0,s.dayOfYear);return this.year(r.getUTCFullYear()),this.month(r.getUTCMonth()),this.date(r.getUTCDate()),this}U(0,["gg",2],0,(function(){return this.weekYear()%100})),U(0,["GG",2],0,(function(){return this.isoWeekYear()%100})),ei("gggg","weekYear"),ei("ggggg","weekYear"),ei("GGGG","isoWeekYear"),ei("GGGGG","isoWeekYear"),Z("weekYear","gg"),Z("isoWeekYear","GG"),A("weekYear",1),A("isoWeekYear",1),dt("G",st),dt("g",st),dt("GG",q,H),dt("gg",q,H),dt("GGGG",it,J),dt("gggg",it,J),dt("GGGGG",nt,K),dt("ggggg",nt,K),ft(["gggg","ggggg","GGGG","GGGGG"],(function(t,e,i,n){e[n.substr(0,2)]=k(t)})),ft(["gg","GG"],(function(t,e,i,n){e[n]=o.parseTwoDigitYear(t)})),U("Q",0,"Qo","quarter"),Z("quarter","Q"),A("quarter",7),dt("Q",j),mt("Q",(function(t,e){e[1]=3*(k(t)-1)})),U("D",["DD",2],"Do","date"),Z("date","D"),A("date",9),dt("D",q),dt("DD",q,H),dt("Do",(function(t,e){return t?e._dayOfMonthOrdinalParse||e._ordinalParse:e._dayOfMonthOrdinalParseLenient})),mt(["D","DD"],2),mt("Do",(function(t,e){e[2]=k(t.match(q)[0])}));var oi=wt("Date",!0);U("DDD",["DDDD",3],"DDDo","dayOfYear"),Z("dayOfYear","DDD"),A("dayOfYear",4),dt("DDD",et),dt("DDDD",P),mt(["DDD","DDDD"],(function(t,e,i){i._dayOfYear=k(t)})),U("m",["mm",2],0,"minute"),Z("minute","m"),A("minute",14),dt("m",q),dt("mm",q,H),mt(["m","mm"],4);var si=wt("Minutes",!1);U("s",["ss",2],0,"second"),Z("second","s"),A("second",15),dt("s",q),dt("ss",q,H),mt(["s","ss"],5);var ri,ai=wt("Seconds",!1);for(U("S",0,0,(function(){return~~(this.millisecond()/100)})),U(0,["SS",2],0,(function(){return~~(this.millisecond()/10)})),U(0,["SSS",3],0,"millisecond"),U(0,["SSSS",4],0,(function(){return 10*this.millisecond()})),U(0,["SSSSS",5],0,(function(){return 100*this.millisecond()})),U(0,["SSSSSS",6],0,(function(){return 1e3*this.millisecond()})),U(0,["SSSSSSS",7],0,(function(){return 1e4*this.millisecond()})),U(0,["SSSSSSSS",8],0,(function(){return 1e5*this.millisecond()})),U(0,["SSSSSSSSS",9],0,(function(){return 1e6*this.millisecond()})),Z("millisecond","ms"),A("millisecond",16),dt("S",et,j),dt("SS",et,H),dt("SSS",et,P),ri="SSSS";ri.length<=9;ri+="S")dt(ri,ot);function li(t,e){e[6]=k(1e3*("0."+t))}for(ri="S";ri.length<=9;ri+="S")mt(ri,li);var hi=wt("Milliseconds",!1);U("z",0,0,"zoneAbbr"),U("zz",0,0,"zoneName");var di=x.prototype;function ui(t){return t}di.add=Ve,di.calendar=function(t,e){var i=t||Ie(),n=Oe(i,this).startOf("day"),s=o.calendarFormat(this,n)||"sameElse",r=e&&(S(e[s])?e[s].call(this,i):e[s]);return this.format(r||this.localeData().calendar(s,this,Ie(i)))},di.clone=function(){return new x(this)},di.diff=function(t,e,i){var n,o,s;if(!this.isValid())return NaN;if(!(n=Oe(t,this)).isValid())return NaN;switch(o=6e4*(n.utcOffset()-this.utcOffset()),e=B(e)){case"year":s=He(this,n)/12;break;case"month":s=He(this,n);break;case"quarter":s=He(this,n)/3;break;case"second":s=(this-n)/1e3;break;case"minute":s=(this-n)/6e4;break;case"hour":s=(this-n)/36e5;break;case"day":s=(this-n-o)/864e5;break;case"week":s=(this-n-o)/6048e5;break;default:s=this-n}return i?s:_(s)},di.endOf=function(t){var e;if(void 0===(t=B(t))||"millisecond"===t||!this.isValid())return this;var i=this._isUTC?ti:$e;switch(t){case"year":e=i(this.year()+1,0,1)-1;break;case"quarter":e=i(this.year(),this.month()-this.month()%3+3,1)-1;break;case"month":e=i(this.year(),this.month()+1,1)-1;break;case"week":e=i(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case"isoWeek":e=i(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case"day":case"date":e=i(this.year(),this.month(),this.date()+1)-1;break;case"hour":e=this._d.valueOf(),e+=36e5-qe(e+(this._isUTC?0:6e4*this.utcOffset()),36e5)-1;break;case"minute":e=this._d.valueOf(),e+=6e4-qe(e,6e4)-1;break;case"second":e=this._d.valueOf(),e+=1e3-qe(e,1e3)-1}return this._d.setTime(e),o.updateOffset(this,!0),this},di.format=function(t){t||(t=this.isUtc()?o.defaultFormatUtc:o.defaultFormat);var e=z(this,t);return this.localeData().postformat(e)},di.from=function(t,e){return this.isValid()&&(w(t)&&t.isValid()||Ie(t).isValid())?Ye({to:this,from:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()},di.fromNow=function(t){return this.from(Ie(),t)},di.to=function(t,e){return this.isValid()&&(w(t)&&t.isValid()||Ie(t).isValid())?Ye({from:this,to:t}).locale(this.locale()).humanize(!e):this.localeData().invalidDate()},di.toNow=function(t){return this.to(Ie(),t)},di.get=function(t){return S(this[t=B(t)])?this[t]():this},di.invalidAt=function(){return m(this).overflow},di.isAfter=function(t,e){var i=w(t)?t:Ie(t);return!(!this.isValid()||!i.isValid())&&("millisecond"===(e=B(e)||"millisecond")?this.valueOf()>i.valueOf():i.valueOf()<this.clone().startOf(e).valueOf())},di.isBefore=function(t,e){var i=w(t)?t:Ie(t);return!(!this.isValid()||!i.isValid())&&("millisecond"===(e=B(e)||"millisecond")?this.valueOf()<i.valueOf():this.clone().endOf(e).valueOf()<i.valueOf())},di.isBetween=function(t,e,i,n){var o=w(t)?t:Ie(t),s=w(e)?e:Ie(e);return!!(this.isValid()&&o.isValid()&&s.isValid())&&("("===(n=n||"()")[0]?this.isAfter(o,i):!this.isBefore(o,i))&&(")"===n[1]?this.isBefore(s,i):!this.isAfter(s,i))},di.isSame=function(t,e){var i,n=w(t)?t:Ie(t);return!(!this.isValid()||!n.isValid())&&("millisecond"===(e=B(e)||"millisecond")?this.valueOf()===n.valueOf():(i=n.valueOf(),this.clone().startOf(e).valueOf()<=i&&i<=this.clone().endOf(e).valueOf()))},di.isSameOrAfter=function(t,e){return this.isSame(t,e)||this.isAfter(t,e)},di.isSameOrBefore=function(t,e){return this.isSame(t,e)||this.isBefore(t,e)},di.isValid=function(){return f(this)},di.lang=Je,di.locale=Pe,di.localeData=Ke,di.max=Le,di.min=Ce,di.parsingFlags=function(){return c({},m(this))},di.set=function(t,e){if("object"==typeof t)for(var i=function(t){var e=[];for(var i in t)e.push({unit:i,priority:W[i]});return e.sort((function(t,e){return t.priority-e.priority})),e}(t=O(t)),n=0;n<i.length;n++)this[i[n].unit](t[i[n].unit]);else if(S(this[t=B(t)]))return this[t](e);return this},di.startOf=function(t){var e;if(void 0===(t=B(t))||"millisecond"===t||!this.isValid())return this;var i=this._isUTC?ti:$e;switch(t){case"year":e=i(this.year(),0,1);break;case"quarter":e=i(this.year(),this.month()-this.month()%3,1);break;case"month":e=i(this.year(),this.month(),1);break;case"week":e=i(this.year(),this.month(),this.date()-this.weekday());break;case"isoWeek":e=i(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case"day":case"date":e=i(this.year(),this.month(),this.date());break;case"hour":e=this._d.valueOf(),e-=qe(e+(this._isUTC?0:6e4*this.utcOffset()),36e5);break;case"minute":e=this._d.valueOf(),e-=qe(e,6e4);break;case"second":e=this._d.valueOf(),e-=qe(e,1e3)}return this._d.setTime(e),o.updateOffset(this,!0),this},di.subtract=je,di.toArray=function(){var t=this;return[t.year(),t.month(),t.date(),t.hour(),t.minute(),t.second(),t.millisecond()]},di.toObject=function(){var t=this;return{years:t.year(),months:t.month(),date:t.date(),hours:t.hours(),minutes:t.minutes(),seconds:t.seconds(),milliseconds:t.milliseconds()}},di.toDate=function(){return new Date(this.valueOf())},di.toISOString=function(t){if(!this.isValid())return null;var e=!0!==t,i=e?this.clone().utc():this;return i.year()<0||i.year()>9999?z(i,e?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"):S(Date.prototype.toISOString)?e?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace("Z",z(i,"Z")):z(i,e?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ")},di.inspect=function(){if(!this.isValid())return"moment.invalid(/* "+this._i+" */)";var t="moment",e="";this.isLocal()||(t=0===this.utcOffset()?"moment.utc":"moment.parseZone",e="Z");var i="["+t+'("]',n=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",o=e+'[")]';return this.format(i+n+"-MM-DD[T]HH:mm:ss.SSS"+o)},di.toJSON=function(){return this.isValid()?this.toISOString():null},di.toString=function(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")},di.unix=function(){return Math.floor(this.valueOf()/1e3)},di.valueOf=function(){return this._d.valueOf()-6e4*(this._offset||0)},di.creationData=function(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}},di.year=xt,di.isLeapYear=function(){return bt(this.year())},di.weekYear=function(t){return ii.call(this,t,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)},di.isoWeekYear=function(t){return ii.call(this,t,this.isoWeek(),this.isoWeekday(),1,4)},di.quarter=di.quarters=function(t){return null==t?Math.ceil((this.month()+1)/3):this.month(3*(t-1)+this.month()%3)},di.month=St,di.daysInMonth=function(){return Dt(this.year(),this.month())},di.week=di.weeks=function(t){var e=this.localeData().week(this);return null==t?e:this.add(7*(t-e),"d")},di.isoWeek=di.isoWeeks=function(t){var e=At(this,1,4).week;return null==t?e:this.add(7*(t-e),"d")},di.weeksInYear=function(){var t=this.localeData()._week;return Xt(this.year(),t.dow,t.doy)},di.isoWeeksInYear=function(){return Xt(this.year(),1,4)},di.date=oi,di.day=di.days=function(t){if(!this.isValid())return null!=t?this:NaN;var e=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=t?(t=function(t,e){return"string"!=typeof t?t:isNaN(t)?"number"==typeof(t=e.weekdaysParse(t))?t:null:parseInt(t,10)}(t,this.localeData()),this.add(t-e,"d")):e},di.weekday=function(t){if(!this.isValid())return null!=t?this:NaN;var e=(this.day()+7-this.localeData()._week.dow)%7;return null==t?e:this.add(t-e,"d")},di.isoWeekday=function(t){if(!this.isValid())return null!=t?this:NaN;if(null!=t){var e=function(t,e){return"string"==typeof t?e.weekdaysParse(t)%7||7:isNaN(t)?null:t}(t,this.localeData());return this.day(this.day()%7?e:e-7)}return this.day()||7},di.dayOfYear=function(t){var e=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==t?e:this.add(t-e,"d")},di.hour=di.hours=$t,di.minute=di.minutes=si,di.second=di.seconds=ai,di.millisecond=di.milliseconds=hi,di.utcOffset=function(t,e,i){var n,s=this._offset||0;if(!this.isValid())return null!=t?this:NaN;if(null!=t){if("string"==typeof t){if(null===(t=Be(at,t)))return this}else Math.abs(t)<16&&!i&&(t*=60);return!this._isUTC&&e&&(n=We(this)),this._offset=t,this._isUTC=!0,null!=n&&this.add(n,"m"),s!==t&&(!e||this._changeInProgress?ze(this,Ye(t-s,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,o.updateOffset(this,!0),this._changeInProgress=null)),this}return this._isUTC?s:We(this)},di.utc=function(t){return this.utcOffset(0,t)},di.local=function(t){return this._isUTC&&(this.utcOffset(0,t),this._isUTC=!1,t&&this.subtract(We(this),"m")),this},di.parseZone=function(){if(null!=this._tzm)this.utcOffset(this._tzm,!1,!0);else if("string"==typeof this._i){var t=Be(rt,this._i);null!=t?this.utcOffset(t):this.utcOffset(0,!0)}return this},di.hasAlignedHourOffset=function(t){return!!this.isValid()&&(t=t?Ie(t).utcOffset():0,(this.utcOffset()-t)%60==0)},di.isDST=function(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()},di.isLocal=function(){return!!this.isValid()&&!this._isUTC},di.isUtcOffset=function(){return!!this.isValid()&&this._isUTC},di.isUtc=Ae,di.isUTC=Ae,di.zoneAbbr=function(){return this._isUTC?"UTC":""},di.zoneName=function(){return this._isUTC?"Coordinated Universal Time":""},di.dates=C("dates accessor is deprecated. Use date instead.",oi),di.months=C("months accessor is deprecated. Use month instead",St),di.years=C("years accessor is deprecated. Use year instead",xt),di.zone=C("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",(function(t,e){return null!=t?("string"!=typeof t&&(t=-t),this.utcOffset(t,e),this):-this.utcOffset()})),di.isDSTShifted=C("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",(function(){if(!a(this._isDSTShifted))return this._isDSTShifted;var t={};if(b(t,this),(t=ke(t))._a){var e=t._isUTC?p(t._a):Ie(t._a);this._isDSTShifted=this.isValid()&&D(t._a,e.toArray())>0}else this._isDSTShifted=!1;return this._isDSTShifted}));var ci=N.prototype;function pi(t,e,i,n){var o=ae(),s=p().set(n,e);return o[i](s,t)}function mi(t,e,i){if(l(t)&&(e=t,t=void 0),t=t||"",null!=e)return pi(t,e,i,"month");var n,o=[];for(n=0;n<12;n++)o[n]=pi(t,n,i,"month");return o}function fi(t,e,i,n){"boolean"==typeof t?(l(e)&&(i=e,e=void 0),e=e||""):(i=e=t,t=!1,l(e)&&(i=e,e=void 0),e=e||"");var o,s=ae(),r=t?s._week.dow:0;if(null!=i)return pi(e,(i+r)%7,n,"day");var a=[];for(o=0;o<7;o++)a[o]=pi(e,(o+r)%7,n,"day");return a}ci.calendar=function(t,e,i){var n=this._calendar[t]||this._calendar.sameElse;return S(n)?n.call(e,i):n},ci.longDateFormat=function(t){var e=this._longDateFormat[t],i=this._longDateFormat[t.toUpperCase()];return e||!i?e:(this._longDateFormat[t]=i.replace(/MMMM|MM|DD|dddd/g,(function(t){return t.slice(1)})),this._longDateFormat[t])},ci.invalidDate=function(){return this._invalidDate},ci.ordinal=function(t){return this._ordinal.replace("%d",t)},ci.preparse=ui,ci.postformat=ui,ci.relativeTime=function(t,e,i,n){var o=this._relativeTime[i];return S(o)?o(t,e,i,n):o.replace(/%d/i,t)},ci.pastFuture=function(t,e){var i=this._relativeTime[t>0?"future":"past"];return S(i)?i(e):i.replace(/%s/i,e)},ci.set=function(t){var e,i;for(i in t)S(e=t[i])?this[i]=e:this["_"+i]=e;this._config=t,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)},ci.months=function(t,e){return t?s(this._months)?this._months[t.month()]:this._months[(this._months.isFormat||It).test(e)?"format":"standalone"][t.month()]:s(this._months)?this._months:this._months.standalone},ci.monthsShort=function(t,e){return t?s(this._monthsShort)?this._monthsShort[t.month()]:this._monthsShort[It.test(e)?"format":"standalone"][t.month()]:s(this._monthsShort)?this._monthsShort:this._monthsShort.standalone},ci.monthsParse=function(t,e,i){var n,o,s;if(this._monthsParseExact)return Gt.call(this,t,e,i);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),n=0;n<12;n++){if(o=p([2e3,n]),i&&!this._longMonthsParse[n]&&(this._longMonthsParse[n]=new RegExp("^"+this.months(o,"").replace(".","")+"$","i"),this._shortMonthsParse[n]=new RegExp("^"+this.monthsShort(o,"").replace(".","")+"$","i")),i||this._monthsParse[n]||(s="^"+this.months(o,"")+"|^"+this.monthsShort(o,""),this._monthsParse[n]=new RegExp(s.replace(".",""),"i")),i&&"MMMM"===e&&this._longMonthsParse[n].test(t))return n;if(i&&"MMM"===e&&this._shortMonthsParse[n].test(t))return n;if(!i&&this._monthsParse[n].test(t))return n}},ci.monthsRegex=function(t){return this._monthsParseExact?(u(this,"_monthsRegex")||Ft.call(this),t?this._monthsStrictRegex:this._monthsRegex):(u(this,"_monthsRegex")||(this._monthsRegex=Nt),this._monthsStrictRegex&&t?this._monthsStrictRegex:this._monthsRegex)},ci.monthsShortRegex=function(t){return this._monthsParseExact?(u(this,"_monthsRegex")||Ft.call(this),t?this._monthsShortStrictRegex:this._monthsShortRegex):(u(this,"_monthsShortRegex")||(this._monthsShortRegex=Qt),this._monthsShortStrictRegex&&t?this._monthsShortStrictRegex:this._monthsShortRegex)},ci.week=function(t){return At(t,this._week.dow,this._week.doy).week},ci.firstDayOfYear=function(){return this._week.doy},ci.firstDayOfWeek=function(){return this._week.dow},ci.weekdays=function(t,e){var i=s(this._weekdays)?this._weekdays:this._weekdays[t&&!0!==t&&this._weekdays.isFormat.test(e)?"format":"standalone"];return!0===t?Tt(i,this._week.dow):t?i[t.day()]:i},ci.weekdaysMin=function(t){return!0===t?Tt(this._weekdaysMin,this._week.dow):t?this._weekdaysMin[t.day()]:this._weekdaysMin},ci.weekdaysShort=function(t){return!0===t?Tt(this._weekdaysShort,this._week.dow):t?this._weekdaysShort[t.day()]:this._weekdaysShort},ci.weekdaysParse=function(t,e,i){var n,o,s;if(this._weekdaysParseExact)return Ut.call(this,t,e,i);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),n=0;n<7;n++){if(o=p([2e3,1]).day(n),i&&!this._fullWeekdaysParse[n]&&(this._fullWeekdaysParse[n]=new RegExp("^"+this.weekdays(o,"").replace(".","\\.?")+"$","i"),this._shortWeekdaysParse[n]=new RegExp("^"+this.weekdaysShort(o,"").replace(".","\\.?")+"$","i"),this._minWeekdaysParse[n]=new RegExp("^"+this.weekdaysMin(o,"").replace(".","\\.?")+"$","i")),this._weekdaysParse[n]||(s="^"+this.weekdays(o,"")+"|^"+this.weekdaysShort(o,"")+"|^"+this.weekdaysMin(o,""),this._weekdaysParse[n]=new RegExp(s.replace(".",""),"i")),i&&"dddd"===e&&this._fullWeekdaysParse[n].test(t))return n;if(i&&"ddd"===e&&this._shortWeekdaysParse[n].test(t))return n;if(i&&"dd"===e&&this._minWeekdaysParse[n].test(t))return n;if(!i&&this._weekdaysParse[n].test(t))return n}},ci.weekdaysRegex=function(t){return this._weekdaysParseExact?(u(this,"_weekdaysRegex")||Ht.call(this),t?this._weekdaysStrictRegex:this._weekdaysRegex):(u(this,"_weekdaysRegex")||(this._weekdaysRegex=zt),this._weekdaysStrictRegex&&t?this._weekdaysStrictRegex:this._weekdaysRegex)},ci.weekdaysShortRegex=function(t){return this._weekdaysParseExact?(u(this,"_weekdaysRegex")||Ht.call(this),t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(u(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=Vt),this._weekdaysShortStrictRegex&&t?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)},ci.weekdaysMinRegex=function(t){return this._weekdaysParseExact?(u(this,"_weekdaysRegex")||Ht.call(this),t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(u(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=jt),this._weekdaysMinStrictRegex&&t?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)},ci.isPM=function(t){return"p"===(t+"").toLowerCase().charAt(0)},ci.meridiem=function(t,e,i){return t>11?i?"pm":"PM":i?"am":"AM"},se("en",{dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(t){var e=t%10;return t+(1===k(t%100/10)?"th":1===e?"st":2===e?"nd":3===e?"rd":"th")}}),o.lang=C("moment.lang is deprecated. Use moment.locale instead.",se),o.langData=C("moment.langData is deprecated. Use moment.localeData instead.",ae);var gi=Math.abs;function vi(t,e,i,n){var o=Ye(e,i);return t._milliseconds+=n*o._milliseconds,t._days+=n*o._days,t._months+=n*o._months,t._bubble()}function bi(t){return t<0?Math.floor(t):Math.ceil(t)}function yi(t){return 4800*t/146097}function xi(t){return 146097*t/4800}function wi(t){return function(){return this.as(t)}}var _i=wi("ms"),ki=wi("s"),Di=wi("m"),Ii=wi("h"),Ci=wi("d"),Li=wi("w"),Gi=wi("M"),Mi=wi("Q"),Si=wi("y");function Qi(t){return function(){return this.isValid()?this._data[t]:NaN}}var Ni=Qi("milliseconds"),Fi=Qi("seconds"),Zi=Qi("minutes"),Bi=Qi("hours"),Oi=Qi("days"),Wi=Qi("months"),Ai=Qi("years"),Xi=Math.round,Ti={ss:44,s:45,m:45,h:22,d:26,M:11};function Yi(t,e,i,n,o){return o.relativeTime(e||1,!!i,t,n)}function Ei(t,e,i){var n=Ye(t).abs(),o=Xi(n.as("s")),s=Xi(n.as("m")),r=Xi(n.as("h")),a=Xi(n.as("d")),l=Xi(n.as("M")),h=Xi(n.as("y")),d=o<=Ti.ss&&["s",o]||o<Ti.s&&["ss",o]||s<=1&&["m"]||s<Ti.m&&["mm",s]||r<=1&&["h"]||r<Ti.h&&["hh",r]||a<=1&&["d"]||a<Ti.d&&["dd",a]||l<=1&&["M"]||l<Ti.M&&["MM",l]||h<=1&&["y"]||["yy",h];return d[2]=e,d[3]=+t>0,d[4]=i,Yi.apply(null,d)}var Ri=Math.abs;function Ui(t){return(t>0)-(t<0)||+t}function zi(){if(!this.isValid())return this.localeData().invalidDate();var t,e,i=Ri(this._milliseconds)/1e3,n=Ri(this._days),o=Ri(this._months);t=_(i/60),e=_(t/60),i%=60,t%=60;var s=_(o/12),r=o%=12,a=n,l=e,h=t,d=i?i.toFixed(3).replace(/\.?0+$/,""):"",u=this.asSeconds();if(!u)return"P0D";var c=u<0?"-":"",p=Ui(this._months)!==Ui(u)?"-":"",m=Ui(this._days)!==Ui(u)?"-":"",f=Ui(this._milliseconds)!==Ui(u)?"-":"";return c+"P"+(s?p+s+"Y":"")+(r?p+r+"M":"")+(a?m+a+"D":"")+(l||h||d?"T":"")+(l?f+l+"H":"")+(h?f+h+"M":"")+(d?f+d+"S":"")}var Vi=Se.prototype;return Vi.isValid=function(){return this._isValid},Vi.abs=function(){var t=this._data;return this._milliseconds=gi(this._milliseconds),this._days=gi(this._days),this._months=gi(this._months),t.milliseconds=gi(t.milliseconds),t.seconds=gi(t.seconds),t.minutes=gi(t.minutes),t.hours=gi(t.hours),t.months=gi(t.months),t.years=gi(t.years),this},Vi.add=function(t,e){return vi(this,t,e,1)},Vi.subtract=function(t,e){return vi(this,t,e,-1)},Vi.as=function(t){if(!this.isValid())return NaN;var e,i,n=this._milliseconds;if("month"===(t=B(t))||"quarter"===t||"year"===t)switch(e=this._days+n/864e5,i=this._months+yi(e),t){case"month":return i;case"quarter":return i/3;case"year":return i/12}else switch(e=this._days+Math.round(xi(this._months)),t){case"week":return e/7+n/6048e5;case"day":return e+n/864e5;case"hour":return 24*e+n/36e5;case"minute":return 1440*e+n/6e4;case"second":return 86400*e+n/1e3;case"millisecond":return Math.floor(864e5*e)+n;default:throw new Error("Unknown unit "+t)}},Vi.asMilliseconds=_i,Vi.asSeconds=ki,Vi.asMinutes=Di,Vi.asHours=Ii,Vi.asDays=Ci,Vi.asWeeks=Li,Vi.asMonths=Gi,Vi.asQuarters=Mi,Vi.asYears=Si,Vi.valueOf=function(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*k(this._months/12):NaN},Vi._bubble=function(){var t,e,i,n,o,s=this._milliseconds,r=this._days,a=this._months,l=this._data;return s>=0&&r>=0&&a>=0||s<=0&&r<=0&&a<=0||(s+=864e5*bi(xi(a)+r),r=0,a=0),l.milliseconds=s%1e3,t=_(s/1e3),l.seconds=t%60,e=_(t/60),l.minutes=e%60,i=_(e/60),l.hours=i%24,r+=_(i/24),o=_(yi(r)),a+=o,r-=bi(xi(o)),n=_(a/12),a%=12,l.days=r,l.months=a,l.years=n,this},Vi.clone=function(){return Ye(this)},Vi.get=function(t){return t=B(t),this.isValid()?this[t+"s"]():NaN},Vi.milliseconds=Ni,Vi.seconds=Fi,Vi.minutes=Zi,Vi.hours=Bi,Vi.days=Oi,Vi.weeks=function(){return _(this.days()/7)},Vi.months=Wi,Vi.years=Ai,Vi.humanize=function(t){if(!this.isValid())return this.localeData().invalidDate();var e=this.localeData(),i=Ei(this,!t,e);return t&&(i=e.pastFuture(+this,i)),e.postformat(i)},Vi.toISOString=zi,Vi.toString=zi,Vi.toJSON=zi,Vi.locale=Pe,Vi.localeData=Ke,Vi.toIsoString=C("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",zi),Vi.lang=Je,U("X",0,0,"unix"),U("x",0,0,"valueOf"),dt("x",st),dt("X",/[+-]?\d+(\.\d{1,3})?/),mt("X",(function(t,e,i){i._d=new Date(1e3*parseFloat(t,10))})),mt("x",(function(t,e,i){i._d=new Date(k(t))})),o.version="2.24.0",e=Ie,o.fn=di,o.min=function(){var t=[].slice.call(arguments,0);return Ge("isBefore",t)},o.max=function(){var t=[].slice.call(arguments,0);return Ge("isAfter",t)},o.now=function(){return Date.now?Date.now():+new Date},o.utc=p,o.unix=function(t){return Ie(1e3*t)},o.months=function(t,e){return mi(t,e,"months")},o.isDate=h,o.locale=se,o.invalid=g,o.duration=Ye,o.isMoment=w,o.weekdays=function(t,e,i){return fi(t,e,i,"weekdays")},o.parseZone=function(){return Ie.apply(null,arguments).parseZone()},o.localeData=ae,o.isDuration=Qe,o.monthsShort=function(t,e){return mi(t,e,"monthsShort")},o.weekdaysMin=function(t,e,i){return fi(t,e,i,"weekdaysMin")},o.defineLocale=re,o.updateLocale=function(t,e){if(null!=e){var i,n,o=te;null!=(n=oe(t))&&(o=n._config),(i=new N(e=Q(o,e))).parentLocale=ee[t],ee[t]=i,se(t)}else null!=ee[t]&&(null!=ee[t].parentLocale?ee[t]=ee[t].parentLocale:null!=ee[t]&&delete ee[t]);return ee[t]},o.locales=function(){return L(ee)},o.weekdaysShort=function(t,e,i){return fi(t,e,i,"weekdaysShort")},o.normalizeUnits=B,o.relativeTimeRounding=function(t){return void 0===t?Xi:"function"==typeof t&&(Xi=t,!0)},o.relativeTimeThreshold=function(t,e){return void 0!==Ti[t]&&(void 0===e?Ti[t]:(Ti[t]=e,"s"===t&&(Ti.ss=e-1),!0))},o.calendarFormat=function(t,e){var i=t.diff(e,"days",!0);return i<-6?"sameElse":i<-1?"lastWeek":i<0?"lastDay":i<1?"sameDay":i<2?"nextDay":i<7?"nextWeek":"sameElse"},o.prototype=di,o.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"GGGG-[W]WW",MONTH:"YYYY-MM"},o}()})),r=(n((function(t,e){(function(t){function e(t,e,i,n){var o={m:["eine Minute","einer Minute"],h:["eine Stunde","einer Stunde"],d:["ein Tag","einem Tag"],dd:[t+" Tage",t+" Tagen"],M:["ein Monat","einem Monat"],MM:[t+" Monate",t+" Monaten"],y:["ein Jahr","einem Jahr"],yy:[t+" Jahre",t+" Jahren"]};return e?o[i][0]:o[i][1]}t.defineLocale("de",{months:"Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember".split("_"),monthsShort:"Jan._Feb._März_Apr._Mai_Juni_Juli_Aug._Sep._Okt._Nov._Dez.".split("_"),monthsParseExact:!0,weekdays:"Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag".split("_"),weekdaysShort:"So._Mo._Di._Mi._Do._Fr._Sa.".split("_"),weekdaysMin:"So_Mo_Di_Mi_Do_Fr_Sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D. MMMM YYYY",LLL:"D. MMMM YYYY HH:mm",LLLL:"dddd, D. MMMM YYYY HH:mm"},calendar:{sameDay:"[heute um] LT [Uhr]",sameElse:"L",nextDay:"[morgen um] LT [Uhr]",nextWeek:"dddd [um] LT [Uhr]",lastDay:"[gestern um] LT [Uhr]",lastWeek:"[letzten] dddd [um] LT [Uhr]"},relativeTime:{future:"in %s",past:"vor %s",s:"ein paar Sekunden",ss:"%d Sekunden",m:e,mm:"%d Minuten",h:e,hh:"%d Stunden",d:e,dd:e,M:e,MM:e,y:e,yy:e},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})})(s)})),n((function(t,e){(function(t){var e="ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.".split("_"),i="ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic".split("_"),n=[/^ene/i,/^feb/i,/^mar/i,/^abr/i,/^may/i,/^jun/i,/^jul/i,/^ago/i,/^sep/i,/^oct/i,/^nov/i,/^dic/i],o=/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre|ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i;t.defineLocale("es",{months:"enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre".split("_"),monthsShort:function(t,n){return t?/-MMM-/.test(n)?i[t.month()]:e[t.month()]:e},monthsRegex:o,monthsShortRegex:o,monthsStrictRegex:/^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i,monthsShortStrictRegex:/^(ene\.?|feb\.?|mar\.?|abr\.?|may\.?|jun\.?|jul\.?|ago\.?|sep\.?|oct\.?|nov\.?|dic\.?)/i,monthsParse:n,longMonthsParse:n,shortMonthsParse:n,weekdays:"domingo_lunes_martes_miércoles_jueves_viernes_sábado".split("_"),weekdaysShort:"dom._lun._mar._mié._jue._vie._sáb.".split("_"),weekdaysMin:"do_lu_ma_mi_ju_vi_sá".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD/MM/YYYY",LL:"D [de] MMMM [de] YYYY",LLL:"D [de] MMMM [de] YYYY H:mm",LLLL:"dddd, D [de] MMMM [de] YYYY H:mm"},calendar:{sameDay:function(){return"[hoy a la"+(1!==this.hours()?"s":"")+"] LT"},nextDay:function(){return"[mañana a la"+(1!==this.hours()?"s":"")+"] LT"},nextWeek:function(){return"dddd [a la"+(1!==this.hours()?"s":"")+"] LT"},lastDay:function(){return"[ayer a la"+(1!==this.hours()?"s":"")+"] LT"},lastWeek:function(){return"[el] dddd [pasado a la"+(1!==this.hours()?"s":"")+"] LT"},sameElse:"L"},relativeTime:{future:"en %s",past:"hace %s",s:"unos segundos",ss:"%d segundos",m:"un minuto",mm:"%d minutos",h:"una hora",hh:"%d horas",d:"un día",dd:"%d días",M:"un mes",MM:"%d meses",y:"un año",yy:"%d años"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})})(s)})),n((function(t,e){(function(t){t.defineLocale("fr",{months:"janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre".split("_"),monthsShort:"janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.".split("_"),monthsParseExact:!0,weekdays:"dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi".split("_"),weekdaysShort:"dim._lun._mar._mer._jeu._ven._sam.".split("_"),weekdaysMin:"di_lu_ma_me_je_ve_sa".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Aujourd’hui à] LT",nextDay:"[Demain à] LT",nextWeek:"dddd [à] LT",lastDay:"[Hier à] LT",lastWeek:"dddd [dernier à] LT",sameElse:"L"},relativeTime:{future:"dans %s",past:"il y a %s",s:"quelques secondes",ss:"%d secondes",m:"une minute",mm:"%d minutes",h:"une heure",hh:"%d heures",d:"un jour",dd:"%d jours",M:"un mois",MM:"%d mois",y:"un an",yy:"%d ans"},dayOfMonthOrdinalParse:/\d{1,2}(er|)/,ordinal:function(t,e){switch(e){case"D":return t+(1===t?"er":"");default:case"M":case"Q":case"DDD":case"d":return t+(1===t?"er":"e");case"w":case"W":return t+(1===t?"re":"e")}},week:{dow:1,doy:4}})})(s)})),n((function(t,e){(function(t){t.defineLocale("it",{months:"gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre".split("_"),monthsShort:"gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic".split("_"),weekdays:"domenica_lunedì_martedì_mercoledì_giovedì_venerdì_sabato".split("_"),weekdaysShort:"dom_lun_mar_mer_gio_ven_sab".split("_"),weekdaysMin:"do_lu_ma_me_gi_ve_sa".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD/MM/YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[Oggi alle] LT",nextDay:"[Domani alle] LT",nextWeek:"dddd [alle] LT",lastDay:"[Ieri alle] LT",lastWeek:function(){switch(this.day()){case 0:return"[la scorsa] dddd [alle] LT";default:return"[lo scorso] dddd [alle] LT"}},sameElse:"L"},relativeTime:{future:function(t){return(/^[0-9].+$/.test(t)?"tra":"in")+" "+t},past:"%s fa",s:"alcuni secondi",ss:"%d secondi",m:"un minuto",mm:"%d minuti",h:"un'ora",hh:"%d ore",d:"un giorno",dd:"%d giorni",M:"un mese",MM:"%d mesi",y:"un anno",yy:"%d anni"},dayOfMonthOrdinalParse:/\d{1,2}º/,ordinal:"%dº",week:{dow:1,doy:4}})})(s)})),n((function(t,e){(function(t){t.defineLocale("ja",{months:"一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月".split("_"),monthsShort:"1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月".split("_"),weekdays:"日曜日_月曜日_火曜日_水曜日_木曜日_金曜日_土曜日".split("_"),weekdaysShort:"日_月_火_水_木_金_土".split("_"),weekdaysMin:"日_月_火_水_木_金_土".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"YYYY/MM/DD",LL:"YYYY年M月D日",LLL:"YYYY年M月D日 HH:mm",LLLL:"YYYY年M月D日 dddd HH:mm",l:"YYYY/MM/DD",ll:"YYYY年M月D日",lll:"YYYY年M月D日 HH:mm",llll:"YYYY年M月D日(ddd) HH:mm"},meridiemParse:/午前|午後/i,isPM:function(t){return"午後"===t},meridiem:function(t,e,i){return t<12?"午前":"午後"},calendar:{sameDay:"[今日] LT",nextDay:"[明日] LT",nextWeek:function(t){return t.week()<this.week()?"[来週]dddd LT":"dddd LT"},lastDay:"[昨日] LT",lastWeek:function(t){return this.week()<t.week()?"[先週]dddd LT":"dddd LT"},sameElse:"L"},dayOfMonthOrdinalParse:/\d{1,2}日/,ordinal:function(t,e){switch(e){case"d":case"D":case"DDD":return t+"日";default:return t}},relativeTime:{future:"%s後",past:"%s前",s:"数秒",ss:"%d秒",m:"1分",mm:"%d分",h:"1時間",hh:"%d時間",d:"1日",dd:"%d日",M:"1ヶ月",MM:"%dヶ月",y:"1年",yy:"%d年"}})})(s)})),n((function(t,e){(function(t){var e="jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.".split("_"),i="jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec".split("_"),n=[/^jan/i,/^feb/i,/^maart|mrt.?$/i,/^apr/i,/^mei$/i,/^jun[i.]?$/i,/^jul[i.]?$/i,/^aug/i,/^sep/i,/^okt/i,/^nov/i,/^dec/i],o=/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;t.defineLocale("nl",{months:"januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december".split("_"),monthsShort:function(t,n){return t?/-MMM-/.test(n)?i[t.month()]:e[t.month()]:e},monthsRegex:o,monthsShortRegex:o,monthsStrictRegex:/^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december)/i,monthsShortStrictRegex:/^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,monthsParse:n,longMonthsParse:n,shortMonthsParse:n,weekdays:"zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag".split("_"),weekdaysShort:"zo._ma._di._wo._do._vr._za.".split("_"),weekdaysMin:"zo_ma_di_wo_do_vr_za".split("_"),weekdaysParseExact:!0,longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD-MM-YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd D MMMM YYYY HH:mm"},calendar:{sameDay:"[vandaag om] LT",nextDay:"[morgen om] LT",nextWeek:"dddd [om] LT",lastDay:"[gisteren om] LT",lastWeek:"[afgelopen] dddd [om] LT",sameElse:"L"},relativeTime:{future:"over %s",past:"%s geleden",s:"een paar seconden",ss:"%d seconden",m:"één minuut",mm:"%d minuten",h:"één uur",hh:"%d uur",d:"één dag",dd:"%d dagen",M:"één maand",MM:"%d maanden",y:"één jaar",yy:"%d jaar"},dayOfMonthOrdinalParse:/\d{1,2}(ste|de)/,ordinal:function(t){return t+(1===t||8===t||t>=20?"ste":"de")},week:{dow:1,doy:4}})})(s)})),n((function(t,e){(function(t){var e="styczeń_luty_marzec_kwiecień_maj_czerwiec_lipiec_sierpień_wrzesień_październik_listopad_grudzień".split("_"),i="stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_września_października_listopada_grudnia".split("_");function n(t){return t%10<5&&t%10>1&&~~(t/10)%10!=1}function o(t,e,i){var o=t+" ";switch(i){case"ss":return o+(n(t)?"sekundy":"sekund");case"m":return e?"minuta":"minutę";case"mm":return o+(n(t)?"minuty":"minut");case"h":return e?"godzina":"godzinę";case"hh":return o+(n(t)?"godziny":"godzin");case"MM":return o+(n(t)?"miesiące":"miesięcy");case"yy":return o+(n(t)?"lata":"lat")}}t.defineLocale("pl",{months:function(t,n){return t?""===n?"("+i[t.month()]+"|"+e[t.month()]+")":/D MMMM/.test(n)?i[t.month()]:e[t.month()]:e},monthsShort:"sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paź_lis_gru".split("_"),weekdays:"niedziela_poniedziałek_wtorek_środa_czwartek_piątek_sobota".split("_"),weekdaysShort:"ndz_pon_wt_śr_czw_pt_sob".split("_"),weekdaysMin:"Nd_Pn_Wt_Śr_Cz_Pt_So".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY",LLL:"D MMMM YYYY HH:mm",LLLL:"dddd, D MMMM YYYY HH:mm"},calendar:{sameDay:"[Dziś o] LT",nextDay:"[Jutro o] LT",nextWeek:function(){switch(this.day()){case 0:return"[W niedzielę o] LT";case 2:return"[We wtorek o] LT";case 3:return"[W środę o] LT";case 6:return"[W sobotę o] LT";default:return"[W] dddd [o] LT"}},lastDay:"[Wczoraj o] LT",lastWeek:function(){switch(this.day()){case 0:return"[W zeszłą niedzielę o] LT";case 3:return"[W zeszłą środę o] LT";case 6:return"[W zeszłą sobotę o] LT";default:return"[W zeszły] dddd [o] LT"}},sameElse:"L"},relativeTime:{future:"za %s",past:"%s temu",s:"kilka sekund",ss:o,m:o,mm:o,h:o,hh:o,d:"1 dzień",dd:"%d dni",M:"miesiąc",MM:o,y:"rok",yy:o},dayOfMonthOrdinalParse:/\d{1,2}\./,ordinal:"%d.",week:{dow:1,doy:4}})})(s)})),n((function(t,e){(function(t){function e(t,e,i){var n,o;return"m"===i?e?"минута":"минуту":t+" "+(n=+t,o={ss:e?"секунда_секунды_секунд":"секунду_секунды_секунд",mm:e?"минута_минуты_минут":"минуту_минуты_минут",hh:"час_часа_часов",dd:"день_дня_дней",MM:"месяц_месяца_месяцев",yy:"год_года_лет"}[i].split("_"),n%10==1&&n%100!=11?o[0]:n%10>=2&&n%10<=4&&(n%100<10||n%100>=20)?o[1]:o[2])}var i=[/^янв/i,/^фев/i,/^мар/i,/^апр/i,/^ма[йя]/i,/^июн/i,/^июл/i,/^авг/i,/^сен/i,/^окт/i,/^ноя/i,/^дек/i];t.defineLocale("ru",{months:{format:"января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря".split("_"),standalone:"январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь".split("_")},monthsShort:{format:"янв._февр._мар._апр._мая_июня_июля_авг._сент._окт._нояб._дек.".split("_"),standalone:"янв._февр._март_апр._май_июнь_июль_авг._сент._окт._нояб._дек.".split("_")},weekdays:{standalone:"воскресенье_понедельник_вторник_среда_четверг_пятница_суббота".split("_"),format:"воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу".split("_"),isFormat:/\[ ?[Вв] ?(?:прошлую|следующую|эту)? ?\] ?dddd/},weekdaysShort:"вс_пн_вт_ср_чт_пт_сб".split("_"),weekdaysMin:"вс_пн_вт_ср_чт_пт_сб".split("_"),monthsParse:i,longMonthsParse:i,shortMonthsParse:i,monthsRegex:/^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,monthsShortRegex:/^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,monthsStrictRegex:/^(январ[яь]|феврал[яь]|марта?|апрел[яь]|ма[яй]|июн[яь]|июл[яь]|августа?|сентябр[яь]|октябр[яь]|ноябр[яь]|декабр[яь])/i,monthsShortStrictRegex:/^(янв\.|февр?\.|мар[т.]|апр\.|ма[яй]|июн[ья.]|июл[ья.]|авг\.|сент?\.|окт\.|нояб?\.|дек\.)/i,longDateFormat:{LT:"H:mm",LTS:"H:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY г.",LLL:"D MMMM YYYY г., H:mm",LLLL:"dddd, D MMMM YYYY г., H:mm"},calendar:{sameDay:"[Сегодня, в] LT",nextDay:"[Завтра, в] LT",lastDay:"[Вчера, в] LT",nextWeek:function(t){if(t.week()===this.week())return 2===this.day()?"[Во] dddd, [в] LT":"[В] dddd, [в] LT";switch(this.day()){case 0:return"[В следующее] dddd, [в] LT";case 1:case 2:case 4:return"[В следующий] dddd, [в] LT";case 3:case 5:case 6:return"[В следующую] dddd, [в] LT"}},lastWeek:function(t){if(t.week()===this.week())return 2===this.day()?"[Во] dddd, [в] LT":"[В] dddd, [в] LT";switch(this.day()){case 0:return"[В прошлое] dddd, [в] LT";case 1:case 2:case 4:return"[В прошлый] dddd, [в] LT";case 3:case 5:case 6:return"[В прошлую] dddd, [в] LT"}},sameElse:"L"},relativeTime:{future:"через %s",past:"%s назад",s:"несколько секунд",ss:e,m:e,mm:e,h:"час",hh:e,d:"день",dd:e,M:"месяц",MM:e,y:"год",yy:e},meridiemParse:/ночи|утра|дня|вечера/i,isPM:function(t){return/^(дня|вечера)$/.test(t)},meridiem:function(t,e,i){return t<4?"ночи":t<12?"утра":t<17?"дня":"вечера"},dayOfMonthOrdinalParse:/\d{1,2}-(й|го|я)/,ordinal:function(t,e){switch(e){case"M":case"d":case"DDD":return t+"-й";case"D":return t+"-го";case"w":case"W":return t+"-я";default:return t}},week:{dow:1,doy:4}})})(s)})),n((function(t,e){(function(t){function e(t,e,i){var n,o;return"m"===i?e?"хвилина":"хвилину":"h"===i?e?"година":"годину":t+" "+(n=+t,o={ss:e?"секунда_секунди_секунд":"секунду_секунди_секунд",mm:e?"хвилина_хвилини_хвилин":"хвилину_хвилини_хвилин",hh:e?"година_години_годин":"годину_години_годин",dd:"день_дні_днів",MM:"місяць_місяці_місяців",yy:"рік_роки_років"}[i].split("_"),n%10==1&&n%100!=11?o[0]:n%10>=2&&n%10<=4&&(n%100<10||n%100>=20)?o[1]:o[2])}function i(t){return function(){return t+"о"+(11===this.hours()?"б":"")+"] LT"}}t.defineLocale("uk",{months:{format:"січня_лютого_березня_квітня_травня_червня_липня_серпня_вересня_жовтня_листопада_грудня".split("_"),standalone:"січень_лютий_березень_квітень_травень_червень_липень_серпень_вересень_жовтень_листопад_грудень".split("_")},monthsShort:"січ_лют_бер_квіт_трав_черв_лип_серп_вер_жовт_лист_груд".split("_"),weekdays:function(t,e){var i={nominative:"неділя_понеділок_вівторок_середа_четвер_п’ятниця_субота".split("_"),accusative:"неділю_понеділок_вівторок_середу_четвер_п’ятницю_суботу".split("_"),genitive:"неділі_понеділка_вівторка_середи_четверга_п’ятниці_суботи".split("_")};return!0===t?i.nominative.slice(1,7).concat(i.nominative.slice(0,1)):t?i[/(\[[ВвУу]\]) ?dddd/.test(e)?"accusative":/\[?(?:минулої|наступної)? ?\] ?dddd/.test(e)?"genitive":"nominative"][t.day()]:i.nominative},weekdaysShort:"нд_пн_вт_ср_чт_пт_сб".split("_"),weekdaysMin:"нд_пн_вт_ср_чт_пт_сб".split("_"),longDateFormat:{LT:"HH:mm",LTS:"HH:mm:ss",L:"DD.MM.YYYY",LL:"D MMMM YYYY р.",LLL:"D MMMM YYYY р., HH:mm",LLLL:"dddd, D MMMM YYYY р., HH:mm"},calendar:{sameDay:i("[Сьогодні "),nextDay:i("[Завтра "),lastDay:i("[Вчора "),nextWeek:i("[У] dddd ["),lastWeek:function(){switch(this.day()){case 0:case 3:case 5:case 6:return i("[Минулої] dddd [").call(this);case 1:case 2:case 4:return i("[Минулого] dddd [").call(this)}},sameElse:"L"},relativeTime:{future:"за %s",past:"%s тому",s:"декілька секунд",ss:e,m:e,mm:e,h:"годину",hh:e,d:"день",dd:e,M:"місяць",MM:e,y:"рік",yy:e},meridiemParse:/ночі|ранку|дня|вечора/,isPM:function(t){return/^(дня|вечора)$/.test(t)},meridiem:function(t,e,i){return t<4?"ночі":t<12?"ранку":t<17?"дня":"вечора"},dayOfMonthOrdinalParse:/\d{1,2}-(й|го)/,ordinal:function(t,e){switch(e){case"M":case"d":case"DDD":case"w":case"W":return t+"-й";case"D":return t+"-го";default:return t}},week:{dow:1,doy:7}})})(s)})),function(t){return t&&t.Math==Math&&t}),a=r("object"==typeof globalThis&&globalThis)||r("object"==typeof window&&window)||r("object"==typeof self&&self)||r("object"==typeof e&&e)||Function("return this")(),l=function(t){try{return!!t()}catch(t){return!0}},h=!l((function(){return 7!=Object.defineProperty({},1,{get:function(){return 7}})[1]})),d={}.propertyIsEnumerable,u=Object.getOwnPropertyDescriptor,c={f:u&&!d.call({1:2},1)?function(t){var e=u(this,t);return!!e&&e.enumerable}:d},p=function(t,e){return{enumerable:!(1&t),configurable:!(2&t),writable:!(4&t),value:e}},m={}.toString,f=function(t){return m.call(t).slice(8,-1)},g="".split,v=l((function(){return!Object("z").propertyIsEnumerable(0)}))?function(t){return"String"==f(t)?g.call(t,""):Object(t)}:Object,b=function(t){if(null==t)throw TypeError("Can't call method on "+t);return t},y=function(t){return v(b(t))},x=function(t){return"object"==typeof t?null!==t:"function"==typeof t},w=function(t,e){if(!x(t))return t;var i,n;if(e&&"function"==typeof(i=t.toString)&&!x(n=i.call(t)))return n;if("function"==typeof(i=t.valueOf)&&!x(n=i.call(t)))return n;if(!e&&"function"==typeof(i=t.toString)&&!x(n=i.call(t)))return n;throw TypeError("Can't convert object to primitive value")},_={}.hasOwnProperty,k=function(t,e){return _.call(t,e)},D=a.document,I=x(D)&&x(D.createElement),C=function(t){return I?D.createElement(t):{}},L=!h&&!l((function(){return 7!=Object.defineProperty(C("div"),"a",{get:function(){return 7}}).a})),G=Object.getOwnPropertyDescriptor,M={f:h?G:function(t,e){if(t=y(t),e=w(e,!0),L)try{return G(t,e)}catch(t){}if(k(t,e))return p(!c.f.call(t,e),t[e])}},S=/#|\.prototype\./,Q=function(t,e){var i=F[N(t)];return i==B||i!=Z&&("function"==typeof e?l(e):!!e)},N=Q.normalize=function(t){return String(t).replace(S,".").toLowerCase()},F=Q.data={},Z=Q.NATIVE="N",B=Q.POLYFILL="P",O=Q,W={},A=function(t){if("function"!=typeof t)throw TypeError(String(t)+" is not a function");return t},X=function(t,e,i){if(A(t),void 0===e)return t;switch(i){case 0:return function(){return t.call(e)};case 1:return function(i){return t.call(e,i)};case 2:return function(i,n){return t.call(e,i,n)};case 3:return function(i,n,o){return t.call(e,i,n,o)}}return function(){return t.apply(e,arguments)}},T=function(t){if(!x(t))throw TypeError(String(t)+" is not an object");return t},Y=Object.defineProperty,E={f:h?Y:function(t,e,i){if(T(t),e=w(e,!0),T(i),L)try{return Y(t,e,i)}catch(t){}if("get"in i||"set"in i)throw TypeError("Accessors not supported");return"value"in i&&(t[e]=i.value),t}},R=h?function(t,e,i){return E.f(t,e,p(1,i))}:function(t,e,i){return t[e]=i,t},U=M.f,z=function(t){var e=function(e,i,n){if(this instanceof t){switch(arguments.length){case 0:return new t;case 1:return new t(e);case 2:return new t(e,i)}return new t(e,i,n)}return t.apply(this,arguments)};return e.prototype=t.prototype,e},V=function(t,e){var i,n,o,s,r,l,h,d,u=t.target,c=t.global,p=t.stat,m=t.proto,f=c?a:p?a[u]:(a[u]||{}).prototype,g=c?W:W[u]||(W[u]={}),v=g.prototype;for(o in e)i=!O(c?o:u+(p?".":"#")+o,t.forced)&&f&&k(f,o),r=g[o],i&&(l=t.noTargetGet?(d=U(f,o))&&d.value:f[o]),s=i&&l?l:e[o],i&&typeof r==typeof s||(h=t.bind&&i?X(s,a):t.wrap&&i?z(s):m&&"function"==typeof s?X(Function.call,s):s,(t.sham||s&&s.sham||r&&r.sham)&&R(h,"sham",!0),g[o]=h,m&&(k(W,n=u+"Prototype")||R(W,n,{}),W[n][o]=s,t.real&&v&&!v[o]&&R(v,o,s)))};V({target:"Object",stat:!0,forced:!h,sham:!h},{defineProperty:E.f});var j=n((function(t){var e=W.Object,i=t.exports=function(t,i,n){return e.defineProperty(t,i,n)};e.defineProperty.sham&&(i.sham=!0)})),H=j,P=Math.ceil,J=Math.floor,K=function(t){return isNaN(t=+t)?0:(t>0?J:P)(t)},q=Math.min,$=function(t){return t>0?q(K(t),9007199254740991):0},tt=Math.max,et=Math.min,it=function(t,e){var i=K(t);return i<0?tt(i+e,0):et(i,e)},nt=function(t){return function(e,i,n){var o,s=y(e),r=$(s.length),a=it(n,r);if(t&&i!=i){for(;r>a;)if((o=s[a++])!=o)return!0}else for(;r>a;a++)if((t||a in s)&&s[a]===i)return t||a||0;return!t&&-1}},ot={includes:nt(!0),indexOf:nt(!1)},st={},rt=ot.indexOf,at=function(t,e){var i,n=y(t),o=0,s=[];for(i in n)!k(st,i)&&k(n,i)&&s.push(i);for(;e.length>o;)k(n,i=e[o++])&&(~rt(s,i)||s.push(i));return s},lt=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"],ht=Object.keys||function(t){return at(t,lt)},dt=h?Object.defineProperties:function(t,e){T(t);for(var i,n=ht(e),o=n.length,s=0;o>s;)E.f(t,i=n[s++],e[i]);return t};V({target:"Object",stat:!0,forced:!h,sham:!h},{defineProperties:dt});var ut=n((function(t){var e=W.Object,i=t.exports=function(t,i){return e.defineProperties(t,i)};e.defineProperties.sham&&(i.sham=!0)})),ct=function(t){return"function"==typeof t?t:void 0},pt=function(t,e){return arguments.length<2?ct(W[t])||ct(a[t]):W[t]&&W[t][e]||a[t]&&a[t][e]},mt=lt.concat("length","prototype"),ft={f:Object.getOwnPropertyNames||function(t){return at(t,mt)}},gt={f:Object.getOwnPropertySymbols},vt=pt("Reflect","ownKeys")||function(t){var e=ft.f(T(t)),i=gt.f;return i?e.concat(i(t)):e},bt=function(t,e,i){var n=w(e);n in t?E.f(t,n,p(0,i)):t[n]=i};V({target:"Object",stat:!0,sham:!h},{getOwnPropertyDescriptors:function(t){for(var e,i,n=y(t),o=M.f,s=vt(n),r={},a=0;s.length>a;)void 0!==(i=o(n,e=s[a++]))&&bt(r,e,i);return r}});var yt=W.Object.getOwnPropertyDescriptors,xt=M.f,wt=l((function(){xt(1)}));V({target:"Object",stat:!0,forced:!h||wt,sham:!h},{getOwnPropertyDescriptor:function(t,e){return xt(y(t),e)}});var _t,kt=n((function(t){var e=W.Object,i=t.exports=function(t,i){return e.getOwnPropertyDescriptor(t,i)};e.getOwnPropertyDescriptor.sham&&(i.sham=!0)})),Dt=!!Object.getOwnPropertySymbols&&!l((function(){return!String(Symbol())})),It=Dt&&!Symbol.sham&&"symbol"==typeof Symbol.iterator,Ct=Array.isArray||function(t){return"Array"==f(t)},Lt=function(t){return Object(b(t))},Gt=pt("document","documentElement"),Mt=a["__core-js_shared__"]||function(t,e){try{R(a,t,e)}catch(i){a[t]=e}return e}("__core-js_shared__",{}),St=n((function(t){(t.exports=function(t,e){return Mt[t]||(Mt[t]=void 0!==e?e:{})})("versions",[]).push({version:"3.6.4",mode:"pure",copyright:"© 2020 Denis Pushkarev (zloirock.ru)"})})),Qt=0,Nt=Math.random(),Ft=function(t){return"Symbol("+String(void 0===t?"":t)+")_"+(++Qt+Nt).toString(36)},Zt=St("keys"),Bt=function(t){return Zt[t]||(Zt[t]=Ft(t))},Ot=Bt("IE_PROTO"),Wt=function(){},At=function(t){return"<script>"+t+"<\/script>"},Xt=function(){try{_t=document.domain&&new ActiveXObject("htmlfile")}catch(t){}var t,e;Xt=_t?function(t){t.write(At("")),t.close();var e=t.parentWindow.Object;return t=null,e}(_t):((e=C("iframe")).style.display="none",Gt.appendChild(e),e.src=String("javascript:"),(t=e.contentWindow.document).open(),t.write(At("document.F=Object")),t.close(),t.F);for(var i=lt.length;i--;)delete Xt.prototype[lt[i]];return Xt()};st[Ot]=!0;var Tt=Object.create||function(t,e){var i;return null!==t?(Wt.prototype=T(t),i=new Wt,Wt.prototype=null,i[Ot]=t):i=Xt(),void 0===e?i:dt(i,e)},Yt=ft.f,Et={}.toString,Rt="object"==typeof window&&window&&Object.getOwnPropertyNames?Object.getOwnPropertyNames(window):[],Ut={f:function(t){return Rt&&"[object Window]"==Et.call(t)?function(t){try{return Yt(t)}catch(t){return Rt.slice()}}(t):Yt(y(t))}},zt=function(t,e,i,n){n&&n.enumerable?t[e]=i:R(t,e,i)},Vt=St("wks"),jt=a.Symbol,Ht=It?jt:jt&&jt.withoutSetter||Ft,Pt=function(t){return k(Vt,t)||(Dt&&k(jt,t)?Vt[t]=jt[t]:Vt[t]=Ht("Symbol."+t)),Vt[t]},Jt={f:Pt},Kt=E.f,qt=function(t){var e=W.Symbol||(W.Symbol={});k(e,t)||Kt(e,t,{value:Jt.f(t)})},$t={};$t[Pt("toStringTag")]="z";var te="[object z]"===String($t),ee=Pt("toStringTag"),ie="Arguments"==f(function(){return arguments}()),ne=te?f:function(t){var e,i,n;return void 0===t?"Undefined":null===t?"Null":"string"==typeof(i=function(t,e){try{return t[e]}catch(t){}}(e=Object(t),ee))?i:ie?f(e):"Object"==(n=f(e))&&"function"==typeof e.callee?"Arguments":n},oe=te?{}.toString:function(){return"[object "+ne(this)+"]"},se=E.f,re=Pt("toStringTag"),ae=function(t,e,i,n){if(t){var o=i?t:t.prototype;k(o,re)||se(o,re,{configurable:!0,value:e}),n&&!te&&R(o,"toString",oe)}},le=Function.toString;"function"!=typeof Mt.inspectSource&&(Mt.inspectSource=function(t){return le.call(t)});var he,de,ue,ce=Mt.inspectSource,pe=a.WeakMap,me="function"==typeof pe&&/native code/.test(ce(pe)),fe=a.WeakMap;if(me){var ge=new fe,ve=ge.get,be=ge.has,ye=ge.set;he=function(t,e){return ye.call(ge,t,e),e},de=function(t){return ve.call(ge,t)||{}},ue=function(t){return be.call(ge,t)}}else{var xe=Bt("state");st[xe]=!0,he=function(t,e){return R(t,xe,e),e},de=function(t){return k(t,xe)?t[xe]:{}},ue=function(t){return k(t,xe)}}var we={set:he,get:de,has:ue,enforce:function(t){return ue(t)?de(t):he(t,{})},getterFor:function(t){return function(e){var i;if(!x(e)||(i=de(e)).type!==t)throw TypeError("Incompatible receiver, "+t+" required");return i}}},_e=Pt("species"),ke=function(t,e){var i;return Ct(t)&&("function"!=typeof(i=t.constructor)||i!==Array&&!Ct(i.prototype)?x(i)&&null===(i=i[_e])&&(i=void 0):i=void 0),new(void 0===i?Array:i)(0===e?0:e)},De=[].push,Ie=function(t){var e=1==t,i=2==t,n=3==t,o=4==t,s=6==t,r=5==t||s;return function(a,l,h,d){for(var u,c,p=Lt(a),m=v(p),f=X(l,h,3),g=$(m.length),b=0,y=d||ke,x=e?y(a,g):i?y(a,0):void 0;g>b;b++)if((r||b in m)&&(c=f(u=m[b],b,p),t))if(e)x[b]=c;else if(c)switch(t){case 3:return!0;case 5:return u;case 6:return b;case 2:De.call(x,u)}else if(o)return!1;return s?-1:n||o?o:x}},Ce={forEach:Ie(0),map:Ie(1),filter:Ie(2),some:Ie(3),every:Ie(4),find:Ie(5),findIndex:Ie(6)},Le=Ce.forEach,Ge=Bt("hidden"),Me=Pt("toPrimitive"),Se=we.set,Qe=we.getterFor("Symbol"),Ne=Object.prototype,Fe=a.Symbol,Ze=pt("JSON","stringify"),Be=M.f,Oe=E.f,We=Ut.f,Ae=c.f,Xe=St("symbols"),Te=St("op-symbols"),Ye=St("string-to-symbol-registry"),Ee=St("symbol-to-string-registry"),Re=St("wks"),Ue=a.QObject,ze=!Ue||!Ue.prototype||!Ue.prototype.findChild,Ve=h&&l((function(){return 7!=Tt(Oe({},"a",{get:function(){return Oe(this,"a",{value:7}).a}})).a}))?function(t,e,i){var n=Be(Ne,e);n&&delete Ne[e],Oe(t,e,i),n&&t!==Ne&&Oe(Ne,e,n)}:Oe,je=function(t,e){var i=Xe[t]=Tt(Fe.prototype);return Se(i,{type:"Symbol",tag:t,description:e}),h||(i.description=e),i},He=It?function(t){return"symbol"==typeof t}:function(t){return Object(t)instanceof Fe},Pe=function(t,e,i){t===Ne&&Pe(Te,e,i),T(t);var n=w(e,!0);return T(i),k(Xe,n)?(i.enumerable?(k(t,Ge)&&t[Ge][n]&&(t[Ge][n]=!1),i=Tt(i,{enumerable:p(0,!1)})):(k(t,Ge)||Oe(t,Ge,p(1,{})),t[Ge][n]=!0),Ve(t,n,i)):Oe(t,n,i)},Je=function(t,e){T(t);var i=y(e),n=ht(i).concat(ti(i));return Le(n,(function(e){h&&!Ke.call(i,e)||Pe(t,e,i[e])})),t},Ke=function(t){var e=w(t,!0),i=Ae.call(this,e);return!(this===Ne&&k(Xe,e)&&!k(Te,e))&&(!(i||!k(this,e)||!k(Xe,e)||k(this,Ge)&&this[Ge][e])||i)},qe=function(t,e){var i=y(t),n=w(e,!0);if(i!==Ne||!k(Xe,n)||k(Te,n)){var o=Be(i,n);return!o||!k(Xe,n)||k(i,Ge)&&i[Ge][n]||(o.enumerable=!0),o}},$e=function(t){var e=We(y(t)),i=[];return Le(e,(function(t){k(Xe,t)||k(st,t)||i.push(t)})),i},ti=function(t){var e=t===Ne,i=We(e?Te:y(t)),n=[];return Le(i,(function(t){!k(Xe,t)||e&&!k(Ne,t)||n.push(Xe[t])})),n};if(Dt||(zt((Fe=function(){if(this instanceof Fe)throw TypeError("Symbol is not a constructor");var t=arguments.length&&void 0!==arguments[0]?String(arguments[0]):void 0,e=Ft(t),i=function(t){this===Ne&&i.call(Te,t),k(this,Ge)&&k(this[Ge],e)&&(this[Ge][e]=!1),Ve(this,e,p(1,t))};return h&&ze&&Ve(Ne,e,{configurable:!0,set:i}),je(e,t)}).prototype,"toString",(function(){return Qe(this).tag})),zt(Fe,"withoutSetter",(function(t){return je(Ft(t),t)})),c.f=Ke,E.f=Pe,M.f=qe,ft.f=Ut.f=$e,gt.f=ti,Jt.f=function(t){return je(Pt(t),t)},h&&Oe(Fe.prototype,"description",{configurable:!0,get:function(){return Qe(this).description}})),V({global:!0,wrap:!0,forced:!Dt,sham:!Dt},{Symbol:Fe}),Le(ht(Re),(function(t){qt(t)})),V({target:"Symbol",stat:!0,forced:!Dt},{for:function(t){var e=String(t);if(k(Ye,e))return Ye[e];var i=Fe(e);return Ye[e]=i,Ee[i]=e,i},keyFor:function(t){if(!He(t))throw TypeError(t+" is not a symbol");if(k(Ee,t))return Ee[t]},useSetter:function(){ze=!0},useSimple:function(){ze=!1}}),V({target:"Object",stat:!0,forced:!Dt,sham:!h},{create:function(t,e){return void 0===e?Tt(t):Je(Tt(t),e)},defineProperty:Pe,defineProperties:Je,getOwnPropertyDescriptor:qe}),V({target:"Object",stat:!0,forced:!Dt},{getOwnPropertyNames:$e,getOwnPropertySymbols:ti}),V({target:"Object",stat:!0,forced:l((function(){gt.f(1)}))},{getOwnPropertySymbols:function(t){return gt.f(Lt(t))}}),Ze){var ei=!Dt||l((function(){var t=Fe();return"[null]"!=Ze([t])||"{}"!=Ze({a:t})||"{}"!=Ze(Object(t))}));V({target:"JSON",stat:!0,forced:ei},{stringify:function(t,e,i){for(var n,o=[t],s=1;arguments.length>s;)o.push(arguments[s++]);if(n=e,(x(e)||void 0!==t)&&!He(t))return Ct(e)||(e=function(t,e){if("function"==typeof n&&(e=n.call(this,t,e)),!He(e))return e}),o[1]=e,Ze.apply(null,o)}})}Fe.prototype[Me]||R(Fe.prototype,Me,Fe.prototype.valueOf),ae(Fe,"Symbol"),st[Ge]=!0;var ii,ni,oi,si=W.Object.getOwnPropertySymbols,ri={},ai=!l((function(){function t(){}return t.prototype.constructor=null,Object.getPrototypeOf(new t)!==t.prototype})),li=Bt("IE_PROTO"),hi=Object.prototype,di=ai?Object.getPrototypeOf:function(t){return t=Lt(t),k(t,li)?t[li]:"function"==typeof t.constructor&&t instanceof t.constructor?t.constructor.prototype:t instanceof Object?hi:null},ui=(Pt("iterator"),!1);[].keys&&("next"in(oi=[].keys())?(ni=di(di(oi)))!==Object.prototype&&(ii=ni):ui=!0),null==ii&&(ii={});var ci={IteratorPrototype:ii,BUGGY_SAFARI_ITERATORS:ui},pi=ci.IteratorPrototype,mi=function(){return this},fi=Object.setPrototypeOf||("__proto__"in{}?function(){var t,e=!1,i={};try{(t=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__").set).call(i,[]),e=i instanceof Array}catch(t){}return function(i,n){return T(i),function(t){if(!x(t)&&null!==t)throw TypeError("Can't set "+String(t)+" as a prototype")}(n),e?t.call(i,n):i.__proto__=n,i}}():void 0),gi=ci.IteratorPrototype,vi=ci.BUGGY_SAFARI_ITERATORS,bi=Pt("iterator"),yi=function(){return this},xi=function(t,e,i,n,o,s,r){!function(t,e,i){var n=e+" Iterator";t.prototype=Tt(pi,{next:p(1,i)}),ae(t,n,!1,!0),ri[n]=mi}(i,e,n);var a,l,h,d=function(t){if(t===o&&g)return g;if(!vi&&t in m)return m[t];switch(t){case"keys":case"values":case"entries":return function(){return new i(this,t)}}return function(){return new i(this)}},u=e+" Iterator",c=!1,m=t.prototype,f=m[bi]||m["@@iterator"]||o&&m[o],g=!vi&&f||d(o),v="Array"==e&&m.entries||f;if(v&&(a=di(v.call(new t)),gi!==Object.prototype&&a.next&&(ae(a,u,!0,!0),ri[u]=yi)),"values"==o&&f&&"values"!==f.name&&(c=!0,g=function(){return f.call(this)}),r&&m[bi]!==g&&R(m,bi,g),ri[e]=g,o)if(l={values:d("values"),keys:s?g:d("keys"),entries:d("entries")},r)for(h in l)!vi&&!c&&h in m||zt(m,h,l[h]);else V({target:e,proto:!0,forced:vi||c},l);return l},wi=we.set,_i=we.getterFor("Array Iterator");xi(Array,"Array",(function(t,e){wi(this,{type:"Array Iterator",target:y(t),index:0,kind:e})}),(function(){var t=_i(this),e=t.target,i=t.kind,n=t.index++;return!e||n>=e.length?(t.target=void 0,{value:void 0,done:!0}):"keys"==i?{value:n,done:!1}:"values"==i?{value:e[n],done:!1}:{value:[n,e[n]],done:!1}}),"values");ri.Arguments=ri.Array;var ki=Pt("toStringTag");for(var Di in{CSSRuleList:0,CSSStyleDeclaration:0,CSSValueList:0,ClientRectList:0,DOMRectList:0,DOMStringList:0,DOMTokenList:1,DataTransferItemList:0,FileList:0,HTMLAllCollection:0,HTMLCollection:0,HTMLFormElement:0,HTMLSelectElement:0,MediaList:0,MimeTypeArray:0,NamedNodeMap:0,NodeList:1,PaintRequestList:0,Plugin:0,PluginArray:0,SVGLengthList:0,SVGNumberList:0,SVGPathSegList:0,SVGPointList:0,SVGStringList:0,SVGTransformList:0,SourceBufferList:0,StyleSheetList:0,TextTrackCueList:0,TextTrackList:0,TouchList:0}){var Ii=a[Di],Ci=Ii&&Ii.prototype;Ci&&ne(Ci)!==ki&&R(Ci,ki,Di),ri[Di]=ri.Array}var Li=function(t){return function(e,i){var n,o,s=String(b(e)),r=K(i),a=s.length;return r<0||r>=a?t?"":void 0:(n=s.charCodeAt(r))<55296||n>56319||r+1===a||(o=s.charCodeAt(r+1))<56320||o>57343?t?s.charAt(r):n:t?s.slice(r,r+2):o-56320+(n-55296<<10)+65536}},Gi={codeAt:Li(!1),charAt:Li(!0)}.charAt,Mi=we.set,Si=we.getterFor("String Iterator");xi(String,"String",(function(t){Mi(this,{type:"String Iterator",string:String(t),index:0})}),(function(){var t,e=Si(this),i=e.string,n=e.index;return n>=i.length?{value:void 0,done:!0}:(t=Gi(i,n),e.index+=t.length,{value:t,done:!1})}));var Qi=Pt("iterator"),Ni=function(t){if(null!=t)return t[Qi]||t["@@iterator"]||ri[ne(t)]},Fi=function(t){var e=Ni(t);if("function"!=typeof e)throw TypeError(String(t)+" is not iterable");return T(e.call(t))};V({target:"Object",stat:!0,sham:!h},{create:Tt});var Zi=W.Object,Bi=function(t,e){return Zi.create(t,e)},Oi=Bi,Wi=j;var Ai=function(t,e,i){return e in t?Wi(t,e,{value:i,enumerable:!0,configurable:!0,writable:!0}):t[e]=i,t},Xi=l((function(){ht(1)}));V({target:"Object",stat:!0,forced:Xi},{keys:function(t){return ht(Lt(t))}});var Ti,Yi=W.Object.keys,Ei="\t\n\v\f\r                　\u2028\u2029\ufeff",Ri="["+Ei+"]",Ui=RegExp("^"+Ri+Ri+"*"),zi=RegExp(Ri+Ri+"*$"),Vi=function(t){return function(e){var i=String(b(e));return 1&t&&(i=i.replace(Ui,"")),2&t&&(i=i.replace(zi,"")),i}},ji={start:Vi(1),end:Vi(2),trim:Vi(3)},Hi=ji.trim;V({target:"String",proto:!0,forced:(Ti="trim",l((function(){return!!Ei[Ti]()||"​᠎"!="​᠎"[Ti]()||Ei[Ti].name!==Ti})))},{trim:function(){return Hi(this)}});var Pi=function(t){return W[t+"Prototype"]},Ji=Pi("String").trim,Ki=String.prototype,qi=function(t){var e=t.trim;return"string"==typeof t||t===Ki||t instanceof String&&e===Ki.trim?Ji:e},$i=function(t,e){var i=[][t];return!!i&&l((function(){i.call(null,e||function(){throw 1},1)}))},tn=Object.defineProperty,en={},nn=function(t){throw t},on=function(t,e){if(k(en,t))return en[t];e||(e={});var i=[][t],n=!!k(e,"ACCESSORS")&&e.ACCESSORS,o=k(e,0)?e[0]:nn,s=k(e,1)?e[1]:void 0;return en[t]=!!i&&!l((function(){if(n&&!h)return!0;var t={length:-1};n?tn(t,1,{enumerable:!0,get:nn}):t[1]=1,i.call(t,o,s)}))},sn=Ce.forEach,rn=$i("forEach"),an=on("forEach"),ln=rn&&an?[].forEach:function(t){return sn(this,t,arguments.length>1?arguments[1]:void 0)};V({target:"Array",proto:!0,forced:[].forEach!=ln},{forEach:ln});var hn,dn,un=Pi("Array").forEach,cn=Array.prototype,pn={DOMTokenList:!0,NodeList:!0},mn=function(t){var e=t.forEach;return t===cn||t instanceof Array&&e===cn.forEach||pn.hasOwnProperty(ne(t))?un:e},fn=pt("navigator","userAgent")||"",gn=a.process,vn=gn&&gn.versions,bn=vn&&vn.v8;bn?dn=(hn=bn.split("."))[0]+hn[1]:fn&&(!(hn=fn.match(/Edge\/(\d+)/))||hn[1]>=74)&&(hn=fn.match(/Chrome\/(\d+)/))&&(dn=hn[1]);var yn=dn&&+dn,xn=Pt("species"),wn=function(t){return yn>=51||!l((function(){var e=[];return(e.constructor={})[xn]=function(){return{foo:1}},1!==e[t](Boolean).foo}))},_n=Ce.map,kn=wn("map"),Dn=on("map");V({target:"Array",proto:!0,forced:!kn||!Dn},{map:function(t){return _n(this,t,arguments.length>1?arguments[1]:void 0)}});var In=Pi("Array").map,Cn=Array.prototype,Ln=function(t){var e=t.map;return t===Cn||t instanceof Array&&e===Cn.map?In:e},Gn=ji.trim,Mn=a.parseInt,Sn=/^[+-]?0[Xx]/,Qn=8!==Mn(Ei+"08")||22!==Mn(Ei+"0x16")?function(t,e){var i=Gn(String(t));return Mn(i,e>>>0||(Sn.test(i)?16:10))}:Mn;V({global:!0,forced:parseInt!=Qn},{parseInt:Qn});var Nn=W.parseInt,Fn=c.f,Zn=function(t){return function(e){for(var i,n=y(e),o=ht(n),s=o.length,r=0,a=[];s>r;)i=o[r++],h&&!Fn.call(n,i)||a.push(t?[i,n[i]]:n[i]);return a}},Bn={entries:Zn(!0),values:Zn(!1)}.values;V({target:"Object",stat:!0},{values:function(t){return Bn(t)}});var On=W.Object.values,Wn=Ce.filter,An=wn("filter"),Xn=on("filter");V({target:"Array",proto:!0,forced:!An||!Xn},{filter:function(t){return Wn(this,t,arguments.length>1?arguments[1]:void 0)}});var Tn=Pi("Array").filter,Yn=Array.prototype,En=function(t){var e=t.filter;return t===Yn||t instanceof Array&&e===Yn.filter?Tn:e},Rn=Pt("isConcatSpreadable"),Un=yn>=51||!l((function(){var t=[];return t[Rn]=!1,t.concat()[0]!==t})),zn=wn("concat"),Vn=function(t){if(!x(t))return!1;var e=t[Rn];return void 0!==e?!!e:Ct(t)};V({target:"Array",proto:!0,forced:!Un||!zn},{concat:function(t){var e,i,n,o,s,r=Lt(this),a=ke(r,0),l=0;for(e=-1,n=arguments.length;e<n;e++)if(s=-1===e?r:arguments[e],Vn(s)){if(l+(o=$(s.length))>9007199254740991)throw TypeError("Maximum allowed index exceeded");for(i=0;i<o;i++,l++)i in s&&bt(a,l,s[i])}else{if(l>=9007199254740991)throw TypeError("Maximum allowed index exceeded");bt(a,l++,s)}return a.length=l,a}});var jn=Pi("Array").concat,Hn=Array.prototype,Pn=function(t){var e=t.concat;return t===Hn||t instanceof Array&&e===Hn.concat?jn:e};V({target:"Array",stat:!0},{isArray:Ct});var Jn=W.Array.isArray,Kn=Jn;var qn=function(t){if(Kn(t)){for(var e=0,i=new Array(t.length);e<t.length;e++)i[e]=t[e];return i}},$n=function(t,e,i,n){try{return n?e(T(i)[0],i[1]):e(i)}catch(e){var o=t.return;throw void 0!==o&&T(o.call(t)),e}},to=Pt("iterator"),eo=Array.prototype,io=function(t){return void 0!==t&&(ri.Array===t||eo[to]===t)},no=Pt("iterator"),oo=!1;try{var so=0,ro={next:function(){return{done:!!so++}},return:function(){oo=!0}};ro[no]=function(){return this},Array.from(ro,(function(){throw 2}))}catch(t){}var ao=!function(t,e){if(!e&&!oo)return!1;var i=!1;try{var n={};n[no]=function(){return{next:function(){return{done:i=!0}}}},t(n)}catch(t){}return i}((function(t){Array.from(t)}));V({target:"Array",stat:!0,forced:ao},{from:function(t){var e,i,n,o,s,r,a=Lt(t),l="function"==typeof this?this:Array,h=arguments.length,d=h>1?arguments[1]:void 0,u=void 0!==d,c=Ni(a),p=0;if(u&&(d=X(d,h>2?arguments[2]:void 0,2)),null==c||l==Array&&io(c))for(i=new l(e=$(a.length));e>p;p++)r=u?d(a[p],p):a[p],bt(i,p,r);else for(s=(o=c.call(a)).next,i=new l;!(n=s.call(o)).done;p++)r=u?$n(o,d,[n.value,p],!0):n.value,bt(i,p,r);return i.length=p,i}});var lo=W.Array.from,ho=Pt("iterator"),uo=function(t){var e=Object(t);return void 0!==e[ho]||"@@iterator"in e||ri.hasOwnProperty(ne(e))};var co=function(t){if(uo(Object(t))||"[object Arguments]"===Object.prototype.toString.call(t))return lo(t)};var po=function(){throw new TypeError("Invalid attempt to spread non-iterable instance")};var mo=function(t){return qn(t)||co(t)||po()},fo=wn("slice"),go=on("slice",{ACCESSORS:!0,0:0,1:2}),vo=Pt("species"),bo=[].slice,yo=Math.max;V({target:"Array",proto:!0,forced:!fo||!go},{slice:function(t,e){var i,n,o,s=y(this),r=$(s.length),a=it(t,r),l=it(void 0===e?r:e,r);if(Ct(s)&&("function"!=typeof(i=s.constructor)||i!==Array&&!Ct(i.prototype)?x(i)&&null===(i=i[vo])&&(i=void 0):i=void 0,i===Array||void 0===i))return bo.call(s,a,l);for(n=new(void 0===i?Array:i)(yo(l-a,0)),o=0;a<l;a++,o++)a in s&&bt(n,o,s[a]);return n.length=o,n}});var xo=Pi("Array").slice,wo=Array.prototype,_o=function(t){var e=t.slice;return t===wo||t instanceof Array&&e===wo.slice?xo:e},ko=l((function(){di(1)}));V({target:"Object",stat:!0,forced:ko,sham:!ai},{getPrototypeOf:function(t){return di(Lt(t))}});var Do=W.Object.getPrototypeOf,Io=Do,Co=ot.indexOf,Lo=[].indexOf,Go=!!Lo&&1/[1].indexOf(1,-0)<0,Mo=$i("indexOf"),So=on("indexOf",{ACCESSORS:!0,1:0});V({target:"Array",proto:!0,forced:Go||!Mo||!So},{indexOf:function(t){return Go?Lo.apply(this,arguments)||0:Co(this,t,arguments.length>1?arguments[1]:void 0)}});var Qo=Pi("Array").indexOf,No=Array.prototype,Fo=function(t){var e=t.indexOf;return t===No||t instanceof Array&&e===No.indexOf?Qo:e},Zo=Jn,Bo=Object.assign,Oo=Object.defineProperty,Wo=!Bo||l((function(){if(h&&1!==Bo({b:1},Bo(Oo({},"a",{enumerable:!0,get:function(){Oo(this,"b",{value:3,enumerable:!1})}}),{b:2})).b)return!0;var t={},e={},i=Symbol();return t[i]=7,"abcdefghijklmnopqrst".split("").forEach((function(t){e[t]=t})),7!=Bo({},t)[i]||"abcdefghijklmnopqrst"!=ht(Bo({},e)).join("")}))?function(t,e){for(var i=Lt(t),n=arguments.length,o=1,s=gt.f,r=c.f;n>o;)for(var a,l=v(arguments[o++]),d=s?ht(l).concat(s(l)):ht(l),u=d.length,p=0;u>p;)a=d[p++],h&&!r.call(l,a)||(i[a]=l[a]);return i}:Bo;V({target:"Object",stat:!0,forced:Object.assign!==Wo},{assign:Wo});var Ao=W.Object.assign;qt("iterator");var Xo=Jt.f("iterator"),To=Xo,Yo=Object.freeze({__proto__:null});qt("asyncIterator");var Eo=Object.freeze({__proto__:null});qt("hasInstance"),qt("isConcatSpreadable"),qt("match"),qt("matchAll"),qt("replace"),qt("search"),qt("species"),qt("split"),qt("toPrimitive"),qt("toStringTag"),qt("unscopables"),ae(Math,"Math",!0),ae(a.JSON,"JSON",!0),o(Yo),o(Eo);var Ro=W.Symbol;qt("asyncDispose"),qt("dispose"),qt("observable"),qt("patternMatch"),qt("replaceAll");var Uo=Ro,zo=n((function(t){function e(i){return t.exports=e="function"==typeof Uo&&"symbol"==typeof To?function(t){return typeof t}:function(t){return t&&"function"==typeof Uo&&t.constructor===Uo&&t!==Uo.prototype?"symbol":typeof t},e(i)}t.exports=e}));var Vo=function(t){if(Kn(t))return t};var jo=function(t,e){if(uo(Object(t))||"[object Arguments]"===Object.prototype.toString.call(t)){var i=[],n=!0,o=!1,s=void 0;try{for(var r,a=Fi(t);!(n=(r=a.next()).done)&&(i.push(r.value),!e||i.length!==e);n=!0);}catch(t){o=!0,s=t}finally{try{n||null==a.return||a.return()}finally{if(o)throw s}}return i}};var Ho=function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")};var Po=function(t,e){return Vo(t)||jo(t,e)||Ho()};V({target:"Date",stat:!0},{now:function(){return(new Date).getTime()}});var Jo=W.Date.now;function Ko(t,e){var i=Yi(t);if(si){var n=si(t);e&&(n=En(n).call(n,(function(e){return kt(t,e).enumerable}))),i.push.apply(i,n)}return i}function qo(t){var e=function(){for(var t=$o(),e=t(" "),i=t(" "),n=t(" "),o=0;o<arguments.length;o++)(e-=t(o<0||arguments.length<=o?void 0:arguments[o]))<0&&(e+=1),(i-=t(o<0||arguments.length<=o?void 0:arguments[o]))<0&&(i+=1),(n-=t(o<0||arguments.length<=o?void 0:arguments[o]))<0&&(n+=1);return[e,i,n]}(t),i=Po(e,3),n=i[0],o=i[1],s=i[2],r=1,a=function(){var t=2091639*n+2.3283064365386963e-10*r;return n=o,o=s,s=t-(r=0|t)};return a.uint32=function(){return 4294967296*a()},a.fract53=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.algorithm="Alea",a.seed=t,a.version="0.9",a}function $o(){var t=4022871197;return function(e){for(var i=e.toString(),n=0;n<i.length;n++){var o=.02519603282416938*(t+=i.charCodeAt(n));o-=t=o>>>0,t=(o*=t)>>>0,t+=4294967296*(o-=t)}return 2.3283064365386963e-10*(t>>>0)}}var ts=/^\/?Date\((-?\d+)/i,es=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i,is=/^#?([a-f\d])([a-f\d])([a-f\d])$/i,ns=/^rgb\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *\)$/i,os=/^rgba\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *([01]|0?\.\d+) *\)$/i;function ss(t){return t instanceof Number||"number"==typeof t}function rs(t){return t instanceof String||"string"==typeof t}function as(t){return"object"===zo(t)&&null!==t}function ls(t,e,i,n){var o=!1;!0===n&&(o=null===e[i]&&void 0!==t[i]),o?delete t[i]:t[i]=e[i]}var hs=Ao;function ds(t,e){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)||!0===i)if("object"===zo(e[o])&&null!==e[o]&&Io(e[o])===Object.prototype)void 0===t[o]?t[o]=ds({},e[o],i):"object"===zo(t[o])&&null!==t[o]&&Io(t[o])===Object.prototype?ds(t[o],e[o],i):ls(t,e,o,n);else if(Zo(e[o])){var s;t[o]=_o(s=e[o]).call(s)}else ls(t,e,o,n);return t}function us(t){var e=zo(t);return"object"===e?null===t?"null":t instanceof Boolean?"Boolean":t instanceof Number?"Number":t instanceof String?"String":Zo(t)?"Array":t instanceof Date?"Date":"Object":"number"===e?"Number":"boolean"===e?"Boolean":"string"===e?"String":void 0===e?"undefined":e}var cs=On;var ps={asBoolean:function(t,e){return"function"==typeof t&&(t=t()),null!=t?0!=t:e||null},asNumber:function(t,e){return"function"==typeof t&&(t=t()),null!=t?Number(t)||e||null:e||null},asString:function(t,e){return"function"==typeof t&&(t=t()),null!=t?String(t):e||null},asSize:function(t,e){return"function"==typeof t&&(t=t()),rs(t)?t:ss(t)?t+"px":e||null},asElement:function(t,e){return"function"==typeof t&&(t=t()),t||e||null}};function ms(t){var e;switch(t.length){case 3:case 4:return(e=is.exec(t))?{r:Nn(e[1]+e[1],16),g:Nn(e[2]+e[2],16),b:Nn(e[3]+e[3],16)}:null;case 6:case 7:return(e=es.exec(t))?{r:Nn(e[1],16),g:Nn(e[2],16),b:Nn(e[3],16)}:null;default:return null}}function fs(t,e,i){var n;return"#"+_o(n=((1<<24)+(t<<16)+(e<<8)+i).toString(16)).call(n,1)}function gs(t,e,i){t/=255,e/=255,i/=255;var n=Math.min(t,Math.min(e,i)),o=Math.max(t,Math.max(e,i));return n===o?{h:0,s:0,v:n}:{h:60*((t===n?3:i===n?1:5)-(t===n?e-i:i===n?t-e:i-t)/(o-n))/360,s:(o-n)/o,v:o}}var vs=function(t){var e,i={};return mn(e=t.split(";")).call(e,(function(t){if(""!=qi(t).call(t)){var e,n,o=t.split(":"),s=qi(e=o[0]).call(e),r=qi(n=o[1]).call(n);i[s]=r}})),i},bs=function(t){var e;return Ln(e=Yi(t)).call(e,(function(e){return e+": "+t[e]})).join("; ")};function ys(t,e,i){var n,o,s,r=Math.floor(6*t),a=6*t-r,l=i*(1-e),h=i*(1-a*e),d=i*(1-(1-a)*e);switch(r%6){case 0:n=i,o=d,s=l;break;case 1:n=h,o=i,s=l;break;case 2:n=l,o=i,s=d;break;case 3:n=l,o=h,s=i;break;case 4:n=d,o=l,s=i;break;case 5:n=i,o=l,s=h}return{r:Math.floor(255*n),g:Math.floor(255*o),b:Math.floor(255*s)}}function xs(t,e,i){var n=ys(t,e,i);return fs(n.r,n.g,n.b)}function ws(t){var e=ms(t);if(!e)throw new TypeError("'".concat(t,"' is not a valid color."));return gs(e.r,e.g,e.b)}function _s(t){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(t)}function ks(t){return ns.test(t)}function Ds(t){if(null===t||"object"!==zo(t))return null;if(t instanceof Element)return t;var e=Oi(t);for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&"object"==zo(t[i])&&(e[i]=Ds(t[i]));return e}var Is=Object.freeze({__proto__:null,Alea:
/**
	 * vis-util
	 * https://github.com/visjs/vis-util
	 *
	 * utilitie collection for visjs
	 *
	 * @version 4.0.0
	 * @date    2020-02-29T15:35:13.178Z
	 *
	 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
	 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
	 *
	 * @license
	 * vis.js is dual licensed under both
	 *
	 *   1. The Apache 2.0 License
	 *      http://www.apache.org/licenses/LICENSE-2.0
	 *
	 *   and
	 *
	 *   2. The MIT License
	 *      http://opensource.org/licenses/MIT
	 *
	 * vis.js may be distributed under either license.
	 */
function(){for(var t=arguments.length,e=new Array(t),i=0;i<t;i++)e[i]=arguments[i];return qo(e.length?e:[Jo()])},HSVToHex:xs,HSVToRGB:ys,RGBToHSV:gs,RGBToHex:fs,addClassName:function(t,e){var i=t.className.split(" "),n=e.split(" ");i=Pn(i).call(i,En(n).call(n,(function(t){return Fo(i).call(i,t)<0}))),t.className=i.join(" ")},addCssText:function(t,e){var i=function(t){for(var e=1;e<arguments.length;e++){var i,n=null!=arguments[e]?arguments[e]:{};if(e%2)mn(i=Ko(Object(n),!0)).call(i,(function(e){Ai(t,e,n[e])}));else if(yt)ut(t,yt(n));else{var o;mn(o=Ko(Object(n))).call(o,(function(e){H(t,e,kt(n,e))}))}}return t}({},vs(t.style.cssText),{},vs(e));t.style.cssText=bs(i)},addEventListener:function(t,e,i,n){var o;t.addEventListener?(void 0===n&&(n=!1),"mousewheel"===e&&Fo(o=navigator.userAgent).call(o,"Firefox")>=0&&(e="DOMMouseScroll"),t.addEventListener(e,i,n)):t.attachEvent("on"+e,i)},binarySearchCustom:function(t,e,i,n){for(var o=0,s=0,r=t.length-1;s<=r&&o<1e4;){var a=Math.floor((s+r)/2),l=t[a],h=e(void 0===n?l[i]:l[i][n]);if(0==h)return a;-1==h?s=a+1:r=a-1,o++}return-1},binarySearchValue:function(t,e,i,n,o){var s,r,a,l,h=0,d=0,u=t.length-1;for(o=null!=o?o:function(t,e){return t==e?0:t<e?-1:1};d<=u&&h<1e4;){if(l=Math.floor(.5*(u+d)),s=t[Math.max(0,l-1)][i],r=t[l][i],a=t[Math.min(t.length-1,l+1)][i],0==o(r,e))return l;if(o(s,e)<0&&o(r,e)>0)return"before"==n?Math.max(0,l-1):l;if(o(r,e)<0&&o(a,e)>0)return"before"==n?l:Math.min(t.length-1,l+1);o(r,e)<0?d=l+1:u=l-1,h++}return-1},bridgeObject:Ds,copyAndExtendArray:function(t,e){var i;return Pn(i=[]).call(i,mo(t),[e])},copyArray:function(t){return _o(t).call(t)},deepExtend:ds,easingFunctions:{linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return t*(2-t)},easeInOutQuad:function(t){return t<.5?2*t*t:(4-2*t)*t-1},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return--t*t*t+1},easeInOutCubic:function(t){return t<.5?4*t*t*t:(t-1)*(2*t-2)*(2*t-2)+1},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return 1- --t*t*t*t},easeInOutQuart:function(t){return t<.5?8*t*t*t*t:1-8*--t*t*t*t},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return 1+--t*t*t*t*t},easeInOutQuint:function(t){return t<.5?16*t*t*t*t*t:1+16*--t*t*t*t*t}},equalArray:function(t,e){if(t.length!==e.length)return!1;for(var i=0,n=t.length;i<n;i++)if(t[i]!=e[i])return!1;return!0},extend:hs,fillIfDefined:function t(e,i){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2];for(var o in e)if(void 0!==i[o])if(null===i[o]||"object"!==zo(i[o]))ls(e,i,o,n);else{var s=e[o],r=i[o];as(s)&&as(r)&&t(s,r,n)}},forEach:function(t,e){if(Zo(t))for(var i=t.length,n=0;n<i;n++)e(t[n],n,t);else for(var o in t)Object.prototype.hasOwnProperty.call(t,o)&&e(t[o],o,t)},getAbsoluteLeft:function(t){return t.getBoundingClientRect().left},getAbsoluteRight:function(t){return t.getBoundingClientRect().right},getAbsoluteTop:function(t){return t.getBoundingClientRect().top},getScrollBarWidth:function(){var t=document.createElement("p");t.style.width="100%",t.style.height="200px";var e=document.createElement("div");e.style.position="absolute",e.style.top="0px",e.style.left="0px",e.style.visibility="hidden",e.style.width="200px",e.style.height="150px",e.style.overflow="hidden",e.appendChild(t),document.body.appendChild(e);var i=t.offsetWidth;e.style.overflow="scroll";var n=t.offsetWidth;return i==n&&(n=e.clientWidth),document.body.removeChild(e),i-n},getTarget:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:window.event,e=null;return t&&(t.target?e=t.target:t.srcElement&&(e=t.srcElement)),e instanceof Element&&(null==e.nodeType||3!=e.nodeType||(e=e.parentNode)instanceof Element)?e:null},getType:us,hasParent:function(t,e){for(var i=t;i;){if(i===e)return!0;if(!i.parentNode)return!1;i=i.parentNode}return!1},hexToHSV:ws,hexToRGB:ms,insertSort:function(t,e){for(var i=0;i<t.length;i++){var n=t[i],o=void 0;for(o=i;o>0&&e(n,t[o-1])<0;o--)t[o]=t[o-1];t[o]=n}return t},isDate:function(t){if(t instanceof Date)return!0;if(rs(t)){if(ts.exec(t))return!0;if(!isNaN(Date.parse(t)))return!0}return!1},isNumber:ss,isObject:as,isString:rs,isValidHex:_s,isValidRGB:ks,isValidRGBA:function(t){return os.test(t)},mergeOptions:function(t,e,i){var n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{},o=function(t){return null!=t},s=function(t){return null!==t&&"object"===zo(t)},r=function(t){for(var e in t)if(Object.prototype.hasOwnProperty.call(t,e))return!1;return!0};if(!s(t))throw new Error("Parameter mergeTarget must be an object");if(!s(e))throw new Error("Parameter options must be an object");if(!o(i))throw new Error("Parameter option must have a value");if(!s(n))throw new Error("Parameter globalOptions must be an object");var a=function(t,e,i){s(t[i])||(t[i]={});var n=e[i],o=t[i];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(o[r]=n[r])},l=e[i],h=s(n)&&!r(n),d=h?n[i]:void 0,u=d?d.enabled:void 0;if(void 0!==l){if("boolean"==typeof l)return s(t[i])||(t[i]={}),void(t[i].enabled=l);if(null===l&&!s(t[i])){if(!o(d))return;t[i]=Oi(d)}if(s(l)){var c=!0;void 0!==l.enabled?c=l.enabled:void 0!==u&&(c=d.enabled),a(t,e,i),t[i].enabled=c}}},option:ps,overrideOpacity:function(t,e){if(-1!==Fo(t).call(t,"rgba"))return t;if(-1!==Fo(t).call(t,"rgb")){var i=t.substr(Fo(t).call(t,"(")+1).replace(")","").split(",");return"rgba("+i[0]+","+i[1]+","+i[2]+","+e+")"}var n=ms(t);return null==n?t:"rgba("+n.r+","+n.g+","+n.b+","+e+")"},parseColor:function(t,e){if(rs(t)){var i=t;if(ks(i)){var n,o=Ln(n=i.substr(4).substr(0,i.length-5).split(",")).call(n,(function(t){return Nn(t)}));i=fs(o[0],o[1],o[2])}if(!0===_s(i)){var s=ws(i),r={h:s.h,s:.8*s.s,v:Math.min(1,1.02*s.v)},a={h:s.h,s:Math.min(1,1.25*s.s),v:.8*s.v},l=xs(a.h,a.s,a.v),h=xs(r.h,r.s,r.v);return{background:i,border:l,highlight:{background:h,border:l},hover:{background:h,border:l}}}return{background:i,border:i,highlight:{background:i,border:i},hover:{background:i,border:i}}}return e?{background:t.background||e.background,border:t.border||e.border,highlight:rs(t.highlight)?{border:t.highlight,background:t.highlight}:{background:t.highlight&&t.highlight.background||e.highlight.background,border:t.highlight&&t.highlight.border||e.highlight.border},hover:rs(t.hover)?{border:t.hover,background:t.hover}:{border:t.hover&&t.hover.border||e.hover.border,background:t.hover&&t.hover.background||e.hover.background}}:{background:t.background||void 0,border:t.border||void 0,highlight:rs(t.highlight)?{border:t.highlight,background:t.highlight}:{background:t.highlight&&t.highlight.background||void 0,border:t.highlight&&t.highlight.border||void 0},hover:rs(t.hover)?{border:t.hover,background:t.hover}:{border:t.hover&&t.hover.border||void 0,background:t.hover&&t.hover.background||void 0}}},preventDefault:function(t){t||(t=window.event),t&&(t.preventDefault?t.preventDefault():t.returnValue=!1)},recursiveDOMDelete:function t(e){if(e)for(;!0===e.hasChildNodes();){var i=e.firstChild;i&&(t(i),e.removeChild(i))}},removeClassName:function(t,e){var i=t.className.split(" "),n=e.split(" ");i=En(i).call(i,(function(t){return Fo(n).call(n,t)<0})),t.className=i.join(" ")},removeCssText:function(t,e){var i=vs(t.style.cssText),n=vs(e);for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&delete i[o];t.style.cssText=bs(i)},removeEventListener:function(t,e,i,n){var o;t.removeEventListener?(void 0===n&&(n=!1),"mousewheel"===e&&Fo(o=navigator.userAgent).call(o,"Firefox")>=0&&(e="DOMMouseScroll"),t.removeEventListener(e,i,n)):t.detachEvent("on"+e,i)},selectiveBridgeObject:function(t,e){if(null!==e&&"object"===zo(e)){for(var i=Oi(e),n=0;n<t.length;n++)Object.prototype.hasOwnProperty.call(e,t[n])&&"object"==zo(e[t[n]])&&(i[t[n]]=Ds(e[t[n]]));return i}return null},selectiveDeepExtend:function(t,e,i){var n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Zo(i))throw new TypeError("Arrays are not supported by deepExtend");for(var o=0;o<t.length;o++){var s=t[o];if(Object.prototype.hasOwnProperty.call(i,s))if(i[s]&&i[s].constructor===Object)void 0===e[s]&&(e[s]={}),e[s].constructor===Object?ds(e[s],i[s],!1,n):ls(e,i,s,n);else{if(Zo(i[s]))throw new TypeError("Arrays are not supported by deepExtend");ls(e,i,s,n)}}return e},selectiveExtend:function(t,e){if(!Zo(t))throw new Error("Array with property names expected as first argument");for(var i=arguments.length,n=new Array(i>2?i-2:0),o=2;o<i;o++)n[o-2]=arguments[o];for(var s=0,r=n;s<r.length;s++)for(var a=r[s],l=0;l<t.length;l++){var h=t[l];a&&Object.prototype.hasOwnProperty.call(a,h)&&(e[h]=a[h])}return e},selectiveNotDeepExtend:function(t,e,i){var n=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(Zo(i))throw new TypeError("Arrays are not supported by deepExtend");for(var o in i)if(Object.prototype.hasOwnProperty.call(i,o)&&-1===Fo(t).call(t,o))if(i[o]&&i[o].constructor===Object)void 0===e[o]&&(e[o]={}),e[o].constructor===Object?ds(e[o],i[o]):ls(e,i,o,n);else if(Zo(i[o])){e[o]=[];for(var s=0;s<i[o].length;s++)e[o].push(i[o][s])}else ls(e,i,o,n);return e},throttle:function(t){var e=!1;return function(){e||(e=!0,requestAnimationFrame((function(){e=!1,t()})))}},toArray:cs,topMost:function(t,e){var i;Zo(e)||(e=[e]);var n=!0,o=!1,s=void 0;try{for(var r,a=Fi(t);!(n=(r=a.next()).done);n=!0){var l=r.value;if(l){i=l[e[0]];for(var h=1;h<e.length;h++)i&&(i=i[e[h]]);if(void 0!==i)break}}}catch(t){o=!0,s=t}finally{try{n||null==a.return||a.return()}finally{if(o)throw s}}return i},updateProperty:function(t,e,i){return t[e]!==i&&(t[e]=i,!0)}});function Cs(t){for(var e in t)t.hasOwnProperty(e)&&(t[e].redundant=t[e].used,t[e].used=[])}function Ls(t){for(var e in t)if(t.hasOwnProperty(e)&&t[e].redundant){for(var i=0;i<t[e].redundant.length;i++)t[e].redundant[i].parentNode.removeChild(t[e].redundant[i]);t[e].redundant=[]}}function Gs(t){Cs(t),Ls(t),Cs(t)}function Ms(t,e,i){var n;return e.hasOwnProperty(t)?e[t].redundant.length>0?(n=e[t].redundant[0],e[t].redundant.shift()):(n=document.createElementNS("http://www.w3.org/2000/svg",t),i.appendChild(n)):(n=document.createElementNS("http://www.w3.org/2000/svg",t),e[t]={used:[],redundant:[]},i.appendChild(n)),e[t].used.push(n),n}function Ss(t,e,i,n){var o;return e.hasOwnProperty(t)?e[t].redundant.length>0?(o=e[t].redundant[0],e[t].redundant.shift()):(o=document.createElement(t),void 0!==n?i.insertBefore(o,n):i.appendChild(o)):(o=document.createElement(t),e[t]={used:[],redundant:[]},void 0!==n?i.insertBefore(o,n):i.appendChild(o)),e[t].used.push(o),o}function Qs(t,e,i,n,o,s){var r;if("circle"==i.style?((r=Ms("circle",n,o)).setAttributeNS(null,"cx",t),r.setAttributeNS(null,"cy",e),r.setAttributeNS(null,"r",.5*i.size)):((r=Ms("rect",n,o)).setAttributeNS(null,"x",t-.5*i.size),r.setAttributeNS(null,"y",e-.5*i.size),r.setAttributeNS(null,"width",i.size),r.setAttributeNS(null,"height",i.size)),void 0!==i.styles&&r.setAttributeNS(null,"style",i.styles),r.setAttributeNS(null,"class",i.className+" vis-point"),s){var a=Ms("text",n,o);s.xOffset&&(t+=s.xOffset),s.yOffset&&(e+=s.yOffset),s.content&&(a.textContent=s.content),s.className&&a.setAttributeNS(null,"class",s.className+" vis-label"),a.setAttributeNS(null,"x",t),a.setAttributeNS(null,"y",e)}return r}function Ns(t,e,i,n,o,s,r,a){if(0!=n){n<0&&(e-=n*=-1);var l=Ms("rect",s,r);l.setAttributeNS(null,"x",t-.5*i),l.setAttributeNS(null,"y",e),l.setAttributeNS(null,"width",i),l.setAttributeNS(null,"height",n),l.setAttributeNS(null,"class",o),a&&l.setAttributeNS(null,"style",a)}}function Fs(){try{return navigator?navigator.languages&&navigator.languages.length?navigator.languages:navigator.userLanguage||navigator.language||navigator.browserLanguage||"en":"en"}catch(t){return"en"}}var Zs=Object.freeze({__proto__:null,prepareElements:Cs,cleanupElements:Ls,resetElements:Gs,getSVGElement:Ms,getDOMElement:Ss,drawPoint:Qs,drawBar:Ns,getNavigatorLanguage:Fs});var Bs=function(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t},Os=Pi("Array").entries,Ws=Array.prototype,As={DOMTokenList:!0,NodeList:!0},Xs=function(t){var e=t.entries;return t===Ws||t instanceof Array&&e===Ws.entries||As.hasOwnProperty(ne(t))?Os:e},Ts=pt("JSON","stringify"),Ys=/[\uD800-\uDFFF]/g,Es=/^[\uD800-\uDBFF]$/,Rs=/^[\uDC00-\uDFFF]$/,Us=function(t,e,i){var n=i.charAt(e-1),o=i.charAt(e+1);return Es.test(t)&&!Rs.test(o)||Rs.test(t)&&!Es.test(n)?"\\u"+t.charCodeAt(0).toString(16):t},zs=l((function(){return'"\\udf06\\ud834"'!==Ts("\udf06\ud834")||'"\\udead"'!==Ts("\udead")}));Ts&&V({target:"JSON",stat:!0,forced:zs},{stringify:function(t,e,i){var n=Ts.apply(null,arguments);return"string"==typeof n?n.replace(Ys,Us):n}}),W.JSON||(W.JSON={stringify:JSON.stringify});var Vs=function(t,e,i){return W.JSON.stringify.apply(null,arguments)},js=Pi("Array").values,Hs=Array.prototype,Ps={DOMTokenList:!0,NodeList:!0},Js=function(t){var e=t.values;return t===Hs||t instanceof Array&&e===Hs.values||Ps.hasOwnProperty(ne(t))?js:e},Ks=Pi("Array").keys,qs=Array.prototype,$s={DOMTokenList:!0,NodeList:!0},tr=function(t){var e=t.keys;return t===qs||t instanceof Array&&e===qs.keys||$s.hasOwnProperty(ne(t))?Ks:e},er=Ce.some,ir=$i("some"),nr=on("some");V({target:"Array",proto:!0,forced:!ir||!nr},{some:function(t){return er(this,t,arguments.length>1?arguments[1]:void 0)}});var or=Pi("Array").some,sr=Array.prototype,rr=function(t){var e=t.some;return t===sr||t instanceof Array&&e===sr.some?or:e};var ar=function(t,e){return!e||"object"!==zo(e)&&"function"!=typeof e?Bs(t):e},lr=Do;V({target:"Object",stat:!0},{setPrototypeOf:fi});var hr=W.Object.setPrototypeOf,dr=n((function(t){function e(i){return t.exports=e=hr?lr:function(t){return t.__proto__||lr(t)},e(i)}t.exports=e})),ur=Bi,cr=n((function(t){function e(i,n){return t.exports=e=hr||function(t,e){return t.__proto__=e,t},e(i,n)}t.exports=e}));var pr=function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function");t.prototype=ur(e&&e.prototype,{constructor:{value:t,writable:!0,configurable:!0}}),e&&cr(t,e)},mr=[],fr=mr.sort,gr=l((function(){mr.sort(void 0)})),vr=l((function(){mr.sort(null)})),br=$i("sort");V({target:"Array",proto:!0,forced:gr||!vr||!br},{sort:function(t){return void 0===t?fr.call(Lt(this)):fr.call(Lt(this),A(t))}});var yr=Pi("Array").sort,xr=Array.prototype,wr=function(t){var e=t.sort;return t===xr||t instanceof Array&&e===xr.sort?yr:e},_r=!l((function(){return Object.isExtensible(Object.preventExtensions({}))})),kr=n((function(t){var e=E.f,i=Ft("meta"),n=0,o=Object.isExtensible||function(){return!0},s=function(t){e(t,i,{value:{objectID:"O"+ ++n,weakData:{}}})},r=t.exports={REQUIRED:!1,fastKey:function(t,e){if(!x(t))return"symbol"==typeof t?t:("string"==typeof t?"S":"P")+t;if(!k(t,i)){if(!o(t))return"F";if(!e)return"E";s(t)}return t[i].objectID},getWeakData:function(t,e){if(!k(t,i)){if(!o(t))return!0;if(!e)return!1;s(t)}return t[i].weakData},onFreeze:function(t){return _r&&r.REQUIRED&&o(t)&&!k(t,i)&&s(t),t}};st[i]=!0})),Dr=(kr.REQUIRED,kr.fastKey,kr.getWeakData,kr.onFreeze,n((function(t){var e=function(t,e){this.stopped=t,this.result=e};(t.exports=function(t,i,n,o,s){var r,a,l,h,d,u,c,p=X(i,n,o?2:1);if(s)r=t;else{if("function"!=typeof(a=Ni(t)))throw TypeError("Target is not iterable");if(io(a)){for(l=0,h=$(t.length);h>l;l++)if((d=o?p(T(c=t[l])[0],c[1]):p(t[l]))&&d instanceof e)return d;return new e(!1)}r=a.call(t)}for(u=r.next;!(c=u.call(r)).done;)if("object"==typeof(d=$n(r,p,c.value,o))&&d&&d instanceof e)return d;return new e(!1)}).stop=function(t){return new e(!0,t)}}))),Ir=function(t,e,i){if(!(t instanceof e))throw TypeError("Incorrect "+(i?i+" ":"")+"invocation");return t},Cr=E.f,Lr=Ce.forEach,Gr=we.set,Mr=we.getterFor,Sr=function(t,e,i){var n,o=-1!==t.indexOf("Map"),s=-1!==t.indexOf("Weak"),r=o?"set":"add",d=a[t],u=d&&d.prototype,c={};if(h&&"function"==typeof d&&(s||u.forEach&&!l((function(){(new d).entries().next()})))){n=e((function(e,i){Gr(Ir(e,n,t),{type:t,collection:new d}),null!=i&&Dr(i,e[r],e,o)}));var p=Mr(t);Lr(["add","clear","delete","forEach","get","has","set","keys","values","entries"],(function(t){var e="add"==t||"set"==t;t in u&&(!s||"clear"!=t)&&R(n.prototype,t,(function(i,n){var o=p(this).collection;if(!e&&s&&!x(i))return"get"==t&&void 0;var r=o[t](0===i?0:i,n);return e?this:r}))})),s||Cr(n.prototype,"size",{configurable:!0,get:function(){return p(this).collection.size}})}else n=i.getConstructor(e,t,o,r),kr.REQUIRED=!0;return ae(n,t,!1,!0),c[t]=n,V({global:!0,forced:!0},c),s||i.setStrong(n,t,o),n},Qr=function(t,e,i){for(var n in e)i&&i.unsafe&&t[n]?t[n]=e[n]:zt(t,n,e[n],i);return t},Nr=Pt("species"),Fr=E.f,Zr=kr.fastKey,Br=we.set,Or=we.getterFor,Wr={getConstructor:function(t,e,i,n){var o=t((function(t,s){Ir(t,o,e),Br(t,{type:e,index:Tt(null),first:void 0,last:void 0,size:0}),h||(t.size=0),null!=s&&Dr(s,t[n],t,i)})),s=Or(e),r=function(t,e,i){var n,o,r=s(t),l=a(t,e);return l?l.value=i:(r.last=l={index:o=Zr(e,!0),key:e,value:i,previous:n=r.last,next:void 0,removed:!1},r.first||(r.first=l),n&&(n.next=l),h?r.size++:t.size++,"F"!==o&&(r.index[o]=l)),t},a=function(t,e){var i,n=s(t),o=Zr(e);if("F"!==o)return n.index[o];for(i=n.first;i;i=i.next)if(i.key==e)return i};return Qr(o.prototype,{clear:function(){for(var t=s(this),e=t.index,i=t.first;i;)i.removed=!0,i.previous&&(i.previous=i.previous.next=void 0),delete e[i.index],i=i.next;t.first=t.last=void 0,h?t.size=0:this.size=0},delete:function(t){var e=s(this),i=a(this,t);if(i){var n=i.next,o=i.previous;delete e.index[i.index],i.removed=!0,o&&(o.next=n),n&&(n.previous=o),e.first==i&&(e.first=n),e.last==i&&(e.last=o),h?e.size--:this.size--}return!!i},forEach:function(t){for(var e,i=s(this),n=X(t,arguments.length>1?arguments[1]:void 0,3);e=e?e.next:i.first;)for(n(e.value,e.key,this);e&&e.removed;)e=e.previous},has:function(t){return!!a(this,t)}}),Qr(o.prototype,i?{get:function(t){var e=a(this,t);return e&&e.value},set:function(t,e){return r(this,0===t?0:t,e)}}:{add:function(t){return r(this,t=0===t?0:t,t)}}),h&&Fr(o.prototype,"size",{get:function(){return s(this).size}}),o},setStrong:function(t,e,i){var n=e+" Iterator",o=Or(e),s=Or(n);xi(t,e,(function(t,e){Br(this,{type:n,target:t,state:o(t),kind:e,last:void 0})}),(function(){for(var t=s(this),e=t.kind,i=t.last;i&&i.removed;)i=i.previous;return t.target&&(t.last=i=i?i.next:t.state.first)?"keys"==e?{value:i.key,done:!1}:"values"==e?{value:i.value,done:!1}:{value:[i.key,i.value],done:!1}:(t.target=void 0,{value:void 0,done:!0})}),i?"entries":"values",!i,!0),function(t){var e=pt(t),i=E.f;h&&e&&!e[Nr]&&i(e,Nr,{configurable:!0,get:function(){return this}})}(e)}},Ar=(Sr("Set",(function(t){return function(){return t(this,arguments.length?arguments[0]:void 0)}}),Wr),W.Set),Xr=(Sr("Map",(function(t){return function(){return t(this,arguments.length?arguments[0]:void 0)}}),Wr),W.Map),Tr=n((function(t){var e=function(t){var e=Object.prototype,i=e.hasOwnProperty,n="function"==typeof Symbol?Symbol:{},o=n.iterator||"@@iterator",s=n.asyncIterator||"@@asyncIterator",r=n.toStringTag||"@@toStringTag";function a(t,e,i,n){var o=e&&e.prototype instanceof d?e:d,s=Object.create(o.prototype),r=new _(n||[]);return s._invoke=function(t,e,i){var n="suspendedStart";return function(o,s){if("executing"===n)throw new Error("Generator is already running");if("completed"===n){if("throw"===o)throw s;return D()}for(i.method=o,i.arg=s;;){var r=i.delegate;if(r){var a=y(r,i);if(a){if(a===h)continue;return a}}if("next"===i.method)i.sent=i._sent=i.arg;else if("throw"===i.method){if("suspendedStart"===n)throw n="completed",i.arg;i.dispatchException(i.arg)}else"return"===i.method&&i.abrupt("return",i.arg);n="executing";var d=l(t,e,i);if("normal"===d.type){if(n=i.done?"completed":"suspendedYield",d.arg===h)continue;return{value:d.arg,done:i.done}}"throw"===d.type&&(n="completed",i.method="throw",i.arg=d.arg)}}}(t,i,r),s}function l(t,e,i){try{return{type:"normal",arg:t.call(e,i)}}catch(t){return{type:"throw",arg:t}}}t.wrap=a;var h={};function d(){}function u(){}function c(){}var p={};p[o]=function(){return this};var m=Object.getPrototypeOf,f=m&&m(m(k([])));f&&f!==e&&i.call(f,o)&&(p=f);var g=c.prototype=d.prototype=Object.create(p);function v(t){["next","throw","return"].forEach((function(e){t[e]=function(t){return this._invoke(e,t)}}))}function b(t,e){var n;this._invoke=function(o,s){function r(){return new e((function(n,r){!function n(o,s,r,a){var h=l(t[o],t,s);if("throw"!==h.type){var d=h.arg,u=d.value;return u&&"object"==typeof u&&i.call(u,"__await")?e.resolve(u.__await).then((function(t){n("next",t,r,a)}),(function(t){n("throw",t,r,a)})):e.resolve(u).then((function(t){d.value=t,r(d)}),(function(t){return n("throw",t,r,a)}))}a(h.arg)}(o,s,n,r)}))}return n=n?n.then(r,r):r()}}function y(t,e){var i=t.iterator[e.method];if(void 0===i){if(e.delegate=null,"throw"===e.method){if(t.iterator.return&&(e.method="return",e.arg=void 0,y(t,e),"throw"===e.method))return h;e.method="throw",e.arg=new TypeError("The iterator does not provide a 'throw' method")}return h}var n=l(i,t.iterator,e.arg);if("throw"===n.type)return e.method="throw",e.arg=n.arg,e.delegate=null,h;var o=n.arg;return o?o.done?(e[t.resultName]=o.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,h):o:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,h)}function x(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function w(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function _(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(x,this),this.reset(!0)}function k(t){if(t){var e=t[o];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var n=-1,s=function e(){for(;++n<t.length;)if(i.call(t,n))return e.value=t[n],e.done=!1,e;return e.value=void 0,e.done=!0,e};return s.next=s}}return{next:D}}function D(){return{value:void 0,done:!0}}return u.prototype=g.constructor=c,c.constructor=u,c[r]=u.displayName="GeneratorFunction",t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===u||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,c):(t.__proto__=c,r in t||(t[r]="GeneratorFunction")),t.prototype=Object.create(g),t},t.awrap=function(t){return{__await:t}},v(b.prototype),b.prototype[s]=function(){return this},t.AsyncIterator=b,t.async=function(e,i,n,o,s){void 0===s&&(s=Promise);var r=new b(a(e,i,n,o),s);return t.isGeneratorFunction(i)?r:r.next().then((function(t){return t.done?t.value:r.next()}))},v(g),g[r]="Generator",g[o]=function(){return this},g.toString=function(){return"[object Generator]"},t.keys=function(t){var e=[];for(var i in t)e.push(i);return e.reverse(),function i(){for(;e.length;){var n=e.pop();if(n in t)return i.value=n,i.done=!1,i}return i.done=!0,i}},t.values=k,_.prototype={constructor:_,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(w),!t)for(var e in this)"t"===e.charAt(0)&&i.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function n(i,n){return r.type="throw",r.arg=t,e.next=i,n&&(e.method="next",e.arg=void 0),!!n}for(var o=this.tryEntries.length-1;o>=0;--o){var s=this.tryEntries[o],r=s.completion;if("root"===s.tryLoc)return n("end");if(s.tryLoc<=this.prev){var a=i.call(s,"catchLoc"),l=i.call(s,"finallyLoc");if(a&&l){if(this.prev<s.catchLoc)return n(s.catchLoc,!0);if(this.prev<s.finallyLoc)return n(s.finallyLoc)}else if(a){if(this.prev<s.catchLoc)return n(s.catchLoc,!0)}else{if(!l)throw new Error("try statement without catch or finally");if(this.prev<s.finallyLoc)return n(s.finallyLoc)}}}},abrupt:function(t,e){for(var n=this.tryEntries.length-1;n>=0;--n){var o=this.tryEntries[n];if(o.tryLoc<=this.prev&&i.call(o,"finallyLoc")&&this.prev<o.finallyLoc){var s=o;break}}s&&("break"===t||"continue"===t)&&s.tryLoc<=e&&e<=s.finallyLoc&&(s=null);var r=s?s.completion:{};return r.type=t,r.arg=e,s?(this.method="next",this.next=s.finallyLoc,h):this.complete(r)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),h},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var i=this.tryEntries[e];if(i.finallyLoc===t)return this.complete(i.completion,i.afterLoc),w(i),h}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var i=this.tryEntries[e];if(i.tryLoc===t){var n=i.completion;if("throw"===n.type){var o=n.arg;w(i)}return o}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,i){return this.delegate={iterator:k(t),resultName:e,nextLoc:i},"next"===this.method&&(this.arg=void 0),h}},t}(t.exports);try{regeneratorRuntime=e}catch(t){Function("r","regeneratorRuntime = r")(e)}})),Yr=Xo,Er=wn("splice"),Rr=on("splice",{ACCESSORS:!0,0:0,1:2}),Ur=Math.max,zr=Math.min;V({target:"Array",proto:!0,forced:!Er||!Rr},{splice:function(t,e){var i,n,o,s,r,a,l=Lt(this),h=$(l.length),d=it(t,h),u=arguments.length;if(0===u?i=n=0:1===u?(i=0,n=h-d):(i=u-2,n=zr(Ur(K(e),0),h-d)),h+i-n>9007199254740991)throw TypeError("Maximum allowed length exceeded");for(o=ke(l,n),s=0;s<n;s++)(r=d+s)in l&&bt(o,s,l[r]);if(o.length=n,i<n){for(s=d;s<h-n;s++)a=s+i,(r=s+n)in l?l[a]=l[r]:delete l[a];for(s=h;s>h-n+i;s--)delete l[s-1]}else if(i>n)for(s=h-n;s>d;s--)a=s+i-1,(r=s+n-1)in l?l[a]=l[r]:delete l[a];for(s=0;s<i;s++)l[s+d]=arguments[s+2];return l.length=h-n+i,o}});var Vr=Pi("Array").splice,jr=Array.prototype,Hr=function(t){var e=t.splice;return t===jr||t instanceof Array&&e===jr.splice?Vr:e},Pr=[].slice,Jr=/MSIE .\./.test(fn),Kr=function(t){return function(e,i){var n=arguments.length>2,o=n?Pr.call(arguments,2):void 0;return t(n?function(){("function"==typeof e?e:Function(e)).apply(this,o)}:e,i)}};V({global:!0,bind:!0,forced:Jr},{setTimeout:Kr(a.setTimeout),setInterval:Kr(a.setInterval)});var qr=W.setTimeout,$r=function(t,e,i,n,o,s,r,a){for(var l,h=o,d=0,u=!!r&&X(r,a,3);d<n;){if(d in i){if(l=u?u(i[d],d,e):i[d],s>0&&Ct(l))h=$r(t,e,l,$(l.length),h,s-1)-1;else{if(h>=9007199254740991)throw TypeError("Exceed the acceptable array length");t[h]=l}h++}d++}return h},ta=$r;V({target:"Array",proto:!0},{flatMap:function(t){var e,i=Lt(this),n=$(i.length);return A(t),(e=ke(i,0)).length=ta(e,i,i,n,0,1,t,arguments.length>1?arguments[1]:void 0),e}});var ea=Pi("Array").flatMap,ia=Array.prototype,na=function(t){var e=t.flatMap;return t===ia||t instanceof Array&&e===ia.flatMap?ea:e},oa=function(t){return function(e,i,n,o){A(i);var s=Lt(e),r=v(s),a=$(s.length),l=t?a-1:0,h=t?-1:1;if(n<2)for(;;){if(l in r){o=r[l],l+=h;break}if(l+=h,t?l<0:a<=l)throw TypeError("Reduce of empty array with no initial value")}for(;t?l>=0:a>l;l+=h)l in r&&(o=i(o,r[l],l,s));return o}},sa={left:oa(!1),right:oa(!0)}.left,ra=$i("reduce"),aa=on("reduce",{1:0});V({target:"Array",proto:!0,forced:!ra||!aa},{reduce:function(t){return sa(this,t,arguments.length,arguments.length>1?arguments[1]:void 0)}});var la=Pi("Array").reduce,ha=Array.prototype,da=function(t){var e=t.reduce;return t===ha||t instanceof Array&&e===ha.reduce?la:e},ua=[].slice,ca={},pa=function(t,e,i){if(!(e in ca)){for(var n=[],o=0;o<e;o++)n[o]="a["+o+"]";ca[e]=Function("C,a","return new C("+n.join(",")+")")}return ca[e](t,i)},ma=Function.bind||function(t){var e=A(this),i=ua.call(arguments,1),n=function(){var o=i.concat(ua.call(arguments));return this instanceof n?pa(e,o.length,o):e.apply(t,o)};return x(e.prototype)&&(n.prototype=e.prototype),n};V({target:"Function",proto:!0},{bind:ma});var fa=Pi("Function").bind,ga=Function.prototype,va=function(t){var e=t.bind;return t===ga||t instanceof Function&&e===ga.bind?fa:e};var ba=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")};function ya(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Wi(t,n.key,n)}}var xa=function(t,e,i){return e&&ya(t.prototype,e),i&&ya(t,i),t};function wa(t,e){var i=Yi(t);if(si){var n=si(t);e&&(n=En(n).call(n,(function(e){return kt(t,e).enumerable}))),i.push.apply(i,n)}return i}function _a(t){return new Da(t)}var ka=function(){function t(e,i,n){var o,s,r;ba(this,t),this._source=e,this._transformers=i,this._target=n,this._listeners={add:va(o=this._add).call(o,this),remove:va(s=this._remove).call(s,this),update:va(r=this._update).call(r,this)}}return xa(t,[{key:"all",value:function(){return this._target.update(this._transformItems(this._source.get())),this}},{key:"start",value:function(){return this._source.on("add",this._listeners.add),this._source.on("remove",this._listeners.remove),this._source.on("update",this._listeners.update),this}},{key:"stop",value:function(){return this._source.off("add",this._listeners.add),this._source.off("remove",this._listeners.remove),this._source.off("update",this._listeners.update),this}},{key:"_transformItems",value:function(t){var e;return da(e=this._transformers).call(e,(function(t,e){return e(t)}),t)}},{key:"_add",value:function(t,e){null!=e&&this._target.add(this._transformItems(this._source.get(e.items)))}},{key:"_update",value:function(t,e){null!=e&&this._target.update(this._transformItems(this._source.get(e.items)))}},{key:"_remove",value:function(t,e){null!=e&&this._target.remove(this._transformItems(e.oldData))}}]),t}(),Da=function(){function t(e){ba(this,t),this._source=e,this._transformers=[]}return xa(t,[{key:"filter",value:function(t){return this._transformers.push((function(e){return En(e).call(e,t)})),this}},{key:"map",value:function(t){return this._transformers.push((function(e){return Ln(e).call(e,t)})),this}},{key:"flatMap",value:function(t){return this._transformers.push((function(e){return na(e).call(e,t)})),this}},{key:"to",value:function(t){return new ka(this._source,this._transformers,t)}}]),t}();for(var Ia=function(t,e){return t(e={exports:{}},e.exports),e.exports}((function(t){var e,i,n="undefined"!=typeof crypto&&crypto.getRandomValues&&va(e=crypto.getRandomValues).call(e,crypto)||"undefined"!=typeof msCrypto&&"function"==typeof window.msCrypto.getRandomValues&&va(i=msCrypto.getRandomValues).call(i,msCrypto);if(n){var o=new Uint8Array(16);t.exports=function(){return n(o),o}}else{var s=new Array(16);t.exports=function(){for(var t,e=0;e<16;e++)0==(3&e)&&(t=4294967296*Math.random()),s[e]=t>>>((3&e)<<3)&255;return s}}})),Ca=[],La=0;La<256;++La)Ca[La]=(La+256).toString(16).substr(1);var Ga=function(t,e){var i=e||0,n=Ca;return[n[t[i++]],n[t[i++]],n[t[i++]],n[t[i++]],"-",n[t[i++]],n[t[i++]],"-",n[t[i++]],n[t[i++]],"-",n[t[i++]],n[t[i++]],"-",n[t[i++]],n[t[i++]],n[t[i++]],n[t[i++]],n[t[i++]],n[t[i++]]].join("")};var Ma=function(t,e,i){var n=e&&i||0;"string"==typeof t&&(e="binary"===t?new Array(16):null,t=null);var o=(t=t||{}).random||(t.rng||Ia)();if(o[6]=15&o[6]|64,o[8]=63&o[8]|128,e)for(var s=0;s<16;++s)e[n+s]=o[s];return e||Ga(o)},Sa=/^\/?Date\((-?\d+)/i;function Qa(t){return s.isMoment(t)}function Na(t,e){var i;if(void 0!==t){if(null===t)return null;if(!e)return t;if("string"!=typeof e&&!(e instanceof String))throw new Error("Type must be a string");switch(e){case"boolean":case"Boolean":return Boolean(t);case"number":case"Number":return rs(t)&&!isNaN(Date.parse(t))?s(t).valueOf():Number(t.valueOf());case"string":case"String":return String(t);case"Date":if(ss(t))return new Date(t);if(t instanceof Date)return new Date(t.valueOf());if(Qa(t))return new Date(t.valueOf());if(rs(t))return(i=Sa.exec(t))?new Date(Number(i[1])):s(new Date(t)).toDate();throw new Error("Cannot convert object of type "+us(t)+" to type Date");case"Moment":if(ss(t))return s(t);if(t instanceof Date)return s(t.valueOf());if(Qa(t))return s(t);if(rs(t))return i=Sa.exec(t),s(i?Number(i[1]):t);throw new Error("Cannot convert object of type "+us(t)+" to type Date");case"ISODate":if(ss(t))return new Date(t);if(t instanceof Date)return t.toISOString();if(Qa(t))return t.toDate().toISOString();if(rs(t))return(i=Sa.exec(t))?new Date(Number(i[1])).toISOString():s(t).format();throw new Error("Cannot convert object of type "+us(t)+" to type ISODate");case"ASPDate":if(ss(t))return"/Date("+t+")/";if(t instanceof Date||Qa(t))return"/Date("+t.valueOf()+")/";if(rs(t))return"/Date("+((i=Sa.exec(t))?new Date(Number(i[1])).valueOf():new Date(t).valueOf())+")/";throw new Error("Cannot convert object of type "+us(t)+" to type ASPDate");default:throw new Error("Unknown type ".concat(e))}}}function Fa(t){return"string"==typeof t||"number"==typeof t}var Za=function(){function t(e){ba(this,t),this._queue=[],this._timeout=null,this._extended=null,this.delay=null,this.max=1/0,this.setOptions(e)}return xa(t,[{key:"setOptions",value:function(t){t&&void 0!==t.delay&&(this.delay=t.delay),t&&void 0!==t.max&&(this.max=t.max),this._flushIfNeeded()}},{key:"destroy",value:function(){if(this.flush(),this._extended){for(var t=this._extended.object,e=this._extended.methods,i=0;i<e.length;i++){var n=e[i];n.original?t[n.name]=n.original:delete t[n.name]}this._extended=null}}},{key:"replace",value:function(t,e){var i=this,n=t[e];if(!n)throw new Error("Method "+e+" undefined");t[e]=function(){for(var t=arguments.length,e=new Array(t),o=0;o<t;o++)e[o]=arguments[o];i.queue({args:e,fn:n,context:this})}}},{key:"queue",value:function(t){"function"==typeof t?this._queue.push({fn:t}):this._queue.push(t),this._flushIfNeeded()}},{key:"_flushIfNeeded",value:function(){var t=this;this._queue.length>this.max&&this.flush(),null!=this._timeout&&(clearTimeout(this._timeout),this._timeout=null),this.queue.length>0&&"number"==typeof this.delay&&(this._timeout=qr((function(){t.flush()}),this.delay))}},{key:"flush",value:function(){var t,e;mn(t=Hr(e=this._queue).call(e,0)).call(t,(function(t){t.fn.apply(t.context||t.fn,t.args||[])}))}}],[{key:"extend",value:function(e,i){var n=new t(i);if(void 0!==e.flush)throw new Error("Target object already has a property flush");e.flush=function(){n.flush()};var o=[{name:"flush",original:void 0}];if(i&&i.replace)for(var s=0;s<i.replace.length;s++){var r=i.replace[s];o.push({name:r,original:e[r]}),n.replace(e,r)}return n._extended={object:e,methods:o},n}}]),t}(),Ba=function(){function t(){ba(this,t),this._subscribers={"*":[],add:[],remove:[],update:[]},this.subscribe=t.prototype.on,this.unsubscribe=t.prototype.off}return xa(t,[{key:"_trigger",value:function(t,e,i){var n,o;if("*"===t)throw new Error("Cannot trigger event *");mn(n=Pn(o=[]).call(o,mo(this._subscribers[t]),mo(this._subscribers["*"]))).call(n,(function(n){n(t,e,null!=i?i:null)}))}},{key:"on",value:function(t,e){"function"==typeof e&&this._subscribers[t].push(e)}},{key:"off",value:function(t,e){var i;this._subscribers[t]=En(i=this._subscribers[t]).call(i,(function(t){return t!==e}))}}]),t}(),Oa=function(){function t(e){ba(this,t),this._pairs=e}return xa(t,[{key:Yr,value:Tr.mark((function t(){var e,i,n,o,s,r,a,l;return Tr.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:e=!0,i=!1,n=void 0,t.prev=3,o=Fi(this._pairs);case 5:if(e=(s=o.next()).done){t.next=12;break}return r=Po(s.value,2),a=r[0],l=r[1],t.next=9,[a,l];case 9:e=!0,t.next=5;break;case 12:t.next=18;break;case 14:t.prev=14,t.t0=t.catch(3),i=!0,n=t.t0;case 18:t.prev=18,t.prev=19,e||null==o.return||o.return();case 21:if(t.prev=21,!i){t.next=24;break}throw n;case 24:return t.finish(21);case 25:return t.finish(18);case 26:case"end":return t.stop()}}),t,this,[[3,14,18,26],[19,,21,25]])}))},{key:"entries",value:Tr.mark((function t(){var e,i,n,o,s,r,a,l;return Tr.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:e=!0,i=!1,n=void 0,t.prev=3,o=Fi(this._pairs);case 5:if(e=(s=o.next()).done){t.next=12;break}return r=Po(s.value,2),a=r[0],l=r[1],t.next=9,[a,l];case 9:e=!0,t.next=5;break;case 12:t.next=18;break;case 14:t.prev=14,t.t0=t.catch(3),i=!0,n=t.t0;case 18:t.prev=18,t.prev=19,e||null==o.return||o.return();case 21:if(t.prev=21,!i){t.next=24;break}throw n;case 24:return t.finish(21);case 25:return t.finish(18);case 26:case"end":return t.stop()}}),t,this,[[3,14,18,26],[19,,21,25]])}))},{key:"keys",value:Tr.mark((function t(){var e,i,n,o,s,r,a;return Tr.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:e=!0,i=!1,n=void 0,t.prev=3,o=Fi(this._pairs);case 5:if(e=(s=o.next()).done){t.next=12;break}return r=Po(s.value,1),a=r[0],t.next=9,a;case 9:e=!0,t.next=5;break;case 12:t.next=18;break;case 14:t.prev=14,t.t0=t.catch(3),i=!0,n=t.t0;case 18:t.prev=18,t.prev=19,e||null==o.return||o.return();case 21:if(t.prev=21,!i){t.next=24;break}throw n;case 24:return t.finish(21);case 25:return t.finish(18);case 26:case"end":return t.stop()}}),t,this,[[3,14,18,26],[19,,21,25]])}))},{key:"values",value:Tr.mark((function t(){var e,i,n,o,s,r,a;return Tr.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:e=!0,i=!1,n=void 0,t.prev=3,o=Fi(this._pairs);case 5:if(e=(s=o.next()).done){t.next=12;break}return r=Po(s.value,2),a=r[1],t.next=9,a;case 9:e=!0,t.next=5;break;case 12:t.next=18;break;case 14:t.prev=14,t.t0=t.catch(3),i=!0,n=t.t0;case 18:t.prev=18,t.prev=19,e||null==o.return||o.return();case 21:if(t.prev=21,!i){t.next=24;break}throw n;case 24:return t.finish(21);case 25:return t.finish(18);case 26:case"end":return t.stop()}}),t,this,[[3,14,18,26],[19,,21,25]])}))},{key:"toIdArray",value:function(){var t;return Ln(t=mo(this._pairs)).call(t,(function(t){return t[0]}))}},{key:"toItemArray",value:function(){var t;return Ln(t=mo(this._pairs)).call(t,(function(t){return t[1]}))}},{key:"toEntryArray",value:function(){return mo(this._pairs)}},{key:"toObjectMap",value:function(){var t=Oi(null),e=!0,i=!1,n=void 0;try{for(var o,s=Fi(this._pairs);!(e=(o=s.next()).done);e=!0){var r=Po(o.value,2),a=r[0],l=r[1];t[a]=l}}catch(t){i=!0,n=t}finally{try{e||null==s.return||s.return()}finally{if(i)throw n}}return t}},{key:"toMap",value:function(){return new Xr(this._pairs)}},{key:"toIdSet",value:function(){return new Ar(this.toIdArray())}},{key:"toItemSet",value:function(){return new Ar(this.toItemArray())}},{key:"cache",value:function(){return new t(mo(this._pairs))}},{key:"distinct",value:function(t){var e=new Ar,i=!0,n=!1,o=void 0;try{for(var s,r=Fi(this._pairs);!(i=(s=r.next()).done);i=!0){var a=Po(s.value,2),l=a[0],h=a[1];e.add(t(h,l))}}catch(t){n=!0,o=t}finally{try{i||null==r.return||r.return()}finally{if(n)throw o}}return e}},{key:"filter",value:function(e){var i=this._pairs;return new t(Ai({},Yr,Tr.mark((function t(){var n,o,s,r,a,l,h,d;return Tr.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:n=!0,o=!1,s=void 0,t.prev=3,r=Fi(i);case 5:if(n=(a=r.next()).done){t.next=13;break}if(l=Po(a.value,2),h=l[0],d=l[1],!e(d,h)){t.next=10;break}return t.next=10,[h,d];case 10:n=!0,t.next=5;break;case 13:t.next=19;break;case 15:t.prev=15,t.t0=t.catch(3),o=!0,s=t.t0;case 19:t.prev=19,t.prev=20,n||null==r.return||r.return();case 22:if(t.prev=22,!o){t.next=25;break}throw s;case 25:return t.finish(22);case 26:return t.finish(19);case 27:case"end":return t.stop()}}),t,null,[[3,15,19,27],[20,,22,26]])}))))}},{key:"forEach",value:function(t){var e=!0,i=!1,n=void 0;try{for(var o,s=Fi(this._pairs);!(e=(o=s.next()).done);e=!0){var r=Po(o.value,2),a=r[0];t(r[1],a)}}catch(t){i=!0,n=t}finally{try{e||null==s.return||s.return()}finally{if(i)throw n}}}},{key:"map",value:function(e){var i=this._pairs;return new t(Ai({},Yr,Tr.mark((function t(){var n,o,s,r,a,l,h,d;return Tr.wrap((function(t){for(;;)switch(t.prev=t.next){case 0:n=!0,o=!1,s=void 0,t.prev=3,r=Fi(i);case 5:if(n=(a=r.next()).done){t.next=12;break}return l=Po(a.value,2),h=l[0],d=l[1],t.next=9,[h,e(d,h)];case 9:n=!0,t.next=5;break;case 12:t.next=18;break;case 14:t.prev=14,t.t0=t.catch(3),o=!0,s=t.t0;case 18:t.prev=18,t.prev=19,n||null==r.return||r.return();case 21:if(t.prev=21,!o){t.next=24;break}throw s;case 24:return t.finish(21);case 25:return t.finish(18);case 26:case"end":return t.stop()}}),t,null,[[3,14,18,26],[19,,21,25]])}))))}},{key:"max",value:function(t){var e=Fi(this._pairs),i=e.next();if(i.done)return null;for(var n=i.value[1],o=t(i.value[1],i.value[0]);!(i=e.next()).done;){var s=Po(i.value,2),r=s[0],a=s[1],l=t(a,r);l>o&&(o=l,n=a)}return n}},{key:"min",value:function(t){var e=Fi(this._pairs),i=e.next();if(i.done)return null;for(var n=i.value[1],o=t(i.value[1],i.value[0]);!(i=e.next()).done;){var s=Po(i.value,2),r=s[0],a=s[1],l=t(a,r);l<o&&(o=l,n=a)}return n}},{key:"reduce",value:function(t,e){var i=!0,n=!1,o=void 0;try{for(var s,r=Fi(this._pairs);!(i=(s=r.next()).done);i=!0){var a=Po(s.value,2),l=a[0];e=t(e,a[1],l)}}catch(t){n=!0,o=t}finally{try{i||null==r.return||r.return()}finally{if(n)throw o}}return e}},{key:"sort",value:function(e){var i=this;return new t(Ai({},Yr,(function(){var t;return Fi(wr(t=mo(i._pairs)).call(t,(function(t,i){var n=Po(t,2),o=n[0],s=n[1],r=Po(i,2),a=r[0],l=r[1];return e(s,l,o,a)})))})))}}]),t}(),Wa=function(){console.warn("Type coercion has been deprecated. Please, use data pipes instead. See https://visjs.github.io/vis-data/data/datapipe.html#TypeCoercion for more details with working migration example.")},Aa=function(t){function e(t,i){var n;if(ba(this,e),n=ar(this,dr(e).call(this)),t&&!Zo(t)&&(i=t,t=[]),n._options=i||{},n._data=new Xr,n.length=0,n._idProp=n._options.fieldId||"id",n._type={},n._options.type){Wa();for(var o=Yi(n._options.type),s=0,r=o.length;s<r;s++){var a=o[s],l=n._options.type[a];n._type[a]="Date"==l||"ISODate"==l||"ASPDate"==l?"Date":l}}return t&&t.length&&n.add(t),n.setOptions(i),n}return pr(e,t),xa(e,[{key:"setOptions",value:function(t){t&&void 0!==t.queue&&(!1===t.queue?this._queue&&(this._queue.destroy(),delete this._queue):(this._queue||(this._queue=Za.extend(this,{replace:["add","update","remove"]})),t.queue&&"object"===zo(t.queue)&&this._queue.setOptions(t.queue)))}},{key:"add",value:function(t,e){var i,n=this,o=[];if(Zo(t)){var s=Ln(t).call(t,(function(t){return t[n._idProp]}));if(rr(s).call(s,(function(t){return n._data.has(t)})))throw new Error("A duplicate id was found in the parameter array.");for(var r=0,a=t.length;r<a;r++)i=this._addItem(t[r]),o.push(i)}else{if(!t||"object"!==zo(t))throw new Error("Unknown dataType");i=this._addItem(t),o.push(i)}return o.length&&this._trigger("add",{items:o},e),o}},{key:"update",value:function(t,e){var i=this,n=[],o=[],s=[],r=[],a=this._idProp,l=function(t){var e=t[a];if(null!=e&&i._data.has(e)){var l=t,h=Ao({},i._data.get(e)),d=i._updateItem(l);o.push(d),r.push(l),s.push(h)}else{var u=i._addItem(t);n.push(u)}};if(Zo(t))for(var h=0,d=t.length;h<d;h++)t[h]&&"object"===zo(t[h])?l(t[h]):console.warn("Ignoring input item, which is not an object at index "+h);else{if(!t||"object"!==zo(t))throw new Error("Unknown dataType");l(t)}if(n.length&&this._trigger("add",{items:n},e),o.length){var u={items:o,oldData:s,data:r};this._trigger("update",u,e)}return Pn(n).call(n,o)}},{key:"updateOnly",value:function(t,e){var i,n=this;Zo(t)||(t=[t]);var o=Ln(i=Ln(t).call(t,(function(t){var e=n._data.get(t[n._idProp]);if(null==e)throw new Error("Updating non-existent items is not allowed.");return{oldData:e,update:t}}))).call(i,(function(t){var e=t.oldData,i=t.update,o=e[n._idProp],s=ds(ds({},e),i);return n._data.set(o,s),{id:o,oldData:e,updatedData:s}}));if(o.length){var s={items:Ln(o).call(o,(function(t){return t.id})),oldData:Ln(o).call(o,(function(t){return t.oldData})),data:Ln(o).call(o,(function(t){return t.updatedData}))};return this._trigger("update",s,e),s.items}return[]}},{key:"get",value:function(t,e){var i=void 0,n=void 0,o=void 0;Fa(t)?(i=t,o=e):Zo(t)?(n=t,o=e):o=t;var s=o&&"Object"===o.returnType?"Object":"Array",r=o&&o.type||this._options.type,a=o&&En(o),l=[],h=null,d=null,u=null;if(null!=i)(h=this._getItem(i,r))&&a&&!a(h)&&(h=null);else if(null!=n)for(var c=0,p=n.length;c<p;c++)null==(h=this._getItem(n[c],r))||a&&!a(h)||l.push(h);else for(var m,f=0,g=(d=mo(tr(m=this._data).call(m))).length;f<g;f++)u=d[f],null==(h=this._getItem(u,r))||a&&!a(h)||l.push(h);if(o&&o.order&&null==i&&this._sort(l,o.order),o&&o.fields){var v=o.fields;if(null!=i&&null!=h)h=this._filterFields(h,v);else for(var b=0,y=l.length;b<y;b++)l[b]=this._filterFields(l[b],v)}if("Object"==s){for(var x={},w=0,_=l.length;w<_;w++){var k=l[w];x[k[this._idProp]]=k}return x}return null!=i?h:l}},{key:"getIds",value:function(t){var e,i,n=this._data,o=t&&En(t),s=t&&t.order,r=t&&t.type||this._options.type,a=mo(tr(n).call(n)),l=[];if(o)if(s){i=[];for(var h=0,d=a.length;h<d;h++){var u=a[h];o(e=this._getItem(u,r))&&i.push(e)}this._sort(i,s);for(var c=0,p=i.length;c<p;c++)l.push(i[c][this._idProp])}else for(var m=0,f=a.length;m<f;m++){var g=a[m];o(e=this._getItem(g,r))&&l.push(e[this._idProp])}else if(s){i=[];for(var v=0,b=a.length;v<b;v++){var y=a[v];i.push(n.get(y))}this._sort(i,s);for(var x=0,w=i.length;x<w;x++)l.push(i[x][this._idProp])}else for(var _=0,k=a.length;_<k;_++){var D=a[_];e=n.get(D),l.push(e[this._idProp])}return l}},{key:"getDataSet",value:function(){return this}},{key:"forEach",value:function(t,e){var i=e&&En(e),n=e&&e.type||this._options.type,o=this._data,s=mo(tr(o).call(o));if(e&&e.order)for(var r=this.get(e),a=0,l=r.length;a<l;a++){var h=r[a];t(h,h[this._idProp])}else for(var d=0,u=s.length;d<u;d++){var c=s[d],p=this._getItem(c,n);i&&!i(p)||t(p,c)}}},{key:"map",value:function(t,e){for(var i=e&&En(e),n=e&&e.type||this._options.type,o=[],s=this._data,r=mo(tr(s).call(s)),a=0,l=r.length;a<l;a++){var h=r[a],d=this._getItem(h,n);i&&!i(d)||o.push(t(d,h))}return e&&e.order&&this._sort(o,e.order),o}},{key:"_filterFields",value:function(t,e){var i;return t?da(i=Zo(e)?e:Yi(e)).call(i,(function(e,i){return e[i]=t[i],e}),{}):t}},{key:"_sort",value:function(t,e){if("string"==typeof e){var i=e;wr(t).call(t,(function(t,e){var n=t[i],o=e[i];return n>o?1:n<o?-1:0}))}else{if("function"!=typeof e)throw new TypeError("Order must be a function or a string");wr(t).call(t,e)}}},{key:"remove",value:function(t,e){for(var i=[],n=[],o=Zo(t)?t:[t],s=0,r=o.length;s<r;s++){var a=this._remove(o[s]);if(a){var l=a[this._idProp];null!=l&&(i.push(l),n.push(a))}}return i.length&&this._trigger("remove",{items:i,oldData:n},e),i}},{key:"_remove",value:function(t){var e;if(Fa(t)?e=t:t&&"object"===zo(t)&&(e=t[this._idProp]),null!=e&&this._data.has(e)){var i=this._data.get(e)||null;return this._data.delete(e),--this.length,i}return null}},{key:"clear",value:function(t){for(var e,i=mo(tr(e=this._data).call(e)),n=[],o=0,s=i.length;o<s;o++)n.push(this._data.get(i[o]));return this._data.clear(),this.length=0,this._trigger("remove",{items:i,oldData:n},t),i}},{key:"max",value:function(t){var e=null,i=null,n=!0,o=!1,s=void 0;try{for(var r,a=Fi(Js(l=this._data).call(l));!(n=(r=a.next()).done);n=!0){var l,h=r.value,d=h[t];"number"==typeof d&&(null==i||d>i)&&(e=h,i=d)}}catch(t){o=!0,s=t}finally{try{n||null==a.return||a.return()}finally{if(o)throw s}}return e||null}},{key:"min",value:function(t){var e=null,i=null,n=!0,o=!1,s=void 0;try{for(var r,a=Fi(Js(l=this._data).call(l));!(n=(r=a.next()).done);n=!0){var l,h=r.value,d=h[t];"number"==typeof d&&(null==i||d<i)&&(e=h,i=d)}}catch(t){o=!0,s=t}finally{try{n||null==a.return||a.return()}finally{if(o)throw s}}return e||null}},{key:"distinct",value:function(t){for(var e=this._data,i=mo(tr(e).call(e)),n=[],o=this._options.type&&this._options.type[t]||null,s=0,r=0,a=i.length;r<a;r++){for(var l=i[r],h=e.get(l)[t],d=!1,u=0;u<s;u++)if(n[u]==h){d=!0;break}d||void 0===h||(n[s]=h,s++)}if(o)for(var c=0,p=n.length;c<p;c++)n[c]=Na(n[c],o);return n}},{key:"_addItem",value:function(t){var e=t[this._idProp];if(null!=e){if(this._data.has(e))throw new Error("Cannot add item: item with id "+e+" already exists")}else e=Ma(),t[this._idProp]=e;for(var i={},n=Yi(t),o=0,s=n.length;o<s;o++){var r=n[o],a=this._type[r];i[r]=Na(t[r],a)}return this._data.set(e,i),++this.length,e}},{key:"_getItem",value:function(t,e){var i,n=this._data.get(t);if(!n)return null;var o=Yi(n);if(e){Wa(),i={};for(var s=0,r=o.length;s<r;s++){var a=o[s],l=n[a];i[a]=Na(l,e[a])}}else i=function(t){for(var e=1;e<arguments.length;e++){var i,n=null!=arguments[e]?arguments[e]:{};if(e%2)mn(i=wa(Object(n),!0)).call(i,(function(e){Ai(t,e,n[e])}));else if(yt)ut(t,yt(n));else{var o;mn(o=wa(Object(n))).call(o,(function(e){H(t,e,kt(n,e))}))}}return t}({},n);return null==i[this._idProp]&&(i[this._idProp]=n.id),i}},{key:"_updateItem",value:function(t){var e=t[this._idProp];if(null==e)throw new Error("Cannot update item: item has no id (item: "+Vs(t)+")");var i=this._data.get(e);if(!i)throw new Error("Cannot update item: no item with id "+e+" found");for(var n=Yi(t),o=0,s=n.length;o<s;o++){var r=n[o],a=this._type[r];i[r]=Na(t[r],a)}return e}},{key:"stream",value:function(t){if(t){var e=this._data;return new Oa(Ai({},Yr,Tr.mark((function i(){var n,o,s,r,a,l,h;return Tr.wrap((function(i){for(;;)switch(i.prev=i.next){case 0:n=!0,o=!1,s=void 0,i.prev=3,r=Fi(t);case 5:if(n=(a=r.next()).done){i.next=14;break}if(l=a.value,null==(h=e.get(l))){i.next=11;break}return i.next=11,[l,h];case 11:n=!0,i.next=5;break;case 14:i.next=20;break;case 16:i.prev=16,i.t0=i.catch(3),o=!0,s=i.t0;case 20:i.prev=20,i.prev=21,n||null==r.return||r.return();case 23:if(i.prev=23,!o){i.next=26;break}throw s;case 26:return i.finish(23);case 27:return i.finish(20);case 28:case"end":return i.stop()}}),i,null,[[3,16,20,28],[21,,23,27]])}))))}var i;return new Oa(Ai({},Yr,va(i=Xs(this._data)).call(i,this._data)))}}]),e}(Ba),Xa=function(t){function e(t,i){var n,o;return ba(this,e),(o=ar(this,dr(e).call(this))).length=0,o._ids=new Ar,o._options=i||{},o._listener=va(n=o._onEvent).call(n,Bs(o)),o.setData(t),o}return pr(e,t),xa(e,[{key:"setData",value:function(t){if(this._data){this._data.off&&this._data.off("*",this._listener);var e=this._data.getIds({filter:En(this._options)}),i=this._data.get(e);this._ids.clear(),this.length=0,this._trigger("remove",{items:e,oldData:i})}if(null!=t){this._data=t;for(var n=this._data.getIds({filter:En(this._options)}),o=0,s=n.length;o<s;o++){var r=n[o];this._ids.add(r)}this.length=n.length,this._trigger("add",{items:n})}else this._data=new Aa;this._data.on&&this._data.on("*",this._listener)}},{key:"refresh",value:function(){for(var t=this._data.getIds({filter:En(this._options)}),e=mo(this._ids),i={},n=[],o=[],s=[],r=0,a=t.length;r<a;r++){var l=t[r];i[l]=!0,this._ids.has(l)||(n.push(l),this._ids.add(l))}for(var h=0,d=e.length;h<d;h++){var u=e[h],c=this._data.get(u);null==c?console.error("If you see this, report it please."):i[u]||(o.push(u),s.push(c),this._ids.delete(u))}this.length+=n.length-o.length,n.length&&this._trigger("add",{items:n}),o.length&&this._trigger("remove",{items:o,oldData:s})}},{key:"get",value:function(t,e){if(null==this._data)return null;var i,n=null;Fa(t)||Zo(t)?(n=t,i=e):i=t;var o=Ao({},this._options,i),s=En(this._options),r=i&&En(i);return s&&r&&(o.filter=function(t){return s(t)&&r(t)}),null==n?this._data.get(o):this._data.get(n,o)}},{key:"getIds",value:function(t){if(this._data.length){var e,i=En(this._options),n=null!=t?En(t):null;return e=n?i?function(t){return i(t)&&n(t)}:n:i,this._data.getIds({filter:e,order:t&&t.order})}return[]}},{key:"forEach",value:function(t,e){if(this._data){var i,n,o=En(this._options),s=e&&En(e);n=s?o?function(t){return o(t)&&s(t)}:s:o,mn(i=this._data).call(i,t,{filter:n,order:e&&e.order})}}},{key:"map",value:function(t,e){if(this._data){var i,n,o=En(this._options),s=e&&En(e);return n=s?o?function(t){return o(t)&&s(t)}:s:o,Ln(i=this._data).call(i,t,{filter:n,order:e&&e.order})}return[]}},{key:"getDataSet",value:function(){return this._data.getDataSet()}},{key:"stream",value:function(t){var e;return this._data.stream(t||Ai({},Yr,va(e=tr(this._ids)).call(e,this._ids)))}},{key:"dispose",value:function(){var t;(null===(t=this._data)||void 0===t?void 0:t.off)&&this._data.off("*",this._listener);var e="This data view has already been disposed of.";H(this,"_data",{get:function(){throw new Error(e)},set:function(){throw new Error(e)},configurable:!1})}},{key:"_onEvent",value:function(t,e,i){if(e&&e.items&&this._data){var n=e.items,o=[],s=[],r=[],a=[],l=[],h=[];switch(t){case"add":for(var d=0,u=n.length;d<u;d++){var c=n[d];this.get(c)&&(this._ids.add(c),o.push(c))}break;case"update":for(var p=0,m=n.length;p<m;p++){var f=n[p];this.get(f)?this._ids.has(f)?(s.push(f),l.push(e.data[p]),a.push(e.oldData[p])):(this._ids.add(f),o.push(f)):this._ids.has(f)&&(this._ids.delete(f),r.push(f),h.push(e.oldData[p]))}break;case"remove":for(var g=0,v=n.length;g<v;g++){var b=n[g];this._ids.has(b)&&(this._ids.delete(b),r.push(b),h.push(e.oldData[g]))}}this.length+=o.length-r.length,o.length&&this._trigger("add",{items:o},i),s.length&&this._trigger("update",{items:s,oldData:a,data:l},i),r.length&&this._trigger("remove",{items:r,oldData:h},i)}}}]),e}(Ba),Ta="undefined"!=typeof window&&window.moment||s;function Ya(t,e){var i=Yi(t);if(si){var n=si(t);e&&(n=En(n).call(n,(function(e){return kt(t,e).enumerable}))),i.push.apply(i,n)}return i}var Ea=/^\/?Date\((-?\d+)/i;function Ra(t,e){var i;if(void 0!==t){if(null===t)return null;if(!e)return t;if("string"!=typeof e&&!(e instanceof String))throw new Error("Type must be a string");switch(e){case"boolean":case"Boolean":return Boolean(t);case"number":case"Number":return rs(t)&&!isNaN(Date.parse(t))?s(t).valueOf():Number(t.valueOf());case"string":case"String":return String(t);case"Date":if(ss(t))return new Date(t);if(t instanceof Date)return new Date(t.valueOf());if(s.isMoment(t))return new Date(t.valueOf());if(rs(t))return(i=Ea.exec(t))?new Date(Number(i[1])):s(new Date(t)).toDate();throw new Error("Cannot convert object of type "+us(t)+" to type Date");case"Moment":if(ss(t))return s(t);if(t instanceof Date)return s(t.valueOf());if(s.isMoment(t))return s(t);if(rs(t))return i=Ea.exec(t),s(i?Number(i[1]):t);throw new Error("Cannot convert object of type "+us(t)+" to type Date");case"ISODate":if(ss(t))return new Date(t);if(t instanceof Date)return t.toISOString();if(s.isMoment(t))return t.toDate().toISOString();if(rs(t))return(i=Ea.exec(t))?new Date(Number(i[1])).toISOString():s(t).format();throw new Error("Cannot convert object of type "+us(t)+" to type ISODate");case"ASPDate":if(ss(t))return"/Date("+t+")/";if(t instanceof Date||s.isMoment(t))return"/Date("+t.valueOf()+")/";if(rs(t))return"/Date("+((i=Ea.exec(t))?new Date(Number(i[1])).valueOf():new Date(t).valueOf())+")/";throw new Error("Cannot convert object of type "+us(t)+" to type ASPDate");default:throw new Error("Unknown type ".concat(e))}}}function Ua(t){var e,i,n,o,s,r,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{start:"Date",end:"Date"},l=t._idProp,h=new Aa({fieldId:l}),d=Ln(e=_a(t)).call(e,(function(t){var e;return da(e=Yi(t)).call(e,(function(e,i){return e[i]=Ra(t[i],a[i]),e}),{})})).to(h);return d.all().start(),{add:function(){var e;return(e=t.getDataSet()).add.apply(e,arguments)},remove:function(){var e;return(e=t.getDataSet()).remove.apply(e,arguments)},update:function(){var e;return(e=t.getDataSet()).update.apply(e,arguments)},updateOnly:function(){var e;return(e=t.getDataSet()).updateOnly.apply(e,arguments)},forEach:va(i=mn(h)).call(i,h),get:va(n=h.get).call(n,h),getIds:va(o=h.getIds).call(o,h),off:va(s=h.off).call(s,h),on:va(r=h.on).call(r,h),get length(){return h.length},idProp:l,type:a,rawDS:t,coercedDS:h,dispose:function(){return d.stop()}}}var za=function(t){for(var e=1;e<arguments.length;e++){var i,n=null!=arguments[e]?arguments[e]:{};if(e%2)mn(i=Ya(Object(n),!0)).call(i,(function(e){Ai(t,e,n[e])}));else if(yt)ut(t,yt(n));else{var o;mn(o=Ya(Object(n))).call(o,(function(e){H(t,e,kt(n,e))}))}}return t}({},Is,{convert:Ra}),Va=ji.trim,ja=a.parseFloat,Ha=1/ja(Ei+"-0")!=-1/0?function(t){var e=Va(String(t)),i=ja(e);return 0===i&&"-"==e.charAt(0)?-0:i}:ja;V({global:!0,forced:parseFloat!=Ha},{parseFloat:Ha});var Pa=W.parseFloat,Ja=function(){function t(e,i){ba(this,t),this.options=null,this.props=null}return xa(t,[{key:"setOptions",value:function(t){t&&za.extend(this.options,t)}},{key:"redraw",value:function(){return!1}},{key:"destroy",value:function(){}},{key:"_isResized",value:function(){var t=this.props._previousWidth!==this.props.width||this.props._previousHeight!==this.props.height;return this.props._previousWidth=this.props.width,this.props._previousHeight=this.props.height,t}}]),t}();V({target:"String",proto:!0},{repeat:"".repeat||function(t){var e=String(b(this)),i="",n=K(t);if(n<0||n==1/0)throw RangeError("Wrong number of repetitions");for(;n>0;(n>>>=1)&&(e+=e))1&n&&(i+=e);return i}});var Ka=Pi("String").repeat,qa=String.prototype,$a=function(t){var e=t.repeat;return"string"==typeof t||t===qa||t instanceof String&&e===qa.repeat?Ka:e};function tl(t,e,i){if(i&&!Zo(i))return tl(t,e,[i]);if(e.hiddenDates=[],i&&1==Zo(i)){for(var n,o=0;o<i.length;o++)if(void 0===$a(i[o])){var s={};s.start=t(i[o].start).toDate().valueOf(),s.end=t(i[o].end).toDate().valueOf(),e.hiddenDates.push(s)}wr(n=e.hiddenDates).call(n,(function(t,e){return t.start-e.start}))}}function el(t,e,i){if(i&&!Zo(i))return el(t,e,[i]);if(i&&void 0!==e.domProps.centerContainer.width){tl(t,e,i);for(var n=t(e.range.start),o=t(e.range.end),s=(e.range.end-e.range.start)/e.domProps.centerContainer.width,r=0;r<i.length;r++)if(void 0!==$a(i[r])){var a=t(i[r].start),l=t(i[r].end);if("Invalid Date"==a._d)throw new Error("Supplied start date is not valid: ".concat(i[r].start));if("Invalid Date"==l._d)throw new Error("Supplied end date is not valid: ".concat(i[r].end));if(l-a>=4*s){var h=0,d=o.clone();switch($a(i[r])){case"daily":a.day()!=l.day()&&(h=1),a.dayOfYear(n.dayOfYear()),a.year(n.year()),a.subtract(7,"days"),l.dayOfYear(n.dayOfYear()),l.year(n.year()),l.subtract(7-h,"days"),d.add(1,"weeks");break;case"weekly":var u=l.diff(a,"days"),c=a.day();a.date(n.date()),a.month(n.month()),a.year(n.year()),l=a.clone(),a.day(c),l.day(c),l.add(u,"days"),a.subtract(1,"weeks"),l.subtract(1,"weeks"),d.add(1,"weeks");break;case"monthly":a.month()!=l.month()&&(h=1),a.month(n.month()),a.year(n.year()),a.subtract(1,"months"),l.month(n.month()),l.year(n.year()),l.subtract(1,"months"),l.add(h,"months"),d.add(1,"months");break;case"yearly":a.year()!=l.year()&&(h=1),a.year(n.year()),a.subtract(1,"years"),l.year(n.year()),l.subtract(1,"years"),l.add(h,"years"),d.add(1,"years");break;default:return void console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:",$a(i[r]))}for(;a<d;)switch(e.hiddenDates.push({start:a.valueOf(),end:l.valueOf()}),$a(i[r])){case"daily":a.add(1,"days"),l.add(1,"days");break;case"weekly":a.add(1,"weeks"),l.add(1,"weeks");break;case"monthly":a.add(1,"months"),l.add(1,"months");break;case"yearly":a.add(1,"y"),l.add(1,"y");break;default:return void console.log("Wrong repeat format, allowed are: daily, weekly, monthly, yearly. Given:",$a(i[r]))}e.hiddenDates.push({start:a.valueOf(),end:l.valueOf()})}}il(e);var p=cl(e.range.start,e.hiddenDates),m=cl(e.range.end,e.hiddenDates),f=e.range.start,g=e.range.end;1==p.hidden&&(f=1==e.range.startToFront?p.startDate-1:p.endDate+1),1==m.hidden&&(g=1==e.range.endToFront?m.startDate-1:m.endDate+1),1!=p.hidden&&1!=m.hidden||e.range._applyRange(f,g)}}function il(t){for(var e,i=t.hiddenDates,n=[],o=0;o<i.length;o++)for(var s=0;s<i.length;s++)o!=s&&1!=i[s].remove&&1!=i[o].remove&&(i[s].start>=i[o].start&&i[s].end<=i[o].end?i[s].remove=!0:i[s].start>=i[o].start&&i[s].start<=i[o].end?(i[o].end=i[s].end,i[s].remove=!0):i[s].end>=i[o].start&&i[s].end<=i[o].end&&(i[o].start=i[s].start,i[s].remove=!0));for(o=0;o<i.length;o++)!0!==i[o].remove&&n.push(i[o]);t.hiddenDates=n,wr(e=t.hiddenDates).call(e,(function(t,e){return t.start-e.start}))}function nl(t,e,i){for(var n=!1,o=e.current.valueOf(),s=0;s<e.hiddenDates.length;s++){var r=e.hiddenDates[s].start,a=e.hiddenDates[s].end;if(o>=r&&o<a){n=!0;break}}if(1==n&&o<e._end.valueOf()&&o!=i){var l=t(i),h=t(a);l.year()!=h.year()?e.switchedYear=!0:l.month()!=h.month()?e.switchedMonth=!0:l.dayOfYear()!=h.dayOfYear()&&(e.switchedDay=!0),e.current=h}}function ol(t,e,i){var n;if(0==t.body.hiddenDates.length)return n=t.range.conversion(i),(e.valueOf()-n.offset)*n.scale;var o=cl(e,t.body.hiddenDates);1==o.hidden&&(e=o.startDate);var s=rl(t.body.hiddenDates,t.range.start,t.range.end);if(e<t.range.start){n=t.range.conversion(i,s);var r=al(t.body.hiddenDates,e,n.offset);return e=t.options.moment(e).toDate().valueOf(),e+=r,-(n.offset-e.valueOf())*n.scale}if(e>t.range.end){var a={start:t.range.start,end:e};return e=ll(t.options.moment,t.body.hiddenDates,a,e),n=t.range.conversion(i,s),(e.valueOf()-n.offset)*n.scale}return e=ll(t.options.moment,t.body.hiddenDates,t.range,e),n=t.range.conversion(i,s),(e.valueOf()-n.offset)*n.scale}function sl(t,e,i){if(0==t.body.hiddenDates.length){var n=t.range.conversion(i);return new Date(e/n.scale+n.offset)}var o=rl(t.body.hiddenDates,t.range.start,t.range.end),s=(t.range.end-t.range.start-o)*e/i,r=dl(t.body.hiddenDates,t.range,s);return new Date(r+s+t.range.start)}function rl(t,e,i){for(var n=0,o=0;o<t.length;o++){var s=t[o].start,r=t[o].end;s>=e&&r<i&&(n+=r-s)}return n}function al(t,e,i){for(var n=0,o=0;o<t.length;o++){var s=t[o].start,r=t[o].end;s>=e&&r<=i&&(n+=r-s)}return n}function ll(t,e,i,n){return n=t(n).toDate().valueOf(),n-=hl(t,e,i,n)}function hl(t,e,i,n){var o=0;n=t(n).toDate().valueOf();for(var s=0;s<e.length;s++){var r=e[s].start,a=e[s].end;r>=i.start&&a<i.end&&n>=a&&(o+=a-r)}return o}function dl(t,e,i){for(var n=0,o=0,s=e.start,r=0;r<t.length;r++){var a=t[r].start,l=t[r].end;if(a>=e.start&&l<e.end){if(o+=a-s,s=l,o>=i)break;n+=l-a}}return n}function ul(t,e,i,n){var o=cl(e,t);return 1==o.hidden?i<0?1==n?o.startDate-(o.endDate-e)-1:o.startDate-1:1==n?o.endDate+(e-o.startDate)+1:o.endDate+1:e}function cl(t,e){for(var i=0;i<e.length;i++){var n=e[i].start,o=e[i].end;if(t>=n&&t<o)return{hidden:!0,startDate:n,endDate:o}}return{hidden:!1,startDate:n,endDate:o}}var pl=Object.freeze({__proto__:null,convertHiddenOptions:tl,updateHiddenDates:el,removeDuplicates:il,printDates:function(t){for(var e=0;e<t.length;e++)console.log(e,new Date(t[e].start),new Date(t[e].end),t[e].start,t[e].end,t[e].remove)},stepOverHiddenDates:nl,toScreen:ol,toTime:sl,getHiddenDurationBetween:rl,getHiddenDurationBeforeStart:al,correctTimeForHidden:ll,getHiddenDurationBefore:hl,getAccumulatedHiddenDuration:dl,snapAwayFromHidden:ul,getIsHidden:cl}),ml=function(t){function e(t,i){var n,o,s,r,a,l,h,d;ba(this,e),d=ar(this,dr(e).call(this));var u=Ta().hours(0).minutes(0).seconds(0).milliseconds(0),c=u.clone().add(-3,"days").valueOf(),p=u.clone().add(3,"days").valueOf();return d.millisecondsPerPixelCache=void 0,void 0===i?(d.start=c,d.end=p):(d.start=i.start||c,d.end=i.end||p),d.rolling=!1,d.body=t,d.deltaDifference=0,d.scaleOffset=0,d.startToFront=!1,d.endToFront=!0,d.defaultOptions={rtl:!1,start:null,end:null,moment:Ta,direction:"horizontal",moveable:!0,zoomable:!0,min:null,max:null,zoomMin:10,zoomMax:31536e10,rollingMode:{follow:!1,offset:.5}},d.options=za.extend({},d.defaultOptions),d.props={touch:{}},d.animationTimer=null,d.body.emitter.on("panstart",va(n=d._onDragStart).call(n,Bs(d))),d.body.emitter.on("panmove",va(o=d._onDrag).call(o,Bs(d))),d.body.emitter.on("panend",va(s=d._onDragEnd).call(s,Bs(d))),d.body.emitter.on("mousewheel",va(r=d._onMouseWheel).call(r,Bs(d))),d.body.emitter.on("touch",va(a=d._onTouch).call(a,Bs(d))),d.body.emitter.on("pinch",va(l=d._onPinch).call(l,Bs(d))),d.body.dom.rollingModeBtn.addEventListener("click",va(h=d.startRolling).call(h,Bs(d))),d.setOptions(i),d}return pr(e,t),xa(e,[{key:"setOptions",value:function(t){if(t){za.selectiveExtend(["animation","direction","min","max","zoomMin","zoomMax","moveable","zoomable","moment","activate","hiddenDates","zoomKey","zoomFriction","rtl","showCurrentTime","rollingMode","horizontalScroll"],this.options,t),t.rollingMode&&t.rollingMode.follow&&this.startRolling(),("start"in t||"end"in t)&&this.setRange(t.start,t.end)}}},{key:"startRolling",value:function(){var t=this;!function e(){t.stopRolling(),t.rolling=!0;var i=t.end-t.start,n=za.convert(new Date,"Date").valueOf(),o=t.options.rollingMode&&t.options.rollingMode.offset||.5,s=n-i*o,r=n+i*(1-o);t.setRange(s,r,{animation:!1}),(i=1/t.conversion(t.body.domProps.center.width).scale/10)<30&&(i=30),i>1e3&&(i=1e3),t.body.dom.rollingModeBtn.style.visibility="hidden",t.currentTimeTimer=qr(e,i)}()}},{key:"stopRolling",value:function(){void 0!==this.currentTimeTimer&&(clearTimeout(this.currentTimeTimer),this.rolling=!1,this.body.dom.rollingModeBtn.style.visibility="visible")}},{key:"setRange",value:function(t,e,i,n,o){i||(i={}),!0!==i.byUser&&(i.byUser=!1);var s=this,r=null!=t?za.convert(t,"Date").valueOf():null,a=null!=e?za.convert(e,"Date").valueOf():null;if(this._cancelAnimation(),this.millisecondsPerPixelCache=void 0,i.animation){var l,h=this.start,d=this.end,u="object"===zo(i.animation)&&"duration"in i.animation?i.animation.duration:500,c="object"===zo(i.animation)&&"easingFunction"in i.animation?i.animation.easingFunction:"easeInOutQuad",p=za.easingFunctions[c];if(!p)throw new Error(Pn(l="Unknown easing function ".concat(Vs(c),". Choose from: ")).call(l,Yi(za.easingFunctions).join(", ")));var m=Jo(),f=!1;return function t(){if(!s.props.touch.dragging){var e=Jo()-m,l=p(e/u),c=e>u,v=c||null===r?r:h+(r-h)*l,b=c||null===a?a:d+(a-d)*l;g=s._applyRange(v,b),el(s.options.moment,s.body,s.options.hiddenDates),f=f||g;var y={start:new Date(s.start),end:new Date(s.end),byUser:i.byUser,event:i.event};if(o&&o(l,g,c),g&&s.body.emitter.emit("rangechange",y),c){if(f&&(s.body.emitter.emit("rangechanged",y),n))return n()}else s.animationTimer=qr(t,20)}}()}var g=this._applyRange(r,a);if(el(this.options.moment,this.body,this.options.hiddenDates),g){var v={start:new Date(this.start),end:new Date(this.end),byUser:i.byUser,event:i.event};if(this.body.emitter.emit("rangechange",v),clearTimeout(s.timeoutID),s.timeoutID=qr((function(){s.body.emitter.emit("rangechanged",v)}),200),n)return n()}}},{key:"getMillisecondsPerPixel",value:function(){return void 0===this.millisecondsPerPixelCache&&(this.millisecondsPerPixelCache=(this.end-this.start)/this.body.dom.center.clientWidth),this.millisecondsPerPixelCache}},{key:"_cancelAnimation",value:function(){this.animationTimer&&(clearTimeout(this.animationTimer),this.animationTimer=null)}},{key:"_applyRange",value:function(t,e){var i,n=null!=t?za.convert(t,"Date").valueOf():this.start,o=null!=e?za.convert(e,"Date").valueOf():this.end,s=null!=this.options.max?za.convert(this.options.max,"Date").valueOf():null,r=null!=this.options.min?za.convert(this.options.min,"Date").valueOf():null;if(isNaN(n)||null===n)throw new Error('Invalid start "'.concat(t,'"'));if(isNaN(o)||null===o)throw new Error('Invalid end "'.concat(e,'"'));if(o<n&&(o=n),null!==r&&n<r&&(n+=i=r-n,o+=i,null!=s&&o>s&&(o=s)),null!==s&&o>s&&(n-=i=o-s,o-=i,null!=r&&n<r&&(n=r)),null!==this.options.zoomMin){var a=Pa(this.options.zoomMin);if(a<0&&(a=0),o-n<a){this.end-this.start===a&&n>=this.start-.5&&o<=this.end?(n=this.start,o=this.end):(n-=(i=a-(o-n))/2,o+=i/2)}}if(null!==this.options.zoomMax){var l=Pa(this.options.zoomMax);l<0&&(l=0),o-n>l&&(this.end-this.start===l&&n<this.start&&o>this.end?(n=this.start,o=this.end):(n+=(i=o-n-l)/2,o-=i/2))}var h=this.start!=n||this.end!=o;return n>=this.start&&n<=this.end||o>=this.start&&o<=this.end||this.start>=n&&this.start<=o||this.end>=n&&this.end<=o||this.body.emitter.emit("checkRangedItems"),this.start=n,this.end=o,h}},{key:"getRange",value:function(){return{start:this.start,end:this.end}}},{key:"conversion",value:function(t,i){return e.conversion(this.start,this.end,t,i)}},{key:"_onDragStart",value:function(t){this.deltaDifference=0,this.previousDelta=0,this.options.moveable&&this._isInsideRange(t)&&this.props.touch.allowDragging&&(this.stopRolling(),this.props.touch.start=this.start,this.props.touch.end=this.end,this.props.touch.dragging=!0,this.body.dom.root&&(this.body.dom.root.style.cursor="move"))}},{key:"_onDrag",value:function(t){if(t&&this.props.touch.dragging&&this.options.moveable&&this.props.touch.allowDragging){var e=this.options.direction;fl(e);var i="horizontal"==e?t.deltaX:t.deltaY;i-=this.deltaDifference;var n=this.props.touch.end-this.props.touch.start;n-=rl(this.body.hiddenDates,this.start,this.end);var o,s="horizontal"==e?this.body.domProps.center.width:this.body.domProps.center.height;o=this.options.rtl?i/s*n:-i/s*n;var r=this.props.touch.start+o,a=this.props.touch.end+o,l=ul(this.body.hiddenDates,r,this.previousDelta-i,!0),h=ul(this.body.hiddenDates,a,this.previousDelta-i,!0);if(l!=r||h!=a)return this.deltaDifference+=i,this.props.touch.start=l,this.props.touch.end=h,void this._onDrag(t);this.previousDelta=i,this._applyRange(r,a);var d=new Date(this.start),u=new Date(this.end);this.body.emitter.emit("rangechange",{start:d,end:u,byUser:!0,event:t}),this.body.emitter.emit("panmove")}}},{key:"_onDragEnd",value:function(t){this.props.touch.dragging&&this.options.moveable&&this.props.touch.allowDragging&&(this.props.touch.dragging=!1,this.body.dom.root&&(this.body.dom.root.style.cursor="auto"),this.body.emitter.emit("rangechanged",{start:new Date(this.start),end:new Date(this.end),byUser:!0,event:t}))}},{key:"_onMouseWheel",value:function(t){var e=0;if(t.wheelDelta?e=t.wheelDelta/120:t.detail?e=-t.detail/3:t.deltaY&&(e=-t.deltaY/3),!(this.options.zoomKey&&!t[this.options.zoomKey]&&this.options.zoomable||!this.options.zoomable&&this.options.moveable)&&this.options.zoomable&&this.options.moveable&&this._isInsideRange(t)&&e){var i,n,o=this.options.zoomFriction||5;if(i=e<0?1-e/o:1/(1+e/o),this.rolling){var s=this.options.rollingMode&&this.options.rollingMode.offset||.5;n=this.start+(this.end-this.start)*s}else{var r=this.getPointer({x:t.clientX,y:t.clientY},this.body.dom.center);n=this._pointerToDate(r)}this.zoom(i,n,e,t),t.preventDefault()}}},{key:"_onTouch",value:function(t){this.props.touch.start=this.start,this.props.touch.end=this.end,this.props.touch.allowDragging=!0,this.props.touch.center=null,this.props.touch.centerDate=null,this.scaleOffset=0,this.deltaDifference=0,za.preventDefault(t)}},{key:"_onPinch",value:function(t){if(this.options.zoomable&&this.options.moveable){za.preventDefault(t),this.props.touch.allowDragging=!1,this.props.touch.center||(this.props.touch.center=this.getPointer(t.center,this.body.dom.center),this.props.touch.centerDate=this._pointerToDate(this.props.touch.center)),this.stopRolling();var e=1/(t.scale+this.scaleOffset),i=this.props.touch.centerDate,n=rl(this.body.hiddenDates,this.start,this.end),o=hl(this.options.moment,this.body.hiddenDates,this,i),s=n-o,r=i-o+(this.props.touch.start-(i-o))*e,a=i+s+(this.props.touch.end-(i+s))*e;this.startToFront=1-e<=0,this.endToFront=e-1<=0;var l=ul(this.body.hiddenDates,r,1-e,!0),h=ul(this.body.hiddenDates,a,e-1,!0);l==r&&h==a||(this.props.touch.start=l,this.props.touch.end=h,this.scaleOffset=1-t.scale,r=l,a=h);var d={animation:!1,byUser:!0,event:t};this.setRange(r,a,d),this.startToFront=!1,this.endToFront=!0}}},{key:"_isInsideRange",value:function(t){var e=t.center?t.center.x:t.clientX,i=this.body.dom.centerContainer.getBoundingClientRect(),n=this.options.rtl?e-i.left:i.right-e,o=this.body.util.toTime(n);return o>=this.start&&o<=this.end}},{key:"_pointerToDate",value:function(t){var e,i=this.options.direction;if(fl(i),"horizontal"==i)return this.body.util.toTime(t.x).valueOf();var n=this.body.domProps.center.height;return e=this.conversion(n),t.y/e.scale+e.offset}},{key:"getPointer",value:function(t,e){var i=e.getBoundingClientRect();return this.options.rtl?{x:i.right-t.x,y:t.y-i.top}:{x:t.x-i.left,y:t.y-i.top}}},{key:"zoom",value:function(t,e,i,n){null==e&&(e=(this.start+this.end)/2);var o=rl(this.body.hiddenDates,this.start,this.end),s=hl(this.options.moment,this.body.hiddenDates,this,e),r=o-s,a=e-s+(this.start-(e-s))*t,l=e+r+(this.end-(e+r))*t;this.startToFront=!(i>0),this.endToFront=!(-i>0);var h=ul(this.body.hiddenDates,a,i,!0),d=ul(this.body.hiddenDates,l,-i,!0);h==a&&d==l||(a=h,l=d);var u={animation:!1,byUser:!0,event:n};this.setRange(a,l,u),this.startToFront=!1,this.endToFront=!0}},{key:"move",value:function(t){var e=this.end-this.start,i=this.start+e*t,n=this.end+e*t;this.start=i,this.end=n}},{key:"moveTo",value:function(t){var e=(this.start+this.end)/2-t,i=this.start-e,n=this.end-e;this.setRange(i,n,{animation:!1,byUser:!0,event:null})}}],[{key:"conversion",value:function(t,e,i,n){return void 0===n&&(n=0),0!=i&&e-t!=0?{offset:t,scale:i/(e-t-n)}:{offset:0,scale:1}}}]),e}(Ja);function fl(t){if("horizontal"!=t&&"vertical"!=t)throw new TypeError('Unknown direction "'.concat(t,'". Choose "horizontal" or "vertical".'))}var gl=W.setInterval,vl=n((function(t){function e(t){if(t)return function(t){for(var i in e.prototype)t[i]=e.prototype[i];return t}(t)}t.exports=e,e.prototype.on=e.prototype.addEventListener=function(t,e){return this._callbacks=this._callbacks||{},(this._callbacks["$"+t]=this._callbacks["$"+t]||[]).push(e),this},e.prototype.once=function(t,e){function i(){this.off(t,i),e.apply(this,arguments)}return i.fn=e,this.on(t,i),this},e.prototype.off=e.prototype.removeListener=e.prototype.removeAllListeners=e.prototype.removeEventListener=function(t,e){if(this._callbacks=this._callbacks||{},0==arguments.length)return this._callbacks={},this;var i,n=this._callbacks["$"+t];if(!n)return this;if(1==arguments.length)return delete this._callbacks["$"+t],this;for(var o=0;o<n.length;o++)if((i=n[o])===e||i.fn===e){n.splice(o,1);break}return 0===n.length&&delete this._callbacks["$"+t],this},e.prototype.emit=function(t){this._callbacks=this._callbacks||{};for(var e=new Array(arguments.length-1),i=this._callbacks["$"+t],n=1;n<arguments.length;n++)e[n-1]=arguments[n];if(i){n=0;for(var o=(i=i.slice(0)).length;n<o;++n)i[n].apply(this,e)}return this},e.prototype.listeners=function(t){return this._callbacks=this._callbacks||{},this._callbacks["$"+t]||[]},e.prototype.hasListeners=function(t){return!!this.listeners(t).length}})),bl=n((function(t,e){var i;t.exports=(i=null,function t(e,n){var o=n||{preventDefault:!1};if(e.Manager){var s=e,r=function(e,i){var n=Object.create(o);return i&&s.assign(n,i),t(new s(e,n),n)};return s.assign(r,s),r.Manager=function(e,i){var n=Object.create(o);return i&&s.assign(n,i),t(new s.Manager(e,n),n)},r}var a=Object.create(e),l=e.element;function h(t){return t.match(/[^ ]+/g)}function d(t){if("hammer.input"!==t.type){if(t.srcEvent._handled||(t.srcEvent._handled={}),t.srcEvent._handled[t.type])return;t.srcEvent._handled[t.type]=!0}var e=!1;t.stopPropagation=function(){e=!0};var n=t.srcEvent.stopPropagation.bind(t.srcEvent);"function"==typeof n&&(t.srcEvent.stopPropagation=function(){n(),t.stopPropagation()}),t.firstTarget=i;for(var o=i;o&&!e;){var s=o.hammer;if(s)for(var r,a=0;a<s.length;a++)if(r=s[a]._handlers[t.type])for(var l=0;l<r.length&&!e;l++)r[l](t);o=o.parentNode}}return l.hammer||(l.hammer=[]),l.hammer.push(a),e.on("hammer.input",(function(t){!0!==o.preventDefault&&o.preventDefault!==t.pointerType||t.preventDefault(),t.isFirst&&(i=t.target)})),a._handlers={},a.on=function(t,i){return h(t).forEach((function(t){var n=a._handlers[t];n||(a._handlers[t]=n=[],e.on(t,d)),n.push(i)})),a},a.off=function(t,i){return h(t).forEach((function(t){var n=a._handlers[t];n&&((n=i?n.filter((function(t){return t!==i})):[]).length>0?a._handlers[t]=n:(e.off(t,d),delete a._handlers[t]))})),a},a.emit=function(t,n){i=n.target,e.emit(t,n)},a.destroy=function(){var t=e.element.hammer,i=t.indexOf(a);-1!==i&&t.splice(i,1),t.length||delete e.element.hammer,a._handlers={},e.destroy()},a})}));
/*! Hammer.JS - v2.0.17-rc - 2019-12-16
	 * http://naver.github.io/egjs
	 *
	 * Forked By Naver egjs
	 * Copyright (c) hammerjs
	 * Licensed under the MIT license */
function yl(){return(yl=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var i=arguments[e];for(var n in i)Object.prototype.hasOwnProperty.call(i,n)&&(t[n]=i[n])}return t}).apply(this,arguments)}function xl(t,e){t.prototype=Object.create(e.prototype),t.prototype.constructor=t,t.__proto__=e}function wl(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t}var _l,kl="function"!=typeof Object.assign?function(t){if(null==t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(null!=n)for(var o in n)n.hasOwnProperty(o)&&(e[o]=n[o])}return e}:Object.assign,Dl=["","webkit","Moz","MS","ms","o"],Il="undefined"==typeof document?{style:{}}:document.createElement("div"),Cl=Math.round,Ll=Math.abs,Gl=Date.now;function Ml(t,e){for(var i,n,o=e[0].toUpperCase()+e.slice(1),s=0;s<Dl.length;){if((n=(i=Dl[s])?i+o:e)in t)return n;s++}}_l="undefined"==typeof window?{}:window;var Sl=Ml(Il.style,"touchAction"),Ql=void 0!==Sl;var Nl=function(){if(!Ql)return!1;var t={},e=_l.CSS&&_l.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(i){return t[i]=!e||_l.CSS.supports("touch-action",i)})),t}(),Fl="ontouchstart"in _l,Zl=void 0!==Ml(_l,"PointerEvent"),Bl=Fl&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),Ol=["x","y"],Wl=["clientX","clientY"];function Al(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(void 0!==t.length)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function Xl(t,e){return"function"==typeof t?t.apply(e&&e[0]||void 0,e):t}function Tl(t,e){return t.indexOf(e)>-1}var Yl=function(){function t(t,e){this.manager=t,this.set(e)}var e=t.prototype;return e.set=function(t){"compute"===t&&(t=this.compute()),Ql&&this.manager.element.style&&Nl[t]&&(this.manager.element.style[Sl]=t),this.actions=t.toLowerCase().trim()},e.update=function(){this.set(this.manager.options.touchAction)},e.compute=function(){var t=[];return Al(this.manager.recognizers,(function(e){Xl(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(Tl(t,"none"))return"none";var e=Tl(t,"pan-x"),i=Tl(t,"pan-y");return e&&i?"none":e||i?e?"pan-x":"pan-y":Tl(t,"manipulation")?"manipulation":"auto"}(t.join(" "))},e.preventDefaults=function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,o=Tl(n,"none")&&!Nl.none,s=Tl(n,"pan-y")&&!Nl["pan-y"],r=Tl(n,"pan-x")&&!Nl["pan-x"];if(o){var a=1===t.pointers.length,l=t.distance<2,h=t.deltaTime<250;if(a&&l&&h)return}if(!r||!s)return o||s&&6&i||r&&24&i?this.preventSrc(e):void 0}},e.preventSrc=function(t){this.manager.session.prevented=!0,t.preventDefault()},t}();function El(t,e){for(;t;){if(t===e)return!0;t=t.parentNode}return!1}function Rl(t){var e=t.length;if(1===e)return{x:Cl(t[0].clientX),y:Cl(t[0].clientY)};for(var i=0,n=0,o=0;o<e;)i+=t[o].clientX,n+=t[o].clientY,o++;return{x:Cl(i/e),y:Cl(n/e)}}function Ul(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:Cl(t.pointers[i].clientX),clientY:Cl(t.pointers[i].clientY)},i++;return{timeStamp:Gl(),pointers:e,center:Rl(e),deltaX:t.deltaX,deltaY:t.deltaY}}function zl(t,e,i){i||(i=Ol);var n=e[i[0]]-t[i[0]],o=e[i[1]]-t[i[1]];return Math.sqrt(n*n+o*o)}function Vl(t,e,i){i||(i=Ol);var n=e[i[0]]-t[i[0]],o=e[i[1]]-t[i[1]];return 180*Math.atan2(o,n)/Math.PI}function jl(t,e){return t===e?1:Ll(t)>=Ll(e)?t<0?2:4:e<0?8:16}function Hl(t,e,i){return{x:e/t||0,y:i/t||0}}function Pl(t,e){var i=t.session,n=e.pointers,o=n.length;i.firstInput||(i.firstInput=Ul(e)),o>1&&!i.firstMultiple?i.firstMultiple=Ul(e):1===o&&(i.firstMultiple=!1);var s=i.firstInput,r=i.firstMultiple,a=r?r.center:s.center,l=e.center=Rl(n);e.timeStamp=Gl(),e.deltaTime=e.timeStamp-s.timeStamp,e.angle=Vl(a,l),e.distance=zl(a,l),function(t,e){var i=e.center,n=t.offsetDelta||{},o=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(o=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y}),e.deltaX=o.x+(i.x-n.x),e.deltaY=o.y+(i.y-n.y)}(i,e),e.offsetDirection=jl(e.deltaX,e.deltaY);var h,d,u=Hl(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=u.x,e.overallVelocityY=u.y,e.overallVelocity=Ll(u.x)>Ll(u.y)?u.x:u.y,e.scale=r?(h=r.pointers,zl((d=n)[0],d[1],Wl)/zl(h[0],h[1],Wl)):1,e.rotation=r?function(t,e){return Vl(e[1],e[0],Wl)+Vl(t[1],t[0],Wl)}(r.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,o,s,r=t.lastInterval||e,a=e.timeStamp-r.timeStamp;if(8!==e.eventType&&(a>25||void 0===r.velocity)){var l=e.deltaX-r.deltaX,h=e.deltaY-r.deltaY,d=Hl(a,l,h);n=d.x,o=d.y,i=Ll(d.x)>Ll(d.y)?d.x:d.y,s=jl(l,h),t.lastInterval=e}else i=r.velocity,n=r.velocityX,o=r.velocityY,s=r.direction;e.velocity=i,e.velocityX=n,e.velocityY=o,e.direction=s}(i,e);var c,p=t.element,m=e.srcEvent;El(c=m.composedPath?m.composedPath()[0]:m.path?m.path[0]:m.target,p)&&(p=c),e.target=p}function Jl(t,e,i){var n=i.pointers.length,o=i.changedPointers.length,s=1&e&&n-o==0,r=12&e&&n-o==0;i.isFirst=!!s,i.isFinal=!!r,s&&(t.session={}),i.eventType=e,Pl(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function Kl(t){return t.trim().split(/\s+/g)}function ql(t,e,i){Al(Kl(e),(function(e){t.addEventListener(e,i,!1)}))}function $l(t,e,i){Al(Kl(e),(function(e){t.removeEventListener(e,i,!1)}))}function th(t){var e=t.ownerDocument||t;return e.defaultView||e.parentWindow||window}var eh=function(){function t(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){Xl(t.options.enable,[t])&&i.handler(e)},this.init()}var e=t.prototype;return e.handler=function(){},e.init=function(){this.evEl&&ql(this.element,this.evEl,this.domHandler),this.evTarget&&ql(this.target,this.evTarget,this.domHandler),this.evWin&&ql(th(this.element),this.evWin,this.domHandler)},e.destroy=function(){this.evEl&&$l(this.element,this.evEl,this.domHandler),this.evTarget&&$l(this.target,this.evTarget,this.domHandler),this.evWin&&$l(th(this.element),this.evWin,this.domHandler)},t}();function ih(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}var nh={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},oh={2:"touch",3:"pen",4:"mouse",5:"kinect"},sh="pointerdown",rh="pointermove pointerup pointercancel";_l.MSPointerEvent&&!_l.PointerEvent&&(sh="MSPointerDown",rh="MSPointerMove MSPointerUp MSPointerCancel");var ah=function(t){function e(){var i,n=e.prototype;return n.evEl=sh,n.evWin=rh,(i=t.apply(this,arguments)||this).store=i.manager.session.pointerEvents=[],i}return xl(e,t),e.prototype.handler=function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),o=nh[n],s=oh[t.pointerType]||t.pointerType,r="touch"===s,a=ih(e,t.pointerId,"pointerId");1&o&&(0===t.button||r)?a<0&&(e.push(t),a=e.length-1):12&o&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,o,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))},e}(eh);function lh(t){return Array.prototype.slice.call(t,0)}function hh(t,e,i){for(var n=[],o=[],s=0;s<t.length;){var r=e?t[s][e]:t[s];ih(o,r)<0&&n.push(t[s]),o[s]=r,s++}return i&&(n=e?n.sort((function(t,i){return t[e]>i[e]})):n.sort()),n}var dh={touchstart:1,touchmove:2,touchend:4,touchcancel:8},uh=function(t){function e(){var i;return e.prototype.evTarget="touchstart touchmove touchend touchcancel",(i=t.apply(this,arguments)||this).targetIds={},i}return xl(e,t),e.prototype.handler=function(t){var e=dh[t.type],i=ch.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:"touch",srcEvent:t})},e}(eh);function ch(t,e){var i,n,o=lh(t.touches),s=this.targetIds;if(3&e&&1===o.length)return s[o[0].identifier]=!0,[o,o];var r=lh(t.changedTouches),a=[],l=this.target;if(n=o.filter((function(t){return El(t.target,l)})),1===e)for(i=0;i<n.length;)s[n[i].identifier]=!0,i++;for(i=0;i<r.length;)s[r[i].identifier]&&a.push(r[i]),12&e&&delete s[r[i].identifier],i++;return a.length?[hh(n.concat(a),"identifier",!0),a]:void 0}var ph={mousedown:1,mousemove:2,mouseup:4},mh=function(t){function e(){var i,n=e.prototype;return n.evEl="mousedown",n.evWin="mousemove mouseup",(i=t.apply(this,arguments)||this).pressed=!1,i}return xl(e,t),e.prototype.handler=function(t){var e=ph[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))},e}(eh);function fh(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY},n=this.lastTouches;this.lastTouches.push(i);setTimeout((function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)}),2500)}}function gh(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,fh.call(this,e)):12&t&&fh.call(this,e)}function vh(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var o=this.lastTouches[n],s=Math.abs(e-o.x),r=Math.abs(i-o.y);if(s<=25&&r<=25)return!0}return!1}var bh=function(){return function(t){function e(e,i){var n;return(n=t.call(this,e,i)||this).handler=function(t,e,i){var o="touch"===i.pointerType,s="mouse"===i.pointerType;if(!(s&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(o)gh.call(wl(wl(n)),e,i);else if(s&&vh.call(wl(wl(n)),i))return;n.callback(t,e,i)}},n.touch=new uh(n.manager,n.handler),n.mouse=new mh(n.manager,n.handler),n.primaryTouch=null,n.lastTouches=[],n}return xl(e,t),e.prototype.destroy=function(){this.touch.destroy(),this.mouse.destroy()},e}(eh)}();function yh(t,e,i){return!!Array.isArray(t)&&(Al(t,i[e],i),!0)}var xh=1;function wh(t,e){var i=e.manager;return i?i.get(t):t}function _h(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}var kh=function(){function t(t){void 0===t&&(t={}),this.options=yl({enable:!0},t),this.id=xh++,this.manager=null,this.state=1,this.simultaneous={},this.requireFail=[]}var e=t.prototype;return e.set=function(t){return kl(this.options,t),this.manager&&this.manager.touchAction.update(),this},e.recognizeWith=function(t){if(yh(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=wh(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},e.dropRecognizeWith=function(t){return yh(t,"dropRecognizeWith",this)||(t=wh(t,this),delete this.simultaneous[t.id]),this},e.requireFailure=function(t){if(yh(t,"requireFailure",this))return this;var e=this.requireFail;return-1===ih(e,t=wh(t,this))&&(e.push(t),t.requireFailure(this)),this},e.dropRequireFailure=function(t){if(yh(t,"dropRequireFailure",this))return this;t=wh(t,this);var e=ih(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},e.hasRequireFailures=function(){return this.requireFail.length>0},e.canRecognizeWith=function(t){return!!this.simultaneous[t.id]},e.emit=function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<8&&n(e.options.event+_h(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=8&&n(e.options.event+_h(i))},e.tryEmit=function(t){if(this.canEmit())return this.emit(t);this.state=32},e.canEmit=function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},e.recognize=function(t){var e=kl({},t);if(!Xl(this.options.enable,[this,e]))return this.reset(),void(this.state=32);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},e.process=function(t){},e.getTouchAction=function(){},e.reset=function(){},t}(),Dh=function(t){function e(e){var i;return void 0===e&&(e={}),(i=t.call(this,yl({event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},e))||this).pTime=!1,i.pCenter=!1,i._timer=null,i._input=null,i.count=0,i}xl(e,t);var i=e.prototype;return i.getTouchAction=function(){return["manipulation"]},i.process=function(t){var e=this,i=this.options,n=t.pointers.length===i.pointers,o=t.distance<i.threshold,s=t.deltaTime<i.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(o&&s&&n){if(4!==t.eventType)return this.failTimeout();var r=!this.pTime||t.timeStamp-this.pTime<i.interval,a=!this.pCenter||zl(this.pCenter,t.center)<i.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,a&&r?this.count+=1:this.count=1,this._input=t,0===this.count%i.taps)return this.hasRequireFailures()?(this._timer=setTimeout((function(){e.state=8,e.tryEmit()}),i.interval),2):8}return 32},i.failTimeout=function(){var t=this;return this._timer=setTimeout((function(){t.state=32}),this.options.interval),32},i.reset=function(){clearTimeout(this._timer)},i.emit=function(){8===this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))},e}(kh),Ih=function(t){function e(e){return void 0===e&&(e={}),t.call(this,yl({pointers:1},e))||this}xl(e,t);var i=e.prototype;return i.attrTest=function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},i.process=function(t){var e=this.state,i=t.eventType,n=6&e,o=this.attrTest(t);return n&&(8&i||!o)?16|e:n||o?4&i?8|e:2&e?4|e:2:32},e}(kh);function Ch(t){return 16===t?"down":8===t?"up":2===t?"left":4===t?"right":""}var Lh=function(t){function e(e){var i;return void 0===e&&(e={}),(i=t.call(this,yl({event:"pan",threshold:10,pointers:1,direction:30},e))||this).pX=null,i.pY=null,i}xl(e,t);var i=e.prototype;return i.getTouchAction=function(){var t=this.options.direction,e=[];return 6&t&&e.push("pan-y"),24&t&&e.push("pan-x"),e},i.directionTest=function(t){var e=this.options,i=!0,n=t.distance,o=t.direction,s=t.deltaX,r=t.deltaY;return o&e.direction||(6&e.direction?(o=0===s?1:s<0?2:4,i=s!==this.pX,n=Math.abs(t.deltaX)):(o=0===r?1:r<0?8:16,i=r!==this.pY,n=Math.abs(t.deltaY))),t.direction=o,i&&n>e.threshold&&o&e.direction},i.attrTest=function(t){return Ih.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},i.emit=function(e){this.pX=e.deltaX,this.pY=e.deltaY;var i=Ch(e.direction);i&&(e.additionalEvent=this.options.event+i),t.prototype.emit.call(this,e)},e}(Ih),Gh=function(t){function e(e){return void 0===e&&(e={}),t.call(this,yl({event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},e))||this}xl(e,t);var i=e.prototype;return i.getTouchAction=function(){return Lh.prototype.getTouchAction.call(this)},i.attrTest=function(e){var i,n=this.options.direction;return 30&n?i=e.overallVelocity:6&n?i=e.overallVelocityX:24&n&&(i=e.overallVelocityY),t.prototype.attrTest.call(this,e)&&n&e.offsetDirection&&e.distance>this.options.threshold&&e.maxPointers===this.options.pointers&&Ll(i)>this.options.velocity&&4&e.eventType},i.emit=function(t){var e=Ch(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)},e}(Ih),Mh=function(t){function e(e){return void 0===e&&(e={}),t.call(this,yl({event:"pinch",threshold:0,pointers:2},e))||this}xl(e,t);var i=e.prototype;return i.getTouchAction=function(){return["none"]},i.attrTest=function(e){return t.prototype.attrTest.call(this,e)&&(Math.abs(e.scale-1)>this.options.threshold||2&this.state)},i.emit=function(e){if(1!==e.scale){var i=e.scale<1?"in":"out";e.additionalEvent=this.options.event+i}t.prototype.emit.call(this,e)},e}(Ih),Sh=function(t){function e(e){return void 0===e&&(e={}),t.call(this,yl({event:"rotate",threshold:0,pointers:2},e))||this}xl(e,t);var i=e.prototype;return i.getTouchAction=function(){return["none"]},i.attrTest=function(e){return t.prototype.attrTest.call(this,e)&&(Math.abs(e.rotation)>this.options.threshold||2&this.state)},e}(Ih),Qh=function(t){function e(e){var i;return void 0===e&&(e={}),(i=t.call(this,yl({event:"press",pointers:1,time:251,threshold:9},e))||this)._timer=null,i._input=null,i}xl(e,t);var i=e.prototype;return i.getTouchAction=function(){return["auto"]},i.process=function(t){var e=this,i=this.options,n=t.pointers.length===i.pointers,o=t.distance<i.threshold,s=t.deltaTime>i.time;if(this._input=t,!o||!n||12&t.eventType&&!s)this.reset();else if(1&t.eventType)this.reset(),this._timer=setTimeout((function(){e.state=8,e.tryEmit()}),i.time);else if(4&t.eventType)return 8;return 32},i.reset=function(){clearTimeout(this._timer)},i.emit=function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=Gl(),this.manager.emit(this.options.event,this._input)))},e}(kh),Nh={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}},Fh=[[Sh,{enable:!1}],[Mh,{enable:!1},["rotate"]],[Gh,{direction:6}],[Lh,{direction:6},["swipe"]],[Dh],[Dh,{event:"doubletap",taps:2},["tap"]],[Qh]];function Zh(t,e){var i,n=t.element;n.style&&(Al(t.options.cssProps,(function(o,s){i=Ml(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=o):n.style[i]=t.oldCssProps[i]||""})),e||(t.oldCssProps={}))}var Bh=function(){function t(t,e){var i,n=this;this.options=kl({},Nh,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(Zl?ah:Bl?uh:Fl?bh:mh))(i,Jl),this.touchAction=new Yl(this,this.options.touchAction),Zh(this,!0),Al(this.options.recognizers,(function(t){var e=n.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}var e=t.prototype;return e.set=function(t){return kl(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},e.stop=function(t){this.session.stopped=t?2:1},e.recognize=function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,o=e.curRecognizer;(!o||o&&8&o.state)&&(e.curRecognizer=null,o=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||o&&i!==o&&!i.canRecognizeWith(o)?i.reset():i.recognize(t),!o&&14&i.state&&(e.curRecognizer=i,o=i),s++}},e.get=function(t){if(t instanceof kh)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event===t)return e[i];return null},e.add=function(t){if(yh(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},e.remove=function(t){if(yh(t,"remove",this))return this;var e=this.get(t);if(t){var i=this.recognizers,n=ih(i,e);-1!==n&&(i.splice(n,1),this.touchAction.update())}return this},e.on=function(t,e){if(void 0===t||void 0===e)return this;var i=this.handlers;return Al(Kl(t),(function(t){i[t]=i[t]||[],i[t].push(e)})),this},e.off=function(t,e){if(void 0===t)return this;var i=this.handlers;return Al(Kl(t),(function(t){e?i[t]&&i[t].splice(ih(i[t],e),1):delete i[t]})),this},e.emit=function(t,e){this.options.domEvents&&function(t,e){var i=document.createEvent("Event");i.initEvent(t,!0,!0),i.gesture=e,e.target.dispatchEvent(i)}(t,e);var i=this.handlers[t]&&this.handlers[t].slice();if(i&&i.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var n=0;n<i.length;)i[n](e),n++}},e.destroy=function(){this.element&&Zh(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null},t}(),Oh={touchstart:1,touchmove:2,touchend:4,touchcancel:8},Wh=function(t){function e(){var i,n=e.prototype;return n.evTarget="touchstart",n.evWin="touchstart touchmove touchend touchcancel",(i=t.apply(this,arguments)||this).started=!1,i}return xl(e,t),e.prototype.handler=function(t){var e=Oh[t.type];if(1===e&&(this.started=!0),this.started){var i=Ah.call(this,t,e);12&e&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:"touch",srcEvent:t})}},e}(eh);function Ah(t,e){var i=lh(t.touches),n=lh(t.changedTouches);return 12&e&&(i=hh(i.concat(n),"identifier",!0)),[i,n]}function Xh(t,e,i){var n="DEPRECATED METHOD: "+e+"\n"+i+" AT \n";return function(){var e=new Error("get-stack-trace"),i=e&&e.stack?e.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",o=window.console&&(window.console.warn||window.console.log);return o&&o.call(window.console,n,i),t.apply(this,arguments)}}var Th=Xh((function(t,e,i){for(var n=Object.keys(e),o=0;o<n.length;)(!i||i&&void 0===t[n[o]])&&(t[n[o]]=e[n[o]]),o++;return t}),"extend","Use `assign`."),Yh=Xh((function(t,e){return Th(t,e,!0)}),"merge","Use `assign`.");function Eh(t,e,i){var n,o=e.prototype;(n=t.prototype=Object.create(o)).constructor=t,n._super=o,i&&kl(n,i)}function Rh(t,e){return function(){return t.apply(e,arguments)}}var Uh,zh=function(){var t=function(t,e){return void 0===e&&(e={}),new Bh(t,yl({recognizers:Fh.concat()},e))};return t.VERSION="2.0.17-rc",t.DIRECTION_ALL=30,t.DIRECTION_DOWN=16,t.DIRECTION_LEFT=2,t.DIRECTION_RIGHT=4,t.DIRECTION_UP=8,t.DIRECTION_HORIZONTAL=6,t.DIRECTION_VERTICAL=24,t.DIRECTION_NONE=1,t.DIRECTION_DOWN=16,t.INPUT_START=1,t.INPUT_MOVE=2,t.INPUT_END=4,t.INPUT_CANCEL=8,t.STATE_POSSIBLE=1,t.STATE_BEGAN=2,t.STATE_CHANGED=4,t.STATE_ENDED=8,t.STATE_RECOGNIZED=8,t.STATE_CANCELLED=16,t.STATE_FAILED=32,t.Manager=Bh,t.Input=eh,t.TouchAction=Yl,t.TouchInput=uh,t.MouseInput=mh,t.PointerEventInput=ah,t.TouchMouseInput=bh,t.SingleTouchInput=Wh,t.Recognizer=kh,t.AttrRecognizer=Ih,t.Tap=Dh,t.Pan=Lh,t.Swipe=Gh,t.Pinch=Mh,t.Rotate=Sh,t.Press=Qh,t.on=ql,t.off=$l,t.each=Al,t.merge=Yh,t.extend=Th,t.bindFn=Rh,t.assign=kl,t.inherit=Eh,t.bindFn=Rh,t.prefixed=Ml,t.toArray=lh,t.inArray=ih,t.uniqueArray=hh,t.splitStr=Kl,t.boolOrFn=Xl,t.hasParent=El,t.addEventListeners=ql,t.removeEventListeners=$l,t.defaults=kl({},Nh,{preset:Fh}),t}();"undefined"!=typeof window?Uh=bl(window.Hammer||zh,{preventDefault:"mouse"}):Uh=function(){return{on:t=function(){},off:t,destroy:t,emit:t,get:function(e){return{set:t}}};var t};var Vh=Uh;function jh(t,e){e.inputHandler=function(t){t.isFirst&&e(t)},t.on("hammer.input",e.inputHandler)}var Hh=function(){function t(e,i,n,o,s){ba(this,t),this.moment=s&&s.moment||Ta,this.options=s||{},this.current=this.moment(),this._start=this.moment(),this._end=this.moment(),this.autoScale=!0,this.scale="day",this.step=1,this.setRange(e,i,n),this.switchedDay=!1,this.switchedMonth=!1,this.switchedYear=!1,Zo(o)?this.hiddenDates=o:this.hiddenDates=null!=o?[o]:[],this.format=t.FORMAT}return xa(t,[{key:"setMoment",value:function(t){this.moment=t,this.current=this.moment(this.current.valueOf()),this._start=this.moment(this._start.valueOf()),this._end=this.moment(this._end.valueOf())}},{key:"setFormat",value:function(e){var i=za.deepExtend({},t.FORMAT);this.format=za.deepExtend(i,e)}},{key:"setRange",value:function(t,e,i){if(!(t instanceof Date&&e instanceof Date))throw"No legal start or end date in method setRange";this._start=null!=t?this.moment(t.valueOf()):Jo(),this._end=null!=e?this.moment(e.valueOf()):Jo(),this.autoScale&&this.setMinimumStep(i)}},{key:"start",value:function(){this.current=this._start.clone(),this.roundToMinor()}},{key:"roundToMinor",value:function(){switch("week"==this.scale&&this.current.weekday(0),this.scale){case"year":this.current.year(this.step*Math.floor(this.current.year()/this.step)),this.current.month(0);case"month":this.current.date(1);case"week":case"day":case"weekday":this.current.hours(0);case"hour":this.current.minutes(0);case"minute":this.current.seconds(0);case"second":this.current.milliseconds(0)}if(1!=this.step){var t=this.current.clone();switch(this.scale){case"millisecond":this.current.subtract(this.current.milliseconds()%this.step,"milliseconds");break;case"second":this.current.subtract(this.current.seconds()%this.step,"seconds");break;case"minute":this.current.subtract(this.current.minutes()%this.step,"minutes");break;case"hour":this.current.subtract(this.current.hours()%this.step,"hours");break;case"weekday":case"day":this.current.subtract((this.current.date()-1)%this.step,"day");break;case"week":this.current.subtract(this.current.week()%this.step,"week");break;case"month":this.current.subtract(this.current.month()%this.step,"month");break;case"year":this.current.subtract(this.current.year()%this.step,"year")}t.isSame(this.current)||(this.current=this.moment(ul(this.hiddenDates,this.current.valueOf(),-1,!0)))}}},{key:"hasNext",value:function(){return this.current.valueOf()<=this._end.valueOf()}},{key:"next",value:function(){var t=this.current.valueOf();switch(this.scale){case"millisecond":this.current.add(this.step,"millisecond");break;case"second":this.current.add(this.step,"second");break;case"minute":this.current.add(this.step,"minute");break;case"hour":this.current.add(this.step,"hour"),this.current.month()<6?this.current.subtract(this.current.hours()%this.step,"hour"):this.current.hours()%this.step!=0&&this.current.add(this.step-this.current.hours()%this.step,"hour");break;case"weekday":case"day":this.current.add(this.step,"day");break;case"week":if(0!==this.current.weekday())this.current.weekday(0),this.current.add(this.step,"week");else if(!1===this.options.showMajorLabels)this.current.add(this.step,"week");else{var e=this.current.clone();e.add(1,"week"),e.isSame(this.current,"month")?this.current.add(this.step,"week"):(this.current.add(this.step,"week"),this.current.date(1))}break;case"month":this.current.add(this.step,"month");break;case"year":this.current.add(this.step,"year")}if(1!=this.step)switch(this.scale){case"millisecond":this.current.milliseconds()>0&&this.current.milliseconds()<this.step&&this.current.milliseconds(0);break;case"second":this.current.seconds()>0&&this.current.seconds()<this.step&&this.current.seconds(0);break;case"minute":this.current.minutes()>0&&this.current.minutes()<this.step&&this.current.minutes(0);break;case"hour":this.current.hours()>0&&this.current.hours()<this.step&&this.current.hours(0);break;case"weekday":case"day":this.current.date()<this.step+1&&this.current.date(1);break;case"week":this.current.week()<this.step&&this.current.week(1);break;case"month":this.current.month()<this.step&&this.current.month(0)}this.current.valueOf()==t&&(this.current=this._end.clone()),this.switchedDay=!1,this.switchedMonth=!1,this.switchedYear=!1,nl(this.moment,this,t)}},{key:"getCurrent",value:function(){return this.current.clone()}},{key:"setScale",value:function(t){t&&"string"==typeof t.scale&&(this.scale=t.scale,this.step=t.step>0?t.step:1,this.autoScale=!1)}},{key:"setAutoScale",value:function(t){this.autoScale=t}},{key:"setMinimumStep",value:function(t){if(null!=t){31104e9>t&&(this.scale="year",this.step=1e3),15552e9>t&&(this.scale="year",this.step=500),31104e8>t&&(this.scale="year",this.step=100),15552e8>t&&(this.scale="year",this.step=50),31104e7>t&&(this.scale="year",this.step=10),15552e7>t&&(this.scale="year",this.step=5),31104e6>t&&(this.scale="year",this.step=1),7776e6>t&&(this.scale="month",this.step=3),2592e6>t&&(this.scale="month",this.step=1),6048e5>t&&this.options.showWeekScale&&(this.scale="week",this.step=1),1728e5>t&&(this.scale="day",this.step=2),864e5>t&&(this.scale="day",this.step=1),432e5>t&&(this.scale="weekday",this.step=1),144e5>t&&(this.scale="hour",this.step=4),36e5>t&&(this.scale="hour",this.step=1),9e5>t&&(this.scale="minute",this.step=15),6e5>t&&(this.scale="minute",this.step=10),3e5>t&&(this.scale="minute",this.step=5),6e4>t&&(this.scale="minute",this.step=1),15e3>t&&(this.scale="second",this.step=15),1e4>t&&(this.scale="second",this.step=10),5e3>t&&(this.scale="second",this.step=5),1e3>t&&(this.scale="second",this.step=1),200>t&&(this.scale="millisecond",this.step=200),100>t&&(this.scale="millisecond",this.step=100),50>t&&(this.scale="millisecond",this.step=50),10>t&&(this.scale="millisecond",this.step=10),5>t&&(this.scale="millisecond",this.step=5),1>t&&(this.scale="millisecond",this.step=1)}}},{key:"isMajor",value:function(){if(1==this.switchedYear)switch(this.scale){case"year":case"month":case"week":case"weekday":case"day":case"hour":case"minute":case"second":case"millisecond":return!0;default:return!1}else if(1==this.switchedMonth)switch(this.scale){case"week":case"weekday":case"day":case"hour":case"minute":case"second":case"millisecond":return!0;default:return!1}else if(1==this.switchedDay)switch(this.scale){case"millisecond":case"second":case"minute":case"hour":return!0;default:return!1}var t=this.moment(this.current);switch(this.scale){case"millisecond":return 0==t.milliseconds();case"second":return 0==t.seconds();case"minute":return 0==t.hours()&&0==t.minutes();case"hour":return 0==t.hours();case"weekday":case"day":case"week":return 1==t.date();case"month":return 0==t.month();case"year":default:return!1}}},{key:"getLabelMinor",value:function(t){if(null==t&&(t=this.current),t instanceof Date&&(t=this.moment(t)),"function"==typeof this.format.minorLabels)return this.format.minorLabels(t,this.scale,this.step);var e=this.format.minorLabels[this.scale];switch(this.scale){case"week":if(1===t.date()&&0!==t.weekday())return"";default:return e&&e.length>0?this.moment(t).format(e):""}}},{key:"getLabelMajor",value:function(t){if(null==t&&(t=this.current),t instanceof Date&&(t=this.moment(t)),"function"==typeof this.format.majorLabels)return this.format.majorLabels(t,this.scale,this.step);var e=this.format.majorLabels[this.scale];return e&&e.length>0?this.moment(t).format(e):""}},{key:"getClassName",value:function(){var t,e=this.moment,i=this.moment(this.current),n=i.locale?i.locale("en"):i.lang("en"),o=this.step,s=[];function r(t){return t/o%2==0?" vis-even":" vis-odd"}function a(t){return t.isSame(Jo(),"day")?" vis-today":t.isSame(e().add(1,"day"),"day")?" vis-tomorrow":t.isSame(e().add(-1,"day"),"day")?" vis-yesterday":""}function l(t){return t.isSame(Jo(),"week")?" vis-current-week":""}function h(t){return t.isSame(Jo(),"month")?" vis-current-month":""}switch(this.scale){case"millisecond":s.push(a(n)),s.push(r(n.milliseconds()));break;case"second":s.push(a(n)),s.push(r(n.seconds()));break;case"minute":s.push(a(n)),s.push(r(n.minutes()));break;case"hour":s.push(Pn(t="vis-h".concat(n.hours())).call(t,4==this.step?"-h"+(n.hours()+4):"")),s.push(a(n)),s.push(r(n.hours()));break;case"weekday":s.push("vis-".concat(n.format("dddd").toLowerCase())),s.push(a(n)),s.push(l(n)),s.push(r(n.date()));break;case"day":s.push("vis-day".concat(n.date())),s.push("vis-".concat(n.format("MMMM").toLowerCase())),s.push(a(n)),s.push(h(n)),s.push(this.step<=2?a(n):""),s.push(this.step<=2?"vis-".concat(n.format("dddd").toLowerCase()):""),s.push(r(n.date()-1));break;case"week":s.push("vis-week".concat(n.format("w"))),s.push(l(n)),s.push(r(n.week()));break;case"month":s.push("vis-".concat(n.format("MMMM").toLowerCase())),s.push(h(n)),s.push(r(n.month()));break;case"year":s.push("vis-year".concat(n.year())),s.push(function(t){return t.isSame(Jo(),"year")?" vis-current-year":""}(n)),s.push(r(n.year()))}return En(s).call(s,String).join(" ")}}],[{key:"snap",value:function(t,e,i){var n=Ta(t);if("year"==e){var o=n.year()+Math.round(n.month()/12);n.year(Math.round(o/i)*i),n.month(0),n.date(0),n.hours(0),n.minutes(0),n.seconds(0),n.milliseconds(0)}else if("month"==e)n.date()>15?(n.date(1),n.add(1,"month")):n.date(1),n.hours(0),n.minutes(0),n.seconds(0),n.milliseconds(0);else if("week"==e)n.weekday()>2?(n.weekday(0),n.add(1,"week")):n.weekday(0),n.hours(0),n.minutes(0),n.seconds(0),n.milliseconds(0);else if("day"==e){switch(i){case 5:case 2:n.hours(24*Math.round(n.hours()/24));break;default:n.hours(12*Math.round(n.hours()/12))}n.minutes(0),n.seconds(0),n.milliseconds(0)}else if("weekday"==e){switch(i){case 5:case 2:n.hours(12*Math.round(n.hours()/12));break;default:n.hours(6*Math.round(n.hours()/6))}n.minutes(0),n.seconds(0),n.milliseconds(0)}else if("hour"==e){switch(i){case 4:n.minutes(60*Math.round(n.minutes()/60));break;default:n.minutes(30*Math.round(n.minutes()/30))}n.seconds(0),n.milliseconds(0)}else if("minute"==e){switch(i){case 15:case 10:n.minutes(5*Math.round(n.minutes()/5)),n.seconds(0);break;case 5:n.seconds(60*Math.round(n.seconds()/60));break;default:n.seconds(30*Math.round(n.seconds()/30))}n.milliseconds(0)}else if("second"==e)switch(i){case 15:case 10:n.seconds(5*Math.round(n.seconds()/5)),n.milliseconds(0);break;case 5:n.milliseconds(1e3*Math.round(n.milliseconds()/1e3));break;default:n.milliseconds(500*Math.round(n.milliseconds()/500))}else if("millisecond"==e){var s=i>5?i/2:1;n.milliseconds(Math.round(n.milliseconds()/s)*s)}return n}}]),t}();function Ph(t,e){void 0===e&&(e={});var i=e.insertAt;if(t&&"undefined"!=typeof document){var n=document.head||document.getElementsByTagName("head")[0],o=document.createElement("style");o.type="text/css","top"===i&&n.firstChild?n.insertBefore(o,n.firstChild):n.appendChild(o),o.styleSheet?o.styleSheet.cssText=t:o.appendChild(document.createTextNode(t))}}Hh.FORMAT={minorLabels:{millisecond:"SSS",second:"s",minute:"HH:mm",hour:"HH:mm",weekday:"ddd D",day:"D",week:"w",month:"MMM",year:"YYYY"},majorLabels:{millisecond:"HH:mm:ss",second:"D MMMM HH:mm",minute:"ddd D MMMM",hour:"ddd D MMMM",weekday:"MMMM YYYY",day:"MMMM YYYY",week:"MMMM YYYY",month:"YYYY",year:""}};Ph(".vis-time-axis{position:relative;overflow:hidden}.vis-time-axis.vis-foreground{top:0;left:0;width:100%}.vis-time-axis.vis-background{position:absolute;top:0;left:0;width:100%;height:100%}.vis-time-axis .vis-text{position:absolute;color:#4d4d4d;padding:3px;overflow:hidden;box-sizing:border-box;white-space:nowrap}.vis-time-axis .vis-text.vis-measure{position:absolute;padding-left:0;padding-right:0;margin-left:0;margin-right:0;visibility:hidden}.vis-time-axis .vis-grid.vis-vertical{position:absolute;border-left:1px solid}.vis-time-axis .vis-grid.vis-vertical-rtl{position:absolute;border-right:1px solid}.vis-time-axis .vis-grid.vis-minor{border-color:#e5e5e5}.vis-time-axis .vis-grid.vis-major{border-color:#bfbfbf}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRpbWVheGlzLmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxlQUNFLGlCQUFrQixDQUNsQixlQUNGLENBRUEsOEJBQ0UsS0FBTSxDQUNOLE1BQU8sQ0FDUCxVQUNGLENBRUEsOEJBQ0UsaUJBQWtCLENBQ2xCLEtBQU0sQ0FDTixNQUFPLENBQ1AsVUFBVyxDQUNYLFdBQ0YsQ0FFQSx5QkFDRSxpQkFBa0IsQ0FDbEIsYUFBYyxDQUNkLFdBQVksQ0FDWixlQUFnQixDQUNoQixxQkFBc0IsQ0FFdEIsa0JBQ0YsQ0FFQSxxQ0FDRSxpQkFBa0IsQ0FDbEIsY0FBZSxDQUNmLGVBQWdCLENBQ2hCLGFBQWMsQ0FDZCxjQUFlLENBQ2YsaUJBQ0YsQ0FFQSxzQ0FDRSxpQkFBa0IsQ0FDbEIscUJBQ0YsQ0FFQSwwQ0FDRSxpQkFBa0IsQ0FDbEIsc0JBQ0YsQ0FFQSxtQ0FDRSxvQkFDRixDQUVBLG1DQUNFLG9CQUNGIiwiZmlsZSI6InRpbWVheGlzLmNzcyIsInNvdXJjZXNDb250ZW50IjpbIi52aXMtdGltZS1heGlzIHtcbiAgcG9zaXRpb246IHJlbGF0aXZlO1xuICBvdmVyZmxvdzogaGlkZGVuO1xufVxuXG4udmlzLXRpbWUtYXhpcy52aXMtZm9yZWdyb3VuZCB7XG4gIHRvcDogMDtcbiAgbGVmdDogMDtcbiAgd2lkdGg6IDEwMCU7XG59XG5cbi52aXMtdGltZS1heGlzLnZpcy1iYWNrZ3JvdW5kIHtcbiAgcG9zaXRpb246IGFic29sdXRlO1xuICB0b3A6IDA7XG4gIGxlZnQ6IDA7XG4gIHdpZHRoOiAxMDAlO1xuICBoZWlnaHQ6IDEwMCU7XG59XG5cbi52aXMtdGltZS1heGlzIC52aXMtdGV4dCB7XG4gIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgY29sb3I6ICM0ZDRkNGQ7XG4gIHBhZGRpbmc6IDNweDtcbiAgb3ZlcmZsb3c6IGhpZGRlbjtcbiAgYm94LXNpemluZzogYm9yZGVyLWJveDtcblxuICB3aGl0ZS1zcGFjZTogbm93cmFwO1xufVxuXG4udmlzLXRpbWUtYXhpcyAudmlzLXRleHQudmlzLW1lYXN1cmUge1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIHBhZGRpbmctbGVmdDogMDtcbiAgcGFkZGluZy1yaWdodDogMDtcbiAgbWFyZ2luLWxlZnQ6IDA7XG4gIG1hcmdpbi1yaWdodDogMDtcbiAgdmlzaWJpbGl0eTogaGlkZGVuO1xufVxuXG4udmlzLXRpbWUtYXhpcyAudmlzLWdyaWQudmlzLXZlcnRpY2FsIHtcbiAgcG9zaXRpb246IGFic29sdXRlO1xuICBib3JkZXItbGVmdDogMXB4IHNvbGlkO1xufVxuXG4udmlzLXRpbWUtYXhpcyAudmlzLWdyaWQudmlzLXZlcnRpY2FsLXJ0bCB7XG4gIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgYm9yZGVyLXJpZ2h0OiAxcHggc29saWQ7XG59XG5cbi52aXMtdGltZS1heGlzIC52aXMtZ3JpZC52aXMtbWlub3Ige1xuICBib3JkZXItY29sb3I6ICNlNWU1ZTU7XG59XG5cbi52aXMtdGltZS1heGlzIC52aXMtZ3JpZC52aXMtbWFqb3Ige1xuICBib3JkZXItY29sb3I6ICNiZmJmYmY7XG59XG4iXX0= */");var Jh=function(t){function e(t,i){var n;return ba(this,e),(n=ar(this,dr(e).call(this))).dom={foreground:null,lines:[],majorTexts:[],minorTexts:[],redundant:{lines:[],majorTexts:[],minorTexts:[]}},n.props={range:{start:0,end:0,minimumStep:0},lineTop:0},n.defaultOptions={orientation:{axis:"bottom"},showMinorLabels:!0,showMajorLabels:!0,showWeekScale:!1,maxMinorChars:7,format:Hh.FORMAT,moment:Ta,timeAxis:null},n.options=za.extend({},n.defaultOptions),n.body=t,n._create(),n.setOptions(i),n}return pr(e,t),xa(e,[{key:"setOptions",value:function(t){t&&(za.selectiveExtend(["showMinorLabels","showMajorLabels","showWeekScale","maxMinorChars","hiddenDates","timeAxis","moment","rtl"],this.options,t),za.selectiveDeepExtend(["format"],this.options,t),"orientation"in t&&("string"==typeof t.orientation?this.options.orientation.axis=t.orientation:"object"===zo(t.orientation)&&"axis"in t.orientation&&(this.options.orientation.axis=t.orientation.axis)),"locale"in t&&("function"==typeof Ta.locale?Ta.locale(t.locale):Ta.lang(t.locale)))}},{key:"_create",value:function(){this.dom.foreground=document.createElement("div"),this.dom.background=document.createElement("div"),this.dom.foreground.className="vis-time-axis vis-foreground",this.dom.background.className="vis-time-axis vis-background"}},{key:"destroy",value:function(){this.dom.foreground.parentNode&&this.dom.foreground.parentNode.removeChild(this.dom.foreground),this.dom.background.parentNode&&this.dom.background.parentNode.removeChild(this.dom.background),this.body=null}},{key:"redraw",value:function(){var t=this.props,e=this.dom.foreground,i=this.dom.background,n="top"==this.options.orientation.axis?this.body.dom.top:this.body.dom.bottom,o=e.parentNode!==n;this._calculateCharSize();var s=this.options.showMinorLabels&&"none"!==this.options.orientation.axis,r=this.options.showMajorLabels&&"none"!==this.options.orientation.axis;t.minorLabelHeight=s?t.minorCharHeight:0,t.majorLabelHeight=r?t.majorCharHeight:0,t.height=t.minorLabelHeight+t.majorLabelHeight,t.width=e.offsetWidth,t.minorLineHeight=this.body.domProps.root.height-t.majorLabelHeight-("top"==this.options.orientation.axis?this.body.domProps.bottom.height:this.body.domProps.top.height),t.minorLineWidth=1,t.majorLineHeight=t.minorLineHeight+t.majorLabelHeight,t.majorLineWidth=1;var a=e.nextSibling,l=i.nextSibling;return e.parentNode&&e.parentNode.removeChild(e),i.parentNode&&i.parentNode.removeChild(i),e.style.height="".concat(this.props.height,"px"),this._repaintLabels(),a?n.insertBefore(e,a):n.appendChild(e),l?this.body.dom.backgroundVertical.insertBefore(i,l):this.body.dom.backgroundVertical.appendChild(i),this._isResized()||o}},{key:"_repaintLabels",value:function(){var t=this.options.orientation.axis,e=za.convert(this.body.range.start,"Number"),i=za.convert(this.body.range.end,"Number"),n=this.body.util.toTime((this.props.minorCharWidth||10)*this.options.maxMinorChars).valueOf(),o=n-hl(this.options.moment,this.body.hiddenDates,this.body.range,n);o-=this.body.util.toTime(0).valueOf();var s=new Hh(new Date(e),new Date(i),o,this.body.hiddenDates,this.options);s.setMoment(this.options.moment),this.options.format&&s.setFormat(this.options.format),this.options.timeAxis&&s.setScale(this.options.timeAxis),this.step=s;var r,a,l,h,d,u,c=this.dom;c.redundant.lines=c.lines,c.redundant.majorTexts=c.majorTexts,c.redundant.minorTexts=c.minorTexts,c.lines=[],c.majorTexts=[],c.minorTexts=[];var p,m,f,g=0,v=void 0,b=0;for(s.start(),a=s.getCurrent(),h=this.body.util.toScreen(a);s.hasNext()&&b<1e3;){switch(b++,d=s.isMajor(),f=s.getClassName(),r=a,l=h,s.next(),a=s.getCurrent(),p=g,g=(h=this.body.util.toScreen(a))-l,s.scale){case"week":u=!0;break;default:u=g>=.4*p}if(this.options.showMinorLabels&&u){var y=this._repaintMinorText(l,s.getLabelMinor(r),t,f);y.style.width="".concat(g,"px")}d&&this.options.showMajorLabels?(l>0&&(null==v&&(v=l),y=this._repaintMajorText(l,s.getLabelMajor(r),t,f)),m=this._repaintMajorLine(l,g,t,f)):u?m=this._repaintMinorLine(l,g,t,f):m&&(m.style.width="".concat(Nn(m.style.width)+g,"px"))}if(1e3!==b||Kh||(console.warn("Something is wrong with the Timeline scale. Limited drawing of grid lines to ".concat(1e3," lines.")),Kh=!0),this.options.showMajorLabels){var x=this.body.util.toTime(0),w=s.getLabelMajor(x),_=w.length*(this.props.majorCharWidth||10)+10;(null==v||_<v)&&this._repaintMajorText(0,w,t,f)}mn(za).call(za,this.dom.redundant,(function(t){for(;t.length;){var e=t.pop();e&&e.parentNode&&e.parentNode.removeChild(e)}}))}},{key:"_repaintMinorText",value:function(t,e,i,n){var o=this.dom.redundant.minorTexts.shift();if(!o){var s=document.createTextNode("");(o=document.createElement("div")).appendChild(s),this.dom.foreground.appendChild(o)}this.dom.minorTexts.push(o),o.innerHTML=e;var r="top"==i?this.props.majorLabelHeight:0;return this._setXY(o,t,r),o.className="vis-text vis-minor ".concat(n),o}},{key:"_repaintMajorText",value:function(t,e,i,n){var o=this.dom.redundant.majorTexts.shift();if(!o){var s=document.createElement("div");(o=document.createElement("div")).appendChild(s),this.dom.foreground.appendChild(o)}o.childNodes[0].innerHTML=e,o.className="vis-text vis-major ".concat(n);var r="top"==i?0:this.props.minorLabelHeight;return this._setXY(o,t,r),this.dom.majorTexts.push(o),o}},{key:"_setXY",value:function(t,e,i){var n,o=this.options.rtl?-1*e:e;t.style.transform=Pn(n="translate(".concat(o,"px, ")).call(n,i,"px)")}},{key:"_repaintMinorLine",value:function(t,e,i,n){var o,s=this.dom.redundant.lines.shift();s||(s=document.createElement("div"),this.dom.background.appendChild(s)),this.dom.lines.push(s);var r=this.props;s.style.width="".concat(e,"px"),s.style.height="".concat(r.minorLineHeight,"px");var a="top"==i?r.majorLabelHeight:this.body.domProps.top.height,l=t-r.minorLineWidth/2;return this._setXY(s,l,a),s.className=Pn(o="vis-grid ".concat(this.options.rtl?"vis-vertical-rtl":"vis-vertical"," vis-minor ")).call(o,n),s}},{key:"_repaintMajorLine",value:function(t,e,i,n){var o,s=this.dom.redundant.lines.shift();s||(s=document.createElement("div"),this.dom.background.appendChild(s)),this.dom.lines.push(s);var r=this.props;s.style.width="".concat(e,"px"),s.style.height="".concat(r.majorLineHeight,"px");var a="top"==i?0:this.body.domProps.top.height,l=t-r.majorLineWidth/2;return this._setXY(s,l,a),s.className=Pn(o="vis-grid ".concat(this.options.rtl?"vis-vertical-rtl":"vis-vertical"," vis-major ")).call(o,n),s}},{key:"_calculateCharSize",value:function(){this.dom.measureCharMinor||(this.dom.measureCharMinor=document.createElement("DIV"),this.dom.measureCharMinor.className="vis-text vis-minor vis-measure",this.dom.measureCharMinor.style.position="absolute",this.dom.measureCharMinor.appendChild(document.createTextNode("0")),this.dom.foreground.appendChild(this.dom.measureCharMinor)),this.props.minorCharHeight=this.dom.measureCharMinor.clientHeight,this.props.minorCharWidth=this.dom.measureCharMinor.clientWidth,this.dom.measureCharMajor||(this.dom.measureCharMajor=document.createElement("DIV"),this.dom.measureCharMajor.className="vis-text vis-major vis-measure",this.dom.measureCharMajor.style.position="absolute",this.dom.measureCharMajor.appendChild(document.createTextNode("0")),this.dom.foreground.appendChild(this.dom.measureCharMajor)),this.props.majorCharHeight=this.dom.measureCharMajor.clientHeight,this.props.majorCharWidth=this.dom.measureCharMajor.clientWidth}}]),e}(Ja),Kh=!1,qh=n((function(t,e){t.exports=function(t){var e,i=t&&t.preventDefault||!1,n=t&&t.container||window,o={},s={keydown:{},keyup:{}},r={};for(e=97;e<=122;e++)r[String.fromCharCode(e)]={code:e-97+65,shift:!1};for(e=65;e<=90;e++)r[String.fromCharCode(e)]={code:e,shift:!0};for(e=0;e<=9;e++)r[""+e]={code:48+e,shift:!1};for(e=1;e<=12;e++)r["F"+e]={code:111+e,shift:!1};for(e=0;e<=9;e++)r["num"+e]={code:96+e,shift:!1};r["num*"]={code:106,shift:!1},r["num+"]={code:107,shift:!1},r["num-"]={code:109,shift:!1},r["num/"]={code:111,shift:!1},r["num."]={code:110,shift:!1},r.left={code:37,shift:!1},r.up={code:38,shift:!1},r.right={code:39,shift:!1},r.down={code:40,shift:!1},r.space={code:32,shift:!1},r.enter={code:13,shift:!1},r.shift={code:16,shift:void 0},r.esc={code:27,shift:!1},r.backspace={code:8,shift:!1},r.tab={code:9,shift:!1},r.ctrl={code:17,shift:!1},r.alt={code:18,shift:!1},r.delete={code:46,shift:!1},r.pageup={code:33,shift:!1},r.pagedown={code:34,shift:!1},r["="]={code:187,shift:!1},r["-"]={code:189,shift:!1},r["]"]={code:221,shift:!1},r["["]={code:219,shift:!1};var a=function(t){h(t,"keydown")},l=function(t){h(t,"keyup")},h=function(t,e){if(void 0!==s[e][t.keyCode]){for(var n=s[e][t.keyCode],o=0;o<n.length;o++)(void 0===n[o].shift||1==n[o].shift&&1==t.shiftKey||0==n[o].shift&&0==t.shiftKey)&&n[o].fn(t);1==i&&t.preventDefault()}};return o.bind=function(t,e,i){if(void 0===i&&(i="keydown"),void 0===r[t])throw new Error("unsupported key: "+t);void 0===s[i][r[t].code]&&(s[i][r[t].code]=[]),s[i][r[t].code].push({fn:e,shift:r[t].shift})},o.bindAll=function(t,e){for(var i in void 0===e&&(e="keydown"),r)r.hasOwnProperty(i)&&o.bind(i,t,e)},o.getKey=function(t){for(var e in r)if(r.hasOwnProperty(e)){if(1==t.shiftKey&&1==r[e].shift&&t.keyCode==r[e].code)return e;if(0==t.shiftKey&&0==r[e].shift&&t.keyCode==r[e].code)return e;if(t.keyCode==r[e].code&&"shift"==e)return e}return"unknown key, currently not supported"},o.unbind=function(t,e,i){if(void 0===i&&(i="keydown"),void 0===r[t])throw new Error("unsupported key: "+t);if(void 0!==e){var n=[],o=s[i][r[t].code];if(void 0!==o)for(var a=0;a<o.length;a++)o[a].fn==e&&o[a].shift==r[t].shift||n.push(s[i][r[t].code][a]);s[i][r[t].code]=n}else s[i][r[t].code]=[]},o.reset=function(){s={keydown:{},keyup:{}}},o.destroy=function(){s={keydown:{},keyup:{}},n.removeEventListener("keydown",a,!0),n.removeEventListener("keyup",l,!0)},n.addEventListener("keydown",a,!0),n.addEventListener("keyup",l,!0),o}}));function $h(t){var e,i;this.active=!1,this.dom={container:t},this.dom.overlay=document.createElement("div"),this.dom.overlay.className="vis-overlay",this.dom.container.appendChild(this.dom.overlay),this.hammer=Vh(this.dom.overlay),this.hammer.on("tap",va(e=this._onTapOverlay).call(e,this));var n=this,o=["tap","doubletap","press","pinch","pan","panstart","panmove","panend"];mn(o).call(o,(function(t){n.hammer.on(t,(function(t){t.stopPropagation()}))})),document&&document.body&&(this.onClick=function(e){(function(t,e){for(;t;){if(t===e)return!0;t=t.parentNode}return!1})(e.target,t)||n.deactivate()},document.body.addEventListener("click",this.onClick)),void 0!==this.keycharm&&this.keycharm.destroy(),this.keycharm=qh(),this.escListener=va(i=this.deactivate).call(i,this)}Ph(".vis .overlay{position:absolute;top:0;left:0;width:100%;height:100%;z-index:10}.vis-active{box-shadow:0 0 10px #86d5f8}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFjdGl2YXRvci5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsY0FDRSxpQkFBa0IsQ0FDbEIsS0FBTSxDQUNOLE1BQU8sQ0FDUCxVQUFXLENBQ1gsV0FBWSxDQUdaLFVBQ0YsQ0FFQSxZQUNFLDJCQUNGIiwiZmlsZSI6ImFjdGl2YXRvci5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyIudmlzIC5vdmVybGF5IHtcbiAgcG9zaXRpb246IGFic29sdXRlO1xuICB0b3A6IDA7XG4gIGxlZnQ6IDA7XG4gIHdpZHRoOiAxMDAlO1xuICBoZWlnaHQ6IDEwMCU7XG5cbiAgLyogTXVzdCBiZSBkaXNwbGF5ZWQgYWJvdmUgZm9yIGV4YW1wbGUgc2VsZWN0ZWQgVGltZWxpbmUgaXRlbXMgKi9cbiAgei1pbmRleDogMTA7XG59XG5cbi52aXMtYWN0aXZlIHtcbiAgYm94LXNoYWRvdzogMCAwIDEwcHggIzg2ZDVmODtcbn1cbiJdfQ== */"),vl($h.prototype),$h.current=null,$h.prototype.destroy=function(){this.deactivate(),this.dom.overlay.parentNode.removeChild(this.dom.overlay),this.onClick&&document.body.removeEventListener("click",this.onClick),void 0!==this.keycharm&&this.keycharm.destroy(),this.keycharm=null,this.hammer.destroy(),this.hammer=null},$h.prototype.activate=function(){var t;$h.current&&$h.current.deactivate(),$h.current=this,this.active=!0,this.dom.overlay.style.display="none",za.addClassName(this.dom.container,"vis-active"),this.emit("change"),this.emit("activate"),va(t=this.keycharm).call(t,"esc",this.escListener)},$h.prototype.deactivate=function(){$h.current===this&&($h.current=null),this.active=!1,this.dom.overlay.style.display="",za.removeClassName(this.dom.container,"vis-active"),this.keycharm.unbind("esc",this.escListener),this.emit("change"),this.emit("deactivate")},$h.prototype._onTapOverlay=function(t){this.activate(),t.stopPropagation()};var td={current:"current",time:"time",deleteSelected:"Delete selected"},ed={current:"attuale",time:"tempo",deleteSelected:"Cancella la selezione"},id={current:"huidige",time:"tijd",deleteSelected:"Selectie verwijderen"},nd={current:"Aktuelle",time:"Zeit",deleteSelected:"Lösche Auswahl"},od={current:"actuel",time:"heure",deleteSelected:"Effacer la selection"},sd={current:"corriente",time:"hora",deleteSelected:"Eliminar selección"},rd={current:"поточний",time:"час",deleteSelected:"Видалити обране"},ad={current:"текущее",time:"время",deleteSelected:"Удалить выбранное"},ld={current:"aktualny",time:"czas",deleteSelected:"Usuń wybrane"},hd={current:"現在",time:"時刻",deleteSelected:"選択されたものを削除"},dd={en:td,en_EN:td,en_US:td,it:ed,it_IT:ed,it_CH:ed,nl:id,nl_NL:id,nl_BE:id,de:nd,de_DE:nd,fr:od,fr_FR:od,fr_CA:od,fr_BE:od,es:sd,es_ES:sd,uk:rd,uk_UA:rd,ru:ad,ru_RU:ad,pl:ld,pl_PL:ld,ja:hd,ja_JP:hd};Ph(".vis-custom-time{background-color:#6e94ff;width:2px;cursor:move;z-index:1}.vis-custom-time>.vis-custom-time-marker{background-color:inherit;color:#fff;font-size:12px;white-space:nowrap;padding:3px 5px;top:0;cursor:auto;z-index:inherit}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImN1c3RvbXRpbWUuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLGlCQUNFLHdCQUF5QixDQUN6QixTQUFVLENBQ1YsV0FBWSxDQUNaLFNBQ0YsQ0FFQSx5Q0FDRSx3QkFBeUIsQ0FDekIsVUFBWSxDQUNaLGNBQWUsQ0FDZixrQkFBbUIsQ0FDbkIsZUFBZ0IsQ0FDaEIsS0FBUSxDQUNSLFdBQWUsQ0FDZixlQUNGIiwiZmlsZSI6ImN1c3RvbXRpbWUuY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLnZpcy1jdXN0b20tdGltZSB7XG4gIGJhY2tncm91bmQtY29sb3I6ICM2RTk0RkY7XG4gIHdpZHRoOiAycHg7XG4gIGN1cnNvcjogbW92ZTtcbiAgei1pbmRleDogMTtcbn1cblxuLnZpcy1jdXN0b20tdGltZSA+IC52aXMtY3VzdG9tLXRpbWUtbWFya2VyIHtcbiAgYmFja2dyb3VuZC1jb2xvcjogaW5oZXJpdDtcbiAgY29sb3I6IHdoaXRlO1xuICBmb250LXNpemU6IDEycHg7XG4gIHdoaXRlLXNwYWNlOiBub3dyYXA7XG4gIHBhZGRpbmc6IDNweCA1cHg7XG4gIHRvcDogMHB4O1xuICBjdXJzb3I6IGluaXRpYWw7XG4gIHotaW5kZXg6IGluaGVyaXQ7XG59Il19 */");var ud=function(t){function e(t,i){var n,o;ba(this,e),(o=ar(this,dr(e).call(this))).body=t,o.defaultOptions={moment:Ta,locales:dd,locale:"en",id:void 0,title:void 0},o.options=za.extend({},o.defaultOptions),o.setOptions(i),o.options.locales=za.extend({},dd,o.options.locales);var s=o.defaultOptions.locales[o.defaultOptions.locale];return mn(n=Yi(o.options.locales)).call(n,(function(t){o.options.locales[t]=za.extend({},s,o.options.locales[t])})),i&&null!=i.time?o.customTime=i.time:o.customTime=new Date,o.eventParams={},o._create(),o}return pr(e,t),xa(e,[{key:"setOptions",value:function(t){t&&za.selectiveExtend(["moment","locale","locales","id","title","rtl","snap"],this.options,t)}},{key:"_create",value:function(){var t,e,i,n=document.createElement("div");n["custom-time"]=this,n.className="vis-custom-time ".concat(this.options.id||""),n.style.position="absolute",n.style.top="0px",n.style.height="100%",this.bar=n;var o=document.createElement("div");function s(t){this.body.range._onMouseWheel(t)}o.style.position="relative",o.style.top="0px",this.options.rtl?o.style.right="-10px":o.style.left="-10px",o.style.height="100%",o.style.width="20px",o.addEventListener?(o.addEventListener("mousewheel",va(s).call(s,this),!1),o.addEventListener("DOMMouseScroll",va(s).call(s,this),!1)):o.attachEvent("onmousewheel",va(s).call(s,this)),n.appendChild(o),this.hammer=new Vh(o),this.hammer.on("panstart",va(t=this._onDragStart).call(t,this)),this.hammer.on("panmove",va(e=this._onDrag).call(e,this)),this.hammer.on("panend",va(i=this._onDragEnd).call(i,this)),this.hammer.get("pan").set({threshold:5,direction:Vh.DIRECTION_ALL})}},{key:"destroy",value:function(){this.hide(),this.hammer.destroy(),this.hammer=null,this.body=null}},{key:"redraw",value:function(){var t=this.body.dom.backgroundVertical;this.bar.parentNode!=t&&(this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar),t.appendChild(this.bar));var e=this.body.util.toScreen(this.customTime),i=this.options.locales[this.options.locale];i||(this.warned||(console.warn("WARNING: options.locales['".concat(this.options.locale,"'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization")),this.warned=!0),i=this.options.locales.en);var n,o=this.options.title;void 0===o?o=(o=Pn(n="".concat(i.time,": ")).call(n,this.options.moment(this.customTime).format("dddd, MMMM Do YYYY, H:mm:ss"))).charAt(0).toUpperCase()+o.substring(1):"function"==typeof o&&(o=o.call(this,this.customTime));return this.options.rtl?this.bar.style.right="".concat(e,"px"):this.bar.style.left="".concat(e,"px"),this.bar.title=o,!1}},{key:"hide",value:function(){this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar)}},{key:"setCustomTime",value:function(t){this.customTime=za.convert(t,"Date"),this.redraw()}},{key:"getCustomTime",value:function(){return new Date(this.customTime.valueOf())}},{key:"setCustomMarker",value:function(t,e){var i,n,o=document.createElement("div");(o.className="vis-custom-time-marker",o.innerHTML=t,o.style.position="absolute",e)&&(o.setAttribute("contenteditable","true"),o.addEventListener("pointerdown",(function(){o.focus()})),o.addEventListener("input",va(i=this._onMarkerChange).call(i,this)),o.title=t,o.addEventListener("blur",va(n=function(t){this.title!=t.target.innerHTML&&(this._onMarkerChanged(t),this.title=t.target.innerHTML)}).call(n,this)));this.bar.appendChild(o)}},{key:"setCustomTitle",value:function(t){this.options.title=t}},{key:"_onDragStart",value:function(t){this.eventParams.dragging=!0,this.eventParams.customTime=this.customTime,t.stopPropagation()}},{key:"_onDrag",value:function(t){if(this.eventParams.dragging){var e=this.options.rtl?-1*t.deltaX:t.deltaX,i=this.body.util.toScreen(this.eventParams.customTime)+e,n=this.body.util.toTime(i),o=this.body.util.getScale(),s=this.body.util.getStep(),r=this.options.snap,a=r?r(n,o,s):n;this.setCustomTime(a),this.body.emitter.emit("timechange",{id:this.options.id,time:new Date(this.customTime.valueOf()),event:t}),t.stopPropagation()}}},{key:"_onDragEnd",value:function(t){this.eventParams.dragging&&(this.body.emitter.emit("timechanged",{id:this.options.id,time:new Date(this.customTime.valueOf()),event:t}),t.stopPropagation())}},{key:"_onMarkerChange",value:function(t){this.body.emitter.emit("markerchange",{id:this.options.id,title:t.target.innerHTML,event:t}),t.stopPropagation()}},{key:"_onMarkerChanged",value:function(t){this.body.emitter.emit("markerchanged",{id:this.options.id,title:t.target.innerHTML,event:t}),t.stopPropagation()}}],[{key:"customTimeFromTarget",value:function(t){for(var e=t.target;e;){if(e.hasOwnProperty("custom-time"))return e["custom-time"];e=e.parentNode}return null}}]),e}(Ja);Ph("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJhbmltYXRpb24uY3NzIn0= */");Ph('.vis-current-time{background-color:#ff7f6e;width:2px;z-index:1;pointer-events:none}.vis-rolling-mode-btn{height:40px;width:40px;position:absolute;top:7px;right:20px;border-radius:50%;font-size:28px;cursor:pointer;opacity:.8;color:#fff;font-weight:700;text-align:center;background:#3876c2}.vis-rolling-mode-btn:before{content:"\\26F6"}.vis-rolling-mode-btn:hover{opacity:1}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImN1cnJlbnR0aW1lLmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxrQkFDRSx3QkFBeUIsQ0FDekIsU0FBVSxDQUNWLFNBQVUsQ0FDVixtQkFDRixDQUVBLHNCQUNFLFdBQVksQ0FDWixVQUFXLENBQ1gsaUJBQWtCLENBQ2xCLE9BQVEsQ0FDUixVQUFXLENBQ1gsaUJBQWtCLENBQ2xCLGNBQWUsQ0FDZixjQUFlLENBQ2YsVUFBWSxDQUNaLFVBQVksQ0FDWixlQUFpQixDQUNqQixpQkFBa0IsQ0FDbEIsa0JBQ0YsQ0FDQSw2QkFDRSxlQUNGLENBRUEsNEJBQ0UsU0FDRiIsImZpbGUiOiJjdXJyZW50dGltZS5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyIudmlzLWN1cnJlbnQtdGltZSB7XG4gIGJhY2tncm91bmQtY29sb3I6ICNGRjdGNkU7XG4gIHdpZHRoOiAycHg7XG4gIHotaW5kZXg6IDE7XG4gIHBvaW50ZXItZXZlbnRzOiBub25lO1xufVxuXG4udmlzLXJvbGxpbmctbW9kZS1idG4ge1xuICBoZWlnaHQ6IDQwcHg7XG4gIHdpZHRoOiA0MHB4O1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIHRvcDogN3B4O1xuICByaWdodDogMjBweDtcbiAgYm9yZGVyLXJhZGl1czogNTAlO1xuICBmb250LXNpemU6IDI4cHg7XG4gIGN1cnNvcjogcG9pbnRlcjtcbiAgb3BhY2l0eTogMC44O1xuICBjb2xvcjogd2hpdGU7XG4gIGZvbnQtd2VpZ2h0OiBib2xkO1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gIGJhY2tncm91bmQ6ICMzODc2YzI7XG59XG4udmlzLXJvbGxpbmctbW9kZS1idG46YmVmb3JlIHtcbiAgY29udGVudDogXCJcXDI2RjZcIjtcbn1cblxuLnZpcy1yb2xsaW5nLW1vZGUtYnRuOmhvdmVyIHtcbiAgb3BhY2l0eTogMTtcbn0iXX0= */');Ph(".vis-panel{position:absolute;padding:0;margin:0;box-sizing:border-box}.vis-panel.vis-bottom,.vis-panel.vis-center,.vis-panel.vis-left,.vis-panel.vis-right,.vis-panel.vis-top{border:1px #bfbfbf}.vis-panel.vis-center,.vis-panel.vis-left,.vis-panel.vis-right{border-top-style:solid;border-bottom-style:solid;overflow:hidden}.vis-left.vis-panel.vis-vertical-scroll,.vis-right.vis-panel.vis-vertical-scroll{height:100%;overflow-x:hidden;overflow-y:scroll}.vis-left.vis-panel.vis-vertical-scroll{direction:rtl}.vis-left.vis-panel.vis-vertical-scroll .vis-content,.vis-right.vis-panel.vis-vertical-scroll{direction:ltr}.vis-right.vis-panel.vis-vertical-scroll .vis-content{direction:rtl}.vis-panel.vis-bottom,.vis-panel.vis-center,.vis-panel.vis-top{border-left-style:solid;border-right-style:solid}.vis-background{overflow:hidden}.vis-panel>.vis-content{position:relative}.vis-panel .vis-shadow{position:absolute;width:100%;height:1px;box-shadow:0 0 10px rgba(0,0,0,.8)}.vis-panel .vis-shadow.vis-top{top:-1px;left:0}.vis-panel .vis-shadow.vis-bottom{bottom:-1px;left:0}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBhbmVsLmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxXQUNFLGlCQUFrQixDQUVsQixTQUFVLENBQ1YsUUFBUyxDQUVULHFCQUNGLENBRUEsd0dBS0Usa0JBQ0YsQ0FFQSwrREFHRSxzQkFBdUIsQ0FDdkIseUJBQTBCLENBQzFCLGVBQ0YsQ0FFQSxpRkFDRSxXQUFZLENBQ1osaUJBQWtCLENBQ2xCLGlCQUNGLENBRUEsd0NBQ0UsYUFDRixDQU1BLDhGQUNFLGFBQ0YsQ0FFQSxzREFDRSxhQUNGLENBRUEsK0RBR0UsdUJBQXdCLENBQ3hCLHdCQUNGLENBRUEsZ0JBQ0UsZUFDRixDQUVBLHdCQUNFLGlCQUNGLENBRUEsdUJBQ0UsaUJBQWtCLENBQ2xCLFVBQVcsQ0FDWCxVQUFXLENBQ1gsa0NBSUYsQ0FFQSwrQkFDRSxRQUFTLENBQ1QsTUFDRixDQUVBLGtDQUNFLFdBQVksQ0FDWixNQUNGIiwiZmlsZSI6InBhbmVsLmNzcyIsInNvdXJjZXNDb250ZW50IjpbIi52aXMtcGFuZWwge1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG5cbiAgcGFkZGluZzogMDtcbiAgbWFyZ2luOiAwO1xuXG4gIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG59XG5cbi52aXMtcGFuZWwudmlzLWNlbnRlcixcbi52aXMtcGFuZWwudmlzLWxlZnQsXG4udmlzLXBhbmVsLnZpcy1yaWdodCxcbi52aXMtcGFuZWwudmlzLXRvcCxcbi52aXMtcGFuZWwudmlzLWJvdHRvbSB7XG4gIGJvcmRlcjogMXB4ICNiZmJmYmY7XG59XG5cbi52aXMtcGFuZWwudmlzLWNlbnRlcixcbi52aXMtcGFuZWwudmlzLWxlZnQsXG4udmlzLXBhbmVsLnZpcy1yaWdodCB7XG4gIGJvcmRlci10b3Atc3R5bGU6IHNvbGlkO1xuICBib3JkZXItYm90dG9tLXN0eWxlOiBzb2xpZDtcbiAgb3ZlcmZsb3c6IGhpZGRlbjtcbn1cblxuLnZpcy1sZWZ0LnZpcy1wYW5lbC52aXMtdmVydGljYWwtc2Nyb2xsLCAudmlzLXJpZ2h0LnZpcy1wYW5lbC52aXMtdmVydGljYWwtc2Nyb2xsIHtcbiAgaGVpZ2h0OiAxMDAlO1xuICBvdmVyZmxvdy14OiBoaWRkZW47XG4gIG92ZXJmbG93LXk6IHNjcm9sbDtcbn0gXG5cbi52aXMtbGVmdC52aXMtcGFuZWwudmlzLXZlcnRpY2FsLXNjcm9sbCB7XG4gIGRpcmVjdGlvbjogcnRsO1xufVxuXG4udmlzLWxlZnQudmlzLXBhbmVsLnZpcy12ZXJ0aWNhbC1zY3JvbGwgLnZpcy1jb250ZW50IHtcbiAgZGlyZWN0aW9uOiBsdHI7XG59XG5cbi52aXMtcmlnaHQudmlzLXBhbmVsLnZpcy12ZXJ0aWNhbC1zY3JvbGwge1xuICBkaXJlY3Rpb246IGx0cjtcbn1cblxuLnZpcy1yaWdodC52aXMtcGFuZWwudmlzLXZlcnRpY2FsLXNjcm9sbCAudmlzLWNvbnRlbnQge1xuICBkaXJlY3Rpb246IHJ0bDtcbn1cblxuLnZpcy1wYW5lbC52aXMtY2VudGVyLFxuLnZpcy1wYW5lbC52aXMtdG9wLFxuLnZpcy1wYW5lbC52aXMtYm90dG9tIHtcbiAgYm9yZGVyLWxlZnQtc3R5bGU6IHNvbGlkO1xuICBib3JkZXItcmlnaHQtc3R5bGU6IHNvbGlkO1xufVxuXG4udmlzLWJhY2tncm91bmQge1xuICBvdmVyZmxvdzogaGlkZGVuO1xufVxuXG4udmlzLXBhbmVsID4gLnZpcy1jb250ZW50IHtcbiAgcG9zaXRpb246IHJlbGF0aXZlO1xufVxuXG4udmlzLXBhbmVsIC52aXMtc2hhZG93IHtcbiAgcG9zaXRpb246IGFic29sdXRlO1xuICB3aWR0aDogMTAwJTtcbiAgaGVpZ2h0OiAxcHg7XG4gIGJveC1zaGFkb3c6IDAgMCAxMHB4IHJnYmEoMCwwLDAsMC44KTtcbiAgLyogVE9ETzogZmluZCBhIG5pY2Ugd2F5IHRvIGVuc3VyZSB2aXMtc2hhZG93cyBhcmUgZHJhd24gb24gdG9wIG9mIGl0ZW1zXG4gIHotaW5kZXg6IDE7XG4gICovXG59XG5cbi52aXMtcGFuZWwgLnZpcy1zaGFkb3cudmlzLXRvcCB7XG4gIHRvcDogLTFweDtcbiAgbGVmdDogMDtcbn1cblxuLnZpcy1wYW5lbCAudmlzLXNoYWRvdy52aXMtYm90dG9tIHtcbiAgYm90dG9tOiAtMXB4O1xuICBsZWZ0OiAwO1xufSJdfQ== */");Ph(".vis-graph-group0{fill:#4f81bd;fill-opacity:0;stroke-width:2px;stroke:#4f81bd}.vis-graph-group1{fill:#f79646;fill-opacity:0;stroke-width:2px;stroke:#f79646}.vis-graph-group2{fill:#8c51cf;fill-opacity:0;stroke-width:2px;stroke:#8c51cf}.vis-graph-group3{fill:#75c841;fill-opacity:0;stroke-width:2px;stroke:#75c841}.vis-graph-group4{fill:#ff0100;fill-opacity:0;stroke-width:2px;stroke:#ff0100}.vis-graph-group5{fill:#37d8e6;fill-opacity:0;stroke-width:2px;stroke:#37d8e6}.vis-graph-group6{fill:#042662;fill-opacity:0;stroke-width:2px;stroke:#042662}.vis-graph-group7{fill:#00ff26;fill-opacity:0;stroke-width:2px;stroke:#00ff26}.vis-graph-group8{fill:#f0f;fill-opacity:0;stroke-width:2px;stroke:#f0f}.vis-graph-group9{fill:#8f3938;fill-opacity:0;stroke-width:2px;stroke:#8f3938}.vis-timeline .vis-fill{fill-opacity:.1;stroke:none}.vis-timeline .vis-bar{fill-opacity:.5;stroke-width:1px}.vis-timeline .vis-point{stroke-width:2px;fill-opacity:1}.vis-timeline .vis-legend-background{stroke-width:1px;fill-opacity:.9;fill:#fff;stroke:#c2c2c2}.vis-timeline .vis-outline{stroke-width:1px;fill-opacity:1;fill:#fff;stroke:#e5e5e5}.vis-timeline .vis-icon-fill{fill-opacity:.3;stroke:none}\n/*# sourceMappingURL=data:application/json;base64,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 */");Ph(".vis-timeline{position:relative;border:1px solid #bfbfbf;overflow:hidden;padding:0;margin:0;box-sizing:border-box}.vis-loading-screen{width:100%;height:100%;position:absolute;top:0;left:0}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRpbWVsaW5lLmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFDQSxjQUNFLGlCQUFrQixDQUNsQix3QkFBeUIsQ0FDekIsZUFBZ0IsQ0FDaEIsU0FBVSxDQUNWLFFBQVMsQ0FDVCxxQkFDRixDQUVBLG9CQUNFLFVBQVcsQ0FDWCxXQUFZLENBQ1osaUJBQWtCLENBQ2xCLEtBQU0sQ0FDTixNQUNGIiwiZmlsZSI6InRpbWVsaW5lLmNzcyIsInNvdXJjZXNDb250ZW50IjpbIlxuLnZpcy10aW1lbGluZSB7XG4gIHBvc2l0aW9uOiByZWxhdGl2ZTtcbiAgYm9yZGVyOiAxcHggc29saWQgI2JmYmZiZjtcbiAgb3ZlcmZsb3c6IGhpZGRlbjtcbiAgcGFkZGluZzogMDtcbiAgbWFyZ2luOiAwO1xuICBib3gtc2l6aW5nOiBib3JkZXItYm94O1xufVxuXG4udmlzLWxvYWRpbmctc2NyZWVuIHtcbiAgd2lkdGg6IDEwMCU7XG4gIGhlaWdodDogMTAwJTtcbiAgcG9zaXRpb246IGFic29sdXRlO1xuICB0b3A6IDA7XG4gIGxlZnQ6IDA7XG59Il19 */");Ph(".vis [class*=span]{min-height:0;width:auto}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJvb3RzdHJhcC5jc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBRUEsbUJBQ0UsWUFBYSxDQUNiLFVBQ0YiLCJmaWxlIjoiYm9vdHN0cmFwLmNzcyIsInNvdXJjZXNDb250ZW50IjpbIi8qIG92ZXJyaWRlIHNvbWUgYm9vdHN0cmFwIHN0eWxlcyBzY3Jld2luZyB1cCB0aGUgdGltZWxpbmVzIGNzcyAqL1xuXG4udmlzIFtjbGFzcyo9XCJzcGFuXCJdIHtcbiAgbWluLWhlaWdodDogMDtcbiAgd2lkdGg6IGF1dG87XG59XG4iXX0= */");var cd=function(){function t(){ba(this,t)}return xa(t,[{key:"_create",value:function(t){var e,i,n,o=this;this.dom={},this.dom.container=t,this.dom.container.style.position="relative",this.dom.root=document.createElement("div"),this.dom.background=document.createElement("div"),this.dom.backgroundVertical=document.createElement("div"),this.dom.backgroundHorizontal=document.createElement("div"),this.dom.centerContainer=document.createElement("div"),this.dom.leftContainer=document.createElement("div"),this.dom.rightContainer=document.createElement("div"),this.dom.center=document.createElement("div"),this.dom.left=document.createElement("div"),this.dom.right=document.createElement("div"),this.dom.top=document.createElement("div"),this.dom.bottom=document.createElement("div"),this.dom.shadowTop=document.createElement("div"),this.dom.shadowBottom=document.createElement("div"),this.dom.shadowTopLeft=document.createElement("div"),this.dom.shadowBottomLeft=document.createElement("div"),this.dom.shadowTopRight=document.createElement("div"),this.dom.shadowBottomRight=document.createElement("div"),this.dom.rollingModeBtn=document.createElement("div"),this.dom.loadingScreen=document.createElement("div"),this.dom.root.className="vis-timeline",this.dom.background.className="vis-panel vis-background",this.dom.backgroundVertical.className="vis-panel vis-background vis-vertical",this.dom.backgroundHorizontal.className="vis-panel vis-background vis-horizontal",this.dom.centerContainer.className="vis-panel vis-center",this.dom.leftContainer.className="vis-panel vis-left",this.dom.rightContainer.className="vis-panel vis-right",this.dom.top.className="vis-panel vis-top",this.dom.bottom.className="vis-panel vis-bottom",this.dom.left.className="vis-content",this.dom.center.className="vis-content",this.dom.right.className="vis-content",this.dom.shadowTop.className="vis-shadow vis-top",this.dom.shadowBottom.className="vis-shadow vis-bottom",this.dom.shadowTopLeft.className="vis-shadow vis-top",this.dom.shadowBottomLeft.className="vis-shadow vis-bottom",this.dom.shadowTopRight.className="vis-shadow vis-top",this.dom.shadowBottomRight.className="vis-shadow vis-bottom",this.dom.rollingModeBtn.className="vis-rolling-mode-btn",this.dom.loadingScreen.className="vis-loading-screen",this.dom.root.appendChild(this.dom.background),this.dom.root.appendChild(this.dom.backgroundVertical),this.dom.root.appendChild(this.dom.backgroundHorizontal),this.dom.root.appendChild(this.dom.centerContainer),this.dom.root.appendChild(this.dom.leftContainer),this.dom.root.appendChild(this.dom.rightContainer),this.dom.root.appendChild(this.dom.top),this.dom.root.appendChild(this.dom.bottom),this.dom.root.appendChild(this.dom.rollingModeBtn),this.dom.centerContainer.appendChild(this.dom.center),this.dom.leftContainer.appendChild(this.dom.left),this.dom.rightContainer.appendChild(this.dom.right),this.dom.centerContainer.appendChild(this.dom.shadowTop),this.dom.centerContainer.appendChild(this.dom.shadowBottom),this.dom.leftContainer.appendChild(this.dom.shadowTopLeft),this.dom.leftContainer.appendChild(this.dom.shadowBottomLeft),this.dom.rightContainer.appendChild(this.dom.shadowTopRight),this.dom.rightContainer.appendChild(this.dom.shadowBottomRight),this.props={root:{},background:{},centerContainer:{},leftContainer:{},rightContainer:{},center:{},left:{},right:{},top:{},bottom:{},border:{},scrollTop:0,scrollTopMin:0},this.on("rangechange",(function(){!0===o.initialDrawDone&&o._redraw()})),this.on("rangechanged",(function(){o.initialRangeChangeDone||(o.initialRangeChangeDone=!0)})),this.on("touch",va(e=this._onTouch).call(e,this)),this.on("panmove",va(i=this._onDrag).call(i,this));var s=this;this._origRedraw=va(n=this._redraw).call(n,this),this._redraw=za.throttle(this._origRedraw),this.on("_change",(function(t){s.itemSet&&s.itemSet.initialItemSetDrawn&&t&&1==t.queue?s._redraw():s._origRedraw()})),this.hammer=new Vh(this.dom.root);var r=this.hammer.get("pinch").set({enable:!0});r&&function(t){t.getTouchAction=function(){return["pan-y"]}}(r),this.hammer.get("pan").set({threshold:5,direction:Vh.DIRECTION_ALL}),this.listeners={};var a,l,h=["tap","doubletap","press","pinch","pan","panstart","panmove","panend"];function d(t){this.isActive()&&this.emit("mousewheel",t);var e=0,i=0;if("detail"in t&&(i=-1*t.detail),"wheelDelta"in t&&(i=t.wheelDelta),"wheelDeltaY"in t&&(i=t.wheelDeltaY),"wheelDeltaX"in t&&(e=-1*t.wheelDeltaX),"axis"in t&&t.axis===t.HORIZONTAL_AXIS&&(e=-1*i,i=0),"deltaY"in t&&(i=-1*t.deltaY),"deltaX"in t&&(e=t.deltaX),t.deltaMode&&(1===t.deltaMode?(e*=40,i*=40):(e*=40,i*=800)),this.options.preferZoom){if(!this.options.zoomKey||t[this.options.zoomKey])return}else if(this.options.zoomKey&&t[this.options.zoomKey])return;if(this.options.verticalScroll||this.options.horizontalScroll)if(this.options.verticalScroll&&Math.abs(i)>=Math.abs(e)){var n=this.props.scrollTop,o=n+i;if(this.isActive())this._setScrollTop(o)!==n&&(this._redraw(),this.emit("scroll",t),t.preventDefault())}else if(this.options.horizontalScroll){var s=(Math.abs(e)>=Math.abs(i)?e:i)/120*(this.range.end-this.range.start)/20,r=this.range.start+s,a=this.range.end+s,l={animation:!1,byUser:!0,event:t};this.range.setRange(r,a,l),t.preventDefault()}}mn(h).call(h,(function(t){var e=function(e){s.isActive()&&s.emit(t,e)};s.hammer.on(t,e),s.listeners[t]=e})),jh(this.hammer,(function(t){s.emit("touch",t)})),a=this.hammer,(l=function(t){s.emit("release",t)}).inputHandler=function(t){t.isFinal&&l(t)},a.on("hammer.input",l.inputHandler);var u="onwheel"in document.createElement("div")?"wheel":void 0!==document.onmousewheel?"mousewheel":this.dom.centerContainer.addEventListener?"DOMMouseScroll":"onmousewheel";function c(t){if(s.options.verticalScroll)if(s._isProgramaticallyScrolled)s._isProgramaticallyScrolled=!1;else if(t.preventDefault(),s.isActive()){var e=-t.target.scrollTop;s._setScrollTop(e),s._redraw(),s.emit("scrollSide",t)}}this.dom.top.addEventListener,this.dom.bottom.addEventListener,this.dom.centerContainer.addEventListener(u,va(d).call(d,this),!1),this.dom.top.addEventListener(u,va(d).call(d,this),!1),this.dom.bottom.addEventListener(u,va(d).call(d,this),!1),this.dom.left.parentNode.addEventListener("scroll",va(c).call(c,this)),this.dom.right.parentNode.addEventListener("scroll",va(c).call(c,this));var p=!1;function m(t){var e;if(t.preventDefault&&(s.emit("dragover",s.getEventProperties(t)),t.preventDefault()),Fo(e=t.target.className).call(e,"timeline")>-1&&!p)return t.dataTransfer.dropEffect="move",p=!0,!1}function f(t){t.preventDefault&&t.preventDefault(),t.stopPropagation&&t.stopPropagation();try{var e=JSON.parse(t.dataTransfer.getData("text"));if(!e||!e.content)return}catch(t){return!1}return p=!1,t.center={x:t.clientX,y:t.clientY},"item"!==e.target?s.itemSet._onAddItem(t):s.itemSet._onDropObjectOnItem(t),s.emit("drop",s.getEventProperties(t)),!1}if(this.dom.center.addEventListener("dragover",va(m).call(m,this),!1),this.dom.center.addEventListener("drop",va(f).call(f,this),!1),this.customTimes=[],this.touch={},this.redrawCount=0,this.initialDrawDone=!1,this.initialRangeChangeDone=!1,!t)throw new Error("No container provided");t.appendChild(this.dom.root),t.appendChild(this.dom.loadingScreen)}},{key:"setOptions",value:function(t){var e;if(t){if(za.selectiveExtend(["width","height","minHeight","maxHeight","autoResize","start","end","clickToUse","dataAttributes","hiddenDates","locale","locales","moment","preferZoom","rtl","zoomKey","horizontalScroll","verticalScroll","longSelectPressTime"],this.options,t),this.dom.rollingModeBtn.style.visibility="hidden",this.options.rtl&&(this.dom.container.style.direction="rtl",this.dom.backgroundVertical.className="vis-panel vis-background vis-vertical-rtl"),this.options.verticalScroll&&(this.options.rtl?this.dom.rightContainer.className="vis-panel vis-right vis-vertical-scroll":this.dom.leftContainer.className="vis-panel vis-left vis-vertical-scroll"),"object"!==zo(this.options.orientation)&&(this.options.orientation={item:void 0,axis:void 0}),"orientation"in t&&("string"==typeof t.orientation?this.options.orientation={item:t.orientation,axis:t.orientation}:"object"===zo(t.orientation)&&("item"in t.orientation&&(this.options.orientation.item=t.orientation.item),"axis"in t.orientation&&(this.options.orientation.axis=t.orientation.axis))),"both"===this.options.orientation.axis){if(!this.timeAxis2){var i=this.timeAxis2=new Jh(this.body);i.setOptions=function(t){var e=t?za.extend({},t):{};e.orientation="top",Jh.prototype.setOptions.call(i,e)},this.components.push(i)}}else if(this.timeAxis2){var n,o,s=Fo(n=this.components).call(n,this.timeAxis2);if(-1!==s)Hr(o=this.components).call(o,s,1);this.timeAxis2.destroy(),this.timeAxis2=null}"function"==typeof t.drawPoints&&(t.drawPoints={onRender:t.drawPoints}),"hiddenDates"in this.options&&tl(this.options.moment,this.body,this.options.hiddenDates),"clickToUse"in t&&(t.clickToUse?this.activator||(this.activator=new $h(this.dom.root)):this.activator&&(this.activator.destroy(),delete this.activator)),this._initAutoResize()}if(mn(e=this.components).call(e,(function(e){return e.setOptions(t)})),"configure"in t){var r;this.configurator||(this.configurator=this._createConfigurator()),this.configurator.setOptions(t.configure);var a=za.deepExtend({},this.options);mn(r=this.components).call(r,(function(t){za.deepExtend(a,t.options)})),this.configurator.setModuleOptions({global:a})}this._redraw()}},{key:"isActive",value:function(){return!this.activator||this.activator.active}},{key:"destroy",value:function(){var t;for(var e in this.setItems(null),this.setGroups(null),this.off(),this._stopAutoResize(),this.dom.root.parentNode&&this.dom.root.parentNode.removeChild(this.dom.root),this.dom=null,this.activator&&(this.activator.destroy(),delete this.activator),this.listeners)this.listeners.hasOwnProperty(e)&&delete this.listeners[e];this.listeners=null,this.hammer&&this.hammer.destroy(),this.hammer=null,mn(t=this.components).call(t,(function(t){return t.destroy()})),this.body=null}},{key:"setCustomTime",value:function(t,e){var i,n=En(i=this.customTimes).call(i,(function(t){return e===t.options.id}));if(0===n.length)throw new Error("No custom time bar found with id ".concat(Vs(e)));n.length>0&&n[0].setCustomTime(t)}},{key:"getCustomTime",value:function(t){var e,i=En(e=this.customTimes).call(e,(function(e){return e.options.id===t}));if(0===i.length)throw new Error("No custom time bar found with id ".concat(Vs(t)));return i[0].getCustomTime()}},{key:"setCustomTimeMarker",value:function(t,e,i){var n,o=En(n=this.customTimes).call(n,(function(t){return t.options.id===e}));if(0===o.length)throw new Error("No custom time bar found with id ".concat(Vs(e)));o.length>0&&o[0].setCustomMarker(t,i)}},{key:"setCustomTimeTitle",value:function(t,e){var i,n=En(i=this.customTimes).call(i,(function(t){return t.options.id===e}));if(0===n.length)throw new Error("No custom time bar found with id ".concat(Vs(e)));if(n.length>0)return n[0].setCustomTitle(t)}},{key:"getEventProperties",value:function(t){return{event:t}}},{key:"addCustomTime",value:function(t,e){var i,n=void 0!==t?za.convert(t,"Date"):new Date;if(rr(i=this.customTimes).call(i,(function(t){return t.options.id===e})))throw new Error("A custom time with id ".concat(Vs(e)," already exists"));var o=new ud(this.body,za.extend({},this.options,{time:n,id:e,snap:this.itemSet.options.snap}));return this.customTimes.push(o),this.components.push(o),this._redraw(),e}},{key:"removeCustomTime",value:function(t){var e,i=this,n=En(e=this.customTimes).call(e,(function(e){return e.options.id===t}));if(0===n.length)throw new Error("No custom time bar found with id ".concat(Vs(t)));mn(n).call(n,(function(t){var e,n,o,s;Hr(e=i.customTimes).call(e,Fo(n=i.customTimes).call(n,t),1),Hr(o=i.components).call(o,Fo(s=i.components).call(s,t),1),t.destroy()}))}},{key:"getVisibleItems",value:function(){return this.itemSet&&this.itemSet.getVisibleItems()||[]}},{key:"getVisibleGroups",value:function(){return this.itemSet&&this.itemSet.getVisibleGroups()||[]}},{key:"fit",value:function(t,e){var i=this.getDataRange();if(null!==i.min||null!==i.max){var n=i.max-i.min,o=new Date(i.min.valueOf()-.01*n),s=new Date(i.max.valueOf()+.01*n),r=!t||void 0===t.animation||t.animation;this.range.setRange(o,s,{animation:r},e)}}},{key:"getDataRange",value:function(){throw new Error("Cannot invoke abstract method getDataRange")}},{key:"setWindow",value:function(t,e,i,n){var o,s;"function"==typeof arguments[2]&&(n=arguments[2],i={}),1==arguments.length?(o=void 0===(s=arguments[0]).animation||s.animation,this.range.setRange(s.start,s.end,{animation:o})):2==arguments.length&&"function"==typeof arguments[1]?(s=arguments[0],n=arguments[1],o=void 0===s.animation||s.animation,this.range.setRange(s.start,s.end,{animation:o},n)):(o=!i||void 0===i.animation||i.animation,this.range.setRange(t,e,{animation:o},n))}},{key:"moveTo",value:function(t,e,i){"function"==typeof arguments[1]&&(i=arguments[1],e={});var n=this.range.end-this.range.start,o=za.convert(t,"Date").valueOf(),s=o-n/2,r=o+n/2,a=!e||void 0===e.animation||e.animation;this.range.setRange(s,r,{animation:a},i)}},{key:"getWindow",value:function(){var t=this.range.getRange();return{start:new Date(t.start),end:new Date(t.end)}}},{key:"zoomIn",value:function(t,e,i){if(!(!t||t<0||t>1)){"function"==typeof arguments[1]&&(i=arguments[1],e={});var n=this.getWindow(),o=n.start.valueOf(),s=n.end.valueOf(),r=s-o,a=r/(1+t),l=(r-a)/2,h=o+l,d=s-l;this.setWindow(h,d,e,i)}}},{key:"zoomOut",value:function(t,e,i){if(!(!t||t<0||t>1)){"function"==typeof arguments[1]&&(i=arguments[1],e={});var n=this.getWindow(),o=n.start.valueOf(),s=n.end.valueOf(),r=s-o,a=o-r*t/2,l=s+r*t/2;this.setWindow(a,l,e,i)}}},{key:"redraw",value:function(){this._redraw()}},{key:"_redraw",value:function(){var t;this.redrawCount++;var e=this.dom;if(e&&e.container&&0!=e.root.offsetWidth){var i=!1,n=this.options,o=this.props;el(this.options.moment,this.body,this.options.hiddenDates),"top"==n.orientation?(za.addClassName(e.root,"vis-top"),za.removeClassName(e.root,"vis-bottom")):(za.removeClassName(e.root,"vis-top"),za.addClassName(e.root,"vis-bottom")),n.rtl?(za.addClassName(e.root,"vis-rtl"),za.removeClassName(e.root,"vis-ltr")):(za.addClassName(e.root,"vis-ltr"),za.removeClassName(e.root,"vis-rtl")),e.root.style.maxHeight=za.option.asSize(n.maxHeight,""),e.root.style.minHeight=za.option.asSize(n.minHeight,""),e.root.style.width=za.option.asSize(n.width,"");var s=e.root.offsetWidth;o.border.left=1,o.border.right=1,o.border.top=1,o.border.bottom=1,o.center.height=e.center.offsetHeight,o.left.height=e.left.offsetHeight,o.right.height=e.right.offsetHeight,o.top.height=e.top.clientHeight||-o.border.top,o.bottom.height=e.bottom.clientHeight||-o.border.bottom;var r=Math.max(o.left.height,o.center.height,o.right.height),a=o.top.height+r+o.bottom.height+o.border.top+o.border.bottom;e.root.style.height=za.option.asSize(n.height,"".concat(a,"px")),o.root.height=e.root.offsetHeight,o.background.height=o.root.height;var l=o.root.height-o.top.height-o.bottom.height;o.centerContainer.height=l,o.leftContainer.height=l,o.rightContainer.height=o.leftContainer.height,o.root.width=s,o.background.width=o.root.width,this.initialDrawDone||(o.scrollbarWidth=za.getScrollBarWidth());var h=e.leftContainer.clientWidth,d=e.rightContainer.clientWidth;n.verticalScroll?n.rtl?(o.left.width=h||-o.border.left,o.right.width=d+o.scrollbarWidth||-o.border.right):(o.left.width=h+o.scrollbarWidth||-o.border.left,o.right.width=d||-o.border.right):(o.left.width=h||-o.border.left,o.right.width=d||-o.border.right),this._setDOM();var u=this._updateScrollTop();"top"!=n.orientation.item&&(u+=Math.max(o.centerContainer.height-o.center.height-o.border.top-o.border.bottom,0)),e.center.style.transform="translateY(".concat(u,"px)");var c=0==o.scrollTop?"hidden":"",p=o.scrollTop==o.scrollTopMin?"hidden":"";e.shadowTop.style.visibility=c,e.shadowBottom.style.visibility=p,e.shadowTopLeft.style.visibility=c,e.shadowBottomLeft.style.visibility=p,e.shadowTopRight.style.visibility=c,e.shadowBottomRight.style.visibility=p,n.verticalScroll&&(e.rightContainer.className="vis-panel vis-right vis-vertical-scroll",e.leftContainer.className="vis-panel vis-left vis-vertical-scroll",e.shadowTopRight.style.visibility="hidden",e.shadowBottomRight.style.visibility="hidden",e.shadowTopLeft.style.visibility="hidden",e.shadowBottomLeft.style.visibility="hidden",e.left.style.top="0px",e.right.style.top="0px"),(!n.verticalScroll||o.center.height<o.centerContainer.height)&&(e.left.style.top="".concat(u,"px"),e.right.style.top="".concat(u,"px"),e.rightContainer.className=e.rightContainer.className.replace(new RegExp("(?:^|\\s)vis-vertical-scroll(?:\\s|$)")," "),e.leftContainer.className=e.leftContainer.className.replace(new RegExp("(?:^|\\s)vis-vertical-scroll(?:\\s|$)")," "),o.left.width=h||-o.border.left,o.right.width=d||-o.border.right,this._setDOM());var m=o.center.height>o.centerContainer.height;this.hammer.get("pan").set({direction:m?Vh.DIRECTION_ALL:Vh.DIRECTION_HORIZONTAL}),this.hammer.get("press").set({time:this.options.longSelectPressTime}),mn(t=this.components).call(t,(function(t){i=t.redraw()||i}));if(i){if(this.redrawCount<5)return void this.body.emitter.emit("_change");console.log("WARNING: infinite loop in redraw?")}else this.redrawCount=0;this.body.emitter.emit("changed")}}},{key:"_setDOM",value:function(){var t=this.props,e=this.dom;t.leftContainer.width=t.left.width,t.rightContainer.width=t.right.width;var i=t.root.width-t.left.width-t.right.width;t.center.width=i,t.centerContainer.width=i,t.top.width=i,t.bottom.width=i,e.background.style.height="".concat(t.background.height,"px"),e.backgroundVertical.style.height="".concat(t.background.height,"px"),e.backgroundHorizontal.style.height="".concat(t.centerContainer.height,"px"),e.centerContainer.style.height="".concat(t.centerContainer.height,"px"),e.leftContainer.style.height="".concat(t.leftContainer.height,"px"),e.rightContainer.style.height="".concat(t.rightContainer.height,"px"),e.background.style.width="".concat(t.background.width,"px"),e.backgroundVertical.style.width="".concat(t.centerContainer.width,"px"),e.backgroundHorizontal.style.width="".concat(t.background.width,"px"),e.centerContainer.style.width="".concat(t.center.width,"px"),e.top.style.width="".concat(t.top.width,"px"),e.bottom.style.width="".concat(t.bottom.width,"px"),e.background.style.left="0",e.background.style.top="0",e.backgroundVertical.style.left="".concat(t.left.width+t.border.left,"px"),e.backgroundVertical.style.top="0",e.backgroundHorizontal.style.left="0",e.backgroundHorizontal.style.top="".concat(t.top.height,"px"),e.centerContainer.style.left="".concat(t.left.width,"px"),e.centerContainer.style.top="".concat(t.top.height,"px"),e.leftContainer.style.left="0",e.leftContainer.style.top="".concat(t.top.height,"px"),e.rightContainer.style.left="".concat(t.left.width+t.center.width,"px"),e.rightContainer.style.top="".concat(t.top.height,"px"),e.top.style.left="".concat(t.left.width,"px"),e.top.style.top="0",e.bottom.style.left="".concat(t.left.width,"px"),e.bottom.style.top="".concat(t.top.height+t.centerContainer.height,"px"),e.center.style.left="0",e.left.style.left="0",e.right.style.left="0"}},{key:"setCurrentTime",value:function(t){if(!this.currentTime)throw new Error("Option showCurrentTime must be true");this.currentTime.setCurrentTime(t)}},{key:"getCurrentTime",value:function(){if(!this.currentTime)throw new Error("Option showCurrentTime must be true");return this.currentTime.getCurrentTime()}},{key:"_toTime",value:function(t){return sl(this,t,this.props.center.width)}},{key:"_toGlobalTime",value:function(t){return sl(this,t,this.props.root.width)}},{key:"_toScreen",value:function(t){return ol(this,t,this.props.center.width)}},{key:"_toGlobalScreen",value:function(t){return ol(this,t,this.props.root.width)}},{key:"_initAutoResize",value:function(){1==this.options.autoResize?this._startAutoResize():this._stopAutoResize()}},{key:"_startAutoResize",value:function(){var t=this;this._stopAutoResize(),this._onResize=function(){if(1==t.options.autoResize){if(t.dom.root){var e=t.dom.root.offsetHeight,i=t.dom.root.offsetWidth;i==t.props.lastWidth&&e==t.props.lastHeight||(t.props.lastWidth=i,t.props.lastHeight=e,t.props.scrollbarWidth=za.getScrollBarWidth(),t.body.emitter.emit("_change"))}}else t._stopAutoResize()},za.addEventListener(window,"resize",this._onResize),t.dom.root&&(t.props.lastWidth=t.dom.root.offsetWidth,t.props.lastHeight=t.dom.root.offsetHeight),this.watchTimer=gl(this._onResize,1e3)}},{key:"_stopAutoResize",value:function(){this.watchTimer&&(clearInterval(this.watchTimer),this.watchTimer=void 0),this._onResize&&(za.removeEventListener(window,"resize",this._onResize),this._onResize=null)}},{key:"_onTouch",value:function(t){this.touch.allowDragging=!0,this.touch.initialScrollTop=this.props.scrollTop}},{key:"_onPinch",value:function(t){this.touch.allowDragging=!1}},{key:"_onDrag",value:function(t){if(t&&this.touch.allowDragging){var e=t.deltaY,i=this._getScrollTop(),n=this._setScrollTop(this.touch.initialScrollTop+e);this.options.verticalScroll&&(this.dom.left.parentNode.scrollTop=-this.props.scrollTop,this.dom.right.parentNode.scrollTop=-this.props.scrollTop),n!=i&&this.emit("verticalDrag")}}},{key:"_setScrollTop",value:function(t){return this.props.scrollTop=t,this._updateScrollTop(),this.props.scrollTop}},{key:"_updateScrollTop",value:function(){var t=Math.min(this.props.centerContainer.height-this.props.center.height,0);return t!=this.props.scrollTopMin&&("top"!=this.options.orientation.item&&(this.props.scrollTop+=t-this.props.scrollTopMin),this.props.scrollTopMin=t),this.props.scrollTop>0&&(this.props.scrollTop=0),this.props.scrollTop<t&&(this.props.scrollTop=t),this.options.verticalScroll&&(this.dom.left.parentNode.scrollTop=-this.props.scrollTop,this.dom.right.parentNode.scrollTop=-this.props.scrollTop),this._isProgramaticallyScrolled=!0,this.props.scrollTop}},{key:"_getScrollTop",value:function(){return this.props.scrollTop}},{key:"_createConfigurator",value:function(){throw new Error("Cannot invoke abstract method _createConfigurator")}}]),t}();vl(cd.prototype);var pd=function(t){function e(t,i){var n,o;ba(this,e),(o=ar(this,dr(e).call(this))).body=t,o.defaultOptions={rtl:!1,showCurrentTime:!0,alignCurrentTime:void 0,moment:Ta,locales:dd,locale:"en"},o.options=za.extend({},o.defaultOptions),o.setOptions(i),o.options.locales=za.extend({},dd,o.options.locales);var s=o.defaultOptions.locales[o.defaultOptions.locale];return mn(n=Yi(o.options.locales)).call(n,(function(t){o.options.locales[t]=za.extend({},s,o.options.locales[t])})),o.offset=0,o._create(),o}return pr(e,t),xa(e,[{key:"_create",value:function(){var t=document.createElement("div");t.className="vis-current-time",t.style.position="absolute",t.style.top="0px",t.style.height="100%",this.bar=t}},{key:"destroy",value:function(){this.options.showCurrentTime=!1,this.redraw(),this.body=null}},{key:"setOptions",value:function(t){t&&za.selectiveExtend(["rtl","showCurrentTime","alignCurrentTime","moment","locale","locales"],this.options,t)}},{key:"redraw",value:function(){if(this.options.showCurrentTime){var t,e,i=this.body.dom.backgroundVertical;this.bar.parentNode!=i&&(this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar),i.appendChild(this.bar),this.start());var n=this.options.moment(Jo()+this.offset);this.options.alignCurrentTime&&(n=n.startOf(this.options.alignCurrentTime));var o=this.body.util.toScreen(n),s=this.options.locales[this.options.locale];s||(this.warned||(console.warn("WARNING: options.locales['".concat(this.options.locale,"'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization")),this.warned=!0),s=this.options.locales.en);var r=Pn(t=Pn(e="".concat(s.current," ")).call(e,s.time,": ")).call(t,n.format("dddd, MMMM Do YYYY, H:mm:ss"));r=r.charAt(0).toUpperCase()+r.substring(1),this.options.rtl?this.bar.style.transform="translateX(".concat(-1*o,"px)"):this.bar.style.transform="translateX(".concat(o,"px)"),this.bar.title=r}else this.bar.parentNode&&this.bar.parentNode.removeChild(this.bar),this.stop();return!1}},{key:"start",value:function(){var t=this;!function e(){t.stop();var i=1/t.body.range.conversion(t.body.domProps.center.width).scale/10;i<30&&(i=30),i>1e3&&(i=1e3),t.redraw(),t.body.emitter.emit("currentTimeTick"),t.currentTimeTimer=qr(e,i)}()}},{key:"stop",value:function(){void 0!==this.currentTimeTimer&&(clearTimeout(this.currentTimeTimer),delete this.currentTimeTimer)}},{key:"setCurrentTime",value:function(t){var e=za.convert(t,"Date").valueOf(),i=Jo();this.offset=e-i,this.redraw()}},{key:"getCurrentTime",value:function(){return new Date(Jo()+this.offset)}}]),e}(Ja),md=Ce.find,fd=!0,gd=on("find");"find"in[]&&Array(1).find((function(){fd=!1})),V({target:"Array",proto:!0,forced:fd||!gd},{find:function(t){return md(this,t,arguments.length>1?arguments[1]:void 0)}});var vd=Pi("Array").find,bd=Array.prototype,yd=function(t){var e=t.find;return t===bd||t instanceof Array&&e===bd.find?vd:e},xd="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||"undefined"!=typeof msCrypto&&"function"==typeof msCrypto.getRandomValues&&msCrypto.getRandomValues.bind(msCrypto),wd=new Uint8Array(16);function _d(){if(!xd)throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return xd(wd)}for(var kd=[],Dd=0;Dd<256;++Dd)kd[Dd]=(Dd+256).toString(16).substr(1);function Id(t,e,i){var n=e&&i||0;"string"==typeof t&&(e="binary"===t?new Array(16):null,t=null);var o=(t=t||{}).random||(t.rng||_d)();if(o[6]=15&o[6]|64,o[8]=63&o[8]|128,e)for(var s=0;s<16;++s)e[n+s]=o[s];return e||function(t,e){var i=e||0,n=kd;return[n[t[i++]],n[t[i++]],n[t[i++]],n[t[i++]],"-",n[t[i++]],n[t[i++]],"-",n[t[i++]],n[t[i++]],"-",n[t[i++]],n[t[i++]],"-",n[t[i++]],n[t[i++]],n[t[i++]],n[t[i++]],n[t[i++]],n[t[i++]]].join("")}(o)}var Cd=ot.includes,Ld=on("indexOf",{ACCESSORS:!0,1:0});V({target:"Array",proto:!0,forced:!Ld},{includes:function(t){return Cd(this,t,arguments.length>1?arguments[1]:void 0)}});var Gd=Pi("Array").includes,Md=Pt("match"),Sd=function(t){if(function(t){var e;return x(t)&&(void 0!==(e=t[Md])?!!e:"RegExp"==f(t))}(t))throw TypeError("The method doesn't accept regular expressions");return t},Qd=Pt("match");V({target:"String",proto:!0,forced:!function(t){var e=/./;try{"/./"[t](e)}catch(i){try{return e[Qd]=!1,"/./"[t](e)}catch(t){}}return!1}("includes")},{includes:function(t){return!!~String(b(this)).indexOf(Sd(t),arguments.length>1?arguments[1]:void 0)}});var Nd=Pi("String").includes,Fd=Array.prototype,Zd=String.prototype,Bd=function(t){var e=t.includes;return t===Fd||t instanceof Array&&e===Fd.includes?Gd:"string"==typeof t||t===Zd||t instanceof String&&e===Zd.includes?Nd:e};function Od(t){wr(t).call(t,(function(t,e){return t.data.start-e.data.start}))}function Wd(t){wr(t).call(t,(function(t,e){return("end"in t.data?t.data.end:t.data.start)-("end"in e.data?e.data.end:e.data.start)}))}function Ad(t,e,i,n){if(i)for(var o=0;o<t.length;o++)t[o].top=null;for(o=0;o<t.length;o++){var s=t[o];if(s.stack&&null===s.top){s.top=e.axis;var r=!1;do{for(var a=null,l=0,h=t.length;l<h;l++){var d=t[l];if(r=n()||!1)return!0;if(null!==d.top&&d!==s&&d.stack&&Rd(s,d,e.item,d.options.rtl)){a=d;break}}null!=a&&(s.top=a.top+a.height+e.item.vertical)}while(a)}}return r}function Xd(t,e,i){for(var n=0;n<t.length;n++)t[n].top=null;var o=i.height;for(n=0;n<t.length;n++){var s=t[n];if(s.stack&&null===s.top){s.top=s.baseTop;do{for(var r=null,a=0,l=t.length;a<l;a++){var h=t[a];if(null!==h.top&&h!==s&&Rd(s,h,e.item,h.options.rtl)){r=h;break}}null!=r&&(s.top=r.top+r.height+e.item.vertical),s.top+s.height>o&&(o=s.top+s.height)}while(r)}}i.height=o-i.top+.5*e.item.vertical}function Td(t,e,i,n){for(var o=0;o<t.length;o++)if(null==t[o].data.subgroup)t[o].top=e.item.vertical;else if(void 0!==t[o].data.subgroup&&n){var s=0;for(var r in i)i.hasOwnProperty(r)&&1==i[r].visible&&i[r].index<i[t[o].data.subgroup].index&&(s+=i[r].height,i[t[o].data.subgroup].top=s);t[o].top=s+.5*e.item.vertical}n||Yd(t,e,i)}function Yd(t,e,i){for(var n in i)if(i.hasOwnProperty(n)){i[n].top=0;do{var o=null;for(var s in i)if(null!==i[s].top&&s!==n&&i[n].index>i[s].index&&Ud(i[n],i[s])){o=i[s];break}null!=o&&(i[n].top=o.top+o.height)}while(o)}for(var r=0;r<t.length;r++)void 0!==t[r].data.subgroup&&(t[r].top=i[t[r].data.subgroup].top+.5*e.item.vertical)}function Ed(t,e,i){var n=!1,o=[];for(var s in i)i[s].hasOwnProperty("index")?o[i[s].index]=s:o.push(s);for(var r=0;r<o.length;r++)if(s=o[r],i.hasOwnProperty(s)){for(var a in n=n||i[s].stack,i[s].top=0,i)i[a].visible&&i[s].index>i[a].index&&(i[s].top+=i[a].height);for(var l=t[s],h=0;h<l.length;h++)void 0!==l[h].data.subgroup&&(l[h].top=i[l[h].data.subgroup].top+.5*e.item.vertical,i[s].stack&&(l[h].baseTop=l[h].top));n&&i[s].stack&&Xd(t[s],e,i[s])}}function Rd(t,e,i,n){return n?t.right-i.horizontal+.001<e.right+e.width&&t.right+t.width+i.horizontal-.001>e.right&&t.top-i.vertical+.001<e.top+e.height&&t.top+t.height+i.vertical-.001>e.top:t.left-i.horizontal+.001<e.left+e.width&&t.left+t.width+i.horizontal-.001>e.left&&t.top-i.vertical+.001<e.top+e.height&&t.top+t.height+i.vertical-.001>e.top}function Ud(t,e){var i=t.start<e.end&&t.end>e.start,n=t.top<e.top+e.height&&t.top+t.height>e.top;return i&&n}var zd=Object.freeze({__proto__:null,orderByStart:Od,orderByEnd:Wd,stack:Ad,substack:Xd,nostack:Td,stackSubgroups:Yd,stackSubgroupsWithInnerStack:Ed,collision:Rd,collisionByTimes:Ud}),Vd="__background__",jd=function(){function t(e,i,n){var o=this;if(ba(this,t),this.groupId=e,this.subgroups={},this.subgroupStack={},this.subgroupStackAll=!1,this.subgroupVisibility={},this.doInnerStack=!1,this.shouldBailStackItems=!1,this.subgroupIndex=0,this.subgroupOrderer=i&&i.subgroupOrder,this.itemSet=n,this.isVisible=null,this.stackDirty=!0,this._disposeCallbacks=[],i&&i.nestedGroups&&(this.nestedGroups=i.nestedGroups,0==i.showNested?this.showNested=!1:this.showNested=!0),i&&i.subgroupStack)if("boolean"==typeof i.subgroupStack)this.doInnerStack=i.subgroupStack,this.subgroupStackAll=i.subgroupStack;else for(var s in i.subgroupStack)this.subgroupStack[s]=i.subgroupStack[s],this.doInnerStack=this.doInnerStack||i.subgroupStack[s];i&&i.heightMode?this.heightMode=i.heightMode:this.heightMode=n.options.groupHeightMode,this.nestedInGroup=null,this.dom={},this.props={label:{width:0,height:0}},this.className=null,this.items={},this.visibleItems=[],this.itemsInRange=[],this.orderedItems={byStart:[],byEnd:[]},this.checkRangedItems=!1;var r=function(){o.checkRangedItems=!0};this.itemSet.body.emitter.on("checkRangedItems",r),this._disposeCallbacks.push((function(){o.itemSet.body.emitter.off("checkRangedItems",r)})),this._create(),this.setData(i)}return xa(t,[{key:"_create",value:function(){var t=document.createElement("div");this.itemSet.options.groupEditable.order?t.className="vis-label draggable":t.className="vis-label",this.dom.label=t;var e=document.createElement("div");e.className="vis-inner",t.appendChild(e),this.dom.inner=e;var i=document.createElement("div");i.className="vis-group",i["vis-group"]=this,this.dom.foreground=i,this.dom.background=document.createElement("div"),this.dom.background.className="vis-group",this.dom.axis=document.createElement("div"),this.dom.axis.className="vis-group",this.dom.marker=document.createElement("div"),this.dom.marker.style.visibility="hidden",this.dom.marker.style.position="absolute",this.dom.marker.innerHTML="",this.dom.background.appendChild(this.dom.marker)}},{key:"setData",value:function(t){if(!this.itemSet.groupTouchParams.isDragging){var e,i,n;if(t&&t.subgroupVisibility)for(var o in t.subgroupVisibility)this.subgroupVisibility[o]=t.subgroupVisibility[o];if(this.itemSet.options&&this.itemSet.options.groupTemplate)e=(i=va(n=this.itemSet.options.groupTemplate).call(n,this))(t,this.dom.inner);else e=t&&t.content;if(e instanceof Element){for(;this.dom.inner.firstChild;)this.dom.inner.removeChild(this.dom.inner.firstChild);this.dom.inner.appendChild(e)}else e instanceof Object&&e.isReactComponent||(e instanceof Object?i(t,this.dom.inner):this.dom.inner.innerHTML=null!=e?e:this.groupId||"");this.dom.label.title=t&&t.title||"",this.dom.inner.firstChild?za.removeClassName(this.dom.inner,"vis-hidden"):za.addClassName(this.dom.inner,"vis-hidden"),t&&t.nestedGroups?(this.nestedGroups&&this.nestedGroups==t.nestedGroups||(this.nestedGroups=t.nestedGroups),void 0===t.showNested&&void 0!==this.showNested||(0==t.showNested?this.showNested=!1:this.showNested=!0),za.addClassName(this.dom.label,"vis-nesting-group"),this.showNested?(za.removeClassName(this.dom.label,"collapsed"),za.addClassName(this.dom.label,"expanded")):(za.removeClassName(this.dom.label,"expanded"),za.addClassName(this.dom.label,"collapsed"))):this.nestedGroups&&(this.nestedGroups=null,za.removeClassName(this.dom.label,"collapsed"),za.removeClassName(this.dom.label,"expanded"),za.removeClassName(this.dom.label,"vis-nesting-group")),t&&(t.treeLevel||t.nestedInGroup)?(za.addClassName(this.dom.label,"vis-nested-group"),t.treeLevel?za.addClassName(this.dom.label,"vis-group-level-"+t.treeLevel):za.addClassName(this.dom.label,"vis-group-level-unknown-but-gte1")):za.addClassName(this.dom.label,"vis-group-level-0");var s=t&&t.className||null;s!=this.className&&(this.className&&(za.removeClassName(this.dom.label,this.className),za.removeClassName(this.dom.foreground,this.className),za.removeClassName(this.dom.background,this.className),za.removeClassName(this.dom.axis,this.className)),za.addClassName(this.dom.label,s),za.addClassName(this.dom.foreground,s),za.addClassName(this.dom.background,s),za.addClassName(this.dom.axis,s),this.className=s),this.style&&(za.removeCssText(this.dom.label,this.style),this.style=null),t&&t.style&&(za.addCssText(this.dom.label,t.style),this.style=t.style)}}},{key:"getLabelWidth",value:function(){return this.props.label.width}},{key:"_didMarkerHeightChange",value:function(){var t=this.dom.marker.clientHeight;if(t!=this.lastMarkerHeight){this.lastMarkerHeight=t;var e={},i=0;if(mn(za).call(za,this.items,(function(t,n){if(t.dirty=!0,t.displayed){e[n]=t.redraw(!0),i=e[n].length}})),i>0)for(var n=function(t){mn(za).call(za,e,(function(e){e[t]()}))},o=0;o<i;o++)n(o);return!0}return!1}},{key:"_calculateGroupSizeAndPosition",value:function(){var t=this.dom.foreground,e=t.offsetTop,i=t.offsetLeft,n=t.offsetWidth;this.top=e,this.right=i,this.width=n}},{key:"_shouldBailItemsRedraw",value:function(){var t=this,e=this.itemSet.options.onTimeout,i={relativeBailingTime:this.itemSet.itemsSettingTime,bailTimeMs:e&&e.timeoutMs,userBailFunction:e&&e.callback,shouldBailStackItems:this.shouldBailStackItems},n=null;if(!this.itemSet.initialDrawDone){if(i.shouldBailStackItems)return!0;Math.abs(Jo()-new Date(i.relativeBailingTime))>i.bailTimeMs&&(i.userBailFunction&&null==this.itemSet.userContinueNotBail?i.userBailFunction((function(e){t.itemSet.userContinueNotBail=e,n=!e})):n=0==t.itemSet.userContinueNotBail)}return n}},{key:"_redrawItems",value:function(t,e,i,n){var o=this;if(t||this.stackDirty||this.isVisible&&!e){var s,r,a,l,h,d,u={byEnd:En(s=this.orderedItems.byEnd).call(s,(function(t){return!t.isCluster})),byStart:En(r=this.orderedItems.byStart).call(r,(function(t){return!t.isCluster}))},c={byEnd:mo(new Ar(En(a=Ln(l=this.orderedItems.byEnd).call(l,(function(t){return t.cluster}))).call(a,(function(t){return!!t})))),byStart:mo(new Ar(En(h=Ln(d=this.orderedItems.byStart).call(d,(function(t){return t.cluster}))).call(h,(function(t){return!!t}))))},p=function(){var t,e,i,s=o._updateItemsInRange(u,En(t=o.visibleItems).call(t,(function(t){return!t.isCluster})),n),r=o._updateClustersInRange(c,En(e=o.visibleItems).call(e,(function(t){return t.isCluster})),n);return Pn(i=[]).call(i,mo(s),mo(r))},m=function(t){var e={},i=function(i){var n,s=En(n=o.visibleItems).call(n,(function(t){return t.data.subgroup===i}));e[i]=t?wr(s).call(s,(function(e,i){return t(e.data,i.data)})):s};for(var n in o.subgroups)i(n);return e};if("function"==typeof this.itemSet.options.order){var f=this;if(this.doInnerStack&&this.itemSet.options.stackSubgroups){Ed(m(this.itemSet.options.order),i,this.subgroups),this.visibleItems=p(),this._updateSubGroupHeights(i)}else{var g,v,b,y;this.visibleItems=p(),this._updateSubGroupHeights(i);var x=wr(g=En(v=_o(b=this.visibleItems).call(b)).call(v,(function(t){return t.isCluster||!t.isCluster&&!t.cluster}))).call(g,(function(t,e){return f.itemSet.options.order(t.data,e.data)}));this.shouldBailStackItems=Ad(x,i,!0,va(y=this._shouldBailItemsRedraw).call(y,this))}}else{var w;if(this.visibleItems=p(),this._updateSubGroupHeights(i),this.itemSet.options.stack)if(this.doInnerStack&&this.itemSet.options.stackSubgroups)Ed(m(),i,this.subgroups);else this.shouldBailStackItems=Ad(this.visibleItems,i,!0,va(w=this._shouldBailItemsRedraw).call(w,this));else Td(this.visibleItems,i,this.subgroups,this.itemSet.options.stackSubgroups)}for(var _=0;_<this.visibleItems.length;_++)this.visibleItems[_].repositionX(),void 0!==this.subgroupVisibility[this.visibleItems[_].data.subgroup]&&(this.subgroupVisibility[this.visibleItems[_].data.subgroup]||this.visibleItems[_].hide());this.itemSet.options.cluster&&mn(za).call(za,this.items,(function(t){t.cluster&&t.displayed&&t.hide()})),this.shouldBailStackItems&&this.itemSet.body.emitter.emit("destroyTimeline"),this.stackDirty=!1}}},{key:"_didResize",value:function(t,e){t=za.updateProperty(this,"height",e)||t;var i=this.dom.inner.clientWidth,n=this.dom.inner.clientHeight;return t=za.updateProperty(this.props.label,"width",i)||t,t=za.updateProperty(this.props.label,"height",n)||t}},{key:"_applyGroupHeight",value:function(t){this.dom.background.style.height="".concat(t,"px"),this.dom.foreground.style.height="".concat(t,"px"),this.dom.label.style.height="".concat(t,"px")}},{key:"_updateItemsVerticalPosition",value:function(t){for(var e=0,i=this.visibleItems.length;e<i;e++){var n=this.visibleItems[e];n.repositionY(t),this.isVisible||this.groupId==Vd||n.displayed&&n.hide()}}},{key:"redraw",value:function(t,e,i,n){var o,s,r,a,l,h,d,u=this,c=!1,p=this.isVisible,m=[function(){i=u._didMarkerHeightChange.call(u)||i},va(o=this._updateSubGroupHeights).call(o,this,e),va(s=this._calculateGroupSizeAndPosition).call(s,this),function(){var i;u.isVisible=va(i=u._isGroupVisible).call(i,u)(t,e)},function(){var n;va(n=u._redrawItems).call(n,u)(i,p,e,t)},va(r=this._updateSubgroupsSizes).call(r,this),function(){var t;h=va(t=u._calculateHeight).call(t,u)(e)},va(a=this._calculateGroupSizeAndPosition).call(a,this),function(){var t;c=va(t=u._didResize).call(t,u)(c,h)},function(){var t;va(t=u._applyGroupHeight).call(t,u)(h)},function(){var t;va(t=u._updateItemsVerticalPosition).call(t,u)(e)},va(l=function(){return!u.isVisible&&u.height&&(c=!1),c}).call(l,this)];return n?m:(mn(m).call(m,(function(t){d=t()})),d)}},{key:"_updateSubGroupHeights",value:function(t){var e=this;if(Yi(this.subgroups).length>0){var i=this;this._resetSubgroups(),mn(za).call(za,this.visibleItems,(function(n){void 0!==n.data.subgroup&&(i.subgroups[n.data.subgroup].height=Math.max(i.subgroups[n.data.subgroup].height,n.height+t.item.vertical),i.subgroups[n.data.subgroup].visible=void 0===e.subgroupVisibility[n.data.subgroup]||Boolean(e.subgroupVisibility[n.data.subgroup]))}))}}},{key:"_isGroupVisible",value:function(t,e){return this.top<=t.body.domProps.centerContainer.height-t.body.domProps.scrollTop+e.axis&&this.top+this.height+e.axis>=-t.body.domProps.scrollTop}},{key:"_calculateHeight",value:function(t){var e,i;if((i="fixed"===this.heightMode?za.toArray(this.items):this.visibleItems).length>0){var n=i[0].top,o=i[0].top+i[0].height;if(mn(za).call(za,i,(function(t){n=Math.min(n,t.top),o=Math.max(o,t.top+t.height)})),n>t.axis){var s=n-t.axis;o-=s,mn(za).call(za,i,(function(t){t.top-=s}))}e=Math.ceil(o+t.item.vertical/2),"fitItems"!==this.heightMode&&(e=Math.max(e,this.props.label.height))}else e=this.props.label.height;return e}},{key:"show",value:function(){this.dom.label.parentNode||this.itemSet.dom.labelSet.appendChild(this.dom.label),this.dom.foreground.parentNode||this.itemSet.dom.foreground.appendChild(this.dom.foreground),this.dom.background.parentNode||this.itemSet.dom.background.appendChild(this.dom.background),this.dom.axis.parentNode||this.itemSet.dom.axis.appendChild(this.dom.axis)}},{key:"hide",value:function(){var t=this.dom.label;t.parentNode&&t.parentNode.removeChild(t);var e=this.dom.foreground;e.parentNode&&e.parentNode.removeChild(e);var i=this.dom.background;i.parentNode&&i.parentNode.removeChild(i);var n=this.dom.axis;n.parentNode&&n.parentNode.removeChild(n)}},{key:"add",value:function(t){var e;if(this.items[t.id]=t,t.setParent(this),this.stackDirty=!0,void 0!==t.data.subgroup&&(this._addToSubgroup(t),this.orderSubgroups()),!Bd(e=this.visibleItems).call(e,t)){var i=this.itemSet.body.range;this._checkIfVisible(t,this.visibleItems,i)}}},{key:"_addToSubgroup",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:t.data.subgroup;null!=e&&void 0===this.subgroups[e]&&(this.subgroups[e]={height:0,top:0,start:t.data.start,end:t.data.end||t.data.start,visible:!1,index:this.subgroupIndex,items:[],stack:this.subgroupStackAll||this.subgroupStack[e]||!1},this.subgroupIndex++),new Date(t.data.start)<new Date(this.subgroups[e].start)&&(this.subgroups[e].start=t.data.start);var i=t.data.end||t.data.start;new Date(i)>new Date(this.subgroups[e].end)&&(this.subgroups[e].end=i),this.subgroups[e].items.push(t)}},{key:"_updateSubgroupsSizes",value:function(){var t=this;if(t.subgroups){var e=function(e){var i,n=t.subgroups[e].items[0].data.end||t.subgroups[e].items[0].data.start,o=t.subgroups[e].items[0].data.start,s=n-1;mn(i=t.subgroups[e].items).call(i,(function(t){new Date(t.data.start)<new Date(o)&&(o=t.data.start);var e=t.data.end||t.data.start;new Date(e)>new Date(s)&&(s=e)})),t.subgroups[e].start=o,t.subgroups[e].end=new Date(s-1)};for(var i in t.subgroups)e(i)}}},{key:"orderSubgroups",value:function(){if(void 0!==this.subgroupOrderer){var t=[];if("string"==typeof this.subgroupOrderer){for(var e in this.subgroups)t.push({subgroup:e,sortField:this.subgroups[e].items[0].data[this.subgroupOrderer]});wr(t).call(t,(function(t,e){return t.sortField-e.sortField}))}else if("function"==typeof this.subgroupOrderer){for(var i in this.subgroups)t.push(this.subgroups[i].items[0].data);wr(t).call(t,this.subgroupOrderer)}if(t.length>0)for(var n=0;n<t.length;n++)this.subgroups[t[n].subgroup].index=n}}},{key:"_resetSubgroups",value:function(){for(var t in this.subgroups)this.subgroups.hasOwnProperty(t)&&(this.subgroups[t].visible=!1,this.subgroups[t].height=0)}},{key:"remove",value:function(t){var e,i;delete this.items[t.id],t.setParent(null),this.stackDirty=!0;var n=Fo(e=this.visibleItems).call(e,t);-1!=n&&Hr(i=this.visibleItems).call(i,n,1),void 0!==t.data.subgroup&&(this._removeFromSubgroup(t),this.orderSubgroups())}},{key:"_removeFromSubgroup",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:t.data.subgroup;if(null!=e){var i=this.subgroups[e];if(i){var n,o,s=Fo(n=i.items).call(n,t);if(s>=0)Hr(o=i.items).call(o,s,1),i.items.length?this._updateSubgroupsSizes():delete this.subgroups[e]}}}},{key:"removeFromDataSet",value:function(t){this.itemSet.removeItem(t.id)}},{key:"order",value:function(){for(var t=za.toArray(this.items),e=[],i=[],n=0;n<t.length;n++)void 0!==t[n].data.end&&i.push(t[n]),e.push(t[n]);this.orderedItems={byStart:e,byEnd:i},Od(this.orderedItems.byStart),Wd(this.orderedItems.byEnd)}},{key:"_updateItemsInRange",value:function(t,e,i){var n=[],o={};if(!this.isVisible&&this.groupId!=Vd){for(var s=0;s<e.length;s++){var r=e[s];r.displayed&&r.hide()}return n}var a=(i.end-i.start)/4,l=i.start-a,h=i.end+a;if(e.length>0)for(var d=0;d<e.length;d++)this._checkIfVisibleWithReference(e[d],n,o,i);var u=za.binarySearchCustom(t.byStart,(function(t){return t<l?-1:t<=h?0:1}),"data","start");if(this._traceVisible(u,t.byStart,n,o,(function(t){return t.data.start<l||t.data.start>h})),1==this.checkRangedItems){this.checkRangedItems=!1;for(var c=0;c<t.byEnd.length;c++)this._checkIfVisibleWithReference(t.byEnd[c],n,o,i)}else{var p=za.binarySearchCustom(t.byEnd,(function(t){return t<l?-1:0}),"data","end");this._traceVisible(p,t.byEnd,n,o,(function(t){return t.data.end<l||t.data.start>h}))}for(var m={},f=0,g=0;g<n.length;g++){var v=n[g];if(!v.displayed){m[g]=v.redraw(!0),f=m[g].length}}if(f>0)for(var b=function(t){mn(za).call(za,m,(function(e){e[t]()}))},y=0;y<f;y++)b(y);for(var x=0;x<n.length;x++)n[x].repositionX();return n}},{key:"_traceVisible",value:function(t,e,i,n,o){if(-1!=t){for(var s=t;s>=0;s--){var r=e[s];if(o(r))break;r.isCluster&&!r.hasItems()||r.cluster||void 0===n[r.id]&&(n[r.id]=!0,i.push(r))}for(var a=t+1;a<e.length;a++){var l=e[a];if(o(l))break;l.isCluster&&!l.hasItems()||l.cluster||void 0===n[l.id]&&(n[l.id]=!0,i.push(l))}}}},{key:"_checkIfVisible",value:function(t,e,i){t.isVisible(i)?(t.displayed||t.show(),t.repositionX(),e.push(t)):t.displayed&&t.hide()}},{key:"_checkIfVisibleWithReference",value:function(t,e,i,n){t.isVisible(n)?void 0===i[t.id]&&(i[t.id]=!0,e.push(t)):t.displayed&&t.hide()}},{key:"_updateClustersInRange",value:function(t,e,i){var n=[],o={};if(e.length>0)for(var s=0;s<e.length;s++)this._checkIfVisibleWithReference(e[s],n,o,i);for(var r=0;r<t.byStart.length;r++)this._checkIfVisibleWithReference(t.byStart[r],n,o,i);for(var a=0;a<t.byEnd.length;a++)this._checkIfVisibleWithReference(t.byEnd[a],n,o,i);for(var l={},h=0,d=0;d<n.length;d++){var u=n[d];if(!u.displayed){l[d]=u.redraw(!0),h=l[d].length}}if(h>0)for(var c=0;c<h;c++)mn(za).call(za,l,(function(t){t[c]()}));for(var p=0;p<n.length;p++)n[p].repositionX();return n}},{key:"changeSubgroup",value:function(t,e,i){this._removeFromSubgroup(t,e),this._addToSubgroup(t,i),this.orderSubgroups()}},{key:"dispose",value:function(){var t;for(this.hide();t=this._disposeCallbacks.pop();)t()}}]),t}(),Hd=function(t){function e(t,i,n){var o;return ba(this,e),(o=ar(this,dr(e).call(this,t,i,n))).width=0,o.height=0,o.top=0,o.left=0,o}return pr(e,t),xa(e,[{key:"redraw",value:function(t,e,i){this.visibleItems=this._updateItemsInRange(this.orderedItems,this.visibleItems,t),this.width=this.dom.background.offsetWidth,this.dom.background.style.height="0";for(var n=0,o=this.visibleItems.length;n<o;n++){this.visibleItems[n].repositionY(e)}return!1}},{key:"show",value:function(){this.dom.background.parentNode||this.itemSet.dom.background.appendChild(this.dom.background)}}]),e}(jd);Ph('.vis-item{position:absolute;color:#1a1a1a;border-color:#97b0f8;border-width:1px;background-color:#d5ddf6;display:inline-block;z-index:1}.vis-item.vis-selected{border-color:#ffc200;background-color:#fff785;z-index:2}.vis-editable.vis-selected{cursor:move}.vis-item.vis-point.vis-selected{background-color:#fff785}.vis-item.vis-box{text-align:center;border-style:solid;border-radius:2px}.vis-item.vis-point{background:none}.vis-item.vis-dot{position:absolute;padding:0;border-width:4px;border-style:solid;border-radius:4px}.vis-item.vis-range{border-style:solid;border-radius:2px;box-sizing:border-box}.vis-item.vis-background{border:none;background-color:rgba(213,221,246,.4);box-sizing:border-box;padding:0;margin:0}.vis-item .vis-item-overflow{position:relative;width:100%;height:100%;padding:0;margin:0;overflow:hidden}.vis-item-visible-frame{white-space:nowrap}.vis-item.vis-range .vis-item-content{position:relative;display:inline-block}.vis-item.vis-background .vis-item-content{position:absolute;display:inline-block}.vis-item.vis-line{padding:0;position:absolute;width:0;border-left-width:1px;border-left-style:solid}.vis-item .vis-item-content{white-space:nowrap;box-sizing:border-box;padding:5px}.vis-item .vis-onUpdateTime-tooltip{position:absolute;background:#4f81bd;color:#fff;width:200px;text-align:center;white-space:nowrap;padding:5px;border-radius:1px;transition:.4s;-o-transition:.4s;-moz-transition:.4s;-webkit-transition:.4s}.vis-item .vis-delete,.vis-item .vis-delete-rtl{position:absolute;top:0;width:24px;height:24px;box-sizing:border-box;padding:0 5px;cursor:pointer;-webkit-transition:background .2s linear;-moz-transition:background .2s linear;-ms-transition:background .2s linear;-o-transition:background .2s linear;transition:background .2s linear}.vis-item .vis-delete{right:-24px}.vis-item .vis-delete-rtl{left:-24px}.vis-item .vis-delete-rtl:after,.vis-item .vis-delete:after{content:"\\00D7";color:red;font-family:arial,sans-serif;font-size:22px;font-weight:700;-webkit-transition:color .2s linear;-moz-transition:color .2s linear;-ms-transition:color .2s linear;-o-transition:color .2s linear;transition:color .2s linear}.vis-item .vis-delete-rtl:hover,.vis-item .vis-delete:hover{background:red}.vis-item .vis-delete-rtl:hover:after,.vis-item .vis-delete:hover:after{color:#fff}.vis-item .vis-drag-center{position:absolute;width:100%;height:100%;top:0;left:0;cursor:move}.vis-item.vis-range .vis-drag-left{left:-4px;cursor:w-resize}.vis-item.vis-range .vis-drag-left,.vis-item.vis-range .vis-drag-right{position:absolute;width:24px;max-width:20%;min-width:2px;height:100%;top:0}.vis-item.vis-range .vis-drag-right{right:-4px;cursor:e-resize}.vis-range.vis-item.vis-readonly .vis-drag-left,.vis-range.vis-item.vis-readonly .vis-drag-right{cursor:auto}.vis-item.vis-cluster{vertical-align:center;text-align:center;border-style:solid;border-radius:2px}.vis-item.vis-cluster-line{padding:0;position:absolute;width:0;border-left-width:1px;border-left-style:solid}.vis-item.vis-cluster-dot{position:absolute;padding:0;border-width:4px;border-style:solid;border-radius:4px}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIml0ZW0uY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLFVBQ0UsaUJBQWtCLENBQ2xCLGFBQWMsQ0FDZCxvQkFBcUIsQ0FDckIsZ0JBQWlCLENBQ2pCLHdCQUF5QixDQUN6QixvQkFBcUIsQ0FDckIsU0FFRixDQUVBLHVCQUNFLG9CQUFxQixDQUNyQix3QkFBeUIsQ0FHekIsU0FDRixDQUVBLDJCQUNFLFdBQ0YsQ0FFQSxpQ0FDRSx3QkFDRixDQUVBLGtCQUNFLGlCQUFrQixDQUNsQixrQkFBbUIsQ0FDbkIsaUJBQ0YsQ0FFQSxvQkFDRSxlQUNGLENBRUEsa0JBQ0UsaUJBQWtCLENBQ2xCLFNBQVUsQ0FDVixnQkFBaUIsQ0FDakIsa0JBQW1CLENBQ25CLGlCQUNGLENBRUEsb0JBQ0Usa0JBQW1CLENBQ25CLGlCQUFrQixDQUNsQixxQkFDRixDQUVBLHlCQUNFLFdBQVksQ0FDWixxQ0FBMEMsQ0FDMUMscUJBQXNCLENBQ3RCLFNBQVUsQ0FDVixRQUNGLENBRUEsNkJBQ0UsaUJBQWtCLENBQ2xCLFVBQVcsQ0FDWCxXQUFZLENBQ1osU0FBVSxDQUNWLFFBQVMsQ0FDVCxlQUNGLENBRUEsd0JBQ0Usa0JBQ0YsQ0FFQSxzQ0FDRSxpQkFBa0IsQ0FDbEIsb0JBQ0YsQ0FFQSwyQ0FDRSxpQkFBa0IsQ0FDbEIsb0JBQ0YsQ0FFQSxtQkFDRSxTQUFVLENBQ1YsaUJBQWtCLENBQ2xCLE9BQVEsQ0FDUixxQkFBc0IsQ0FDdEIsdUJBQ0YsQ0FFQSw0QkFDRSxrQkFBbUIsQ0FDbkIscUJBQXNCLENBQ3RCLFdBQ0YsQ0FFQSxvQ0FDRSxpQkFBa0IsQ0FDbEIsa0JBQW1CLENBQ25CLFVBQVksQ0FDWixXQUFZLENBQ1osaUJBQWtCLENBQ2xCLGtCQUFtQixDQUNuQixXQUFZLENBQ1osaUJBQWtCLENBQ2xCLGNBQWdCLENBQ2hCLGlCQUFtQixDQUNuQixtQkFBcUIsQ0FDckIsc0JBQ0YsQ0FFQSxnREFDRSxpQkFBa0IsQ0FDbEIsS0FBUSxDQUNSLFVBQVcsQ0FDWCxXQUFZLENBQ1oscUJBQXNCLENBQ3RCLGFBQWdCLENBQ2hCLGNBQWUsQ0FFZix3Q0FBMEMsQ0FDMUMscUNBQXVDLENBQ3ZDLG9DQUFzQyxDQUN0QyxtQ0FBcUMsQ0FDckMsZ0NBQ0YsQ0FFQSxzQkFDRSxXQUNGLENBRUEsMEJBQ0UsVUFDRixDQUVBLDREQUNFLGVBQWdCLENBQ2hCLFNBQVUsQ0FDViw0QkFBOEIsQ0FDOUIsY0FBZSxDQUNmLGVBQWlCLENBRWpCLG1DQUFxQyxDQUNyQyxnQ0FBa0MsQ0FDbEMsK0JBQWlDLENBQ2pDLDhCQUFnQyxDQUNoQywyQkFDRixDQUVBLDREQUNFLGNBQ0YsQ0FFQSx3RUFDRSxVQUNGLENBRUEsMkJBQ0UsaUJBQWtCLENBQ2xCLFVBQVcsQ0FDWCxXQUFZLENBQ1osS0FBTSxDQUNOLE1BQVMsQ0FDVCxXQUNGLENBRUEsbUNBT0UsU0FBVSxDQUVWLGVBQ0YsQ0FFQSx1RUFYRSxpQkFBa0IsQ0FDbEIsVUFBVyxDQUNYLGFBQWMsQ0FDZCxhQUFjLENBQ2QsV0FBWSxDQUNaLEtBZ0JGLENBVkEsb0NBT0UsVUFBVyxDQUVYLGVBQ0YsQ0FFQSxpR0FFRSxXQUNGLENBRUEsc0JBQ0UscUJBQXNCLENBQ3RCLGlCQUFrQixDQUNsQixrQkFBbUIsQ0FDbkIsaUJBQ0YsQ0FFQSwyQkFDRSxTQUFVLENBQ1YsaUJBQWtCLENBQ2xCLE9BQVEsQ0FDUixxQkFBc0IsQ0FDdEIsdUJBQ0YsQ0FFQSwwQkFDRSxpQkFBa0IsQ0FDbEIsU0FBVSxDQUNWLGdCQUFpQixDQUNqQixrQkFBbUIsQ0FDbkIsaUJBQ0YiLCJmaWxlIjoiaXRlbS5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyJcbi52aXMtaXRlbSB7XG4gIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgY29sb3I6ICMxQTFBMUE7XG4gIGJvcmRlci1jb2xvcjogIzk3QjBGODtcbiAgYm9yZGVyLXdpZHRoOiAxcHg7XG4gIGJhY2tncm91bmQtY29sb3I6ICNENURERjY7XG4gIGRpc3BsYXk6IGlubGluZS1ibG9jaztcbiAgei1pbmRleDogMTtcbiAgLypvdmVyZmxvdzogaGlkZGVuOyovXG59XG5cbi52aXMtaXRlbS52aXMtc2VsZWN0ZWQge1xuICBib3JkZXItY29sb3I6ICNGRkMyMDA7XG4gIGJhY2tncm91bmQtY29sb3I6ICNGRkY3ODU7XG5cbiAgLyogei1pbmRleCBtdXN0IGJlIGhpZ2hlciB0aGFuIHRoZSB6LWluZGV4IG9mIGN1c3RvbSB0aW1lIGJhciBhbmQgY3VycmVudCB0aW1lIGJhciAqL1xuICB6LWluZGV4OiAyO1xufVxuXG4udmlzLWVkaXRhYmxlLnZpcy1zZWxlY3RlZCB7XG4gIGN1cnNvcjogbW92ZTtcbn1cblxuLnZpcy1pdGVtLnZpcy1wb2ludC52aXMtc2VsZWN0ZWQge1xuICBiYWNrZ3JvdW5kLWNvbG9yOiAjRkZGNzg1O1xufVxuXG4udmlzLWl0ZW0udmlzLWJveCB7XG4gIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgYm9yZGVyLXN0eWxlOiBzb2xpZDtcbiAgYm9yZGVyLXJhZGl1czogMnB4O1xufVxuXG4udmlzLWl0ZW0udmlzLXBvaW50IHtcbiAgYmFja2dyb3VuZDogbm9uZTtcbn1cblxuLnZpcy1pdGVtLnZpcy1kb3Qge1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIHBhZGRpbmc6IDA7XG4gIGJvcmRlci13aWR0aDogNHB4O1xuICBib3JkZXItc3R5bGU6IHNvbGlkO1xuICBib3JkZXItcmFkaXVzOiA0cHg7XG59XG5cbi52aXMtaXRlbS52aXMtcmFuZ2Uge1xuICBib3JkZXItc3R5bGU6IHNvbGlkO1xuICBib3JkZXItcmFkaXVzOiAycHg7XG4gIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG59XG5cbi52aXMtaXRlbS52aXMtYmFja2dyb3VuZCB7XG4gIGJvcmRlcjogbm9uZTtcbiAgYmFja2dyb3VuZC1jb2xvcjogcmdiYSgyMTMsIDIyMSwgMjQ2LCAwLjQpO1xuICBib3gtc2l6aW5nOiBib3JkZXItYm94O1xuICBwYWRkaW5nOiAwO1xuICBtYXJnaW46IDA7XG59XG5cbi52aXMtaXRlbSAudmlzLWl0ZW0tb3ZlcmZsb3cge1xuICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gIHdpZHRoOiAxMDAlO1xuICBoZWlnaHQ6IDEwMCU7XG4gIHBhZGRpbmc6IDA7XG4gIG1hcmdpbjogMDtcbiAgb3ZlcmZsb3c6IGhpZGRlbjtcbn1cblxuLnZpcy1pdGVtLXZpc2libGUtZnJhbWUge1xuICB3aGl0ZS1zcGFjZTogbm93cmFwO1xufVxuXG4udmlzLWl0ZW0udmlzLXJhbmdlIC52aXMtaXRlbS1jb250ZW50IHtcbiAgcG9zaXRpb246IHJlbGF0aXZlO1xuICBkaXNwbGF5OiBpbmxpbmUtYmxvY2s7XG59XG5cbi52aXMtaXRlbS52aXMtYmFja2dyb3VuZCAudmlzLWl0ZW0tY29udGVudCB7XG4gIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgZGlzcGxheTogaW5saW5lLWJsb2NrO1xufVxuXG4udmlzLWl0ZW0udmlzLWxpbmUge1xuICBwYWRkaW5nOiAwO1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIHdpZHRoOiAwO1xuICBib3JkZXItbGVmdC13aWR0aDogMXB4O1xuICBib3JkZXItbGVmdC1zdHlsZTogc29saWQ7XG59XG5cbi52aXMtaXRlbSAudmlzLWl0ZW0tY29udGVudCB7XG4gIHdoaXRlLXNwYWNlOiBub3dyYXA7XG4gIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG4gIHBhZGRpbmc6IDVweDtcbn1cblxuLnZpcy1pdGVtIC52aXMtb25VcGRhdGVUaW1lLXRvb2x0aXAge1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIGJhY2tncm91bmQ6ICM0ZjgxYmQ7XG4gIGNvbG9yOiB3aGl0ZTtcbiAgd2lkdGg6IDIwMHB4O1xuICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gIHdoaXRlLXNwYWNlOiBub3dyYXA7XG4gIHBhZGRpbmc6IDVweDtcbiAgYm9yZGVyLXJhZGl1czogMXB4O1xuICB0cmFuc2l0aW9uOiAwLjRzO1xuICAtby10cmFuc2l0aW9uOiAwLjRzO1xuICAtbW96LXRyYW5zaXRpb246IDAuNHM7XG4gIC13ZWJraXQtdHJhbnNpdGlvbjogMC40cztcbn1cblxuLnZpcy1pdGVtIC52aXMtZGVsZXRlLCAudmlzLWl0ZW0gLnZpcy1kZWxldGUtcnRsIHtcbiAgcG9zaXRpb246IGFic29sdXRlO1xuICB0b3A6IDBweDtcbiAgd2lkdGg6IDI0cHg7XG4gIGhlaWdodDogMjRweDtcbiAgYm94LXNpemluZzogYm9yZGVyLWJveDtcbiAgcGFkZGluZzogMHB4IDVweDtcbiAgY3Vyc29yOiBwb2ludGVyO1xuXG4gIC13ZWJraXQtdHJhbnNpdGlvbjogYmFja2dyb3VuZCAwLjJzIGxpbmVhcjtcbiAgLW1vei10cmFuc2l0aW9uOiBiYWNrZ3JvdW5kIDAuMnMgbGluZWFyO1xuICAtbXMtdHJhbnNpdGlvbjogYmFja2dyb3VuZCAwLjJzIGxpbmVhcjtcbiAgLW8tdHJhbnNpdGlvbjogYmFja2dyb3VuZCAwLjJzIGxpbmVhcjtcbiAgdHJhbnNpdGlvbjogYmFja2dyb3VuZCAwLjJzIGxpbmVhcjtcbn1cblxuLnZpcy1pdGVtIC52aXMtZGVsZXRlIHtcbiAgcmlnaHQ6IC0yNHB4O1xufVxuXG4udmlzLWl0ZW0gLnZpcy1kZWxldGUtcnRsIHtcbiAgbGVmdDogLTI0cHg7XG59XG5cbi52aXMtaXRlbSAudmlzLWRlbGV0ZTphZnRlciwgLnZpcy1pdGVtIC52aXMtZGVsZXRlLXJ0bDphZnRlciB7XG4gIGNvbnRlbnQ6IFwiXFwwMEQ3XCI7IC8qIE1VTFRJUExJQ0FUSU9OIFNJR04gKi9cbiAgY29sb3I6IHJlZDtcbiAgZm9udC1mYW1pbHk6IGFyaWFsLCBzYW5zLXNlcmlmO1xuICBmb250LXNpemU6IDIycHg7XG4gIGZvbnQtd2VpZ2h0OiBib2xkO1xuXG4gIC13ZWJraXQtdHJhbnNpdGlvbjogY29sb3IgMC4ycyBsaW5lYXI7XG4gIC1tb3otdHJhbnNpdGlvbjogY29sb3IgMC4ycyBsaW5lYXI7XG4gIC1tcy10cmFuc2l0aW9uOiBjb2xvciAwLjJzIGxpbmVhcjtcbiAgLW8tdHJhbnNpdGlvbjogY29sb3IgMC4ycyBsaW5lYXI7XG4gIHRyYW5zaXRpb246IGNvbG9yIDAuMnMgbGluZWFyO1xufVxuXG4udmlzLWl0ZW0gLnZpcy1kZWxldGU6aG92ZXIsIC52aXMtaXRlbSAudmlzLWRlbGV0ZS1ydGw6aG92ZXIge1xuICBiYWNrZ3JvdW5kOiByZWQ7XG59XG5cbi52aXMtaXRlbSAudmlzLWRlbGV0ZTpob3ZlcjphZnRlciwgLnZpcy1pdGVtIC52aXMtZGVsZXRlLXJ0bDpob3ZlcjphZnRlciB7XG4gIGNvbG9yOiB3aGl0ZTtcbn1cblxuLnZpcy1pdGVtIC52aXMtZHJhZy1jZW50ZXIge1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIHdpZHRoOiAxMDAlO1xuICBoZWlnaHQ6IDEwMCU7XG4gIHRvcDogMDtcbiAgbGVmdDogMHB4O1xuICBjdXJzb3I6IG1vdmU7XG59XG5cbi52aXMtaXRlbS52aXMtcmFuZ2UgLnZpcy1kcmFnLWxlZnQge1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIHdpZHRoOiAyNHB4O1xuICBtYXgtd2lkdGg6IDIwJTtcbiAgbWluLXdpZHRoOiAycHg7XG4gIGhlaWdodDogMTAwJTtcbiAgdG9wOiAwO1xuICBsZWZ0OiAtNHB4O1xuXG4gIGN1cnNvcjogdy1yZXNpemU7XG59XG5cbi52aXMtaXRlbS52aXMtcmFuZ2UgLnZpcy1kcmFnLXJpZ2h0IHtcbiAgcG9zaXRpb246IGFic29sdXRlO1xuICB3aWR0aDogMjRweDtcbiAgbWF4LXdpZHRoOiAyMCU7XG4gIG1pbi13aWR0aDogMnB4O1xuICBoZWlnaHQ6IDEwMCU7XG4gIHRvcDogMDtcbiAgcmlnaHQ6IC00cHg7XG5cbiAgY3Vyc29yOiBlLXJlc2l6ZTtcbn1cblxuLnZpcy1yYW5nZS52aXMtaXRlbS52aXMtcmVhZG9ubHkgLnZpcy1kcmFnLWxlZnQsXG4udmlzLXJhbmdlLnZpcy1pdGVtLnZpcy1yZWFkb25seSAudmlzLWRyYWctcmlnaHQge1xuICBjdXJzb3I6IGF1dG87XG59XG5cbi52aXMtaXRlbS52aXMtY2x1c3RlciB7XG4gIHZlcnRpY2FsLWFsaWduOiBjZW50ZXI7XG4gIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgYm9yZGVyLXN0eWxlOiBzb2xpZDtcbiAgYm9yZGVyLXJhZGl1czogMnB4O1xufVxuXG4udmlzLWl0ZW0udmlzLWNsdXN0ZXItbGluZSB7XG4gIHBhZGRpbmc6IDA7XG4gIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgd2lkdGg6IDA7XG4gIGJvcmRlci1sZWZ0LXdpZHRoOiAxcHg7XG4gIGJvcmRlci1sZWZ0LXN0eWxlOiBzb2xpZDtcbn1cblxuLnZpcy1pdGVtLnZpcy1jbHVzdGVyLWRvdCB7XG4gIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgcGFkZGluZzogMDtcbiAgYm9yZGVyLXdpZHRoOiA0cHg7XG4gIGJvcmRlci1zdHlsZTogc29saWQ7XG4gIGJvcmRlci1yYWRpdXM6IDRweDtcbn0iXX0= */');var Pd=function(){function t(e,i,n){var o,s=this;ba(this,t),this.id=null,this.parent=null,this.data=e,this.dom=null,this.conversion=i||{},this.defaultOptions={locales:dd,locale:"en"},this.options=za.extend({},this.defaultOptions,n),this.options.locales=za.extend({},dd,this.options.locales);var r=this.defaultOptions.locales[this.defaultOptions.locale];mn(o=Yi(this.options.locales)).call(o,(function(t){s.options.locales[t]=za.extend({},r,s.options.locales[t])})),this.selected=!1,this.displayed=!1,this.groupShowing=!0,this.selectable=n&&n.selectable||!1,this.dirty=!0,this.top=null,this.right=null,this.left=null,this.width=null,this.height=null,this.setSelectability(e),this.editable=null,this._updateEditStatus()}return xa(t,[{key:"select",value:function(){this.selectable&&(this.selected=!0,this.dirty=!0,this.displayed&&this.redraw())}},{key:"unselect",value:function(){this.selected=!1,this.dirty=!0,this.displayed&&this.redraw()}},{key:"setData",value:function(t){null!=t.group&&this.data.group!=t.group&&null!=this.parent&&this.parent.itemSet._moveToGroup(this,t.group),this.setSelectability(t),this.parent&&(this.parent.stackDirty=!0),null!=t.subgroup&&this.data.subgroup!=t.subgroup&&null!=this.parent&&this.parent.changeSubgroup(this,this.data.subgroup,t.subgroup),this.data=t,this._updateEditStatus(),this.dirty=!0,this.displayed&&this.redraw()}},{key:"setSelectability",value:function(t){t&&(this.selectable=void 0===t.selectable||Boolean(t.selectable))}},{key:"setParent",value:function(t){this.displayed?(this.hide(),this.parent=t,this.parent&&this.show()):this.parent=t}},{key:"isVisible",value:function(t){return!1}},{key:"show",value:function(){return!1}},{key:"hide",value:function(){return!1}},{key:"redraw",value:function(){}},{key:"repositionX",value:function(){}},{key:"repositionY",value:function(){}},{key:"_repaintDragCenter",value:function(){if(this.selected&&this.editable.updateTime&&!this.dom.dragCenter){var t,e,i=this,n=document.createElement("div");n.className="vis-drag-center",n.dragCenterItem=this,this.hammerDragCenter=new Vh(n),this.hammerDragCenter.on("tap",(function(t){i.parent.itemSet.body.emitter.emit("click",{event:t,item:i.id})})),this.hammerDragCenter.on("doubletap",(function(t){t.stopPropagation(),i.parent.itemSet._onUpdateItem(i),i.parent.itemSet.body.emitter.emit("doubleClick",{event:t,item:i.id})})),this.hammerDragCenter.on("panstart",(function(t){t.stopPropagation(),i.parent.itemSet._onDragStart(t)})),this.hammerDragCenter.on("panmove",va(t=i.parent.itemSet._onDrag).call(t,i.parent.itemSet)),this.hammerDragCenter.on("panend",va(e=i.parent.itemSet._onDragEnd).call(e,i.parent.itemSet)),this.dom.box?this.dom.dragLeft?this.dom.box.insertBefore(n,this.dom.dragLeft):this.dom.box.appendChild(n):this.dom.point&&this.dom.point.appendChild(n),this.dom.dragCenter=n}else!this.selected&&this.dom.dragCenter&&(this.dom.dragCenter.parentNode&&this.dom.dragCenter.parentNode.removeChild(this.dom.dragCenter),this.dom.dragCenter=null,this.hammerDragCenter&&(this.hammerDragCenter.destroy(),this.hammerDragCenter=null))}},{key:"_repaintDeleteButton",value:function(t){var e=(this.options.editable.overrideItems||null==this.editable)&&this.options.editable.remove||!this.options.editable.overrideItems&&null!=this.editable&&this.editable.remove;if(this.selected&&e&&!this.dom.deleteButton){var i=this,n=document.createElement("div");this.options.rtl?n.className="vis-delete-rtl":n.className="vis-delete";var o=this.options.locales[this.options.locale];o||(this.warned||(console.warn("WARNING: options.locales['".concat(this.options.locale,"'] not found. See https://visjs.github.io/vis-timeline/docs/timeline/#Localization")),this.warned=!0),o=this.options.locales.en),n.title=o.deleteSelected,this.hammerDeleteButton=new Vh(n).on("tap",(function(t){t.stopPropagation(),i.parent.removeFromDataSet(i)})),t.appendChild(n),this.dom.deleteButton=n}else!this.selected&&this.dom.deleteButton&&(this.dom.deleteButton.parentNode&&this.dom.deleteButton.parentNode.removeChild(this.dom.deleteButton),this.dom.deleteButton=null,this.hammerDeleteButton&&(this.hammerDeleteButton.destroy(),this.hammerDeleteButton=null))}},{key:"_repaintOnItemUpdateTimeTooltip",value:function(t){if(this.options.tooltipOnItemUpdateTime){var e=(this.options.editable.updateTime||!0===this.data.editable)&&!1!==this.data.editable;if(this.selected&&e&&!this.dom.onItemUpdateTimeTooltip){var i=document.createElement("div");i.className="vis-onUpdateTime-tooltip",t.appendChild(i),this.dom.onItemUpdateTimeTooltip=i}else!this.selected&&this.dom.onItemUpdateTimeTooltip&&(this.dom.onItemUpdateTimeTooltip.parentNode&&this.dom.onItemUpdateTimeTooltip.parentNode.removeChild(this.dom.onItemUpdateTimeTooltip),this.dom.onItemUpdateTimeTooltip=null);if(this.dom.onItemUpdateTimeTooltip){this.dom.onItemUpdateTimeTooltip.style.visibility=this.parent.itemSet.touchParams.itemIsDragging?"visible":"hidden",this.dom.onItemUpdateTimeTooltip.style.transform="translateX(-50%)",this.dom.onItemUpdateTimeTooltip.style.left="50%";var n,o,s=this.parent.itemSet.body.domProps.scrollTop;if(("top"==this.options.orientation.item?this.top:this.parent.height-this.top-this.height)+this.parent.top-50<-s?(this.dom.onItemUpdateTimeTooltip.style.bottom="",this.dom.onItemUpdateTimeTooltip.style.top="".concat(this.height+2,"px")):(this.dom.onItemUpdateTimeTooltip.style.top="",this.dom.onItemUpdateTimeTooltip.style.bottom="".concat(this.height+2,"px")),this.options.tooltipOnItemUpdateTime&&this.options.tooltipOnItemUpdateTime.template)n=va(o=this.options.tooltipOnItemUpdateTime.template).call(o,this)(this.data);else n="start: ".concat(Ta(this.data.start).format("MM/DD/YYYY hh:mm")),this.data.end&&(n+="<br> end: ".concat(Ta(this.data.end).format("MM/DD/YYYY hh:mm")));this.dom.onItemUpdateTimeTooltip.innerHTML=n}}}},{key:"_getItemData",value:function(){return this.parent.itemSet.itemsData.get(this.id)}},{key:"_updateContents",value:function(t){var e,i,n,o,s,r,a=this._getItemData(),l=(this.dom.box||this.dom.point).getElementsByClassName("vis-item-visible-frame")[0];this.options.visibleFrameTemplate?n=(o=va(s=this.options.visibleFrameTemplate).call(s,this))(a,l):n="";if(l)if(n instanceof Object&&!(n instanceof Element))o(a,l);else if(this._contentToString(this.itemVisibleFrameContent)!==this._contentToString(n)){if(n instanceof Element)l.innerHTML="",l.appendChild(n);else if(null!=n)l.innerHTML=n;else if("background"!=this.data.type||void 0!==this.data.content)throw new Error('Property "content" missing in item '.concat(this.id));this.itemVisibleFrameContent=n}this.options.template?e=(i=va(r=this.options.template).call(r,this))(a,t,this.data):e=this.data.content;if(e instanceof Object&&!(e instanceof Element))i(a,t);else if(this._contentToString(this.content)!==this._contentToString(e)){if(e instanceof Element)t.innerHTML="",t.appendChild(e);else if(null!=e)t.innerHTML=e;else if("background"!=this.data.type||void 0!==this.data.content)throw new Error('Property "content" missing in item '.concat(this.id));this.content=e}}},{key:"_updateDataAttributes",value:function(t){if(this.options.dataAttributes&&this.options.dataAttributes.length>0){var e=[];if(Zo(this.options.dataAttributes))e=this.options.dataAttributes;else{if("all"!=this.options.dataAttributes)return;e=Yi(this.data)}var i=!0,n=!1,o=void 0;try{for(var s,r=Fi(e);!(i=(s=r.next()).done);i=!0){var a=s.value,l=this.data[a];null!=l?t.setAttribute("data-".concat(a),l):t.removeAttribute("data-".concat(a))}}catch(t){n=!0,o=t}finally{try{i||null==r.return||r.return()}finally{if(n)throw o}}}}},{key:"_updateStyle",value:function(t){this.style&&(za.removeCssText(t,this.style),this.style=null),this.data.style&&(za.addCssText(t,this.data.style),this.style=this.data.style)}},{key:"_contentToString",value:function(t){return"string"==typeof t?t:t&&"outerHTML"in t?t.outerHTML:t}},{key:"_updateEditStatus",value:function(){this.options&&("boolean"==typeof this.options.editable?this.editable={updateTime:this.options.editable,updateGroup:this.options.editable,remove:this.options.editable}:"object"===zo(this.options.editable)&&(this.editable={},za.selectiveExtend(["updateTime","updateGroup","remove"],this.editable,this.options.editable))),this.options&&this.options.editable&&!0===this.options.editable.overrideItems||this.data&&("boolean"==typeof this.data.editable?this.editable={updateTime:this.data.editable,updateGroup:this.data.editable,remove:this.data.editable}:"object"===zo(this.data.editable)&&(this.editable={},za.selectiveExtend(["updateTime","updateGroup","remove"],this.editable,this.data.editable)))}},{key:"getWidthLeft",value:function(){return 0}},{key:"getWidthRight",value:function(){return 0}},{key:"getTitle",value:function(){var t;return this.options.tooltip&&this.options.tooltip.template?va(t=this.options.tooltip.template).call(t,this)(this._getItemData(),this.data):this.data.title}}]),t}();Pd.prototype.stack=!0;var Jd=function(t){function e(t,i,n){var o;if(ba(this,e),(o=ar(this,dr(e).call(this,t,i,n))).props={dot:{width:0,height:0},line:{width:0,height:0}},t&&null==t.start)throw new Error('Property "start" missing in item '.concat(t));return o}return pr(e,t),xa(e,[{key:"isVisible",value:function(t){if(this.cluster)return!1;var e,i=this.data.align||this.options.align,n=this.width*t.getMillisecondsPerPixel();return e="right"==i?this.data.start.getTime()>t.start&&this.data.start.getTime()-n<t.end:"left"==i?this.data.start.getTime()+n>t.start&&this.data.start.getTime()<t.end:this.data.start.getTime()+n/2>t.start&&this.data.start.getTime()-n/2<t.end,e}},{key:"_createDomElement",value:function(){this.dom||(this.dom={},this.dom.box=document.createElement("DIV"),this.dom.content=document.createElement("DIV"),this.dom.content.className="vis-item-content",this.dom.box.appendChild(this.dom.content),this.dom.line=document.createElement("DIV"),this.dom.line.className="vis-line",this.dom.dot=document.createElement("DIV"),this.dom.dot.className="vis-dot",this.dom.box["vis-item"]=this,this.dirty=!0)}},{key:"_appendDomElement",value:function(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){var t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.box)}if(!this.dom.line.parentNode){var e=this.parent.dom.background;if(!e)throw new Error("Cannot redraw item: parent has no background container element");e.appendChild(this.dom.line)}if(!this.dom.dot.parentNode){var i=this.parent.dom.axis;if(!e)throw new Error("Cannot redraw item: parent has no axis container element");i.appendChild(this.dom.dot)}this.displayed=!0}},{key:"_updateDirtyDomComponents",value:function(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.box),this._updateStyle(this.dom.box);var t=this.editable.updateTime||this.editable.updateGroup,e=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+(t?" vis-editable":" vis-readonly");this.dom.box.className="vis-item vis-box".concat(e),this.dom.line.className="vis-item vis-line".concat(e),this.dom.dot.className="vis-item vis-dot".concat(e)}}},{key:"_getDomComponentsSizes",value:function(){return{previous:{right:this.dom.box.style.right,left:this.dom.box.style.left},dot:{height:this.dom.dot.offsetHeight,width:this.dom.dot.offsetWidth},line:{width:this.dom.line.offsetWidth},box:{width:this.dom.box.offsetWidth,height:this.dom.box.offsetHeight}}}},{key:"_updateDomComponentsSizes",value:function(t){this.options.rtl?this.dom.box.style.right="0px":this.dom.box.style.left="0px",this.props.dot.height=t.dot.height,this.props.dot.width=t.dot.width,this.props.line.width=t.line.width,this.width=t.box.width,this.height=t.box.height,this.options.rtl?this.dom.box.style.right=t.previous.right:this.dom.box.style.left=t.previous.left,this.dirty=!1}},{key:"_repaintDomAdditionals",value:function(){this._repaintOnItemUpdateTimeTooltip(this.dom.box),this._repaintDragCenter(),this._repaintDeleteButton(this.dom.box)}},{key:"redraw",value:function(t){var e,i,n,o,s,r,a=this,l=[va(e=this._createDomElement).call(e,this),va(i=this._appendDomElement).call(i,this),va(n=this._updateDirtyDomComponents).call(n,this),function(){a.dirty&&(s=a._getDomComponentsSizes())},function(){var t;a.dirty&&va(t=a._updateDomComponentsSizes).call(t,a)(s)},va(o=this._repaintDomAdditionals).call(o,this)];return t?l:(mn(l).call(l,(function(t){r=t()})),r)}},{key:"show",value:function(t){if(!this.displayed)return this.redraw(t)}},{key:"hide",value:function(){if(this.displayed){var t=this.dom;t.box.remove?t.box.remove():t.box.parentNode&&t.box.parentNode.removeChild(t.box),t.line.remove?t.line.remove():t.line.parentNode&&t.line.parentNode.removeChild(t.line),t.dot.remove?t.dot.remove():t.dot.parentNode&&t.dot.parentNode.removeChild(t.dot),this.displayed=!1}}},{key:"repositionXY",value:function(){var t=this.options.rtl,e=function(t,e,i){var n,o=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(void 0!==e||void 0!==i){var s=o?-1*e:e;t.style.transform=void 0!==i?void 0!==e?Pn(n="translate(".concat(s,"px, ")).call(n,i,"px)"):"translateY(".concat(i,"px)"):"translateX(".concat(s,"px)")}};e(this.dom.box,this.boxX,this.boxY,t),e(this.dom.dot,this.dotX,this.dotY,t),e(this.dom.line,this.lineX,this.lineY,t)}},{key:"repositionX",value:function(){var t=this.conversion.toScreen(this.data.start),e=void 0===this.data.align?this.options.align:this.data.align,i=this.props.line.width,n=this.props.dot.width;"right"==e?(this.boxX=t-this.width,this.lineX=t-i,this.dotX=t-i/2-n/2):"left"==e?(this.boxX=t,this.lineX=t,this.dotX=t+i/2-n/2):(this.boxX=t-this.width/2,this.lineX=this.options.rtl?t-i:t-i/2,this.dotX=t-n/2),this.options.rtl?this.right=this.boxX:this.left=this.boxX,this.repositionXY()}},{key:"repositionY",value:function(){var t=this.options.orientation.item,e=this.dom.line.style;if("top"==t){var i=this.parent.top+this.top+1;this.boxY=this.top||0,e.height="".concat(i,"px"),e.bottom="",e.top="0"}else{var n=this.parent.itemSet.props.height-this.parent.top-this.parent.height+this.top;this.boxY=this.parent.height-this.top-(this.height||0),e.height="".concat(n,"px"),e.top="",e.bottom="0"}this.dotY=-this.props.dot.height/2,this.repositionXY()}},{key:"getWidthLeft",value:function(){return this.width/2}},{key:"getWidthRight",value:function(){return this.width/2}}]),e}(Pd),Kd=function(t){function e(t,i,n){var o;if(ba(this,e),(o=ar(this,dr(e).call(this,t,i,n))).props={dot:{top:0,width:0,height:0},content:{height:0,marginLeft:0,marginRight:0}},t&&null==t.start)throw new Error('Property "start" missing in item '.concat(t));return o}return pr(e,t),xa(e,[{key:"isVisible",value:function(t){if(this.cluster)return!1;var e=this.width*t.getMillisecondsPerPixel();return this.data.start.getTime()+e>t.start&&this.data.start<t.end}},{key:"_createDomElement",value:function(){this.dom||(this.dom={},this.dom.point=document.createElement("div"),this.dom.content=document.createElement("div"),this.dom.content.className="vis-item-content",this.dom.point.appendChild(this.dom.content),this.dom.dot=document.createElement("div"),this.dom.point.appendChild(this.dom.dot),this.dom.point["vis-item"]=this,this.dirty=!0)}},{key:"_appendDomElement",value:function(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.point.parentNode){var t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.point)}this.displayed=!0}},{key:"_updateDirtyDomComponents",value:function(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.point),this._updateStyle(this.dom.point);var t=this.editable.updateTime||this.editable.updateGroup,e=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+(t?" vis-editable":" vis-readonly");this.dom.point.className="vis-item vis-point".concat(e),this.dom.dot.className="vis-item vis-dot".concat(e)}}},{key:"_getDomComponentsSizes",value:function(){return{dot:{width:this.dom.dot.offsetWidth,height:this.dom.dot.offsetHeight},content:{width:this.dom.content.offsetWidth,height:this.dom.content.offsetHeight},point:{width:this.dom.point.offsetWidth,height:this.dom.point.offsetHeight}}}},{key:"_updateDomComponentsSizes",value:function(t){this.props.dot.width=t.dot.width,this.props.dot.height=t.dot.height,this.props.content.height=t.content.height,this.options.rtl?this.dom.content.style.marginRight="".concat(2*this.props.dot.width,"px"):this.dom.content.style.marginLeft="".concat(2*this.props.dot.width,"px"),this.width=t.point.width,this.height=t.point.height,this.dom.dot.style.top="".concat((this.height-this.props.dot.height)/2,"px");var e=this.props.dot.width,i=this.options.rtl?e/2*-1:e/2;this.dom.dot.style.transform="translateX(".concat(i,"px"),this.dirty=!1}},{key:"_repaintDomAdditionals",value:function(){this._repaintOnItemUpdateTimeTooltip(this.dom.point),this._repaintDragCenter(),this._repaintDeleteButton(this.dom.point)}},{key:"redraw",value:function(t){var e,i,n,o,s,r,a=this,l=[va(e=this._createDomElement).call(e,this),va(i=this._appendDomElement).call(i,this),va(n=this._updateDirtyDomComponents).call(n,this),function(){a.dirty&&(s=a._getDomComponentsSizes())},function(){var t;a.dirty&&va(t=a._updateDomComponentsSizes).call(t,a)(s)},va(o=this._repaintDomAdditionals).call(o,this)];return t?l:(mn(l).call(l,(function(t){r=t()})),r)}},{key:"repositionXY",value:function(){var t=this.options.rtl,e=function(t,e,i){var n,o=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(void 0!==e||void 0!==i){var s=o?-1*e:e;t.style.transform=void 0!==i?void 0!==e?Pn(n="translate(".concat(s,"px, ")).call(n,i,"px)"):"translateY(".concat(i,"px)"):"translateX(".concat(s,"px)")}};e(this.dom.point,this.pointX,this.pointY,t)}},{key:"show",value:function(t){if(!this.displayed)return this.redraw(t)}},{key:"hide",value:function(){this.displayed&&(this.dom.point.parentNode&&this.dom.point.parentNode.removeChild(this.dom.point),this.displayed=!1)}},{key:"repositionX",value:function(){var t=this.conversion.toScreen(this.data.start);this.pointX=t,this.options.rtl?this.right=t-this.props.dot.width:this.left=t-this.props.dot.width,this.repositionXY()}},{key:"repositionY",value:function(){var t=this.options.orientation.item;this.pointY="top"==t?this.top:this.parent.height-this.top-this.height,this.repositionXY()}},{key:"getWidthLeft",value:function(){return this.props.dot.width}},{key:"getWidthRight",value:function(){return this.props.dot.width}}]),e}(Pd),qd=function(t){function e(t,i,n){var o;if(ba(this,e),(o=ar(this,dr(e).call(this,t,i,n))).props={content:{width:0}},o.overflow=!1,t){if(null==t.start)throw new Error('Property "start" missing in item '.concat(t.id));if(null==t.end)throw new Error('Property "end" missing in item '.concat(t.id))}return o}return pr(e,t),xa(e,[{key:"isVisible",value:function(t){return!this.cluster&&(this.data.start<t.end&&this.data.end>t.start)}},{key:"_createDomElement",value:function(){this.dom||(this.dom={},this.dom.box=document.createElement("div"),this.dom.frame=document.createElement("div"),this.dom.frame.className="vis-item-overflow",this.dom.box.appendChild(this.dom.frame),this.dom.visibleFrame=document.createElement("div"),this.dom.visibleFrame.className="vis-item-visible-frame",this.dom.box.appendChild(this.dom.visibleFrame),this.dom.content=document.createElement("div"),this.dom.content.className="vis-item-content",this.dom.frame.appendChild(this.dom.content),this.dom.box["vis-item"]=this,this.dirty=!0)}},{key:"_appendDomElement",value:function(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){var t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.box)}this.displayed=!0}},{key:"_updateDirtyDomComponents",value:function(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.box),this._updateStyle(this.dom.box);var t=this.editable.updateTime||this.editable.updateGroup,e=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+(t?" vis-editable":" vis-readonly");this.dom.box.className=this.baseClassName+e,this.dom.content.style.maxWidth="none"}}},{key:"_getDomComponentsSizes",value:function(){return this.overflow="hidden"!==window.getComputedStyle(this.dom.frame).overflow,this.whiteSpace="nowrap"!==window.getComputedStyle(this.dom.content).whiteSpace,{content:{width:this.dom.content.offsetWidth},box:{height:this.dom.box.offsetHeight}}}},{key:"_updateDomComponentsSizes",value:function(t){this.props.content.width=t.content.width,this.height=t.box.height,this.dom.content.style.maxWidth="",this.dirty=!1}},{key:"_repaintDomAdditionals",value:function(){this._repaintOnItemUpdateTimeTooltip(this.dom.box),this._repaintDeleteButton(this.dom.box),this._repaintDragCenter(),this._repaintDragLeft(),this._repaintDragRight()}},{key:"redraw",value:function(t){var e,i,n,o,s,r,a=this,l=[va(e=this._createDomElement).call(e,this),va(i=this._appendDomElement).call(i,this),va(n=this._updateDirtyDomComponents).call(n,this),function(){var t;a.dirty&&(s=va(t=a._getDomComponentsSizes).call(t,a)())},function(){var t;a.dirty&&va(t=a._updateDomComponentsSizes).call(t,a)(s)},va(o=this._repaintDomAdditionals).call(o,this)];return t?l:(mn(l).call(l,(function(t){r=t()})),r)}},{key:"show",value:function(t){if(!this.displayed)return this.redraw(t)}},{key:"hide",value:function(){if(this.displayed){var t=this.dom.box;t.parentNode&&t.parentNode.removeChild(t),this.displayed=!1}}},{key:"repositionX",value:function(t){var e,i,n=this.parent.width,o=this.conversion.toScreen(this.data.start),s=this.conversion.toScreen(this.data.end),r=void 0===this.data.align?this.options.align:this.data.align;!1===this.data.limitSize||void 0!==t&&!0!==t||(o<-n&&(o=-n),s>2*n&&(s=2*n));var a=Math.max(Math.round(1e3*(s-o))/1e3,1);switch(this.overflow?(this.options.rtl?this.right=o:this.left=o,this.width=a+this.props.content.width,i=this.props.content.width):(this.options.rtl?this.right=o:this.left=o,this.width=a,i=Math.min(s-o,this.props.content.width)),this.options.rtl?this.dom.box.style.transform="translateX(".concat(-1*this.right,"px)"):this.dom.box.style.transform="translateX(".concat(this.left,"px)"),this.dom.box.style.width="".concat(a,"px"),this.whiteSpace&&(this.height=this.dom.box.offsetHeight),r){case"left":this.dom.content.style.transform="translateX(0)";break;case"right":if(this.options.rtl){var l=-1*Math.max(a-i,0);this.dom.content.style.transform="translateX(".concat(l,"px)")}else this.dom.content.style.transform="translateX(".concat(Math.max(a-i,0),"px)");break;case"center":if(this.options.rtl){var h=-1*Math.max((a-i)/2,0);this.dom.content.style.transform="translateX(".concat(h,"px)")}else this.dom.content.style.transform="translateX(".concat(Math.max((a-i)/2,0),"px)");break;default:if(e=this.overflow?s>0?Math.max(-o,0):-i:o<0?-o:0,this.options.rtl){var d=-1*e;this.dom.content.style.transform="translateX(".concat(d,"px)")}else this.dom.content.style.transform="translateX(".concat(e,"px)")}}},{key:"repositionY",value:function(){var t=this.options.orientation.item,e=this.dom.box;e.style.top="".concat("top"==t?this.top:this.parent.height-this.top-this.height,"px")}},{key:"_repaintDragLeft",value:function(){if((this.selected||this.options.itemsAlwaysDraggable.range)&&this.editable.updateTime&&!this.dom.dragLeft){var t=document.createElement("div");t.className="vis-drag-left",t.dragLeftItem=this,this.dom.box.appendChild(t),this.dom.dragLeft=t}else this.selected||this.options.itemsAlwaysDraggable.range||!this.dom.dragLeft||(this.dom.dragLeft.parentNode&&this.dom.dragLeft.parentNode.removeChild(this.dom.dragLeft),this.dom.dragLeft=null)}},{key:"_repaintDragRight",value:function(){if((this.selected||this.options.itemsAlwaysDraggable.range)&&this.editable.updateTime&&!this.dom.dragRight){var t=document.createElement("div");t.className="vis-drag-right",t.dragRightItem=this,this.dom.box.appendChild(t),this.dom.dragRight=t}else this.selected||this.options.itemsAlwaysDraggable.range||!this.dom.dragRight||(this.dom.dragRight.parentNode&&this.dom.dragRight.parentNode.removeChild(this.dom.dragRight),this.dom.dragRight=null)}}]),e}(Pd);qd.prototype.baseClassName="vis-item vis-range";var $d=function(t){function e(t,i,n){var o;if(ba(this,e),(o=ar(this,dr(e).call(this,t,i,n))).props={content:{width:0}},o.overflow=!1,t){if(null==t.start)throw new Error('Property "start" missing in item '.concat(t.id));if(null==t.end)throw new Error('Property "end" missing in item '.concat(t.id))}return o}return pr(e,t),xa(e,[{key:"isVisible",value:function(t){return this.data.start<t.end&&this.data.end>t.start}},{key:"_createDomElement",value:function(){this.dom||(this.dom={},this.dom.box=document.createElement("div"),this.dom.frame=document.createElement("div"),this.dom.frame.className="vis-item-overflow",this.dom.box.appendChild(this.dom.frame),this.dom.content=document.createElement("div"),this.dom.content.className="vis-item-content",this.dom.frame.appendChild(this.dom.content),this.dirty=!0)}},{key:"_appendDomElement",value:function(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){var t=this.parent.dom.background;if(!t)throw new Error("Cannot redraw item: parent has no background container element");t.appendChild(this.dom.box)}this.displayed=!0}},{key:"_updateDirtyDomComponents",value:function(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.content),this._updateStyle(this.dom.box);var t=(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"");this.dom.box.className=this.baseClassName+t}}},{key:"_getDomComponentsSizes",value:function(){return this.overflow="hidden"!==window.getComputedStyle(this.dom.content).overflow,{content:{width:this.dom.content.offsetWidth}}}},{key:"_updateDomComponentsSizes",value:function(t){this.props.content.width=t.content.width,this.height=0,this.dirty=!1}},{key:"_repaintDomAdditionals",value:function(){}},{key:"redraw",value:function(t){var e,i,n,o,s,r,a=this,l=[va(e=this._createDomElement).call(e,this),va(i=this._appendDomElement).call(i,this),va(n=this._updateDirtyDomComponents).call(n,this),function(){var t;a.dirty&&(s=va(t=a._getDomComponentsSizes).call(t,a)())},function(){var t;a.dirty&&va(t=a._updateDomComponentsSizes).call(t,a)(s)},va(o=this._repaintDomAdditionals).call(o,this)];return t?l:(mn(l).call(l,(function(t){r=t()})),r)}},{key:"repositionY",value:function(t){var e,i=this.options.orientation.item;if(void 0!==this.data.subgroup){var n=this.data.subgroup;this.dom.box.style.height="".concat(this.parent.subgroups[n].height,"px"),this.dom.box.style.top="".concat("top"==i?this.parent.top+this.parent.subgroups[n].top:this.parent.top+this.parent.height-this.parent.subgroups[n].top-this.parent.subgroups[n].height,"px"),this.dom.box.style.bottom=""}else this.parent instanceof Hd?(e=Math.max(this.parent.height,this.parent.itemSet.body.domProps.center.height,this.parent.itemSet.body.domProps.centerContainer.height),this.dom.box.style.bottom="bottom"==i?"0":"",this.dom.box.style.top="top"==i?"0":""):(e=this.parent.height,this.dom.box.style.top="".concat(this.parent.top,"px"),this.dom.box.style.bottom="");this.dom.box.style.height="".concat(e,"px")}}]),e}(Pd);$d.prototype.baseClassName="vis-item vis-background",$d.prototype.stack=!1,$d.prototype.show=qd.prototype.show,$d.prototype.hide=qd.prototype.hide,$d.prototype.repositionX=qd.prototype.repositionX;Ph("div.vis-tooltip{position:absolute;visibility:hidden;padding:5px;white-space:nowrap;font-family:verdana;font-size:14px;color:#000;background-color:#f5f4ed;-moz-border-radius:3px;-webkit-border-radius:3px;border-radius:3px;border:1px solid #808074;box-shadow:3px 3px 10px rgba(0,0,0,.2);pointer-events:none;z-index:5}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRvb2x0aXAuY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLGdCQUNFLGlCQUFrQixDQUNsQixpQkFBa0IsQ0FDbEIsV0FBWSxDQUNaLGtCQUFtQixDQUVuQixtQkFBb0IsQ0FDcEIsY0FBYyxDQUNkLFVBQWEsQ0FDYix3QkFBeUIsQ0FFekIsc0JBQXVCLENBQ3ZCLHlCQUEwQixDQUMxQixpQkFBa0IsQ0FDbEIsd0JBQXlCLENBRXpCLHNDQUEyQyxDQUMzQyxtQkFBb0IsQ0FFcEIsU0FDRiIsImZpbGUiOiJ0b29sdGlwLmNzcyIsInNvdXJjZXNDb250ZW50IjpbImRpdi52aXMtdG9vbHRpcCB7XG4gIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgdmlzaWJpbGl0eTogaGlkZGVuO1xuICBwYWRkaW5nOiA1cHg7XG4gIHdoaXRlLXNwYWNlOiBub3dyYXA7XG5cbiAgZm9udC1mYW1pbHk6IHZlcmRhbmE7XG4gIGZvbnQtc2l6ZToxNHB4O1xuICBjb2xvcjojMDAwMDAwO1xuICBiYWNrZ3JvdW5kLWNvbG9yOiAjZjVmNGVkO1xuXG4gIC1tb3otYm9yZGVyLXJhZGl1czogM3B4O1xuICAtd2Via2l0LWJvcmRlci1yYWRpdXM6IDNweDtcbiAgYm9yZGVyLXJhZGl1czogM3B4O1xuICBib3JkZXI6IDFweCBzb2xpZCAjODA4MDc0O1xuXG4gIGJveC1zaGFkb3c6IDNweCAzcHggMTBweCByZ2JhKDAsIDAsIDAsIDAuMik7XG4gIHBvaW50ZXItZXZlbnRzOiBub25lO1xuXG4gIHotaW5kZXg6IDU7XG59XG4iXX0= */");var tu=function(){function t(e,i){ba(this,t),this.container=e,this.overflowMethod=i||"cap",this.x=0,this.y=0,this.padding=5,this.hidden=!1,this.frame=document.createElement("div"),this.frame.className="vis-tooltip",this.container.appendChild(this.frame)}return xa(t,[{key:"setPosition",value:function(t,e){this.x=Nn(t),this.y=Nn(e)}},{key:"setText",value:function(t){t instanceof Element?(this.frame.innerHTML="",this.frame.appendChild(t)):this.frame.innerHTML=t}},{key:"show",value:function(t){if(void 0===t&&(t=!0),!0===t){var e=this.frame.clientHeight,i=this.frame.clientWidth,n=this.frame.parentNode.clientHeight,o=this.frame.parentNode.clientWidth,s=0,r=0;if("flip"==this.overflowMethod||"none"==this.overflowMethod){var a=!1,l=!0;"flip"==this.overflowMethod&&(this.y-e<this.padding&&(l=!1),this.x+i>o-this.padding&&(a=!0)),s=a?this.x-i:this.x,r=l?this.y-e:this.y}else(r=this.y-e)+e+this.padding>n&&(r=n-e-this.padding),r<this.padding&&(r=this.padding),(s=this.x)+i+this.padding>o&&(s=o-i-this.padding),s<this.padding&&(s=this.padding);this.frame.style.left=s+"px",this.frame.style.top=r+"px",this.frame.style.visibility="visible",this.hidden=!1}else this.hide()}},{key:"hide",value:function(){this.hidden=!0,this.frame.style.left="0",this.frame.style.top="0",this.frame.style.visibility="hidden"}},{key:"destroy",value:function(){this.frame.parentNode.removeChild(this.frame)}}]),t}(),eu=Ce.every,iu=$i("every"),nu=on("every");V({target:"Array",proto:!0,forced:!iu||!nu},{every:function(t){return eu(this,t,arguments.length>1?arguments[1]:void 0)}});var ou=Pi("Array").every,su=Array.prototype,ru=function(t){var e=t.every;return t===su||t instanceof Array&&e===su.every?ou:e},au=function(t){function e(t,i,n){var o;ba(this,e);var s=Ao({},{fitOnDoubleClick:!0},n,{editable:!1});if((o=ar(this,dr(e).call(this,t,i,s))).props={content:{width:0,height:0}},!t||null==t.uiItems)throw new Error('Property "uiItems" missing in item '+t.id);return o.id=Id(),o.group=t.group,o._setupRange(),o.emitter=o.data.eventEmitter,o.range=o.data.range,o.attached=!1,o.isCluster=!0,o.data.isCluster=!0,o}return pr(e,t),xa(e,[{key:"hasItems",value:function(){return this.data.uiItems&&this.data.uiItems.length&&this.attached}},{key:"setUiItems",value:function(t){this.detach(),this.data.uiItems=t,this._setupRange(),this.attach()}},{key:"isVisible",value:function(t){var e=this.data.end?this.data.end-this.data.start:0,i=this.width*t.getMillisecondsPerPixel(),n=Math.max(e,this.data.start.getTime()+i);return this.data.start<t.end&&n>t.start&&this.hasItems()}},{key:"getData",value:function(){return{isCluster:!0,id:this.id,items:this.data.items||[],data:this.data}}},{key:"redraw",value:function(t){var e,i,n,o,s,r,a,l,h=[va(e=this._createDomElement).call(e,this),va(i=this._appendDomElement).call(i,this),va(n=this._updateDirtyDomComponents).call(n,this),va(o=function(){this.dirty&&(a=this._getDomComponentsSizes())}).call(o,this),va(s=function(){var t;this.dirty&&va(t=this._updateDomComponentsSizes).call(t,this)(a)}).call(s,this),va(r=this._repaintDomAdditionals).call(r,this)];return t?h:(mn(h).call(h,(function(t){l=t()})),l)}},{key:"show",value:function(){this.displayed||this.redraw()}},{key:"hide",value:function(){if(this.displayed){var t=this.dom;t.box.parentNode&&t.box.parentNode.removeChild(t.box),this.options.showStipes&&(t.line.parentNode&&t.line.parentNode.removeChild(t.line),t.dot.parentNode&&t.dot.parentNode.removeChild(t.dot)),this.displayed=!1}}},{key:"repositionX",value:function(){var t=this.conversion.toScreen(this.data.start),e=this.data.end?this.conversion.toScreen(this.data.end):0;if(e)this.repositionXWithRanges(t,e);else{var i=void 0===this.data.align?this.options.align:this.data.align;this.repositionXWithoutRanges(t,i)}this.options.showStipes&&(this.dom.line.style.display=this._isStipeVisible()?"block":"none",this.dom.dot.style.display=this._isStipeVisible()?"block":"none",this._isStipeVisible()&&this.repositionStype(t,e))}},{key:"repositionStype",value:function(t,e){this.dom.line.style.display="block",this.dom.dot.style.display="block";var i=this.dom.line.offsetWidth,n=this.dom.dot.offsetWidth;if(e){var o=i+t+(e-t)/2,s=o-n/2,r=this.options.rtl?-1*o:o,a=this.options.rtl?-1*s:s;this.dom.line.style.transform="translateX(".concat(r,"px)"),this.dom.dot.style.transform="translateX(".concat(a,"px)")}else{var l=this.options.rtl?-1*t:t,h=this.options.rtl?-1*(t-n/2):t-n/2;this.dom.line.style.transform="translateX(".concat(l,"px)"),this.dom.dot.style.transform="translateX(".concat(h,"px)")}}},{key:"repositionXWithoutRanges",value:function(t,e){"right"==e?this.options.rtl?(this.right=t-this.width,this.dom.box.style.right=this.right+"px"):(this.left=t-this.width,this.dom.box.style.left=this.left+"px"):"left"==e?this.options.rtl?(this.right=t,this.dom.box.style.right=this.right+"px"):(this.left=t,this.dom.box.style.left=this.left+"px"):this.options.rtl?(this.right=t-this.width/2,this.dom.box.style.right=this.right+"px"):(this.left=t-this.width/2,this.dom.box.style.left=this.left+"px")}},{key:"repositionXWithRanges",value:function(t,e){var i=Math.round(Math.max(e-t+.5,1));this.options.rtl?this.right=t:this.left=t,this.width=Math.max(i,this.minWidth||0),this.options.rtl?this.dom.box.style.right=this.right+"px":this.dom.box.style.left=this.left+"px",this.dom.box.style.width=i+"px"}},{key:"repositionY",value:function(){var t=this.options.orientation.item,e=this.dom.box;if(e.style.top="top"==t?(this.top||0)+"px":(this.parent.height-this.top-this.height||0)+"px",this.options.showStipes){if("top"==t)this.dom.line.style.top="0",this.dom.line.style.height=this.parent.top+this.top+1+"px",this.dom.line.style.bottom="";else{var i=this.parent.itemSet.props.height,n=i-this.parent.top-this.parent.height+this.top;this.dom.line.style.top=i-n+"px",this.dom.line.style.bottom="0"}this.dom.dot.style.top=-this.dom.dot.offsetHeight/2+"px"}}},{key:"getWidthLeft",value:function(){return this.width/2}},{key:"getWidthRight",value:function(){return this.width/2}},{key:"move",value:function(){this.repositionX(),this.repositionY()}},{key:"attach",value:function(){var t,e=!0,i=!1,n=void 0;try{for(var o,s=Fi(this.data.uiItems);!(e=(o=s.next()).done);e=!0){o.value.cluster=this}}catch(t){i=!0,n=t}finally{try{e||null==s.return||s.return()}finally{if(i)throw n}}this.data.items=Ln(t=this.data.uiItems).call(t,(function(t){return t.data})),this.attached=!0,this.dirty=!0}},{key:"detach",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(this.hasItems()){var e=!0,i=!1,n=void 0;try{for(var o,s=Fi(this.data.uiItems);!(e=(o=s.next()).done);e=!0){var r=o.value;delete r.cluster}}catch(t){i=!0,n=t}finally{try{e||null==s.return||s.return()}finally{if(i)throw n}}this.attached=!1,t&&this.group&&(this.group.remove(this),this.group=null),this.data.items=[],this.dirty=!0}}},{key:"_onDoubleClick",value:function(){this._fit()}},{key:"_setupRange",value:function(){var t,e,i,n=Ln(t=this.data.uiItems).call(t,(function(t){return{start:t.data.start.valueOf(),end:t.data.end?t.data.end.valueOf():t.data.start.valueOf()}}));this.data.min=Math.min.apply(Math,mo(Ln(n).call(n,(function(t){return Math.min(t.start,t.end||t.start)})))),this.data.max=Math.max.apply(Math,mo(Ln(n).call(n,(function(t){return Math.max(t.start,t.end||t.start)}))));var o=Ln(e=this.data.uiItems).call(e,(function(t){return t.center})),s=da(o).call(o,(function(t,e){return t+e}),0)/this.data.uiItems.length;rr(i=this.data.uiItems).call(i,(function(t){return t.data.end}))?(this.data.start=new Date(this.data.min),this.data.end=new Date(this.data.max)):(this.data.start=new Date(s),this.data.end=null)}},{key:"_getUiItems",value:function(){var t,e=this;return this.data.uiItems&&this.data.uiItems.length?En(t=this.data.uiItems).call(t,(function(t){return t.cluster===e})):[]}},{key:"_createDomElement",value:function(){if(!this.dom){var t;if(this.dom={},this.dom.box=document.createElement("DIV"),this.dom.content=document.createElement("DIV"),this.dom.content.className="vis-item-content",this.dom.box.appendChild(this.dom.content),this.options.showStipes&&(this.dom.line=document.createElement("DIV"),this.dom.line.className="vis-cluster-line",this.dom.line.style.display="none",this.dom.dot=document.createElement("DIV"),this.dom.dot.className="vis-cluster-dot",this.dom.dot.style.display="none"),this.options.fitOnDoubleClick)this.dom.box.ondblclick=va(t=e.prototype._onDoubleClick).call(t,this);this.dom.box["vis-item"]=this,this.dirty=!0}}},{key:"_appendDomElement",value:function(){if(!this.parent)throw new Error("Cannot redraw item: no parent attached");if(!this.dom.box.parentNode){var t=this.parent.dom.foreground;if(!t)throw new Error("Cannot redraw item: parent has no foreground container element");t.appendChild(this.dom.box)}var e=this.parent.dom.background;if(this.options.showStipes){if(!this.dom.line.parentNode){if(!e)throw new Error("Cannot redraw item: parent has no background container element");e.appendChild(this.dom.line)}if(!this.dom.dot.parentNode){var i=this.parent.dom.axis;if(!e)throw new Error("Cannot redraw item: parent has no axis container element");i.appendChild(this.dom.dot)}}this.displayed=!0}},{key:"_updateDirtyDomComponents",value:function(){if(this.dirty){this._updateContents(this.dom.content),this._updateDataAttributes(this.dom.box),this._updateStyle(this.dom.box);var t=this.baseClassName+" "+(this.data.className?" "+this.data.className:"")+(this.selected?" vis-selected":"")+" vis-readonly";this.dom.box.className="vis-item "+t,this.options.showStipes&&(this.dom.line.className="vis-item vis-cluster-line "+(this.selected?" vis-selected":""),this.dom.dot.className="vis-item vis-cluster-dot "+(this.selected?" vis-selected":"")),this.data.end&&(this.dom.content.style.maxWidth="none")}}},{key:"_getDomComponentsSizes",value:function(){var t={previous:{right:this.dom.box.style.right,left:this.dom.box.style.left},box:{width:this.dom.box.offsetWidth,height:this.dom.box.offsetHeight}};return this.options.showStipes&&(t.dot={height:this.dom.dot.offsetHeight,width:this.dom.dot.offsetWidth},t.line={width:this.dom.line.offsetWidth}),t}},{key:"_updateDomComponentsSizes",value:function(t){this.options.rtl?this.dom.box.style.right="0px":this.dom.box.style.left="0px",this.data.end?this.minWidth=t.box.width:this.width=t.box.width,this.height=t.box.height,this.options.rtl?this.dom.box.style.right=t.previous.right:this.dom.box.style.left=t.previous.left,this.dirty=!1}},{key:"_repaintDomAdditionals",value:function(){this._repaintOnItemUpdateTimeTooltip(this.dom.box)}},{key:"_isStipeVisible",value:function(){return this.minWidth>=this.width||!this.data.end}},{key:"_getFitRange",value:function(){var t=.05*(this.data.max-this.data.min)/2;return{fitStart:this.data.min-t,fitEnd:this.data.max+t}}},{key:"_fit",value:function(){if(this.emitter){var t=this._getFitRange(),e=t.fitStart,i=t.fitEnd,n={start:new Date(e),end:new Date(i),animation:!0};this.emitter.emit("fit",n)}}},{key:"_getItemData",value:function(){return this.data}}]),e}(Pd);au.prototype.baseClassName="vis-item vis-range vis-cluster";var lu="__ungrouped__",hu=function(){function t(e){ba(this,t),this.itemSet=e,this.groups={},this.cache={},this.cache[-1]=[]}return xa(t,[{key:"createClusterItem",value:function(t,e,i){return new au(t,e,i)}},{key:"setItems",value:function(t,e){this.items=t||[],this.dataChanged=!0,this.applyOnChangedLevel=!1,e&&e.applyOnChangedLevel&&(this.applyOnChangedLevel=e.applyOnChangedLevel)}},{key:"updateData",value:function(){this.dataChanged=!0,this.applyOnChangedLevel=!1}},{key:"getClusters",value:function(t,e,i){var n="boolean"==typeof i?{}:i,o=n.maxItems,s=n.clusterCriteria;s||(s=function(){return!0}),o=o||1;var r=-1,a=0;if(e>0){if(e>=1)return[];r=Math.abs(Math.round(Math.log(100/e)/Math.log(2))),a=Math.abs(Math.pow(2,r))}if(this.dataChanged){var l=r!=this.cacheLevel;(!this.applyOnChangedLevel||l)&&(this._dropLevelsCache(),this._filterData())}this.cacheLevel=r;var h=this.cache[r];if(!h){for(var d in h=[],this.groups)if(this.groups.hasOwnProperty(d))for(var u=this.groups[d],c=u.length,p=0;p<c;){for(var m=u[p],f=1,g=p-1;g>=0&&m.center-u[g].center<a/2;)!u[g].cluster&&s(m.data,u[g].data)&&f++,g--;for(var v=p+1;v<u.length&&u[v].center-m.center<a/2;)s(m.data,u[v].data)&&f++,v++;for(var b=h.length-1;b>=0&&m.center-h[b].center<a;)m.group==h[b].group&&s(m.data,h[b].data)&&f++,b--;if(f>o){for(var y=f-o+1,x=[],w=p;x.length<y&&w<u.length;)s(u[w].data,u[w].data)&&x.push(u[w]),w++;var _=this.itemSet.getGroupId(m.data),k=this.itemSet.groups[_]||this.itemSet.groups[lu],D=this._getClusterForItems(x,k,t,i);h.push(D),p+=y}else delete m.cluster,p+=1}this.cache[r]=h}return h}},{key:"_filterData",value:function(){var t={};this.groups=t;for(var e=0,i=On(this.items);e<i.length;e++){var n=i[e],o=n.parent?n.parent.groupId:"",s=t[o];s||(s=[],t[o]=s),s.push(n),n.data.start&&(n.data.end?n.center=(n.data.start.valueOf()+n.data.end.valueOf())/2:n.center=n.data.start.valueOf())}for(var r in t){var a;if(t.hasOwnProperty(r))wr(a=t[r]).call(a,(function(t,e){return t.center-e.center}))}this.dataChanged=!1}},{key:"_getClusterForItems",value:function(t,e,i,n){var o,s,r=Ln(o=i||[]).call(o,(function(t){var e;return{cluster:t,itemsIds:new Ar(Ln(e=t.data.uiItems).call(e,(function(t){return t.id})))}}));if(r.length){var a=!0,l=!1,h=void 0;try{for(var d,u=function(){var e=d.value;if(e.itemsIds.size===t.length&&ru(t).call(t,(function(t){return e.itemsIds.has(t.id)})))return s=e.cluster,"break"},c=Fi(r);!(a=(d=c.next()).done);a=!0){if("break"===u())break}}catch(t){l=!0,h=t}finally{try{a||null==c.return||c.return()}finally{if(l)throw h}}}if(s)return s.setUiItems(t),s.group!==e&&(s.group&&s.group.remove(s),e&&(e.add(s),s.group=e)),s;var p=n.titleTemplate||"",m={toScreen:this.itemSet.body.util.toScreen,toTime:this.itemSet.body.util.toTime},f=p.replace(/{count}/,t.length),g='<div title="'+f+'">'+t.length+"</div>",v=Ao({},n,this.itemSet.options),b={content:g,title:f,group:e,uiItems:t,eventEmitter:this.itemSet.body.emitter,range:this.itemSet.body.range};return s=this.createClusterItem(b,m,v),e&&(e.add(s),s.group=e),s.attach(),s}},{key:"_dropLevelsCache",value:function(){this.cache={},this.cacheLevel=-1,this.cache[this.cacheLevel]=[]}}]),t}();Ph('.vis-itemset{position:relative;padding:0;margin:0;box-sizing:border-box}.vis-itemset .vis-background,.vis-itemset .vis-foreground{position:absolute;width:100%;height:100%;overflow:visible}.vis-axis{position:absolute;width:100%;height:0;left:0;z-index:1}.vis-foreground .vis-group{position:relative;box-sizing:border-box;border-bottom:1px solid #bfbfbf}.vis-foreground .vis-group:last-child{border-bottom:none}.vis-nesting-group{cursor:pointer}.vis-label.vis-nested-group.vis-group-level-unknown-but-gte1{background:#f5f5f5}.vis-label.vis-nested-group.vis-group-level-0{background-color:#fff}.vis-ltr .vis-label.vis-nested-group.vis-group-level-0 .vis-inner{padding-left:0}.vis-rtl .vis-label.vis-nested-group.vis-group-level-0 .vis-inner{padding-right:0}.vis-label.vis-nested-group.vis-group-level-1{background-color:rgba(0,0,0,.05)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-1 .vis-inner{padding-left:15px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-1 .vis-inner{padding-right:15px}.vis-label.vis-nested-group.vis-group-level-2{background-color:rgba(0,0,0,.1)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-2 .vis-inner{padding-left:30px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-2 .vis-inner{padding-right:30px}.vis-label.vis-nested-group.vis-group-level-3{background-color:rgba(0,0,0,.15)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-3 .vis-inner{padding-left:45px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-3 .vis-inner{padding-right:45px}.vis-label.vis-nested-group.vis-group-level-4{background-color:rgba(0,0,0,.2)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-4 .vis-inner{padding-left:60px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-4 .vis-inner{padding-right:60px}.vis-label.vis-nested-group.vis-group-level-5{background-color:rgba(0,0,0,.25)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-5 .vis-inner{padding-left:75px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-5 .vis-inner{padding-right:75px}.vis-label.vis-nested-group.vis-group-level-6{background-color:rgba(0,0,0,.3)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-6 .vis-inner{padding-left:90px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-6 .vis-inner{padding-right:90px}.vis-label.vis-nested-group.vis-group-level-7{background-color:rgba(0,0,0,.35)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-7 .vis-inner{padding-left:105px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-7 .vis-inner{padding-right:105px}.vis-label.vis-nested-group.vis-group-level-8{background-color:rgba(0,0,0,.4)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-8 .vis-inner{padding-left:120px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-8 .vis-inner{padding-right:120px}.vis-label.vis-nested-group.vis-group-level-9{background-color:rgba(0,0,0,.45)}.vis-ltr .vis-label.vis-nested-group.vis-group-level-9 .vis-inner{padding-left:135px}.vis-rtl .vis-label.vis-nested-group.vis-group-level-9 .vis-inner{padding-right:135px}.vis-label.vis-nested-group{background-color:rgba(0,0,0,.5)}.vis-ltr .vis-label.vis-nested-group .vis-inner{padding-left:150px}.vis-rtl .vis-label.vis-nested-group .vis-inner{padding-right:150px}.vis-group-level-unknown-but-gte1{border:1px solid red}.vis-label.vis-nesting-group:before{display:inline-block;width:15px}.vis-label.vis-nesting-group.expanded:before{content:"\\25BC"}.vis-label.vis-nesting-group.collapsed:before{content:"\\25B6"}.vis-rtl .vis-label.vis-nesting-group.collapsed:before{content:"\\25C0"}.vis-ltr .vis-label:not(.vis-nesting-group):not(.vis-group-level-0){padding-left:15px}.vis-rtl .vis-label:not(.vis-nesting-group):not(.vis-group-level-0){padding-right:15px}.vis-overlay{position:absolute;top:0;left:0;width:100%;height:100%;z-index:10}\n/*# sourceMappingURL=data:application/json;base64,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 */');Ph(".vis-labelset{overflow:hidden}.vis-labelset,.vis-labelset .vis-label{position:relative;box-sizing:border-box}.vis-labelset .vis-label{left:0;top:0;width:100%;color:#4d4d4d;border-bottom:1px solid #bfbfbf}.vis-labelset .vis-label.draggable{cursor:pointer}.vis-group-is-dragging{background:rgba(0,0,0,.1)}.vis-labelset .vis-label:last-child{border-bottom:none}.vis-labelset .vis-label .vis-inner{display:inline-block;padding:5px}.vis-labelset .vis-label .vis-inner.vis-hidden{padding:0}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxhYmVsc2V0LmNzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFDQSxjQUdFLGVBR0YsQ0FFQSx1Q0FQRSxpQkFBa0IsQ0FJbEIscUJBV0YsQ0FSQSx5QkFFRSxNQUFPLENBQ1AsS0FBTSxDQUNOLFVBQVcsQ0FDWCxhQUFjLENBTWQsK0JBSEYsQ0FNQSxtQ0FDRSxjQUNGLENBRUEsdUJBQ0UseUJBQ0YsQ0FFQSxvQ0FDRSxrQkFDRixDQUVBLG9DQUNFLG9CQUFxQixDQUNyQixXQUNGLENBRUEsK0NBQ0UsU0FDRiIsImZpbGUiOiJsYWJlbHNldC5jc3MiLCJzb3VyY2VzQ29udGVudCI6WyJcbi52aXMtbGFiZWxzZXQge1xuICBwb3NpdGlvbjogcmVsYXRpdmU7XG5cbiAgb3ZlcmZsb3c6IGhpZGRlbjtcblxuICBib3gtc2l6aW5nOiBib3JkZXItYm94O1xufVxuXG4udmlzLWxhYmVsc2V0IC52aXMtbGFiZWwge1xuICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gIGxlZnQ6IDA7XG4gIHRvcDogMDtcbiAgd2lkdGg6IDEwMCU7XG4gIGNvbG9yOiAjNGQ0ZDRkO1xuXG4gIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG59XG5cbi52aXMtbGFiZWxzZXQgLnZpcy1sYWJlbCB7XG4gIGJvcmRlci1ib3R0b206IDFweCBzb2xpZCAjYmZiZmJmO1xufVxuXG4udmlzLWxhYmVsc2V0IC52aXMtbGFiZWwuZHJhZ2dhYmxlIHtcbiAgY3Vyc29yOiBwb2ludGVyO1xufVxuXG4udmlzLWdyb3VwLWlzLWRyYWdnaW5nIHtcbiAgYmFja2dyb3VuZDogcmdiYSgwLCAwLCAwLCAuMSk7XG59XG5cbi52aXMtbGFiZWxzZXQgLnZpcy1sYWJlbDpsYXN0LWNoaWxkIHtcbiAgYm9yZGVyLWJvdHRvbTogbm9uZTtcbn1cblxuLnZpcy1sYWJlbHNldCAudmlzLWxhYmVsIC52aXMtaW5uZXIge1xuICBkaXNwbGF5OiBpbmxpbmUtYmxvY2s7XG4gIHBhZGRpbmc6IDVweDtcbn1cblxuLnZpcy1sYWJlbHNldCAudmlzLWxhYmVsIC52aXMtaW5uZXIudmlzLWhpZGRlbiB7XG4gIHBhZGRpbmc6IDA7XG59XG4iXX0= */");var du="__background__",uu=function(t){function e(t,i){var n;ba(this,e),(n=ar(this,dr(e).call(this))).body=t,n.defaultOptions={type:null,orientation:{item:"bottom"},align:"auto",stack:!0,stackSubgroups:!0,groupOrderSwap:function(t,e,i){var n=e.order;e.order=t.order,t.order=n},groupOrder:"order",selectable:!0,multiselect:!1,longSelectPressTime:251,itemsAlwaysDraggable:{item:!1,range:!1},editable:{updateTime:!1,updateGroup:!1,add:!1,remove:!1,overrideItems:!1},groupEditable:{order:!1,add:!1,remove:!1},snap:Hh.snap,onDropObjectOnItem:function(t,e,i){i(e)},onAdd:function(t,e){e(t)},onUpdate:function(t,e){e(t)},onMove:function(t,e){e(t)},onRemove:function(t,e){e(t)},onMoving:function(t,e){e(t)},onAddGroup:function(t,e){e(t)},onMoveGroup:function(t,e){e(t)},onRemoveGroup:function(t,e){e(t)},margin:{item:{horizontal:10,vertical:10},axis:20},showTooltips:!0,tooltip:{followMouse:!1,overflowMethod:"flip",delay:500},tooltipOnItemUpdateTime:!1},n.options=za.extend({},n.defaultOptions),n.options.rtl=i.rtl,n.options.onTimeout=i.onTimeout,n.conversion={toScreen:t.util.toScreen,toTime:t.util.toTime},n.dom={},n.props={},n.hammer=null;var o=Bs(n);return n.itemsData=null,n.groupsData=null,n.itemsSettingTime=null,n.initialItemSetDrawn=!1,n.userContinueNotBail=null,n.sequentialSelection=!1,n.itemListeners={add:function(t,e,i){o._onAdd(e.items),o.options.cluster&&o.clusterGenerator.setItems(o.items,{applyOnChangedLevel:!1}),o.redraw()},update:function(t,e,i){o._onUpdate(e.items),o.options.cluster&&o.clusterGenerator.setItems(o.items,{applyOnChangedLevel:!1}),o.redraw()},remove:function(t,e,i){o._onRemove(e.items),o.options.cluster&&o.clusterGenerator.setItems(o.items,{applyOnChangedLevel:!1}),o.redraw()}},n.groupListeners={add:function(t,e,i){if(o._onAddGroups(e.items),o.groupsData&&o.groupsData.length>0){var n,s=o.groupsData.getDataSet();mn(n=s.get()).call(n,(function(t){if(t.nestedGroups){var e;0!=t.showNested&&(t.showNested=!0);var n=[];mn(e=t.nestedGroups).call(e,(function(e){var i=s.get(e);i&&(i.nestedInGroup=t.id,0==t.showNested&&(i.visible=!1),n=Pn(n).call(n,i))})),s.update(n,i)}}))}},update:function(t,e,i){o._onUpdateGroups(e.items)},remove:function(t,e,i){o._onRemoveGroups(e.items)}},n.items={},n.groups={},n.groupIds=[],n.selection=[],n.popup=null,n.popupTimer=null,n.touchParams={},n.groupTouchParams={group:null,isDragging:!1},n._create(),n.setOptions(i),n.clusters=[],n}return pr(e,t),xa(e,[{key:"_create",value:function(){var t,e,i,n,o,s,r,a,l,h,d,u,c,p,m,f=this,g=document.createElement("div");g.className="vis-itemset",g["vis-itemset"]=this,this.dom.frame=g;var v=document.createElement("div");v.className="vis-background",g.appendChild(v),this.dom.background=v;var b=document.createElement("div");b.className="vis-foreground",g.appendChild(b),this.dom.foreground=b;var y=document.createElement("div");y.className="vis-axis",this.dom.axis=y;var x=document.createElement("div");x.className="vis-labelset",this.dom.labelSet=x,this._updateUngrouped();var w=new Hd(du,null,this);w.show(),this.groups[du]=w,this.hammer=new Vh(this.body.dom.centerContainer),this.hammer.on("hammer.input",(function(t){t.isFirst&&f._onTouch(t)})),this.hammer.on("panstart",va(t=this._onDragStart).call(t,this)),this.hammer.on("panmove",va(e=this._onDrag).call(e,this)),this.hammer.on("panend",va(i=this._onDragEnd).call(i,this)),this.hammer.get("pan").set({threshold:5,direction:Vh.ALL}),this.hammer.on("tap",va(n=this._onSelectItem).call(n,this)),this.hammer.on("press",va(o=this._onMultiSelectItem).call(o,this)),this.hammer.on("doubletap",va(s=this._onAddItem).call(s,this)),this.options.rtl?this.groupHammer=new Vh(this.body.dom.rightContainer):this.groupHammer=new Vh(this.body.dom.leftContainer),this.groupHammer.on("tap",va(r=this._onGroupClick).call(r,this)),this.groupHammer.on("panstart",va(a=this._onGroupDragStart).call(a,this)),this.groupHammer.on("panmove",va(l=this._onGroupDrag).call(l,this)),this.groupHammer.on("panend",va(h=this._onGroupDragEnd).call(h,this)),this.groupHammer.get("pan").set({threshold:5,direction:Vh.DIRECTION_VERTICAL}),this.body.dom.centerContainer.addEventListener("mouseover",va(d=this._onMouseOver).call(d,this)),this.body.dom.centerContainer.addEventListener("mouseout",va(u=this._onMouseOut).call(u,this)),this.body.dom.centerContainer.addEventListener("mousemove",va(c=this._onMouseMove).call(c,this)),this.body.dom.centerContainer.addEventListener("contextmenu",va(p=this._onDragEnd).call(p,this)),this.body.dom.centerContainer.addEventListener("mousewheel",va(m=this._onMouseWheel).call(m,this)),this.show()}},{key:"setOptions",value:function(t){var e=this;if(t){var i,n;za.selectiveExtend(["type","rtl","align","order","stack","stackSubgroups","selectable","multiselect","sequentialSelection","multiselectPerGroup","longSelectPressTime","groupOrder","dataAttributes","template","groupTemplate","visibleFrameTemplate","hide","snap","groupOrderSwap","showTooltips","tooltip","tooltipOnItemUpdateTime","groupHeightMode","onTimeout"],this.options,t),"itemsAlwaysDraggable"in t&&("boolean"==typeof t.itemsAlwaysDraggable?(this.options.itemsAlwaysDraggable.item=t.itemsAlwaysDraggable,this.options.itemsAlwaysDraggable.range=!1):"object"===zo(t.itemsAlwaysDraggable)&&(za.selectiveExtend(["item","range"],this.options.itemsAlwaysDraggable,t.itemsAlwaysDraggable),this.options.itemsAlwaysDraggable.item||(this.options.itemsAlwaysDraggable.range=!1))),"sequentialSelection"in t&&"boolean"==typeof t.sequentialSelection&&(this.options.sequentialSelection=t.sequentialSelection),"orientation"in t&&("string"==typeof t.orientation?this.options.orientation.item="top"===t.orientation?"top":"bottom":"object"===zo(t.orientation)&&"item"in t.orientation&&(this.options.orientation.item=t.orientation.item)),"margin"in t&&("number"==typeof t.margin?(this.options.margin.axis=t.margin,this.options.margin.item.horizontal=t.margin,this.options.margin.item.vertical=t.margin):"object"===zo(t.margin)&&(za.selectiveExtend(["axis"],this.options.margin,t.margin),"item"in t.margin&&("number"==typeof t.margin.item?(this.options.margin.item.horizontal=t.margin.item,this.options.margin.item.vertical=t.margin.item):"object"===zo(t.margin.item)&&za.selectiveExtend(["horizontal","vertical"],this.options.margin.item,t.margin.item)))),mn(i=["locale","locales"]).call(i,(function(i){i in t&&(e.options[i]=t[i])})),"editable"in t&&("boolean"==typeof t.editable?(this.options.editable.updateTime=t.editable,this.options.editable.updateGroup=t.editable,this.options.editable.add=t.editable,this.options.editable.remove=t.editable,this.options.editable.overrideItems=!1):"object"===zo(t.editable)&&za.selectiveExtend(["updateTime","updateGroup","add","remove","overrideItems"],this.options.editable,t.editable)),"groupEditable"in t&&("boolean"==typeof t.groupEditable?(this.options.groupEditable.order=t.groupEditable,this.options.groupEditable.add=t.groupEditable,this.options.groupEditable.remove=t.groupEditable):"object"===zo(t.groupEditable)&&za.selectiveExtend(["order","add","remove"],this.options.groupEditable,t.groupEditable));mn(n=["onDropObjectOnItem","onAdd","onUpdate","onRemove","onMove","onMoving","onAddGroup","onMoveGroup","onRemoveGroup"]).call(n,(function(i){var n=t[i];if(n){var o;if("function"!=typeof n)throw new Error(Pn(o="option ".concat(i," must be a function ")).call(o,i,"(item, callback)"));e.options[i]=n}})),t.cluster?(Ao(this.options,{cluster:t.cluster}),this.clusterGenerator||(this.clusterGenerator=new hu(this)),this.clusterGenerator.setItems(this.items,{applyOnChangedLevel:!1}),this.markDirty({refreshItems:!0,restackGroups:!0}),this.redraw()):this.clusterGenerator?(this._detachAllClusters(),this.clusters=[],this.clusterGenerator=null,this.options.cluster=void 0,this.markDirty({refreshItems:!0,restackGroups:!0}),this.redraw()):this.markDirty()}}},{key:"markDirty",value:function(t){this.groupIds=[],t&&(t.refreshItems&&mn(za).call(za,this.items,(function(t){t.dirty=!0,t.displayed&&t.redraw()})),t.restackGroups&&mn(za).call(za,this.groups,(function(t,e){e!==du&&(t.stackDirty=!0)})))}},{key:"destroy",value:function(){this.clearPopupTimer(),this.hide(),this.setItems(null),this.setGroups(null),this.hammer&&this.hammer.destroy(),this.groupHammer&&this.groupHammer.destroy(),this.hammer=null,this.body=null,this.conversion=null}},{key:"hide",value:function(){this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom.axis.parentNode&&this.dom.axis.parentNode.removeChild(this.dom.axis),this.dom.labelSet.parentNode&&this.dom.labelSet.parentNode.removeChild(this.dom.labelSet)}},{key:"show",value:function(){this.dom.frame.parentNode||this.body.dom.center.appendChild(this.dom.frame),this.dom.axis.parentNode||this.body.dom.backgroundVertical.appendChild(this.dom.axis),this.dom.labelSet.parentNode||(this.options.rtl?this.body.dom.right.appendChild(this.dom.labelSet):this.body.dom.left.appendChild(this.dom.labelSet))}},{key:"setPopupTimer",value:function(t){if(this.clearPopupTimer(),t){var e=this.options.tooltip.delay||"number"==typeof this.options.tooltip.delay?this.options.tooltip.delay:500;this.popupTimer=qr((function(){t.show()}),e)}}},{key:"clearPopupTimer",value:function(){null!=this.popupTimer&&(clearTimeout(this.popupTimer),this.popupTimer=null)}},{key:"setSelection",value:function(t){var e;null==t&&(t=[]),Zo(t)||(t=[t]);var i=En(e=this.selection).call(e,(function(e){return-1===Fo(t).call(t,e)})),n=!0,o=!1,s=void 0;try{for(var r,a=Fi(i);!(n=(r=a.next()).done);n=!0){var l=r.value,h=this.getItemById(l);h&&h.unselect()}}catch(t){o=!0,s=t}finally{try{n||null==a.return||a.return()}finally{if(o)throw s}}this.selection=mo(t);var d=!0,u=!1,c=void 0;try{for(var p,m=Fi(t);!(d=(p=m.next()).done);d=!0){var f=p.value,g=this.getItemById(f);g&&g.select()}}catch(t){u=!0,c=t}finally{try{d||null==m.return||m.return()}finally{if(u)throw c}}}},{key:"getSelection",value:function(){var t;return Pn(t=this.selection).call(t,[])}},{key:"getVisibleItems",value:function(){var t,e,i=this.body.range.getRange();this.options.rtl?(t=this.body.util.toScreen(i.start),e=this.body.util.toScreen(i.end)):(e=this.body.util.toScreen(i.start),t=this.body.util.toScreen(i.end));var n=[];for(var o in this.groups)if(this.groups.hasOwnProperty(o)){var s=this.groups[o],r=s.isVisible?s.visibleItems:[],a=!0,l=!1,h=void 0;try{for(var d,u=Fi(r);!(a=(d=u.next()).done);a=!0){var c=d.value;this.options.rtl?c.right<e&&c.right+c.width>t&&n.push(c.id):c.left<t&&c.left+c.width>e&&n.push(c.id)}}catch(t){l=!0,h=t}finally{try{a||null==u.return||u.return()}finally{if(l)throw h}}}return n}},{key:"getVisibleGroups",value:function(){var t=[];for(var e in this.groups){if(this.groups.hasOwnProperty(e))this.groups[e].isVisible&&t.push(e)}return t}},{key:"getItemById",value:function(t){var e;return this.items[t]||yd(e=this.clusters).call(e,(function(e){return e.id===t}))}},{key:"_deselect",value:function(t){for(var e=this.selection,i=0,n=e.length;i<n;i++)if(e[i]==t){Hr(e).call(e,i,1);break}}},{key:"redraw",value:function(){var t=this,e=this.options.margin,i=this.body.range,n=za.option.asSize,o=this.options,s=o.orientation.item,r=!1,a=this.dom.frame;this.props.top=this.body.domProps.top.height+this.body.domProps.border.top,this.options.rtl?this.props.right=this.body.domProps.right.width+this.body.domProps.border.right:this.props.left=this.body.domProps.left.width+this.body.domProps.border.left,a.className="vis-itemset",this.options.cluster&&this._clusterItems(),r=this._orderGroups()||r;var l=i.end-i.start,h=l!=this.lastVisibleInterval||this.props.width!=this.props.lastWidth,d=i.start!=this.lastRangeStart,u=o.stack!=this.lastStack,c=o.stackSubgroups!=this.lastStackSubgroups,p=h||d||u||c;this.lastVisibleInterval=l,this.lastRangeStart=i.start,this.lastStack=o.stack,this.lastStackSubgroups=o.stackSubgroups,this.props.lastWidth=this.props.width;var m=this._firstGroup(),f={item:e.item,axis:e.axis},g={item:e.item,axis:e.item.vertical/2},v=0,b=e.axis+e.item.vertical;this.groups[du].redraw(i,g,p);var y={},x=0;return mn(za).call(za,this.groups,(function(t,e){if(e!==du){var n=t==m?f:g;y[e]=t.redraw(i,n,p,!0),x=y[e].length}})),x>0&&function(){for(var e={},i=function(t){mn(za).call(za,y,(function(i,n){e[n]=i[t]()}))},n=0;n<x;n++)i(n);mn(za).call(za,t.groups,(function(t,i){if(i!==du){var n=e[i];r=n||r,v+=t.height}})),v=Math.max(v,b)}(),v=Math.max(v,b),a.style.height=n(v),this.props.width=a.offsetWidth,this.props.height=v,this.dom.axis.style.top=n("top"==s?this.body.domProps.top.height+this.body.domProps.border.top:this.body.domProps.top.height+this.body.domProps.centerContainer.height),this.options.rtl?this.dom.axis.style.right="0":this.dom.axis.style.left="0",this.hammer.get("press").set({time:this.options.longSelectPressTime}),this.initialItemSetDrawn=!0,r=this._isResized()||r}},{key:"_firstGroup",value:function(){var t="top"==this.options.orientation.item?0:this.groupIds.length-1,e=this.groupIds[t];return this.groups[e]||this.groups.__ungrouped__||null}},{key:"_updateUngrouped",value:function(){var t,e,i=this.groups.__ungrouped__;if(this.groupsData){if(i)for(e in i.dispose(),delete this.groups.__ungrouped__,this.items)if(this.items.hasOwnProperty(e)){(t=this.items[e]).parent&&t.parent.remove(t);var n=this.getGroupId(t.data),o=this.groups[n];o&&o.add(t)||t.hide()}}else if(!i){for(e in i=new jd(null,null,this),this.groups.__ungrouped__=i,this.items)this.items.hasOwnProperty(e)&&(t=this.items[e],i.add(t));i.show()}}},{key:"getLabelSet",value:function(){return this.dom.labelSet}},{key:"setItems",value:function(t){this.itemsSettingTime=new Date;var e,i=this,n=this.itemsData;if(t){if(!(t instanceof Aa||t instanceof Xa))throw new TypeError("Data must be an instance of DataSet or DataView");this.itemsData=Ua(t)}else this.itemsData=null;if(n&&(mn(za).call(za,this.itemListeners,(function(t,e){n.off(e,t)})),n.dispose(),e=n.getIds(),this._onRemove(e)),this.itemsData){var o=this.id;mn(za).call(za,this.itemListeners,(function(t,e){i.itemsData.on(e,t,o)})),e=this.itemsData.getIds(),this._onAdd(e),this._updateUngrouped()}this.body.emitter.emit("_change",{queue:!0})}},{key:"getItems",value:function(){return null!=this.itemsData?this.itemsData.rawDS:null}},{key:"setGroups",value:function(t){var e,i=this;if(this.groupsData&&(mn(za).call(za,this.groupListeners,(function(t,e){i.groupsData.off(e,t)})),e=this.groupsData.getIds(),this.groupsData=null,this._onRemoveGroups(e)),t){if(!(t instanceof Aa||t instanceof Xa))throw new TypeError("Data must be an instance of DataSet or DataView");this.groupsData=t}else this.groupsData=null;if(this.groupsData){var n,o=this.groupsData;this.groupsData instanceof Xa&&(o=this.groupsData.getDataSet()),mn(n=o.get()).call(n,(function(t){var e;t.nestedGroups&&mn(e=t.nestedGroups).call(e,(function(e){var i=o.get(e);i.nestedInGroup=t.id,0==t.showNested&&(i.visible=!1),o.update(i)}))}));var s=this.id;mn(za).call(za,this.groupListeners,(function(t,e){i.groupsData.on(e,t,s)})),e=this.groupsData.getIds(),this._onAddGroups(e)}this._updateUngrouped(),this._order(),this.options.cluster&&(this.clusterGenerator.updateData(),this._clusterItems(),this.markDirty({refreshItems:!0,restackGroups:!0})),this.body.emitter.emit("_change",{queue:!0})}},{key:"getGroups",value:function(){return this.groupsData}},{key:"removeItem",value:function(t){var e=this,i=this.itemsData.get(t);i&&this.options.onRemove(i,(function(i){i&&e.itemsData.remove(t)}))}},{key:"_getType",value:function(t){return t.type||this.options.type||(t.end?"range":"box")}},{key:"getGroupId",value:function(t){return"background"==this._getType(t)&&null==t.group?du:this.groupsData?t.group:"__ungrouped__"}},{key:"_onUpdate",value:function(t){var i=this,n=this;mn(t).call(t,(function(t){var o,s=n.itemsData.get(t),r=n.items[t],a=s?n._getType(s):null,l=e.types[a];if(r&&(l&&r instanceof l?n._updateItem(r,s):(o=r.selected,n._removeItem(r),r=null)),!r&&s){if(!l)throw new TypeError('Unknown item type "'.concat(a,'"'));(r=new l(s,n.conversion,n.options)).id=t,n._addItem(r),o&&(i.selection.push(t),r.select())}})),this._order(),this.options.cluster&&(this.clusterGenerator.setItems(this.items,{applyOnChangedLevel:!1}),this._clusterItems()),this.body.emitter.emit("_change",{queue:!0})}},{key:"_onRemove",value:function(t){var e=0,i=this;mn(t).call(t,(function(t){var n=i.items[t];n&&(e++,i._removeItem(n))})),e&&(this._order(),this.body.emitter.emit("_change",{queue:!0}))}},{key:"_order",value:function(){mn(za).call(za,this.groups,(function(t){t.order()}))}},{key:"_onUpdateGroups",value:function(t){this._onAddGroups(t)}},{key:"_onAddGroups",value:function(t){var e=this;mn(t).call(t,(function(t){var i=e.groupsData.get(t),n=e.groups[t];if(n)n.setData(i);else{if("__ungrouped__"==t||t==du)throw new Error("Illegal group id. ".concat(t," is a reserved id."));var o=Oi(e.options);for(var s in za.extend(o,{height:null}),n=new jd(t,i,e),e.groups[t]=n,e.items)if(e.items.hasOwnProperty(s)){var r=e.items[s];r.data.group==t&&n.add(r)}n.order(),n.show()}})),this.body.emitter.emit("_change",{queue:!0})}},{key:"_onRemoveGroups",value:function(t){var e=this;mn(t).call(t,(function(t){var i=e.groups[t];i&&(i.dispose(),delete e.groups[t])})),this.options.cluster&&(this.clusterGenerator.updateData(),this._clusterItems()),this.markDirty({restackGroups:!!this.options.cluster}),this.body.emitter.emit("_change",{queue:!0})}},{key:"_orderGroups",value:function(){if(this.groupsData){var t=this.groupsData.getIds({order:this.options.groupOrder});t=this._orderNestedGroups(t);var e=!za.equalArray(t,this.groupIds);if(e){var i=this.groups;mn(t).call(t,(function(t){i[t].hide()})),mn(t).call(t,(function(t){i[t].show()})),this.groupIds=t}return e}return!1}},{key:"_orderNestedGroups",value:function(t){var e=this;return function t(e,i){var n=[];return mn(i).call(i,(function(i){if(n.push(i),e.groupsData.get(i).nestedGroups){var o,s=Ln(o=e.groupsData.get({filter:function(t){return t.nestedInGroup==i},order:e.options.groupOrder})).call(o,(function(t){return t.id}));n=Pn(n).call(n,t(e,s))}})),n}(this,En(t).call(t,(function(t){return!e.groupsData.get(t).nestedInGroup})))}},{key:"_addItem",value:function(t){this.items[t.id]=t;var e=this.getGroupId(t.data),i=this.groups[e];i?i&&i.data&&i.data.showNested&&(t.groupShowing=!0):t.groupShowing=!1,i&&i.add(t)}},{key:"_updateItem",value:function(t,e){t.setData(e);var i=this.getGroupId(t.data),n=this.groups[i];n?n&&n.data&&n.data.showNested&&(t.groupShowing=!0):t.groupShowing=!1}},{key:"_removeItem",value:function(t){var e,i;t.hide(),delete this.items[t.id];var n=Fo(e=this.selection).call(e,t.id);-1!=n&&Hr(i=this.selection).call(i,n,1),t.parent&&t.parent.remove(t),null!=this.popup&&this.popup.hide()}},{key:"_constructByEndArray",value:function(t){for(var e=[],i=0;i<t.length;i++)t[i]instanceof qd&&e.push(t[i]);return e}},{key:"_onTouch",value:function(t){this.touchParams.item=this.itemFromTarget(t),this.touchParams.dragLeftItem=t.target.dragLeftItem||!1,this.touchParams.dragRightItem=t.target.dragRightItem||!1,this.touchParams.itemProps=null}},{key:"_getGroupIndex",value:function(t){for(var e=0;e<this.groupIds.length;e++)if(t==this.groupIds[e])return e}},{key:"_onDragStart",value:function(t){var e=this;if(!this.touchParams.itemIsDragging){var i,n=this.touchParams.item||null,o=this;if(n&&(n.selected||this.options.itemsAlwaysDraggable.item)){if(this.options.editable.overrideItems&&!this.options.editable.updateTime&&!this.options.editable.updateGroup)return;if(null!=n.editable&&!n.editable.updateTime&&!n.editable.updateGroup&&!this.options.editable.overrideItems)return;var s=this.touchParams.dragLeftItem,r=this.touchParams.dragRightItem;if(this.touchParams.itemIsDragging=!0,this.touchParams.selectedItem=n,s)i={item:s,initialX:t.center.x,dragLeft:!0,data:this._cloneItemData(n.data)},this.touchParams.itemProps=[i];else if(r)i={item:r,initialX:t.center.x,dragRight:!0,data:this._cloneItemData(n.data)},this.touchParams.itemProps=[i];else if(this.options.editable.add&&(t.srcEvent.ctrlKey||t.srcEvent.metaKey))this._onDragStartAddItem(t);else{this.groupIds.length<1&&this.redraw();var a=this._getGroupIndex(n.data.group),l=this.options.itemsAlwaysDraggable.item&&!n.selected?[n.id]:this.getSelection();this.touchParams.itemProps=Ln(l).call(l,(function(i){var n=o.items[i],s=o._getGroupIndex(n.data.group);return{item:n,initialX:t.center.x,groupOffset:a-s,data:e._cloneItemData(n.data)}}))}t.stopPropagation()}else this.options.editable.add&&(t.srcEvent.ctrlKey||t.srcEvent.metaKey)&&this._onDragStartAddItem(t)}}},{key:"_onDragStartAddItem",value:function(t){var e=this.options.snap||null,i=this.dom.frame.getBoundingClientRect(),n=this.options.rtl?i.right-t.center.x+10:t.center.x-i.left-10,o=this.body.util.toTime(n),s=this.body.util.getScale(),r=this.body.util.getStep(),a=e?e(o,s,r):o,l={type:"range",start:a,end:a,content:"new item"},h=Id();l[this.itemsData.idProp]=h;var d=this.groupFromTarget(t);d&&(l.group=d.groupId);var u=new qd(l,this.conversion,this.options);u.id=h,u.data=this._cloneItemData(l),this._addItem(u),this.touchParams.selectedItem=u;var c={item:u,initialX:t.center.x,data:u.data};this.options.rtl?c.dragLeft=!0:c.dragRight=!0,this.touchParams.itemProps=[c],t.stopPropagation()}},{key:"_onDrag",value:function(t){var e=this;if(null!=this.popup&&this.options.showTooltips&&!this.popup.hidden){var i=this.body.dom.centerContainer,n=i.getBoundingClientRect();this.popup.setPosition(t.center.x-n.left+i.offsetLeft,t.center.y-n.top+i.offsetTop),this.popup.show()}if(this.touchParams.itemProps){var o;t.stopPropagation();var s=this,r=this.options.snap||null,a=this.body.dom.root.offsetLeft,l=this.options.rtl?a+this.body.domProps.right.width:a+this.body.domProps.left.width,h=this.body.util.getScale(),d=this.body.util.getStep(),u=this.touchParams.selectedItem,c=(this.options.editable.overrideItems||null==u.editable)&&this.options.editable.updateGroup||!this.options.editable.overrideItems&&null!=u.editable&&u.editable.updateGroup,p=null;if(c&&u&&null!=u.data.group){var m=s.groupFromTarget(t);m&&(p=this._getGroupIndex(m.groupId))}mn(o=this.touchParams.itemProps).call(o,(function(i){var n,o,a,m,f,g=s.body.util.toTime(t.center.x-l),v=s.body.util.toTime(i.initialX-l);n=e.options.rtl?-(g-v):g-v;var b=e._cloneItemData(i.item.data);if(null==i.item.editable||i.item.editable.updateTime||i.item.editable.updateGroup||s.options.editable.overrideItems){if((e.options.editable.overrideItems||null==u.editable)&&e.options.editable.updateTime||!e.options.editable.overrideItems&&null!=u.editable&&u.editable.updateTime)if(i.dragLeft)e.options.rtl?null!=b.end&&(a=za.convert(i.data.end,"Date"),f=new Date(a.valueOf()+n),b.end=r?r(f,h,d):f):null!=b.start&&(o=za.convert(i.data.start,"Date"),m=new Date(o.valueOf()+n),b.start=r?r(m,h,d):m);else if(i.dragRight)e.options.rtl?null!=b.start&&(o=za.convert(i.data.start,"Date"),m=new Date(o.valueOf()+n),b.start=r?r(m,h,d):m):null!=b.end&&(a=za.convert(i.data.end,"Date"),f=new Date(a.valueOf()+n),b.end=r?r(f,h,d):f);else if(null!=b.start)if(o=za.convert(i.data.start,"Date").valueOf(),m=new Date(o+n),null!=b.end){var y=(a=za.convert(i.data.end,"Date")).valueOf()-o.valueOf();b.start=r?r(m,h,d):m,b.end=new Date(b.start.valueOf()+y)}else b.start=r?r(m,h,d):m;if(c&&!i.dragLeft&&!i.dragRight&&null!=p&&null!=b.group){var x=p-i.groupOffset;x=Math.max(0,x),x=Math.min(s.groupIds.length-1,x),b.group=s.groupIds[x]}b=e._cloneItemData(b),s.options.onMoving(b,(function(t){t&&i.item.setData(e._cloneItemData(t,"Date"))}))}})),this.body.emitter.emit("_change")}}},{key:"_moveToGroup",value:function(t,e){var i=this.groups[e];if(i&&i.groupId!=t.data.group){var n=t.parent;n.remove(t),n.order(),t.data.group=i.groupId,i.add(t),i.order()}}},{key:"_onDragEnd",value:function(t){var e=this;if(this.touchParams.itemIsDragging=!1,this.touchParams.itemProps){t.stopPropagation();var i=this,n=this.touchParams.itemProps;this.touchParams.itemProps=null,mn(n).call(n,(function(t){var n=t.item.id;if(null!=i.itemsData.get(n)){var o=e._cloneItemData(t.item.data);i.options.onMove(o,(function(o){o?(o[e.itemsData.idProp]=n,e.itemsData.update(o)):(t.item.setData(t.data),i.body.emitter.emit("_change"))}))}else i.options.onAdd(t.item.data,(function(e){i._removeItem(t.item),e&&i.itemsData.add(e),i.body.emitter.emit("_change")}))}))}}},{key:"_onGroupClick",value:function(t){var e=this,i=this.groupFromTarget(t);qr((function(){e.toggleGroupShowNested(i)}),1)}},{key:"toggleGroupShowNested",value:function(t){var e,i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;if(t&&t.nestedGroups){var n=this.groupsData.getDataSet();t.showNested=null!=i?!!i:!t.showNested;var o=n.get(t.groupId);o.showNested=t.showNested;for(var s=t.nestedGroups,r=s;r.length>0;){var a=r;r=[];for(var l=0;l<a.length;l++){var h=n.get(a[l]);h.nestedGroups&&(r=Pn(r).call(r,h.nestedGroups))}r.length>0&&(s=Pn(s).call(s,r))}var d=Ln(e=n.get(s)).call(e,(function(t){return null==t.visible&&(t.visible=!0),t.visible=!!o.showNested,t}));n.update(Pn(d).call(d,o)),o.showNested?(za.removeClassName(t.dom.label,"collapsed"),za.addClassName(t.dom.label,"expanded")):(za.removeClassName(t.dom.label,"expanded"),za.addClassName(t.dom.label,"collapsed"))}}},{key:"toggleGroupDragClassName",value:function(t){t.dom.label.classList.toggle("vis-group-is-dragging"),t.dom.foreground.classList.toggle("vis-group-is-dragging")}},{key:"_onGroupDragStart",value:function(t){this.groupTouchParams.isDragging||this.options.groupEditable.order&&(this.groupTouchParams.group=this.groupFromTarget(t),this.groupTouchParams.group&&(t.stopPropagation(),this.groupTouchParams.isDragging=!0,this.toggleGroupDragClassName(this.groupTouchParams.group),this.groupTouchParams.originalOrder=this.groupsData.getIds({order:this.options.groupOrder})))}},{key:"_onGroupDrag",value:function(t){if(this.options.groupEditable.order&&this.groupTouchParams.group){t.stopPropagation();var e=this.groupsData;this.groupsData instanceof Xa&&(e=this.groupsData.getDataSet());var i=this.groupFromTarget(t);if(i&&i.height!=this.groupTouchParams.group.height){var n=i.top<this.groupTouchParams.group.top,o=t.center?t.center.y:t.clientY,s=i.dom.foreground.getBoundingClientRect(),r=this.groupTouchParams.group.height;if(n){if(s.top+r<o)return}else{var a=i.height;if(s.top+a-r>o)return}}if(i&&i!=this.groupTouchParams.group){var l=e.get(i.groupId),h=e.get(this.groupTouchParams.group.groupId);h&&l&&(this.options.groupOrderSwap(h,l,e),e.update(h),e.update(l));var d=e.getIds({order:this.options.groupOrder});if(!za.equalArray(d,this.groupTouchParams.originalOrder))for(var u=this.groupTouchParams.originalOrder,c=this.groupTouchParams.group.groupId,p=Math.min(u.length,d.length),m=0,f=0,g=0;m<p;){for(;m+f<p&&m+g<p&&d[m+f]==u[m+g];)m++;if(m+f>=p)break;if(d[m+f]==c)f=1;else if(u[m+g]==c)g=1;else{var v=Fo(d).call(d,u[m+g]),b=e.get(d[m+f]),y=e.get(u[m+g]);this.options.groupOrderSwap(b,y,e),e.update(b),e.update(y);var x=d[m+f];d[m+f]=u[m+g],d[v]=x,m++}}}}}},{key:"_onGroupDragEnd",value:function(t){if(this.groupTouchParams.isDragging=!1,this.options.groupEditable.order&&this.groupTouchParams.group){t.stopPropagation();var e=this,i=e.groupTouchParams.group.groupId,n=e.groupsData.getDataSet(),o=za.extend({},n.get(i));e.options.onMoveGroup(o,(function(t){if(t)t[n._idProp]=i,n.update(t);else{var o=n.getIds({order:e.options.groupOrder});if(!za.equalArray(o,e.groupTouchParams.originalOrder))for(var s=e.groupTouchParams.originalOrder,r=Math.min(s.length,o.length),a=0;a<r;){for(;a<r&&o[a]==s[a];)a++;if(a>=r)break;var l=Fo(o).call(o,s[a]),h=n.get(o[a]),d=n.get(s[a]);e.options.groupOrderSwap(h,d,n),n.update(h),n.update(d);var u=o[a];o[a]=s[a],o[l]=u,a++}}})),e.body.emitter.emit("groupDragged",{groupId:i}),this.toggleGroupDragClassName(this.groupTouchParams.group),this.groupTouchParams.group=null}}},{key:"_onSelectItem",value:function(t){if(this.options.selectable){var e=t.srcEvent&&(t.srcEvent.ctrlKey||t.srcEvent.metaKey),i=t.srcEvent&&t.srcEvent.shiftKey;if(e||i)this._onMultiSelectItem(t);else{var n=this.getSelection(),o=this.itemFromTarget(t),s=o&&o.selectable?[o.id]:[];this.setSelection(s);var r=this.getSelection();(r.length>0||n.length>0)&&this.body.emitter.emit("select",{items:r,event:t})}}}},{key:"_onMouseOver",value:function(t){var e=this.itemFromTarget(t);if(e&&e!==this.itemFromRelatedTarget(t)){var i=e.getTitle();if(this.options.showTooltips&&i){null==this.popup&&(this.popup=new tu(this.body.dom.root,this.options.tooltip.overflowMethod||"flip")),this.popup.setText(i);var n=this.body.dom.centerContainer,o=n.getBoundingClientRect();this.popup.setPosition(t.clientX-o.left+n.offsetLeft,t.clientY-o.top+n.offsetTop),this.setPopupTimer(this.popup)}else this.clearPopupTimer(),null!=this.popup&&this.popup.hide();this.body.emitter.emit("itemover",{item:e.id,event:t})}}},{key:"_onMouseOut",value:function(t){var e=this.itemFromTarget(t);e&&(e!==this.itemFromRelatedTarget(t)&&(this.clearPopupTimer(),null!=this.popup&&this.popup.hide(),this.body.emitter.emit("itemout",{item:e.id,event:t})))}},{key:"_onMouseMove",value:function(t){if(this.itemFromTarget(t)&&(null!=this.popupTimer&&this.setPopupTimer(this.popup),this.options.showTooltips&&this.options.tooltip.followMouse&&this.popup&&!this.popup.hidden)){var e=this.body.dom.centerContainer,i=e.getBoundingClientRect();this.popup.setPosition(t.clientX-i.left+e.offsetLeft,t.clientY-i.top+e.offsetTop),this.popup.show()}}},{key:"_onMouseWheel",value:function(t){this.touchParams.itemIsDragging&&this._onDragEnd(t)}},{key:"_onUpdateItem",value:function(t){if(this.options.selectable&&(this.options.editable.updateTime||this.options.editable.updateGroup)){var e=this;if(t){var i=e.itemsData.get(t.id);this.options.onUpdate(i,(function(t){t&&e.itemsData.update(t)}))}}}},{key:"_onDropObjectOnItem",value:function(t){var e=this.itemFromTarget(t),i=JSON.parse(t.dataTransfer.getData("text"));this.options.onDropObjectOnItem(i,e)}},{key:"_onAddItem",value:function(t){if(this.options.selectable&&this.options.editable.add){var e,i,n=this,o=this.options.snap||null,s=this.dom.frame.getBoundingClientRect(),r=this.options.rtl?s.right-t.center.x:t.center.x-s.left,a=this.body.util.toTime(r),l=this.body.util.getScale(),h=this.body.util.getStep();"drop"==t.type?((i=JSON.parse(t.dataTransfer.getData("text"))).content=i.content?i.content:"new item",i.start=i.start?i.start:o?o(a,l,h):a,i.type=i.type||"box",i[this.itemsData.idProp]=i.id||Id(),"range"!=i.type||i.end||(e=this.body.util.toTime(r+this.props.width/5),i.end=o?o(e,l,h):e)):((i={start:o?o(a,l,h):a,content:"new item"})[this.itemsData.idProp]=Id(),"range"===this.options.type&&(e=this.body.util.toTime(r+this.props.width/5),i.end=o?o(e,l,h):e));var d=this.groupFromTarget(t);d&&(i.group=d.groupId),i=this._cloneItemData(i),this.options.onAdd(i,(function(e){e&&(n.itemsData.add(e),"drop"==t.type&&n.setSelection([e.id]))}))}}},{key:"_onMultiSelectItem",value:function(t){var i=this;if(this.options.selectable){var n=this.itemFromTarget(t);if(n){var o=this.options.multiselect?this.getSelection():[];if((t.srcEvent&&t.srcEvent.shiftKey||!1||this.options.sequentialSelection)&&this.options.multiselect){var s=this.itemsData.get(n.id).group,r=void 0;this.options.multiselectPerGroup&&o.length>0&&(r=this.itemsData.get(o[0]).group),this.options.multiselectPerGroup&&null!=r&&r!=s||o.push(n.id);var a=e._getItemRange(this.itemsData.get(o));if(!this.options.multiselectPerGroup||r==s)for(var l in o=[],this.items)if(this.items.hasOwnProperty(l)){var h=this.items[l],d=h.data.start,u=void 0!==h.data.end?h.data.end:d;!(d>=a.min&&u<=a.max)||this.options.multiselectPerGroup&&r!=this.itemsData.get(h.id).group||h instanceof $d||o.push(h.id)}}else{var c=Fo(o).call(o,n.id);-1==c?o.push(n.id):Hr(o).call(o,c,1)}var p=En(o).call(o,(function(t){return i.getItemById(t).selectable}));this.setSelection(p),this.body.emitter.emit("select",{items:this.getSelection(),event:t})}}}},{key:"itemFromElement",value:function(t){for(var e=t;e;){if(e.hasOwnProperty("vis-item"))return e["vis-item"];e=e.parentNode}return null}},{key:"itemFromTarget",value:function(t){return this.itemFromElement(t.target)}},{key:"itemFromRelatedTarget",value:function(t){return this.itemFromElement(t.relatedTarget)}},{key:"groupFromTarget",value:function(t){var e=t.center?t.center.y:t.clientY,i=this.groupIds;i.length<=0&&this.groupsData&&(i=this.groupsData.getIds({order:this.options.groupOrder}));for(var n=0;n<i.length;n++){var o=i[n],s=this.groups[o],r=s.dom.foreground,a=r.getBoundingClientRect();if(e>=a.top&&e<a.top+r.offsetHeight)return s;if("top"===this.options.orientation.item){if(n===this.groupIds.length-1&&e>a.top)return s}else if(0===n&&e<a.top+r.offset)return s}return null}},{key:"_cloneItemData",value:function(t,e){var i=za.extend({},t);return e||(e=this.itemsData.type),null!=i.start&&(i.start=za.convert(i.start,e&&e.start||"Date")),null!=i.end&&(i.end=za.convert(i.end,e&&e.end||"Date")),i}},{key:"_clusterItems",value:function(){if(this.options.cluster){var t=this.body.range.conversion(this.body.domProps.center.width).scale,e=this.clusterGenerator.getClusters(this.clusters,t,this.options.cluster);if(this.clusters!=e){if(this._detachAllClusters(),e){var i=!0,n=!1,o=void 0;try{for(var s,r=Fi(e);!(i=(s=r.next()).done);i=!0){s.value.attach()}}catch(t){n=!0,o=t}finally{try{i||null==r.return||r.return()}finally{if(n)throw o}}this.clusters=e}this._updateClusters(e)}}}},{key:"_detachAllClusters",value:function(){if(this.options.cluster&&this.clusters&&this.clusters.length){var t=!0,e=!1,i=void 0;try{for(var n,o=Fi(this.clusters);!(t=(n=o.next()).done);t=!0){n.value.detach()}}catch(t){e=!0,i=t}finally{try{t||null==o.return||o.return()}finally{if(e)throw i}}}}},{key:"_updateClusters",value:function(t){if(this.clusters&&this.clusters.length){var e,i=new Ar(Ln(t).call(t,(function(t){return t.id}))),n=En(e=this.clusters).call(e,(function(t){return!i.has(t.id)})),o=!1,s=!0,r=!1,a=void 0;try{for(var l,h=Fi(n);!(s=(l=h.next()).done);s=!0){var d,u,c=l.value,p=Fo(d=this.selection).call(d,c.id);if(-1!==p)c.unselect(),Hr(u=this.selection).call(u,p,1),o=!0}}catch(t){r=!0,a=t}finally{try{s||null==h.return||h.return()}finally{if(r)throw a}}if(o){var m=this.getSelection();this.body.emitter.emit("select",{items:m,event:event})}}this.clusters=t||[]}}],[{key:"_getItemRange",value:function(t){var e=null,i=null;return mn(t).call(t,(function(t){(null==i||t.start<i)&&(i=t.start),null!=t.end?(null==e||t.end>e)&&(e=t.end):(null==e||t.start>e)&&(e=t.start)})),{min:i,max:e}}},{key:"itemSetFromTarget",value:function(t){for(var e=t.target;e;){if(e.hasOwnProperty("vis-itemset"))return e["vis-itemset"];e=e.parentNode}return null}}]),e}(Ja);uu.types={background:$d,box:Jd,range:qd,point:Kd},uu.prototype._onAdd=uu.prototype._onUpdate;var cu,pu=!1,mu="background: #FFeeee; color: #dd0000",fu=function(){function t(){ba(this,t)}return xa(t,null,[{key:"validate",value:function(e,i,n){pu=!1,cu=i;var o=i;return void 0!==n&&(o=i[n]),t.parse(e,o,[]),pu}},{key:"parse",value:function(e,i,n){for(var o in e)e.hasOwnProperty(o)&&t.check(o,e,i,n)}},{key:"check",value:function(e,i,n,o){if(void 0!==n[e]||void 0!==n.__any__){var s=e,r=!0;void 0===n[e]&&void 0!==n.__any__&&(s="__any__",r="object"===t.getType(i[e]));var a=n[s];r&&void 0!==a.__type__&&(a=a.__type__),t.checkFields(e,i,n,s,a,o)}else t.getSuggestion(e,n,o)}},{key:"checkFields",value:function(e,i,n,o,s,r){var a=function(i){console.log("%c"+i+t.printLocation(r,e),mu)},l=t.getType(i[e]),h=s[l];void 0!==h?"array"===t.getType(h)&&-1===Fo(h).call(h,i[e])?(a('Invalid option detected in "'+e+'". Allowed values are:'+t.print(h)+' not "'+i[e]+'". '),pu=!0):"object"===l&&"__any__"!==o&&(r=za.copyAndExtendArray(r,e),t.parse(i[e],n[o],r)):void 0===s.any&&(a('Invalid type received for "'+e+'". Expected: '+t.print(Yi(s))+". Received ["+l+'] "'+i[e]+'"'),pu=!0)}},{key:"getType",value:function(t){var e=zo(t);return"object"===e?null===t?"null":t instanceof Boolean?"boolean":t instanceof Number?"number":t instanceof String?"string":Zo(t)?"array":t instanceof Date?"date":void 0!==t.nodeType?"dom":!0===t._isAMomentObject?"moment":"object":"number"===e?"number":"boolean"===e?"boolean":"string"===e?"string":void 0===e?"undefined":e}},{key:"getSuggestion",value:function(e,i,n){var o,s=t.findInOptions(e,i,n,!1),r=t.findInOptions(e,cu,[],!0);o=void 0!==s.indexMatch?" in "+t.printLocation(s.path,e,"")+'Perhaps it was incomplete? Did you mean: "'+s.indexMatch+'"?\n\n':r.distance<=4&&s.distance>r.distance?" in "+t.printLocation(s.path,e,"")+"Perhaps it was misplaced? Matching option found at: "+t.printLocation(r.path,r.closestMatch,""):s.distance<=8?'. Did you mean "'+s.closestMatch+'"?'+t.printLocation(s.path,e):". Did you mean one of these: "+t.print(Yi(i))+t.printLocation(n,e),console.log('%cUnknown option detected: "'+e+'"'+o,mu),pu=!0}},{key:"findInOptions",value:function(e,i,n){var o=arguments.length>3&&void 0!==arguments[3]&&arguments[3],s=1e9,r="",a=[],l=e.toLowerCase(),h=void 0;for(var d in i){var u=void 0;if(void 0!==i[d].__type__&&!0===o){var c=t.findInOptions(e,i[d],za.copyAndExtendArray(n,d));s>c.distance&&(r=c.closestMatch,a=c.path,s=c.distance,h=c.indexMatch)}else{var p;-1!==Fo(p=d.toLowerCase()).call(p,l)&&(h=d),s>(u=t.levenshteinDistance(e,d))&&(r=d,a=za.copyArray(n),s=u)}}return{closestMatch:r,path:a,distance:s,indexMatch:h}}},{key:"printLocation",value:function(t,e){for(var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"Problem value found at: \n",n="\n\n"+i+"options = {\n",o=0;o<t.length;o++){for(var s=0;s<o+1;s++)n+="  ";n+=t[o]+": {\n"}for(var r=0;r<t.length+1;r++)n+="  ";n+=e+"\n";for(var a=0;a<t.length+1;a++){for(var l=0;l<t.length-a;l++)n+="  ";n+="}\n"}return n+"\n\n"}},{key:"print",value:function(t){return Vs(t).replace(/(\")|(\[)|(\])|(,"__type__")/g,"").replace(/(\,)/g,", ")}},{key:"levenshteinDistance",value:function(t,e){if(0===t.length)return e.length;if(0===e.length)return t.length;var i,n,o=[];for(i=0;i<=e.length;i++)o[i]=[i];for(n=0;n<=t.length;n++)o[0][n]=n;for(i=1;i<=e.length;i++)for(n=1;n<=t.length;n++)e.charAt(i-1)==t.charAt(n-1)?o[i][n]=o[i-1][n-1]:o[i][n]=Math.min(o[i-1][n-1]+1,Math.min(o[i][n-1]+1,o[i-1][n]+1));return o[e.length][t.length]}}]),t}(),gu="string",vu="boolean",bu="number",yu="object",xu={configure:{enabled:{boolean:vu},filter:{boolean:vu,function:"function"},container:{dom:"dom"},__type__:{object:yu,boolean:vu,function:"function"}},align:{string:gu},alignCurrentTime:{string:gu,undefined:"undefined"},rtl:{boolean:vu,undefined:"undefined"},rollingMode:{follow:{boolean:vu},offset:{number:bu,undefined:"undefined"},__type__:{object:yu}},onTimeout:{timeoutMs:{number:bu},callback:{function:"function"},__type__:{object:yu}},verticalScroll:{boolean:vu,undefined:"undefined"},horizontalScroll:{boolean:vu,undefined:"undefined"},autoResize:{boolean:vu},throttleRedraw:{number:bu},clickToUse:{boolean:vu},dataAttributes:{string:gu,array:"array"},editable:{add:{boolean:vu,undefined:"undefined"},remove:{boolean:vu,undefined:"undefined"},updateGroup:{boolean:vu,undefined:"undefined"},updateTime:{boolean:vu,undefined:"undefined"},overrideItems:{boolean:vu,undefined:"undefined"},__type__:{boolean:vu,object:yu}},end:{number:bu,date:"date",string:gu,moment:"moment"},format:{minorLabels:{millisecond:{string:gu,undefined:"undefined"},second:{string:gu,undefined:"undefined"},minute:{string:gu,undefined:"undefined"},hour:{string:gu,undefined:"undefined"},weekday:{string:gu,undefined:"undefined"},day:{string:gu,undefined:"undefined"},week:{string:gu,undefined:"undefined"},month:{string:gu,undefined:"undefined"},year:{string:gu,undefined:"undefined"},__type__:{object:yu,function:"function"}},majorLabels:{millisecond:{string:gu,undefined:"undefined"},second:{string:gu,undefined:"undefined"},minute:{string:gu,undefined:"undefined"},hour:{string:gu,undefined:"undefined"},weekday:{string:gu,undefined:"undefined"},day:{string:gu,undefined:"undefined"},week:{string:gu,undefined:"undefined"},month:{string:gu,undefined:"undefined"},year:{string:gu,undefined:"undefined"},__type__:{object:yu,function:"function"}},__type__:{object:yu}},moment:{function:"function"},groupHeightMode:{string:gu},groupOrder:{string:gu,function:"function"},groupEditable:{add:{boolean:vu,undefined:"undefined"},remove:{boolean:vu,undefined:"undefined"},order:{boolean:vu,undefined:"undefined"},__type__:{boolean:vu,object:yu}},groupOrderSwap:{function:"function"},height:{string:gu,number:bu},hiddenDates:{start:{date:"date",number:bu,string:gu,moment:"moment"},end:{date:"date",number:bu,string:gu,moment:"moment"},repeat:{string:gu},__type__:{object:yu,array:"array"}},itemsAlwaysDraggable:{item:{boolean:vu,undefined:"undefined"},range:{boolean:vu,undefined:"undefined"},__type__:{boolean:vu,object:yu}},limitSize:{boolean:vu},locale:{string:gu},locales:{__any__:{any:"any"},__type__:{object:yu}},longSelectPressTime:{number:bu},margin:{axis:{number:bu},item:{horizontal:{number:bu,undefined:"undefined"},vertical:{number:bu,undefined:"undefined"},__type__:{object:yu,number:bu}},__type__:{object:yu,number:bu}},max:{date:"date",number:bu,string:gu,moment:"moment"},maxHeight:{number:bu,string:gu},maxMinorChars:{number:bu},min:{date:"date",number:bu,string:gu,moment:"moment"},minHeight:{number:bu,string:gu},moveable:{boolean:vu},multiselect:{boolean:vu},multiselectPerGroup:{boolean:vu},onAdd:{function:"function"},onDropObjectOnItem:{function:"function"},onUpdate:{function:"function"},onMove:{function:"function"},onMoving:{function:"function"},onRemove:{function:"function"},onAddGroup:{function:"function"},onMoveGroup:{function:"function"},onRemoveGroup:{function:"function"},onInitialDrawComplete:{function:"function"},order:{function:"function"},orientation:{axis:{string:gu,undefined:"undefined"},item:{string:gu,undefined:"undefined"},__type__:{string:gu,object:yu}},selectable:{boolean:vu},sequentialSelection:{boolean:vu},showCurrentTime:{boolean:vu},showMajorLabels:{boolean:vu},showMinorLabels:{boolean:vu},showWeekScale:{boolean:vu},stack:{boolean:vu},stackSubgroups:{boolean:vu},cluster:{maxItems:{number:bu,undefined:"undefined"},titleTemplate:{string:gu,undefined:"undefined"},clusterCriteria:{function:"function",undefined:"undefined"},showStipes:{boolean:vu,undefined:"undefined"},fitOnDoubleClick:{boolean:vu,undefined:"undefined"},__type__:{boolean:vu,object:yu}},snap:{function:"function",null:"null"},start:{date:"date",number:bu,string:gu,moment:"moment"},template:{function:"function"},loadingScreenTemplate:{function:"function"},groupTemplate:{function:"function"},visibleFrameTemplate:{string:gu,function:"function"},showTooltips:{boolean:vu},tooltip:{followMouse:{boolean:vu},overflowMethod:{string:["cap","flip","none"]},delay:{number:bu},template:{function:"function"},__type__:{object:yu}},tooltipOnItemUpdateTime:{template:{function:"function"},__type__:{boolean:vu,object:yu}},timeAxis:{scale:{string:gu,undefined:"undefined"},step:{number:bu,undefined:"undefined"},__type__:{object:yu}},type:{string:gu},width:{string:gu,number:bu},preferZoom:{boolean:vu},zoomable:{boolean:vu},zoomKey:{string:["ctrlKey","altKey","shiftKey","metaKey",""]},zoomFriction:{number:bu},zoomMax:{number:bu},zoomMin:{number:bu},__type__:{object:yu}},wu={global:{align:["center","left","right"],alignCurrentTime:["none","year","month","quarter","week","isoWeek","day","date","hour","minute","second"],direction:!1,autoResize:!0,clickToUse:!1,editable:{add:!1,remove:!1,updateGroup:!1,updateTime:!1},end:"",format:{minorLabels:{millisecond:"SSS",second:"s",minute:"HH:mm",hour:"HH:mm",weekday:"ddd D",day:"D",week:"w",month:"MMM",year:"YYYY"},majorLabels:{millisecond:"HH:mm:ss",second:"D MMMM HH:mm",minute:"ddd D MMMM",hour:"ddd D MMMM",weekday:"MMMM YYYY",day:"MMMM YYYY",week:"MMMM YYYY",month:"YYYY",year:""}},groupHeightMode:["auto","fixed","fitItems"],groupsDraggable:!1,height:"",locale:"",longSelectPressTime:251,margin:{axis:[20,0,100,1],item:{horizontal:[10,0,100,1],vertical:[10,0,100,1]}},max:"",maxHeight:"",maxMinorChars:[7,0,20,1],min:"",minHeight:"",moveable:!1,multiselect:!1,multiselectPerGroup:!1,orientation:{axis:["both","bottom","top"],item:["bottom","top"]},preferZoom:!1,selectable:!0,showCurrentTime:!1,showMajorLabels:!0,showMinorLabels:!0,stack:!0,stackSubgroups:!0,cluster:!1,start:"",showTooltips:!0,tooltip:{followMouse:!1,overflowMethod:"flip",delay:[500,0,99999,100]},tooltipOnItemUpdateTime:!1,type:["box","point","range","background"],width:"100%",zoomable:!0,zoomKey:["ctrlKey","altKey","shiftKey","metaKey",""],zoomMax:[31536e10,10,31536e10,1],zoomMin:[10,10,31536e10,1]}};V({target:"Array",proto:!0},{fill:function(t){for(var e=Lt(this),i=$(e.length),n=arguments.length,o=it(n>1?arguments[1]:void 0,i),s=n>2?arguments[2]:void 0,r=void 0===s?i:it(s,i);r>o;)e[o++]=t;return e}});var _u=Pi("Array").fill,ku=Array.prototype,Du=function(t){var e=t.fill;return t===ku||t instanceof Array&&e===ku.fill?_u:e},Iu={black:"#000000",navy:"#000080",darkblue:"#00008B",mediumblue:"#0000CD",blue:"#0000FF",darkgreen:"#006400",green:"#008000",teal:"#008080",darkcyan:"#008B8B",deepskyblue:"#00BFFF",darkturquoise:"#00CED1",mediumspringgreen:"#00FA9A",lime:"#00FF00",springgreen:"#00FF7F",aqua:"#00FFFF",cyan:"#00FFFF",midnightblue:"#191970",dodgerblue:"#1E90FF",lightseagreen:"#20B2AA",forestgreen:"#228B22",seagreen:"#2E8B57",darkslategray:"#2F4F4F",limegreen:"#32CD32",mediumseagreen:"#3CB371",turquoise:"#40E0D0",royalblue:"#4169E1",steelblue:"#4682B4",darkslateblue:"#483D8B",mediumturquoise:"#48D1CC",indigo:"#4B0082",darkolivegreen:"#556B2F",cadetblue:"#5F9EA0",cornflowerblue:"#6495ED",mediumaquamarine:"#66CDAA",dimgray:"#696969",slateblue:"#6A5ACD",olivedrab:"#6B8E23",slategray:"#708090",lightslategray:"#778899",mediumslateblue:"#7B68EE",lawngreen:"#7CFC00",chartreuse:"#7FFF00",aquamarine:"#7FFFD4",maroon:"#800000",purple:"#800080",olive:"#808000",gray:"#808080",skyblue:"#87CEEB",lightskyblue:"#87CEFA",blueviolet:"#8A2BE2",darkred:"#8B0000",darkmagenta:"#8B008B",saddlebrown:"#8B4513",darkseagreen:"#8FBC8F",lightgreen:"#90EE90",mediumpurple:"#9370D8",darkviolet:"#9400D3",palegreen:"#98FB98",darkorchid:"#9932CC",yellowgreen:"#9ACD32",sienna:"#A0522D",brown:"#A52A2A",darkgray:"#A9A9A9",lightblue:"#ADD8E6",greenyellow:"#ADFF2F",paleturquoise:"#AFEEEE",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",firebrick:"#B22222",darkgoldenrod:"#B8860B",mediumorchid:"#BA55D3",rosybrown:"#BC8F8F",darkkhaki:"#BDB76B",silver:"#C0C0C0",mediumvioletred:"#C71585",indianred:"#CD5C5C",peru:"#CD853F",chocolate:"#D2691E",tan:"#D2B48C",lightgrey:"#D3D3D3",palevioletred:"#D87093",thistle:"#D8BFD8",orchid:"#DA70D6",goldenrod:"#DAA520",crimson:"#DC143C",gainsboro:"#DCDCDC",plum:"#DDA0DD",burlywood:"#DEB887",lightcyan:"#E0FFFF",lavender:"#E6E6FA",darksalmon:"#E9967A",violet:"#EE82EE",palegoldenrod:"#EEE8AA",lightcoral:"#F08080",khaki:"#F0E68C",aliceblue:"#F0F8FF",honeydew:"#F0FFF0",azure:"#F0FFFF",sandybrown:"#F4A460",wheat:"#F5DEB3",beige:"#F5F5DC",whitesmoke:"#F5F5F5",mintcream:"#F5FFFA",ghostwhite:"#F8F8FF",salmon:"#FA8072",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lightgoldenrodyellow:"#FAFAD2",oldlace:"#FDF5E6",red:"#FF0000",fuchsia:"#FF00FF",magenta:"#FF00FF",deeppink:"#FF1493",orangered:"#FF4500",tomato:"#FF6347",hotpink:"#FF69B4",coral:"#FF7F50",darkorange:"#FF8C00",lightsalmon:"#FFA07A",orange:"#FFA500",lightpink:"#FFB6C1",pink:"#FFC0CB",gold:"#FFD700",peachpuff:"#FFDAB9",navajowhite:"#FFDEAD",moccasin:"#FFE4B5",bisque:"#FFE4C4",mistyrose:"#FFE4E1",blanchedalmond:"#FFEBCD",papayawhip:"#FFEFD5",lavenderblush:"#FFF0F5",seashell:"#FFF5EE",cornsilk:"#FFF8DC",lemonchiffon:"#FFFACD",floralwhite:"#FFFAF0",snow:"#FFFAFA",yellow:"#FFFF00",lightyellow:"#FFFFE0",ivory:"#FFFFF0",white:"#FFFFFF"},Cu=function(){function t(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;ba(this,t),this.pixelRatio=e,this.generated=!1,this.centerCoordinates={x:144.5,y:144.5},this.r=289*.49,this.color={r:255,g:255,b:255,a:1},this.hueCircle=void 0,this.initialColor={r:255,g:255,b:255,a:1},this.previousColor=void 0,this.applied=!1,this.updateCallback=function(){},this.closeCallback=function(){},this._create()}return xa(t,[{key:"insertTo",value:function(t){void 0!==this.hammer&&(this.hammer.destroy(),this.hammer=void 0),this.container=t,this.container.appendChild(this.frame),this._bindHammer(),this._setSize()}},{key:"setUpdateCallback",value:function(t){if("function"!=typeof t)throw new Error("Function attempted to set as colorPicker update callback is not a function.");this.updateCallback=t}},{key:"setCloseCallback",value:function(t){if("function"!=typeof t)throw new Error("Function attempted to set as colorPicker closing callback is not a function.");this.closeCallback=t}},{key:"_isColorString",value:function(t){if("string"==typeof t)return Iu[t]}},{key:"setColor",value:function(t){var e=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if("none"!==t){var i,n=this._isColorString(t);if(void 0!==n&&(t=n),!0===za.isString(t)){if(!0===za.isValidRGB(t)){var o=t.substr(4).substr(0,t.length-5).split(",");i={r:o[0],g:o[1],b:o[2],a:1}}else if(!0===za.isValidRGBA(t)){var s=t.substr(5).substr(0,t.length-6).split(",");i={r:s[0],g:s[1],b:s[2],a:s[3]}}else if(!0===za.isValidHex(t)){var r=za.hexToRGB(t);i={r:r.r,g:r.g,b:r.b,a:1}}}else if(t instanceof Object&&void 0!==t.r&&void 0!==t.g&&void 0!==t.b){var a=void 0!==t.a?t.a:"1.0";i={r:t.r,g:t.g,b:t.b,a:a}}if(void 0===i)throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: "+Vs(t));this._setColor(i,e)}}},{key:"show",value:function(){void 0!==this.closeCallback&&(this.closeCallback(),this.closeCallback=void 0),this.applied=!1,this.frame.style.display="block",this._generateHueCircle()}},{key:"_hide",value:function(){var t=this,e=!(arguments.length>0&&void 0!==arguments[0])||arguments[0];!0===e&&(this.previousColor=za.extend({},this.color)),!0===this.applied&&this.updateCallback(this.initialColor),this.frame.style.display="none",qr((function(){void 0!==t.closeCallback&&(t.closeCallback(),t.closeCallback=void 0)}),0)}},{key:"_save",value:function(){this.updateCallback(this.color),this.applied=!1,this._hide()}},{key:"_apply",value:function(){this.applied=!0,this.updateCallback(this.color),this._updatePicker(this.color)}},{key:"_loadLast",value:function(){void 0!==this.previousColor?this.setColor(this.previousColor,!1):alert("There is no last color to load...")}},{key:"_setColor",value:function(t){var e=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];!0===e&&(this.initialColor=za.extend({},t)),this.color=t;var i=za.RGBToHSV(t.r,t.g,t.b),n=2*Math.PI,o=this.r*i.s,s=this.centerCoordinates.x+o*Math.sin(n*i.h),r=this.centerCoordinates.y+o*Math.cos(n*i.h);this.colorPickerSelector.style.left=s-.5*this.colorPickerSelector.clientWidth+"px",this.colorPickerSelector.style.top=r-.5*this.colorPickerSelector.clientHeight+"px",this._updatePicker(t)}},{key:"_setOpacity",value:function(t){this.color.a=t/100,this._updatePicker(this.color)}},{key:"_setBrightness",value:function(t){var e=za.RGBToHSV(this.color.r,this.color.g,this.color.b);e.v=t/100;var i=za.HSVToRGB(e.h,e.s,e.v);i.a=this.color.a,this.color=i,this._updatePicker()}},{key:"_updatePicker",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.color,e=za.RGBToHSV(t.r,t.g,t.b),i=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(i.webkitBackingStorePixelRatio||i.mozBackingStorePixelRatio||i.msBackingStorePixelRatio||i.oBackingStorePixelRatio||i.backingStorePixelRatio||1)),i.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);var n=this.colorPickerCanvas.clientWidth,o=this.colorPickerCanvas.clientHeight;i.clearRect(0,0,n,o),i.putImageData(this.hueCircle,0,0),i.fillStyle="rgba(0,0,0,"+(1-e.v)+")",i.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),Du(i).call(i),this.brightnessRange.value=100*e.v,this.opacityRange.value=100*t.a,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}},{key:"_setSize",value:function(){this.colorPickerCanvas.style.width="100%",this.colorPickerCanvas.style.height="100%",this.colorPickerCanvas.width=289*this.pixelRatio,this.colorPickerCanvas.height=289*this.pixelRatio}},{key:"_create",value:function(){var t,e,i,n;if(this.frame=document.createElement("div"),this.frame.className="vis-color-picker",this.colorPickerDiv=document.createElement("div"),this.colorPickerSelector=document.createElement("div"),this.colorPickerSelector.className="vis-selector",this.colorPickerDiv.appendChild(this.colorPickerSelector),this.colorPickerCanvas=document.createElement("canvas"),this.colorPickerDiv.appendChild(this.colorPickerCanvas),this.colorPickerCanvas.getContext){var o=this.colorPickerCanvas.getContext("2d");this.pixelRatio=(window.devicePixelRatio||1)/(o.webkitBackingStorePixelRatio||o.mozBackingStorePixelRatio||o.msBackingStorePixelRatio||o.oBackingStorePixelRatio||o.backingStorePixelRatio||1),this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0)}else{var s=document.createElement("DIV");s.style.color="red",s.style.fontWeight="bold",s.style.padding="10px",s.innerHTML="Error: your browser does not support HTML canvas",this.colorPickerCanvas.appendChild(s)}this.colorPickerDiv.className="vis-color",this.opacityDiv=document.createElement("div"),this.opacityDiv.className="vis-opacity",this.brightnessDiv=document.createElement("div"),this.brightnessDiv.className="vis-brightness",this.arrowDiv=document.createElement("div"),this.arrowDiv.className="vis-arrow",this.opacityRange=document.createElement("input");try{this.opacityRange.type="range",this.opacityRange.min="0",this.opacityRange.max="100"}catch(t){}this.opacityRange.value="100",this.opacityRange.className="vis-range",this.brightnessRange=document.createElement("input");try{this.brightnessRange.type="range",this.brightnessRange.min="0",this.brightnessRange.max="100"}catch(t){}this.brightnessRange.value="100",this.brightnessRange.className="vis-range",this.opacityDiv.appendChild(this.opacityRange),this.brightnessDiv.appendChild(this.brightnessRange);var r=this;this.opacityRange.onchange=function(){r._setOpacity(this.value)},this.opacityRange.oninput=function(){r._setOpacity(this.value)},this.brightnessRange.onchange=function(){r._setBrightness(this.value)},this.brightnessRange.oninput=function(){r._setBrightness(this.value)},this.brightnessLabel=document.createElement("div"),this.brightnessLabel.className="vis-label vis-brightness",this.brightnessLabel.innerHTML="brightness:",this.opacityLabel=document.createElement("div"),this.opacityLabel.className="vis-label vis-opacity",this.opacityLabel.innerHTML="opacity:",this.newColorDiv=document.createElement("div"),this.newColorDiv.className="vis-new-color",this.newColorDiv.innerHTML="new",this.initialColorDiv=document.createElement("div"),this.initialColorDiv.className="vis-initial-color",this.initialColorDiv.innerHTML="initial",this.cancelButton=document.createElement("div"),this.cancelButton.className="vis-button vis-cancel",this.cancelButton.innerHTML="cancel",this.cancelButton.onclick=va(t=this._hide).call(t,this,!1),this.applyButton=document.createElement("div"),this.applyButton.className="vis-button vis-apply",this.applyButton.innerHTML="apply",this.applyButton.onclick=va(e=this._apply).call(e,this),this.saveButton=document.createElement("div"),this.saveButton.className="vis-button vis-save",this.saveButton.innerHTML="save",this.saveButton.onclick=va(i=this._save).call(i,this),this.loadButton=document.createElement("div"),this.loadButton.className="vis-button vis-load",this.loadButton.innerHTML="load last",this.loadButton.onclick=va(n=this._loadLast).call(n,this),this.frame.appendChild(this.colorPickerDiv),this.frame.appendChild(this.arrowDiv),this.frame.appendChild(this.brightnessLabel),this.frame.appendChild(this.brightnessDiv),this.frame.appendChild(this.opacityLabel),this.frame.appendChild(this.opacityDiv),this.frame.appendChild(this.newColorDiv),this.frame.appendChild(this.initialColorDiv),this.frame.appendChild(this.cancelButton),this.frame.appendChild(this.applyButton),this.frame.appendChild(this.saveButton),this.frame.appendChild(this.loadButton)}},{key:"_bindHammer",value:function(){var t=this;this.drag={},this.pinch={},this.hammer=new Vh(this.colorPickerCanvas),this.hammer.get("pinch").set({enable:!0}),jh(this.hammer,(function(e){t._moveSelector(e)})),this.hammer.on("tap",(function(e){t._moveSelector(e)})),this.hammer.on("panstart",(function(e){t._moveSelector(e)})),this.hammer.on("panmove",(function(e){t._moveSelector(e)})),this.hammer.on("panend",(function(e){t._moveSelector(e)}))}},{key:"_generateHueCircle",value:function(){if(!1===this.generated){var t=this.colorPickerCanvas.getContext("2d");void 0===this.pixelRation&&(this.pixelRatio=(window.devicePixelRatio||1)/(t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1)),t.setTransform(this.pixelRatio,0,0,this.pixelRatio,0,0);var e,i,n,o,s=this.colorPickerCanvas.clientWidth,r=this.colorPickerCanvas.clientHeight;t.clearRect(0,0,s,r),this.centerCoordinates={x:.5*s,y:.5*r},this.r=.49*s;var a,l=2*Math.PI/360,h=1/this.r;for(n=0;n<360;n++)for(o=0;o<this.r;o++)e=this.centerCoordinates.x+o*Math.sin(l*n),i=this.centerCoordinates.y+o*Math.cos(l*n),a=za.HSVToRGB(n*(1/360),o*h,1),t.fillStyle="rgb("+a.r+","+a.g+","+a.b+")",t.fillRect(e-.5,i-.5,2,2);t.strokeStyle="rgba(0,0,0,1)",t.circle(this.centerCoordinates.x,this.centerCoordinates.y,this.r),t.stroke(),this.hueCircle=t.getImageData(0,0,s,r)}this.generated=!0}},{key:"_moveSelector",value:function(t){var e=this.colorPickerDiv.getBoundingClientRect(),i=t.center.x-e.left,n=t.center.y-e.top,o=.5*this.colorPickerDiv.clientHeight,s=.5*this.colorPickerDiv.clientWidth,r=i-s,a=n-o,l=Math.atan2(r,a),h=.98*Math.min(Math.sqrt(r*r+a*a),s),d=Math.cos(l)*h+o,u=Math.sin(l)*h+s;this.colorPickerSelector.style.top=d-.5*this.colorPickerSelector.clientHeight+"px",this.colorPickerSelector.style.left=u-.5*this.colorPickerSelector.clientWidth+"px";var c=l/(2*Math.PI);c=c<0?c+1:c;var p=h/this.r,m=za.RGBToHSV(this.color.r,this.color.g,this.color.b);m.h=c,m.s=p;var f=za.HSVToRGB(m.h,m.s,m.v);f.a=this.color.a,this.color=f,this.initialColorDiv.style.backgroundColor="rgba("+this.initialColor.r+","+this.initialColor.g+","+this.initialColor.b+","+this.initialColor.a+")",this.newColorDiv.style.backgroundColor="rgba("+this.color.r+","+this.color.g+","+this.color.b+","+this.color.a+")"}}]),t}();Ph('div.vis-configuration{position:relative;display:block;float:left;font-size:12px}div.vis-configuration-wrapper{display:block;width:700px}div.vis-configuration-wrapper:after{clear:both;content:"";display:block}div.vis-configuration.vis-config-option-container{display:block;width:495px;background-color:#fff;border:2px solid #f7f8fa;border-radius:4px;margin-top:20px;left:10px;padding-left:5px}div.vis-configuration.vis-config-button{display:block;width:495px;height:25px;vertical-align:middle;line-height:25px;background-color:#f7f8fa;border:2px solid #ceced0;border-radius:4px;margin-top:20px;left:10px;padding-left:5px;cursor:pointer;margin-bottom:30px}div.vis-configuration.vis-config-button.hover{background-color:#4588e6;border:2px solid #214373;color:#fff}div.vis-configuration.vis-config-item{display:block;float:left;width:495px;height:25px;vertical-align:middle;line-height:25px}div.vis-configuration.vis-config-item.vis-config-s2{left:10px;background-color:#f7f8fa;padding-left:5px;border-radius:3px}div.vis-configuration.vis-config-item.vis-config-s3{left:20px;background-color:#e4e9f0;padding-left:5px;border-radius:3px}div.vis-configuration.vis-config-item.vis-config-s4{left:30px;background-color:#cfd8e6;padding-left:5px;border-radius:3px}div.vis-configuration.vis-config-header{font-size:18px;font-weight:700}div.vis-configuration.vis-config-label{width:120px;height:25px;line-height:25px}div.vis-configuration.vis-config-label.vis-config-s3{width:110px}div.vis-configuration.vis-config-label.vis-config-s4{width:100px}div.vis-configuration.vis-config-colorBlock{top:1px;width:30px;height:19px;border:1px solid #444;border-radius:2px;padding:0;margin:0;cursor:pointer}input.vis-configuration.vis-config-checkbox{left:-5px}input.vis-configuration.vis-config-rangeinput{position:relative;top:-5px;width:60px;padding:1px;margin:0;pointer-events:none}input.vis-configuration.vis-config-range{-webkit-appearance:none;border:0 solid #fff;background-color:transparent;width:300px;height:20px}input.vis-configuration.vis-config-range::-webkit-slider-runnable-track{width:300px;height:5px;background:#dedede;background:-moz-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0,#dedede),color-stop(99%,#c8c8c8));background:-webkit-linear-gradient(top,#dedede,#c8c8c8 99%);background:-o-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:-ms-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:linear-gradient(180deg,#dedede 0,#c8c8c8 99%);filter:progid:DXImageTransform.Microsoft.gradient(startColorstr="#dedede",endColorstr="#c8c8c8",GradientType=0);border:1px solid #999;box-shadow:0 0 3px 0 #aaa;border-radius:3px}input.vis-configuration.vis-config-range::-webkit-slider-thumb{-webkit-appearance:none;border:1px solid #14334b;height:17px;width:17px;border-radius:50%;background:#3876c2;background:-moz-linear-gradient(top,#3876c2 0,#385380 100%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0,#3876c2),color-stop(100%,#385380));background:-webkit-linear-gradient(top,#3876c2,#385380);background:-o-linear-gradient(top,#3876c2 0,#385380 100%);background:-ms-linear-gradient(top,#3876c2 0,#385380 100%);background:linear-gradient(180deg,#3876c2 0,#385380);filter:progid:DXImageTransform.Microsoft.gradient(startColorstr="#3876c2",endColorstr="#385380",GradientType=0);box-shadow:0 0 1px 0 #111927;margin-top:-7px}input.vis-configuration.vis-config-range:focus{outline:none}input.vis-configuration.vis-config-range:focus::-webkit-slider-runnable-track{background:#9d9d9d;background:-moz-linear-gradient(top,#9d9d9d 0,#c8c8c8 99%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0,#9d9d9d),color-stop(99%,#c8c8c8));background:-webkit-linear-gradient(top,#9d9d9d,#c8c8c8 99%);background:-o-linear-gradient(top,#9d9d9d 0,#c8c8c8 99%);background:-ms-linear-gradient(top,#9d9d9d 0,#c8c8c8 99%);background:linear-gradient(180deg,#9d9d9d 0,#c8c8c8 99%);filter:progid:DXImageTransform.Microsoft.gradient(startColorstr="#9d9d9d",endColorstr="#c8c8c8",GradientType=0)}input.vis-configuration.vis-config-range::-moz-range-track{width:300px;height:10px;background:#dedede;background:-moz-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:-webkit-gradient(linear,left top,left bottom,color-stop(0,#dedede),color-stop(99%,#c8c8c8));background:-webkit-linear-gradient(top,#dedede,#c8c8c8 99%);background:-o-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:-ms-linear-gradient(top,#dedede 0,#c8c8c8 99%);background:linear-gradient(180deg,#dedede 0,#c8c8c8 99%);filter:progid:DXImageTransform.Microsoft.gradient(startColorstr="#dedede",endColorstr="#c8c8c8",GradientType=0);border:1px solid #999;box-shadow:0 0 3px 0 #aaa;border-radius:3px}input.vis-configuration.vis-config-range::-moz-range-thumb{border:none;height:16px;width:16px;border-radius:50%;background:#385380}input.vis-configuration.vis-config-range:-moz-focusring{outline:1px solid #fff;outline-offset:-1px}input.vis-configuration.vis-config-range::-ms-track{width:300px;height:5px;background:transparent;border-color:transparent;border-width:6px 0;color:transparent}input.vis-configuration.vis-config-range::-ms-fill-lower{background:#777;border-radius:10px}input.vis-configuration.vis-config-range::-ms-fill-upper{background:#ddd;border-radius:10px}input.vis-configuration.vis-config-range::-ms-thumb{border:none;height:16px;width:16px;border-radius:50%;background:#385380}input.vis-configuration.vis-config-range:focus::-ms-fill-lower{background:#888}input.vis-configuration.vis-config-range:focus::-ms-fill-upper{background:#ccc}.vis-configuration-popup{position:absolute;background:rgba(57,76,89,.85);border:2px solid #f2faff;line-height:30px;height:30px;width:150px;text-align:center;color:#fff;font-size:14px;border-radius:4px;-webkit-transition:opacity .3s ease-in-out;-moz-transition:opacity .3s ease-in-out;transition:opacity .3s ease-in-out}.vis-configuration-popup:after,.vis-configuration-popup:before{left:100%;top:50%;border:solid transparent;content:" ";height:0;width:0;position:absolute;pointer-events:none}.vis-configuration-popup:after{border-color:rgba(136,183,213,0) rgba(136,183,213,0) rgba(136,183,213,0) rgba(57,76,89,.85);border-width:8px;margin-top:-8px}.vis-configuration-popup:before{border-color:rgba(194,225,245,0) rgba(194,225,245,0) rgba(194,225,245,0) #f2faff;border-width:12px;margin-top:-12px}\n/*# sourceMappingURL=data:application/json;base64,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 */');var Lu=function(){function t(e,i,n){var o=arguments.length>3&&void 0!==arguments[3]?arguments[3]:1;ba(this,t),this.parent=e,this.changedOptions=[],this.container=i,this.allowCreation=!1,this.options={},this.initialized=!1,this.popupCounter=0,this.defaultOptions={enabled:!1,filter:!0,container:void 0,showButton:!0},za.extend(this.options,this.defaultOptions),this.configureOptions=n,this.moduleOptions={},this.domElements=[],this.popupDiv={},this.popupLimit=5,this.popupHistory={},this.colorPicker=new Cu(o),this.wrapper=void 0}return xa(t,[{key:"setOptions",value:function(t){if(void 0!==t){this.popupHistory={},this._removePopup();var e=!0;if("string"==typeof t)this.options.filter=t;else if(t instanceof Array)this.options.filter=t.join();else if("object"===zo(t)){if(null==t)throw new TypeError("options cannot be null");void 0!==t.container&&(this.options.container=t.container),void 0!==En(t)&&(this.options.filter=En(t)),void 0!==t.showButton&&(this.options.showButton=t.showButton),void 0!==t.enabled&&(e=t.enabled)}else"boolean"==typeof t?(this.options.filter=!0,e=t):"function"==typeof t&&(this.options.filter=t,e=!0);!1===En(this.options)&&(e=!1),this.options.enabled=e}this._clean()}},{key:"setModuleOptions",value:function(t){this.moduleOptions=t,!0===this.options.enabled&&(this._clean(),void 0!==this.options.container&&(this.container=this.options.container),this._create())}},{key:"_create",value:function(){this._clean(),this.changedOptions=[];var t=En(this.options),e=0,i=!1;for(var n in this.configureOptions)this.configureOptions.hasOwnProperty(n)&&(this.allowCreation=!1,i=!1,"function"==typeof t?i=(i=t(n,[]))||this._handleObject(this.configureOptions[n],[n],!0):!0!==t&&-1===Fo(t).call(t,n)||(i=!0),!1!==i&&(this.allowCreation=!0,e>0&&this._makeItem([]),this._makeHeader(n),this._handleObject(this.configureOptions[n],[n])),e++);this._makeButton(),this._push()}},{key:"_push",value:function(){this.wrapper=document.createElement("div"),this.wrapper.className="vis-configuration-wrapper",this.container.appendChild(this.wrapper);for(var t=0;t<this.domElements.length;t++)this.wrapper.appendChild(this.domElements[t]);this._showPopupIfNeeded()}},{key:"_clean",value:function(){for(var t=0;t<this.domElements.length;t++)this.wrapper.removeChild(this.domElements[t]);void 0!==this.wrapper&&(this.container.removeChild(this.wrapper),this.wrapper=void 0),this.domElements=[],this._removePopup()}},{key:"_getValue",value:function(t){for(var e=this.moduleOptions,i=0;i<t.length;i++){if(void 0===e[t[i]]){e=void 0;break}e=e[t[i]]}return e}},{key:"_makeItem",value:function(t){if(!0===this.allowCreation){var e=document.createElement("div");e.className="vis-configuration vis-config-item vis-config-s"+t.length;for(var i=arguments.length,n=new Array(i>1?i-1:0),o=1;o<i;o++)n[o-1]=arguments[o];return mn(n).call(n,(function(t){e.appendChild(t)})),this.domElements.push(e),this.domElements.length}return 0}},{key:"_makeHeader",value:function(t){var e=document.createElement("div");e.className="vis-configuration vis-config-header",e.innerHTML=t,this._makeItem([],e)}},{key:"_makeLabel",value:function(t,e){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=document.createElement("div");return n.className="vis-configuration vis-config-label vis-config-s"+e.length,n.innerHTML=!0===i?"<i><b>"+t+":</b></i>":t+":",n}},{key:"_makeDropdown",value:function(t,e,i){var n=document.createElement("select");n.className="vis-configuration vis-config-select";var o=0;void 0!==e&&-1!==Fo(t).call(t,e)&&(o=Fo(t).call(t,e));for(var s=0;s<t.length;s++){var r=document.createElement("option");r.value=t[s],s===o&&(r.selected="selected"),r.innerHTML=t[s],n.appendChild(r)}var a=this;n.onchange=function(){a._update(this.value,i)};var l=this._makeLabel(i[i.length-1],i);this._makeItem(i,l,n)}},{key:"_makeRange",value:function(t,e,i){var n=t[0],o=t[1],s=t[2],r=t[3],a=document.createElement("input");a.className="vis-configuration vis-config-range";try{a.type="range",a.min=o,a.max=s}catch(t){}a.step=r;var l="",h=0;if(void 0!==e){e<0&&1.2*e<o?(a.min=Math.ceil(1.2*e),h=a.min,l="range increased"):e/1.2<o&&(a.min=Math.ceil(e/1.2),h=a.min,l="range increased"),1.2*e>s&&1!==s&&(a.max=Math.ceil(1.2*e),h=a.max,l="range increased"),a.value=e}else a.value=n;var d=document.createElement("input");d.className="vis-configuration vis-config-rangeinput",d.value=Number(a.value);var u=this;a.onchange=function(){d.value=this.value,u._update(Number(this.value),i)},a.oninput=function(){d.value=this.value};var c=this._makeLabel(i[i.length-1],i),p=this._makeItem(i,c,a,d);""!==l&&this.popupHistory[p]!==h&&(this.popupHistory[p]=h,this._setupPopup(l,p))}},{key:"_makeButton",value:function(){var t=this;if(!0===this.options.showButton){var e=document.createElement("div");e.className="vis-configuration vis-config-button",e.innerHTML="generate options",e.onclick=function(){t._printOptions()},e.onmouseover=function(){e.className="vis-configuration vis-config-button hover"},e.onmouseout=function(){e.className="vis-configuration vis-config-button"},this.optionsContainer=document.createElement("div"),this.optionsContainer.className="vis-configuration vis-config-option-container",this.domElements.push(this.optionsContainer),this.domElements.push(e)}}},{key:"_setupPopup",value:function(t,e){var i=this;if(!0===this.initialized&&!0===this.allowCreation&&this.popupCounter<this.popupLimit){var n=document.createElement("div");n.id="vis-configuration-popup",n.className="vis-configuration-popup",n.innerHTML=t,n.onclick=function(){i._removePopup()},this.popupCounter+=1,this.popupDiv={html:n,index:e}}}},{key:"_removePopup",value:function(){void 0!==this.popupDiv.html&&(this.popupDiv.html.parentNode.removeChild(this.popupDiv.html),clearTimeout(this.popupDiv.hideTimeout),clearTimeout(this.popupDiv.deleteTimeout),this.popupDiv={})}},{key:"_showPopupIfNeeded",value:function(){var t=this;if(void 0!==this.popupDiv.html){var e=this.domElements[this.popupDiv.index].getBoundingClientRect();this.popupDiv.html.style.left=e.left+"px",this.popupDiv.html.style.top=e.top-30+"px",document.body.appendChild(this.popupDiv.html),this.popupDiv.hideTimeout=qr((function(){t.popupDiv.html.style.opacity=0}),1500),this.popupDiv.deleteTimeout=qr((function(){t._removePopup()}),1800)}}},{key:"_makeCheckbox",value:function(t,e,i){var n=document.createElement("input");n.type="checkbox",n.className="vis-configuration vis-config-checkbox",n.checked=t,void 0!==e&&(n.checked=e,e!==t&&("object"===zo(t)?e!==t.enabled&&this.changedOptions.push({path:i,value:e}):this.changedOptions.push({path:i,value:e})));var o=this;n.onchange=function(){o._update(this.checked,i)};var s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,n)}},{key:"_makeTextInput",value:function(t,e,i){var n=document.createElement("input");n.type="text",n.className="vis-configuration vis-config-text",n.value=e,e!==t&&this.changedOptions.push({path:i,value:e});var o=this;n.onchange=function(){o._update(this.value,i)};var s=this._makeLabel(i[i.length-1],i);this._makeItem(i,s,n)}},{key:"_makeColorField",value:function(t,e,i){var n=this,o=t[1],s=document.createElement("div");"none"!==(e=void 0===e?o:e)?(s.className="vis-configuration vis-config-colorBlock",s.style.backgroundColor=e):s.className="vis-configuration vis-config-colorBlock none",e=void 0===e?o:e,s.onclick=function(){n._showColorPicker(e,s,i)};var r=this._makeLabel(i[i.length-1],i);this._makeItem(i,r,s)}},{key:"_showColorPicker",value:function(t,e,i){var n=this;e.onclick=function(){},this.colorPicker.insertTo(e),this.colorPicker.show(),this.colorPicker.setColor(t),this.colorPicker.setUpdateCallback((function(t){var o="rgba("+t.r+","+t.g+","+t.b+","+t.a+")";e.style.backgroundColor=o,n._update(o,i)})),this.colorPicker.setCloseCallback((function(){e.onclick=function(){n._showColorPicker(t,e,i)}}))}},{key:"_handleObject",value:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],n=!1,o=En(this.options),s=!1;for(var r in t)if(t.hasOwnProperty(r)){n=!0;var a=t[r],l=za.copyAndExtendArray(e,r);if("function"==typeof o&&!1===(n=o(r,e))&&!(a instanceof Array)&&"string"!=typeof a&&"boolean"!=typeof a&&a instanceof Object&&(this.allowCreation=!1,n=this._handleObject(a,l,!0),this.allowCreation=!1===i),!1!==n){s=!0;var h=this._getValue(l);if(a instanceof Array)this._handleArray(a,h,l);else if("string"==typeof a)this._makeTextInput(a,h,l);else if("boolean"==typeof a)this._makeCheckbox(a,h,l);else if(a instanceof Object){var d=!0;if(-1!==Fo(e).call(e,"physics")&&this.moduleOptions.physics.solver!==r&&(d=!1),!0===d)if(void 0!==a.enabled){var u=za.copyAndExtendArray(l,"enabled"),c=this._getValue(u);if(!0===c){var p=this._makeLabel(r,l,!0);this._makeItem(l,p),s=this._handleObject(a,l)||s}else this._makeCheckbox(a,c,l)}else{var m=this._makeLabel(r,l,!0);this._makeItem(l,m),s=this._handleObject(a,l)||s}}else console.error("dont know how to handle",a,r,l)}}return s}},{key:"_handleArray",value:function(t,e,i){"string"==typeof t[0]&&"color"===t[0]?(this._makeColorField(t,e,i),t[1]!==e&&this.changedOptions.push({path:i,value:e})):"string"==typeof t[0]?(this._makeDropdown(t,e,i),t[0]!==e&&this.changedOptions.push({path:i,value:e})):"number"==typeof t[0]&&(this._makeRange(t,e,i),t[0]!==e&&this.changedOptions.push({path:i,value:Number(e)}))}},{key:"_update",value:function(t,e){var i=this._constructOptions(t,e);this.parent.body&&this.parent.body.emitter&&this.parent.body.emitter.emit&&this.parent.body.emitter.emit("configChange",i),this.initialized=!0,this.parent.setOptions(i)}},{key:"_constructOptions",value:function(t,e){var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},n=i;t="false"!==(t="true"===t||t)&&t;for(var o=0;o<e.length;o++)"global"!==e[o]&&(void 0===n[e[o]]&&(n[e[o]]={}),o!==e.length-1?n=n[e[o]]:n[e[o]]=t);return i}},{key:"_printOptions",value:function(){var t=this.getOptions();this.optionsContainer.innerHTML="<pre>var options = "+Vs(t,null,2)+"</pre>"}},{key:"getOptions",value:function(){for(var t={},e=0;e<this.changedOptions.length;e++)this._constructOptions(this.changedOptions[e].value,this.changedOptions[e].path,t);return t}}]),t}(),Gu=function(t){function e(t,i,n,o){var s,r,a,l,h,d,u,c;if(ba(this,e),(c=ar(this,dr(e).call(this))).initTime=new Date,c.itemsDone=!1,!(Bs(c)instanceof e))throw new SyntaxError("Constructor must be called with the new operator");if(!(Zo(n)||n instanceof Aa||n instanceof Xa)&&n instanceof Object){var p=o;o=n,n=p}o&&o.throttleRedraw&&console.warn('Timeline option "throttleRedraw" is DEPRICATED and no longer supported. It will be removed in the next MAJOR release.');var m=Bs(c);if(c.defaultOptions={autoResize:!0,longSelectPressTime:251,orientation:{axis:"bottom",item:"bottom"},moment:Ta},c.options=za.deepExtend({},c.defaultOptions),c._create(t),!o||o&&void 0===o.rtl){var f;c.dom.root.style.visibility="hidden";for(var g=c.dom.root;!f&&g;)f=window.getComputedStyle(g,null).direction,g=g.parentElement;c.options.rtl=f&&"rtl"==f.toLowerCase()}else c.options.rtl=o.rtl;o&&(o.rollingMode&&(c.options.rollingMode=o.rollingMode),o.onInitialDrawComplete&&(c.options.onInitialDrawComplete=o.onInitialDrawComplete),o.onTimeout&&(c.options.onTimeout=o.onTimeout),o.loadingScreenTemplate&&(c.options.loadingScreenTemplate=o.loadingScreenTemplate));var v=document.createElement("div");if(c.options.loadingScreenTemplate){var b,y=va(b=c.options.loadingScreenTemplate).call(b,Bs(c)),x=y(c.dom.loadingScreen);x instanceof Object&&!(x instanceof Element)?y(v):x instanceof Element?(v.innerHTML="",v.appendChild(x)):null!=x&&(v.innerHTML=x)}return c.dom.loadingScreen.appendChild(v),c.components=[],c.body={dom:c.dom,domProps:c.props,emitter:{on:va(s=c.on).call(s,Bs(c)),off:va(r=c.off).call(r,Bs(c)),emit:va(a=c.emit).call(a,Bs(c))},hiddenDates:[],util:{getScale:function(){return m.timeAxis.step.scale},getStep:function(){return m.timeAxis.step.step},toScreen:va(l=m._toScreen).call(l,m),toGlobalScreen:va(h=m._toGlobalScreen).call(h,m),toTime:va(d=m._toTime).call(d,m),toGlobalTime:va(u=m._toGlobalTime).call(u,m)}},c.range=new ml(c.body,c.options),c.components.push(c.range),c.body.range=c.range,c.timeAxis=new Jh(c.body,c.options),c.timeAxis2=null,c.components.push(c.timeAxis),c.currentTime=new pd(c.body,c.options),c.components.push(c.currentTime),c.itemSet=new uu(c.body,c.options),c.components.push(c.itemSet),c.itemsData=null,c.groupsData=null,c.dom.root.onclick=function(t){m.emit("click",m.getEventProperties(t))},c.dom.root.ondblclick=function(t){m.emit("doubleClick",m.getEventProperties(t))},c.dom.root.oncontextmenu=function(t){m.emit("contextmenu",m.getEventProperties(t))},c.dom.root.onmouseover=function(t){m.emit("mouseOver",m.getEventProperties(t))},window.PointerEvent?(c.dom.root.onpointerdown=function(t){m.emit("mouseDown",m.getEventProperties(t))},c.dom.root.onpointermove=function(t){m.emit("mouseMove",m.getEventProperties(t))},c.dom.root.onpointerup=function(t){m.emit("mouseUp",m.getEventProperties(t))}):(c.dom.root.onmousemove=function(t){m.emit("mouseMove",m.getEventProperties(t))},c.dom.root.onmousedown=function(t){m.emit("mouseDown",m.getEventProperties(t))},c.dom.root.onmouseup=function(t){m.emit("mouseUp",m.getEventProperties(t))}),c.initialFitDone=!1,c.on("changed",(function(){if(null!=m.itemsData){if(!m.initialFitDone&&!m.options.rollingMode)if(m.initialFitDone=!0,null!=m.options.start||null!=m.options.end){if(null==m.options.start||null==m.options.end)var t=m.getItemRange();var e=null!=m.options.start?m.options.start:t.min,i=null!=m.options.end?m.options.end:t.max;m.setWindow(e,i,{animation:!1})}else m.fit({animation:!1});m.initialDrawDone||!m.initialRangeChangeDone&&(m.options.start||m.options.end)&&!m.options.rollingMode||(m.initialDrawDone=!0,m.itemSet.initialDrawDone=!0,m.dom.root.style.visibility="visible",m.dom.loadingScreen.parentNode.removeChild(m.dom.loadingScreen),m.options.onInitialDrawComplete&&qr((function(){return m.options.onInitialDrawComplete()}),0))}})),c.on("destroyTimeline",(function(){m.destroy()})),o&&c.setOptions(o),c.body.emitter.on("fit",(function(t){c._onFit(t),c.redraw()})),n&&c.setGroups(n),i&&c.setItems(i),c._redraw(),c}return pr(e,t),xa(e,[{key:"_createConfigurator",value:function(){return new Lu(this,this.dom.container,wu)}},{key:"redraw",value:function(){this.itemSet&&this.itemSet.markDirty({refreshItems:!0}),this._redraw()}},{key:"setOptions",value:function(t){if(!0===fu.validate(t,xu)&&console.log("%cErrors have been found in the supplied options object.",mu),cd.prototype.setOptions.call(this,t),"type"in t&&t.type!==this.options.type){this.options.type=t.type;var e=this.itemsData;if(e){var i=this.getSelection();this.setItems(null),this.setItems(e.rawDS),this.setSelection(i)}}}},{key:"setItems",value:function(t){var e;this.itemsDone=!1,e=t?Ua(t instanceof Aa||t instanceof Xa?t:new Aa(t)):null,this.itemsData&&this.itemsData.dispose(),this.itemsData=e,this.itemSet&&this.itemSet.setItems(null!=e?e.rawDS:null)}},{key:"setGroups",value:function(t){var e;if(t){var i=function(t){return!1!==t.visible};e=t instanceof Aa||t instanceof Xa?new Xa(t,{filter:i}):new Aa(En(t).call(t,i))}else e=null;this.groupsData instanceof Xa&&this.groupsData.setData(null),this.groupsData=e,this.itemSet.setGroups(e)}},{key:"setData",value:function(t){t&&t.groups&&this.setGroups(t.groups),t&&t.items&&this.setItems(t.items)}},{key:"setSelection",value:function(t,e){this.itemSet&&this.itemSet.setSelection(t),e&&e.focus&&this.focus(t,e)}},{key:"getSelection",value:function(){return this.itemSet&&this.itemSet.getSelection()||[]}},{key:"focus",value:function(t,e){if(this.itemsData&&null!=t){var i=Zo(t)?t:[t],n=this.itemsData.get(i),o=null,s=null;if(mn(n).call(n,(function(t){var e=t.start.valueOf(),i="end"in t?t.end.valueOf():t.start.valueOf();(null===o||e<o)&&(o=e),(null===s||i>s)&&(s=i)})),null!==o&&null!==s){var r=this,a=this.itemSet.items[i[0]],l=-1*this._getScrollTop(),h=null,d=function(){var t=Qu(r,a);t.shouldScroll&&t.itemTop!=h.itemTop&&(r._setScrollTop(-t.scrollOffset),r._redraw())},u=!e||void 0===e.zoom||e.zoom,c=(o+s)/2,p=u?1.1*(s-o):Math.max(this.range.end-this.range.start,1.1*(s-o)),m=!e||void 0===e.animation||e.animation;m||(h={shouldScroll:!1,scrollOffset:-1,itemTop:-1}),this.range.setRange(c-p/2,c+p/2,{animation:m},(function(){d(),qr(d,100)}),(function(t,e,i){var n=Qu(r,a);if(!1!==n&&(h||(h=n),h.itemTop!=n.itemTop||h.shouldScroll)){h.itemTop!=n.itemTop&&n.shouldScroll&&(h=n,l=-1*r._getScrollTop());var o=l,s=h.scrollOffset,d=i?s:o+(s-o)*t;r._setScrollTop(-d),e||r._redraw()}}))}}}},{key:"fit",value:function(t,e){var i,n=!t||void 0===t.animation||t.animation;1===this.itemsData.length&&void 0===this.itemsData.get()[0].end?(i=this.getDataRange(),this.moveTo(i.min.valueOf(),{animation:n},e)):(i=this.getItemRange(),this.range.setRange(i.min,i.max,{animation:n},e))}},{key:"getItemRange",value:function(){var t=this,e=this.getDataRange(),i=null!==e.min?e.min.valueOf():null,n=null!==e.max?e.max.valueOf():null,o=null,s=null;if(null!=i&&null!=n){var r=n-i;r<=0&&(r=10);var a=r/this.props.center.width,l={},h=0;if(mn(za).call(za,this.itemSet.items,(function(t,e){if(t.groupShowing){l[e]=t.redraw(!0),h=l[e].length}})),h>0)for(var d=function(t){mn(za).call(za,l,(function(e){e[t]()}))},u=0;u<h;u++)d(u);if(mn(za).call(za,this.itemSet.items,(function(e){var r,l,h=Mu(e),d=Su(e);t.options.rtl?(r=h-(e.getWidthRight()+10)*a,l=d+(e.getWidthLeft()+10)*a):(r=h-(e.getWidthLeft()+10)*a,l=d+(e.getWidthRight()+10)*a),r<i&&(i=r,o=e),l>n&&(n=l,s=e)})),o&&s){var c=o.getWidthLeft()+10,p=s.getWidthRight()+10,m=this.props.center.width-c-p;m>0&&(this.options.rtl?(i=Mu(o)-p*r/m,n=Su(s)+c*r/m):(i=Mu(o)-c*r/m,n=Su(s)+p*r/m))}}return{min:null!=i?new Date(i):null,max:null!=n?new Date(n):null}}},{key:"getDataRange",value:function(){var t,e=null,i=null;this.itemsData&&mn(t=this.itemsData).call(t,(function(t){var n=za.convert(t.start,"Date").valueOf(),o=za.convert(null!=t.end?t.end:t.start,"Date").valueOf();(null===e||n<e)&&(e=n),(null===i||o>i)&&(i=o)}));return{min:null!=e?new Date(e):null,max:null!=i?new Date(i):null}}},{key:"getEventProperties",value:function(t){var e=t.center?t.center.x:t.clientX,i=t.center?t.center.y:t.clientY,n=this.dom.centerContainer.getBoundingClientRect(),o=this.options.rtl?n.right-e:e-n.left,s=i-n.top,r=this.itemSet.itemFromTarget(t),a=this.itemSet.groupFromTarget(t),l=ud.customTimeFromTarget(t),h=this.itemSet.options.snap||null,d=this.body.util.getScale(),u=this.body.util.getStep(),c=this._toTime(o),p=h?h(c,d,u):c,m=za.getTarget(t),f=null;return null!=r?f="item":null!=l?f="custom-time":za.hasParent(m,this.timeAxis.dom.foreground)||this.timeAxis2&&za.hasParent(m,this.timeAxis2.dom.foreground)?f="axis":za.hasParent(m,this.itemSet.dom.labelSet)?f="group-label":za.hasParent(m,this.currentTime.bar)?f="current-time":za.hasParent(m,this.dom.center)&&(f="background"),{event:t,item:r?r.id:null,isCluster:!!r&&!!r.isCluster,items:r?r.items||[]:null,group:a?a.groupId:null,customTime:l?l.options.id:null,what:f,pageX:t.srcEvent?t.srcEvent.pageX:t.pageX,pageY:t.srcEvent?t.srcEvent.pageY:t.pageY,x:o,y:s,time:c,snappedTime:p}}},{key:"toggleRollingMode",value:function(){this.range.rolling?this.range.stopRolling():(null==this.options.rollingMode&&this.setOptions(this.options),this.range.startRolling())}},{key:"_redraw",value:function(){cd.prototype._redraw.call(this)}},{key:"_onFit",value:function(t){var e=t.start,i=t.end,n=t.animation;i?this.range.setRange(e,i,{animation:n}):this.moveTo(e.valueOf(),{animation:n})}}]),e}(cd);function Mu(t){return za.convert(t.data.start,"Date").valueOf()}function Su(t){var e=null!=t.data.end?t.data.end:t.data.start;return za.convert(e,"Date").valueOf()}function Qu(t,e){if(!e.parent)return!1;var i=t.options.rtl?t.props.rightContainer.height:t.props.leftContainer.height,n=t.props.center.height,o=e.parent,s=o.top,r=!0,a=t.timeAxis.options.orientation.axis,l=function(){return"bottom"==a?o.height-e.top-e.height:e.top},h=-1*t._getScrollTop(),d=s+l(),u=e.height;return d<h?s+i<=s+l()+u&&(s+=l()-t.itemSet.options.margin.item.vertical):d+u>h+i?s+=l()+u-i+t.itemSet.options.margin.item.vertical:r=!1,{shouldScroll:r,scrollOffset:s=Math.min(s,n-i),itemTop:d}}var Nu=function(){function t(e,i,n,o,s,r){var a=arguments.length>6&&void 0!==arguments[6]&&arguments[6],l=arguments.length>7&&void 0!==arguments[7]&&arguments[7];if(ba(this,t),this.majorSteps=[1,2,5,10],this.minorSteps=[.25,.5,1,2],this.customLines=null,this.containerHeight=s,this.majorCharHeight=r,this._start=e,this._end=i,this.scale=1,this.minorStepIdx=-1,this.magnitudefactor=1,this.determineScale(),this.zeroAlign=a,this.autoScaleStart=n,this.autoScaleEnd=o,this.formattingFunction=l,n||o){var h=this,d=function(t){var e=t-t%(h.magnitudefactor*h.minorSteps[h.minorStepIdx]);return t%(h.magnitudefactor*h.minorSteps[h.minorStepIdx])>h.magnitudefactor*h.minorSteps[h.minorStepIdx]*.5?e+h.magnitudefactor*h.minorSteps[h.minorStepIdx]:e};n&&(this._start-=2*this.magnitudefactor*this.minorSteps[this.minorStepIdx],this._start=d(this._start)),o&&(this._end+=this.magnitudefactor*this.minorSteps[this.minorStepIdx],this._end=d(this._end)),this.determineScale()}}return xa(t,[{key:"setCharHeight",value:function(t){this.majorCharHeight=t}},{key:"setHeight",value:function(t){this.containerHeight=t}},{key:"determineScale",value:function(){var t=this._end-this._start;this.scale=this.containerHeight/t;var e=this.majorCharHeight/this.scale,i=t>0?Math.round(Math.log(t)/Math.LN10):0;this.minorStepIdx=-1,this.magnitudefactor=Math.pow(10,i);var n=0;i<0&&(n=i);for(var o=!1,s=n;Math.abs(s)<=Math.abs(i);s++){this.magnitudefactor=Math.pow(10,s);for(var r=0;r<this.minorSteps.length;r++){if(this.magnitudefactor*this.minorSteps[r]>=e){o=!0,this.minorStepIdx=r;break}}if(!0===o)break}}},{key:"is_major",value:function(t){return t%(this.magnitudefactor*this.majorSteps[this.minorStepIdx])==0}},{key:"getStep",value:function(){return this.magnitudefactor*this.minorSteps[this.minorStepIdx]}},{key:"getFirstMajor",value:function(){var t=this.magnitudefactor*this.majorSteps[this.minorStepIdx];return this.convertValue(this._start+(t-this._start%t)%t)}},{key:"formatValue",value:function(t){var e=t.toPrecision(5);return"function"==typeof this.formattingFunction&&(e=this.formattingFunction(t)),"number"==typeof e?"".concat(e):"string"==typeof e?e:t.toPrecision(5)}},{key:"getLines",value:function(){for(var t=[],e=this.getStep(),i=(e-this._start%e)%e,n=this._start+i;this._end-n>1e-5;n+=e)n!=this._start&&t.push({major:this.is_major(n),y:this.convertValue(n),val:this.formatValue(n)});return t}},{key:"followScale",value:function(t){var e=this.minorStepIdx,i=this._start,n=this._end,o=this,s=function(){o.magnitudefactor*=2},r=function(){o.magnitudefactor/=2};t.minorStepIdx<=1&&this.minorStepIdx<=1||t.minorStepIdx>1&&this.minorStepIdx>1||(t.minorStepIdx<this.minorStepIdx?(this.minorStepIdx=1,2==e||s(),s()):(this.minorStepIdx=2,1==e||r(),r()));for(var a=t.convertValue(0),l=t.getStep()*t.scale,h=!1,d=0;!h&&d++<5;){this.scale=l/(this.minorSteps[this.minorStepIdx]*this.magnitudefactor);var u=this.containerHeight/this.scale;this._start=i,this._end=this._start+u;var c=this._end*this.scale,p=this.magnitudefactor*this.majorSteps[this.minorStepIdx],m=this.getFirstMajor()-t.getFirstMajor();if(this.zeroAlign){var f=a-c;this._end+=f/this.scale,this._start=this._end-u}else this.autoScaleStart?(this._start-=m/this.scale,this._end=this._start+u):(this._start+=p-m/this.scale,this._end=this._start+u);if(!this.autoScaleEnd&&this._end>n+1e-5)r(),h=!1;else{if(!this.autoScaleStart&&this._start<i-1e-5){if(!(this.zeroAlign&&i>=0)){r(),h=!1;continue}console.warn("Can't adhere to given 'min' range, due to zeroalign")}this.autoScaleStart&&this.autoScaleEnd&&u<n-i?(s(),h=!1):h=!0}}}},{key:"convertValue",value:function(t){return this.containerHeight-(t-this._start)*this.scale}},{key:"screenToValue",value:function(t){return(this.containerHeight-t)/this.scale+this._start}}]),t}();Ph(".vis-panel.vis-background.vis-horizontal .vis-grid.vis-horizontal{position:absolute;width:100%;height:0;border-bottom:1px solid}.vis-panel.vis-background.vis-horizontal .vis-grid.vis-minor{border-color:#e5e5e5}.vis-panel.vis-background.vis-horizontal .vis-grid.vis-major{border-color:#bfbfbf}.vis-data-axis .vis-y-axis.vis-major{width:100%;position:absolute;color:#4d4d4d;white-space:nowrap}.vis-data-axis .vis-y-axis.vis-major.vis-measure{padding:0;margin:0;border:0;visibility:hidden;width:auto}.vis-data-axis .vis-y-axis.vis-minor{position:absolute;width:100%;color:#bebebe;white-space:nowrap}.vis-data-axis .vis-y-axis.vis-minor.vis-measure{padding:0;margin:0;border:0;visibility:hidden;width:auto}.vis-data-axis .vis-y-axis.vis-title{position:absolute;color:#4d4d4d;white-space:nowrap;bottom:20px;text-align:center}.vis-data-axis .vis-y-axis.vis-title.vis-measure{padding:0;margin:0;visibility:hidden;width:auto}.vis-data-axis .vis-y-axis.vis-title.vis-left{bottom:0;-webkit-transform-origin:left top;-moz-transform-origin:left top;-ms-transform-origin:left top;-o-transform-origin:left top;transform-origin:left bottom;-webkit-transform:rotate(-90deg);-moz-transform:rotate(-90deg);-ms-transform:rotate(-90deg);-o-transform:rotate(-90deg);transform:rotate(-90deg)}.vis-data-axis .vis-y-axis.vis-title.vis-right{bottom:0;-webkit-transform-origin:right bottom;-moz-transform-origin:right bottom;-ms-transform-origin:right bottom;-o-transform-origin:right bottom;transform-origin:right bottom;-webkit-transform:rotate(90deg);-moz-transform:rotate(90deg);-ms-transform:rotate(90deg);-o-transform:rotate(90deg);transform:rotate(90deg)}.vis-legend{background-color:rgba(247,252,255,.65);padding:5px;border:1px solid #b3b3b3;box-shadow:2px 2px 10px hsla(0,0%,60.4%,.55)}.vis-legend-text{white-space:nowrap;display:inline-block}\n/*# sourceMappingURL=data:application/json;base64,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 */");var Fu=function(t){function e(t,i,n,o){var s;ba(this,e),(s=ar(this,dr(e).call(this))).id=Id(),s.body=t,s.defaultOptions={orientation:"left",showMinorLabels:!0,showMajorLabels:!0,showWeekScale:!1,icons:!1,majorLinesOffset:7,minorLinesOffset:4,labelOffsetX:10,labelOffsetY:2,iconWidth:20,width:"40px",visible:!0,alignZeros:!0,left:{range:{min:void 0,max:void 0},format:function(t){return"".concat(Pa(t.toPrecision(3)))},title:{text:void 0,style:void 0}},right:{range:{min:void 0,max:void 0},format:function(t){return"".concat(Pa(t.toPrecision(3)))},title:{text:void 0,style:void 0}}},s.linegraphOptions=o,s.linegraphSVG=n,s.props={},s.DOMelements={lines:{},labels:{},title:{}},s.dom={},s.scale=void 0,s.range={start:0,end:0},s.options=za.extend({},s.defaultOptions),s.conversionFactor=1,s.setOptions(i),s.width=Number("".concat(s.options.width).replace("px","")),s.minWidth=s.width,s.height=s.linegraphSVG.getBoundingClientRect().height,s.hidden=!1,s.stepPixels=25,s.zeroCrossing=-1,s.amountOfSteps=-1,s.lineOffset=0,s.master=!0,s.masterAxis=null,s.svgElements={},s.iconsRemoved=!1,s.groups={},s.amountOfGroups=0,s._create(),null==s.scale&&s._redrawLabels(),s.framework={svg:s.svg,svgElements:s.svgElements,options:s.options,groups:s.groups};var r=Bs(s);return s.body.emitter.on("verticalDrag",(function(){r.dom.lineContainer.style.top="".concat(r.body.domProps.scrollTop,"px")})),s}return pr(e,t),xa(e,[{key:"addGroup",value:function(t,e){this.groups.hasOwnProperty(t)||(this.groups[t]=e),this.amountOfGroups+=1}},{key:"updateGroup",value:function(t,e){this.groups.hasOwnProperty(t)||(this.amountOfGroups+=1),this.groups[t]=e}},{key:"removeGroup",value:function(t){this.groups.hasOwnProperty(t)&&(delete this.groups[t],this.amountOfGroups-=1)}},{key:"setOptions",value:function(t){if(t){var e=!1;this.options.orientation!=t.orientation&&void 0!==t.orientation&&(e=!0);za.selectiveDeepExtend(["orientation","showMinorLabels","showMajorLabels","icons","majorLinesOffset","minorLinesOffset","labelOffsetX","labelOffsetY","iconWidth","width","visible","left","right","alignZeros"],this.options,t),this.minWidth=Number("".concat(this.options.width).replace("px","")),!0===e&&this.dom.frame&&(this.hide(),this.show())}}},{key:"_create",value:function(){this.dom.frame=document.createElement("div"),this.dom.frame.style.width=this.options.width,this.dom.frame.style.height=this.height,this.dom.lineContainer=document.createElement("div"),this.dom.lineContainer.style.width="100%",this.dom.lineContainer.style.height=this.height,this.dom.lineContainer.style.position="relative",this.dom.lineContainer.style.visibility="visible",this.dom.lineContainer.style.display="block",this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.style.position="absolute",this.svg.style.top="0px",this.svg.style.height="100%",this.svg.style.width="100%",this.svg.style.display="block",this.dom.frame.appendChild(this.svg)}},{key:"_redrawGroupIcons",value:function(){var t;Cs(this.svgElements);var e=this.options.iconWidth,i=11.5;t="left"===this.options.orientation?4:this.width-e-4;var n=Yi(this.groups);wr(n).call(n,(function(t,e){return t<e?-1:1}));var o=!0,s=!1,r=void 0;try{for(var a,l=Fi(n);!(o=(a=l.next()).done);o=!0){var h=a.value;!0!==this.groups[h].visible||void 0!==this.linegraphOptions.visibility[h]&&!0!==this.linegraphOptions.visibility[h]||(this.groups[h].getLegend(e,15,this.framework,t,i),i+=19)}}catch(t){s=!0,r=t}finally{try{o||null==l.return||l.return()}finally{if(s)throw r}}Ls(this.svgElements),this.iconsRemoved=!1}},{key:"_cleanupIcons",value:function(){!1===this.iconsRemoved&&(Cs(this.svgElements),Ls(this.svgElements),this.iconsRemoved=!0)}},{key:"show",value:function(){this.hidden=!1,this.dom.frame.parentNode||("left"===this.options.orientation?this.body.dom.left.appendChild(this.dom.frame):this.body.dom.right.appendChild(this.dom.frame)),this.dom.lineContainer.parentNode||this.body.dom.backgroundHorizontal.appendChild(this.dom.lineContainer),this.dom.lineContainer.style.display="block"}},{key:"hide",value:function(){this.hidden=!0,this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom.lineContainer.style.display="none"}},{key:"setRange",value:function(t,e){this.range.start=t,this.range.end=e}},{key:"redraw",value:function(){var t=!1,e=0;for(var i in this.dom.lineContainer.style.top="".concat(this.body.domProps.scrollTop,"px"),this.groups)this.groups.hasOwnProperty(i)&&(!0!==this.groups[i].visible||void 0!==this.linegraphOptions.visibility[i]&&!0!==this.linegraphOptions.visibility[i]||e++);if(0===this.amountOfGroups||0===e)this.hide();else{this.show(),this.height=Number(this.linegraphSVG.style.height.replace("px","")),this.dom.lineContainer.style.height="".concat(this.height,"px"),this.width=!0===this.options.visible?Number("".concat(this.options.width).replace("px","")):0;var n=this.props,o=this.dom.frame;o.className="vis-data-axis",this._calculateCharSize();var s=this.options.orientation,r=this.options.showMinorLabels,a=this.options.showMajorLabels,l=this.body.dom.backgroundHorizontal.offsetWidth;n.minorLabelHeight=r?n.minorCharHeight:0,n.majorLabelHeight=a?n.majorCharHeight:0,n.minorLineWidth=l-this.lineOffset-this.width+2*this.options.minorLinesOffset,n.minorLineHeight=1,n.majorLineWidth=l-this.lineOffset-this.width+2*this.options.majorLinesOffset,n.majorLineHeight=1,"left"===s?(o.style.top="0",o.style.left="0",o.style.bottom="",o.style.width="".concat(this.width,"px"),o.style.height="".concat(this.height,"px"),this.props.width=this.body.domProps.left.width,this.props.height=this.body.domProps.left.height):(o.style.top="",o.style.bottom="0",o.style.left="0",o.style.width="".concat(this.width,"px"),o.style.height="".concat(this.height,"px"),this.props.width=this.body.domProps.right.width,this.props.height=this.body.domProps.right.height),t=this._redrawLabels(),t=this._isResized()||t,!0===this.options.icons?this._redrawGroupIcons():this._cleanupIcons(),this._redrawTitle(s)}return t}},{key:"_redrawLabels",value:function(){var t=this,e=!1;Cs(this.DOMelements.lines),Cs(this.DOMelements.labels);var i=this.options.orientation,n=null!=this.options[i].range?this.options[i].range:{},o=!0;null!=n.max&&(this.range.end=n.max,o=!1);var s=!0;null!=n.min&&(this.range.start=n.min,s=!1),this.scale=new Nu(this.range.start,this.range.end,s,o,this.dom.frame.offsetHeight,this.props.majorCharHeight,this.options.alignZeros,this.options[i].format),!1===this.master&&null!=this.masterAxis?(this.scale.followScale(this.masterAxis.scale),this.dom.lineContainer.style.display="none"):this.dom.lineContainer.style.display="block",this.maxLabelSize=0;var r=this.scale.getLines();mn(r).call(r,(function(e){var n=e.y,o=e.major;t.options.showMinorLabels&&!1===o&&t._redrawLabel(n-2,e.val,i,"vis-y-axis vis-minor",t.props.minorCharHeight),o&&n>=0&&t._redrawLabel(n-2,e.val,i,"vis-y-axis vis-major",t.props.majorCharHeight),!0===t.master&&(o?t._redrawLine(n,i,"vis-grid vis-horizontal vis-major",t.options.majorLinesOffset,t.props.majorLineWidth):t._redrawLine(n,i,"vis-grid vis-horizontal vis-minor",t.options.minorLinesOffset,t.props.minorLineWidth))}));var a=0;void 0!==this.options[i].title&&void 0!==this.options[i].title.text&&(a=this.props.titleCharHeight);var l=!0===this.options.icons?Math.max(this.options.iconWidth,a)+this.options.labelOffsetX+15:a+this.options.labelOffsetX+15;return this.maxLabelSize>this.width-l&&!0===this.options.visible?(this.width=this.maxLabelSize+l,this.options.width="".concat(this.width,"px"),Ls(this.DOMelements.lines),Ls(this.DOMelements.labels),this.redraw(),e=!0):this.maxLabelSize<this.width-l&&!0===this.options.visible&&this.width>this.minWidth?(this.width=Math.max(this.minWidth,this.maxLabelSize+l),this.options.width="".concat(this.width,"px"),Ls(this.DOMelements.lines),Ls(this.DOMelements.labels),this.redraw(),e=!0):(Ls(this.DOMelements.lines),Ls(this.DOMelements.labels),e=!1),e}},{key:"convertValue",value:function(t){return this.scale.convertValue(t)}},{key:"screenToValue",value:function(t){return this.scale.screenToValue(t)}},{key:"_redrawLabel",value:function(t,e,i,n,o){var s=Ss("div",this.DOMelements.labels,this.dom.frame);s.className=n,s.innerHTML=e,"left"===i?(s.style.left="-".concat(this.options.labelOffsetX,"px"),s.style.textAlign="right"):(s.style.right="-".concat(this.options.labelOffsetX,"px"),s.style.textAlign="left"),s.style.top="".concat(t-.5*o+this.options.labelOffsetY,"px"),e+="";var r=Math.max(this.props.majorCharWidth,this.props.minorCharWidth);this.maxLabelSize<e.length*r&&(this.maxLabelSize=e.length*r)}},{key:"_redrawLine",value:function(t,e,i,n,o){if(!0===this.master){var s=Ss("div",this.DOMelements.lines,this.dom.lineContainer);s.className=i,s.innerHTML="","left"===e?s.style.left="".concat(this.width-n,"px"):s.style.right="".concat(this.width-n,"px"),s.style.width="".concat(o,"px"),s.style.top="".concat(t,"px")}}},{key:"_redrawTitle",value:function(t){if(Cs(this.DOMelements.title),void 0!==this.options[t].title&&void 0!==this.options[t].title.text){var e=Ss("div",this.DOMelements.title,this.dom.frame);e.className="vis-y-axis vis-title vis-".concat(t),e.innerHTML=this.options[t].title.text,void 0!==this.options[t].title.style&&za.addCssText(e,this.options[t].title.style),"left"===t?e.style.left="".concat(this.props.titleCharHeight,"px"):e.style.right="".concat(this.props.titleCharHeight,"px"),e.style.width="".concat(this.height,"px")}Ls(this.DOMelements.title)}},{key:"_calculateCharSize",value:function(){if(!("minorCharHeight"in this.props)){var t=document.createTextNode("0"),e=document.createElement("div");e.className="vis-y-axis vis-minor vis-measure",e.appendChild(t),this.dom.frame.appendChild(e),this.props.minorCharHeight=e.clientHeight,this.props.minorCharWidth=e.clientWidth,this.dom.frame.removeChild(e)}if(!("majorCharHeight"in this.props)){var i=document.createTextNode("0"),n=document.createElement("div");n.className="vis-y-axis vis-major vis-measure",n.appendChild(i),this.dom.frame.appendChild(n),this.props.majorCharHeight=n.clientHeight,this.props.majorCharWidth=n.clientWidth,this.dom.frame.removeChild(n)}if(!("titleCharHeight"in this.props)){var o=document.createTextNode("0"),s=document.createElement("div");s.className="vis-y-axis vis-title vis-measure",s.appendChild(o),this.dom.frame.appendChild(s),this.props.titleCharHeight=s.clientHeight,this.props.titleCharWidth=s.clientWidth,this.dom.frame.removeChild(s)}}}]),e}(Ja);function Zu(t,e){}function Bu(t,e){return{style:(e=void 0===e?{}:e).style||t.options.drawPoints.style,styles:e.styles||t.options.drawPoints.styles,size:e.size||t.options.drawPoints.size,className:e.className||t.className}}function Ou(t,e){}function Wu(t,e){}function Au(t,e,i,n){this.id=e;this.options=za.selectiveBridgeObject(["sampling","style","sort","yAxisOrientation","barChart","drawPoints","shaded","interpolation","zIndex","excludeFromStacking","excludeFromLegend"],i),this.usingDefaultStyle=void 0===t.className,this.groupsUsingDefaultStyles=n,this.zeroPosition=0,this.update(t),1==this.usingDefaultStyle&&(this.groupsUsingDefaultStyles[0]+=1),this.itemsData=[],this.visible=void 0===t.visible||t.visible}function Xu(t,e,i,n){this.body=t,this.defaultOptions={enabled:!1,icons:!0,iconSize:20,iconSpacing:6,left:{visible:!0,position:"top-left"},right:{visible:!0,position:"top-right"}},this.side=i,this.options=za.extend({},this.defaultOptions),this.linegraphOptions=n,this.svgElements={},this.dom={},this.groups={},this.amountOfGroups=0,this._create(),this.framework={svg:this.svg,svgElements:this.svgElements,options:this.options,groups:this.groups},this.setOptions(e)}Zu.draw=function(t,e,i,n){n=n||0;for(var o=function(t,e){var i=void 0;t.options&&t.options.drawPoints&&t.options.drawPoints.onRender&&"function"==typeof t.options.drawPoints.onRender&&(i=t.options.drawPoints.onRender);e.group.options&&e.group.options.drawPoints&&e.group.options.drawPoints.onRender&&"function"==typeof e.group.options.drawPoints.onRender&&(i=e.group.options.drawPoints.onRender);return i}(i,e),s=0;s<t.length;s++)if(o){var r=o(t[s],e);!0!==r&&"object"!==zo(r)||Qs(t[s].screen_x+n,t[s].screen_y,Bu(e,r),i.svgElements,i.svg,t[s].label)}else Qs(t[s].screen_x+n,t[s].screen_y,Bu(e),i.svgElements,i.svg,t[s].label)},Zu.drawIcon=function(t,e,i,n,o,s){var r=.5*o,a=Ms("rect",s.svgElements,s.svg);a.setAttributeNS(null,"x",e),a.setAttributeNS(null,"y",i-r),a.setAttributeNS(null,"width",n),a.setAttributeNS(null,"height",2*r),a.setAttributeNS(null,"class","vis-outline"),Qs(e+.5*n,i,Bu(t),s.svgElements,s.svg)},Ou.drawIcon=function(t,e,i,n,o,s){var r=.5*o,a=Ms("rect",s.svgElements,s.svg);a.setAttributeNS(null,"x",e),a.setAttributeNS(null,"y",i-r),a.setAttributeNS(null,"width",n),a.setAttributeNS(null,"height",2*r),a.setAttributeNS(null,"class","vis-outline");var l=Math.round(.3*n),h=t.options.barChart.width/l,d=Math.round(.4*o),u=Math.round(.75*o),c=Math.round((n-2*l)/3);if(Ns(e+.5*l+c,i+r-d-1,l,d,t.className+" vis-bar",s.svgElements,s.svg,t.style),Ns(e+1.5*l+c+2,i+r-u-1,l,u,t.className+" vis-bar",s.svgElements,s.svg,t.style),1==t.options.drawPoints.enabled){var p={style:t.options.drawPoints.style,styles:t.options.drawPoints.styles,size:t.options.drawPoints.size/h,className:t.className};Qs(e+.5*l+c,i+r-d-1,p,s.svgElements,s.svg),Qs(e+1.5*l+c+2,i+r-u-1,p,s.svgElements,s.svg)}},Ou.draw=function(t,e,i){var n,o,s,r,a,l,h=[],d={},u=0;for(a=0;a<t.length;a++)if("bar"===(r=i.groups[t[a]]).options.style&&!0===r.visible&&(void 0===i.options.groups.visibility[t[a]]||!0===i.options.groups.visibility[t[a]]))for(l=0;l<e[t[a]].length;l++)h.push({screen_x:e[t[a]][l].screen_x,screen_end:e[t[a]][l].screen_end,screen_y:e[t[a]][l].screen_y,x:e[t[a]][l].x,end:e[t[a]][l].end,y:e[t[a]][l].y,groupId:t[a],label:e[t[a]][l].label}),u+=1;if(0!==u)for(wr(h).call(h,(function(t,e){return t.screen_x===e.screen_x?t.groupId<e.groupId?-1:1:t.screen_x-e.screen_x})),Ou._getDataIntersections(d,h),a=0;a<h.length;a++){var c=null!=(r=i.groups[h[a].groupId]).options.barChart.minWidth?r.options.barChart.minWidth:.1*r.options.barChart.width,p=0;if(void 0===d[o=h[a].screen_x])a+1<h.length&&(n=Math.abs(h[a+1].screen_x-o)),s=Ou._getSafeDrawData(n,r,c);else{var m=a+(d[o].amount-d[o].resolved);m<h.length&&(n=Math.abs(h[m].screen_x-o)),s=Ou._getSafeDrawData(n,r,c),d[o].resolved+=1,!0===r.options.stack&&!0!==r.options.excludeFromStacking?h[a].screen_y<r.zeroPosition?(p=d[o].accumulatedNegative,d[o].accumulatedNegative+=r.zeroPosition-h[a].screen_y):(p=d[o].accumulatedPositive,d[o].accumulatedPositive+=r.zeroPosition-h[a].screen_y):!0===r.options.barChart.sideBySide&&(s.width=s.width/d[o].amount,s.offset+=d[o].resolved*s.width-.5*s.width*(d[o].amount+1))}var f=s.width,g=h[a].screen_x;if(null!=h[a].screen_end?g+=.5*(f=h[a].screen_end-h[a].screen_x):g+=s.offset,Ns(g,h[a].screen_y-p,f,r.zeroPosition-h[a].screen_y,r.className+" vis-bar",i.svgElements,i.svg,r.style),!0===r.options.drawPoints.enabled){var v={screen_x:h[a].screen_x,screen_y:h[a].screen_y-p,x:h[a].x,y:h[a].y,groupId:h[a].groupId,label:h[a].label};Zu.draw([v],r,i,s.offset)}}},Ou._getDataIntersections=function(t,e){for(var i,n=0;n<e.length;n++)n+1<e.length&&(i=Math.abs(e[n+1].screen_x-e[n].screen_x)),n>0&&(i=Math.min(i,Math.abs(e[n-1].screen_x-e[n].screen_x))),0===i&&(void 0===t[e[n].screen_x]&&(t[e[n].screen_x]={amount:0,resolved:0,accumulatedPositive:0,accumulatedNegative:0}),t[e[n].screen_x].amount+=1)},Ou._getSafeDrawData=function(t,e,i){var n,o;return t<e.options.barChart.width&&t>0?(n=t<i?i:t,o=0,"left"===e.options.barChart.align?o-=.5*t:"right"===e.options.barChart.align&&(o+=.5*t)):(n=e.options.barChart.width,o=0,"left"===e.options.barChart.align?o-=.5*e.options.barChart.width:"right"===e.options.barChart.align&&(o+=.5*e.options.barChart.width)),{width:n,offset:o}},Ou.getStackedYRange=function(t,e,i,n,o){if(t.length>0){wr(t).call(t,(function(t,e){return t.screen_x===e.screen_x?t.groupId<e.groupId?-1:1:t.screen_x-e.screen_x}));var s={};Ou._getDataIntersections(s,t),e[n]=Ou._getStackedYRange(s,t),e[n].yAxisOrientation=o,i.push(n)}},Ou._getStackedYRange=function(t,e){for(var i,n=e[0].screen_y,o=e[0].screen_y,s=0;s<e.length;s++)void 0===t[i=e[s].screen_x]?(n=n>e[s].screen_y?e[s].screen_y:n,o=o<e[s].screen_y?e[s].screen_y:o):e[s].screen_y<0?t[i].accumulatedNegative+=e[s].screen_y:t[i].accumulatedPositive+=e[s].screen_y;for(var r in t)t.hasOwnProperty(r)&&(n=(n=n>t[r].accumulatedNegative?t[r].accumulatedNegative:n)>t[r].accumulatedPositive?t[r].accumulatedPositive:n,o=(o=o<t[r].accumulatedNegative?t[r].accumulatedNegative:o)<t[r].accumulatedPositive?t[r].accumulatedPositive:o);return{min:n,max:o}},Wu.calcPath=function(t,e){if(null!=t&&t.length>0){return 1==e.options.interpolation.enabled?Wu._catmullRom(t,e):Wu._linear(t)}},Wu.drawIcon=function(t,e,i,n,o,s){var r,a,l=.5*o,h=Ms("rect",s.svgElements,s.svg);(h.setAttributeNS(null,"x",e),h.setAttributeNS(null,"y",i-l),h.setAttributeNS(null,"width",n),h.setAttributeNS(null,"height",2*l),h.setAttributeNS(null,"class","vis-outline"),(r=Ms("path",s.svgElements,s.svg)).setAttributeNS(null,"class",t.className),void 0!==t.style&&r.setAttributeNS(null,"style",t.style),r.setAttributeNS(null,"d","M"+e+","+i+" L"+(e+n)+","+i),1==t.options.shaded.enabled&&(a=Ms("path",s.svgElements,s.svg),"top"==t.options.shaded.orientation?a.setAttributeNS(null,"d","M"+e+", "+(i-l)+"L"+e+","+i+" L"+(e+n)+","+i+" L"+(e+n)+","+(i-l)):a.setAttributeNS(null,"d","M"+e+","+i+" L"+e+","+(i+l)+" L"+(e+n)+","+(i+l)+"L"+(e+n)+","+i),a.setAttributeNS(null,"class",t.className+" vis-icon-fill"),void 0!==t.options.shaded.style&&""!==t.options.shaded.style&&a.setAttributeNS(null,"style",t.options.shaded.style)),1==t.options.drawPoints.enabled)&&Qs(e+.5*n,i,{style:t.options.drawPoints.style,styles:t.options.drawPoints.styles,size:t.options.drawPoints.size,className:t.className},s.svgElements,s.svg)},Wu.drawShading=function(t,e,i,n){if(1==e.options.shaded.enabled){var o,s=Number(n.svg.style.height.replace("px","")),r=Ms("path",n.svgElements,n.svg),a="L";1==e.options.interpolation.enabled&&(a="C");var l=0;l="top"==e.options.shaded.orientation?0:"bottom"==e.options.shaded.orientation?s:Math.min(Math.max(0,e.zeroPosition),s),o="group"==e.options.shaded.orientation&&null!=i&&null!=i?"M"+t[0][0]+","+t[0][1]+" "+this.serializePath(t,a,!1)+" L"+i[i.length-1][0]+","+i[i.length-1][1]+" "+this.serializePath(i,a,!0)+i[0][0]+","+i[0][1]+" Z":"M"+t[0][0]+","+t[0][1]+" "+this.serializePath(t,a,!1)+" V"+l+" H"+t[0][0]+" Z",r.setAttributeNS(null,"class",e.className+" vis-fill"),void 0!==e.options.shaded.style&&r.setAttributeNS(null,"style",e.options.shaded.style),r.setAttributeNS(null,"d",o)}},Wu.draw=function(t,e,i){if(null!=t&&null!=t){var n=Ms("path",i.svgElements,i.svg);n.setAttributeNS(null,"class",e.className),void 0!==e.style&&n.setAttributeNS(null,"style",e.style);var o="L";1==e.options.interpolation.enabled&&(o="C"),n.setAttributeNS(null,"d","M"+t[0][0]+","+t[0][1]+" "+this.serializePath(t,o,!1))}},Wu.serializePath=function(t,e,i){if(t.length<2)return"";var n,o=e;if(i)for(n=t.length-2;n>0;n--)o+=t[n][0]+","+t[n][1]+" ";else for(n=1;n<t.length;n++)o+=t[n][0]+","+t[n][1]+" ";return o},Wu._catmullRomUniform=function(t){var e,i,n,o,s,r,a=[];a.push([Math.round(t[0].screen_x),Math.round(t[0].screen_y)]);for(var l=t.length,h=0;h<l-1;h++)e=0==h?t[0]:t[h-1],i=t[h],n=t[h+1],o=h+2<l?t[h+2]:n,s={screen_x:(-e.screen_x+6*i.screen_x+n.screen_x)*(1/6),screen_y:(-e.screen_y+6*i.screen_y+n.screen_y)*(1/6)},r={screen_x:(i.screen_x+6*n.screen_x-o.screen_x)*(1/6),screen_y:(i.screen_y+6*n.screen_y-o.screen_y)*(1/6)},a.push([s.screen_x,s.screen_y]),a.push([r.screen_x,r.screen_y]),a.push([n.screen_x,n.screen_y]);return a},Wu._catmullRom=function(t,e){var i=e.options.interpolation.alpha;if(0==i||void 0===i)return this._catmullRomUniform(t);var n,o,s,r,a,l,h,d,u,c,p,m,f,g,v,b,y,x,w,_=[];_.push([Math.round(t[0].screen_x),Math.round(t[0].screen_y)]);for(var k=t.length,D=0;D<k-1;D++)n=0==D?t[0]:t[D-1],o=t[D],s=t[D+1],r=D+2<k?t[D+2]:s,h=Math.sqrt(Math.pow(n.screen_x-o.screen_x,2)+Math.pow(n.screen_y-o.screen_y,2)),d=Math.sqrt(Math.pow(o.screen_x-s.screen_x,2)+Math.pow(o.screen_y-s.screen_y,2)),u=Math.sqrt(Math.pow(s.screen_x-r.screen_x,2)+Math.pow(s.screen_y-r.screen_y,2)),g=Math.pow(u,i),b=Math.pow(u,2*i),v=Math.pow(d,i),y=Math.pow(d,2*i),w=Math.pow(h,i),c=2*(x=Math.pow(h,2*i))+3*w*v+y,p=2*b+3*g*v+y,(m=3*w*(w+v))>0&&(m=1/m),(f=3*g*(g+v))>0&&(f=1/f),a={screen_x:(-y*n.screen_x+c*o.screen_x+x*s.screen_x)*m,screen_y:(-y*n.screen_y+c*o.screen_y+x*s.screen_y)*m},l={screen_x:(b*o.screen_x+p*s.screen_x-y*r.screen_x)*f,screen_y:(b*o.screen_y+p*s.screen_y-y*r.screen_y)*f},0==a.screen_x&&0==a.screen_y&&(a=o),0==l.screen_x&&0==l.screen_y&&(l=s),_.push([a.screen_x,a.screen_y]),_.push([l.screen_x,l.screen_y]),_.push([s.screen_x,s.screen_y]);return _},Wu._linear=function(t){for(var e=[],i=0;i<t.length;i++)e.push([t[i].screen_x,t[i].screen_y]);return e},Au.prototype.setItems=function(t){null!=t?(this.itemsData=t,1==wr(this.options)&&za.insertSort(this.itemsData,(function(t,e){return t.x>e.x?1:-1}))):this.itemsData=[]},Au.prototype.getItems=function(){return this.itemsData},Au.prototype.setZeroPosition=function(t){this.zeroPosition=t},Au.prototype.setOptions=function(t){if(void 0!==t){za.selectiveDeepExtend(["sampling","style","sort","yAxisOrientation","barChart","zIndex","excludeFromStacking","excludeFromLegend"],this.options,t),"function"==typeof t.drawPoints&&(t.drawPoints={onRender:t.drawPoints}),za.mergeOptions(this.options,t,"interpolation"),za.mergeOptions(this.options,t,"drawPoints"),za.mergeOptions(this.options,t,"shaded"),t.interpolation&&"object"==zo(t.interpolation)&&t.interpolation.parametrization&&("uniform"==t.interpolation.parametrization?this.options.interpolation.alpha=0:"chordal"==t.interpolation.parametrization?this.options.interpolation.alpha=1:(this.options.interpolation.parametrization="centripetal",this.options.interpolation.alpha=.5))}},Au.prototype.update=function(t){this.group=t,this.content=t.content||"graph",this.className=t.className||this.className||"vis-graph-group"+this.groupsUsingDefaultStyles[0]%10,this.visible=void 0===t.visible||t.visible,this.style=t.style,this.setOptions(t.options)},Au.prototype.getLegend=function(t,e,i,n,o){null!=i&&null!=i||(i={svg:document.createElementNS("http://www.w3.org/2000/svg","svg"),svgElements:{},options:this.options,groups:[this]});switch(null!=n&&null!=n||(n=0),null!=o&&null!=o||(o=.5*e),this.options.style){case"line":Wu.drawIcon(this,n,o,t,e,i);break;case"points":case"point":Zu.drawIcon(this,n,o,t,e,i);break;case"bar":Ou.drawIcon(this,n,o,t,e,i)}return{icon:i.svg,label:this.content,orientation:this.options.yAxisOrientation}},Au.prototype.getYRange=function(t){for(var e=t[0].y,i=t[0].y,n=0;n<t.length;n++)e=e>t[n].y?t[n].y:e,i=i<t[n].y?t[n].y:i;return{min:e,max:i,yAxisOrientation:this.options.yAxisOrientation}},Xu.prototype=new Ja,Xu.prototype.clear=function(){this.groups={},this.amountOfGroups=0},Xu.prototype.addGroup=function(t,e){1!=e.options.excludeFromLegend&&(this.groups.hasOwnProperty(t)||(this.groups[t]=e),this.amountOfGroups+=1)},Xu.prototype.updateGroup=function(t,e){this.groups[t]=e},Xu.prototype.removeGroup=function(t){this.groups.hasOwnProperty(t)&&(delete this.groups[t],this.amountOfGroups-=1)},Xu.prototype._create=function(){this.dom.frame=document.createElement("div"),this.dom.frame.className="vis-legend",this.dom.frame.style.position="absolute",this.dom.frame.style.top="10px",this.dom.frame.style.display="block",this.dom.textArea=document.createElement("div"),this.dom.textArea.className="vis-legend-text",this.dom.textArea.style.position="relative",this.dom.textArea.style.top="0px",this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.style.position="absolute",this.svg.style.top="0px",this.svg.style.width=this.options.iconSize+5+"px",this.svg.style.height="100%",this.dom.frame.appendChild(this.svg),this.dom.frame.appendChild(this.dom.textArea)},Xu.prototype.hide=function(){this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame)},Xu.prototype.show=function(){this.dom.frame.parentNode||this.body.dom.center.appendChild(this.dom.frame)},Xu.prototype.setOptions=function(t){za.selectiveDeepExtend(["enabled","orientation","icons","left","right"],this.options,t)},Xu.prototype.redraw=function(){var t=0,e=Yi(this.groups);wr(e).call(e,(function(t,e){return t<e?-1:1}));for(var i=0;i<e.length;i++){var n=e[i];1!=this.groups[n].visible||void 0!==this.linegraphOptions.visibility[n]&&1!=this.linegraphOptions.visibility[n]||t++}if(0==this.options[this.side].visible||0==this.amountOfGroups||0==this.options.enabled||0==t)this.hide();else{if(this.show(),"top-left"==this.options[this.side].position||"bottom-left"==this.options[this.side].position?(this.dom.frame.style.left="4px",this.dom.frame.style.textAlign="left",this.dom.textArea.style.textAlign="left",this.dom.textArea.style.left=this.options.iconSize+15+"px",this.dom.textArea.style.right="",this.svg.style.left="0px",this.svg.style.right=""):(this.dom.frame.style.right="4px",this.dom.frame.style.textAlign="right",this.dom.textArea.style.textAlign="right",this.dom.textArea.style.right=this.options.iconSize+15+"px",this.dom.textArea.style.left="",this.svg.style.right="0px",this.svg.style.left=""),"top-left"==this.options[this.side].position||"top-right"==this.options[this.side].position)this.dom.frame.style.top=4-Number(this.body.dom.center.style.top.replace("px",""))+"px",this.dom.frame.style.bottom="";else{var o=this.body.domProps.center.height-this.body.domProps.centerContainer.height;this.dom.frame.style.bottom=4+o+Number(this.body.dom.center.style.top.replace("px",""))+"px",this.dom.frame.style.top=""}0==this.options.icons?(this.dom.frame.style.width=this.dom.textArea.offsetWidth+10+"px",this.dom.textArea.style.right="",this.dom.textArea.style.left="",this.svg.style.width="0px"):(this.dom.frame.style.width=this.options.iconSize+15+this.dom.textArea.offsetWidth+10+"px",this.drawLegendIcons());var s="";for(i=0;i<e.length;i++)n=e[i],1!=this.groups[n].visible||void 0!==this.linegraphOptions.visibility[n]&&1!=this.linegraphOptions.visibility[n]||(s+=this.groups[n].content+"<br />");this.dom.textArea.innerHTML=s,this.dom.textArea.style.lineHeight=.75*this.options.iconSize+this.options.iconSpacing+"px"}},Xu.prototype.drawLegendIcons=function(){if(this.dom.frame.parentNode){var t=Yi(this.groups);wr(t).call(t,(function(t,e){return t<e?-1:1})),Gs(this.svgElements);var e=window.getComputedStyle(this.dom.frame).paddingTop,i=Number(e.replace("px","")),n=i,o=this.options.iconSize,s=.75*this.options.iconSize,r=i+.5*s+3;this.svg.style.width=o+5+i+"px";for(var a=0;a<t.length;a++){var l=t[a];1!=this.groups[l].visible||void 0!==this.linegraphOptions.visibility[l]&&1!=this.linegraphOptions.visibility[l]||(this.groups[l].getLegend(o,s,this.framework,n,r),r+=s+this.options.iconSpacing)}}};function Tu(t,e){this.id=Id(),this.body=t,this.defaultOptions={yAxisOrientation:"left",defaultGroup:"default",sort:!0,sampling:!0,stack:!1,graphHeight:"400px",shaded:{enabled:!1,orientation:"bottom"},style:"line",barChart:{width:50,sideBySide:!1,align:"center"},interpolation:{enabled:!0,parametrization:"centripetal",alpha:.5},drawPoints:{enabled:!0,size:6,style:"square"},dataAxis:{},legend:{},groups:{visibility:{}}},this.options=za.extend({},this.defaultOptions),this.dom={},this.props={},this.hammer=null,this.groups={},this.abortedGraphUpdate=!1,this.updateSVGheight=!1,this.updateSVGheightOnResize=!1,this.forceGraphUpdate=!0;var i=this;this.itemsData=null,this.groupsData=null,this.itemListeners={add:function(t,e,n){i._onAdd(e.items)},update:function(t,e,n){i._onUpdate(e.items)},remove:function(t,e,n){i._onRemove(e.items)}},this.groupListeners={add:function(t,e,n){i._onAddGroups(e.items)},update:function(t,e,n){i._onUpdateGroups(e.items)},remove:function(t,e,n){i._onRemoveGroups(e.items)}},this.items={},this.selection=[],this.lastStart=this.body.range.start,this.touchParams={},this.svgElements={},this.setOptions(e),this.groupsUsingDefaultStyles=[0],this.body.emitter.on("rangechanged",(function(){i.lastStart=i.body.range.start,i.svg.style.left=za.option.asSize(-i.props.width),i.forceGraphUpdate=!0,i.redraw.call(i)})),this._create(),this.framework={svg:this.svg,svgElements:this.svgElements,options:this.options,groups:this.groups}}Tu.prototype=new Ja,Tu.prototype._create=function(){var t=document.createElement("div");t.className="vis-line-graph",this.dom.frame=t,this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.style.position="relative",this.svg.style.height=(""+this.options.graphHeight).replace("px","")+"px",this.svg.style.display="block",t.appendChild(this.svg),this.options.dataAxis.orientation="left",this.yAxisLeft=new Fu(this.body,this.options.dataAxis,this.svg,this.options.groups),this.options.dataAxis.orientation="right",this.yAxisRight=new Fu(this.body,this.options.dataAxis,this.svg,this.options.groups),delete this.options.dataAxis.orientation,this.legendLeft=new Xu(this.body,this.options.legend,"left",this.options.groups),this.legendRight=new Xu(this.body,this.options.legend,"right",this.options.groups),this.show()},Tu.prototype.setOptions=function(t){if(t){void 0===t.graphHeight&&void 0!==t.height?(this.updateSVGheight=!0,this.updateSVGheightOnResize=!0):void 0!==this.body.domProps.centerContainer.height&&void 0!==t.graphHeight&&Nn((t.graphHeight+"").replace("px",""))<this.body.domProps.centerContainer.height&&(this.updateSVGheight=!0),za.selectiveDeepExtend(["sampling","defaultGroup","stack","height","graphHeight","yAxisOrientation","style","barChart","dataAxis","sort","groups"],this.options,t),za.mergeOptions(this.options,t,"interpolation"),za.mergeOptions(this.options,t,"drawPoints"),za.mergeOptions(this.options,t,"shaded"),za.mergeOptions(this.options,t,"legend"),t.interpolation&&"object"==zo(t.interpolation)&&t.interpolation.parametrization&&("uniform"==t.interpolation.parametrization?this.options.interpolation.alpha=0:"chordal"==t.interpolation.parametrization?this.options.interpolation.alpha=1:(this.options.interpolation.parametrization="centripetal",this.options.interpolation.alpha=.5)),this.yAxisLeft&&void 0!==t.dataAxis&&(this.yAxisLeft.setOptions(this.options.dataAxis),this.yAxisRight.setOptions(this.options.dataAxis)),this.legendLeft&&void 0!==t.legend&&(this.legendLeft.setOptions(this.options.legend),this.legendRight.setOptions(this.options.legend)),this.groups.hasOwnProperty("__ungrouped__")&&this.groups.__ungrouped__.setOptions(t)}this.dom.frame&&(this.forceGraphUpdate=!0,this.body.emitter.emit("_change",{queue:!0}))},Tu.prototype.hide=function(){this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame)},Tu.prototype.show=function(){this.dom.frame.parentNode||this.body.dom.center.appendChild(this.dom.frame)},Tu.prototype.setItems=function(t){var e,i=this,n=this.itemsData;if(t){if(!(t instanceof Aa||t instanceof Xa))throw new TypeError("Data must be an instance of DataSet or DataView");this.itemsData=Ua(t)}else this.itemsData=null;if(n&&(mn(za).call(za,this.itemListeners,(function(t,e){n.off(e,t)})),n.dispose(),e=n.getIds(),this._onRemove(e)),this.itemsData){var o=this.id;mn(za).call(za,this.itemListeners,(function(t,e){i.itemsData.on(e,t,o)})),e=this.itemsData.getIds(),this._onAdd(e)}},Tu.prototype.setGroups=function(t){var e,i=this;if(this.groupsData){mn(za).call(za,this.groupListeners,(function(t,e){i.groupsData.off(e,t)})),e=this.groupsData.getIds(),this.groupsData=null;for(var n=0;n<e.length;n++)this._removeGroup(e[n])}if(t){if(!(t instanceof Aa||t instanceof Xa))throw new TypeError("Data must be an instance of DataSet or DataView");this.groupsData=t}else this.groupsData=null;if(this.groupsData){var o=this.id;mn(za).call(za,this.groupListeners,(function(t,e){i.groupsData.on(e,t,o)})),e=this.groupsData.getIds(),this._onAddGroups(e)}},Tu.prototype._onUpdate=function(t){this._updateAllGroupData(t)},Tu.prototype._onAdd=function(t){this._onUpdate(t)},Tu.prototype._onRemove=function(t){this._onUpdate(t)},Tu.prototype._onUpdateGroups=function(t){this._updateAllGroupData(null,t)},Tu.prototype._onAddGroups=function(t){this._onUpdateGroups(t)},Tu.prototype._onRemoveGroups=function(t){for(var e=0;e<t.length;e++)this._removeGroup(t[e]);this.forceGraphUpdate=!0,this.body.emitter.emit("_change",{queue:!0})},Tu.prototype._removeGroup=function(t){this.groups.hasOwnProperty(t)&&("right"==this.groups[t].options.yAxisOrientation?(this.yAxisRight.removeGroup(t),this.legendRight.removeGroup(t),this.legendRight.redraw()):(this.yAxisLeft.removeGroup(t),this.legendLeft.removeGroup(t),this.legendLeft.redraw()),delete this.groups[t])},Tu.prototype._updateGroup=function(t,e){this.groups.hasOwnProperty(e)?(this.groups[e].update(t),"right"==this.groups[e].options.yAxisOrientation?(this.yAxisRight.updateGroup(e,this.groups[e]),this.legendRight.updateGroup(e,this.groups[e]),this.yAxisLeft.removeGroup(e),this.legendLeft.removeGroup(e)):(this.yAxisLeft.updateGroup(e,this.groups[e]),this.legendLeft.updateGroup(e,this.groups[e]),this.yAxisRight.removeGroup(e),this.legendRight.removeGroup(e))):(this.groups[e]=new Au(t,e,this.options,this.groupsUsingDefaultStyles),"right"==this.groups[e].options.yAxisOrientation?(this.yAxisRight.addGroup(e,this.groups[e]),this.legendRight.addGroup(e,this.groups[e])):(this.yAxisLeft.addGroup(e,this.groups[e]),this.legendLeft.addGroup(e,this.groups[e]))),this.legendLeft.redraw(),this.legendRight.redraw()},Tu.prototype._updateAllGroupData=function(t,e){if(null!=this.itemsData){var i={},n=this.itemsData.get(),o=this.itemsData.idProp,s={};t&&Ln(t).call(t,(function(t){s[t]=t}));for(var r={},a=0;a<n.length;a++){var l=n[a],h=l.group;null==h&&(h="__ungrouped__"),r.hasOwnProperty(h)?r[h]++:r[h]=1}var d={};if(!e&&t)for(h in this.groups)if(this.groups.hasOwnProperty(h)){var u=(f=this.groups[h]).getItems();i[h]=En(u).call(u,(function(t){return d[t[o]]=t[o],t[o]!==s[t[o]]}));var c=r[h];r[h]-=i[h].length,i[h].length<c&&(i[h][c-1]={})}for(a=0;a<n.length;a++)if(null==(h=(l=n[a]).group)&&(h="__ungrouped__"),e||!t||l[o]===s[l[o]]||!d.hasOwnProperty(l[o])){i.hasOwnProperty(h)||(i[h]=new Array(r[h]));var p=za.bridgeObject(l);p.x=za.convert(l.x,"Date"),p.end=za.convert(l.end,"Date"),p.orginalY=l.y,p.y=Number(l.y),p[o]=l[o];var m=i[h].length-r[h]--;i[h][m]=p}for(h in this.groups)this.groups.hasOwnProperty(h)&&(i.hasOwnProperty(h)||(i[h]=new Array(0)));for(h in i)if(i.hasOwnProperty(h))if(0==i[h].length)this.groups.hasOwnProperty(h)&&this._removeGroup(h);else{var f=void 0;null!=this.groupsData&&(f=this.groupsData.get(h)),null==f&&(f={id:h,content:this.options.defaultGroup+h}),this._updateGroup(f,h),this.groups[h].setItems(i[h])}this.forceGraphUpdate=!0,this.body.emitter.emit("_change",{queue:!0})}},Tu.prototype.redraw=function(){var t=!1;this.props.width=this.dom.frame.offsetWidth,this.props.height=this.body.domProps.centerContainer.height-this.body.domProps.border.top-this.body.domProps.border.bottom,t=this._isResized()||t;var e,i=this.body.range.end-this.body.range.start,n=i!=this.lastVisibleInterval;(this.lastVisibleInterval=i,1==t)&&(this.svg.style.width=za.option.asSize(3*this.props.width),this.svg.style.left=za.option.asSize(-this.props.width),-1==Fo(e=this.options.height+"").call(e,"%")&&1!=this.updateSVGheightOnResize||(this.updateSVGheight=!0));if(1==this.updateSVGheight?(this.options.graphHeight!=this.props.height+"px"&&(this.options.graphHeight=this.props.height+"px",this.svg.style.height=this.props.height+"px"),this.updateSVGheight=!1):this.svg.style.height=(""+this.options.graphHeight).replace("px","")+"px",1==t||1==n||1==this.abortedGraphUpdate||1==this.forceGraphUpdate)t=this._updateGraph()||t,this.forceGraphUpdate=!1;else if(0!=this.lastStart){var o=this.body.range.start-this.lastStart,s=this.body.range.end-this.body.range.start;if(0!=this.props.width){var r=o*(this.props.width/s);this.svg.style.left=-this.props.width-r+"px"}}return this.legendLeft.redraw(),this.legendRight.redraw(),t},Tu.prototype._getSortedGroupIds=function(){var t=[];for(var e in this.groups)if(this.groups.hasOwnProperty(e)){var i=this.groups[e];1!=i.visible||void 0!==this.options.groups.visibility[e]&&1!=this.options.groups.visibility[e]||t.push({id:e,zIndex:i.options.zIndex})}za.insertSort(t,(function(t,e){var i=t.zIndex,n=e.zIndex;return void 0===i&&(i=0),void 0===n&&(n=0),i==n?0:i<n?-1:1}));for(var n=new Array(t.length),o=0;o<t.length;o++)n[o]=t[o].id;return n},Tu.prototype._updateGraph=function(){if(Cs(this.svgElements),0!=this.props.width&&null!=this.itemsData){var t,e,i={},n=this.body.util.toGlobalTime(-this.body.domProps.root.width),o=this.body.util.toGlobalTime(2*this.body.domProps.root.width),s=this._getSortedGroupIds();if(s.length>0){var r={};for(this._getRelevantData(s,r,n,o),this._applySampling(s,r),e=0;e<s.length;e++)this._convertXcoordinates(r[s[e]]);if(this._getYRanges(s,r,i),1==this._updateYAxis(s,i))return Ls(this.svgElements),this.abortedGraphUpdate=!0,!0;this.abortedGraphUpdate=!1;var a=void 0;for(e=0;e<s.length;e++)t=this.groups[s[e]],!0===this.options.stack&&"line"===this.options.style&&(null!=t.options.excludeFromStacking&&t.options.excludeFromStacking||(null!=a&&(this._stack(r[t.id],r[a.id]),1==t.options.shaded.enabled&&"group"!==t.options.shaded.orientation&&("top"==t.options.shaded.orientation&&"group"!==a.options.shaded.orientation?(a.options.shaded.orientation="group",a.options.shaded.groupId=t.id):(t.options.shaded.orientation="group",t.options.shaded.groupId=a.id))),a=t)),this._convertYcoordinates(r[s[e]],t);var l={};for(e=0;e<s.length;e++)if("line"===(t=this.groups[s[e]]).options.style&&1==t.options.shaded.enabled){var h=r[s[e]];if(null==h||0==h.length)continue;if(l.hasOwnProperty(s[e])||(l[s[e]]=Wu.calcPath(h,t)),"group"===t.options.shaded.orientation){var d=t.options.shaded.groupId;if(-1===Fo(s).call(s,d)){console.log(t.id+": Unknown shading group target given:"+d);continue}l.hasOwnProperty(d)||(l[d]=Wu.calcPath(r[d],this.groups[d])),Wu.drawShading(l[s[e]],t,l[d],this.framework)}else Wu.drawShading(l[s[e]],t,void 0,this.framework)}for(Ou.draw(s,r,this.framework),e=0;e<s.length;e++)if(t=this.groups[s[e]],r[s[e]].length>0)switch(t.options.style){case"line":l.hasOwnProperty(s[e])||(l[s[e]]=Wu.calcPath(r[s[e]],t)),Wu.draw(l[s[e]],t,this.framework);case"point":case"points":"point"!=t.options.style&&"points"!=t.options.style&&1!=t.options.drawPoints.enabled||Zu.draw(r[s[e]],t,this.framework)}}}return Ls(this.svgElements),!1},Tu.prototype._stack=function(t,e){var i,n,o,s,r;i=0;for(var a=0;a<t.length;a++){s=void 0,r=void 0;for(var l=i;l<e.length;l++){if(e[l].x===t[a].x){s=e[l],r=e[l],i=l;break}if(e[l].x>t[a].x){r=e[l],s=0==l?r:e[l-1],i=l;break}}void 0===r&&(s=e[e.length-1],r=e[e.length-1]),n=r.x-s.x,o=r.y-s.y,t[a].y=0==n?t[a].orginalY+r.y:t[a].orginalY+o/n*(t[a].x-s.x)+s.y}},Tu.prototype._getRelevantData=function(t,e,i,n){var o,s,r,a;if(t.length>0)for(s=0;s<t.length;s++){var l=(o=this.groups[t[s]]).getItems();if(1==wr(o.options)){var h=function(t,e){return t.getTime()==e.getTime()?0:t<e?-1:1},d=Math.max(0,za.binarySearchValue(l,i,"x","before",h)),u=Math.min(l.length,za.binarySearchValue(l,n,"x","after",h)+1);u<=0&&(u=l.length);var c=new Array(u-d);for(r=d;r<u;r++)a=o.itemsData[r],c[r-d]=a;e[t[s]]=c}else e[t[s]]=o.itemsData}},Tu.prototype._applySampling=function(t,e){if(t.length>0)for(var i=0;i<t.length;i++)if(1==this.groups[t[i]].options.sampling){var n=e[t[i]];if(n.length>0){var o,s=n.length,r=s/(this.body.util.toGlobalScreen(n[n.length-1].x)-this.body.util.toGlobalScreen(n[0].x));o=Math.min(Math.ceil(.2*s),Math.max(1,Math.round(r)));for(var a=new Array(s),l=0;l<s;l+=o){a[Math.round(l/o)]=n[l]}e[t[i]]=Hr(a).call(a,0,Math.round(s/o))}}},Tu.prototype._getYRanges=function(t,e,i){var n,o,s,r,a=[],l=[];if(t.length>0){for(s=0;s<t.length;s++)n=e[t[s]],r=this.groups[t[s]].options,n.length>0&&(o=this.groups[t[s]],!0===r.stack&&"bar"===r.style?"left"===r.yAxisOrientation?a=Pn(a).call(a,n):l=Pn(l).call(l,n):i[t[s]]=o.getYRange(n,t[s]));Ou.getStackedYRange(a,i,t,"__barStackLeft","left"),Ou.getStackedYRange(l,i,t,"__barStackRight","right")}},Tu.prototype._updateYAxis=function(t,e){var i,n,o=!1,s=!1,r=!1,a=1e9,l=1e9,h=-1e9,d=-1e9;if(t.length>0){for(var u=0;u<t.length;u++){var c=this.groups[t[u]];c&&"right"!=c.options.yAxisOrientation?(s=!0,a=1e9,h=-1e9):c&&c.options.yAxisOrientation&&(r=!0,l=1e9,d=-1e9)}for(u=0;u<t.length;u++)e.hasOwnProperty(t[u])&&!0!==e[t[u]].ignore&&(i=e[t[u]].min,n=e[t[u]].max,"right"!=e[t[u]].yAxisOrientation?(s=!0,a=a>i?i:a,h=h<n?n:h):(r=!0,l=l>i?i:l,d=d<n?n:d));1==s&&this.yAxisLeft.setRange(a,h),1==r&&this.yAxisRight.setRange(l,d)}o=this._toggleAxisVisiblity(s,this.yAxisLeft)||o,o=this._toggleAxisVisiblity(r,this.yAxisRight)||o,1==r&&1==s?(this.yAxisLeft.drawIcons=!0,this.yAxisRight.drawIcons=!0):(this.yAxisLeft.drawIcons=!1,this.yAxisRight.drawIcons=!1),this.yAxisRight.master=!s,this.yAxisRight.masterAxis=this.yAxisLeft,0==this.yAxisRight.master?(this.yAxisLeft.lineOffset=1==r?this.yAxisRight.width:0,o=this.yAxisLeft.redraw()||o,o=this.yAxisRight.redraw()||o):o=this.yAxisRight.redraw()||o;var p=["__barStackLeft","__barStackRight","__lineStackLeft","__lineStackRight"];for(u=0;u<p.length;u++)-1!=Fo(t).call(t,p[u])&&Hr(t).call(t,Fo(t).call(t,p[u]),1);return o},Tu.prototype._toggleAxisVisiblity=function(t,e){var i=!1;return 0==t?e.dom.frame.parentNode&&0==e.hidden&&(e.hide(),i=!0):e.dom.frame.parentNode||1!=e.hidden||(e.show(),i=!0),i},Tu.prototype._convertXcoordinates=function(t){for(var e=this.body.util.toScreen,i=0;i<t.length;i++)t[i].screen_x=e(t[i].x)+this.props.width,t[i].screen_y=t[i].y,null!=t[i].end?t[i].screen_end=e(t[i].end)+this.props.width:t[i].screen_end=void 0},Tu.prototype._convertYcoordinates=function(t,e){var i=this.yAxisLeft,n=Number(this.svg.style.height.replace("px",""));"right"==e.options.yAxisOrientation&&(i=this.yAxisRight);for(var o=0;o<t.length;o++)t[o].screen_y=Math.round(i.convertValue(t[o].y));e.setZeroPosition(Math.min(n,i.convertValue(0)))};var Yu="boolean",Eu={configure:{enabled:{boolean:Yu},filter:{boolean:Yu,function:"function"},container:{dom:"dom"},__type__:{object:"object",boolean:Yu,function:"function"}},alignCurrentTime:{string:"string",undefined:"undefined"},yAxisOrientation:{string:["left","right"]},defaultGroup:{string:"string"},sort:{boolean:Yu},sampling:{boolean:Yu},stack:{boolean:Yu},graphHeight:{string:"string",number:"number"},shaded:{enabled:{boolean:Yu},orientation:{string:["bottom","top","zero","group"]},groupId:{object:"object"},__type__:{boolean:Yu,object:"object"}},style:{string:["line","bar","points"]},barChart:{width:{number:"number"},minWidth:{number:"number"},sideBySide:{boolean:Yu},align:{string:["left","center","right"]},__type__:{object:"object"}},interpolation:{enabled:{boolean:Yu},parametrization:{string:["centripetal","chordal","uniform"]},alpha:{number:"number"},__type__:{object:"object",boolean:Yu}},drawPoints:{enabled:{boolean:Yu},onRender:{function:"function"},size:{number:"number"},style:{string:["square","circle"]},__type__:{object:"object",boolean:Yu,function:"function"}},dataAxis:{showMinorLabels:{boolean:Yu},showMajorLabels:{boolean:Yu},showWeekScale:{boolean:Yu},icons:{boolean:Yu},width:{string:"string",number:"number"},visible:{boolean:Yu},alignZeros:{boolean:Yu},left:{range:{min:{number:"number",undefined:"undefined"},max:{number:"number",undefined:"undefined"},__type__:{object:"object"}},format:{function:"function"},title:{text:{string:"string",number:"number",undefined:"undefined"},style:{string:"string",undefined:"undefined"},__type__:{object:"object"}},__type__:{object:"object"}},right:{range:{min:{number:"number",undefined:"undefined"},max:{number:"number",undefined:"undefined"},__type__:{object:"object"}},format:{function:"function"},title:{text:{string:"string",number:"number",undefined:"undefined"},style:{string:"string",undefined:"undefined"},__type__:{object:"object"}},__type__:{object:"object"}},__type__:{object:"object"}},legend:{enabled:{boolean:Yu},icons:{boolean:Yu},left:{visible:{boolean:Yu},position:{string:["top-right","bottom-right","top-left","bottom-left"]},__type__:{object:"object"}},right:{visible:{boolean:Yu},position:{string:["top-right","bottom-right","top-left","bottom-left"]},__type__:{object:"object"}},__type__:{object:"object",boolean:Yu}},groups:{visibility:{any:"any"},__type__:{object:"object"}},autoResize:{boolean:Yu},throttleRedraw:{number:"number"},clickToUse:{boolean:Yu},end:{number:"number",date:"date",string:"string",moment:"moment"},format:{minorLabels:{millisecond:{string:"string",undefined:"undefined"},second:{string:"string",undefined:"undefined"},minute:{string:"string",undefined:"undefined"},hour:{string:"string",undefined:"undefined"},weekday:{string:"string",undefined:"undefined"},day:{string:"string",undefined:"undefined"},week:{string:"string",undefined:"undefined"},month:{string:"string",undefined:"undefined"},quarter:{string:"string",undefined:"undefined"},year:{string:"string",undefined:"undefined"},__type__:{object:"object"}},majorLabels:{millisecond:{string:"string",undefined:"undefined"},second:{string:"string",undefined:"undefined"},minute:{string:"string",undefined:"undefined"},hour:{string:"string",undefined:"undefined"},weekday:{string:"string",undefined:"undefined"},day:{string:"string",undefined:"undefined"},week:{string:"string",undefined:"undefined"},month:{string:"string",undefined:"undefined"},quarter:{string:"string",undefined:"undefined"},year:{string:"string",undefined:"undefined"},__type__:{object:"object"}},__type__:{object:"object"}},moment:{function:"function"},height:{string:"string",number:"number"},hiddenDates:{start:{date:"date",number:"number",string:"string",moment:"moment"},end:{date:"date",number:"number",string:"string",moment:"moment"},repeat:{string:"string"},__type__:{object:"object",array:"array"}},locale:{string:"string"},locales:{__any__:{any:"any"},__type__:{object:"object"}},max:{date:"date",number:"number",string:"string",moment:"moment"},maxHeight:{number:"number",string:"string"},maxMinorChars:{number:"number"},min:{date:"date",number:"number",string:"string",moment:"moment"},minHeight:{number:"number",string:"string"},moveable:{boolean:Yu},multiselect:{boolean:Yu},orientation:{string:"string"},showCurrentTime:{boolean:Yu},showMajorLabels:{boolean:Yu},showMinorLabels:{boolean:Yu},showWeekScale:{boolean:Yu},start:{date:"date",number:"number",string:"string",moment:"moment"},timeAxis:{scale:{string:"string",undefined:"undefined"},step:{number:"number",undefined:"undefined"},__type__:{object:"object"}},width:{string:"string",number:"number"},zoomable:{boolean:Yu},zoomKey:{string:["ctrlKey","altKey","metaKey",""]},zoomMax:{number:"number"},zoomMin:{number:"number"},zIndex:{number:"number"},__type__:{object:"object"}},Ru={global:{alignCurrentTime:["none","year","month","quarter","week","isoWeek","day","date","hour","minute","second"],sort:!0,sampling:!0,stack:!1,shaded:{enabled:!1,orientation:["zero","top","bottom","group"]},style:["line","bar","points"],barChart:{width:[50,5,100,5],minWidth:[50,5,100,5],sideBySide:!1,align:["left","center","right"]},interpolation:{enabled:!0,parametrization:["centripetal","chordal","uniform"]},drawPoints:{enabled:!0,size:[6,2,30,1],style:["square","circle"]},dataAxis:{showMinorLabels:!0,showMajorLabels:!0,showWeekScale:!1,icons:!1,width:[40,0,200,1],visible:!0,alignZeros:!0,left:{title:{text:"",style:""}},right:{title:{text:"",style:""}}},legend:{enabled:!1,icons:!0,left:{visible:!0,position:["top-right","bottom-right","top-left","bottom-left"]},right:{visible:!0,position:["top-right","bottom-right","top-left","bottom-left"]}},autoResize:!0,clickToUse:!1,end:"",format:{minorLabels:{millisecond:"SSS",second:"s",minute:"HH:mm",hour:"HH:mm",weekday:"ddd D",day:"D",week:"w",month:"MMM",quarter:"[Q]Q",year:"YYYY"},majorLabels:{millisecond:"HH:mm:ss",second:"D MMMM HH:mm",minute:"ddd D MMMM",hour:"ddd D MMMM",weekday:"MMMM YYYY",day:"MMMM YYYY",week:"MMMM YYYY",month:"YYYY",quarter:"YYYY",year:""}},height:"",locale:"",max:"",maxHeight:"",maxMinorChars:[7,0,20,1],min:"",minHeight:"",moveable:!0,orientation:["both","bottom","top"],showCurrentTime:!1,showMajorLabels:!0,showMinorLabels:!0,showWeekScale:!1,start:"",width:"100%",zoomable:!0,zoomKey:["ctrlKey","altKey","metaKey",""],zoomMax:[31536e10,10,31536e10,1],zoomMin:[10,10,31536e10,1],zIndex:0}};function Uu(t,e,i,n){var o,s,r,a,l,h,d;if(!(Zo(i)||i instanceof Aa||i instanceof Xa)&&i instanceof Object){var u=n;n=i,i=u}n&&n.throttleRedraw&&console.warn('Graph2d option "throttleRedraw" is DEPRICATED and no longer supported. It will be removed in the next MAJOR release.');var c=this;this.defaultOptions={start:null,end:null,autoResize:!0,orientation:{axis:"bottom",item:"bottom"},moment:Ta,width:null,height:null,maxHeight:null,minHeight:null},this.options=za.deepExtend({},this.defaultOptions),this._create(t),this.components=[],this.body={dom:this.dom,domProps:this.props,emitter:{on:va(o=this.on).call(o,this),off:va(s=this.off).call(s,this),emit:va(r=this.emit).call(r,this)},hiddenDates:[],util:{toScreen:va(a=c._toScreen).call(a,c),toGlobalScreen:va(l=c._toGlobalScreen).call(l,c),toTime:va(h=c._toTime).call(h,c),toGlobalTime:va(d=c._toGlobalTime).call(d,c)}},this.range=new ml(this.body),this.components.push(this.range),this.body.range=this.range,this.timeAxis=new Jh(this.body),this.components.push(this.timeAxis),this.currentTime=new pd(this.body),this.components.push(this.currentTime),this.linegraph=new Tu(this.body),this.components.push(this.linegraph),this.itemsData=null,this.groupsData=null,this.on("tap",(function(t){c.emit("click",c.getEventProperties(t))})),this.on("doubletap",(function(t){c.emit("doubleClick",c.getEventProperties(t))})),this.dom.root.oncontextmenu=function(t){c.emit("contextmenu",c.getEventProperties(t))},this.initialFitDone=!1,this.on("changed",(function(){if(null!=c.itemsData){if(!c.initialFitDone&&!c.options.rollingMode)if(c.initialFitDone=!0,null!=c.options.start||null!=c.options.end){if(null==c.options.start||null==c.options.end)var t=c.getItemRange();var e=null!=c.options.start?c.options.start:t.min,i=null!=c.options.end?c.options.end:t.max;c.setWindow(e,i,{animation:!1})}else c.fit({animation:!1});c.initialDrawDone||!c.initialRangeChangeDone&&(c.options.start||c.options.end)&&!c.options.rollingMode||(c.initialDrawDone=!0,c.dom.root.style.visibility="visible",c.dom.loadingScreen.parentNode.removeChild(c.dom.loadingScreen),c.options.onInitialDrawComplete&&qr((function(){return c.options.onInitialDrawComplete()}),0))}})),n&&this.setOptions(n),i&&this.setGroups(i),e&&this.setItems(e),this._redraw()}Uu.prototype=new cd,Uu.prototype.setOptions=function(t){!0===fu.validate(t,Eu)&&console.log("%cErrors have been found in the supplied options object.",mu),cd.prototype.setOptions.call(this,t)},Uu.prototype.setItems=function(t){var e,i=null==this.itemsData;if(e=t?Ua(t instanceof Aa||t instanceof Xa?t:new Aa(t)):null,this.itemsData&&this.itemsData.dispose(),this.itemsData=e,this.linegraph&&this.linegraph.setItems(null!=e?e.rawDS:null),i)if(null!=this.options.start||null!=this.options.end){var n=null!=this.options.start?this.options.start:null,o=null!=this.options.end?this.options.end:null;this.setWindow(n,o,{animation:!1})}else this.fit({animation:!1})},Uu.prototype.setGroups=function(t){var e;e=t?t instanceof Aa||t instanceof Xa?t:new Aa(t):null,this.groupsData=e,this.linegraph.setGroups(e)},Uu.prototype.getLegend=function(t,e,i){return void 0===e&&(e=15),void 0===i&&(i=15),void 0!==this.linegraph.groups[t]?this.linegraph.groups[t].getLegend(e,i):"cannot find group:'"+t+"'"},Uu.prototype.isGroupVisible=function(t){return void 0!==this.linegraph.groups[t]&&(this.linegraph.groups[t].visible&&(void 0===this.linegraph.options.groups.visibility[t]||1==this.linegraph.options.groups.visibility[t]))},Uu.prototype.getDataRange=function(){var t=null,e=null;for(var i in this.linegraph.groups)if(this.linegraph.groups.hasOwnProperty(i)&&1==this.linegraph.groups[i].visible)for(var n=0;n<this.linegraph.groups[i].itemsData.length;n++){var o=this.linegraph.groups[i].itemsData[n],s=za.convert(o.x,"Date").valueOf();t=null==t||t>s?s:t,e=null==e||e<s?s:e}return{min:null!=t?new Date(t):null,max:null!=e?new Date(e):null}},Uu.prototype.getEventProperties=function(t){var e=t.center?t.center.x:t.clientX,i=t.center?t.center.y:t.clientY,n=e-za.getAbsoluteLeft(this.dom.centerContainer),o=i-za.getAbsoluteTop(this.dom.centerContainer),s=this._toTime(n),r=ud.customTimeFromTarget(t),a=za.getTarget(t),l=null;za.hasParent(a,this.timeAxis.dom.foreground)||this.timeAxis2&&za.hasParent(a,this.timeAxis2.dom.foreground)?l="axis":za.hasParent(a,this.linegraph.yAxisLeft.dom.frame)||za.hasParent(a,this.linegraph.yAxisRight.dom.frame)?l="data-axis":za.hasParent(a,this.linegraph.legendLeft.dom.frame)||za.hasParent(a,this.linegraph.legendRight.dom.frame)?l="legend":null!=r?l="custom-time":za.hasParent(a,this.currentTime.bar)?l="current-time":za.hasParent(a,this.dom.center)&&(l="background");var h=[],d=this.linegraph.yAxisLeft,u=this.linegraph.yAxisRight;return!d.hidden&&this.itemsData.length>0&&h.push(d.screenToValue(o)),!u.hidden&&this.itemsData.length>0&&h.push(u.screenToValue(o)),{event:t,customTime:r?r.options.id:null,what:l,pageX:t.srcEvent?t.srcEvent.pageX:t.pageX,pageY:t.srcEvent?t.srcEvent.pageY:t.pageY,x:n,y:o,time:s,value:h}},Uu.prototype._createConfigurator=function(){return new Lu(this,this.dom.container,Ru)};var zu=Fs();Ta.locale(zu);var Vu={Core:cd,DateUtil:pl,Range:ml,stack:zd,TimeStep:Hh,components:{items:{Item:Pd,BackgroundItem:$d,BoxItem:Jd,PointItem:Kd,RangeItem:qd},BackgroundGroup:Hd,Component:Ja,CurrentTime:pd,CustomTime:ud,DataAxis:Fu,DataScale:Nu,GraphGroup:Au,Group:jd,ItemSet:uu,Legend:Xu,LineGraph:Tu,TimeAxis:Jh}};t.DOMutil=Zs,t.DataSet=Aa,t.DataView=Xa,t.Graph2d=Uu,t.Hammer=Vh,t.Queue=Za,t.Timeline=Gu,t.keycharm=qh,t.moment=Ta,t.timeline=Vu,t.util=Is,Object.defineProperty(t,"__esModule",{value:!0})}));
//# sourceMappingURL=vis-timeline-graph2d.min.js.map
