// Licensed to the Apache Software Foundation (ASF) under one 
// or more contributor license agreements.  See the NOTICE file 
// distributed with this work for additional information 
// regarding copyright ownership.  The ASF licenses this file 
// to you under the Apache License, Version 2.0 (the 
// "License"); you may not use this file except in compliance 
// with the License.  You may obtain a copy of the License at 
// 
//  http://www.apache.org/licenses/LICENSE-2.0
// 
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

// This is a generated file, DO NOT EDIT.
// To add new functions, see the generator at
// common/function-registry/gen_builtins_catalog.py or the function list at
// common/function-registry/doris_builtins_functions.py.

package org.apache.doris.builtins;

import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.Type;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSet;
import com.google.common.collect.Sets;
import java.util.Set;

public class ScalarBuiltins { 
    public static void initBuiltins(FunctionSet functionSet) { 
        functionSet.addScalarAndVectorizedBuiltin("bitand", "_ZN5doris9Operators32bitand_tiny_int_val_tiny_int_valEPN9doris_udf15FunctionContextERKNS1_10TinyIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.TINYINT, false, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("bitand", "_ZN5doris9Operators34bitand_small_int_val_small_int_valEPN9doris_udf15FunctionContextERKNS1_11SmallIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.SMALLINT, false, Type.SMALLINT, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("bitand", "_ZN5doris9Operators22bitand_int_val_int_valEPN9doris_udf15FunctionContextERKNS1_6IntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("bitand", "_ZN5doris9Operators30bitand_big_int_val_big_int_valEPN9doris_udf15FunctionContextERKNS1_9BigIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bitand", "_ZN5doris9Operators34bitand_large_int_val_large_int_valEPN9doris_udf15FunctionContextERKNS1_11LargeIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, false, Type.LARGEINT, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("bitor", "_ZN5doris9Operators31bitor_tiny_int_val_tiny_int_valEPN9doris_udf15FunctionContextERKNS1_10TinyIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.TINYINT, false, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("bitor", "_ZN5doris9Operators33bitor_small_int_val_small_int_valEPN9doris_udf15FunctionContextERKNS1_11SmallIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.SMALLINT, false, Type.SMALLINT, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("bitor", "_ZN5doris9Operators21bitor_int_val_int_valEPN9doris_udf15FunctionContextERKNS1_6IntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("bitor", "_ZN5doris9Operators29bitor_big_int_val_big_int_valEPN9doris_udf15FunctionContextERKNS1_9BigIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bitor", "_ZN5doris9Operators33bitor_large_int_val_large_int_valEPN9doris_udf15FunctionContextERKNS1_11LargeIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, false, Type.LARGEINT, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("bitxor", "_ZN5doris9Operators32bitxor_tiny_int_val_tiny_int_valEPN9doris_udf15FunctionContextERKNS1_10TinyIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.TINYINT, false, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("bitxor", "_ZN5doris9Operators34bitxor_small_int_val_small_int_valEPN9doris_udf15FunctionContextERKNS1_11SmallIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.SMALLINT, false, Type.SMALLINT, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("bitxor", "_ZN5doris9Operators22bitxor_int_val_int_valEPN9doris_udf15FunctionContextERKNS1_6IntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("bitxor", "_ZN5doris9Operators30bitxor_big_int_val_big_int_valEPN9doris_udf15FunctionContextERKNS1_9BigIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bitxor", "_ZN5doris9Operators34bitxor_large_int_val_large_int_valEPN9doris_udf15FunctionContextERKNS1_11LargeIntValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, false, Type.LARGEINT, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("bitnot", "_ZN5doris9Operators19bitnot_tiny_int_valEPN9doris_udf15FunctionContextERKNS1_10TinyIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.TINYINT, false, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("bitnot", "_ZN5doris9Operators20bitnot_small_int_valEPN9doris_udf15FunctionContextERKNS1_11SmallIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.SMALLINT, false, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("bitnot", "_ZN5doris9Operators14bitnot_int_valEPN9doris_udf15FunctionContextERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("bitnot", "_ZN5doris9Operators18bitnot_big_int_valEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bitnot", "_ZN5doris9Operators20bitnot_large_int_valEPN9doris_udf15FunctionContextERKNS1_11LargeIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, false, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.ARRAY, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.BOOLEAN), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.BOOLEAN), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TINYINT, false, new ArrayType(Type.TINYINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TINYINT, false, new ArrayType(Type.TINYINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.SMALLINT, false, new ArrayType(Type.SMALLINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.SMALLINT, false, new ArrayType(Type.SMALLINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, new ArrayType(Type.INT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, new ArrayType(Type.INT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BIGINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BIGINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.LARGEINT, false, new ArrayType(Type.LARGEINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.LARGEINT, false, new ArrayType(Type.LARGEINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, new ArrayType(Type.DATETIME), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, new ArrayType(Type.DATETIME), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, new ArrayType(Type.DATE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, new ArrayType(Type.DATE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, new ArrayType(Type.DATETIMEV2), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, new ArrayType(Type.DATETIMEV2), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, new ArrayType(Type.DATEV2), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, new ArrayType(Type.DATEV2), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.FLOAT, false, new ArrayType(Type.FLOAT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.FLOAT, false, new ArrayType(Type.FLOAT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.DOUBLE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.DOUBLE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.MAX_DECIMALV2_TYPE, false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.MAX_DECIMALV2_TYPE, false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, new ArrayType(Type.VARCHAR), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, new ArrayType(Type.VARCHAR), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("element_at", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, new ArrayType(Type.STRING), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_extract%", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, new ArrayType(Type.STRING), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.BOOLEAN), new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.TINYINT), new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.SMALLINT), new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.INT), new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.BIGINT), new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.LARGEINT), new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DATETIME), new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DATE), new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DATETIMEV2), new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DATEV2), new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.FLOAT), new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DOUBLE), new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.MAX_DECIMALV2_TYPE), new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.VARCHAR), new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("arrays_overlap", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.STRING), new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.BOOLEAN), Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.TINYINT), Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.SMALLINT), Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.INT), Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.BIGINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.LARGEINT), Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DATETIME), Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DATE), Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DATETIMEV2), Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DATEV2), Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.FLOAT), Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.DOUBLE), Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.VARCHAR), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_contains", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.STRING), Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("array_enumerate", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BOOLEAN), Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.TINYINT), Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.SMALLINT), Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.INT), Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BIGINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.LARGEINT), Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DATETIME), Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DATE), Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DATETIMEV2), Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DATEV2), Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.FLOAT), Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DOUBLE), Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.VARCHAR), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("countequal", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.STRING), Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BOOLEAN), Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.TINYINT), Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.SMALLINT), Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.INT), Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BIGINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.LARGEINT), Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DATETIME), Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DATE), Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DATETIMEV2), Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DATEV2), Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.FLOAT), Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.DOUBLE), Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.VARCHAR), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_position", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.STRING), Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("cardinality", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.ARRAY);
        functionSet.addScalarAndVectorizedBuiltin("size", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.ARRAY);
        functionSet.addScalarAndVectorizedBuiltin("array_size", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.ARRAY);
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIMEV2), false, new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATEV2), false, new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("array_distinct", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("array_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIMEV2), false, new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATEV2), false, new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("array_sort", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.BOOLEAN), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.TINYINT), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.SMALLINT), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.INT), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.BIGINT), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.LARGEINT), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DATETIME), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DATE), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DATETIMEV2), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DATEV2), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.FLOAT), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DOUBLE), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.VARCHAR), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.STRING), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.BOOLEAN), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.TINYINT), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.SMALLINT), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.INT), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.BIGINT), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.LARGEINT), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DATETIME), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DATE), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DATETIMEV2), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DATEV2), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.FLOAT), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.DOUBLE), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.VARCHAR), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_join", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, new ArrayType(Type.STRING), Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TINYINT, false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.SMALLINT, false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.LARGEINT, false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.FLOAT, false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.MAX_DECIMALV2_TYPE, false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_min", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TINYINT, false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.SMALLINT, false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.LARGEINT, false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.FLOAT, false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.MAX_DECIMALV2_TYPE, false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_max", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_sum", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_sum", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_sum", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_sum", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_sum", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_sum", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.LARGEINT, false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_sum", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_sum", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_sum", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.MAX_DECIMALV2_TYPE, false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_avg", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_avg", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_avg", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_avg", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_avg", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_avg", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_avg", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_avg", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_avg", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.MAX_DECIMALV2_TYPE, false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_product", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_product", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_product", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_product", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_product", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_product", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_product", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_product", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_product", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.MAX_DECIMALV2_TYPE, false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN), Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT), Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT), Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT), Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT), Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT), Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE), Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME), Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE), Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIMEV2), false, new ArrayType(Type.DATETIMEV2), Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATEV2), false, new ArrayType(Type.DATEV2), Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR), Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_remove", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING), Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN), new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT), new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT), new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT), new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT), new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT), new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT), new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE), new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE), new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME), new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE), new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIMEV2), false, new ArrayType(Type.DATETIMEV2), new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATEV2), false, new ArrayType(Type.DATEV2), new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR), new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("array_union", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING), new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN), new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT), new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT), new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT), new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT), new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT), new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT), new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE), new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE), new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME), new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE), new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIMEV2), false, new ArrayType(Type.DATETIMEV2), new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATEV2), false, new ArrayType(Type.DATEV2), new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR), new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("array_except", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING), new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIMEV2), false, new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATEV2), false, new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_compact", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN), new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT), new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT), new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT), new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT), new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT), new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT), new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE), new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE), new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME), new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE), new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIMEV2), false, new ArrayType(Type.DATETIMEV2), new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATEV2), false, new ArrayType(Type.DATEV2), new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR), new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("array_intersect", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING), new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING), Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_slice", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("%element_slice%", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING), Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BOOLEAN), false, new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("array_popback", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.BOOLEAN), false, Type.BIGINT, Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.TINYINT), false, Type.BIGINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.SMALLINT), false, Type.BIGINT, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.INT), false, Type.BIGINT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.BIGINT), false, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.LARGEINT), false, Type.BIGINT, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.DATETIME), false, Type.BIGINT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.DATE), false, Type.BIGINT, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.FLOAT), false, Type.BIGINT, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.DOUBLE), false, Type.BIGINT, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, Type.BIGINT, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.VARCHAR), false, Type.BIGINT, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("array_with_constant", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.STRING), false, Type.BIGINT, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("array_range", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, new ArrayType(Type.INT), false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("array_range", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, new ArrayType(Type.INT), false, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("array_range", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, new ArrayType(Type.INT), false, Type.INT, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("reverse", "_ZN5doris15StringFunctions7reverseEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("reverse", "_ZN5doris15StringFunctions7reverseEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.TINYINT), false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.SMALLINT), false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.INT), false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.LARGEINT), false, new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATETIME), false, new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DATE), false, new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.FLOAT), false, new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.DOUBLE), false, new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.VARCHAR), false, new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("reverse", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.STRING), false, new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("unix_timestamp", "_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.INT, false);
        functionSet.addScalarAndVectorizedBuiltin("unix_timestamp", "_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("unix_timestamp", "_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("unix_timestamp", "_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_11DateV2TimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("unix_timestamp", "_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("unix_timestamp", "_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("unix_timestamp", "_ZN5doris18TimestampFunctions7to_unixEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("from_unixtime", "_ZN5doris18TimestampFunctions9from_unixEPN9doris_udf15FunctionContextERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("from_unixtime", "_ZN5doris18TimestampFunctions9from_unixEPN9doris_udf15FunctionContextERKNS1_6IntValERKNS1_9StringValE", true, "_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.INT, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("from_unixtime", "_ZN5doris18TimestampFunctions9from_unixEPN9doris_udf15FunctionContextERKNS1_6IntValERKNS1_9StringValE", true, "_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.INT, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("now", "_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATETIME, false);
        functionSet.addScalarAndVectorizedBuiltin("current_timestamp", "_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATETIME, false);
        functionSet.addScalarAndVectorizedBuiltin("localtime", "_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATETIME, false);
        functionSet.addScalarAndVectorizedBuiltin("localtimestamp", "_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATETIME, false);
        functionSet.addScalarAndVectorizedBuiltin("now", "_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATETIMEV2, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("current_timestamp", "_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATETIMEV2, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("localtime", "_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATETIMEV2, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("localtimestamp", "_ZN5doris18TimestampFunctions3nowEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATETIMEV2, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("curtime", "_ZN5doris18TimestampFunctions7curtimeEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.TIME, false);
        functionSet.addScalarAndVectorizedBuiltin("current_time", "_ZN5doris18TimestampFunctions7curtimeEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.TIME, false);
        functionSet.addScalarAndVectorizedBuiltin("curdate", "_ZN5doris18TimestampFunctions7curdateEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATE, false);
        functionSet.addScalarAndVectorizedBuiltin("current_date", "_ZN5doris18TimestampFunctions7curdateEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATE, false);
        functionSet.addScalarAndVectorizedBuiltin("utc_timestamp", "_ZN5doris18TimestampFunctions13utc_timestampEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DATETIME, false);
        functionSet.addScalarAndVectorizedBuiltin("timestamp", "_ZN5doris18TimestampFunctions9timestampEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("from_days", "_ZN5doris18TimestampFunctions9from_daysEPN9doris_udf15FunctionContextERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("last_day", "_ZN5doris18TimestampFunctions8last_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("last_day", "_ZN5doris18TimestampFunctions8last_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("last_day", "_ZN5doris18TimestampFunctions8last_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("last_day", "_ZN5doris18TimestampFunctions8last_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("to_monday", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("to_monday", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("to_monday", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("to_monday", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("to_days", "_ZN5doris18TimestampFunctions7to_daysEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("date_trunc", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("date_trunc", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("year", "_ZN5doris18TimestampFunctions4yearEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("month", "_ZN5doris18TimestampFunctions5monthEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("quarter", "_ZN5doris18TimestampFunctions7quarterEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("dayofweek", "_ZN5doris18TimestampFunctions11day_of_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("weekday", "_ZN5doris18TimestampFunctions8week_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("day", "_ZN5doris18TimestampFunctions12day_of_monthEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("dayofmonth", "_ZN5doris18TimestampFunctions12day_of_monthEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("dayofyear", "_ZN5doris18TimestampFunctions11day_of_yearEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("weekofyear", "_ZN5doris18TimestampFunctions12week_of_yearEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("yearweek", "_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("yearweek", "_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("week", "_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("week", "_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hour", "_ZN5doris18TimestampFunctions4hourEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minute", "_ZN5doris18TimestampFunctions6minuteEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("second", "_ZN5doris18TimestampFunctions6secondEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("makedate", "_ZN5doris18TimestampFunctions9make_dateEPN9doris_udf15FunctionContextERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("years_add", "_ZN5doris18TimestampFunctions9years_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("years_sub", "_ZN5doris18TimestampFunctions9years_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("months_add", "_ZN5doris18TimestampFunctions10months_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("add_months", "_ZN5doris18TimestampFunctions10months_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("months_sub", "_ZN5doris18TimestampFunctions10months_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("weeks_add", "_ZN5doris18TimestampFunctions9weeks_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("weeks_sub", "_ZN5doris18TimestampFunctions9weeks_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("days_add", "_ZN5doris18TimestampFunctions8days_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("date_add", "_ZN5doris18TimestampFunctions8days_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("adddate", "_ZN5doris18TimestampFunctions8days_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("days_sub", "_ZN5doris18TimestampFunctions8days_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("date_sub", "_ZN5doris18TimestampFunctions8days_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("subdate", "_ZN5doris18TimestampFunctions8days_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hours_add", "_ZN5doris18TimestampFunctions9hours_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hours_sub", "_ZN5doris18TimestampFunctions9hours_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minutes_add", "_ZN5doris18TimestampFunctions11minutes_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minutes_sub", "_ZN5doris18TimestampFunctions11minutes_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("seconds_add", "_ZN5doris18TimestampFunctions11seconds_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("seconds_sub", "_ZN5doris18TimestampFunctions11seconds_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarBuiltin("microseconds_add", "_ZN5doris18TimestampFunctions10micros_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarBuiltin("microseconds_sub", "_ZN5doris18TimestampFunctions10micros_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("datediff", "_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("timediff", "_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("str_to_date", "_ZN5doris18TimestampFunctions11str_to_dateEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("str_to_date", "_ZN5doris18TimestampFunctions11str_to_dateEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("date_format", "_ZN5doris18TimestampFunctions11date_formatEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_9StringValE", true, "_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATETIME, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("date_format", "_ZN5doris18TimestampFunctions11date_formatEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_9StringValE", true, "_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATE, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("date", "_ZN5doris18TimestampFunctions7to_dateEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("to_date", "_ZN5doris18TimestampFunctions7to_dateEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("dayname", "_ZN5doris18TimestampFunctions8day_nameEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("monthname", "_ZN5doris18TimestampFunctions10month_nameEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("convert_tz", "_ZN5doris18TimestampFunctions10convert_tzEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_9StringValES9_", true, "_ZN5doris18TimestampFunctions18convert_tz_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris18TimestampFunctions16convert_tz_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("years_diff", "_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("months_diff", "_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("weeks_diff", "_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("days_diff", "_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("hours_diff", "_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minutes_diff", "_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("seconds_diff", "_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.INT, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("timestamp", "_ZN5doris18TimestampFunctions9timestampEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("to_days", "_ZN5doris18TimestampFunctions7to_daysEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("year", "_ZN5doris18TimestampFunctions4yearEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("month", "_ZN5doris18TimestampFunctions5monthEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("quarter", "_ZN5doris18TimestampFunctions7quarterEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("dayofweek", "_ZN5doris18TimestampFunctions11day_of_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("weekday", "_ZN5doris18TimestampFunctions8week_dayEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("day", "_ZN5doris18TimestampFunctions12day_of_monthEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("dayofmonth", "_ZN5doris18TimestampFunctions12day_of_monthEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("dayofyear", "_ZN5doris18TimestampFunctions11day_of_yearEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("weekofyear", "_ZN5doris18TimestampFunctions12week_of_yearEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("yearweek", "_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("yearweek", "_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("week", "_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("week", "_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hour", "_ZN5doris18TimestampFunctions4hourEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute", "_ZN5doris18TimestampFunctions6minuteEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("second", "_ZN5doris18TimestampFunctions6secondEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("year", "_ZN5doris18TimestampFunctions4yearEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("month", "_ZN5doris18TimestampFunctions5monthEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("quarter", "_ZN5doris18TimestampFunctions7quarterEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("dayofweek", "_ZN5doris18TimestampFunctions11day_of_weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("weekday", "_ZN5doris18TimestampFunctions8week_dayEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("day", "_ZN5doris18TimestampFunctions12day_of_monthEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("dayofmonth", "_ZN5doris18TimestampFunctions12day_of_monthEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("dayofyear", "_ZN5doris18TimestampFunctions11day_of_yearEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("weekofyear", "_ZN5doris18TimestampFunctions12week_of_yearEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("yearweek", "_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("yearweek", "_ZN5doris18TimestampFunctions9year_weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("week", "_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("week", "_ZN5doris18TimestampFunctions4weekEPN9doris_udf15FunctionContextERKNS1_11DateV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hour", "_ZN5doris18TimestampFunctions4hourEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute", "_ZN5doris18TimestampFunctions6minuteEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("second", "_ZN5doris18TimestampFunctions6secondEPN9doris_udf15FunctionContextERKNS1_11DateV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("years_add", "_ZN5doris18TimestampFunctions9years_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("years_sub", "_ZN5doris18TimestampFunctions9years_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("months_add", "_ZN5doris18TimestampFunctions10months_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("add_months", "_ZN5doris18TimestampFunctions10months_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("months_sub", "_ZN5doris18TimestampFunctions10months_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("weeks_add", "_ZN5doris18TimestampFunctions9weeks_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("weeks_sub", "_ZN5doris18TimestampFunctions9weeks_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("days_add", "_ZN5doris18TimestampFunctions8days_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("date_add", "_ZN5doris18TimestampFunctions8days_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("adddate", "_ZN5doris18TimestampFunctions8days_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("days_sub", "_ZN5doris18TimestampFunctions8days_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("date_sub", "_ZN5doris18TimestampFunctions8days_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("subdate", "_ZN5doris18TimestampFunctions8days_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hours_add", "_ZN5doris18TimestampFunctions9hours_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hours_sub", "_ZN5doris18TimestampFunctions9hours_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minutes_add", "_ZN5doris18TimestampFunctions11minutes_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minutes_sub", "_ZN5doris18TimestampFunctions11minutes_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("seconds_add", "_ZN5doris18TimestampFunctions11seconds_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("seconds_sub", "_ZN5doris18TimestampFunctions11seconds_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarBuiltin("microseconds_add", "_ZN5doris18TimestampFunctions10micros_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarBuiltin("microseconds_sub", "_ZN5doris18TimestampFunctions10micros_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("years_add", "_ZN5doris18TimestampFunctions9years_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("years_sub", "_ZN5doris18TimestampFunctions9years_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("months_add", "_ZN5doris18TimestampFunctions10months_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("add_months", "_ZN5doris18TimestampFunctions10months_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("months_sub", "_ZN5doris18TimestampFunctions10months_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("weeks_add", "_ZN5doris18TimestampFunctions9weeks_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("weeks_sub", "_ZN5doris18TimestampFunctions9weeks_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("days_add", "_ZN5doris18TimestampFunctions8days_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("date_add", "_ZN5doris18TimestampFunctions8days_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("adddate", "_ZN5doris18TimestampFunctions8days_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("days_sub", "_ZN5doris18TimestampFunctions8days_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("date_sub", "_ZN5doris18TimestampFunctions8days_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("subdate", "_ZN5doris18TimestampFunctions8days_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hours_add", "_ZN5doris18TimestampFunctions9hours_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hours_sub", "_ZN5doris18TimestampFunctions9hours_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minutes_add", "_ZN5doris18TimestampFunctions11minutes_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minutes_sub", "_ZN5doris18TimestampFunctions11minutes_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("seconds_add", "_ZN5doris18TimestampFunctions11seconds_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("seconds_sub", "_ZN5doris18TimestampFunctions11seconds_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarBuiltin("microseconds_add", "_ZN5doris18TimestampFunctions10micros_addEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarBuiltin("microseconds_sub", "_ZN5doris18TimestampFunctions10micros_subEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("datediff", "_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("timediff", "_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("datediff", "_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("timediff", "_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TIMEV2, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("datediff", "_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("timediff", "_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TIMEV2, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("datediff", "_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("timediff", "_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TIMEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("datediff", "_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATETIMEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("timediff", "_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TIMEV2, false, Type.DATETIMEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("datediff", "_ZN5doris18TimestampFunctions9date_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.DATEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("timediff", "_ZN5doris18TimestampFunctions9time_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TIMEV2, false, Type.DATEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("date_format", "_ZN5doris18TimestampFunctions11date_formatEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_9StringValE", true, "_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATETIMEV2, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("date_format", "_ZN5doris18TimestampFunctions11date_formatEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_9StringValE", true, "_ZN5doris18TimestampFunctions14format_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris18TimestampFunctions12format_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATEV2, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("date", "_ZN5doris18TimestampFunctions7to_dateEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("to_date", "_ZN5doris18TimestampFunctions7to_dateEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("datev2", "_ZN5doris18TimestampFunctions7to_dateEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("to_datev2", "_ZN5doris18TimestampFunctions7to_dateEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("dayname", "_ZN5doris18TimestampFunctions8day_nameEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("monthname", "_ZN5doris18TimestampFunctions10month_nameEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("dayname", "_ZN5doris18TimestampFunctions8day_nameEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("monthname", "_ZN5doris18TimestampFunctions10month_nameEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("convert_tz", "_ZN5doris18TimestampFunctions10convert_tzEPN9doris_udf15FunctionContextERKNS1_11DateV2ValERKNS1_9StringValES9_", true, "_ZN5doris18TimestampFunctions18convert_tz_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris18TimestampFunctions16convert_tz_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("convert_tz", "_ZN5doris18TimestampFunctions10convert_tzEPN9doris_udf15FunctionContextERKNS1_11DateV2ValERKNS1_9StringValES9_", true, "_ZN5doris18TimestampFunctions18convert_tz_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris18TimestampFunctions16convert_tz_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("years_diff", "_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("months_diff", "_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("weeks_diff", "_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("days_diff", "_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("hours_diff", "_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minutes_diff", "_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("seconds_diff", "_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("years_diff", "_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("months_diff", "_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("weeks_diff", "_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("days_diff", "_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("hours_diff", "_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minutes_diff", "_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("seconds_diff", "_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("years_diff", "_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("months_diff", "_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("weeks_diff", "_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("days_diff", "_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("hours_diff", "_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minutes_diff", "_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("seconds_diff", "_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("years_diff", "_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("months_diff", "_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("weeks_diff", "_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("days_diff", "_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("hours_diff", "_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minutes_diff", "_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("seconds_diff", "_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("years_diff", "_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("months_diff", "_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("weeks_diff", "_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("days_diff", "_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("hours_diff", "_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minutes_diff", "_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("seconds_diff", "_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("years_diff", "_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("months_diff", "_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("weeks_diff", "_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("days_diff", "_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("hours_diff", "_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minutes_diff", "_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("seconds_diff", "_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("years_diff", "_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("months_diff", "_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("weeks_diff", "_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("days_diff", "_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("hours_diff", "_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("minutes_diff", "_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("seconds_diff", "_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIMEV2, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("years_diff", "_ZN5doris18TimestampFunctions10years_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("months_diff", "_ZN5doris18TimestampFunctions11months_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("weeks_diff", "_ZN5doris18TimestampFunctions10weeks_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("days_diff", "_ZN5doris18TimestampFunctions9days_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("hours_diff", "_ZN5doris18TimestampFunctions10hours_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minutes_diff", "_ZN5doris18TimestampFunctions12minutes_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("seconds_diff", "_ZN5doris18TimestampFunctions12seconds_diffEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.DATETIME, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.INT, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("year_floor", "_ZN5doris18TimestampFunctions10year_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("year_ceil", "_ZN5doris18TimestampFunctions9year_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("month_floor", "_ZN5doris18TimestampFunctions11month_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("month_ceil", "_ZN5doris18TimestampFunctions10month_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("week_floor", "_ZN5doris18TimestampFunctions10week_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("week_ceil", "_ZN5doris18TimestampFunctions9week_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("day_floor", "_ZN5doris18TimestampFunctions9day_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("day_ceil", "_ZN5doris18TimestampFunctions8day_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hour_floor", "_ZN5doris18TimestampFunctions10hour_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("hour_ceil", "_ZN5doris18TimestampFunctions9hour_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minute_floor", "_ZN5doris18TimestampFunctions12minute_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("minute_ceil", "_ZN5doris18TimestampFunctions11minute_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("second_floor", "_ZN5doris18TimestampFunctions12second_floorEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("second_ceil", "_ZN5doris18TimestampFunctions11second_ceilEPN9doris_udf15FunctionContextERKNS1_11DateTimeV2ValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATEV2, Type.INT, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("pi", "_ZN5doris13MathFunctions2piEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DOUBLE, false);
        functionSet.addScalarAndVectorizedBuiltin("e", "_ZN5doris13MathFunctions1eEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DOUBLE, false);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_8FloatValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.FLOAT, false, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_11LargeIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, false, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_11SmallIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_10TinyIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.SMALLINT, false, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.MAX_DECIMALV2_TYPE, false, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("abs", "_ZN5doris13MathFunctions3absEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("sign", "_ZN5doris13MathFunctions4signEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.TINYINT, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("sin", "_ZN5doris13MathFunctions3sinEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("asin", "_ZN5doris13MathFunctions4asinEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("cos", "_ZN5doris13MathFunctions3cosEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("acos", "_ZN5doris13MathFunctions4acosEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("tan", "_ZN5doris13MathFunctions3tanEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("atan", "_ZN5doris13MathFunctions4atanEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("ceil", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("ceiling", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("dceil", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("floor", "_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("dfloor", "_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("round", "_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("dround", "_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("ceil", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("ceiling", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("dceil", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("floor", "_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("dfloor", "_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("round", "_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("dround", "_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("ceil", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("ceiling", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("dceil", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("floor", "_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("dfloor", "_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("round", "_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("dround", "_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("ceil", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("ceiling", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("dceil", "_ZN5doris13MathFunctions4ceilEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("floor", "_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("dfloor", "_ZN5doris13MathFunctions5floorEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("round", "_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("dround", "_ZN5doris13MathFunctions5roundEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("round", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dround", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("round", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dround", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("round", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dround", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("round", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dround", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("floor", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dfloor", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("floor", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dfloor", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("floor", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dfloor", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("ceil", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dceil", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("ceil", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dceil", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("ceil", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("dceil", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("truncate", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("truncate", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("truncate", "_ZN5doris13MathFunctions11round_up_toEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("truncate", "_ZN5doris13MathFunctions8truncateEPN9doris_udf15FunctionContextERKNS1_9DoubleValERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("ln", "_ZN5doris13MathFunctions2lnEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("dlog1", "_ZN5doris13MathFunctions2lnEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("log", "_ZN5doris13MathFunctions3logEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("log2", "_ZN5doris13MathFunctions4log2EPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("log10", "_ZN5doris13MathFunctions5log10EPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("dlog10", "_ZN5doris13MathFunctions5log10EPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("exp", "_ZN5doris13MathFunctions3expEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("dexp", "_ZN5doris13MathFunctions3expEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("radians", "_ZN5doris13MathFunctions7radiansEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("degrees", "_ZN5doris13MathFunctions7degreesEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("sqrt", "_ZN5doris13MathFunctions4sqrtEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("dsqrt", "_ZN5doris13MathFunctions4sqrtEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("cbrt", "_ZN5doris13MathFunctions4cbrtEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("pow", "_ZN5doris13MathFunctions3powEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("power", "_ZN5doris13MathFunctions3powEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("dpow", "_ZN5doris13MathFunctions3powEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("fpow", "_ZN5doris13MathFunctions3powEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("rand", "_ZN5doris13MathFunctions4randEPN9doris_udf15FunctionContextE", true, "_ZN5doris13MathFunctions12rand_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13MathFunctions10rand_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DOUBLE, false);
        functionSet.addScalarAndVectorizedBuiltin("random", "_ZN5doris13MathFunctions4randEPN9doris_udf15FunctionContextE", true, "_ZN5doris13MathFunctions12rand_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13MathFunctions10rand_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.DOUBLE, false);
        functionSet.addScalarAndVectorizedBuiltin("rand", "_ZN5doris13MathFunctions9rand_seedEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, "_ZN5doris13MathFunctions12rand_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13MathFunctions10rand_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("random", "_ZN5doris13MathFunctions9rand_seedEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, "_ZN5doris13MathFunctions12rand_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13MathFunctions10rand_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bin", "_ZN5doris13MathFunctions3binEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("hex", "_ZN5doris13MathFunctions7hex_intEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("hex", "_ZN5doris13MathFunctions10hex_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("hex", "_ZN5doris13MathFunctions10hex_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("unhex", "_ZN5doris13MathFunctions5unhexEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("unhex", "_ZN5doris13MathFunctions5unhexEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("conv", "_ZN5doris13MathFunctions8conv_intEPN9doris_udf15FunctionContextERKNS1_9BigIntValERKNS1_10TinyIntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.BIGINT, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("conv", "_ZN5doris13MathFunctions11conv_stringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_10TinyIntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("conv", "_ZN5doris13MathFunctions11conv_stringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_10TinyIntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("pmod", "_ZN5doris13MathFunctions11pmod_bigintEPN9doris_udf15FunctionContextERKNS1_9BigIntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("pmod", "_ZN5doris13MathFunctions11pmod_doubleEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris9Operators29mod_tiny_int_val_tiny_int_valEPN9doris_udf15FunctionContextERKNS1_10TinyIntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TINYINT, false, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris9Operators31mod_small_int_val_small_int_valEPN9doris_udf15FunctionContextERKNS1_11SmallIntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.SMALLINT, false, Type.SMALLINT, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris9Operators19mod_int_val_int_valEPN9doris_udf15FunctionContextERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris9Operators27mod_big_int_val_big_int_valEPN9doris_udf15FunctionContextERKNS1_9BigIntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris9Operators31mod_large_int_val_large_int_valEPN9doris_udf15FunctionContextERKNS1_11LargeIntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.LARGEINT, false, Type.LARGEINT, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris18DecimalV2Operators31mod_decimalv2_val_decimalv2_valEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.MAX_DECIMALV2_TYPE, false, Type.MAX_DECIMALV2_TYPE, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris18DecimalV2Operators31mod_decimalv2_val_decimalv2_valEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DECIMAL32, false, Type.DECIMAL32, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris18DecimalV2Operators31mod_decimalv2_val_decimalv2_valEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DECIMAL64, false, Type.DECIMAL64, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris18DecimalV2Operators31mod_decimalv2_val_decimalv2_valEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DECIMAL128, false, Type.DECIMAL128, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris13MathFunctions10fmod_floatEPN9doris_udf15FunctionContextERKNS1_8FloatValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.FLOAT, false, Type.FLOAT, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("fmod", "_ZN5doris13MathFunctions10fmod_floatEPN9doris_udf15FunctionContextERKNS1_8FloatValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.FLOAT, false, Type.FLOAT, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("mod", "_ZN5doris13MathFunctions11fmod_doubleEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("fmod", "_ZN5doris13MathFunctions11fmod_doubleEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("positive", "_ZN5doris13MathFunctions15positive_bigintEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("positive", "_ZN5doris13MathFunctions15positive_doubleEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("positive", "_ZN5doris13MathFunctions16positive_decimalEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.MAX_DECIMALV2_TYPE, false, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("positive", "_ZN5doris13MathFunctions16positive_decimalEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("positive", "_ZN5doris13MathFunctions16positive_decimalEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("positive", "_ZN5doris13MathFunctions16positive_decimalEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("negative", "_ZN5doris13MathFunctions15negative_bigintEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("negative", "_ZN5doris13MathFunctions15negative_doubleEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("negative", "_ZN5doris13MathFunctions16negative_decimalEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.MAX_DECIMALV2_TYPE, false, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("negative", "_ZN5doris13MathFunctions16negative_decimalEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("negative", "_ZN5doris13MathFunctions16negative_decimalEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("negative", "_ZN5doris13MathFunctions16negative_decimalEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_10TinyIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.TINYINT, true, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_11SmallIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.SMALLINT, true, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, true, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_11LargeIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, true, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_8FloatValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.FLOAT, true, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, true, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_11DateTimeValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DATETIME, true, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.MAX_DECIMALV2_TYPE, true, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, true, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, true, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, true, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("least", "_ZN5doris13MathFunctions5leastEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_10TinyIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.TINYINT, true, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_11SmallIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.SMALLINT, true, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, true, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_11LargeIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, true, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_8FloatValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.FLOAT, true, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, true, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.MAX_DECIMALV2_TYPE, true, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, true, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, true, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, true, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_11DateTimeValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DATETIME, true, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_11DateTimeValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DATETIMEV2, true, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("greatest", "_ZN5doris13MathFunctions8greatestEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.BOOLEAN, false, Type.BOOLEAN, Type.BOOLEAN, Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.TINYINT, false, Type.BOOLEAN, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.SMALLINT, false, Type.BOOLEAN, Type.SMALLINT, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.INT, false, Type.BOOLEAN, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.BIGINT, false, Type.BOOLEAN, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.LARGEINT, false, Type.BOOLEAN, Type.LARGEINT, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.FLOAT, false, Type.BOOLEAN, Type.FLOAT, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.DOUBLE, false, Type.BOOLEAN, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIME, false, Type.BOOLEAN, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATE, false, Type.BOOLEAN, Type.DATE, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIMEV2, false, Type.BOOLEAN, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATEV2, false, Type.BOOLEAN, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.MAX_DECIMALV2_TYPE, false, Type.BOOLEAN, Type.MAX_DECIMALV2_TYPE, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL32, false, Type.BOOLEAN, Type.DECIMAL32, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL64, false, Type.BOOLEAN, Type.DECIMAL64, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL128, false, Type.BOOLEAN, Type.DECIMAL128, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.BITMAP, false, Type.BOOLEAN, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.HLL, false, Type.BOOLEAN, Type.HLL, Type.HLL);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.VARCHAR, false, Type.BOOLEAN, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, Type.STRING, false, Type.BOOLEAN, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.BOOLEAN), false, Type.BOOLEAN, new ArrayType(Type.BOOLEAN), new ArrayType(Type.BOOLEAN));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.TINYINT), false, Type.BOOLEAN, new ArrayType(Type.TINYINT), new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.SMALLINT), false, Type.BOOLEAN, new ArrayType(Type.SMALLINT), new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.INT), false, Type.BOOLEAN, new ArrayType(Type.INT), new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.BIGINT), false, Type.BOOLEAN, new ArrayType(Type.BIGINT), new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.LARGEINT), false, Type.BOOLEAN, new ArrayType(Type.LARGEINT), new ArrayType(Type.LARGEINT));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.FLOAT), false, Type.BOOLEAN, new ArrayType(Type.FLOAT), new ArrayType(Type.FLOAT));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.DOUBLE), false, Type.BOOLEAN, new ArrayType(Type.DOUBLE), new ArrayType(Type.DOUBLE));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.DATETIME), false, Type.BOOLEAN, new ArrayType(Type.DATETIME), new ArrayType(Type.DATETIME));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.DATE), false, Type.BOOLEAN, new ArrayType(Type.DATE), new ArrayType(Type.DATE));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.DATETIMEV2), false, Type.BOOLEAN, new ArrayType(Type.DATETIMEV2), new ArrayType(Type.DATETIMEV2));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.DATEV2), false, Type.BOOLEAN, new ArrayType(Type.DATEV2), new ArrayType(Type.DATEV2));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.MAX_DECIMALV2_TYPE), false, Type.BOOLEAN, new ArrayType(Type.MAX_DECIMALV2_TYPE), new ArrayType(Type.MAX_DECIMALV2_TYPE));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.VARCHAR), false, Type.BOOLEAN, new ArrayType(Type.VARCHAR), new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("if", "", true, null, null, Function.NullableMode.CUSTOM, new ArrayType(Type.STRING), false, Type.BOOLEAN, new ArrayType(Type.STRING), new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, Type.BOOLEAN, Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.TINYINT, false, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.SMALLINT, false, Type.SMALLINT, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.LARGEINT, false, Type.LARGEINT, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.FLOAT, false, Type.FLOAT, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATE, false, Type.DATE, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DATEV2, false, Type.DATEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.MAX_DECIMALV2_TYPE, false, Type.MAX_DECIMALV2_TYPE, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DECIMAL32, false, Type.DECIMAL32, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DECIMAL64, false, Type.DECIMAL64, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DECIMAL128, false, Type.DECIMAL128, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("nullif", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.BOOLEAN, false, Type.BOOLEAN, Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.BOOLEAN, false, Type.BOOLEAN, Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.TINYINT, false, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.TINYINT, false, Type.TINYINT, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.SMALLINT, false, Type.SMALLINT, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.SMALLINT, false, Type.SMALLINT, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.INT, false, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.INT, false, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.BIGINT, false, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.BIGINT, false, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.LARGEINT, false, Type.LARGEINT, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.LARGEINT, false, Type.LARGEINT, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.FLOAT, false, Type.FLOAT, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.FLOAT, false, Type.FLOAT, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATE, false, Type.DATE, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATE, false, Type.DATE, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIME, false, Type.DATETIME, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIME, false, Type.DATE, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIME, false, Type.DATE, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIME, false, Type.DATETIME, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIME, false, Type.DATETIME, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATEV2, false, Type.DATE, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATEV2, false, Type.DATE, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIMEV2, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIMEV2, false, Type.DATEV2, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIMEV2, false, Type.DATETIMEV2, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.MAX_DECIMALV2_TYPE, false, Type.MAX_DECIMALV2_TYPE, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.MAX_DECIMALV2_TYPE, false, Type.MAX_DECIMALV2_TYPE, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL32, false, Type.DECIMAL32, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL32, false, Type.DECIMAL32, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL64, false, Type.DECIMAL64, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL64, false, Type.DECIMAL64, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL128, false, Type.DECIMAL128, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL128, false, Type.DECIMAL128, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.BITMAP, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.BITMAP, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ifnull", "", true, null, null, Function.NullableMode.CUSTOM, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("nvl", "", true, null, null, Function.NullableMode.CUSTOM, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.BOOLEAN, true, Type.BOOLEAN);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.TINYINT, true, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.SMALLINT, true, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.INT, true, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.BIGINT, true, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.LARGEINT, true, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.FLOAT, true, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.DOUBLE, true, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIME, true, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATE, true, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATETIMEV2, true, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.DATEV2, true, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.MAX_DECIMALV2_TYPE, true, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL32, true, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL64, true, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.DECIMAL128, true, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.BITMAP, true, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.VARCHAR, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("coalesce", "", true, null, null, Function.NullableMode.CUSTOM, Type.STRING, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("esquery", "_ZN5doris11ESFunctions5matchEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("substr", "_ZN5doris15StringFunctions9substringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("substring", "_ZN5doris15StringFunctions9substringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("substr", "_ZN5doris15StringFunctions9substringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("substring", "_ZN5doris15StringFunctions9substringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("mask", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("mask_first_n", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("mask_first_n", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("mask_last_n", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("mask_last_n", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("strleft", "_ZN5doris15StringFunctions4leftEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("left", "_ZN5doris15StringFunctions4leftEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("strright", "_ZN5doris15StringFunctions5rightEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("right", "_ZN5doris15StringFunctions5rightEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("ends_with", "_ZN5doris15StringFunctions9ends_withEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("starts_with", "_ZN5doris15StringFunctions11starts_withEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("null_or_empty", "_ZN5doris15StringFunctions13null_or_emptyEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BOOLEAN, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("not_null_or_empty", "_ZN5doris15StringFunctions17not_null_or_emptyEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BOOLEAN, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("space", "_ZN5doris15StringFunctions5spaceEPN9doris_udf15FunctionContextERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("repeat", "_ZN5doris15StringFunctions6repeatEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("lpad", "_ZN5doris15StringFunctions4lpadEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("rpad", "_ZN5doris15StringFunctions4rpadEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.INT, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("append_trailing_char_if_absent", "_ZN5doris15StringFunctions30append_trailing_char_if_absentEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("length", "_ZN5doris15StringFunctions6lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("bit_length", "_ZN5doris15StringFunctions10bit_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("char_length", "_ZN5doris15StringFunctions16char_utf8_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("character_length", "_ZN5doris15StringFunctions16char_utf8_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("lower", "_ZN5doris15StringFunctions5lowerEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("lcase", "_ZN5doris15StringFunctions5lowerEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("upper", "_ZN5doris15StringFunctions5upperEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ucase", "_ZN5doris15StringFunctions5upperEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("initcap", "_ZN5doris15StringFunctions7initcapEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("trim", "_ZN5doris15StringFunctions4trimEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ltrim", "_ZN5doris15StringFunctions5ltrimEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("rtrim", "_ZN5doris15StringFunctions5rtrimEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ascii", "_ZN5doris15StringFunctions5asciiEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("instr", "_ZN5doris15StringFunctions5instrEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("locate", "_ZN5doris15StringFunctions6locateEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("locate", "_ZN5doris15StringFunctions10locate_posEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.VARCHAR, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("regexp_extract", "_ZN5doris15StringFunctions14regexp_extractEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_9BigIntValE", true, "_ZN5doris15StringFunctions14regexp_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris15StringFunctions12regexp_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("regexp_replace", "_ZN5doris15StringFunctions14regexp_replaceEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_", true, "_ZN5doris15StringFunctions14regexp_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris15StringFunctions12regexp_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("regexp_replace_one", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("regexp_extract_all", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("concat", "_ZN5doris15StringFunctions6concatEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("elt", "_ZN5doris15StringFunctions3eltEPN9doris_udf15FunctionContextERKNS1_6IntValEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, true, Type.INT, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("elt", "_ZN5doris15StringFunctions3eltEPN9doris_udf15FunctionContextERKNS1_6IntValEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, true, Type.INT, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("replace", "_ZN5doris15StringFunctions7replaceEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("concat_ws", "_ZN5doris15StringFunctions9concat_wsEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_", true, null, null, Function.NullableMode.CUSTOM, Type.VARCHAR, true, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("concat_ws", "_ZN5doris15StringFunctions9concat_wsEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_", true, null, null, Function.NullableMode.CUSTOM, Type.VARCHAR, false, Type.VARCHAR, new ArrayType(Type.VARCHAR));
        functionSet.addScalarAndVectorizedBuiltin("find_in_set", "_ZN5doris15StringFunctions11find_in_setEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("parse_url", "_ZN5doris15StringFunctions9parse_urlEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, "_ZN5doris15StringFunctions17parse_url_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris15StringFunctions15parse_url_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("parse_url", "_ZN5doris15StringFunctions13parse_url_keyEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_", true, "_ZN5doris15StringFunctions17parse_url_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris15StringFunctions15parse_url_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_11LargeIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("split_part", "_ZN5doris15StringFunctions10split_partEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("substring_index", "_ZN5doris15StringFunctions15substring_indexEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("extract_url_parameter", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("sub_replace", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("sub_replace", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.SMALLINT, false, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.LARGEINT, false, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.MAX_DECIMALV2_TYPE, false, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL32, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL64, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DECIMAL128, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.DATE);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DATETIME);
        functionSet.addScalarAndVectorizedBuiltin("running_difference", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("substr", "_ZN5doris15StringFunctions9substringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("substring", "_ZN5doris15StringFunctions9substringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("substr", "_ZN5doris15StringFunctions9substringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("substring", "_ZN5doris15StringFunctions9substringEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("strleft", "_ZN5doris15StringFunctions4leftEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("left", "_ZN5doris15StringFunctions4leftEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("strright", "_ZN5doris15StringFunctions5rightEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("right", "_ZN5doris15StringFunctions5rightEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("ends_with", "_ZN5doris15StringFunctions9ends_withEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("starts_with", "_ZN5doris15StringFunctions11starts_withEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("null_or_empty", "_ZN5doris15StringFunctions13null_or_emptyEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BOOLEAN, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("not_null_or_empty", "_ZN5doris15StringFunctions17not_null_or_emptyEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BOOLEAN, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("space", "_ZN5doris15StringFunctions5spaceEPN9doris_udf15FunctionContextERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("repeat", "_ZN5doris15StringFunctions6repeatEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("lpad", "_ZN5doris15StringFunctions4lpadEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("rpad", "_ZN5doris15StringFunctions4rpadEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_6IntValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.INT, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("append_trailing_char_if_absent", "_ZN5doris15StringFunctions30append_trailing_char_if_absentEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("length", "_ZN5doris15StringFunctions6lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("bit_length", "_ZN5doris15StringFunctions10bit_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("char_length", "_ZN5doris15StringFunctions16char_utf8_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("character_length", "_ZN5doris15StringFunctions16char_utf8_lengthEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("lower", "_ZN5doris15StringFunctions5lowerEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("lcase", "_ZN5doris15StringFunctions5lowerEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("upper", "_ZN5doris15StringFunctions5upperEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ucase", "_ZN5doris15StringFunctions5upperEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("trim", "_ZN5doris15StringFunctions4trimEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ltrim", "_ZN5doris15StringFunctions5ltrimEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("rtrim", "_ZN5doris15StringFunctions5rtrimEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ascii", "_ZN5doris15StringFunctions5asciiEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("instr", "_ZN5doris15StringFunctions5instrEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("locate", "_ZN5doris15StringFunctions6locateEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("locate", "_ZN5doris15StringFunctions10locate_posEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.STRING, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("regexp_extract", "_ZN5doris15StringFunctions14regexp_extractEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_9BigIntValE", true, "_ZN5doris15StringFunctions14regexp_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris15StringFunctions12regexp_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("regexp_replace", "_ZN5doris15StringFunctions14regexp_replaceEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_", true, "_ZN5doris15StringFunctions14regexp_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris15StringFunctions12regexp_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("regexp_replace_one", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("regexp_extract_all", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("concat", "_ZN5doris15StringFunctions6concatEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("replace", "_ZN5doris15StringFunctions7replaceEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("concat_ws", "_ZN5doris15StringFunctions9concat_wsEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_", true, null, null, Function.NullableMode.CUSTOM, Type.STRING, true, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("find_in_set", "_ZN5doris15StringFunctions11find_in_setEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("parse_url", "_ZN5doris15StringFunctions9parse_urlEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, "_ZN5doris15StringFunctions17parse_url_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris15StringFunctions15parse_url_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("parse_url", "_ZN5doris15StringFunctions13parse_url_keyEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_", true, "_ZN5doris15StringFunctions17parse_url_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris15StringFunctions15parse_url_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_11LargeIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_9DoubleValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.DECIMAL32);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.DECIMAL64);
        functionSet.addScalarAndVectorizedBuiltin("money_format", "_ZN5doris15StringFunctions12money_formatEPN9doris_udf15FunctionContextERKNS1_12DecimalV2ValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.DECIMAL128);
        functionSet.addScalarAndVectorizedBuiltin("split_part", "_ZN5doris15StringFunctions10split_partEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("substring_index", "_ZN5doris15StringFunctions15substring_indexEPN9doris_udf15FunctionContextERKNS1_9StringValES6_RKNS1_6IntValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("convert_to", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("sleep", "_ZN5doris16UtilityFunctions5sleepEPN9doris_udf15FunctionContextERKNS1_6IntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("version", "_ZN5doris16UtilityFunctions7versionEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.VARCHAR, false);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.TINYINT);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.SMALLINT);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.INT);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.LARGEINT);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.MAX_DECIMALV2_TYPE);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.DATEV2);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.DATETIMEV2);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("field", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.JSONB, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_error_to_null", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.JSONB, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_error_to_value", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.JSONB, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_error_to_invalid", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.JSONB, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_nullable", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.JSONB, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_nullable_error_to_null", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.JSONB, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_nullable_error_to_value", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.JSONB, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_nullable_error_to_invalid", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.JSONB, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_notnull", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.JSONB, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_notnull_error_to_value", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.JSONB, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_parse_notnull_error_to_invalid", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.JSONB, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_exists_path", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.JSONB, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_exists_path", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_type", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_type", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.JSONB, false, Type.JSONB, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.JSONB, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_isnull", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, Type.JSONB, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_isnull", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_bool", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, Type.JSONB, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_bool", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_int", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.JSONB, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_int", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_bigint", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.JSONB, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_bigint", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_double", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.JSONB, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_double", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_string", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.JSONB, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("jsonb_extract_string", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.JSONB, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("get_json_int", "_ZN5doris13JsonFunctions12get_json_intEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, "_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("get_json_double", "_ZN5doris13JsonFunctions15get_json_doubleEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, "_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("get_json_string", "_ZN5doris13JsonFunctions15get_json_stringEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, "_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("get_json_int", "_ZN5doris13JsonFunctions12get_json_intEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, "_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.INT, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("get_json_double", "_ZN5doris13JsonFunctions15get_json_doubleEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, "_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("get_json_string", "_ZN5doris13JsonFunctions15get_json_stringEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, "_ZN5doris13JsonFunctions17json_path_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13JsonFunctions15json_path_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("json_array", "_ZN5doris13JsonFunctions10json_arrayEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.VARCHAR, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("json_object", "_ZN5doris13JsonFunctions11json_objectEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.VARCHAR, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("json_quote", "_ZN5doris13JsonFunctions10json_quoteEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("hll_cardinality", "_ZN5doris12HllFunctions15hll_cardinalityEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BIGINT, false, Type.HLL);
        functionSet.addScalarAndVectorizedBuiltin("hll_hash", "_ZN5doris12HllFunctions8hll_hashEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.HLL, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("hll_empty", "_ZN5doris12HllFunctions9hll_emptyEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.HLL, false);
        functionSet.addScalarAndVectorizedBuiltin("hll_hash", "_ZN5doris12HllFunctions8hll_hashEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.HLL, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("to_bitmap", "_ZN5doris15BitmapFunctions9to_bitmapEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("to_bitmap_with_check", "_ZN5doris15BitmapFunctions20to_bitmap_with_checkEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("to_bitmap", "_ZN5doris15BitmapFunctions9to_bitmapEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("to_bitmap_with_check", "_ZN5doris15BitmapFunctions20to_bitmap_with_checkEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("to_bitmap", "_ZN5doris15BitmapFunctions9to_bitmapEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("to_bitmap_with_check", "_ZN5doris15BitmapFunctions20to_bitmap_with_checkEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_hash", "_ZN5doris15BitmapFunctions11bitmap_hashEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_hash64", "_ZN5doris15BitmapFunctions11bitmap_hash64EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_hash", "_ZN5doris15BitmapFunctions11bitmap_hash64EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_hash64", "_ZN5doris15BitmapFunctions11bitmap_hashEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_count", "_ZN5doris15BitmapFunctions12bitmap_countEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BIGINT, false, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_and_not_count", "_ZN5doris15BitmapFunctions20bitmap_and_not_countEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_empty", "_ZN5doris15BitmapFunctions12bitmap_emptyEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BITMAP, false);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_or", "_ZN5doris15BitmapFunctions9bitmap_orEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BITMAP, true, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_or", "_ZN5doris15BitmapFunctions9bitmap_orEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BITMAP, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_xor", "_ZN5doris15BitmapFunctions10bitmap_xorEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BITMAP, true, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_xor", "_ZN5doris15BitmapFunctions10bitmap_xorEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BITMAP, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_xor_count", "_ZN5doris15BitmapFunctions16bitmap_xor_countEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, true, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_xor_count", "_ZN5doris15BitmapFunctions16bitmap_xor_countEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_not", "_ZN5doris15BitmapFunctions10bitmap_notEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BITMAP, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_and", "_ZN5doris15BitmapFunctions10bitmap_andEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BITMAP, true, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_and", "_ZN5doris15BitmapFunctions10bitmap_andEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BITMAP, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_and_not", "_ZN5doris15BitmapFunctions14bitmap_and_notEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BITMAP, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_to_string", "_ZN5doris15BitmapFunctions16bitmap_to_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_from_string", "_ZN5doris15BitmapFunctions18bitmap_from_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BITMAP, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_from_string", "_ZN5doris15BitmapFunctions18bitmap_from_stringEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BITMAP, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_from_array", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BITMAP, false, new ArrayType(Type.TINYINT));
        functionSet.addScalarAndVectorizedBuiltin("bitmap_from_array", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BITMAP, false, new ArrayType(Type.SMALLINT));
        functionSet.addScalarAndVectorizedBuiltin("bitmap_from_array", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BITMAP, false, new ArrayType(Type.INT));
        functionSet.addScalarAndVectorizedBuiltin("bitmap_from_array", "", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BITMAP, false, new ArrayType(Type.BIGINT));
        functionSet.addScalarAndVectorizedBuiltin("bitmap_contains", "_ZN5doris15BitmapFunctions15bitmap_containsEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_9BigIntValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.BITMAP, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_has_any", "_ZN5doris15BitmapFunctions14bitmap_has_anyEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_has_all", "_ZN5doris15BitmapFunctions14bitmap_has_allEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BOOLEAN, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_min", "_ZN5doris15BitmapFunctions10bitmap_minEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_max", "_ZN5doris15BitmapFunctions10bitmap_maxEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BIGINT, false, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_subset_in_range", "_ZN5doris15BitmapFunctions22bitmap_subset_in_rangeEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_9BigIntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BITMAP, false, Type.BITMAP, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_subset_limit", "_ZN5doris15BitmapFunctions19bitmap_subset_limitEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_9BigIntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BITMAP, false, Type.BITMAP, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_and_count", "_ZN5doris15BitmapFunctions16bitmap_and_countEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, true, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_and_count", "_ZN5doris15BitmapFunctions16bitmap_and_countEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_or_count", "_ZN5doris15BitmapFunctions15bitmap_or_countEPN9doris_udf15FunctionContextERKNS1_9StringValEiPS5_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, true, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_or_count", "_ZN5doris15BitmapFunctions15bitmap_or_countEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, false, Type.BITMAP, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("sub_bitmap", "_ZN5doris15BitmapFunctions10sub_bitmapEPN9doris_udf15FunctionContextERKNS1_9StringValERKNS1_9BigIntValES9_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.BITMAP, false, Type.BITMAP, Type.BIGINT, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("bitmap_to_array", "", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, new ArrayType(Type.BIGINT), false, Type.BITMAP);
        functionSet.addScalarAndVectorizedBuiltin("to_quantile_state", "_ZN5doris22QuantileStateFunctions17to_quantile_stateEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris22QuantileStateFunctions25to_quantile_state_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.QUANTILE_STATE, false, Type.VARCHAR, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("quantile_percent", "_ZN5doris22QuantileStateFunctions16quantile_percentEPN9doris_udf15FunctionContextERNS1_9StringValE", true, "_ZN5doris22QuantileStateFunctions24quantile_percent_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.DOUBLE, false, Type.QUANTILE_STATE, Type.FLOAT);
        functionSet.addScalarAndVectorizedBuiltin("murmur_hash3_32", "_ZN5doris13HashFunctions15murmur_hash3_32EPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("murmur_hash3_32", "_ZN5doris13HashFunctions15murmur_hash3_32EPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.INT, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("murmur_hash3_64", "_ZN5doris13HashFunctions15murmur_hash3_64EPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("murmur_hash3_64", "_ZN5doris13HashFunctions15murmur_hash3_64EPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.BIGINT, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("aes_encrypt", "_ZN5doris19EncryptionFunctions11aes_encryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("aes_decrypt", "_ZN5doris19EncryptionFunctions11aes_decryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("aes_encrypt", "_ZN5doris19EncryptionFunctions11aes_encryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_S6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("aes_decrypt", "_ZN5doris19EncryptionFunctions11aes_decryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_S6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("sm4_encrypt", "_ZN5doris19EncryptionFunctions11sm4_encryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("sm4_decrypt", "_ZN5doris19EncryptionFunctions11sm4_decryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("sm4_encrypt", "_ZN5doris19EncryptionFunctions11sm4_encryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_S6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("sm4_decrypt", "_ZN5doris19EncryptionFunctions11sm4_decryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_S6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("from_base64", "_ZN5doris19EncryptionFunctions11from_base64EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("aes_encrypt", "_ZN5doris19EncryptionFunctions11aes_encryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("aes_decrypt", "_ZN5doris19EncryptionFunctions11aes_decryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("aes_encrypt", "_ZN5doris19EncryptionFunctions11aes_encryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_S6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("aes_decrypt", "_ZN5doris19EncryptionFunctions11aes_decryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_S6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("sm4_encrypt", "_ZN5doris19EncryptionFunctions11sm4_encryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("sm4_decrypt", "_ZN5doris19EncryptionFunctions11sm4_decryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("sm4_encrypt", "_ZN5doris19EncryptionFunctions11sm4_encryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_S6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("sm4_decrypt", "_ZN5doris19EncryptionFunctions11sm4_decryptEPN9doris_udf15FunctionContextERKNS1_9StringValES6_S6_S6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING, Type.STRING, Type.STRING, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("from_base64", "_ZN5doris19EncryptionFunctions11from_base64EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("to_base64", "_ZN5doris19EncryptionFunctions9to_base64EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("to_base64", "_ZN5doris19EncryptionFunctions9to_base64EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("md5", "_ZN5doris19EncryptionFunctions3md5EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("md5sum", "_ZN5doris19EncryptionFunctions6md5sumEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("md5", "_ZN5doris19EncryptionFunctions3md5EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("md5sum", "_ZN5doris19EncryptionFunctions6md5sumEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("sm3", "_ZN5doris19EncryptionFunctions3sm3EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("sm3sum", "_ZN5doris19EncryptionFunctions6sm3sumEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, true, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("sm3", "_ZN5doris19EncryptionFunctions3sm3EPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("sm3sum", "_ZN5doris19EncryptionFunctions6sm3sumEPN9doris_udf15FunctionContextEiPKNS1_9StringValE", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.VARCHAR, true, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_Point", "_ZN5doris12GeoFunctions8st_pointEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("ST_X", "_ZN5doris12GeoFunctions4st_xEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_Y", "_ZN5doris12GeoFunctions4st_yEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_X", "_ZN5doris12GeoFunctions4st_xEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_Y", "_ZN5doris12GeoFunctions4st_yEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_Distance_Sphere", "_ZN5doris12GeoFunctions18st_distance_sphereEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_S6_S6_", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.DOUBLE, false, Type.DOUBLE, Type.DOUBLE, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("ST_AsText", "_ZN5doris12GeoFunctions9st_as_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_AsWKT", "_ZN5doris12GeoFunctions9st_as_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_AsText", "_ZN5doris12GeoFunctions9st_as_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_AsWKT", "_ZN5doris12GeoFunctions9st_as_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, null, null, Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_GeometryFromText", "_ZN5doris12GeoFunctions11st_from_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions19st_from_wkt_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_GeomFromText", "_ZN5doris12GeoFunctions11st_from_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions19st_from_wkt_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_GeometryFromText", "_ZN5doris12GeoFunctions11st_from_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions19st_from_wkt_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_GeomFromText", "_ZN5doris12GeoFunctions11st_from_wktEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions19st_from_wkt_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_LineFromText", "_ZN5doris12GeoFunctions7st_lineEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions15st_line_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_LineStringFromText", "_ZN5doris12GeoFunctions7st_lineEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions15st_line_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_LineFromText", "_ZN5doris12GeoFunctions7st_lineEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions15st_line_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_LineStringFromText", "_ZN5doris12GeoFunctions7st_lineEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions15st_line_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_Polygon", "_ZN5doris12GeoFunctions10st_polygonEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions18st_polygon_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_PolyFromText", "_ZN5doris12GeoFunctions10st_polygonEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions18st_polygon_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_PolygonFromText", "_ZN5doris12GeoFunctions10st_polygonEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions18st_polygon_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("ST_Polygon", "_ZN5doris12GeoFunctions10st_polygonEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions18st_polygon_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_PolyFromText", "_ZN5doris12GeoFunctions10st_polygonEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions18st_polygon_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_PolygonFromText", "_ZN5doris12GeoFunctions10st_polygonEPN9doris_udf15FunctionContextERKNS1_9StringValE", true, "_ZN5doris12GeoFunctions18st_polygon_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("ST_Circle", "_ZN5doris12GeoFunctions9st_circleEPN9doris_udf15FunctionContextERKNS1_9DoubleValES6_S6_", true, "_ZN5doris12GeoFunctions17st_circle_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_from_wkt_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.VARCHAR, false, Type.DOUBLE, Type.DOUBLE, Type.DOUBLE);
        functionSet.addScalarAndVectorizedBuiltin("ST_Contains", "_ZN5doris12GeoFunctions11st_containsEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", true, "_ZN5doris12GeoFunctions19st_contains_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris12GeoFunctions17st_contains_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", Function.NullableMode.ALWAYS_NULLABLE, Type.BOOLEAN, false, Type.VARCHAR, Type.VARCHAR);
        functionSet.addScalarAndVectorizedBuiltin("grouping_id", "_ZN5doris21GroupingSetsFunctions11grouping_idEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BIGINT, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("grouping", "_ZN5doris21GroupingSetsFunctions8groupingEPN9doris_udf15FunctionContextERKNS1_9BigIntValE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.BIGINT, false, Type.BIGINT);
        functionSet.addScalarAndVectorizedBuiltin("domain", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("domain_without_www", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("protocol", "fake_symble_for_no_vec", true, null, null, Function.NullableMode.DEPEND_ON_ARGUMENT, Type.STRING, false, Type.STRING);
        functionSet.addScalarAndVectorizedBuiltin("multi_search_all_positions", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, new ArrayType(Type.INT), false, Type.STRING, new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("multi_match_any", "", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.TINYINT, false, Type.STRING, new ArrayType(Type.STRING));
        functionSet.addScalarAndVectorizedBuiltin("uuid", "_ZN5doris15StringFunctions4uuidEPN9doris_udf15FunctionContextE", true, null, null, Function.NullableMode.ALWAYS_NOT_NULLABLE, Type.VARCHAR, false);

        Set<String> funcNames = Sets.newHashSet();
        funcNames.add("unix_timestamp");
        funcNames.add("str_to_date");
        funcNames.add("convert_tz");
        funcNames.add("pi");
        funcNames.add("e");
        funcNames.add("divide");
        funcNames.add("int_divide");
        funcNames.add("pmod");
        funcNames.add("mod");
        funcNames.add("fmod");
        funcNames.add("substr");
        funcNames.add("substring");
        funcNames.add("append_trailing_char_if_absent");
        funcNames.add("ST_X");
        funcNames.add("ST_Y");
        funcNames.add("ST_AsText");
        funcNames.add("ST_GeometryFromText");
        funcNames.add("ST_LineFromText");
        funcNames.add("ST_Polygon");
        funcNames.add("ST_Contains");
        functionSet.buildNullResultWithOneNullParamFunction(funcNames);
        Set<String> nondeterministicFuncNames = Sets.newHashSet();
        nondeterministicFuncNames.add("rand");
        nondeterministicFuncNames.add("now");
        nondeterministicFuncNames.add("current_timestamp");
        nondeterministicFuncNames.add("localtime");
        nondeterministicFuncNames.add("localtimestamp");
        nondeterministicFuncNames.add("curdate");
        nondeterministicFuncNames.add("current_date");
        nondeterministicFuncNames.add("curtime");
        nondeterministicFuncNames.add("current_time");
        nondeterministicFuncNames.add("utc_timestamp");
        nondeterministicFuncNames.add("uuid");
        functionSet.buildNondeterministicFunctions(nondeterministicFuncNames);
        funcNames = Sets.newHashSet();
        funcNames.add("unix_timestamp");
        funcNames.add("str_to_date");
        funcNames.add("convert_tz");
        funcNames.add("pi");
        funcNames.add("e");
        funcNames.add("divide");
        funcNames.add("int_divide");
        funcNames.add("pmod");
        funcNames.add("mod");
        funcNames.add("fmod");
        funcNames.add("substr");
        funcNames.add("substring");
        funcNames.add("append_trailing_char_if_absent");
        funcNames.add("ST_X");
        funcNames.add("ST_Y");
        funcNames.add("ST_AsText");
        funcNames.add("ST_GeometryFromText");
        funcNames.add("ST_LineFromText");
        funcNames.add("ST_Polygon");
        funcNames.add("ST_Contains");
        functionSet.buildNullResultWithOneNullParamFunction(funcNames);
  }
}
