/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.logging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.RollingFileAppender$;
import org.apache.spark.util.logging.RollingPolicy;
import org.spark_project.guava.io.Files;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf!\u0002\u0017.\u0001E:\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u001d!\u0007A1A\u0005\n\u0015DaA\u001a\u0001!\u0002\u00131\u0006bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000b5\u0004A\u0011\t8\t\u000bI\u0004A\u0011K:\t\u000by\u0004A\u0011\u00028\t\r}\u0004A\u0011BA\u0001\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aa!!\u0005\u0001\t\u0013q\u0007bBA\n\u0001\u0011\u0005qF\\\u0004\t\u0003+i\u0003\u0012A\u0019\u0002\u0018\u00199A&\fE\u0001c\u0005e\u0001B\u0002/\u0015\t\u0003\t\t\u0003C\u0005\u0002$Q\u0011\r\u0011\"\u0001\u0002&!A\u00111\u0007\u000b!\u0002\u0013\t9\u0003C\u0005\u00026Q\u0011\r\u0011\"\u0001\u0002&!A\u0011q\u0007\u000b!\u0002\u0013\t9\u0003C\u0005\u0002:Q\u0011\r\u0011\"\u0001\u0002&!A\u00111\b\u000b!\u0002\u0013\t9\u0003C\u0005\u0002>Q\u0011\r\u0011\"\u0001\u0002&!A\u0011q\b\u000b!\u0002\u0013\t9\u0003C\u0005\u0002BQ\u0011\r\u0011\"\u0001\u0002&!A\u00111\t\u000b!\u0002\u0013\t9\u0003C\u0005\u0002FQ\u0011\r\u0011\"\u0001\u0002&!A\u0011q\t\u000b!\u0002\u0013\t9\u0003C\u0005\u0002JQ\u0011\r\u0011\"\u0001\u0002&!A\u00111\n\u000b!\u0002\u0013\t9\u0003\u0003\u0005\u0002NQ\u0011\r\u0011\"\u0001f\u0011\u001d\ty\u0005\u0006Q\u0001\nYC\u0011\"!\u0015\u0015\u0005\u0004%\t!!\n\t\u0011\u0005MC\u0003)A\u0005\u0003OA\u0011\"!\u0016\u0015\u0005\u0004%\t!!\n\t\u0011\u0005]C\u0003)A\u0005\u0003OAq!!\u0017\u0015\t\u0003\tY\u0006C\u0005\u0002\fR\t\n\u0011\"\u0001\u0002\u000e\n\u0019\"k\u001c7mS:<g)\u001b7f\u0003B\u0004XM\u001c3fe*\u0011afL\u0001\bY><w-\u001b8h\u0015\t\u0001\u0014'\u0001\u0003vi&d'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0014\u0005\u0001A\u0004CA\u001d;\u001b\u0005i\u0013BA\u001e.\u000511\u0015\u000e\\3BaB,g\u000eZ3s\u0003-Ig\u000e];u'R\u0014X-Y7\u0004\u0001A\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0003S>T\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\nY\u0011J\u001c9viN#(/Z1n\u0003)\t7\r^5wK\u001aKG.\u001a\t\u0003\u007f!K!!\u0013!\u0003\t\u0019KG.Z\u0001\u000ee>dG.\u001b8h!>d\u0017nY=\u0016\u00031\u0003\"!O'\n\u00059k#!\u0004*pY2Lgn\u001a)pY&\u001c\u00170\u0001\bs_2d\u0017N\\4Q_2L7-\u001f\u0011\u0002\t\r|gN\u001a\t\u0003%Nk\u0011!M\u0005\u0003)F\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015\t,hMZ3s'&TX\r\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006LA\u0002J]R\fa\u0001P5oSRtDC\u00020`A\u0006\u00147\r\u0005\u0002:\u0001!)Ah\u0002a\u0001}!)ai\u0002a\u0001\u000f\")!j\u0002a\u0001\u0019\")\u0001k\u0002a\u0001#\"9Qk\u0002I\u0001\u0002\u00041\u0016\u0001E7bqJ+G/Y5oK\u00124\u0015\u000e\\3t+\u00051\u0016!E7bqJ+G/Y5oK\u00124\u0015\u000e\\3tA\u0005\tRM\\1cY\u0016\u001cu.\u001c9sKN\u001c\u0018n\u001c8\u0016\u0003%\u0004\"a\u00166\n\u0005-D&a\u0002\"p_2,\u0017M\\\u0001\u0013K:\f'\r\\3D_6\u0004(/Z:tS>t\u0007%\u0001\u0003ti>\u0004H#A8\u0011\u0005]\u0003\u0018BA9Y\u0005\u0011)f.\u001b;\u0002\u0019\u0005\u0004\b/\u001a8e)>4\u0015\u000e\\3\u0015\u0007=$H\u0010C\u0003v\u001b\u0001\u0007a/A\u0003csR,7\u000fE\u0002XofL!\u0001\u001f-\u0003\u000b\u0005\u0013(/Y=\u0011\u0005]S\u0018BA>Y\u0005\u0011\u0011\u0015\u0010^3\t\u000bul\u0001\u0019\u0001,\u0002\u00071,g.\u0001\u0005s_2dwN^3s\u0003)\u0011x\u000e^1uK\u001aKG.\u001a\u000b\u0006_\u0006\r\u0011Q\u0001\u0005\u0006\r>\u0001\ra\u0012\u0005\u0007\u0003\u000fy\u0001\u0019A$\u0002\u0019I|G\u000e\\8wKJ4\u0015\u000e\\3\u0002#I|G\u000e\\8wKJ4\u0015\u000e\\3Fq&\u001cH\u000fF\u0002j\u0003\u001bAa!a\u0004\u0011\u0001\u00049\u0015\u0001\u00024jY\u0016\f\u0001\"\\8wK\u001aKG.Z\u0001\u000fI\u0016dW\r^3PY\u00124\u0015\u000e\\3t\u0003M\u0011v\u000e\u001c7j]\u001e4\u0015\u000e\\3BaB,g\u000eZ3s!\tIDcE\u0002\u0015\u00037\u00012aVA\u000f\u0013\r\ty\u0002\u0017\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005]\u0011!E*U%\u0006#ViR-`!J{\u0005+\u0012*U3V\u0011\u0011q\u0005\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006\"\u0002\t1\fgnZ\u0005\u0005\u0003c\tYC\u0001\u0004TiJLgnZ\u0001\u0013'R\u0013\u0016\tV#H3~\u0003&k\u0014)F%RK\u0006%\u0001\tT)J\u000bE+R$Z?\u0012+e)Q+M)\u0006\t2\u000b\u0016*B)\u0016;\u0015l\u0018#F\r\u0006+F\n\u0016\u0011\u0002#%sE+\u0012*W\u00032{\u0006KU(Q\u000bJ#\u0016,\u0001\nJ\u001dR+%KV!M?B\u0013v\nU#S)f\u0003\u0013\u0001E%O)\u0016\u0013f+\u0011'`\t\u00163\u0015)\u0016'U\u0003EIe\nV#S-\u0006cu\fR#G\u0003VcE\u000bI\u0001\u000e'&SVi\u0018)S\u001fB+%\u000bV-\u0002\u001dMK%,R0Q%>\u0003VI\u0015+ZA\u0005a1+\u0013.F?\u0012+e)Q+M)\u0006i1+\u0013.F?\u0012+e)Q+M)\u0002\nqCU#U\u0003&sU\tR0G\u00132+5k\u0018)S\u001fB+%\u000bV-\u00021I+E+Q%O\u000b\u0012{f)\u0013'F'~\u0003&k\u0014)F%RK\u0006%A\nE\u000b\u001a\u000bU\u000b\u0014+`\u0005V3e)\u0012*`'&SV)\u0001\u000bE\u000b\u001a\u000bU\u000b\u0014+`\u0005V3e)\u0012*`'&SV\tI\u0001\u0013\u000b:\u000b%\tT#`\u0007>k\u0005KU#T'&{e*A\nF\u001d\u0006\u0013E*R0D\u001f6\u0003&+R*T\u0013>s\u0005%A\bH5&\u0003v\fT(H?N+fIR%Y\u0003A9%,\u0013)`\u0019>;ulU+G\r&C\u0006%\u0001\rhKR\u001cvN\u001d;fIJ{G\u000e\\3e\u001fZ,'OR5mKN$b!!\u0018\u0002v\u0005\u001d\u0005#BA0\u0003_:e\u0002BA1\u0003WrA!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0004\u0003Oj\u0014A\u0002\u001fs_>$h(C\u0001Z\u0013\r\ti\u0007W\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t(a\u001d\u0003\u0007M+\u0017OC\u0002\u0002naCq!a\u001e+\u0001\u0004\tI(A\u0005eSJ,7\r^8ssB!\u00111PAB\u001d\u0011\ti(a \u0011\u0007\u0005\r\u0004,C\u0002\u0002\u0002b\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0019\u0003\u000bS1!!!Y\u0011\u001d\tII\u000ba\u0001\u0003s\na\"Y2uSZ,g)\u001b7f\u001d\u0006lW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003\u001fS3AVAIW\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\u0013Ut7\r[3dW\u0016$'bAAO1\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0016q\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class RollingFileAppender
extends FileAppender {
    public final File org$apache$spark$util$logging$RollingFileAppender$$activeFile;
    private final RollingPolicy rollingPolicy;
    private final int maxRetainedFiles;
    private final boolean enableCompression;

    public static int $lessinit$greater$default$5() {
        return RollingFileAppender$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<File> getSortedRolledOverFiles(String string, String string2) {
        return RollingFileAppender$.MODULE$.getSortedRolledOverFiles(string, string2);
    }

    public static String GZIP_LOG_SUFFIX() {
        return RollingFileAppender$.MODULE$.GZIP_LOG_SUFFIX();
    }

    public static String ENABLE_COMPRESSION() {
        return RollingFileAppender$.MODULE$.ENABLE_COMPRESSION();
    }

    public static int DEFAULT_BUFFER_SIZE() {
        return RollingFileAppender$.MODULE$.DEFAULT_BUFFER_SIZE();
    }

    public static String RETAINED_FILES_PROPERTY() {
        return RollingFileAppender$.MODULE$.RETAINED_FILES_PROPERTY();
    }

    public static String SIZE_DEFAULT() {
        return RollingFileAppender$.MODULE$.SIZE_DEFAULT();
    }

    public static String SIZE_PROPERTY() {
        return RollingFileAppender$.MODULE$.SIZE_PROPERTY();
    }

    public static String INTERVAL_DEFAULT() {
        return RollingFileAppender$.MODULE$.INTERVAL_DEFAULT();
    }

    public static String INTERVAL_PROPERTY() {
        return RollingFileAppender$.MODULE$.INTERVAL_PROPERTY();
    }

    public static String STRATEGY_DEFAULT() {
        return RollingFileAppender$.MODULE$.STRATEGY_DEFAULT();
    }

    public static String STRATEGY_PROPERTY() {
        return RollingFileAppender$.MODULE$.STRATEGY_PROPERTY();
    }

    public RollingPolicy rollingPolicy() {
        return this.rollingPolicy;
    }

    private int maxRetainedFiles() {
        return this.maxRetainedFiles;
    }

    private boolean enableCompression() {
        return this.enableCompression;
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public void appendToFile(byte[] bytes, int len) {
        if (this.rollingPolicy().shouldRollover(len)) {
            this.rollover();
            this.rollingPolicy().rolledOver();
        }
        super.appendToFile(bytes, len);
        this.rollingPolicy().bytesWritten(len);
    }

    private void rollover() {
        try {
            this.closeFile();
            this.moveFile();
            this.openFile();
            if (this.maxRetainedFiles() > 0) {
                this.deleteOldFiles();
            }
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Error rolling over ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).toString(), e);
        }
    }

    private void rotateFile(File activeFile, File rolloverFile) {
        if (this.enableCompression()) {
            File gzFile = new File(new StringBuilder(0).append(rolloverFile.getAbsolutePath()).append(RollingFileAppender$.MODULE$.GZIP_LOG_SUFFIX()).toString());
            GZIPOutputStream gzOutputStream = null;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(activeFile);
                gzOutputStream = new GZIPOutputStream(new FileOutputStream(gzFile));
                IOUtils.copy((InputStream)inputStream, (OutputStream)gzOutputStream);
                ((InputStream)inputStream).close();
                gzOutputStream.close();
                activeFile.delete();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(gzOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)gzOutputStream);
        } else {
            Files.move((File)activeFile, (File)rolloverFile);
        }
    }

    private boolean rolloverFileExist(File file) {
        return file.exists() || new File(new StringBuilder(0).append(file.getAbsolutePath()).append(RollingFileAppender$.MODULE$.GZIP_LOG_SUFFIX()).toString()).exists();
    }

    private void moveFile() {
        String rolloverSuffix = this.rollingPolicy().generateRolledOverFileSuffix();
        File rolloverFile = new File(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParentFile(), new StringBuilder(0).append(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getName()).append(rolloverSuffix).toString()).getAbsoluteFile();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Attempting to rollover file ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).append(" to file ").append(rolloverFile).toString());
        if (this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.exists()) {
            if (!this.rolloverFileExist(rolloverFile)) {
                this.rotateFile(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile, rolloverFile);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Rolled over ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).append(" to ").append(rolloverFile).toString());
            } else {
                int i = 0;
                ObjectRef altRolloverFile = ObjectRef.create(null);
                do {
                    altRolloverFile.elem = new File(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParent(), new StringBuilder(2).append(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getName()).append(rolloverSuffix).append("--").append(i).toString()).getAbsoluteFile();
                } while (++i < 10000 && this.rolloverFileExist((File)altRolloverFile.elem));
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Rollover file ").append(rolloverFile).append(" already exists, ").append("rolled over ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).append(" to file ").append((File)altRolloverFile$1.elem).toString());
                this.rotateFile(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile, (File)altRolloverFile.elem);
            }
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("File ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).append(" does not exist").toString());
        }
    }

    public void deleteOldFiles() {
        try {
            File[] rolledoverFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParentFile().listFiles(new FileFilter(this){
                private final /* synthetic */ RollingFileAppender $outer;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean accept(File f) {
                    if (!f.getName().startsWith(this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getName())) return false;
                    File file = f;
                    File file2 = this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile;
                    if (file == null) {
                        if (file2 == null) return false;
                        return true;
                    } else if (((Object)file).equals(file2)) return false;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }))).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            File[] filesToBeDeleted = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rolledoverFiles)).take(package$.MODULE$.max(0, rolledoverFiles.length - this.maxRetainedFiles()));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToBeDeleted)).foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RollingFileAppender.$anonfun$deleteOldFiles$1(this, file)));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Error cleaning logs in directory ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParentFile().getAbsolutePath()).toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldFiles$1(RollingFileAppender $this, File file) {
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Deleting file executor log file ").append(file.getAbsolutePath()).toString());
        return file.delete();
    }

    public RollingFileAppender(InputStream inputStream, File activeFile, RollingPolicy rollingPolicy, SparkConf conf, int bufferSize) {
        this.org$apache$spark$util$logging$RollingFileAppender$$activeFile = activeFile;
        this.rollingPolicy = rollingPolicy;
        super(inputStream, activeFile, bufferSize);
        this.maxRetainedFiles = conf.getInt(RollingFileAppender$.MODULE$.RETAINED_FILES_PROPERTY(), -1);
        this.enableCompression = conf.getBoolean(RollingFileAppender$.MODULE$.ENABLE_COMPRESSION(), false);
    }
}

