/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage.memory;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfoManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.memory.BlockEvictionHandler;
import org.apache.spark.storage.memory.DeserializedMemoryEntry;
import org.apache.spark.storage.memory.DeserializedValuesHolder;
import org.apache.spark.storage.memory.MemoryEntry;
import org.apache.spark.storage.memory.MemoryEntryBuilder;
import org.apache.spark.storage.memory.PartiallySerializedBlock;
import org.apache.spark.storage.memory.PartiallyUnrolledIterator;
import org.apache.spark.storage.memory.SerializedMemoryEntry;
import org.apache.spark.storage.memory.SerializedValuesHolder;
import org.apache.spark.storage.memory.ValuesHolder;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t]e!\u0002\u0015*\u00015\u001a\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"A\u0001\f\u0001B\u0001B\u0003%\u0011\fC\u0003^\u0001\u0011\u0005a\fC\u0004f\u0001\t\u0007I\u0011\u00024\t\ri\u0004\u0001\u0015!\u0003h\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9\u0001\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\u0005\u0011%\t\t\u0003\u0001b\u0001\n\u0013\t9\u0001\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\u0005\u0011%\t)\u0003\u0001b\u0001\n\u0013\t9\u0003\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\r\u0011\u001d\tY\u0003\u0001C\u0005\u0003OAq!!\f\u0001\t\u0013\t9\u0003C\u0004\u00020\u0001!I!a\n\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBAC\u0001\u0011%\u0011q\u0011\u0005\t\u0003\u000b\u0004A\u0011A\u0016\u0002H\"A\u0011\u0011\u001d\u0001\u0005\u0002-\n\u0019\u000fC\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!Q\u0004\u0001\u0005\u0002\t}\u0001b\u0002B\u0012\u0001\u0011\u0005!Q\u0005\u0005\b\u0005[\u0001A\u0011\u0002B\u0018\u0011!\u0011Y\u0004\u0001C\u0001[\tu\u0002b\u0002B%\u0001\u0011E!1\n\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/BqA!\u0017\u0001\t\u0003\u0011Y\u0006C\u0004\u0003d\u0001!\tA!\u001a\t\u0013\t-\u0004!%A\u0005\u0002\t5\u0004b\u0002BB\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0005\u000b\u0003A\u0011AA\u0014\u0011\u001d\u00119\t\u0001C\u0005\u0005\u0013CqAa#\u0001\t\u0013\u0011)\u0003C\u0004\u0003\u000e\u0002!IAa$\u0003\u00175+Wn\u001c:z'R|'/\u001a\u0006\u0003U-\na!\\3n_JL(B\u0001\u0017.\u0003\u001d\u0019Ho\u001c:bO\u0016T!AL\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\n\u0004\u0001QR\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\r\u0005\u0002<}5\tAH\u0003\u0002>[\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002@y\t9Aj\\4hS:<\u0017\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002D\t6\tQ&\u0003\u0002F[\tI1\u000b]1sW\u000e{gNZ\u0001\u0011E2|7m[%oM>l\u0015M\\1hKJ\u0004\"\u0001S%\u000e\u0003-J!AS\u0016\u0003!\tcwnY6J]\u001a|W*\u00198bO\u0016\u0014\u0018!E:fe&\fG.\u001b>fe6\u000bg.Y4feB\u0011Q\nU\u0007\u0002\u001d*\u0011q*L\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018BA)O\u0005E\u0019VM]5bY&TXM]'b]\u0006<WM]\u0001\u000e[\u0016lwN]=NC:\fw-\u001a:\u0011\u0005Q3V\"A+\u000b\u0005)j\u0013BA,V\u00055iU-\\8ss6\u000bg.Y4fe\u0006!\"\r\\8dW\u00163\u0018n\u0019;j_:D\u0015M\u001c3mKJ\u0004\"AW.\u000e\u0003%J!\u0001X\u0015\u0003)\tcwnY6Fm&\u001cG/[8o\u0011\u0006tG\r\\3s\u0003\u0019a\u0014N\\5u}Q1q\fY1cG\u0012\u0004\"A\u0017\u0001\t\u000b\u00013\u0001\u0019\u0001\"\t\u000b\u00193\u0001\u0019A$\t\u000b-3\u0001\u0019\u0001'\t\u000bI3\u0001\u0019A*\t\u000ba3\u0001\u0019A-\u0002\u000f\u0015tGO]5fgV\tq\r\u0005\u0003i[>\u0014X\"A5\u000b\u0005)\\\u0017\u0001B;uS2T\u0011\u0001\\\u0001\u0005U\u00064\u0018-\u0003\u0002oS\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\"\u0001\u00139\n\u0005E\\#a\u0002\"m_\u000e\\\u0017\n\u001a\u0019\u0003gb\u00042A\u0017;w\u0013\t)\u0018FA\u0006NK6|'/_#oiJL\bCA<y\u0019\u0001!\u0011\"\u001f\u0005\u0002\u0002\u0003\u0005)\u0011A>\u0003\u0007}#\u0013'\u0001\u0005f]R\u0014\u0018.Z:!#\tax\u0010\u0005\u00026{&\u0011aP\u000e\u0002\b\u001d>$\b.\u001b8h!\r)\u0014\u0011A\u0005\u0004\u0003\u00071$aA!os\u0006)rN\u001c%fCB,fN]8mY6+Wn\u001c:z\u001b\u0006\u0004XCAA\u0005!!\tY!!\u0006\u0002\u001a\u0005eQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u000f5,H/\u00192mK*\u0019\u00111\u0003\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0018\u00055!a\u0002%bg\"l\u0015\r\u001d\t\u0004k\u0005m\u0011bAA\u000fm\t!Aj\u001c8h\u0003Yyg\u000eS3baVs'o\u001c7m\u001b\u0016lwN]=NCB\u0004\u0013AF8gM\"+\u0017\r]+oe>dG.T3n_JLX*\u00199\u0002/=4g\rS3baVs'o\u001c7m\u001b\u0016lwN]=NCB\u0004\u0013!F;oe>dG.T3n_JLH\u000b\u001b:fg\"|G\u000eZ\u000b\u0003\u00033\ta#\u001e8s_2dW*Z7pef$\u0006N]3tQ>dG\rI\u0001\n[\u0006DX*Z7pef\f!\"\\3n_JLXk]3e\u0003A\u0011Gn\\2lg6+Wn\u001c:z+N,G-A\u0004hKR\u001c\u0016N_3\u0015\t\u0005e\u0011Q\u0007\u0005\u0007\u0003o\u0011\u0002\u0019A8\u0002\u000f\tdwnY6JI\u0006A\u0001/\u001e;CsR,7/\u0006\u0003\u0002>\u0005eCCCA \u0003;\ny&a\u0019\u0002nQ!\u0011\u0011IA$!\r)\u00141I\u0005\u0004\u0003\u000b2$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0013\u001a\u0012\u0011!a\u0002\u0003\u0017\n!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\ti%a\u0015\u0002X5\u0011\u0011q\n\u0006\u0004\u0003#2\u0014a\u0002:fM2,7\r^\u0005\u0005\u0003+\nyE\u0001\u0005DY\u0006\u001c8\u000fV1h!\r9\u0018\u0011\f\u0003\u0007\u00037\u001a\"\u0019A>\u0003\u0003QCa!a\u000e\u0014\u0001\u0004y\u0007bBA1'\u0001\u0007\u0011\u0011D\u0001\u0005g&TX\rC\u0004\u0002fM\u0001\r!a\u001a\u0002\u00155,Wn\u001c:z\u001b>$W\rE\u0002U\u0003SJ1!a\u001bV\u0005)iU-\\8ss6{G-\u001a\u0005\b\u0003_\u001a\u0002\u0019AA9\u0003\u0019y&-\u001f;fgB)Q'a\u001d\u0002x%\u0019\u0011Q\u000f\u001c\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BA=\u0003\u0003k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0003S>T!A[\u0017\n\t\u0005\r\u00151\u0010\u0002\u0012\u0007\",hn[3e\u0005f$XMQ;gM\u0016\u0014\u0018a\u00039vi&#XM]1u_J,B!!#\u00022Ra\u00111RAR\u0003K\u000b\u0019,!/\u0002<BA\u0011QRAO\u00033\tIB\u0004\u0003\u0002\u0010\u0006ee\u0002BAI\u0003/k!!a%\u000b\u0007\u0005U\u0015)\u0001\u0004=e>|GOP\u0005\u0002o%\u0019\u00111\u0014\u001c\u0002\u000fA\f7m[1hK&!\u0011qTAQ\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u00111\u0014\u001c\t\r\u0005]B\u00031\u0001p\u0011\u001d\t9\u000b\u0006a\u0001\u0003S\u000baA^1mk\u0016\u001c\bCBAG\u0003W\u000by+\u0003\u0003\u0002.\u0006\u0005&\u0001C%uKJ\fGo\u001c:\u0011\u0007]\f\t\f\u0002\u0004\u0002\\Q\u0011\ra\u001f\u0005\b\u0003k#\u0002\u0019AA\\\u0003!\u0019G.Y:t)\u0006<\u0007CBA'\u0003'\ny\u000bC\u0004\u0002fQ\u0001\r!a\u001a\t\u000f\u0005uF\u00031\u0001\u0002@\u0006aa/\u00197vKNDu\u000e\u001c3feB)!,!1\u00020&\u0019\u00111Y\u0015\u0003\u0019Y\u000bG.^3t\u0011>dG-\u001a:\u0002'A,H/\u0013;fe\u0006$xN]!t-\u0006dW/Z:\u0016\t\u0005%\u0017Q\u001b\u000b\t\u0003\u0017\f9.!7\u0002^BA\u0011QRAO\u0003\u001b\fI\u0002E\u0003[\u0003\u001f\f\u0019.C\u0002\u0002R&\u0012\u0011\u0004U1si&\fG\u000e\\=V]J|G\u000e\\3e\u0013R,'/\u0019;peB\u0019q/!6\u0005\r\u0005mSC1\u0001|\u0011\u0019\t9$\u0006a\u0001_\"9\u0011qU\u000bA\u0002\u0005m\u0007CBAG\u0003W\u000b\u0019\u000eC\u0004\u00026V\u0001\r!a8\u0011\r\u00055\u00131KAj\u0003I\u0001X\u000f^%uKJ\fGo\u001c:Bg\nKH/Z:\u0016\t\u0005\u0015\u0018\u0011\u001f\u000b\u000b\u0003O\f\u00190!>\u0002z\u0006u\b\u0003CAG\u0003;\u000bI/!\u0007\u0011\u000bi\u000bY/a<\n\u0007\u00055\u0018F\u0001\rQCJ$\u0018.\u00197msN+'/[1mSj,GM\u00117pG.\u00042a^Ay\t\u0019\tYF\u0006b\u0001w\"1\u0011q\u0007\fA\u0002=Dq!a*\u0017\u0001\u0004\t9\u0010\u0005\u0004\u0002\u000e\u0006-\u0016q\u001e\u0005\b\u0003k3\u0002\u0019AA~!\u0019\ti%a\u0015\u0002p\"9\u0011Q\r\fA\u0002\u0005\u001d\u0014\u0001C4fi\nKH/Z:\u0015\t\t\r!\u0011\u0002\t\u0006k\t\u0015\u0011qO\u0005\u0004\u0005\u000f1$AB(qi&|g\u000e\u0003\u0004\u00028]\u0001\ra\\\u0001\nO\u0016$h+\u00197vKN$BAa\u0004\u0003\u001cA)QG!\u0002\u0003\u0012A\"!1\u0003B\f!\u0019\ti)a+\u0003\u0016A\u0019qOa\u0006\u0005\u0015\te\u0001$!A\u0001\u0002\u000b\u00051PA\u0002`IIBa!a\u000e\u0019\u0001\u0004y\u0017A\u0002:f[>4X\r\u0006\u0003\u0002B\t\u0005\u0002BBA\u001c3\u0001\u0007q.A\u0003dY\u0016\f'\u000f\u0006\u0002\u0003(A\u0019QG!\u000b\n\u0007\t-bG\u0001\u0003V]&$\u0018\u0001C4fiJ#G-\u00133\u0015\t\tE\"\u0011\b\t\u0006k\t\u0015!1\u0007\t\u0004k\tU\u0012b\u0001B\u001cm\t\u0019\u0011J\u001c;\t\r\u0005]2\u00041\u0001p\u0003Y)g/[2u\u00052|7m[:U_\u001a\u0013X-Z*qC\u000e,G\u0003CA\r\u0005\u007f\u0011\u0019Ea\u0012\t\u000f\u0005]B\u00041\u0001\u0003BA!QG!\u0002p\u0011\u001d\u0011)\u0005\ba\u0001\u00033\tQa\u001d9bG\u0016Dq!!\u001a\u001d\u0001\u0004\t9'A\bbMR,'\u000f\u0012:pa\u0006\u001bG/[8o)\u0011\u00119C!\u0014\t\r\u0005]R\u00041\u0001p\u0003!\u0019wN\u001c;bS:\u001cH\u0003BA!\u0005'Ba!a\u000e\u001f\u0001\u0004y\u0017\u0001F2veJ,g\u000e\u001e+bg.\fE\u000f^3naRLE\r\u0006\u0002\u0002\u001a\u0005q\"/Z:feZ,WK\u001c:pY2lU-\\8ss\u001a{'\u000f\u00165jgR\u000b7o\u001b\u000b\t\u0003\u0003\u0012iFa\u0018\u0003b!1\u0011q\u0007\u0011A\u0002=DaA\u000b\u0011A\u0002\u0005e\u0001bBA3A\u0001\u0007\u0011qM\u0001\u001fe\u0016dW-Y:f+:\u0014x\u000e\u001c7NK6|'/\u001f$peRC\u0017n\u001d+bg.$bAa\n\u0003h\t%\u0004bBA3C\u0001\u0007\u0011q\r\u0005\tU\u0005\u0002\n\u00111\u0001\u0002\u001a\u0005A#/\u001a7fCN,WK\u001c:pY2lU-\\8ss\u001a{'\u000f\u00165jgR\u000b7o\u001b\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u000e\u0016\u0005\u00033\u0011\th\u000b\u0002\u0003tA!!Q\u000fB@\u001b\t\u00119H\u0003\u0003\u0003z\tm\u0014!C;oG\",7m[3e\u0015\r\u0011iHN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BA\u0005o\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003M\u0019WO\u001d:f]R,fN]8mY6+Wn\u001c:z\u0003y\u0019WO\u001d:f]R,fN]8mY6+Wn\u001c:z\r>\u0014H\u000b[5t)\u0006\u001c8.A\tok6$\u0016m]6t+:\u0014x\u000e\u001c7j]\u001e,\"Aa\r\u0002\u001d1|w-T3n_JLXk]1hK\u00069Bn\\4V]J|G\u000e\u001c$bS2,(/Z'fgN\fw-\u001a\u000b\u0007\u0005O\u0011\tJa%\t\r\u0005]r\u00051\u0001p\u0011\u001d\u0011)j\na\u0001\u00033\tqBZ5oC24Vm\u0019;peNK'0\u001a")
public class MemoryStore
implements Logging {
    private final SparkConf conf;
    private final BlockInfoManager blockInfoManager;
    private final SerializerManager serializerManager;
    private final MemoryManager memoryManager;
    private final BlockEvictionHandler blockEvictionHandler;
    private final LinkedHashMap<BlockId, MemoryEntry<?>> entries;
    private final HashMap<Object, Object> onHeapUnrollMemoryMap;
    private final HashMap<Object, Object> offHeapUnrollMemoryMap;
    private final long unrollMemoryThreshold;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LinkedHashMap<BlockId, MemoryEntry<?>> entries() {
        return this.entries;
    }

    private HashMap<Object, Object> onHeapUnrollMemoryMap() {
        return this.onHeapUnrollMemoryMap;
    }

    private HashMap<Object, Object> offHeapUnrollMemoryMap() {
        return this.offHeapUnrollMemoryMap;
    }

    private long unrollMemoryThreshold() {
        return this.unrollMemoryThreshold;
    }

    private long maxMemory() {
        return this.memoryManager.maxOnHeapStorageMemory() + this.memoryManager.maxOffHeapStorageMemory();
    }

    private long memoryUsed() {
        return this.memoryManager.storageMemoryUsed();
    }

    private long blocksMemoryUsed() {
        long l;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            l = this.memoryUsed() - this.currentUnrollMemory();
        }
        return l;
    }

    public long getSize(BlockId blockId) {
        long l;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            l = this.entries().get(blockId).size();
        }
        return l;
    }

    public <T> boolean putBytes(BlockId blockId, long size, MemoryMode memoryMode, Function0<ChunkedByteBuffer> _bytes, ClassTag<T> evidence$2) {
        boolean bl;
        Predef$.MODULE$.require(!this.contains(blockId), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Block ").append(blockId).append(" is already present in the MemoryStore").toString());
        if (this.memoryManager.acquireStorageMemory(blockId, size, memoryMode)) {
            ChunkedByteBuffer bytes = (ChunkedByteBuffer)_bytes.apply();
            Predef$.MODULE$.assert(bytes.size() == size);
            SerializedMemoryEntry entry = new SerializedMemoryEntry(bytes, memoryMode, (ClassTag)Predef$.MODULE$.implicitly(evidence$2));
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                MemoryEntry cfr_ignored_0 = this.entries().put(blockId, entry);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Block %s stored as bytes in memory (estimated size %s, free %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blockId, Utils$.MODULE$.bytesToString(size), Utils$.MODULE$.bytesToString(this.maxMemory() - this.blocksMemoryUsed())})));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private <T> Either<Object, Object> putIterator(BlockId blockId, Iterator<T> values, ClassTag<T> classTag, MemoryMode memoryMode, ValuesHolder<T> valuesHolder) {
        Left left;
        Predef$.MODULE$.require(!this.contains(blockId), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Block ").append(blockId).append(" is already present in the MemoryStore").toString());
        int elementsUnrolled = 0;
        boolean keepUnrolling = true;
        long initialMemoryThreshold = this.unrollMemoryThreshold();
        long memoryCheckPeriod = BoxesRunTime.unboxToLong((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.UNROLL_MEMORY_CHECK_PERIOD()));
        long memoryThreshold = initialMemoryThreshold;
        double memoryGrowthFactor = BoxesRunTime.unboxToDouble((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.UNROLL_MEMORY_GROWTH_FACTOR()));
        long unrollMemoryUsedByThisBlock = 0L;
        keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, initialMemoryThreshold, memoryMode);
        if (!keepUnrolling) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Failed to reserve initial memory threshold of ").append(Utils$.MODULE$.bytesToString(initialMemoryThreshold)).append(" for computing block ").append(blockId).append(" in memory.").toString());
        } else {
            unrollMemoryUsedByThisBlock += initialMemoryThreshold;
        }
        while (values.hasNext() && keepUnrolling) {
            long currentSize;
            valuesHolder.storeValue(values.next());
            if ((long)elementsUnrolled % memoryCheckPeriod == 0L && (currentSize = valuesHolder.estimatedSize()) >= memoryThreshold) {
                long amountToRequest = (long)((double)currentSize * memoryGrowthFactor - (double)memoryThreshold);
                keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, amountToRequest, memoryMode);
                if (keepUnrolling) {
                    unrollMemoryUsedByThisBlock += amountToRequest;
                }
                memoryThreshold += amountToRequest;
            }
            ++elementsUnrolled;
        }
        if (keepUnrolling) {
            long amountToRequest;
            MemoryEntryBuilder<T> entryBuilder = valuesHolder.getBuilder();
            long size = entryBuilder.preciseSize();
            if (size > unrollMemoryUsedByThisBlock && (keepUnrolling = this.reserveUnrollMemoryForThisTask(blockId, amountToRequest = size - unrollMemoryUsedByThisBlock, memoryMode))) {
                unrollMemoryUsedByThisBlock += amountToRequest;
            }
            if (keepUnrolling) {
                MemoryEntry entry = entryBuilder.build();
                MemoryManager memoryManager = this.memoryManager;
                synchronized (memoryManager) {
                    this.releaseUnrollMemoryForThisTask(memoryMode, unrollMemoryUsedByThisBlock);
                    boolean success = this.memoryManager.acquireStorageMemory(blockId, entry.size(), memoryMode);
                    Predef$.MODULE$.assert(success, (Function0 & Serializable & scala.Serializable)() -> "transferring unroll memory to storage memory failed");
                }
                LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
                synchronized (linkedHashMap) {
                    this.entries().put(blockId, entry);
                }
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Block %s stored as values in memory (estimated size %s, free %s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blockId, Utils$.MODULE$.bytesToString(entry.size()), Utils$.MODULE$.bytesToString(this.maxMemory() - this.blocksMemoryUsed())})));
                left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)entry.size()));
            } else {
                this.logUnrollFailureMessage(blockId, entryBuilder.preciseSize());
                left = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToLong((long)unrollMemoryUsedByThisBlock));
            }
        } else {
            this.logUnrollFailureMessage(blockId, valuesHolder.estimatedSize());
            left = package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToLong((long)unrollMemoryUsedByThisBlock));
        }
        return left;
    }

    public <T> Either<PartiallyUnrolledIterator<T>, Object> putIteratorAsValues(BlockId blockId, Iterator<T> values, ClassTag<T> classTag) {
        Right right;
        DeserializedValuesHolder<T> valuesHolder = new DeserializedValuesHolder<T>(classTag);
        Either<Object, Object> either = this.putIterator(blockId, values, classTag, MemoryMode.ON_HEAP, valuesHolder);
        if (either instanceof Right) {
            Right right2 = (Right)either;
            long storedSize = BoxesRunTime.unboxToLong((Object)right2.value());
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)storedSize));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            long unrollMemoryUsedByThisBlock = BoxesRunTime.unboxToLong((Object)left.value());
            Iterator unrolledIterator = valuesHolder.vector() != null ? valuesHolder.vector().iterator() : Predef$.MODULE$.genericArrayOps(valuesHolder.arrayValues()).toIterator();
            right = package$.MODULE$.Left().apply(new PartiallyUnrolledIterator<T>(this, MemoryMode.ON_HEAP, unrollMemoryUsedByThisBlock, unrolledIterator, values));
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    public <T> Either<PartiallySerializedBlock<T>, Object> putIteratorAsBytes(BlockId blockId, Iterator<T> values, ClassTag<T> classTag, MemoryMode memoryMode) {
        Right right;
        int n;
        Predef$.MODULE$.require(!this.contains(blockId), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Block ").append(blockId).append(" is already present in the MemoryStore").toString());
        long initialMemoryThreshold = this.unrollMemoryThreshold();
        if (initialMemoryThreshold > (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Initial memory threshold of ").append(Utils$.MODULE$.bytesToString(initialMemoryThreshold)).append(" ").append("is too large to be set as chunk size. Chunk size has been capped to ").append(Utils$.MODULE$.bytesToString(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH)).toString());
            n = ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH;
        } else {
            n = (int)initialMemoryThreshold;
        }
        int chunkSize = n;
        SerializedValuesHolder<T> valuesHolder = new SerializedValuesHolder<T>(blockId, chunkSize, classTag, memoryMode, this.serializerManager);
        Either<Object, Object> either = this.putIterator(blockId, values, classTag, memoryMode, valuesHolder);
        if (either instanceof Right) {
            Right right2 = (Right)either;
            long storedSize = BoxesRunTime.unboxToLong((Object)right2.value());
            right = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)storedSize));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            long unrollMemoryUsedByThisBlock = BoxesRunTime.unboxToLong((Object)left.value());
            right = package$.MODULE$.Left().apply(new PartiallySerializedBlock<T>(this, this.serializerManager, blockId, valuesHolder.serializationStream(), valuesHolder.redirectableStream(), unrollMemoryUsedByThisBlock, memoryMode, valuesHolder.bbos(), values, classTag));
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    public Option<ChunkedByteBuffer> getBytes(BlockId blockId) {
        None$ none$;
        MemoryEntry<?> entry;
        MemoryEntry<?> memoryEntry;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            memoryEntry = this.entries().get(blockId);
        }
        MemoryEntry<?> memoryEntry2 = entry = memoryEntry;
        if (memoryEntry2 == null) {
            none$ = None$.MODULE$;
        } else {
            if (memoryEntry2 instanceof DeserializedMemoryEntry) {
                throw new IllegalArgumentException("should only call getBytes on serialized blocks");
            }
            if (memoryEntry2 instanceof SerializedMemoryEntry) {
                SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry2;
                ChunkedByteBuffer bytes = serializedMemoryEntry.buffer();
                none$ = new Some((Object)bytes);
            } else {
                throw new MatchError(memoryEntry2);
            }
        }
        return none$;
    }

    public Option<Iterator<?>> getValues(BlockId blockId) {
        None$ none$;
        MemoryEntry<?> entry;
        MemoryEntry<?> memoryEntry;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            memoryEntry = this.entries().get(blockId);
        }
        MemoryEntry<?> memoryEntry2 = entry = memoryEntry;
        if (memoryEntry2 == null) {
            none$ = None$.MODULE$;
        } else {
            if (memoryEntry2 instanceof SerializedMemoryEntry) {
                throw new IllegalArgumentException("should only call getValues on deserialized blocks");
            }
            if (memoryEntry2 instanceof DeserializedMemoryEntry) {
                DeserializedMemoryEntry deserializedMemoryEntry = (DeserializedMemoryEntry)memoryEntry2;
                Object values = deserializedMemoryEntry.value();
                Some x = new Some(values);
                none$ = x.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.genericArrayOps(x$1).iterator());
            } else {
                throw new MatchError(memoryEntry2);
            }
        }
        return none$;
    }

    public boolean remove(BlockId blockId) {
        boolean bl;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            boolean bl2;
            MemoryEntry memoryEntry;
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                memoryEntry = (MemoryEntry)this.entries().remove(blockId);
            }
            MemoryEntry entry = memoryEntry;
            if (entry != null) {
                MemoryEntry memoryEntry2 = entry;
                if (memoryEntry2 instanceof SerializedMemoryEntry) {
                    SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry2;
                    ChunkedByteBuffer buffer = serializedMemoryEntry.buffer();
                    buffer.dispose();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.memoryManager.releaseStorageMemory(entry.size(), entry.memoryMode());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Block ").append(blockId).append(" of size ").append(entry.size()).append(" dropped ").append("from memory (free ").append(this.maxMemory() - this.blocksMemoryUsed()).append(")").toString());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public void clear() {
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                this.entries().clear();
            }
            this.onHeapUnrollMemoryMap().clear();
            this.offHeapUnrollMemoryMap().clear();
            this.memoryManager.releaseAllStorageMemory();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "MemoryStore cleared");
        }
    }

    private Option<Object> getRddId(BlockId blockId) {
        return blockId.asRDDId().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.rddId()));
    }

    public long evictBlocksToFreeSpace(Option<BlockId> blockId2, long space, MemoryMode memoryMode) {
        long l;
        Predef$.MODULE$.assert(space > 0L);
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            long l2;
            LongRef freedMemory = LongRef.create((long)0L);
            Option rddToAdd = blockId2.flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.getRddId((BlockId)blockId));
            ArrayBuffer selectedBlocks = new ArrayBuffer();
            LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
            synchronized (linkedHashMap) {
                java.util.Iterator<Map.Entry<BlockId, MemoryEntry<?>>> iterator = this.entries().entrySet().iterator();
                while (freedMemory.elem < space && iterator.hasNext()) {
                    MemoryEntry<?> entry;
                    Map.Entry<BlockId, MemoryEntry<?>> pair = iterator.next();
                    BlockId blockId3 = pair.getKey();
                    if (!this.blockIsEvictable$1(blockId3, entry = pair.getValue(), memoryMode, rddToAdd) || !this.blockInfoManager.lockForWriting(blockId3, false).isDefined()) continue;
                    selectedBlocks.$plus$eq((Object)blockId3);
                    freedMemory.elem += pair.getValue().size();
                }
            }
            if (freedMemory.elem >= space) {
                IntRef lastSuccessfulBlock = IntRef.create((int)-1);
                try {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append(selectedBlocks.size()).append(" blocks selected for dropping ").append("(").append(Utils$.MODULE$.bytesToString(freedMemory$1.elem)).append(" bytes)").toString());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), selectedBlocks.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                        MemoryEntry<?> memoryEntry;
                        BlockId blockId = (BlockId)selectedBlocks.apply(idx);
                        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
                        synchronized (linkedHashMap) {
                            memoryEntry = this.entries().get(blockId);
                        }
                        MemoryEntry<?> entry = memoryEntry;
                        if (entry != null) {
                            this.dropBlock$1(blockId, entry);
                            this.afterDropAction(blockId);
                        }
                        lastSuccessfulBlock$1.elem = idx;
                    });
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("After dropping ").append(selectedBlocks.size()).append(" blocks, ").append("free memory is ").append(Utils$.MODULE$.bytesToString(this.maxMemory() - this.blocksMemoryUsed())).toString());
                    l2 = freedMemory.elem;
                }
                finally {
                    if (lastSuccessfulBlock.elem != selectedBlocks.size() - 1) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(lastSuccessfulBlock.elem + 1), selectedBlocks.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                            BlockId blockId = (BlockId)selectedBlocks.apply(idx);
                            $this.blockInfoManager.unlock(blockId, $this.blockInfoManager.unlock$default$2());
                        });
                    }
                }
            } else {
                blockId2.foreach((Function1 & Serializable & scala.Serializable)id -> {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Will not store ").append(id).toString());
                    return BoxedUnit.UNIT;
                });
                selectedBlocks.foreach((Function1 & Serializable & scala.Serializable)id -> {
                    this.blockInfoManager.unlock(id, this.blockInfoManager.unlock$default$2());
                    return BoxedUnit.UNIT;
                });
                l2 = 0L;
            }
            l = l2;
        }
        return l;
    }

    public void afterDropAction(BlockId blockId) {
    }

    public boolean contains(BlockId blockId) {
        boolean bl;
        LinkedHashMap<BlockId, MemoryEntry<?>> linkedHashMap = this.entries();
        synchronized (linkedHashMap) {
            bl = this.entries().containsKey(blockId);
        }
        return bl;
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public boolean reserveUnrollMemoryForThisTask(BlockId blockId, long memory, MemoryMode memoryMode) {
        boolean bl;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            boolean success = this.memoryManager.acquireUnrollMemory(blockId, memory, memoryMode);
            if (success) {
                HashMap<Object, Object> hashMap;
                long taskAttemptId = this.currentTaskAttemptId();
                MemoryMode memoryMode2 = memoryMode;
                if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
                    hashMap = this.onHeapUnrollMemoryMap();
                } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
                    hashMap = this.offHeapUnrollMemoryMap();
                } else {
                    throw new MatchError((Object)memoryMode2);
                }
                HashMap<Object, Object> unrollMemoryMap = hashMap;
                unrollMemoryMap.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)unrollMemoryMap.getOrElse((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + memory)));
            }
            bl = success;
        }
        return bl;
    }

    public void releaseUnrollMemoryForThisTask(MemoryMode memoryMode, long memory) {
        long taskAttemptId = this.currentTaskAttemptId();
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            Object object;
            HashMap<Object, Object> hashMap;
            MemoryMode memoryMode2 = memoryMode;
            if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
                hashMap = this.onHeapUnrollMemoryMap();
            } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
                hashMap = this.offHeapUnrollMemoryMap();
            } else {
                throw new MatchError((Object)memoryMode2);
            }
            HashMap<Object, Object> unrollMemoryMap = hashMap;
            if (unrollMemoryMap.contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) {
                long memoryToRelease = scala.math.package$.MODULE$.min(memory, BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))));
                if (memoryToRelease > 0L) {
                    unrollMemoryMap.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) - memoryToRelease)));
                    this.memoryManager.releaseUnrollMemory(memoryToRelease, memoryMode);
                }
                object = BoxesRunTime.unboxToLong((Object)unrollMemoryMap.apply((Object)BoxesRunTime.boxToLong((long)taskAttemptId))) == 0L ? unrollMemoryMap.remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
        }
    }

    public long releaseUnrollMemoryForThisTask$default$2() {
        return Long.MAX_VALUE;
    }

    public long currentUnrollMemory() {
        long l;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            l = BoxesRunTime.unboxToLong((Object)this.onHeapUnrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + BoxesRunTime.unboxToLong((Object)this.offHeapUnrollMemoryMap().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        return l;
    }

    public long currentUnrollMemoryForThisTask() {
        long l;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            l = BoxesRunTime.unboxToLong((Object)this.onHeapUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + BoxesRunTime.unboxToLong((Object)this.offHeapUnrollMemoryMap().getOrElse((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        }
        return l;
    }

    private int numTasksUnrolling() {
        int n;
        MemoryManager memoryManager = this.memoryManager;
        synchronized (memoryManager) {
            n = ((TraversableOnce)this.onHeapUnrollMemoryMap().keys().$plus$plus((GenTraversableOnce)this.offHeapUnrollMemoryMap().keys(), Iterable$.MODULE$.canBuildFrom())).toSet().size();
        }
        return n;
    }

    private void logMemoryUsage() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Memory use = ").append(Utils$.MODULE$.bytesToString(this.blocksMemoryUsed())).append(" (blocks) + ").append(Utils$.MODULE$.bytesToString(this.currentUnrollMemory())).append(" (scratch space shared across ").append(this.numTasksUnrolling()).append(" tasks(s)) = ").append(Utils$.MODULE$.bytesToString(this.memoryUsed())).append(". ").append("Storage limit = ").append(Utils$.MODULE$.bytesToString(this.maxMemory())).append(".").toString());
    }

    private void logUnrollFailureMessage(BlockId blockId, long finalVectorSize) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Not enough space to cache ").append(blockId).append(" in memory! ").append("(computed ").append(Utils$.MODULE$.bytesToString(finalVectorSize)).append(" so far)").toString());
        this.logMemoryUsage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean blockIsEvictable$1(BlockId blockId, MemoryEntry entry, MemoryMode memoryMode$1, Option rddToAdd$1) {
        MemoryMode memoryMode = entry.memoryMode();
        MemoryMode memoryMode2 = memoryMode$1;
        if (memoryMode == null) {
            if (memoryMode2 != null) {
                return false;
            }
        } else if (!((Object)((Object)memoryMode)).equals((Object)memoryMode2)) return false;
        if (rddToAdd$1.isEmpty()) return true;
        Option option = rddToAdd$1;
        Option<Object> option2 = this.getRddId(blockId);
        if (option == null) {
            if (option2 == null) return false;
            return true;
        } else if (option.equals(option2)) return false;
        return true;
    }

    public static final /* synthetic */ Either $anonfun$evictBlocksToFreeSpace$2(Either data$1) {
        return data$1;
    }

    private final void dropBlock$1(BlockId blockId, MemoryEntry entry) {
        Left left;
        MemoryEntry memoryEntry = entry;
        if (memoryEntry instanceof DeserializedMemoryEntry) {
            DeserializedMemoryEntry deserializedMemoryEntry = (DeserializedMemoryEntry)memoryEntry;
            Object values = deserializedMemoryEntry.value();
            left = package$.MODULE$.Left().apply(values);
        } else if (memoryEntry instanceof SerializedMemoryEntry) {
            SerializedMemoryEntry serializedMemoryEntry = (SerializedMemoryEntry)memoryEntry;
            ChunkedByteBuffer buffer = serializedMemoryEntry.buffer();
            left = package$.MODULE$.Right().apply((Object)buffer);
        } else {
            throw new MatchError((Object)memoryEntry);
        }
        Left data = left;
        StorageLevel newEffectiveStorageLevel = this.blockEvictionHandler.dropFromMemory(blockId, (Function0<Either<Object, ChunkedByteBuffer>>)((Function0 & Serializable & scala.Serializable)() -> MemoryStore.$anonfun$evictBlocksToFreeSpace$2((Either)data)), entry.classTag());
        if (newEffectiveStorageLevel.isValid()) {
            this.blockInfoManager.unlock(blockId, this.blockInfoManager.unlock$default$2());
        } else {
            this.blockInfoManager.removeBlock(blockId);
        }
    }

    public MemoryStore(SparkConf conf, BlockInfoManager blockInfoManager, SerializerManager serializerManager, MemoryManager memoryManager, BlockEvictionHandler blockEvictionHandler) {
        this.conf = conf;
        this.blockInfoManager = blockInfoManager;
        this.serializerManager = serializerManager;
        this.memoryManager = memoryManager;
        this.blockEvictionHandler = blockEvictionHandler;
        Logging.$init$(this);
        this.entries = new LinkedHashMap(32, 0.75f, true);
        this.onHeapUnrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.offHeapUnrollMemoryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.unrollMemoryThreshold = conf.getLong("spark.storage.unrollMemoryThreshold", 0x100000L);
        if (this.maxMemory() < this.unrollMemoryThreshold()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("Max memory ").append(Utils$.MODULE$.bytesToString(this.maxMemory())).append(" is less than the initial memory ").append("threshold ").append(Utils$.MODULE$.bytesToString(this.unrollMemoryThreshold())).append(" needed to store a block in ").append("memory. Please configure Spark with more memory.").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("MemoryStore started with capacity %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.bytesToString(this.maxMemory())})));
    }
}

