/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.CountingWritableChannel;
import org.apache.spark.storage.DiskBlockData;
import org.apache.spark.storage.DiskBlockManager;
import org.apache.spark.storage.EncryptedBlockData;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import org.spark_project.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb!\u0002\n\u0014\u0001UY\u0002\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u00119\u0002!\u0011!Q\u0001\n=B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006o\u0001!\t\u0001\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019\u0011\u0005\u0001)A\u0005\u007f!91\t\u0001b\u0001\n\u0013q\u0004B\u0002#\u0001A\u0003%q\bC\u0004F\u0001\t\u0007I\u0011\u0002$\t\rQ\u0003\u0001\u0015!\u0003H\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015I\b\u0001\"\u0001{\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\t\u0001\u0011%\u00111\u0003\u0002\n\t&\u001c8n\u0015;pe\u0016T!\u0001F\u000b\u0002\u000fM$xN]1hK*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xmE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0016\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0014%\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001CA\u0016-\u001b\u0005)\u0012BA\u0017\u0016\u0005%\u0019\u0006/\u0019:l\u0007>tg-A\u0006eSN\\W*\u00198bO\u0016\u0014\bC\u0001\u00192\u001b\u0005\u0019\u0012B\u0001\u001a\u0014\u0005A!\u0015n]6CY>\u001c7.T1oC\u001e,'/A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\tYS'\u0003\u00027+\ty1+Z2ve&$\u00180T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0005siZD\b\u0005\u00021\u0001!)\u0001\u0006\u0002a\u0001U!)a\u0006\u0002a\u0001_!)1\u0007\u0002a\u0001i\u0005\tR.\u001b8NK6|'/_'ba\nKH/Z:\u0016\u0003}\u0002\"!\b!\n\u0005\u0005s\"\u0001\u0002'p]\u001e\f!#\\5o\u001b\u0016lwN]=NCB\u0014\u0015\u0010^3tA\u0005\tR.\u0019=NK6|'/_'ba\nKH/Z:\u0002%5\f\u00070T3n_JLX*\u00199CsR,7\u000fI\u0001\u000bE2|7m[*ju\u0016\u001cX#A$\u0011\t!{\u0015kP\u0007\u0002\u0013*\u0011!jS\u0001\u000bG>t7-\u001e:sK:$(B\u0001'N\u0003\u0011)H/\u001b7\u000b\u00039\u000bAA[1wC&\u0011\u0001+\u0013\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001\u0019S\u0013\t\u00196CA\u0004CY>\u001c7.\u00133\u0002\u0017\tdwnY6TSj,7\u000fI\u0001\bO\u0016$8+\u001b>f)\tyt\u000bC\u0003Y\u0017\u0001\u0007\u0011+A\u0004cY>\u001c7.\u00133\u0002\u0007A,H\u000f\u0006\u0002\\YR\u0011Al\u0018\t\u0003;uK!A\u0018\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006A2\u0001\r!Y\u0001\noJLG/\u001a$v]\u000e\u0004B!\b2e9&\u00111M\b\u0002\n\rVt7\r^5p]F\u0002\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\u0011\rD\u0017M\u001c8fYNT!!['\u0002\u00079Lw.\u0003\u0002lM\n\u0019rK]5uC\ndWMQ=uK\u000eC\u0017M\u001c8fY\")\u0001\f\u0004a\u0001#\u0006A\u0001/\u001e;CsR,7\u000fF\u0002]_BDQ\u0001W\u0007A\u0002ECQ!]\u0007A\u0002I\fQAY=uKN\u0004\"a]<\u000e\u0003QT!!\u001e<\u0002\u0005%|'B\u0001'\u0016\u0013\tAHOA\tDQVt7.\u001a3CsR,')\u001e4gKJ\f\u0001bZ3u\u0005f$Xm\u001d\u000b\u0003wz\u0004\"\u0001\r?\n\u0005u\u001c\"!\u0003\"m_\u000e\\G)\u0019;b\u0011\u0015Af\u00021\u0001R\u0003\u0019\u0011X-\\8wKR!\u00111AA\u0005!\ri\u0012QA\u0005\u0004\u0003\u000fq\"a\u0002\"p_2,\u0017M\u001c\u0005\u00061>\u0001\r!U\u0001\tG>tG/Y5ogR!\u00111AA\b\u0011\u0015A\u0006\u00031\u0001R\u00031y\u0007/\u001a8G_J<&/\u001b;f)\r!\u0017Q\u0003\u0005\b\u0003/\t\u0002\u0019AA\r\u0003\u00111\u0017\u000e\\3\u0011\t\u0005m\u0011qD\u0007\u0003\u0003;Q!!^'\n\t\u0005\u0005\u0012Q\u0004\u0002\u0005\r&dW\r")
public class DiskStore
implements Logging {
    private final SparkConf conf;
    private final DiskBlockManager diskManager;
    private final SecurityManager securityManager;
    private final long minMemoryMapBytes;
    private final long maxMemoryMapBytes;
    private final ConcurrentHashMap<BlockId, Object> blockSizes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long minMemoryMapBytes() {
        return this.minMemoryMapBytes;
    }

    private long maxMemoryMapBytes() {
        return this.maxMemoryMapBytes;
    }

    private ConcurrentHashMap<BlockId, Object> blockSizes() {
        return this.blockSizes;
    }

    public long getSize(BlockId blockId) {
        return BoxesRunTime.unboxToLong((Object)this.blockSizes().get(blockId));
    }

    public void put(BlockId blockId, Function1<WritableByteChannel, BoxedUnit> writeFunc) {
        if (this.contains(blockId)) {
            throw new IllegalStateException(new StringBuilder(43).append("Block ").append(blockId).append(" is already present in the disk store").toString());
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Attempting to put block ").append(blockId).toString());
        long startTime = System.currentTimeMillis();
        File file = this.diskManager.getFile(blockId);
        CountingWritableChannel out = new CountingWritableChannel(this.openForWrite(file));
        boolean threwException = true;
        try {
            writeFunc.apply((Object)out);
            this.blockSizes().put(blockId, BoxesRunTime.boxToLong((long)out.getCount()));
            threwException = false;
        }
        finally {
            try {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    if (!threwException) {
                        threwException = true;
                        throw ioe;
                    }
                }
            }
            finally {
                if (threwException) {
                    this.remove(blockId);
                }
            }
        }
        long finishTime = System.currentTimeMillis();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Block %s stored as %s file on disk in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getName(), Utils$.MODULE$.bytesToString(file.length()), BoxesRunTime.boxToLong((long)(finishTime - startTime))})));
    }

    public void putBytes(BlockId blockId, ChunkedByteBuffer bytes) {
        this.put(blockId, (Function1<WritableByteChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)channel -> {
            bytes.writeFully(channel);
            return BoxedUnit.UNIT;
        });
    }

    public BlockData getBytes(BlockId blockId) {
        BlockData blockData;
        File file = this.diskManager.getFile(blockId.name());
        long blockSize = this.getSize(blockId);
        Option<byte[]> option = this.securityManager.getIOEncryptionKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] key = (byte[])some.value();
            blockData = new EncryptedBlockData(file, blockSize, this.conf, key);
        } else {
            blockData = new DiskBlockData(this.minMemoryMapBytes(), this.maxMemoryMapBytes(), file, blockSize);
        }
        return blockData;
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(BlockId blockId) {
        boolean bl;
        this.blockSizes().remove(blockId);
        File file = this.diskManager.getFile(blockId.name());
        if (file.exists()) {
            void var3_3;
            boolean ret = file.delete();
            if (!ret) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error deleting ").append(file.getPath()).toString());
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean contains(BlockId blockId) {
        File file = this.diskManager.getFile(blockId.name());
        return file.exists();
    }

    private WritableByteChannel openForWrite(File file) {
        WritableByteChannel writableByteChannel;
        FileChannel out = new FileOutputStream(file).getChannel();
        try {
            writableByteChannel = (WritableByteChannel)this.securityManager.getIOEncryptionKey().map((Function1 & Serializable & scala.Serializable)key -> CryptoStreamUtils$.MODULE$.createWritableChannel(out, $this.conf, (byte[])key)).getOrElse((Function0 & Serializable & scala.Serializable)() -> out);
        }
        catch (Exception e) {
            Closeables.close((Closeable)out, (boolean)true);
            file.delete();
            throw e;
        }
        return writableByteChannel;
    }

    public DiskStore(SparkConf conf, DiskBlockManager diskManager, SecurityManager securityManager) {
        this.conf = conf;
        this.diskManager = diskManager;
        this.securityManager = securityManager;
        Logging.$init$(this);
        this.minMemoryMapBytes = conf.getSizeAsBytes("spark.storage.memoryMapThreshold", "2m");
        this.maxMemoryMapBytes = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.MEMORY_MAP_LIMIT_FOR_TESTS()));
        this.blockSizes = new ConcurrentHashMap();
    }
}

