/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.DiskBlockObjectWriter;
import org.apache.spark.storage.DiskBlockObjectWriter$;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.TimeTrackingOutputStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d!\u0002#F\u0001\u001dk\u0005\u0002\u0003/\u0001\u0005\u000b\u0007I\u0011\u00010\t\u0011\t\u0004!\u0011!Q\u0001\n}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005W\"Aa\u000e\u0001B\u0001B\u0003%q\u000e\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011!I\bA!A!\u0002\u0013Q\bBCA\u0001\u0001\t\u0015\r\u0011\"\u0001\u0002\u0004!Q\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0002\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012\u0019I\u00111\u0005\u0001\u0011\u0002\u0007%\u0011Q\u0005\u0005\b\u0003OYA\u0011AA\u0015\u0011!\t\td\u0003I\u0005\u0002\u0005%\u0002bBA\u001a\u0017\u0011\u0005\u0011\u0011\u0006\u0005\u000f\u0003kY\u0001\u0013aA\u0001\u0002\u0013%\u0011\u0011FA\u001c\u0011%\tI\u0004\u0001a\u0001\n\u0013\tY\u0004C\u0005\u0002N\u0001\u0001\r\u0011\"\u0003\u0002P!A\u0011Q\u000b\u0001!B\u0013\ti\u0004C\u0005\u0002X\u0001\u0001\r\u0011\"\u0003\u0002Z!I\u0011q\f\u0001A\u0002\u0013%\u0011\u0011\r\u0005\t\u0003K\u0002\u0001\u0015)\u0003\u0002\\!I\u0011q\r\u0001A\u0002\u0013%\u0011\u0011\u000e\u0005\n\u0003W\u0002\u0001\u0019!C\u0005\u0003[Bq!!\u001d\u0001A\u0003&a\nC\u0005\u0002t\u0001\u0001\r\u0011\"\u0003\u0002v!I\u0011Q\u0010\u0001A\u0002\u0013%\u0011q\u0010\u0005\t\u0003\u0007\u0003\u0001\u0015)\u0003\u0002x!I\u0011Q\u0011\u0001A\u0002\u0013%\u0011q\u0011\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0005\u0003#C\u0001\"!&\u0001A\u0003&\u0011\u0011\u0012\u0005\n\u0003/\u0003\u0001\u0019!C\u0005\u00033C\u0011\"!)\u0001\u0001\u0004%I!a)\t\u0011\u0005\u001d\u0006\u0001)Q\u0005\u00037C\u0011\"!+\u0001\u0001\u0004%I!a+\t\u0013\u00055\u0006\u00011A\u0005\n\u0005=\u0006bBAZ\u0001\u0001\u0006KA\u001e\u0005\n\u0003k\u0003\u0001\u0019!C\u0005\u0003WC\u0011\"a.\u0001\u0001\u0004%I!!/\t\u000f\u0005u\u0006\u0001)Q\u0005m\"I\u0011q\u0018\u0001A\u0002\u0013%\u00111\u0016\u0005\n\u0003\u0003\u0004\u0001\u0019!C\u0005\u0003\u0007Dq!a2\u0001A\u0003&a\u000fC\u0005\u0002J\u0002\u0001\r\u0011\"\u0003\u0002L\"I\u00111\u001b\u0001A\u0002\u0013%\u0011Q\u001b\u0005\t\u00033\u0004\u0001\u0015)\u0003\u0002N\"I\u00111\u001c\u0001A\u0002\u0013%\u00111\u001a\u0005\n\u0003;\u0004\u0001\u0019!C\u0005\u0003?D\u0001\"a9\u0001A\u0003&\u0011Q\u001a\u0005\n\u0003K\u0004\u0001\u0019!C\u0005\u0003OD\u0011\"!;\u0001\u0001\u0004%I!a;\t\u000f\u0005=\b\u0001)Q\u0005_\"9\u0011\u0011\u001f\u0001\u0005\n\u0005%\u0002bBAz\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0003o\u0004A\u0011BA\u0015\u0011\u001d\t\t\u0004\u0001C!\u0003SAq!!?\u0001\t\u0003\tY\u0010C\u0004\u0003\u0004\u0001!\tA!\u0002\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!9!q\u0001\u0001\u0005B\te\u0001b\u0002B\u0004\u0001\u0011\u0005#q\u0004\u0005\b\u0005s\u0001A\u0011AA\u0015\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0003SA\u0001B!\u0010\u0001\t\u0003:\u0015\u0011F\u0004\u000b\u0005\u007f)\u0015\u0011!E\u0001\u000f\n\u0005c!\u0003#F\u0003\u0003E\ta\u0012B\"\u0011\u001d\ty!\u0011C\u0001\u0005\u0017B\u0011B!\u0014B#\u0003%\tAa\u0014\u0003+\u0011K7o\u001b\"m_\u000e\\wJ\u00196fGR<&/\u001b;fe*\u0011aiR\u0001\bgR|'/Y4f\u0015\tA\u0015*A\u0003ta\u0006\u00148N\u0003\u0002K\u0017\u00061\u0011\r]1dQ\u0016T\u0011\u0001T\u0001\u0004_J<7c\u0001\u0001O-B\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0003S>T\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002V!\naq*\u001e;qkR\u001cFO]3b[B\u0011qKW\u0007\u00021*\u0011\u0011lR\u0001\tS:$XM\u001d8bY&\u00111\f\u0017\u0002\b\u0019><w-\u001b8h\u0003\u00111\u0017\u000e\\3\u0004\u0001U\tq\f\u0005\u0002PA&\u0011\u0011\r\u0015\u0002\u0005\r&dW-A\u0003gS2,\u0007%A\ttKJL\u0017\r\\5{KJl\u0015M\\1hKJ\u0004\"!\u001a5\u000e\u0003\u0019T!aZ$\u0002\u0015M,'/[1mSj,'/\u0003\u0002jM\n\t2+\u001a:jC2L'0\u001a:NC:\fw-\u001a:\u0002%M,'/[1mSj,'/\u00138ti\u0006t7-\u001a\t\u0003K2L!!\u001c4\u0003%M+'/[1mSj,'/\u00138ti\u0006t7-Z\u0001\u000bEV4g-\u001a:TSj,\u0007C\u00019t\u001b\u0005\t(\"\u0001:\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\f(aA%oi\u0006Q1/\u001f8d/JLG/Z:\u0011\u0005A<\u0018B\u0001=r\u0005\u001d\u0011un\u001c7fC:\fAb\u001e:ji\u0016lU\r\u001e:jGN\u0004\"a\u001f@\u000e\u0003qT!!`$\u0002\u0011\u0015DXmY;u_JL!a ?\u0003'MCWO\u001a4mK^\u0013\u0018\u000e^3NKR\u0014\u0018nY:\u0002\u000f\tdwnY6JIV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\tI!D\u0001F\u0013\r\tY!\u0012\u0002\b\u00052|7m[%e\u0003!\u0011Gn\\2l\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\t\u0002\u0014\u0005U\u0011qCA\r\u00037\ti\"a\b\u0002\"A\u0019\u0011q\u0001\u0001\t\u000bqS\u0001\u0019A0\t\u000b\rT\u0001\u0019\u00013\t\u000b)T\u0001\u0019A6\t\u000b9T\u0001\u0019A8\t\u000bUT\u0001\u0019\u0001<\t\u000beT\u0001\u0019\u0001>\t\u0013\u0005\u0005!\u0002%AA\u0002\u0005\u0015!aF'b]V\fGn\u00117pg\u0016|U\u000f\u001e9viN#(/Z1n'\tYa*\u0001\u0004%S:LG\u000f\n\u000b\u0003\u0003W\u00012\u0001]A\u0017\u0013\r\ty#\u001d\u0002\u0005+:LG/A\u0003dY>\u001cX-A\u0006nC:,\u0018\r\\\"m_N,\u0017aC:va\u0016\u0014He\u00197pg\u0016L1!!\rU\u0003\u001d\u0019\u0007.\u00198oK2,\"!!\u0010\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005A1\r[1o]\u0016d7OC\u0002\u0002HI\u000b1A\\5p\u0013\u0011\tY%!\u0011\u0003\u0017\u0019KG.Z\"iC:tW\r\\\u0001\fG\"\fgN\\3m?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005E\u0003\"CA*#\u0005\u0005\t\u0019AA\u001f\u0003\rAH%M\u0001\tG\"\fgN\\3mA\u0005\u0019QnY:\u0016\u0005\u0005m\u0003cAA/\u00175\t\u0001!A\u0004nGN|F%Z9\u0015\t\u0005-\u00121\r\u0005\n\u0003'\"\u0012\u0011!a\u0001\u00037\nA!\\2tA\u0005\u0011!m]\u000b\u0002\u001d\u00061!m]0%KF$B!a\u000b\u0002p!A\u00111K\f\u0002\u0002\u0003\u0007a*A\u0002cg\u0002\n1AZ8t+\t\t9\bE\u0002P\u0003sJ1!a\u001fQ\u0005A1\u0015\u000e\\3PkR\u0004X\u000f^*ue\u0016\fW.A\u0004g_N|F%Z9\u0015\t\u0005-\u0012\u0011\u0011\u0005\n\u0003'R\u0012\u0011!a\u0001\u0003o\nAAZ8tA\u0005\u0011Ao]\u000b\u0003\u0003\u0013\u0003B!a\u0002\u0002\f&\u0019\u0011QR#\u00031QKW.\u001a+sC\u000e\\\u0017N\\4PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0004ug~#S-\u001d\u000b\u0005\u0003W\t\u0019\nC\u0005\u0002Tu\t\t\u00111\u0001\u0002\n\u0006\u0019Ao\u001d\u0011\u0002\r=\u0014'nT;u+\t\tY\nE\u0002f\u0003;K1!a(g\u0005M\u0019VM]5bY&T\u0018\r^5p]N#(/Z1n\u0003)y'M[(vi~#S-\u001d\u000b\u0005\u0003W\t)\u000bC\u0005\u0002T\u0001\n\t\u00111\u0001\u0002\u001c\u00069qN\u00196PkR\u0004\u0013aC5oSRL\u0017\r\\5{K\u0012,\u0012A^\u0001\u0010S:LG/[1mSj,Gm\u0018\u0013fcR!\u00111FAY\u0011!\t\u0019fIA\u0001\u0002\u00041\u0018\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013AC:ue\u0016\fWn\u00149f]\u0006q1\u000f\u001e:fC6|\u0005/\u001a8`I\u0015\fH\u0003BA\u0016\u0003wC\u0001\"a\u0015'\u0003\u0003\u0005\rA^\u0001\fgR\u0014X-Y7Pa\u0016t\u0007%A\u0007iCN\u0014U-\u001a8DY>\u001cX\rZ\u0001\u0012Q\u0006\u001c()Z3o\u00072|7/\u001a3`I\u0015\fH\u0003BA\u0016\u0003\u000bD\u0001\"a\u0015*\u0003\u0003\u0005\rA^\u0001\u000fQ\u0006\u001c()Z3o\u00072|7/\u001a3!\u0003E\u0019w.\\7jiR,G\rU8tSRLwN\\\u000b\u0003\u0003\u001b\u00042\u0001]Ah\u0013\r\t\t.\u001d\u0002\u0005\u0019>tw-A\u000bd_6l\u0017\u000e\u001e;fIB{7/\u001b;j_:|F%Z9\u0015\t\u0005-\u0012q\u001b\u0005\n\u0003'b\u0013\u0011!a\u0001\u0003\u001b\f!cY8n[&$H/\u001a3Q_NLG/[8oA\u0005\u0001\"/\u001a9peR,G\rU8tSRLwN\\\u0001\u0015e\u0016\u0004xN\u001d;fIB{7/\u001b;j_:|F%Z9\u0015\t\u0005-\u0012\u0011\u001d\u0005\n\u0003'z\u0013\u0011!a\u0001\u0003\u001b\f\u0011C]3q_J$X\r\u001a)pg&$\u0018n\u001c8!\u0003EqW/\u001c*fG>\u0014Hm],sSR$XM\\\u000b\u0002_\u0006)b.^7SK\u000e|'\u000fZ:Xe&$H/\u001a8`I\u0015\fH\u0003BA\u0016\u0003[D\u0001\"a\u00153\u0003\u0003\u0005\ra\\\u0001\u0013]Vl'+Z2pe\u0012\u001cxK]5ui\u0016t\u0007%\u0001\u0006j]&$\u0018.\u00197ju\u0016\fAa\u001c9f]R\u0011\u00111C\u0001\u000fG2|7/\u001a*fg>,(oY3t\u00031\u0019w.\\7ji\u0006sGmR3u)\t\ti\u0010\u0005\u0003\u0002\b\u0005}\u0018b\u0001B\u0001\u000b\nYa)\u001b7f'\u0016<W.\u001a8u\u0003m\u0011XM^3siB\u000b'\u000f^5bY^\u0013\u0018\u000e^3t\u0003:$7\t\\8tKR\tq,A\u0003xe&$X\r\u0006\u0004\u0002,\t-!Q\u0003\u0005\b\u0005\u001bQ\u0004\u0019\u0001B\b\u0003\rYW-\u001f\t\u0004a\nE\u0011b\u0001B\nc\n\u0019\u0011I\\=\t\u000f\t]!\b1\u0001\u0003\u0010\u0005)a/\u00197vKR!\u00111\u0006B\u000e\u0011\u0019\u0011ib\u000fa\u0001_\u0006\t!\r\u0006\u0005\u0002,\t\u0005\"\u0011\u0007B\u001b\u0011\u001d\u0011\u0019\u0003\u0010a\u0001\u0005K\tqa\u001b<CsR,7\u000fE\u0003q\u0005O\u0011Y#C\u0002\u0003*E\u0014Q!\u0011:sCf\u00042\u0001\u001dB\u0017\u0013\r\u0011y#\u001d\u0002\u0005\u0005f$X\r\u0003\u0004\u00034q\u0002\ra\\\u0001\u0005_\u001a47\u000f\u0003\u0004\u00038q\u0002\ra\\\u0001\u0004Y\u0016t\u0017!\u0004:fG>\u0014Hm\u0016:jiR,g.\u0001\nva\u0012\fG/\u001a\"zi\u0016\u001cxK]5ui\u0016t\u0017!\u00024mkND\u0017!\u0006#jg.\u0014En\\2l\u001f\nTWm\u0019;Xe&$XM\u001d\t\u0004\u0003\u000f\t5cA!\u0003FA\u0019\u0001Oa\u0012\n\u0007\t%\u0013O\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u0003\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TC\u0001B)U\u0011\t)Aa\u0015,\u0005\tU\u0003\u0003\u0002B,\u0005Cj!A!\u0017\u000b\t\tm#QL\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0018r\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005G\u0012IFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DiskBlockObjectWriter
extends OutputStream
implements Logging {
    private final File file;
    private final SerializerManager serializerManager;
    private final SerializerInstance serializerInstance;
    public final int org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize;
    private final boolean syncWrites;
    private final ShuffleWriteMetrics writeMetrics;
    private final BlockId blockId;
    private FileChannel channel;
    private ManualCloseOutputStream mcs;
    private OutputStream bs;
    private FileOutputStream fos;
    private TimeTrackingOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$ts;
    private SerializationStream objOut;
    private boolean initialized;
    private boolean streamOpen;
    private boolean hasBeenClosed;
    private long committedPosition;
    private long reportedPosition;
    private int numRecordsWritten;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static BlockId $lessinit$greater$default$7() {
        return DiskBlockObjectWriter$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public File file() {
        return this.file;
    }

    public BlockId blockId() {
        return this.blockId;
    }

    private FileChannel channel() {
        return this.channel;
    }

    private void channel_$eq(FileChannel x$1) {
        this.channel = x$1;
    }

    private ManualCloseOutputStream mcs() {
        return this.mcs;
    }

    private void mcs_$eq(ManualCloseOutputStream x$1) {
        this.mcs = x$1;
    }

    private OutputStream bs() {
        return this.bs;
    }

    private void bs_$eq(OutputStream x$1) {
        this.bs = x$1;
    }

    private FileOutputStream fos() {
        return this.fos;
    }

    private void fos_$eq(FileOutputStream x$1) {
        this.fos = x$1;
    }

    public TimeTrackingOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$ts() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$ts;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(TimeTrackingOutputStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts = x$1;
    }

    private SerializationStream objOut() {
        return this.objOut;
    }

    private void objOut_$eq(SerializationStream x$1) {
        this.objOut = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean streamOpen() {
        return this.streamOpen;
    }

    private void streamOpen_$eq(boolean x$1) {
        this.streamOpen = x$1;
    }

    private boolean hasBeenClosed() {
        return this.hasBeenClosed;
    }

    private void hasBeenClosed_$eq(boolean x$1) {
        this.hasBeenClosed = x$1;
    }

    private long committedPosition() {
        return this.committedPosition;
    }

    private void committedPosition_$eq(long x$1) {
        this.committedPosition = x$1;
    }

    private long reportedPosition() {
        return this.reportedPosition;
    }

    private void reportedPosition_$eq(long x$1) {
        this.reportedPosition = x$1;
    }

    private int numRecordsWritten() {
        return this.numRecordsWritten;
    }

    private void numRecordsWritten_$eq(int x$1) {
        this.numRecordsWritten = x$1;
    }

    private void initialize() {
        this.fos_$eq(new FileOutputStream(this.file(), true));
        this.channel_$eq(this.fos().getChannel());
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(new TimeTrackingOutputStream(this.writeMetrics, this.fos()));
        public class Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1
        extends BufferedOutputStream
        implements ManualCloseOutputStream {
            private final /* synthetic */ DiskBlockObjectWriter $outer;

            public /* synthetic */ void org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close() {
                super.close();
            }

            public void close() {
                ManualCloseOutputStream.close$(this);
            }

            public void manualClose() {
                ManualCloseOutputStream.manualClose$(this);
            }

            public /* synthetic */ DiskBlockObjectWriter org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer() {
                return this.$outer;
            }

            public Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1(DiskBlockObjectWriter $outer) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.org$apache$spark$storage$DiskBlockObjectWriter$$ts(), $outer.org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize);
                ManualCloseOutputStream.$init$(this);
            }
        }
        this.mcs_$eq(new Org_apache_spark_storage_DiskBlockObjectWriter$ManualCloseBufferedOutputStream$1(this));
    }

    public DiskBlockObjectWriter open() {
        if (this.hasBeenClosed()) {
            throw new IllegalStateException("Writer already closed. Cannot be reopened.");
        }
        if (!this.initialized()) {
            this.initialize();
            this.initialized_$eq(true);
        }
        this.bs_$eq(this.serializerManager.wrapStream(this.blockId(), (OutputStream)((Object)this.mcs())));
        this.objOut_$eq(this.serializerInstance.serializeStream(this.bs()));
        this.streamOpen_$eq(true);
        return this;
    }

    private void closeResources() {
        block0: {
            if (!this.initialized()) break block0;
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.mcs().manualClose(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.channel_$eq(null);
                this.mcs_$eq(null);
                this.bs_$eq(null);
                this.fos_$eq(null);
                this.org$apache$spark$storage$DiskBlockObjectWriter$$ts_$eq(null);
                this.objOut_$eq(null);
                this.initialized_$eq(false);
                this.streamOpen_$eq(false);
                this.hasBeenClosed_$eq(true);
            });
        }
    }

    @Override
    public void close() {
        block0: {
            if (!this.initialized()) break block0;
            Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> this.commitAndGet(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeResources());
        }
    }

    public FileSegment commitAndGet() {
        FileSegment fileSegment;
        if (this.streamOpen()) {
            this.objOut().flush();
            this.bs().flush();
            this.objOut().close();
            this.streamOpen_$eq(false);
            if (this.syncWrites) {
                long start = System.nanoTime();
                this.fos().getFD().sync();
                this.writeMetrics.incWriteTime(System.nanoTime() - start);
            }
            long pos = this.channel().position();
            FileSegment fileSegment2 = new FileSegment(this.file(), this.committedPosition(), pos - this.committedPosition());
            this.committedPosition_$eq(pos);
            this.writeMetrics.incBytesWritten(this.committedPosition() - this.reportedPosition());
            this.reportedPosition_$eq(this.committedPosition());
            this.numRecordsWritten_$eq(0);
            fileSegment = fileSegment2;
        } else {
            fileSegment = new FileSegment(this.file(), this.committedPosition(), 0L);
        }
        return fileSegment;
    }

    public File revertPartialWritesAndClose() {
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!this.initialized()) break block0;
                $this.writeMetrics.decBytesWritten(this.reportedPosition() - this.committedPosition());
                $this.writeMetrics.decRecordsWritten(this.numRecordsWritten());
                this.streamOpen_$eq(false);
                this.closeResources();
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FileOutputStream truncateStream = null;
            try {
                try {
                    truncateStream = new FileOutputStream(this.file(), true);
                    truncateStream.getChannel().truncate(this.committedPosition());
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Uncaught exception while reverting partial writes to file ").append(this.file()).toString(), e);
                }
            }
            finally {
                if (truncateStream != null) {
                    truncateStream.close();
                    truncateStream = null;
                }
            }
        });
        return this.file();
    }

    public void write(Object key, Object value) {
        Object object = !this.streamOpen() ? this.open() : BoxedUnit.UNIT;
        this.objOut().writeKey(key, ClassTag$.MODULE$.Any());
        this.objOut().writeValue(value, ClassTag$.MODULE$.Any());
        this.recordWritten();
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] kvBytes, int offs, int len) {
        Object object = !this.streamOpen() ? this.open() : BoxedUnit.UNIT;
        this.bs().write(kvBytes, offs, len);
    }

    public void recordWritten() {
        block0: {
            this.numRecordsWritten_$eq(this.numRecordsWritten() + 1);
            this.writeMetrics.incRecordsWritten(1L);
            if (this.numRecordsWritten() % 16384 != 0) break block0;
            this.updateBytesWritten();
        }
    }

    private void updateBytesWritten() {
        long pos = this.channel().position();
        this.writeMetrics.incBytesWritten(pos - this.reportedPosition());
        this.reportedPosition_$eq(pos);
    }

    @Override
    public void flush() {
        this.objOut().flush();
        this.bs().flush();
    }

    public DiskBlockObjectWriter(File file, SerializerManager serializerManager, SerializerInstance serializerInstance, int bufferSize, boolean syncWrites, ShuffleWriteMetrics writeMetrics, BlockId blockId) {
        this.file = file;
        this.serializerManager = serializerManager;
        this.serializerInstance = serializerInstance;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$bufferSize = bufferSize;
        this.syncWrites = syncWrites;
        this.writeMetrics = writeMetrics;
        this.blockId = blockId;
        Logging.$init$(this);
        this.channel = null;
        this.mcs = null;
        this.bs = null;
        this.fos = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$ts = null;
        this.objOut = null;
        this.initialized = false;
        this.streamOpen = false;
        this.hasBeenClosed = false;
        this.committedPosition = file.length();
        this.reportedPosition = this.committedPosition();
        this.numRecordsWritten = 0;
    }

    public interface ManualCloseOutputStream {
        public /* synthetic */ void org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close();

        public static /* synthetic */ void close$(ManualCloseOutputStream $this) {
            $this.close();
        }

        default public void close() {
            ((OutputStream)((Object)this)).flush();
        }

        public static /* synthetic */ void manualClose$(ManualCloseOutputStream $this) {
            $this.manualClose();
        }

        default public void manualClose() {
            this.org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$super$close();
        }

        public /* synthetic */ DiskBlockObjectWriter org$apache$spark$storage$DiskBlockObjectWriter$ManualCloseOutputStream$$$outer();

        public static void $init$(ManualCloseOutputStream $this) {
        }
    }
}

