/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.BlockManagerInfo;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetBlockStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetMatchingBlockIds$;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockUpdatedInfo$;
import org.apache.spark.storage.DefaultTopologyMapper;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.storage.TestBlockId;
import org.apache.spark.storage.TopologyMapper;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.SetLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t]f!\u0002\u0016,\u00015\u001a\u0004\u0002\u0003$\u0001\u0005\u000b\u0007I\u0011\t%\t\u00111\u0003!\u0011!Q\u0001\n%C\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005\u001f\"A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u001d9\u0007A1A\u0005\n!Daa\u001e\u0001!\u0002\u0013I\u0007b\u0002=\u0001\u0005\u0004%I!\u001f\u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003{\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\n\u0011%\ty\u0003\u0001b\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u001a\u0011%\t\t\u0005\u0001b\u0001\n\u0017\t\u0019\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA#\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA+\u0011!\ti\u0006\u0001b\u0001\n\u0003q\u0005bBA0\u0001\u0001\u0006Ia\u0014\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007Cq!a*\u0001\t\u0013\tI\u000bC\u0004\u00024\u0002!I!!.\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002H\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBAk\u0001\u0011%\u0011q\u001b\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KDq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!\u0011\u0007\u0001\u0005\n\tM\u0002b\u0002B&\u0001\u0011%!Q\n\u0005\b\u0005K\u0002A\u0011\u0002B4\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqAa%\u0001\t\u0013\u0011)\nC\u0004\u0003$\u0002!IA!*\t\u000f\t%\u0006\u0001\"\u0003\u0003,\"9!1\u0017\u0001\u0005B\tU&A\u0007\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJ,e\u000e\u001a9pS:$(B\u0001\u0017.\u0003\u001d\u0019Ho\u001c:bO\u0016T!AL\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\n\u0005\u0001QR\u0004\t\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{5\n1A\u001d9d\u0013\tyDHA\u000bUQJ,\u0017\rZ*bM\u0016\u0014\u0006oY#oIB|\u0017N\u001c;\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rk\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0015\u0013%a\u0002'pO\u001eLgnZ\u0001\u0007eB\u001cWI\u001c<\u0004\u0001U\t\u0011\n\u0005\u0002<\u0015&\u00111\n\u0010\u0002\u0007%B\u001cWI\u001c<\u0002\u000fI\u00048-\u00128wA\u00059\u0011n\u001d'pG\u0006dW#A(\u0011\u0005U\u0002\u0016BA)7\u0005\u001d\u0011un\u001c7fC:\f\u0001\"[:M_\u000e\fG\u000eI\u0001\u0005G>tg\r\u0005\u0002V-6\tQ&\u0003\u0002X[\tI1\u000b]1sW\u000e{gNZ\u0001\fY&\u001cH/\u001a8fe\n+8\u000f\u0005\u0002[;6\t1L\u0003\u0002][\u0005I1o\u00195fIVdWM]\u0005\u0003=n\u0013q\u0002T5wK2K7\u000f^3oKJ\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0005\u001cG-\u001a4\u0011\u0005\t\u0004Q\"A\u0016\t\u000b\u0019;\u0001\u0019A%\t\u000b5;\u0001\u0019A(\t\u000bM;\u0001\u0019\u0001+\t\u000ba;\u0001\u0019A-\u0002!\tdwnY6NC:\fw-\u001a:J]\u001a|W#A5\u0011\t)|\u0017\u000f^\u0007\u0002W*\u0011A.\\\u0001\b[V$\u0018M\u00197f\u0015\tqg'\u0001\u0006d_2dWm\u0019;j_:L!\u0001]6\u0003\u000f!\u000b7\u000f['baB\u0011!M]\u0005\u0003g.\u0012aB\u00117pG.l\u0015M\\1hKJLE\r\u0005\u0002ck&\u0011ao\u000b\u0002\u0011\u00052|7m['b]\u0006<WM]%oM>\f\u0011C\u00197pG.l\u0015M\\1hKJLeNZ8!\u0003a\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\u0014\u00150\u0012=fGV$xN]\u000b\u0002uB!!n\\>r!\ra\u0018q\u0001\b\u0004{\u0006\r\u0001C\u0001@7\u001b\u0005y(bAA\u0001\u000f\u00061AH]8pizJ1!!\u00027\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0001\u001c\u00023\tdwnY6NC:\fw-\u001a:JI\nKX\t_3dkR|'\u000fI\u0001\u000fE2|7m\u001b'pG\u0006$\u0018n\u001c8t+\t\t\u0019\u0002\u0005\u0005\u0002\u0016\u0005}\u0011\u0011EA\u0014\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011\u0001B;uS2T!!!\b\u0002\t)\fg/Y\u0005\u0004a\u0006]\u0001c\u00012\u0002$%\u0019\u0011QE\u0016\u0003\u000f\tcwnY6JIB!!.!\u000br\u0013\r\tYc\u001b\u0002\b\u0011\u0006\u001c\bnU3u\u0003=\u0011Gn\\2l\u0019>\u001c\u0017\r^5p]N\u0004\u0013!D1tWRC'/Z1e!>|G.\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9D\u0003\u0003\u0002:\u0005]\u0011AC2p]\u000e,(O]3oi&!\u0011QHA\u001c\u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u0002\u001d\u0005\u001c8\u000e\u00165sK\u0006$\u0007k\\8mA\u0005\u0019\u0012m]6Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\u0011\u0011Q\t\t\u0005\u0003\u000f\nY%\u0004\u0002\u0002J)\u0019\u0011\u0011\b\u001c\n\t\u00055\u0013\u0011\n\u0002 \u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017\u0001F1tW\u0016CXmY;uS>t7i\u001c8uKb$\b%\u0001\bu_B|Gn\\4z\u001b\u0006\u0004\b/\u001a:\u0016\u0005\u0005U\u0003c\u00012\u0002X%\u0019\u0011\u0011L\u0016\u0003\u001dQ{\u0007o\u001c7pOfl\u0015\r\u001d9fe\u0006yAo\u001c9pY><\u00170T1qa\u0016\u0014\b%\u0001\u000bqe>\f7\r^5wK2L(+\u001a9mS\u000e\fG/Z\u0001\u0016aJ|\u0017m\u0019;jm\u0016d\u0017PU3qY&\u001c\u0017\r^3!\u0003=\u0011XmY3jm\u0016\fe\u000e\u001a*fa2LH\u0003BA3\u0003o\u0002r!NA4\u0003W\n\t(C\u0002\u0002jY\u0012q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0004k\u00055\u0014bAA8m\t\u0019\u0011I\\=\u0011\u0007U\n\u0019(C\u0002\u0002vY\u0012A!\u00168ji\"9\u0011\u0011\u0010\fA\u0002\u0005m\u0014aB2p]R,\u0007\u0010\u001e\t\u0004w\u0005u\u0014bAA@y\tq!\u000b]2DC2d7i\u001c8uKb$\u0018!\u0003:f[>4XM\u00153e)\u0011\t))a)\u0011\r\u0005\u001d\u0013qQAF\u0013\u0011\tI)!\u0013\u0003\r\u0019+H/\u001e:f!\u0019\ti)a&\u0002\u001e:!\u0011qRAJ\u001d\rq\u0018\u0011S\u0005\u0002o%\u0019\u0011Q\u0013\u001c\u0002\u000fA\f7m[1hK&!\u0011\u0011TAN\u0005\r\u0019V-\u001d\u0006\u0004\u0003+3\u0004cA\u001b\u0002 &\u0019\u0011\u0011\u0015\u001c\u0003\u0007%sG\u000fC\u0004\u0002&^\u0001\r!!(\u0002\u000bI$G-\u00133\u0002\u001bI,Wn\u001c<f'\",hM\u001a7f)\u0011\tY+a,\u0011\r\u0005\u001d\u0013qQAW!\u0015\ti)a&P\u0011\u001d\t\t\f\u0007a\u0001\u0003;\u000b\u0011b\u001d5vM\u001adW-\u00133\u0002\u001fI,Wn\u001c<f\u0005J|\u0017\rZ2bgR$b!!\"\u00028\u0006\u0005\u0007bBA]3\u0001\u0007\u00111X\u0001\fEJ|\u0017\rZ2bgRLE\rE\u00026\u0003{K1!a07\u0005\u0011auN\\4\t\r\u0005\r\u0017\u00041\u0001P\u0003A\u0011X-\\8wK\u001a\u0013x.\u001c#sSZ,'/\u0001\nsK6|g/\u001a\"m_\u000e\\W*\u00198bO\u0016\u0014H\u0003BA9\u0003\u0013Da!a3\u001b\u0001\u0004\t\u0018A\u00042m_\u000e\\W*\u00198bO\u0016\u0014\u0018\nZ\u0001\u000fe\u0016lwN^3Fq\u0016\u001cW\u000f^8s)\u0011\t\t(!5\t\r\u0005M7\u00041\u0001|\u0003\u0019)\u00070Z2JI\u0006\t\u0002.Z1si\n,\u0017\r\u001e*fG\u0016Lg/\u001a3\u0015\u0007=\u000bI\u000e\u0003\u0004\u0002Lr\u0001\r!]\u0001\u0017e\u0016lwN^3CY>\u001c7N\u0012:p[^{'o[3sgR!\u0011\u0011OAp\u0011\u001d\t\t/\ba\u0001\u0003C\tqA\u00197pG.LE-\u0001\u0007nK6|'/_*uCR,8/\u0006\u0002\u0002hB1A0!;r\u0003[LA!a;\u0002\f\t\u0019Q*\u00199\u0011\u000fU\ny/a/\u0002<&\u0019\u0011\u0011\u001f\u001c\u0003\rQ+\b\u000f\\33\u00035\u0019Ho\u001c:bO\u0016\u001cF/\u0019;vgV\u0011\u0011q\u001f\t\u0006k\u0005e\u0018Q`\u0005\u0004\u0003w4$!B!se\u0006L\bc\u00012\u0002\u0000&\u0019!\u0011A\u0016\u0003\u001bM#xN]1hKN#\u0018\r^;t\u0003-\u0011Gn\\2l'R\fG/^:\u0015\r\t\u001d!q\u0003B\r!\u0019a\u0018\u0011^9\u0003\nA1\u0011qIAD\u0005\u0017\u0001R!\u000eB\u0007\u0005#I1Aa\u00047\u0005\u0019y\u0005\u000f^5p]B\u0019!Ma\u0005\n\u0007\tU1FA\u0006CY>\u001c7n\u0015;biV\u001c\bbBAqA\u0001\u0007\u0011\u0011\u0005\u0005\u0007\u00057\u0001\u0003\u0019A(\u0002\u0013\u0005\u001c8n\u00157bm\u0016\u001c\u0018aE4fi6\u000bGo\u00195j]\u001e\u0014En\\2l\u0013\u0012\u001cHC\u0002B\u0011\u0005K\u0011y\u0003\u0005\u0004\u0002H\u0005\u001d%1\u0005\t\u0007\u0003\u001b\u000b9*!\t\t\u000f\t\u001d\u0012\u00051\u0001\u0003*\u00051a-\u001b7uKJ\u0004b!\u000eB\u0016\u0003Cy\u0015b\u0001B\u0017m\tIa)\u001e8di&|g.\r\u0005\u0007\u00057\t\u0003\u0019A(\u0002\u0011I,w-[:uKJ$\u0012\"\u001dB\u001b\u0005s\u0011iD!\u0011\t\r\t]\"\u00051\u0001r\u0003UIGmV5uQ>,H\u000fV8q_2|w-_%oM>DqAa\u000f#\u0001\u0004\tY,\u0001\tnCb|e\u000eS3ba6+WnU5{K\"9!q\b\u0012A\u0002\u0005m\u0016!E7bq>3g\rS3ba6+WnU5{K\"9!1\t\u0012A\u0002\t\u0015\u0013!D:mCZ,WI\u001c3q_&tG\u000fE\u0002<\u0005\u000fJ1A!\u0013=\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fq\"\u001e9eCR,'\t\\8dW&sgm\u001c\u000b\f\u001f\n=#\u0011\u000bB*\u0005;\u0012\t\u0007\u0003\u0004\u0002L\u000e\u0002\r!\u001d\u0005\b\u0003C\u001c\u0003\u0019AA\u0011\u0011\u001d\u0011)f\ta\u0001\u0005/\nAb\u001d;pe\u0006<W\rT3wK2\u00042A\u0019B-\u0013\r\u0011Yf\u000b\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u0005\b\u0005?\u001a\u0003\u0019AA^\u0003\u001diW-\\*ju\u0016DqAa\u0019$\u0001\u0004\tY,\u0001\u0005eSN\\7+\u001b>f\u000319W\r\u001e'pG\u0006$\u0018n\u001c8t)\u0011\u0011IGa\u001b\u0011\u000b\u00055\u0015qS9\t\u000f\u0005\u0005H\u00051\u0001\u0002\"\u0005)r-\u001a;M_\u000e\fG/[8og\u0006sGm\u0015;biV\u001cH\u0003\u0002B9\u0005#\u0003R!\u000eB\u0007\u0005g\u0002BA!\u001e\u0003\f:!!q\u000fBD\u001d\u0011\u0011IH!\"\u000f\t\tm$1\u0011\b\u0005\u0005{\u0012\tID\u0002\u007f\u0005\u007fJ\u0011AM\u0005\u0003aEJ!AL\u0018\n\u00051j\u0013b\u0001BEW\u0005!\"\t\\8dW6\u000bg.Y4fe6+7o]1hKNLAA!$\u0003\u0010\n9\"\t\\8dW2{7-\u0019;j_:\u001c\u0018I\u001c3Ti\u0006$Xo\u001d\u0006\u0004\u0005\u0013[\u0003bBAqK\u0001\u0007\u0011\u0011E\u0001\u001dO\u0016$Hj\\2bi&|gn]'vYRL\u0007\u000f\\3CY>\u001c7.\u00133t)\u0011\u00119J!(\u0011\r\u00055%\u0011\u0014B5\u0013\u0011\u0011Y*a'\u0003\u0015%sG-\u001a=fIN+\u0017\u000fC\u0004\u0003 \u001a\u0002\rA!)\u0002\u0011\tdwnY6JIN\u0004R!NA}\u0003C\t\u0001bZ3u!\u0016,'o\u001d\u000b\u0005\u0005S\u00129\u000b\u0003\u0004\u0002L\u001e\u0002\r!]\u0001\u0017O\u0016$X\t_3dkR|'/\u00128ea>Lg\u000e\u001e*fMR!!Q\u0016BX!\u0015)$Q\u0002B#\u0011\u0019\u0011\t\f\u000ba\u0001w\u0006QQ\r_3dkR|'/\u00133\u0002\r=t7\u000b^8q)\t\t\t\b")
public class BlockManagerMasterEndpoint
implements ThreadSafeRpcEndpoint,
Logging {
    private final RpcEnv rpcEnv;
    private final boolean isLocal;
    public final LiveListenerBus org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus;
    private final scala.collection.mutable.HashMap<BlockManagerId, BlockManagerInfo> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo;
    private final scala.collection.mutable.HashMap<String, BlockManagerId> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor;
    private final HashMap<BlockId, HashSet<BlockManagerId>> blockLocations;
    private final ThreadPoolExecutor askThreadPool;
    private final ExecutionContextExecutorService askExecutionContext;
    private final TopologyMapper topologyMapper;
    private final boolean proactivelyReplicate;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public final RpcEndpointRef self() {
        return RpcEndpoint.self$(this);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return RpcEndpoint.receive$(this);
    }

    @Override
    public void onError(Throwable cause) {
        RpcEndpoint.onError$(this, cause);
    }

    @Override
    public void onConnected(RpcAddress remoteAddress) {
        RpcEndpoint.onConnected$(this, remoteAddress);
    }

    @Override
    public void onDisconnected(RpcAddress remoteAddress) {
        RpcEndpoint.onDisconnected$(this, remoteAddress);
    }

    @Override
    public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
        RpcEndpoint.onNetworkError$(this, cause, remoteAddress);
    }

    @Override
    public void onStart() {
        RpcEndpoint.onStart$(this);
    }

    @Override
    public final void stop() {
        RpcEndpoint.stop$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public scala.collection.mutable.HashMap<BlockManagerId, BlockManagerInfo> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo() {
        return this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo;
    }

    public scala.collection.mutable.HashMap<String, BlockManagerId> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor() {
        return this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor;
    }

    private HashMap<BlockId, HashSet<BlockManagerId>> blockLocations() {
        return this.blockLocations;
    }

    private ThreadPoolExecutor askThreadPool() {
        return this.askThreadPool;
    }

    private ExecutionContextExecutorService askExecutionContext() {
        return this.askExecutionContext;
    }

    private TopologyMapper topologyMapper() {
        return this.topologyMapper;
    }

    public boolean proactivelyReplicate() {
        return this.proactivelyReplicate;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
        return new scala.Serializable(this, context){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMasterEndpoint $outer;
            private final RpcCallContext context$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof BlockManagerMessages.RegisterBlockManager) {
                    BlockManagerMessages.RegisterBlockManager registerBlockManager = (BlockManagerMessages.RegisterBlockManager)A1;
                    BlockManagerId blockManagerId = registerBlockManager.blockManagerId();
                    long maxOnHeapMemSize = registerBlockManager.maxOnHeapMemSize();
                    long maxOffHeapMemSize = registerBlockManager.maxOffHeapMemSize();
                    RpcEndpointRef slaveEndpoint = registerBlockManager.sender();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$register(blockManagerId, maxOnHeapMemSize, maxOffHeapMemSize, slaveEndpoint));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.UpdateBlockInfo) {
                    BlockManagerMessages.UpdateBlockInfo updateBlockInfo = (BlockManagerMessages.UpdateBlockInfo)A1;
                    BlockManagerId blockManagerId = updateBlockInfo.blockManagerId();
                    BlockId blockId = updateBlockInfo.blockId();
                    StorageLevel storageLevel = updateBlockInfo.storageLevel();
                    long deserializedSize = updateBlockInfo.memSize();
                    long size = updateBlockInfo.diskSize();
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$updateBlockInfo(blockManagerId, blockId, storageLevel, deserializedSize, size)));
                    this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus.post(new SparkListenerBlockUpdated(BlockUpdatedInfo$.MODULE$.apply(updateBlockInfo)));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetLocations) {
                    BlockManagerMessages.GetLocations getLocations = (BlockManagerMessages.GetLocations)A1;
                    BlockId blockId = getLocations.blockId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocations(blockId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetLocationsAndStatus) {
                    BlockManagerMessages.GetLocationsAndStatus getLocationsAndStatus = (BlockManagerMessages.GetLocationsAndStatus)A1;
                    BlockId blockId = getLocationsAndStatus.blockId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocationsAndStatus(blockId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetLocationsMultipleBlockIds) {
                    BlockManagerMessages.GetLocationsMultipleBlockIds getLocationsMultipleBlockIds = (BlockManagerMessages.GetLocationsMultipleBlockIds)A1;
                    BlockId[] blockIds = getLocationsMultipleBlockIds.blockIds();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocationsMultipleBlockIds(blockIds));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetPeers) {
                    BlockManagerMessages.GetPeers getPeers = (BlockManagerMessages.GetPeers)A1;
                    BlockManagerId blockManagerId = getPeers.blockManagerId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getPeers(blockManagerId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetExecutorEndpointRef) {
                    BlockManagerMessages.GetExecutorEndpointRef getExecutorEndpointRef = (BlockManagerMessages.GetExecutorEndpointRef)A1;
                    String executorId = getExecutorEndpointRef.executorId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getExecutorEndpointRef(executorId));
                    object = BoxedUnit.UNIT;
                } else if (BlockManagerMessages$GetMemoryStatus$.MODULE$.equals(A1)) {
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$memoryStatus());
                    object = BoxedUnit.UNIT;
                } else if (BlockManagerMessages$GetStorageStatus$.MODULE$.equals(A1)) {
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$storageStatus());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetBlockStatus) {
                    BlockManagerMessages.GetBlockStatus getBlockStatus = (BlockManagerMessages.GetBlockStatus)A1;
                    BlockId blockId = getBlockStatus.blockId();
                    boolean askSlaves = getBlockStatus.askSlaves();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockStatus(blockId, askSlaves));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetMatchingBlockIds) {
                    BlockManagerMessages.GetMatchingBlockIds getMatchingBlockIds = (BlockManagerMessages.GetMatchingBlockIds)A1;
                    Function1<BlockId, Object> filter = getMatchingBlockIds.filter();
                    boolean askSlaves = getMatchingBlockIds.askSlaves();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getMatchingBlockIds(filter, askSlaves));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveRdd) {
                    BlockManagerMessages.RemoveRdd removeRdd2 = (BlockManagerMessages.RemoveRdd)A1;
                    int rddId = removeRdd2.rddId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeRdd(rddId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveShuffle) {
                    BlockManagerMessages.RemoveShuffle removeShuffle = (BlockManagerMessages.RemoveShuffle)A1;
                    int shuffleId = removeShuffle.shuffleId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeShuffle(shuffleId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveBroadcast) {
                    BlockManagerMessages.RemoveBroadcast removeBroadcast2 = (BlockManagerMessages.RemoveBroadcast)A1;
                    long broadcastId = removeBroadcast2.broadcastId();
                    boolean removeFromDriver = removeBroadcast2.removeFromDriver();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeBroadcast(broadcastId, removeFromDriver));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveBlock) {
                    BlockManagerMessages.RemoveBlock removeBlock = (BlockManagerMessages.RemoveBlock)A1;
                    BlockId blockId = removeBlock.blockId();
                    this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeBlockFromWorkers(blockId);
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveExecutor) {
                    BlockManagerMessages.RemoveExecutor removeExecutor = (BlockManagerMessages.RemoveExecutor)A1;
                    String execId = removeExecutor.execId();
                    this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeExecutor(execId);
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                    object = BoxedUnit.UNIT;
                } else if (BlockManagerMessages$StopBlockManagerMaster$.MODULE$.equals(A1)) {
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                    this.$outer.stop();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.BlockManagerHeartbeat) {
                    BlockManagerMessages.BlockManagerHeartbeat blockManagerHeartbeat = (BlockManagerMessages.BlockManagerHeartbeat)A1;
                    BlockManagerId blockManagerId = blockManagerHeartbeat.blockManagerId();
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$heartbeatReceived(blockManagerId)));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.HasCachedBlocks) {
                    BlockManagerMessages.HasCachedBlocks hasCachedBlocks = (BlockManagerMessages.HasCachedBlocks)A1;
                    String executorId = hasCachedBlocks.executorId();
                    Option option = this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().get((Object)executorId);
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        BlockManagerId bm = (BlockManagerId)some.value();
                        if (this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().contains((Object)bm)) {
                            BlockManagerInfo bmInfo = (BlockManagerInfo)this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)bm);
                            this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)bmInfo.cachedBlocks().nonEmpty()));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)false));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (None$.MODULE$.equals(option)) {
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)false));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof BlockManagerMessages.RegisterBlockManager ? true : (object instanceof BlockManagerMessages.UpdateBlockInfo ? true : (object instanceof BlockManagerMessages.GetLocations ? true : (object instanceof BlockManagerMessages.GetLocationsAndStatus ? true : (object instanceof BlockManagerMessages.GetLocationsMultipleBlockIds ? true : (object instanceof BlockManagerMessages.GetPeers ? true : (object instanceof BlockManagerMessages.GetExecutorEndpointRef ? true : (BlockManagerMessages$GetMemoryStatus$.MODULE$.equals(object) ? true : (BlockManagerMessages$GetStorageStatus$.MODULE$.equals(object) ? true : (object instanceof BlockManagerMessages.GetBlockStatus ? true : (object instanceof BlockManagerMessages.GetMatchingBlockIds ? true : (object instanceof BlockManagerMessages.RemoveRdd ? true : (object instanceof BlockManagerMessages.RemoveShuffle ? true : (object instanceof BlockManagerMessages.RemoveBroadcast ? true : (object instanceof BlockManagerMessages.RemoveBlock ? true : (object instanceof BlockManagerMessages.RemoveExecutor ? true : (BlockManagerMessages$StopBlockManagerMaster$.MODULE$.equals(object) ? true : (object instanceof BlockManagerMessages.BlockManagerHeartbeat ? true : object instanceof BlockManagerMessages.HasCachedBlocks)))))))))))))))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.context$1 = context$1;
            }
        };
    }

    public Future<Seq<Object>> org$apache$spark$storage$BlockManagerMasterEndpoint$$removeRdd(int rddId) {
        Iterable blocks = (Iterable)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.blockLocations()).asScala()).keys().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.asRDDId()), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BlockManagerMasterEndpoint.$anonfun$removeRdd$2(rddId, x$2)));
        blocks.foreach((Function1 & Serializable & scala.Serializable)blockId -> {
            HashSet<BlockManagerId> bms = this.blockLocations().get(blockId);
            bms.foreach((Function1 & Serializable & scala.Serializable)bm -> {
                BlockManagerMasterEndpoint.$anonfun$removeRdd$4(this, blockId, bm);
                return BoxedUnit.UNIT;
            });
            return this.blockLocations().remove(blockId);
        });
        BlockManagerMessages.RemoveRdd removeMsg = new BlockManagerMessages.RemoveRdd(rddId);
        Seq futures = ((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().map((Function1 & Serializable & scala.Serializable)bm -> bm.slaveEndpoint().ask(removeMsg, ClassTag$.MODULE$.Int()).recover((PartialFunction)new scala.Serializable(this, rddId, (BlockManagerInfo)bm){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMasterEndpoint $outer;
            private final int rddId$1;
            private final BlockManagerInfo bm$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IOException) {
                    IOException iOException = (IOException)A1;
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Error trying to remove RDD ").append($this.rddId$1).append(" from block manager ").append($this.bm$1.blockManagerId()).toString(), iOException);
                    object = BoxesRunTime.boxToInteger((int)0);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IOException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rddId$1 = rddId$1;
                this.bm$1 = bm$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.storage.BlockManagerMasterEndpoint$$anonfun$$nestedInanonfun$removeRdd$6$1 )}, serializedLambda);
            }
        }, (ExecutionContext)this.askExecutionContext()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.askExecutionContext());
    }

    public Future<Seq<Object>> org$apache$spark$storage$BlockManagerMasterEndpoint$$removeShuffle(int shuffleId) {
        BlockManagerMessages.RemoveShuffle removeMsg = new BlockManagerMessages.RemoveShuffle(shuffleId);
        return Future$.MODULE$.sequence((TraversableOnce)((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().map((Function1 & Serializable & scala.Serializable)bm -> bm.slaveEndpoint().ask(removeMsg, ClassTag$.MODULE$.Boolean()), Iterable$.MODULE$.canBuildFrom())).toSeq(), Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.askExecutionContext());
    }

    public Future<Seq<Object>> org$apache$spark$storage$BlockManagerMasterEndpoint$$removeBroadcast(long broadcastId, boolean removeFromDriver) {
        BlockManagerMessages.RemoveBroadcast removeMsg = new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromDriver);
        Iterable requiredBlockManagers = (Iterable)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().filter((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockManagerMasterEndpoint.$anonfun$removeBroadcast$1(removeFromDriver, info)));
        Seq futures = ((TraversableOnce)requiredBlockManagers.map((Function1 & Serializable & scala.Serializable)bm -> bm.slaveEndpoint().ask(removeMsg, ClassTag$.MODULE$.Int()).recover((PartialFunction)new scala.Serializable(this, broadcastId, (BlockManagerInfo)bm){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMasterEndpoint $outer;
            private final long broadcastId$1;
            private final BlockManagerInfo bm$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IOException) {
                    IOException iOException = (IOException)A1;
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Error trying to remove broadcast ").append($this.broadcastId$1).append(" from block manager ").append($this.bm$2.blockManagerId()).toString(), iOException);
                    object = BoxesRunTime.boxToInteger((int)0);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IOException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broadcastId$1 = broadcastId$1;
                this.bm$2 = bm$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.storage.BlockManagerMasterEndpoint$$anonfun$$nestedInanonfun$removeBroadcast$2$1 )}, serializedLambda);
            }
        }, (ExecutionContext)this.askExecutionContext()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.askExecutionContext());
    }

    private void removeBlockManager(BlockManagerId blockManagerId) {
        BlockManagerInfo info = (BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)blockManagerId);
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().$minus$eq((Object)blockManagerId.executorId());
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().remove((Object)blockManagerId);
        for (BlockId blockId : info.blocks().keySet()) {
            HashSet<BlockManagerId> locations = this.blockLocations().get(blockId);
            locations.$minus$eq((Object)blockManagerId);
            if (locations.size() == 0) {
                this.blockLocations().remove(blockId);
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("No more replicas available for ").append(blockId).append(" !").toString());
                continue;
            }
            if (!this.proactivelyReplicate() || !blockId.isRDD() && !(blockId instanceof TestBlockId)) continue;
            int maxReplicas = locations.size() + 1;
            int i = new Random(blockId.hashCode()).nextInt(locations.size());
            Seq blockLocations = locations.toSeq();
            BlockManagerId candidateBMId = (BlockManagerId)blockLocations.apply(i);
            this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().get((Object)candidateBMId).foreach((Function1 & Serializable & scala.Serializable)bm2 -> {
                Seq remainingLocations = (Seq)locations.toSeq().filter((Function1 & Serializable & scala.Serializable)bm -> BoxesRunTime.boxToBoolean((boolean)BlockManagerMasterEndpoint.$anonfun$removeBlockManager$3(candidateBMId, bm)));
                BlockManagerMessages.ReplicateBlock replicateMsg = new BlockManagerMessages.ReplicateBlock(blockId, (Seq<BlockManagerId>)remainingLocations, maxReplicas);
                return bm2.slaveEndpoint().ask(replicateMsg, ClassTag$.MODULE$.Boolean());
            });
        }
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus.post(new SparkListenerBlockManagerRemoved(System.currentTimeMillis(), blockManagerId));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Removing block manager ").append(blockManagerId).toString());
    }

    public void org$apache$spark$storage$BlockManagerMasterEndpoint$$removeExecutor(String execId) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Trying to remove executor ").append(execId).append(" from BlockManagerMaster.").toString());
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().get((Object)execId).foreach((Function1 & Serializable & scala.Serializable)blockManagerId -> {
            this.removeBlockManager(blockManagerId);
            return BoxedUnit.UNIT;
        });
    }

    public boolean org$apache$spark$storage$BlockManagerMasterEndpoint$$heartbeatReceived(BlockManagerId blockManagerId) {
        boolean bl;
        if (!this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().contains((Object)blockManagerId)) {
            bl = blockManagerId.isDriver() && !this.isLocal();
        } else {
            ((BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)blockManagerId)).updateLastSeenMs();
            bl = true;
        }
        return bl;
    }

    public void org$apache$spark$storage$BlockManagerMasterEndpoint$$removeBlockFromWorkers(BlockId blockId) {
        block0: {
            HashSet<BlockManagerId> locations = this.blockLocations().get(blockId);
            if (locations == null) break block0;
            locations.foreach((Function1 & Serializable & scala.Serializable)blockManagerId -> {
                Option blockManager = this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().get(blockManagerId);
                return blockManager.isDefined() ? ((BlockManagerInfo)blockManager.get()).slaveEndpoint().ask(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean()) : BoxedUnit.UNIT;
            });
        }
    }

    public scala.collection.immutable.Map<BlockManagerId, Tuple2<Object, Object>> org$apache$spark$storage$BlockManagerMasterEndpoint$$memoryStatus() {
        return ((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
            BlockManagerInfo info = (BlockManagerInfo)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)blockManagerId, (Object)new Tuple2.mcJJ.sp(info.maxMem(), info.remainingMem()));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public StorageStatus[] org$apache$spark$storage$BlockManagerMasterEndpoint$$storageStatus() {
        return (StorageStatus[])((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
            BlockManagerInfo info = (BlockManagerInfo)tuple2._2();
            StorageStatus storageStatus = new StorageStatus(blockManagerId, info.maxMem(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)info.maxOnHeapMem())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)info.maxOffHeapMem())), (Map<BlockId, BlockStatus>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(info.blocks()).asScala()));
            return storageStatus;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StorageStatus.class));
    }

    public scala.collection.immutable.Map<BlockManagerId, Future<Option<BlockStatus>>> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockStatus(BlockId blockId, boolean askSlaves) {
        BlockManagerMessages.GetBlockStatus getBlockStatus = new BlockManagerMessages.GetBlockStatus(blockId, BlockManagerMessages$GetBlockStatus$.MODULE$.apply$default$2());
        return ((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().map((Function1 & Serializable & scala.Serializable)info -> {
            Future blockStatusFuture = askSlaves ? info.slaveEndpoint().ask(getBlockStatus, ClassTag$.MODULE$.apply(Option.class)) : Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> info.getStatus(blockId), (ExecutionContext)this.askExecutionContext());
            return new Tuple2((Object)info.blockManagerId(), (Object)blockStatusFuture);
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Future<Seq<BlockId>> org$apache$spark$storage$BlockManagerMasterEndpoint$$getMatchingBlockIds(Function1<BlockId, Object> filter, boolean askSlaves) {
        BlockManagerMessages.GetMatchingBlockIds getMatchingBlockIds = new BlockManagerMessages.GetMatchingBlockIds(filter, BlockManagerMessages$GetMatchingBlockIds$.MODULE$.apply$default$2());
        return Future$.MODULE$.sequence((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().map((Function1 & Serializable & scala.Serializable)info -> {
            Future future = askSlaves ? info.slaveEndpoint().ask(getMatchingBlockIds, ClassTag$.MODULE$.apply(Seq.class)) : Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(info.blocks()).asScala()).keys().filter(filter)).toSeq(), (ExecutionContext)this.askExecutionContext());
            return future;
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom(), (ExecutionContext)this.askExecutionContext()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)x$4.flatten((Function1)Predef$.MODULE$.$conforms())).toSeq(), (ExecutionContext)this.askExecutionContext());
    }

    public BlockManagerId org$apache$spark$storage$BlockManagerMasterEndpoint$$register(BlockManagerId idWithoutTopologyInfo, long maxOnHeapMemSize, long maxOffHeapMemSize, RpcEndpointRef slaveEndpoint) {
        BlockManagerId id = BlockManagerId$.MODULE$.apply(idWithoutTopologyInfo.executorId(), idWithoutTopologyInfo.host(), idWithoutTopologyInfo.port(), this.topologyMapper().getTopologyForHost(idWithoutTopologyInfo.host()));
        long time = System.currentTimeMillis();
        if (!this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().contains((Object)id)) {
            Option option = this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().get((Object)id.executorId());
            if (option instanceof Some) {
                Some some = (Some)option;
                BlockManagerId oldId = (BlockManagerId)some.value();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Got two different block manager registrations on same executor - ").append(" will replace old one ").append(oldId).append(" with new one ").append(id).toString());
                this.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeExecutor(id.executorId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Registering block manager %s with %s RAM, %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id.hostPort(), Utils$.MODULE$.bytesToString(maxOnHeapMemSize + maxOffHeapMemSize), id})));
            this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().update((Object)id.executorId(), (Object)id);
            this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().update((Object)id, (Object)new BlockManagerInfo(id, System.currentTimeMillis(), maxOnHeapMemSize, maxOffHeapMemSize, slaveEndpoint));
        }
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus.post(new SparkListenerBlockManagerAdded(time, id, maxOnHeapMemSize + maxOffHeapMemSize, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)maxOnHeapMemSize)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)maxOffHeapMemSize))));
        return id;
    }

    public boolean org$apache$spark$storage$BlockManagerMasterEndpoint$$updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        HashSet<BlockManagerId> hashSet;
        if (!this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().contains((Object)blockManagerId)) {
            return blockManagerId.isDriver() && !this.isLocal();
        }
        if (blockId == null) {
            ((BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)blockManagerId)).updateLastSeenMs();
            return true;
        }
        ((BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)blockManagerId)).updateBlockInfo(blockId, storageLevel, memSize, diskSize);
        HashSet<BlockManagerId> locations = null;
        if (this.blockLocations().containsKey(blockId)) {
            locations = this.blockLocations().get(blockId);
            hashSet = BoxedUnit.UNIT;
        } else {
            locations = new HashSet<BlockManagerId>();
            hashSet = this.blockLocations().put(blockId, locations);
        }
        boolean bl = storageLevel.isValid() ? locations.add((Object)blockManagerId) : locations.remove((Object)blockManagerId);
        HashSet<BlockManagerId> hashSet2 = locations.size() == 0 ? this.blockLocations().remove(blockId) : BoxedUnit.UNIT;
        return true;
    }

    public Seq<BlockManagerId> org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocations(BlockId blockId) {
        return this.blockLocations().containsKey(blockId) ? ((SetLike)this.blockLocations().get(blockId)).toSeq() : (Seq)Seq$.MODULE$.empty();
    }

    public Option<BlockManagerMessages.BlockLocationsAndStatus> org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocationsAndStatus(BlockId blockId) {
        Seq locations = (Seq)Option$.MODULE$.apply(this.blockLocations().get(blockId)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Option status = locations.headOption().flatMap((Function1 & Serializable & scala.Serializable)bmId -> ((BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply(bmId)).getStatus(blockId));
        return locations.nonEmpty() && status.isDefined() ? new Some((Object)new BlockManagerMessages.BlockLocationsAndStatus((Seq<BlockManagerId>)locations, (BlockStatus)status.get())) : None$.MODULE$;
    }

    public IndexedSeq<Seq<BlockManagerId>> org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocationsMultipleBlockIds(BlockId[] blockIds) {
        return (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).map((Function1 & Serializable & scala.Serializable)blockId -> this.org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocations((BlockId)blockId), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<BlockManagerId> org$apache$spark$storage$BlockManagerMasterEndpoint$$getPeers(BlockManagerId blockManagerId) {
        Set blockManagerIds = this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().keySet();
        return blockManagerIds.contains((Object)blockManagerId) ? ((scala.collection.SetLike)((TraversableLike)blockManagerIds.filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDriver()))).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)BlockManagerMasterEndpoint.$anonfun$getPeers$2(blockManagerId, x$7)))).toSeq() : (Seq)Seq$.MODULE$.empty();
    }

    public Option<RpcEndpointRef> org$apache$spark$storage$BlockManagerMasterEndpoint$$getExecutorEndpointRef(String executorId) {
        return this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().get((Object)executorId).flatMap((Function1 & Serializable & scala.Serializable)blockManagerId -> this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().get(blockManagerId).map((Function1 & Serializable & scala.Serializable)info -> info.slaveEndpoint()));
    }

    @Override
    public void onStop() {
        this.askThreadPool().shutdownNow();
    }

    public static final /* synthetic */ boolean $anonfun$removeRdd$2(int rddId$1, RDDBlockId x$2) {
        return x$2.rddId() == rddId$1;
    }

    public static final /* synthetic */ void $anonfun$removeRdd$4(BlockManagerMasterEndpoint $this, RDDBlockId blockId$1, BlockManagerId bm) {
        $this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().get((Object)bm).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.removeBlock(blockId$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeBroadcast$1(boolean removeFromDriver$1, BlockManagerInfo info) {
        return removeFromDriver$1 || !info.blockManagerId().isDriver();
    }

    public static final /* synthetic */ boolean $anonfun$removeBlockManager$3(BlockManagerId candidateBMId$1, BlockManagerId bm) {
        BlockManagerId blockManagerId = bm;
        BlockManagerId blockManagerId2 = candidateBMId$1;
        return blockManagerId == null ? blockManagerId2 != null : !((Object)blockManagerId).equals(blockManagerId2);
    }

    public static final /* synthetic */ boolean $anonfun$getPeers$2(BlockManagerId blockManagerId$2, BlockManagerId x$7) {
        BlockManagerId blockManagerId = x$7;
        BlockManagerId blockManagerId2 = blockManagerId$2;
        return !(blockManagerId != null ? !((Object)blockManagerId).equals(blockManagerId2) : blockManagerId2 != null);
    }

    public BlockManagerMasterEndpoint(RpcEnv rpcEnv, boolean isLocal, SparkConf conf, LiveListenerBus listenerBus) {
        this.rpcEnv = rpcEnv;
        this.isLocal = isLocal;
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus = listenerBus;
        RpcEndpoint.$init$(this);
        Logging.$init$(this);
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo = new scala.collection.mutable.HashMap();
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor = new scala.collection.mutable.HashMap();
        this.blockLocations = new HashMap();
        this.askThreadPool = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("block-manager-ask-thread-pool", 100, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.askExecutionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.askThreadPool());
        String topologyMapperClassName = conf.get("spark.storage.replication.topologyMapper", DefaultTopologyMapper.class.getName());
        Class<?> clazz = Utils$.MODULE$.classForName(topologyMapperClassName);
        TopologyMapper mapper = (TopologyMapper)clazz.getConstructor(SparkConf.class).newInstance(conf);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Using ").append(topologyMapperClassName).append(" for getting topology information").toString());
        this.topologyMapper = mapper;
        this.proactivelyReplicate = new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.storage.replication.proactive", "false"))).toBoolean();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BlockManagerMasterEndpoint up");
    }
}

