/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t=c!\u0002\u0013&\u0001\u001dj\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0007I\u0011\u0001\u001f\t\u0011\r\u0003!\u00111A\u0005\u0002\u0011C\u0001B\u0013\u0001\u0003\u0002\u0003\u0006K!\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000bC\u0003U\u0001\u0011\u0005Q\u000bC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\r\u0001\u0004\u0001\u0015!\u0003^\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005%\u0002\u0001\"\u0001\u0002l!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!!'\u0001\t\u0003\tY\nC\u0004\u0002,\u0002!\t!!,\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003?\u0004A\u0011AAq\u0011%\t\t\u0010AI\u0001\n\u0003\t\u0019\u0010C\u0004\u0003\n\u0001!\tAa\u0003\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B\u0013\u0001\u0011%!qE\u0004\t\u0005g)\u0003\u0012A\u0014\u00036\u00199A%\nE\u0001O\t]\u0002B\u0002+!\t\u0003\u0011I\u0004C\u0005\u0003<\u0001\u0012\r\u0011\"\u0001\u0003>!A!Q\n\u0011!\u0002\u0013\u0011yD\u0001\nCY>\u001c7.T1oC\u001e,'/T1ti\u0016\u0014(B\u0001\u0014(\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\n\u0004\u00019\"\u0004CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g\r\u0005\u00026q5\taG\u0003\u00028O\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002:m\t9Aj\\4hS:<\u0017A\u00043sSZ,'/\u00128ea>Lg\u000e^\u0002\u0001+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!(\u0003\r\u0011\boY\u0005\u0003\u0005~\u0012aB\u00159d\u000b:$\u0007o\\5oiJ+g-\u0001\nee&4XM]#oIB|\u0017N\u001c;`I\u0015\fHCA#I!\tyc)\u0003\u0002Ha\t!QK\\5u\u0011\u001dI%!!AA\u0002u\n1\u0001\u001f\u00132\u0003=!'/\u001b<fe\u0016sG\r]8j]R\u0004\u0013\u0001B2p]\u001a\u0004\"!\u0014(\u000e\u0003\u001dJ!aT\u0014\u0003\u0013M\u0003\u0018M]6D_:4\u0017\u0001C5t\tJLg/\u001a:\u0011\u0005=\u0012\u0016BA*1\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003\u0002,Y3j\u0003\"a\u0016\u0001\u000e\u0003\u0015BQA\u000f\u0004A\u0002uBQa\u0013\u0004A\u00021CQ\u0001\u0015\u0004A\u0002E\u000bq\u0001^5nK>,H/F\u0001^!\tqd,\u0003\u0002`\u007f\tQ!\u000b]2US6,w.\u001e;\u0002\u0011QLW.Z8vi\u0002\naB]3n_Z,W\t_3dkR|'\u000f\u0006\u0002FG\")A-\u0003a\u0001K\u00061Q\r_3d\u0013\u0012\u0004\"AZ7\u000f\u0005\u001d\\\u0007C\u000151\u001b\u0005I'B\u00016<\u0003\u0019a$o\\8u}%\u0011A\u000eM\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002ma\u0005\u0019\"/Z7pm\u0016,\u00050Z2vi>\u0014\u0018i]=oGR\u0011QI\u001d\u0005\u0006I*\u0001\r!Z\u0001\u0015e\u0016<\u0017n\u001d;fe\ncwnY6NC:\fw-\u001a:\u0015\rUD(p`A\u0002!\t9f/\u0003\u0002xK\tq!\t\\8dW6\u000bg.Y4fe&#\u0007\"B=\f\u0001\u0004)\u0018A\u00042m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\u0005\u0006w.\u0001\r\u0001`\u0001\u0011[\u0006DxJ\u001c%fCBlU-\\*ju\u0016\u0004\"aL?\n\u0005y\u0004$\u0001\u0002'p]\u001eDa!!\u0001\f\u0001\u0004a\u0018!E7bq>3g\rS3ba6+WnU5{K\"1\u0011QA\u0006A\u0002u\nQb\u001d7bm\u0016,e\u000e\u001a9pS:$\u0018aD;qI\u0006$XM\u00117pG.LeNZ8\u0015\u0017E\u000bY!!\u0004\u0002\u0018\u0005\u0005\u0012Q\u0005\u0005\u0006s2\u0001\r!\u001e\u0005\b\u0003\u001fa\u0001\u0019AA\t\u0003\u001d\u0011Gn\\2l\u0013\u0012\u00042aVA\n\u0013\r\t)\"\n\u0002\b\u00052|7m[%e\u0011\u001d\tI\u0002\u0004a\u0001\u00037\tAb\u001d;pe\u0006<W\rT3wK2\u00042aVA\u000f\u0013\r\ty\"\n\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u0005\u0007\u0003Ga\u0001\u0019\u0001?\u0002\u000f5,WnU5{K\"1\u0011q\u0005\u0007A\u0002q\f\u0001\u0002Z5tWNK'0Z\u0001\rO\u0016$Hj\\2bi&|gn\u001d\u000b\u0005\u0003[\ty\u0004E\u0003\u00020\u0005eRO\u0004\u0003\u00022\u0005Ubb\u00015\u00024%\t\u0011'C\u0002\u00028A\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002<\u0005u\"aA*fc*\u0019\u0011q\u0007\u0019\t\u000f\u0005=Q\u00021\u0001\u0002\u0012\u0005)r-\u001a;M_\u000e\fG/[8og\u0006sGm\u0015;biV\u001cH\u0003BA#\u0003S\u0002RaLA$\u0003\u0017J1!!\u00131\u0005\u0019y\u0005\u000f^5p]B!\u0011QJA2\u001d\u0011\ty%a\u0018\u000f\t\u0005E\u0013Q\f\b\u0005\u0003'\nYF\u0004\u0003\u0002V\u0005ecb\u00015\u0002X%\tA&\u0003\u0002+W%\u0011\u0001&K\u0005\u0003M\u001dJ1!!\u0019&\u0003Q\u0011En\\2l\u001b\u0006t\u0017mZ3s\u001b\u0016\u001c8/Y4fg&!\u0011QMA4\u0005]\u0011En\\2l\u0019>\u001c\u0017\r^5p]N\fe\u000eZ*uCR,8OC\u0002\u0002b\u0015Bq!a\u0004\u000f\u0001\u0004\t\t\u0002\u0006\u0003\u0002n\u0005M\u0004CBA\u0018\u0003_\ni#\u0003\u0003\u0002r\u0005u\"AC%oI\u0016DX\rZ*fc\"9\u0011QO\bA\u0002\u0005]\u0014\u0001\u00032m_\u000e\\\u0017\nZ:\u0011\u000b=\nI(!\u0005\n\u0007\u0005m\u0004GA\u0003BeJ\f\u00170\u0001\u0005d_:$\u0018-\u001b8t)\r\t\u0016\u0011\u0011\u0005\b\u0003\u001f\u0001\u0002\u0019AA\t\u0003!9W\r\u001e)fKJ\u001cH\u0003BA\u0017\u0003\u000fCQ!_\tA\u0002U\facZ3u\u000bb,7-\u001e;pe\u0016sG\r]8j]R\u0014VM\u001a\u000b\u0005\u0003\u001b\u000by\t\u0005\u00030\u0003\u000fj\u0004BBAI%\u0001\u0007Q-\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\f1B]3n_Z,'\t\\8dWR\u0019Q)a&\t\u000f\u0005=1\u00031\u0001\u0002\u0012\u0005I!/Z7pm\u0016\u0014F\r\u001a\u000b\u0006\u000b\u0006u\u0015q\u0015\u0005\b\u0003?#\u0002\u0019AAQ\u0003\u0015\u0011H\rZ%e!\ry\u00131U\u0005\u0004\u0003K\u0003$aA%oi\"1\u0011\u0011\u0016\u000bA\u0002E\u000b\u0001B\u00197pG.LgnZ\u0001\u000ee\u0016lwN^3TQV4g\r\\3\u0015\u000b\u0015\u000by+a-\t\u000f\u0005EV\u00031\u0001\u0002\"\u0006I1\u000f[;gM2,\u0017\n\u001a\u0005\u0007\u0003S+\u0002\u0019A)\u0002\u001fI,Wn\u001c<f\u0005J|\u0017\rZ2bgR$r!RA]\u0003{\u000b\t\r\u0003\u0004\u0002<Z\u0001\r\u0001`\u0001\fEJ|\u0017\rZ2bgRLE\r\u0003\u0004\u0002@Z\u0001\r!U\u0001\u0011e\u0016lwN^3Ge>lW*Y:uKJDa!!+\u0017\u0001\u0004\t\u0016aD4fi6+Wn\u001c:z'R\fG/^:\u0016\u0005\u0005\u001d\u0007C\u00024\u0002JV\fi-C\u0002\u0002L>\u00141!T1q!\u0015y\u0013q\u001a?}\u0013\r\t\t\u000e\r\u0002\u0007)V\u0004H.\u001a\u001a\u0002!\u001d,Go\u0015;pe\u0006<Wm\u0015;biV\u001cXCAAl!\u0015y\u0013\u0011PAm!\r9\u00161\\\u0005\u0004\u0003;,#!D*u_J\fw-Z*uCR,8/\u0001\bhKR\u0014En\\2l'R\fG/^:\u0015\r\u0005\r\u00181^Aw!\u00191\u0017\u0011Z;\u0002fB\u0019q+a:\n\u0007\u0005%XEA\u0006CY>\u001c7n\u0015;biV\u001c\bbBA\b3\u0001\u0007\u0011\u0011\u0003\u0005\t\u0003_L\u0002\u0013!a\u0001#\u0006I\u0011m]6TY\u00064Xm]\u0001\u0019O\u0016$(\t\\8dWN#\u0018\r^;tI\u0011,g-Y;mi\u0012\u0012TCAA{U\r\t\u0016q_\u0016\u0003\u0003s\u0004B!a?\u0003\u00065\u0011\u0011Q \u0006\u0005\u0003\u007f\u0014\t!A\u0005v]\u000eDWmY6fI*\u0019!1\u0001\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\b\u0005u(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0019r-\u001a;NCR\u001c\u0007.\u001b8h\u00052|7m[%egR1!Q\u0002B\b\u00053\u0001b!a\f\u0002:\u0005E\u0001b\u0002B\t7\u0001\u0007!1C\u0001\u0007M&dG/\u001a:\u0011\r=\u0012)\"!\u0005R\u0013\r\u00119\u0002\r\u0002\n\rVt7\r^5p]FBa!a<\u001c\u0001\u0004\t\u0016a\u00045bg\u000e\u000b7\r[3e\u00052|7m[:\u0015\u0007E\u0013y\u0002\u0003\u0004\u0002\u0012r\u0001\r!Z\u0001\u0005gR|\u0007\u000fF\u0001F\u0003\u0011!X\r\u001c7\u0015\u0007\u0015\u0013I\u0003C\u0004\u0003,y\u0001\rA!\f\u0002\u000f5,7o]1hKB\u0019qFa\f\n\u0007\tE\u0002GA\u0002B]f\f!C\u00117pG.l\u0015M\\1hKJl\u0015m\u001d;feB\u0011q\u000bI\n\u0003A9\"\"A!\u000e\u0002)\u0011\u0013\u0016JV#S?\u0016sE\tU(J\u001dR{f*Q'F+\t\u0011y\u0004\u0005\u0003\u0003B\t-SB\u0001B\"\u0015\u0011\u0011)Ea\u0012\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0013\nAA[1wC&\u0019aNa\u0011\u0002+\u0011\u0013\u0016JV#S?\u0016sE\tU(J\u001dR{f*Q'FA\u0001")
public class BlockManagerMaster
implements Logging {
    private RpcEndpointRef driverEndpoint;
    private final boolean isDriver;
    private final RpcTimeout timeout;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String DRIVER_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public RpcTimeout timeout() {
        return this.timeout;
    }

    public void removeExecutor(String execId) {
        this.tell(new BlockManagerMessages.RemoveExecutor(execId));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removed ").append(execId).append(" successfully in removeExecutor").toString());
    }

    public void removeExecutorAsync(String execId) {
        this.driverEndpoint().ask(new BlockManagerMessages.RemoveExecutor(execId), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Removal of executor ").append(execId).append(" requested").toString());
    }

    public BlockManagerId registerBlockManager(BlockManagerId blockManagerId, long maxOnHeapMemSize, long maxOffHeapMemSize, RpcEndpointRef slaveEndpoint) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Registering BlockManager ").append(blockManagerId).toString());
        BlockManagerId updatedId = (BlockManagerId)this.driverEndpoint().askSync(new BlockManagerMessages.RegisterBlockManager(blockManagerId, maxOnHeapMemSize, maxOffHeapMemSize, slaveEndpoint), ClassTag$.MODULE$.apply(BlockManagerId.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Registered BlockManager ").append(updatedId).toString());
        return updatedId;
    }

    public boolean updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        boolean res = BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(new BlockManagerMessages.UpdateBlockInfo(blockManagerId, blockId, storageLevel, memSize, diskSize), ClassTag$.MODULE$.Boolean()));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Updated info of block ").append(blockId).toString());
        return res;
    }

    public Seq<BlockManagerId> getLocations(BlockId blockId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocations(blockId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<BlockManagerMessages.BlockLocationsAndStatus> getLocationsAndStatus(BlockId blockId) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsAndStatus(blockId), ClassTag$.MODULE$.apply(Option.class));
    }

    public IndexedSeq<Seq<BlockManagerId>> getLocations(BlockId[] blockIds) {
        return (IndexedSeq)this.driverEndpoint().askSync(new BlockManagerMessages.GetLocationsMultipleBlockIds(blockIds), ClassTag$.MODULE$.apply(IndexedSeq.class));
    }

    public boolean contains(BlockId blockId) {
        return !this.getLocations(blockId).isEmpty();
    }

    public Seq<BlockManagerId> getPeers(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askSync(new BlockManagerMessages.GetPeers(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<RpcEndpointRef> getExecutorEndpointRef(String executorId) {
        return (Option)this.driverEndpoint().askSync(new BlockManagerMessages.GetExecutorEndpointRef(executorId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void removeBlock(BlockId blockId) {
        this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean());
    }

    public void removeRdd(int rddId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveRdd(rddId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Failed to remove RDD ").append(rddId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            this.timeout().awaitResult(future);
        }
    }

    public void removeShuffle(int shuffleId, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveShuffle(shuffleId), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Failed to remove shuffle ").append(shuffleId$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            this.timeout().awaitResult(future);
        }
    }

    public void removeBroadcast(long broadcastId, boolean removeFromMaster, boolean blocking) {
        block0: {
            Future future = (Future)this.driverEndpoint().askSync(new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromMaster), ClassTag$.MODULE$.apply(Future.class));
            future.failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Failed to remove broadcast ").append(broadcastId$1).append(" with removeFromMaster = ").append(removeFromMaster$1).append(" - ").append(e.getMessage()).toString(), e);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            if (!blocking) break block0;
            this.timeout().awaitResult(future);
        }
    }

    public Map<BlockManagerId, Tuple2<Object, Object>> getMemoryStatus() {
        if (this.driverEndpoint() == null) {
            return Predef$.MODULE$.Map().empty();
        }
        return (Map)this.driverEndpoint().askSync(BlockManagerMessages$GetMemoryStatus$.MODULE$, ClassTag$.MODULE$.apply(Map.class));
    }

    public StorageStatus[] getStorageStatus() {
        if (this.driverEndpoint() == null) {
            return (StorageStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StorageStatus.class));
        }
        return (StorageStatus[])this.driverEndpoint().askSync(BlockManagerMessages$GetStorageStatus$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StorageStatus.class)));
    }

    public Map<BlockManagerId, BlockStatus> getBlockStatus(BlockId blockId, boolean askSlaves) {
        BlockManagerMessages.GetBlockStatus msg = new BlockManagerMessages.GetBlockStatus(blockId, askSlaves);
        Map response = (Map)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Map.class));
        Tuple2 tuple2 = response.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Iterable blockManagerIds = (scala.collection.immutable.Iterable)tuple2._1();
        scala.collection.immutable.Iterable futures = (scala.collection.immutable.Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)blockManagerIds, (Object)futures);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Iterable blockManagerIds2 = (scala.collection.immutable.Iterable)tuple23._1();
        scala.collection.immutable.Iterable futures2 = (scala.collection.immutable.Iterable)tuple23._2();
        ExecutionContextExecutor sameThread = ThreadUtils$.MODULE$.sameThread();
        CanBuildFrom cbf = (CanBuildFrom)Predef$.MODULE$.implicitly((Object)scala.collection.Iterable$.MODULE$.canBuildFrom());
        Iterable blockStatus = (Iterable)this.timeout().awaitResult(Future$.MODULE$.sequence((TraversableOnce)futures2, cbf, (ExecutionContext)ThreadUtils$.MODULE$.sameThread()));
        if (blockStatus == null) {
            throw new SparkException(new StringBuilder(50).append("BlockManager returned null for BlockStatus query: ").append(blockId).toString());
        }
        return ((TraversableOnce)((TraversableLike)blockManagerIds2.zip((GenIterable)blockStatus, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
            Option status = (Option)tuple2._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(status.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)blockManagerId, s)));
            return iterable;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public boolean getBlockStatus$default$2() {
        return true;
    }

    public Seq<BlockId> getMatchingBlockIds(Function1<BlockId, Object> filter, boolean askSlaves) {
        BlockManagerMessages.GetMatchingBlockIds msg = new BlockManagerMessages.GetMatchingBlockIds(filter, askSlaves);
        Future future = (Future)this.driverEndpoint().askSync(msg, ClassTag$.MODULE$.apply(Future.class));
        return (Seq)this.timeout().awaitResult(future);
    }

    public boolean hasCachedBlocks(String executorId) {
        return BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(new BlockManagerMessages.HasCachedBlocks(executorId), ClassTag$.MODULE$.Boolean()));
    }

    public void stop() {
        block0: {
            if (this.driverEndpoint() == null || !this.isDriver) break block0;
            this.tell(BlockManagerMessages$StopBlockManagerMaster$.MODULE$);
            this.driverEndpoint_$eq(null);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BlockManagerMaster stopped");
        }
    }

    private void tell(Object message) {
        if (!BoxesRunTime.unboxToBoolean(this.driverEndpoint().askSync(message, ClassTag$.MODULE$.Boolean()))) {
            throw new SparkException("BlockManagerMasterEndpoint returned false, expected true.");
        }
    }

    public BlockManagerMaster(RpcEndpointRef driverEndpoint, SparkConf conf, boolean isDriver) {
        this.driverEndpoint = driverEndpoint;
        this.isDriver = isDriver;
        Logging.$init$(this);
        this.timeout = RpcUtils$.MODULE$.askRpcTimeout(conf);
    }
}

