/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.sort.SortShuffleWriter$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.collection.ExternalSorter;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product2;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]f!B\u000e\u001d\u0001\u00012\u0003\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t'\u0002\u0011\t\u0011)A\u0005)\")\u0001\f\u0001C\u00013\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007BB3\u0001A\u0003%!\rC\u0004g\u0001\t\u0007I\u0011B4\t\r9\u0004\u0001\u0015!\u0003i\u0011\u001dy\u0007\u00011A\u0005\nADqA \u0001A\u0002\u0013%q\u0010\u0003\u0004~\u0001\u0001\u0006K!\u001d\u0005\n\u0003'\u0001\u0001\u0019!C\u0005\u0003+A\u0011\"!\b\u0001\u0001\u0004%I!a\b\t\u0011\u0005\r\u0002\u0001)Q\u0005\u0003/A\u0011\"!\n\u0001\u0001\u0004%I!a\n\t\u0013\u0005U\u0002\u00011A\u0005\n\u0005]\u0002\u0002CA\u001e\u0001\u0001\u0006K!!\u000b\t\u0013\u0005u\u0002A1A\u0005\n\u0005}\u0002\u0002CA'\u0001\u0001\u0006I!!\u0011\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!9\u0011Q\u000f\u0001\u0005B\u0005]t\u0001CAB9!\u0005\u0001%!\"\u0007\u000fma\u0002\u0012\u0001\u0011\u0002\b\"1\u0001\f\u0007C\u0001\u0003\u001fCq!!%\u0019\t\u0003\t\u0019JA\tT_J$8\u000b[;gM2,wK]5uKJT!!\b\u0010\u0002\tM|'\u000f\u001e\u0006\u0003?\u0001\nqa\u001d5vM\u001adWM\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h+\u00119c\u0006P'\u0014\u0007\u0001Ac\b\u0005\u0003*U1ZT\"\u0001\u0010\n\u0005-r\"!D*ik\u001a4G.Z,sSR,'\u000f\u0005\u0002.]1\u0001A!B\u0018\u0001\u0005\u0004\t$!A&\u0004\u0001E\u0011!\u0007\u000f\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\b\u001d>$\b.\u001b8h!\t\u0019\u0014(\u0003\u0002;i\t\u0019\u0011I\\=\u0011\u00055bD!B\u001f\u0001\u0005\u0004\t$!\u0001,\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005\u0003\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\r\u0003%a\u0002'pO\u001eLgnZ\u0001\u0015g\",hM\u001a7f\u00052|7m\u001b*fg>dg/\u001a:\u0011\u0005%2\u0015BA$\u001f\u0005eIe\u000eZ3y'\",hM\u001a7f\u00052|7m\u001b*fg>dg/\u001a:\u0002\r!\fg\u000e\u001a7f!\u0015I#\nL\u001eM\u0013\tYeDA\tCCN,7\u000b[;gM2,\u0007*\u00198eY\u0016\u0004\"!L'\u0005\u000b9\u0003!\u0019A\u0019\u0003\u0003\r\u000bQ!\\1q\u0013\u0012\u0004\"aM)\n\u0005I#$aA%oi\u000691m\u001c8uKb$\bCA+W\u001b\u0005\u0001\u0013BA,!\u0005-!\u0016m]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0015QF,\u00180`!\u0015Y\u0006\u0001L\u001eM\u001b\u0005a\u0002\"\u0002#\u0006\u0001\u0004)\u0005\"\u0002%\u0006\u0001\u0004I\u0005\"B(\u0006\u0001\u0004\u0001\u0006\"B*\u0006\u0001\u0004!\u0016a\u00013faV\t!\rE\u0003VG2ZD*\u0003\u0002eA\t\t2\u000b[;gM2,G)\u001a9f]\u0012,gnY=\u0002\t\u0011,\u0007\u000fI\u0001\rE2|7m['b]\u0006<WM]\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eI\u0001\bgR|'/Y4f\u0013\ti'N\u0001\u0007CY>\u001c7.T1oC\u001e,'/A\u0007cY>\u001c7.T1oC\u001e,'\u000fI\u0001\u0007g>\u0014H/\u001a:\u0016\u0003E\u0004$A]>\u0011\u000bMDHf\u000f>\u000e\u0003QT!!\u001e<\u0002\u0015\r|G\u000e\\3di&|gN\u0003\u0002xA\u0005!Q\u000f^5m\u0013\tIHO\u0001\bFqR,'O\\1m'>\u0014H/\u001a:\u0011\u00055ZH!\u0003?\r\u0003\u0003\u0005\tQ!\u00012\u0005\ryF%M\u0001\bg>\u0014H/\u001a:!\u0003)\u0019xN\u001d;fe~#S-\u001d\u000b\u0005\u0003\u0003\t9\u0001E\u00024\u0003\u0007I1!!\u00025\u0005\u0011)f.\u001b;\t\u0013\u0005%1\"!AA\u0002\u0005-\u0011a\u0001=%cA\"\u0011QBA\t!\u0019\u0019\b\u0010L\u001e\u0002\u0010A\u0019Q&!\u0005\u0005\u0015q\f9!!A\u0001\u0002\u000b\u0005\u0011'\u0001\u0005ti>\u0004\b/\u001b8h+\t\t9\u0002E\u00024\u00033I1!a\u00075\u0005\u001d\u0011un\u001c7fC:\fAb\u001d;paBLgnZ0%KF$B!!\u0001\u0002\"!I\u0011\u0011\u0002\b\u0002\u0002\u0003\u0007\u0011qC\u0001\ngR|\u0007\u000f]5oO\u0002\n\u0011\"\\1q'R\fG/^:\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0002%A\u0005tG\",G-\u001e7fe&!\u00111GA\u0017\u0005%i\u0015\r]*uCR,8/A\u0007nCB\u001cF/\u0019;vg~#S-\u001d\u000b\u0005\u0003\u0003\tI\u0004C\u0005\u0002\nE\t\t\u00111\u0001\u0002*\u0005QQ.\u00199Ti\u0006$Xo\u001d\u0011\u0002\u0019]\u0014\u0018\u000e^3NKR\u0014\u0018nY:\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d\u0003%\u0001\u0005fq\u0016\u001cW\u000f^8s\u0013\u0011\tY%!\u0012\u0003'MCWO\u001a4mK^\u0013\u0018\u000e^3NKR\u0014\u0018nY:\u0002\u001b]\u0014\u0018\u000e^3NKR\u0014\u0018nY:!\u0003\u00159(/\u001b;f)\u0011\t\t!a\u0015\t\u000f\u0005US\u00031\u0001\u0002X\u00059!/Z2pe\u0012\u001c\bCBA-\u0003S\nyG\u0004\u0003\u0002\\\u0005\u0015d\u0002BA/\u0003Gj!!a\u0018\u000b\u0007\u0005\u0005\u0004'\u0001\u0004=e>|GOP\u0005\u0002k%\u0019\u0011q\r\u001b\u0002\u000fA\f7m[1hK&!\u00111NA7\u0005!IE/\u001a:bi>\u0014(bAA4iA)1'!\u001d-w%\u0019\u00111\u000f\u001b\u0003\u0011A\u0013x\u000eZ;diJ\nAa\u001d;paR!\u0011\u0011PA@!\u0015\u0019\u00141PA\u0015\u0013\r\ti\b\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0005e\u00031\u0001\u0002\u0018\u000591/^2dKN\u001c\u0018!E*peR\u001c\u0006.\u001e4gY\u0016<&/\u001b;feB\u00111\fG\n\u00041\u0005%\u0005cA\u001a\u0002\f&\u0019\u0011Q\u0012\u001b\u0003\r\u0005s\u0017PU3g)\t\t))A\u000btQ>,H\u000e\u001a\"za\u0006\u001c8/T3sO\u0016\u001cvN\u001d;\u0015\r\u0005]\u0011QSAP\u0011\u001d\t9J\u0007a\u0001\u00033\u000bAaY8oMB\u0019Q+a'\n\u0007\u0005u\u0005EA\u0005Ta\u0006\u00148nQ8oM\"1\u0001M\u0007a\u0001\u0003C\u0003\u0004\"a)\u0002(\u00065\u00161\u0017\t\t+\u000e\f)+a+\u00022B\u0019Q&a*\u0005\u0017\u0005%\u0016qTA\u0001\u0002\u0003\u0015\t!\r\u0002\u0004?\u0012\u0012\u0004cA\u0017\u0002.\u0012Y\u0011qVAP\u0003\u0003\u0005\tQ!\u00012\u0005\ryFe\r\t\u0004[\u0005MFaCA[\u0003?\u000b\t\u0011!A\u0003\u0002E\u00121a\u0018\u00135\u0001")
public class SortShuffleWriter<K, V, C>
extends ShuffleWriter<K, V>
implements Logging {
    private final IndexShuffleBlockResolver shuffleBlockResolver;
    private final int mapId;
    private final TaskContext context;
    private final ShuffleDependency<K, V, C> dep;
    private final BlockManager blockManager;
    private ExternalSorter<K, V, ?> sorter;
    private boolean stopping;
    private MapStatus mapStatus;
    private final ShuffleWriteMetrics writeMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean shouldBypassMergeSort(SparkConf sparkConf, ShuffleDependency<?, ?, ?> shuffleDependency) {
        return SortShuffleWriter$.MODULE$.shouldBypassMergeSort(sparkConf, shuffleDependency);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ShuffleDependency<K, V, C> dep() {
        return this.dep;
    }

    private BlockManager blockManager() {
        return this.blockManager;
    }

    private ExternalSorter<K, V, ?> sorter() {
        return this.sorter;
    }

    private void sorter_$eq(ExternalSorter<K, V, ?> x$1) {
        this.sorter = x$1;
    }

    private boolean stopping() {
        return this.stopping;
    }

    private void stopping_$eq(boolean x$1) {
        this.stopping = x$1;
    }

    private MapStatus mapStatus() {
        return this.mapStatus;
    }

    private void mapStatus_$eq(MapStatus x$1) {
        this.mapStatus = x$1;
    }

    private ShuffleWriteMetrics writeMetrics() {
        return this.writeMetrics;
    }

    @Override
    public void write(Iterator<Product2<K, V>> records) {
        this.sorter_$eq(this.dep().mapSideCombine() ? new ExternalSorter<K, V, C>(this.context, this.dep().aggregator(), (Option<Partitioner>)new Some((Object)this.dep().partitioner()), this.dep().keyOrdering(), this.dep().serializer()) : new ExternalSorter(this.context, None$.MODULE$, (Option<Partitioner>)new Some((Object)this.dep().partitioner()), None$.MODULE$, this.dep().serializer()));
        this.sorter().insertAll(records);
        File output = this.shuffleBlockResolver.getDataFile(this.dep().shuffleId(), this.mapId);
        File tmp = Utils$.MODULE$.tempFileWith(output);
        try {
            ShuffleBlockId blockId = new ShuffleBlockId(this.dep().shuffleId(), this.mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
            long[] partitionLengths = this.sorter().writePartitionedFile(blockId, tmp);
            this.shuffleBlockResolver.writeIndexFileAndCommit(this.dep().shuffleId(), this.mapId, partitionLengths, tmp);
            this.mapStatus_$eq(MapStatus$.MODULE$.apply(this.blockManager().shuffleServerId(), partitionLengths));
        }
        finally {
            if (tmp.exists() && !tmp.delete()) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Error while deleting temp file ").append(tmp.getAbsolutePath()).toString());
            }
        }
    }

    @Override
    public Option<MapStatus> stop(boolean success) {
        Object object;
        try {
            if (this.stopping()) {
                object = None$.MODULE$;
            } else {
                this.stopping_$eq(true);
                object = success ? Option$.MODULE$.apply((Object)this.mapStatus()) : None$.MODULE$;
            }
        }
        finally {
            if (this.sorter() != null) {
                long startTime = System.nanoTime();
                this.sorter().stop();
                this.writeMetrics().incWriteTime(System.nanoTime() - startTime);
                this.sorter_$eq(null);
            }
        }
        return object;
    }

    public SortShuffleWriter(IndexShuffleBlockResolver shuffleBlockResolver, BaseShuffleHandle<K, V, C> handle, int mapId, TaskContext context) {
        this.shuffleBlockResolver = shuffleBlockResolver;
        this.mapId = mapId;
        this.context = context;
        Logging.$init$(this);
        this.dep = handle.dependency();
        this.blockManager = SparkEnv$.MODULE$.get().blockManager();
        this.sorter = null;
        this.stopping = false;
        this.mapStatus = null;
        this.writeMetrics = context.taskMetrics().shuffleWriteMetrics();
    }
}

