/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!\u0002\u000b\u0016\u0001]i\u0002\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011Q\u0002!\u0011!Q\u0001\nUBQa\u000f\u0001\u0005\u0002qB\u0001\u0002\u0011\u0001\t\u0006\u0004%I!\u0011\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u0019a\u0005\u0001)A\u0005\t\")Q\n\u0001C\u0001\u001d\")a\f\u0001C\u0005?\")!\r\u0001C\u0001G\")\u0011\u000e\u0001C\u0005U\")q\u000f\u0001C\u0001q\"1q\u0010\u0001C!\u0003\u0003Aq!!\u0007\u0001\t\u0003\nYb\u0002\u0005\u0002\u001eUA\taFA\u0010\r\u001d!R\u0003#\u0001\u0018\u0003CAaaO\b\u0005\u0002\u0005\r\u0002\"CA\u0013\u001f\t\u0007I\u0011AA\u0014\u0011\u001d\tIc\u0004Q\u0001\neC\u0011\"a\u000b\u0010#\u0003%\t!!\f\u00033%sG-\u001a=TQV4g\r\\3CY>\u001c7NU3t_24XM\u001d\u0006\u0003-]\tqa\u001d5vM\u001adWM\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h'\u0011\u0001a\u0004\n\u0015\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)c%D\u0001\u0016\u0013\t9SC\u0001\u000bTQV4g\r\\3CY>\u001c7NU3t_24XM\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003W]\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003cIj\u0011aF\u0005\u0003g]\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u001b}\u0013Gn\\2l\u001b\u0006t\u0017mZ3s!\t1\u0014(D\u00018\u0015\tAt#A\u0004ti>\u0014\u0018mZ3\n\u0005i:$\u0001\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0002>}}\u0002\"!\n\u0001\t\u000b9\u001a\u0001\u0019\u0001\u0019\t\u000fQ\u001a\u0001\u0013!a\u0001k\u0005a!\r\\8dW6\u000bg.Y4feV\tQ'A\u0007ue\u0006t7\u000f]8si\u000e{gNZ\u000b\u0002\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0005kRLGN\u0003\u0002J/\u00059a.\u001a;x_J\\\u0017BA&G\u00055!&/\u00198ta>\u0014HoQ8oM\u0006qAO]1ogB|'\u000f^\"p]\u001a\u0004\u0013aC4fi\u0012\u000bG/\u0019$jY\u0016$2aT,]!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0002j_*\tA+\u0001\u0003kCZ\f\u0017B\u0001,R\u0005\u00111\u0015\u000e\\3\t\u000ba;\u0001\u0019A-\u0002\u0013MDWO\u001a4mK&#\u0007CA\u0010[\u0013\tY\u0006EA\u0002J]RDQ!X\u0004A\u0002e\u000bQ!\\1q\u0013\u0012\fAbZ3u\u0013:$W\r\u001f$jY\u0016$2a\u00141b\u0011\u0015A\u0006\u00021\u0001Z\u0011\u0015i\u0006\u00021\u0001Z\u0003=\u0011X-\\8wK\u0012\u000bG/\u0019\"z\u001b\u0006\u0004Hc\u00013hQB\u0011q$Z\u0005\u0003M\u0002\u0012A!\u00168ji\")\u0001,\u0003a\u00013\")Q,\u0003a\u00013\u0006)2\r[3dW&sG-\u001a=B]\u0012$\u0015\r^1GS2,G\u0003B6rgV\u00042a\b7o\u0013\ti\u0007EA\u0003BeJ\f\u0017\u0010\u0005\u0002 _&\u0011\u0001\u000f\t\u0002\u0005\u0019>tw\rC\u0003s\u0015\u0001\u0007q*A\u0003j]\u0012,\u0007\u0010C\u0003u\u0015\u0001\u0007q*\u0001\u0003eCR\f\u0007\"\u0002<\u000b\u0001\u0004I\u0016A\u00022m_\u000e\\7/A\fxe&$X-\u00138eKb4\u0015\u000e\\3B]\u0012\u001cu.\\7jiR)A-\u001f>|{\")\u0001l\u0003a\u00013\")Ql\u0003a\u00013\")Ap\u0003a\u0001W\u00069A.\u001a8hi\"\u001c\b\"\u0002@\f\u0001\u0004y\u0015a\u00023bi\u0006$V\u000e]\u0001\rO\u0016$(\t\\8dW\u0012\u000bG/\u0019\u000b\u0005\u0003\u0007\ty\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI\u0001S\u0001\u0007EV4g-\u001a:\n\t\u00055\u0011q\u0001\u0002\u000e\u001b\u0006t\u0017mZ3e\u0005V4g-\u001a:\t\u000f\u0005EA\u00021\u0001\u0002\u0014\u00059!\r\\8dW&#\u0007c\u0001\u001c\u0002\u0016%\u0019\u0011qC\u001c\u0003\u001dMCWO\u001a4mK\ncwnY6JI\u0006!1\u000f^8q)\u0005!\u0017!G%oI\u0016D8\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\u0004\"!J\b\u0014\u0005=qBCAA\u0010\u00039quj\u0014)`%\u0016#UkQ#`\u0013\u0012+\u0012!W\u0001\u0010\u001d>{\u0005k\u0018*F\tV\u001bUiX%EA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a\f+\u0007U\n\td\u000b\u0002\u00024A!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!C;oG\",7m[3e\u0015\r\ti\u0004I\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA!\u0003o\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging {
    private BlockManager blockManager;
    private final BlockManager _blockManager;
    private final TransportConf transportConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static BlockManager $lessinit$greater$default$2() {
        return IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2();
    }

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if (!this.bitmap$0) {
                this.blockManager = (BlockManager)Option$.MODULE$.apply((Object)this._blockManager).getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkEnv$.MODULE$.get().blockManager());
                this.bitmap$0 = true;
            }
        }
        this._blockManager = null;
        return this.blockManager;
    }

    private BlockManager blockManager() {
        return !this.bitmap$0 ? this.blockManager$lzycompute() : this.blockManager;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    public File getDataFile(int shuffleId, int mapId) {
        return this.blockManager().diskBlockManager().getFile(new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()));
    }

    private File getIndexFile(int shuffleId, int mapId) {
        return this.blockManager().diskBlockManager().getFile(new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()));
    }

    public void removeDataByMap(int shuffleId, int mapId) {
        block1: {
            ObjectRef file = ObjectRef.create((Object)this.getDataFile(shuffleId, mapId));
            if (((File)file.elem).exists() && !((File)file.elem).delete()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Error deleting data ").append(((File)file$1.elem).getPath()).toString());
            }
            file.elem = this.getIndexFile(shuffleId, mapId);
            if (!((File)file.elem).exists() || ((File)file.elem).delete()) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Error deleting index ").append(((File)file$1.elem).getPath()).toString());
        }
    }

    private long[] checkIndexAndDataFile(File index, File data, int blocks) {
        long[] lengths;
        block11: {
            long[] lArray;
            block10: {
                DataInputStream dataInputStream;
                if (index.length() != (long)(blocks + 1) * 8L) {
                    return null;
                }
                lengths = new long[blocks];
                try {
                    dataInputStream = new DataInputStream(new NioBufferedFileInputStream(index));
                }
                catch (IOException e) {
                    return null;
                }
                try (DataInputStream in = dataInputStream;){
                    try {
                        long offset = in.readLong();
                        if (offset != 0L) {
                            lArray = null;
                            break block10;
                        }
                        for (int i = 0; i < blocks; ++i) {
                            long off = in.readLong();
                            lengths[i] = off - offset;
                            offset = off;
                        }
                        break block11;
                    }
                    catch (IOException e) {
                        lArray = null;
                    }
                }
            }
            return lArray;
        }
        return (long[])(data.length() == BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) ? lengths : null);
    }

    public void writeIndexFileAndCommit(int shuffleId, int mapId, long[] lengths, File dataTmp) {
        File indexFile = this.getIndexFile(shuffleId, mapId);
        File indexTmp = Utils$.MODULE$.tempFileWith(indexFile);
        try {
            File dataFile = this.getDataFile(shuffleId, mapId);
            IndexShuffleBlockResolver indexShuffleBlockResolver = this;
            synchronized (indexShuffleBlockResolver) {
                Object object;
                long[] existingLengths = this.checkIndexAndDataFile(indexFile, dataFile, lengths.length);
                if (existingLengths != null) {
                    System.arraycopy(existingLengths, 0, lengths, 0, lengths.length);
                    object = dataTmp != null && dataTmp.exists() ? BoxesRunTime.boxToBoolean((boolean)dataTmp.delete()) : BoxedUnit.UNIT;
                } else {
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexTmp)));
                    Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        LongRef offset = LongRef.create((long)0L);
                        out.writeLong(offset.elem);
                        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)length -> {
                            offset$1.elem += length;
                            out.writeLong(offset$1.elem);
                        });
                    }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
                    Object object2 = indexFile.exists() ? BoxesRunTime.boxToBoolean((boolean)indexFile.delete()) : BoxedUnit.UNIT;
                    Object object3 = dataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)dataFile.delete()) : BoxedUnit.UNIT;
                    if (!indexTmp.renameTo(indexFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(indexTmp).append(" to ").append(indexFile).toString());
                    }
                    if (dataTmp != null && dataTmp.exists() && !dataTmp.renameTo(dataFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(dataTmp).append(" to ").append(dataFile).toString());
                    }
                    object = BoxedUnit.UNIT;
                }
            }
        }
        finally {
            if (indexTmp.exists() && !indexTmp.delete()) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to delete temporary index file at ").append(indexTmp.getAbsolutePath()).toString());
            }
        }
    }

    @Override
    public ManagedBuffer getBlockData(ShuffleBlockId blockId) {
        FileSegmentManagedBuffer fileSegmentManagedBuffer;
        File indexFile = this.getIndexFile(blockId.shuffleId(), blockId.mapId());
        SeekableByteChannel channel = Files.newByteChannel(indexFile.toPath(), new OpenOption[0]);
        channel.position((long)blockId.reduceId() * 8L);
        try (DataInputStream in = new DataInputStream(Channels.newInputStream(channel));){
            long offset = in.readLong();
            long nextOffset = in.readLong();
            long actualPosition = channel.position();
            long expectedPosition = (long)blockId.reduceId() * 8L + 16L;
            if (actualPosition != expectedPosition) {
                throw new Exception(new StringBuilder(99).append("SPARK-22982: Incorrect channel position after index file reads: ").append("expected ").append(expectedPosition).append(" but actual position was ").append(actualPosition).append(".").toString());
            }
            fileSegmentManagedBuffer = new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(blockId.shuffleId(), blockId.mapId()), offset, nextOffset - offset);
        }
        return fileSegmentManagedBuffer;
    }

    @Override
    public void stop() {
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager) {
        this._blockManager = _blockManager;
        Logging.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3());
    }
}

