/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.scheduler.EventLoggingListener$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklisted;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklistedForStage;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerExecutorUnblacklisted;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerNodeBlacklisted;
import org.apache.spark.scheduler.SparkListenerNodeBlacklistedForStage;
import org.apache.spark.scheduler.SparkListenerNodeUnblacklisted;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.util.JsonProtocol$;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r-g!\u0002)R\u0001MK\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011M\u0004!\u0011!Q\u0001\nQD\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001BCA\u0007\u0001\t\u0005\t\u0015!\u0003\u0002\u0010!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0010\u0001\u0011\u0005\u0011q\u0006\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003wA\u0001\"a\u0011\u0001A\u0003%\u0011Q\b\u0005\n\u0003\u000b\u0002!\u0019!C\u0005\u0003wA\u0001\"a\u0012\u0001A\u0003%\u0011Q\b\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003wA\u0001\"a\u0013\u0001A\u0003%\u0011Q\b\u0005\n\u0003\u001b\u0002!\u0019!C\u0005\u0003wA\u0001\"a\u0014\u0001A\u0003%\u0011Q\b\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003'B\u0001\"a\u0017\u0001A\u0003%\u0011Q\u000b\u0005\n\u0003;\u0002!\u0019!C\u0005\u0003?B\u0001\"!\u001c\u0001A\u0003%\u0011\u0011\r\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003cB\u0001\"!!\u0001A\u0003%\u00111\u000f\u0005\n\u0003\u0007\u0003!\u0019!C\u0005\u0003\u000bCq!a\"\u0001A\u0003%A\u000fC\u0005\u0002\n\u0002\u0001\r\u0011\"\u0003\u0002\f\"I\u0011Q\u0013\u0001A\u0002\u0013%\u0011q\u0013\u0005\t\u0003G\u0003\u0001\u0015)\u0003\u0002\u000e\"I\u0011Q\u0015\u0001A\u0002\u0013%\u0011q\u0015\u0005\n\u0003k\u0003\u0001\u0019!C\u0005\u0003oC\u0001\"a/\u0001A\u0003&\u0011\u0011\u0016\u0005\u000b\u0003{\u0003!\u0019!C\u0001#\u0006}\u0006\u0002CAv\u0001\u0001\u0006I!!1\t\u0015\u00055\bA1A\u0005\u0002E\u000by\u000fC\u0004\u0002r\u0002\u0001\u000b\u0011\u00024\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u0011q\u001f\u0001\u0005\n\u0005e\b\"\u0003B\u0005\u0001E\u0005I\u0011\u0002B\u0006\u0011\u001d\u0011\t\u0003\u0001C!\u0005GAqA!\f\u0001\t\u0003\u0012y\u0003C\u0004\u0003:\u0001!\tEa\u000f\t\u000f\t\u0015\u0003\u0001\"\u0011\u0003H!9!\u0011\u000b\u0001\u0005B\tM\u0003b\u0002B/\u0001\u0011\u0005#q\f\u0005\b\u0005S\u0002A\u0011\tB6\u0011\u001d\u0011)\b\u0001C!\u0005oBqA!!\u0001\t\u0003\u0012\u0019\tC\u0004\u0003\u000e\u0002!\tEa$\t\u000f\te\u0005\u0001\"\u0011\u0003\u001c\"9!Q\u0015\u0001\u0005B\t\u001d\u0006b\u0002BY\u0001\u0011\u0005#1\u0017\u0005\b\u0005{\u0003A\u0011\tB`\u0011\u001d\u0011I\r\u0001C!\u0005\u0017DqA!6\u0001\t\u0003\u00129\u000eC\u0004\u0003b\u0002!\tEa9\t\u000f\t5\b\u0001\"\u0011\u0003p\"9!\u0011 \u0001\u0005B\tm\bbBB\u0003\u0001\u0011\u00053q\u0001\u0005\b\u0007#\u0001A\u0011IB\n\u0011\u001d\u0019i\u0002\u0001C!\u0007?Aqa!\u000b\u0001\t\u0003\u001aY\u0003C\u0004\u00046\u0001!\tea\u000e\t\u000f\rm\u0002\u0001\"\u0001\u0002v\"A1Q\b\u0001\u0005\u0002M\u001byd\u0002\u0005\u0004DEC\taUB#\r\u001d\u0001\u0016\u000b#\u0001T\u0007\u000fBq!a\bA\t\u0003\u0019y\u0005C\u0005\u0004R\u0001\u0013\r\u0011\"\u0001\u0004T!A1q\f!!\u0002\u0013\u0019)\u0006C\u0005\u0004b\u0001\u0013\r\u0011\"\u0001\u0004T!A11\r!!\u0002\u0013\u0019)\u0006C\u0005\u0004f\u0001\u0013\r\u0011\"\u0003\u0004h!A1Q\u000f!!\u0002\u0013\u0019I\u0007C\u0005\u0004x\u0001\u0013\r\u0011\"\u0003\u0004z!A1\u0011\u0011!!\u0002\u0013\u0019Y\bC\u0004\u0004\u0004\u0002#\ta!\"\t\u000f\rU\u0005\t\"\u0001\u0004\u0018\"I1\u0011\u0015!\u0012\u0002\u0013\u000511\u0015\u0005\b\u0007O\u0003E\u0011BBU\u0011\u001d\u0019y\u000b\u0011C\u0001\u0007cCqa!2A\t\u0003\u00199M\u0001\u000bFm\u0016tG\u000fT8hO&tw\rT5ti\u0016tWM\u001d\u0006\u0003%N\u000b\u0011b]2iK\u0012,H.\u001a:\u000b\u0005Q+\u0016!B:qCJ\\'B\u0001,X\u0003\u0019\t\u0007/Y2iK*\t\u0001,A\u0002pe\u001e\u001c2\u0001\u0001._!\tYF,D\u0001R\u0013\ti\u0016KA\u0007Ta\u0006\u00148\u000eT5ti\u0016tWM\u001d\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003CN\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003G\u0002\u0014q\u0001T8hO&tw-A\u0003baBLEm\u0001\u0001\u0011\u0005\u001d\u0004hB\u00015o!\tIG.D\u0001k\u0015\tYW-\u0001\u0004=e>|GO\u0010\u0006\u0002[\u0006)1oY1mC&\u0011q\u000e\\\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002pY\u0006a\u0011\r\u001d9BiR,W\u000e\u001d;JIB\u0019QO\u001e4\u000e\u00031L!a\u001e7\u0003\r=\u0003H/[8o\u0003)awn\u001a\"bg\u0016$\u0015N\u001d\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f1A\\3u\u0015\u0005q\u0018\u0001\u00026bm\u0006L1!!\u0001|\u0005\r)&+S\u0001\ngB\f'o[\"p]\u001a\u0004B!a\u0002\u0002\n5\t1+C\u0002\u0002\fM\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\t\r|gN\u001a\u0006\u0004\u00033)\u0016A\u00025bI>|\u0007/\u0003\u0003\u0002\u001e\u0005M!!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\r\u0003G\t)#a\n\u0002*\u0005-\u0012Q\u0006\t\u00037\u0002AQ\u0001\u001a\u0004A\u0002\u0019DQa\u001d\u0004A\u0002QDQ\u0001\u001f\u0004A\u0002eDq!a\u0001\u0007\u0001\u0004\t)\u0001C\u0004\u0002\u000e\u0019\u0001\r!a\u0004\u0015\u0015\u0005\r\u0012\u0011GA\u001a\u0003k\t9\u0004C\u0003e\u000f\u0001\u0007a\rC\u0003t\u000f\u0001\u0007A\u000fC\u0003y\u000f\u0001\u0007\u0011\u0010C\u0004\u0002\u0004\u001d\u0001\r!!\u0002\u0002\u001dMDw.\u001e7e\u0007>l\u0007O]3tgV\u0011\u0011Q\b\t\u0004k\u0006}\u0012bAA!Y\n9!i\\8mK\u0006t\u0017aD:i_VdGmQ8naJ,7o\u001d\u0011\u0002\u001fMDw.\u001e7e\u001fZ,'o\u001e:ji\u0016\f\u0001c\u001d5pk2$wJ^3soJLG/\u001a\u0011\u0002+MDw.\u001e7e\u0019><'\t\\8dWV\u0003H-\u0019;fg\u000612\u000f[8vY\u0012dun\u001a\"m_\u000e\\W\u000b\u001d3bi\u0016\u001c\b%A\u0004uKN$\u0018N\\4\u0002\u0011Q,7\u000f^5oO\u0002\n\u0001c\\;uaV$()\u001e4gKJ\u001c\u0016N_3\u0016\u0005\u0005U\u0003cA;\u0002X%\u0019\u0011\u0011\f7\u0003\u0007%sG/A\tpkR\u0004X\u000f\u001e\"vM\u001a,'oU5{K\u0002\n!BZ5mKNK8\u000f^3n+\t\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\u0011\t9'a\u0006\u0002\u0005\u0019\u001c\u0018\u0002BA6\u0003K\u0012!BR5mKNK8\u000f^3n\u0003-1\u0017\u000e\\3TsN$X-\u001c\u0011\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cWCAA:!\u0011)h/!\u001e\u0011\t\u0005]\u0014QP\u0007\u0003\u0003sR1!a\u001fT\u0003\tIw.\u0003\u0003\u0002\u0000\u0005e$\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0003E\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rI\u0001\u0015G>l\u0007O]3tg&|gnQ8eK\u000et\u0015-\\3\u0016\u0003Q\fQcY8naJ,7o]5p]\u000e{G-Z2OC6,\u0007%\u0001\tiC\u0012|w\u000e\u001d#bi\u0006\u001cFO]3b[V\u0011\u0011Q\u0012\t\u0005kZ\fy\t\u0005\u0003\u0002d\u0005E\u0015\u0002BAJ\u0003K\u0012!CR*ECR\fw*\u001e;qkR\u001cFO]3b[\u0006!\u0002.\u00193p_B$\u0015\r^1TiJ,\u0017-\\0%KF$B!!'\u0002 B\u0019Q/a'\n\u0007\u0005uEN\u0001\u0003V]&$\b\"CAQ3\u0005\u0005\t\u0019AAG\u0003\rAH%M\u0001\u0012Q\u0006$wn\u001c9ECR\f7\u000b\u001e:fC6\u0004\u0013AB<sSR,'/\u0006\u0002\u0002*B!QO^AV!\u0011\ti+!-\u000e\u0005\u0005=&bAA>{&!\u00111WAX\u0005-\u0001&/\u001b8u/JLG/\u001a:\u0002\u0015]\u0014\u0018\u000e^3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u0006e\u0006\"CAQ9\u0005\u0005\t\u0019AAU\u0003\u001d9(/\u001b;fe\u0002\nA\u0002\\8hO\u0016$WI^3oiN,\"!!1\u0011\r\u0005\r\u0017QZAi\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017d\u0017AC2pY2,7\r^5p]&!\u0011qZAc\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\t\u0005M\u0017Q\u001d\b\u0005\u0003+\fyN\u0004\u0003\u0002X\u0006mgbA5\u0002Z&\t\u0001,C\u0002\u0002^^\u000baA[:p]R\u001a\u0018\u0002BAq\u0003G\fqAS:p]\u0006\u001bFKC\u0002\u0002^^KA!a:\u0002j\n1!JV1mk\u0016TA!!9\u0002d\u0006iAn\\4hK\u0012,e/\u001a8ug\u0002\nq\u0001\\8h!\u0006$\b.F\u0001g\u0003!awn\u001a)bi\"\u0004\u0013!B:uCJ$HCAAM\u0003!awnZ#wK:$HCBAM\u0003w\u0014)\u0001C\u0004\u0002~\u000e\u0002\r!a@\u0002\u000b\u00154XM\u001c;\u0011\u0007m\u0013\t!C\u0002\u0003\u0004E\u0013!c\u00159be.d\u0015n\u001d;f]\u0016\u0014XI^3oi\"I!qA\u0012\u0011\u0002\u0003\u0007\u0011QH\u0001\fM2,8\u000f\u001b'pO\u001e,'/\u0001\nm_\u001e,e/\u001a8uI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0007U\u0011\tiDa\u0004,\u0005\tE\u0001\u0003\u0002B\n\u0005;i!A!\u0006\u000b\t\t]!\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0007m\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005?\u0011)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001c\u001c8Ti\u0006<WmU;c[&$H/\u001a3\u0015\t\u0005e%Q\u0005\u0005\b\u0003{,\u0003\u0019\u0001B\u0014!\rY&\u0011F\u0005\u0004\u0005W\t&aG*qCJ\\G*[:uK:,'o\u0015;bO\u0016\u001cVOY7jiR,G-A\u0006p]R\u000b7o[*uCJ$H\u0003BAM\u0005cAq!!@'\u0001\u0004\u0011\u0019\u0004E\u0002\\\u0005kI1Aa\u000eR\u0005Y\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feR\u000b7o[*uCJ$\u0018aE8o)\u0006\u001c8nR3ui&twMU3tk2$H\u0003BAM\u0005{Aq!!@(\u0001\u0004\u0011y\u0004E\u0002\\\u0005\u0003J1Aa\u0011R\u0005y\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feR\u000b7o[$fiRLgn\u001a*fgVdG/A\u0005p]R\u000b7o[#oIR!\u0011\u0011\u0014B%\u0011\u001d\ti\u0010\u000ba\u0001\u0005\u0017\u00022a\u0017B'\u0013\r\u0011y%\u0015\u0002\u0015'B\f'o\u001b'jgR,g.\u001a:UCN\\WI\u001c3\u0002'=tWI\u001c<je>tW.\u001a8u+B$\u0017\r^3\u0015\t\u0005e%Q\u000b\u0005\b\u0003{L\u0003\u0019\u0001B,!\rY&\u0011L\u0005\u0004\u00057\n&AH*qCJ\\G*[:uK:,'/\u00128wSJ|g.\\3oiV\u0003H-\u0019;f\u0003Aygn\u0015;bO\u0016\u001cu.\u001c9mKR,G\r\u0006\u0003\u0002\u001a\n\u0005\u0004bBA\u007fU\u0001\u0007!1\r\t\u00047\n\u0015\u0014b\u0001B4#\nY2\u000b]1sW2K7\u000f^3oKJ\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012\f!b\u001c8K_\n\u001cF/\u0019:u)\u0011\tIJ!\u001c\t\u000f\u0005u8\u00061\u0001\u0003pA\u00191L!\u001d\n\u0007\tM\u0014KA\u000bTa\u0006\u00148\u000eT5ti\u0016tWM\u001d&pEN#\u0018M\u001d;\u0002\u0011=t'j\u001c2F]\u0012$B!!'\u0003z!9\u0011Q \u0017A\u0002\tm\u0004cA.\u0003~%\u0019!qP)\u0003'M\u0003\u0018M]6MSN$XM\\3s\u0015>\u0014WI\u001c3\u0002'=t'\t\\8dW6\u000bg.Y4fe\u0006#G-\u001a3\u0015\t\u0005e%Q\u0011\u0005\b\u0003{l\u0003\u0019\u0001BD!\rY&\u0011R\u0005\u0004\u0005\u0017\u000b&AH*qCJ\\G*[:uK:,'O\u00117pG.l\u0015M\\1hKJ\fE\rZ3e\u0003UygN\u00117pG.l\u0015M\\1hKJ\u0014V-\\8wK\u0012$B!!'\u0003\u0012\"9\u0011Q \u0018A\u0002\tM\u0005cA.\u0003\u0016&\u0019!qS)\u0003AM\u0003\u0018M]6MSN$XM\\3s\u00052|7m['b]\u0006<WM\u001d*f[>4X\rZ\u0001\u000f_:,f\u000e]3sg&\u001cHO\u0015#E)\u0011\tIJ!(\t\u000f\u0005ux\u00061\u0001\u0003 B\u00191L!)\n\u0007\t\r\u0016KA\rTa\u0006\u00148\u000eT5ti\u0016tWM]+oa\u0016\u00148/[:u%\u0012#\u0015AE8o\u0003B\u0004H.[2bi&|gn\u0015;beR$B!!'\u0003*\"9\u0011Q \u0019A\u0002\t-\u0006cA.\u0003.&\u0019!qV)\u0003;M\u0003\u0018M]6MSN$XM\\3s\u0003B\u0004H.[2bi&|gn\u0015;beR\f\u0001c\u001c8BaBd\u0017nY1uS>tWI\u001c3\u0015\t\u0005e%Q\u0017\u0005\b\u0003{\f\u0004\u0019\u0001B\\!\rY&\u0011X\u0005\u0004\u0005w\u000b&aG*qCJ\\G*[:uK:,'/\u00119qY&\u001c\u0017\r^5p]\u0016sG-A\bp]\u0016CXmY;u_J\fE\rZ3e)\u0011\tIJ!1\t\u000f\u0005u(\u00071\u0001\u0003DB\u00191L!2\n\u0007\t\u001d\u0017K\u0001\u000eTa\u0006\u00148\u000eT5ti\u0016tWM]#yK\u000e,Ho\u001c:BI\u0012,G-A\tp]\u0016CXmY;u_J\u0014V-\\8wK\u0012$B!!'\u0003N\"9\u0011Q`\u001aA\u0002\t=\u0007cA.\u0003R&\u0019!1[)\u00039M\u0003\u0018M]6MSN$XM\\3s\u000bb,7-\u001e;peJ+Wn\u001c<fI\u0006)rN\\#yK\u000e,Ho\u001c:CY\u0006\u001c7\u000e\\5ti\u0016$G\u0003BAM\u00053Dq!!@5\u0001\u0004\u0011Y\u000eE\u0002\\\u0005;L1Aa8R\u0005\u0001\u001a\u0006/\u0019:l\u0019&\u001cH/\u001a8fe\u0016CXmY;u_J\u0014E.Y2lY&\u001cH/\u001a3\u0002;=tW\t_3dkR|'O\u00117bG.d\u0017n\u001d;fI\u001a{'o\u0015;bO\u0016$B!!'\u0003f\"9\u0011Q`\u001bA\u0002\t\u001d\bcA.\u0003j&\u0019!1^)\u0003QM\u0003\u0018M]6MSN$XM\\3s\u000bb,7-\u001e;pe\nc\u0017mY6mSN$X\r\u001a$peN#\u0018mZ3\u00023=tgj\u001c3f\u00052\f7m\u001b7jgR,GMR8s'R\fw-\u001a\u000b\u0005\u00033\u0013\t\u0010C\u0004\u0002~Z\u0002\rAa=\u0011\u0007m\u0013)0C\u0002\u0003xF\u0013Ae\u00159be.d\u0015n\u001d;f]\u0016\u0014hj\u001c3f\u00052\f7m\u001b7jgR,GMR8s'R\fw-Z\u0001\u0018_:,\u00050Z2vi>\u0014XK\u001c2mC\u000e\\G.[:uK\u0012$B!!'\u0003~\"9\u0011Q`\u001cA\u0002\t}\bcA.\u0004\u0002%\u001911A)\u0003EM\u0003\u0018M]6MSN$XM\\3s\u000bb,7-\u001e;peVs'\r\\1dW2L7\u000f^3e\u0003EygNT8eK\nc\u0017mY6mSN$X\r\u001a\u000b\u0005\u00033\u001bI\u0001C\u0004\u0002~b\u0002\raa\u0003\u0011\u0007m\u001bi!C\u0002\u0004\u0010E\u0013Ad\u00159be.d\u0015n\u001d;f]\u0016\u0014hj\u001c3f\u00052\f7m\u001b7jgR,G-A\np]:{G-Z+oE2\f7m\u001b7jgR,G\r\u0006\u0003\u0002\u001a\u000eU\u0001bBA\u007fs\u0001\u00071q\u0003\t\u00047\u000ee\u0011bAB\u000e#\nq2\u000b]1sW2K7\u000f^3oKJtu\u000eZ3V]\nd\u0017mY6mSN$X\rZ\u0001\u000f_:\u0014En\\2l+B$\u0017\r^3e)\u0011\tIj!\t\t\u000f\u0005u(\b1\u0001\u0004$A\u00191l!\n\n\u0007\r\u001d\u0012KA\rTa\u0006\u00148\u000eT5ti\u0016tWM\u001d\"m_\u000e\\W\u000b\u001d3bi\u0016$\u0017aF8o\u000bb,7-\u001e;pe6+GO]5dgV\u0003H-\u0019;f)\u0011\tIj!\f\t\u000f\u0005u8\b1\u0001\u00040A\u00191l!\r\n\u0007\rM\u0012K\u0001\u0012Ta\u0006\u00148\u000eT5ti\u0016tWM]#yK\u000e,Ho\u001c:NKR\u0014\u0018nY:Va\u0012\fG/Z\u0001\r_:|E\u000f[3s\u000bZ,g\u000e\u001e\u000b\u0005\u00033\u001bI\u0004C\u0004\u0002~r\u0002\r!a@\u0002\tM$x\u000e]\u0001\fe\u0016$\u0017m\u0019;Fm\u0016tG\u000f\u0006\u0003\u0003X\r\u0005\u0003bBA\u007f}\u0001\u0007!qK\u0001\u0015\u000bZ,g\u000e\u001e'pO\u001eLgn\u001a'jgR,g.\u001a:\u0011\u0005m\u00035\u0003\u0002!\u0004Jy\u00032!^B&\u0013\r\u0019i\u0005\u001c\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\r\u0015\u0013aC%O?B\u0013vj\u0012*F'N+\"a!\u0016\u0011\t\r]3QL\u0007\u0003\u00073R1aa\u0017~\u0003\u0011a\u0017M\\4\n\u0007E\u001cI&\u0001\u0007J\u001d~\u0003&kT$S\u000bN\u001b\u0006%A\bE\u000b\u001a\u000bU\u000b\u0014+`\u0019>;u\fR%S\u0003A!UIR!V\u0019R{FjT$`\t&\u0013\u0006%\u0001\u000bM\u001f\u001e{f)\u0013'F?B+%+T%T'&{ejU\u000b\u0003\u0007S\u0002Baa\u001b\u0004r5\u00111Q\u000e\u0006\u0005\u0007_\n)'\u0001\u0006qKJl\u0017n]:j_:LAaa\u001d\u0004n\taai\u001d)fe6L7o]5p]\u0006)BjT$`\r&cUi\u0018)F%6K5kU%P\u001dN\u0003\u0013\u0001C2pI\u0016\u001cW*\u00199\u0016\u0005\rm\u0004cBAb\u0007{2\u0017QO\u0005\u0005\u0007\u007f\n)MA\u0004ICNDW*\u00199\u0002\u0013\r|G-Z2NCB\u0004\u0013\u0001D5oSR,e/\u001a8u\u0019><G\u0003CAM\u0007\u000f\u001b\tja%\t\u000f\r%%\n1\u0001\u0004\f\u0006IAn\\4TiJ,\u0017-\u001c\t\u0005\u0003[\u001bi)\u0003\u0003\u0004\u0010\u0006=&\u0001D(viB,Ho\u0015;sK\u0006l\u0007bBA'\u0015\u0002\u0007\u0011Q\b\u0005\b\u0003{S\u0005\u0019AAa\u0003)9W\r\u001e'pOB\u000bG\u000f\u001b\u000b\nM\u000ee51TBO\u0007?CQ\u0001_&A\u0002eDQ\u0001Z&A\u0002\u0019DQa]&A\u0002QD\u0001\"a!L!\u0003\u0005\r\u0001^\u0001\u0015O\u0016$Hj\\4QCRDG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u0015&f\u0001;\u0003\u0010\u0005A1/\u00198ji&TX\rF\u0002g\u0007WCaa!,N\u0001\u00041\u0017aA:ue\u0006aq\u000e]3o\u000bZ,g\u000e\u001e'pOR111WB]\u0007\u0007\u0004B!!,\u00046&!1qWAX\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\rmf\n1\u0001\u0004>\u0006\u0019An\\4\u0011\t\u0005\r4qX\u0005\u0005\u0007\u0003\f)G\u0001\u0003QCRD\u0007bBA4\u001d\u0002\u0007\u0011\u0011M\u0001\nG>$Wm\u0019(b[\u0016$2\u0001^Be\u0011\u001d\u0019Yl\u0014a\u0001\u0007{\u0003")
public class EventLoggingListener
extends SparkListener
implements Logging {
    private final URI logBaseDir;
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final boolean shouldCompress;
    private final boolean shouldOverwrite;
    private final boolean shouldLogBlockUpdates;
    private final boolean testing;
    private final int outputBufferSize;
    private final FileSystem fileSystem;
    private final Option<CompressionCodec> compressionCodec;
    private final Option<String> compressionCodecName;
    private Option<FSDataOutputStream> hadoopDataStream;
    private Option<PrintWriter> writer;
    private final ArrayBuffer<JsonAST.JValue> loggedEvents;
    private final String logPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<String> codecName(Path path) {
        return EventLoggingListener$.MODULE$.codecName(path);
    }

    public static InputStream openEventLog(Path path, FileSystem fileSystem) {
        return EventLoggingListener$.MODULE$.openEventLog(path, fileSystem);
    }

    public static Option<String> getLogPath$default$4() {
        return EventLoggingListener$.MODULE$.getLogPath$default$4();
    }

    public static String getLogPath(URI uRI, String string, Option<String> option, Option<String> option2) {
        return EventLoggingListener$.MODULE$.getLogPath(uRI, string, option, option2);
    }

    public static void initEventLog(OutputStream outputStream, boolean bl, ArrayBuffer<JsonAST.JValue> arrayBuffer) {
        EventLoggingListener$.MODULE$.initEventLog(outputStream, bl, arrayBuffer);
    }

    public static String DEFAULT_LOG_DIR() {
        return EventLoggingListener$.MODULE$.DEFAULT_LOG_DIR();
    }

    public static String IN_PROGRESS() {
        return EventLoggingListener$.MODULE$.IN_PROGRESS();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean shouldCompress() {
        return this.shouldCompress;
    }

    private boolean shouldOverwrite() {
        return this.shouldOverwrite;
    }

    private boolean shouldLogBlockUpdates() {
        return this.shouldLogBlockUpdates;
    }

    private boolean testing() {
        return this.testing;
    }

    private int outputBufferSize() {
        return this.outputBufferSize;
    }

    private FileSystem fileSystem() {
        return this.fileSystem;
    }

    private Option<CompressionCodec> compressionCodec() {
        return this.compressionCodec;
    }

    private Option<String> compressionCodecName() {
        return this.compressionCodecName;
    }

    private Option<FSDataOutputStream> hadoopDataStream() {
        return this.hadoopDataStream;
    }

    private void hadoopDataStream_$eq(Option<FSDataOutputStream> x$1) {
        this.hadoopDataStream = x$1;
    }

    private Option<PrintWriter> writer() {
        return this.writer;
    }

    private void writer_$eq(Option<PrintWriter> x$1) {
        this.writer = x$1;
    }

    public ArrayBuffer<JsonAST.JValue> loggedEvents() {
        return this.loggedEvents;
    }

    public String logPath() {
        return this.logPath;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void start() {
        if (!this.fileSystem().getFileStatus(new Path(this.logBaseDir)).isDirectory()) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Log directory ").append(this.logBaseDir).append(" is not a directory.").toString());
        }
        workingPath = new StringBuilder(0).append(this.logPath()).append(EventLoggingListener$.MODULE$.IN_PROGRESS()).toString();
        path = new Path(workingPath);
        uri = path.toUri();
        defaultFs = FileSystem.getDefaultUri((Configuration)this.hadoopConf).getScheme();
        if (defaultFs == null) ** GOTO lbl-1000
        v0 = defaultFs;
        var6_5 = "file";
        if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = isDefaultLocal = false;
        }
        if (this.shouldOverwrite() && this.fileSystem().delete(path, true)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$start$1(org.apache.hadoop.fs.Path ), ()Ljava/lang/String;)((Path)path));
        }
        if (isDefaultLocal && uri.getScheme() == null) ** GOTO lbl-1000
        v2 = uri.getScheme();
        var8_7 = "file";
        if (!(v2 != null ? v2.equals(var8_7) == false : var8_7 != null)) lbl-1000:
        // 2 sources

        {
            v3 /* !! */  = new FileOutputStream(uri.getPath());
        } else {
            this.hadoopDataStream_$eq((Option<FSDataOutputStream>)new Some((Object)this.fileSystem().create(path)));
            v3 /* !! */  = (OutputStream)this.hadoopDataStream().get();
        }
        dstream = v3 /* !! */ ;
        try {
            cstream = (OutputStream)this.compressionCodec().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$start$2(java.io.OutputStream org.apache.spark.io.CompressionCodec ), (Lorg/apache/spark/io/CompressionCodec;)Ljava/io/OutputStream;)((OutputStream)dstream)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$start$3(java.io.OutputStream ), ()Ljava/io/OutputStream;)((OutputStream)dstream));
            bstream = new BufferedOutputStream(cstream, this.outputBufferSize());
            EventLoggingListener$.MODULE$.initEventLog(bstream, this.testing(), this.loggedEvents());
            this.fileSystem().setPermission(path, EventLoggingListener$.MODULE$.org$apache$spark$scheduler$EventLoggingListener$$LOG_FILE_PERMISSIONS());
            this.writer_$eq((Option<PrintWriter>)new Some((Object)new PrintWriter(bstream)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$start$4(org.apache.spark.scheduler.EventLoggingListener ), ()Ljava/lang/String;)((EventLoggingListener)this));
        }
        catch (Exception e) {
            dstream.close();
            throw e;
        }
    }

    private void logEvent(SparkListenerEvent event, boolean flushLogger) {
        block1: {
            JsonAST.JValue eventJson = JsonProtocol$.MODULE$.sparkEventToJson(event);
            this.writer().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                EventLoggingListener.$anonfun$logEvent$1(eventJson, x$2);
                return BoxedUnit.UNIT;
            });
            if (flushLogger) {
                this.writer().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.flush();
                    return BoxedUnit.UNIT;
                });
                this.hadoopDataStream().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.hflush();
                    return BoxedUnit.UNIT;
                });
            }
            if (!this.testing()) break block1;
            this.loggedEvents().$plus$eq((Object)eventJson);
        }
    }

    private boolean logEvent$default$2() {
        return false;
    }

    @Override
    public void onStageSubmitted(SparkListenerStageSubmitted event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onTaskStart(SparkListenerTaskStart event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onTaskGettingResult(SparkListenerTaskGettingResult event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onTaskEnd(SparkListenerTaskEnd event) {
        this.logEvent(event, this.logEvent$default$2());
    }

    @Override
    public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate event) {
        this.logEvent(this.redactEvent(event), this.logEvent$default$2());
    }

    @Override
    public void onStageCompleted(SparkListenerStageCompleted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onJobStart(SparkListenerJobStart event) {
        this.logEvent(event, true);
    }

    @Override
    public void onJobEnd(SparkListenerJobEnd event) {
        this.logEvent(event, true);
    }

    @Override
    public void onBlockManagerAdded(SparkListenerBlockManagerAdded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved event) {
        this.logEvent(event, true);
    }

    @Override
    public void onUnpersistRDD(SparkListenerUnpersistRDD event) {
        this.logEvent(event, true);
    }

    @Override
    public void onApplicationStart(SparkListenerApplicationStart event) {
        this.logEvent(event, true);
    }

    @Override
    public void onApplicationEnd(SparkListenerApplicationEnd event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorAdded(SparkListenerExecutorAdded event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorRemoved(SparkListenerExecutorRemoved event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorBlacklisted(SparkListenerExecutorBlacklisted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorBlacklistedForStage(SparkListenerExecutorBlacklistedForStage event) {
        this.logEvent(event, true);
    }

    @Override
    public void onNodeBlacklistedForStage(SparkListenerNodeBlacklistedForStage event) {
        this.logEvent(event, true);
    }

    @Override
    public void onExecutorUnblacklisted(SparkListenerExecutorUnblacklisted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onNodeBlacklisted(SparkListenerNodeBlacklisted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onNodeUnblacklisted(SparkListenerNodeUnblacklisted event) {
        this.logEvent(event, true);
    }

    @Override
    public void onBlockUpdated(SparkListenerBlockUpdated event) {
        block0: {
            if (!this.shouldLogBlockUpdates()) break block0;
            this.logEvent(event, true);
        }
    }

    @Override
    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate event) {
    }

    @Override
    public void onOtherEvent(SparkListenerEvent event) {
        block0: {
            if (!event.logEvent()) break block0;
            this.logEvent(event, true);
        }
    }

    public void stop() {
        this.writer().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        Path target = new Path(this.logPath());
        if (this.fileSystem().exists(target)) {
            if (this.shouldOverwrite()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Event log ").append(target).append(" already exists. Overwriting...").toString());
                if (!this.fileSystem().delete(target, true)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error deleting ").append(target).toString());
                }
            } else {
                throw new IOException(new StringOps(Predef$.MODULE$.augmentString("Target log file already exists (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPath()})));
            }
        }
        this.fileSystem().rename(new Path(new StringBuilder(0).append(this.logPath()).append(EventLoggingListener$.MODULE$.IN_PROGRESS()).toString()), target);
        try {
            this.fileSystem().setTimes(target, System.currentTimeMillis(), -1L);
        }
        catch (Exception e) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("failed to set time of ").append(target).toString(), e);
        }
    }

    public SparkListenerEnvironmentUpdate redactEvent(SparkListenerEnvironmentUpdate event) {
        Map redactedProps = (Map)event.environmentDetails().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Seq props = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), Utils$.MODULE$.redact($this.sparkConf, (Seq<Tuple2<String, String>>)props));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new SparkListenerEnvironmentUpdate((Map<String, Seq<Tuple2<String, String>>>)redactedProps);
    }

    public static final /* synthetic */ String $anonfun$start$1(Path path$1) {
        return new StringBuilder(41).append("Event log ").append(path$1).append(" already exists. Overwriting...").toString();
    }

    public static final /* synthetic */ OutputStream $anonfun$start$2(OutputStream dstream$1, CompressionCodec x$1) {
        return x$1.compressedOutputStream(dstream$1);
    }

    public static final /* synthetic */ OutputStream $anonfun$start$3(OutputStream dstream$1) {
        return dstream$1;
    }

    public static final /* synthetic */ String $anonfun$start$4(EventLoggingListener $this) {
        return new StringOps(Predef$.MODULE$.augmentString("Logging events to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.logPath()}));
    }

    public static final /* synthetic */ void $anonfun$logEvent$1(JsonAST.JValue eventJson$1, PrintWriter x$2) {
        JsonAST.JValue x$1 = eventJson$1;
        Formats x$22 = JsonMethods$.MODULE$.render$default$2(x$1);
        x$2.println(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$22)));
    }

    public EventLoggingListener(String appId, Option<String> appAttemptId, URI logBaseDir, SparkConf sparkConf, Configuration hadoopConf) {
        this.logBaseDir = logBaseDir;
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        Logging.$init$(this);
        this.shouldCompress = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.EVENT_LOG_COMPRESS()));
        this.shouldOverwrite = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.EVENT_LOG_OVERWRITE()));
        this.shouldLogBlockUpdates = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.EVENT_LOG_BLOCK_UPDATES()));
        this.testing = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.EVENT_LOG_TESTING()));
        this.outputBufferSize = (int)BoxesRunTime.unboxToLong((Object)sparkConf.get(package$.MODULE$.EVENT_LOG_OUTPUT_BUFFER_SIZE()));
        this.fileSystem = Utils$.MODULE$.getHadoopFileSystem(logBaseDir, hadoopConf);
        this.compressionCodec = this.shouldCompress() ? new Some((Object)CompressionCodec$.MODULE$.createCodec(sparkConf)) : None$.MODULE$;
        this.compressionCodecName = this.compressionCodec().map((Function1 & Serializable & scala.Serializable)c -> CompressionCodec$.MODULE$.getShortName(c.getClass().getName()));
        this.hadoopDataStream = None$.MODULE$;
        this.writer = None$.MODULE$;
        this.loggedEvents = new ArrayBuffer();
        this.logPath = EventLoggingListener$.MODULE$.getLogPath(logBaseDir, appId, appAttemptId, this.compressionCodecName());
    }

    public EventLoggingListener(String appId, Option<String> appAttemptId, URI logBaseDir, SparkConf sparkConf) {
        this(appId, appAttemptId, logBaseDir, sparkConf, SparkHadoopUtil$.MODULE$.get().newConfiguration(sparkConf));
    }
}

