/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.package$;
import org.apache.spark.scheduler.SparkListenerLogStart;
import org.apache.spark.util.JsonProtocol$;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;

public final class EventLoggingListener$
implements Logging {
    public static EventLoggingListener$ MODULE$;
    private final String IN_PROGRESS;
    private final String DEFAULT_LOG_DIR;
    private final FsPermission org$apache$spark$scheduler$EventLoggingListener$$LOG_FILE_PERMISSIONS;
    private final HashMap<String, CompressionCodec> codecMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new EventLoggingListener$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String IN_PROGRESS() {
        return this.IN_PROGRESS;
    }

    public String DEFAULT_LOG_DIR() {
        return this.DEFAULT_LOG_DIR;
    }

    public FsPermission org$apache$spark$scheduler$EventLoggingListener$$LOG_FILE_PERMISSIONS() {
        return this.org$apache$spark$scheduler$EventLoggingListener$$LOG_FILE_PERMISSIONS;
    }

    private HashMap<String, CompressionCodec> codecMap() {
        return this.codecMap;
    }

    public void initEventLog(OutputStream logStream, boolean testing, ArrayBuffer<JsonAST.JValue> loggedEvents) {
        block0: {
            SparkListenerLogStart metadata = new SparkListenerLogStart(package$.MODULE$.SPARK_VERSION());
            JsonAST.JValue eventJson = JsonProtocol$.MODULE$.logStartToJson(metadata);
            String metadataJson = new StringBuilder(1).append(JsonMethods$.MODULE$.compact(eventJson)).append("\n").toString();
            logStream.write(metadataJson.getBytes(StandardCharsets.UTF_8));
            if (!testing || loggedEvents == null) break block0;
            loggedEvents.$plus$eq((Object)eventJson);
        }
    }

    public String getLogPath(URI logBaseDir, String appId, Option<String> appAttemptId, Option<String> compressionCodecName) {
        String base = new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(new Path(logBaseDir).toString())).stripSuffix("/")).append("/").append(this.sanitize(appId)).toString();
        String codec = (String)compressionCodecName.map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(1).append(".").append((String)x$6).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return appAttemptId.isDefined() ? new StringBuilder(1).append(base).append("_").append(this.sanitize((String)appAttemptId.get())).append(codec).toString() : new StringBuilder(0).append(base).append(codec).toString();
    }

    public Option<String> getLogPath$default$4() {
        return None$.MODULE$;
    }

    private String sanitize(String str) {
        return str.replaceAll("[ :/]", "-").replaceAll("[.${}'\"]", "_").toLowerCase(Locale.ROOT);
    }

    public InputStream openEventLog(Path log, FileSystem fs) {
        InputStream inputStream;
        BufferedInputStream in = new BufferedInputStream((InputStream)fs.open(log));
        try {
            Option codec = this.codecName(log).map((Function1 & Serializable & scala.Serializable)c -> (CompressionCodec)MODULE$.codecMap().getOrElseUpdate(c, (Function0 & Serializable & scala.Serializable)() -> CompressionCodec$.MODULE$.createCodec(new SparkConf(), (String)c)));
            inputStream = (InputStream)codec.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.compressedInputStream(in)).getOrElse((Function0 & Serializable & scala.Serializable)() -> in);
        }
        catch (Throwable e) {
            in.close();
            throw e;
        }
        return inputStream;
    }

    public Option<String> codecName(Path log) {
        String logName = new StringOps(Predef$.MODULE$.augmentString(log.getName())).stripSuffix(this.IN_PROGRESS());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logName.split("\\."))).tail())).lastOption();
    }

    private EventLoggingListener$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.IN_PROGRESS = ".inprogress";
        this.DEFAULT_LOG_DIR = "/tmp/spark-events";
        this.org$apache$spark$scheduler$EventLoggingListener$$LOG_FILE_PERMISSIONS = new FsPermission((short)Integer.parseInt("770", 8));
        this.codecMap = new HashMap();
    }
}

