/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.AsyncEventQueue$;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.LiveListenerBus$;
import org.apache.spark.scheduler.LiveListenerBusMetrics;
import org.apache.spark.scheduler.SparkListenerBus;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.ListenerBus;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u0017.\tYB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t)\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!q\u0006A!A!\u0002\u0013y\u0006\"\u00022\u0001\t\u0003\u0019\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007q\u0002\u0001\u000b\u0011B6\t\u000fe\u0004!\u0019!C\u0005u\"9\u00111\u0001\u0001!\u0002\u0013Y\b\u0002CA\u0003\u0001\t\u0007I\u0011\u0002>\t\u000f\u0005\u001d\u0001\u0001)A\u0005w\"I\u0011\u0011\u0002\u0001A\u0002\u0013%\u00111\u0002\u0005\n\u0003'\u0001\u0001\u0019!C\u0005\u0003+A\u0001\"!\t\u0001A\u0003&\u0011Q\u0002\u0005\n\u0003W\u0001!\u0019!C\u0005\u0003[A\u0001\"!\u000e\u0001A\u0003%\u0011q\u0006\u0005\n\u0003o\u0001\u0001\u0019!C\u0005\u0003sA\u0011\"!\u0011\u0001\u0001\u0004%I!a\u0011\t\u0011\u0005\u001d\u0003\u0001)Q\u0005\u0003wA\u0011\"!\u0013\u0001\u0005\u0004%I!!\f\t\u0011\u0005-\u0003\u0001)A\u0005\u0003_A\u0011\"!\u0014\u0001\u0005\u0004%I!!\f\t\u0011\u0005=\u0003\u0001)A\u0005\u0003_A\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0015\t\u0011\u0005\u001d\u0004\u0001)A\u0005\u0003+B\u0011\"!\u001b\u0001\u0005\u0004%I!a\u001b\t\u0011\u0005M\u0004\u0001)A\u0005\u0003[B\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003sBq!a\"\u0001\t\u0013\tI\tC\u0004\u0002\f\u0002!\t&!$\t\u0011\u0005}\u0005\u0001\"\u0001.\u0003CC\u0001\"!*\u0001\t\u0003i\u0013\u0011\u0012\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!!0\u0001\t\u0003\ny\f\u0003\b\u0002D\u0002\u0001\n1!A\u0001\n\u0013\t)-!3\b\u000f\u0005MW\u0006#\u0003\u0002V\u001a1A&\fE\u0005\u0003/DaA\u0019\u0015\u0005\u0002\u0005e\u0007\"CAnQ\t\u0007I\u0011AAo\u0011!\t)\u000f\u000bQ\u0001\n\u0005}'aD!ts:\u001cWI^3oiF+X-^3\u000b\u00059z\u0013!C:dQ\u0016$W\u000f\\3s\u0015\t\u0001\u0014'A\u0003ta\u0006\u00148N\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0005\u0001]j\u0014\t\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014H\u0001\u0004B]f\u0014VM\u001a\t\u0003}}j\u0011!L\u0005\u0003\u00016\u0012\u0001c\u00159be.d\u0015n\u001d;f]\u0016\u0014()^:\u0011\u0005\t+U\"A\"\u000b\u0005\u0011{\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0019\u001b%a\u0002'pO\u001eLgnZ\u0001\u0005]\u0006lW-F\u0001J!\tQ\u0015K\u0004\u0002L\u001fB\u0011A*O\u0007\u0002\u001b*\u0011a*N\u0001\u0007yI|w\u000e\u001e \n\u0005AK\u0014A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001U\u001d\u0002\u000b9\fW.\u001a\u0011\u0002\t\r|gN\u001a\t\u0003/bk\u0011aL\u0005\u00033>\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u000f5,GO]5dgB\u0011a\bX\u0005\u0003;6\u0012a\u0003T5wK2K7\u000f^3oKJ\u0014Uo]'fiJL7m]\u0001\u0004EV\u001c\bC\u0001 a\u0013\t\tWFA\bMSZ,G*[:uK:,'OQ;t\u0003\u0019a\u0014N\\5u}Q)A-\u001a4hQB\u0011a\b\u0001\u0005\u0006\u000f\u001a\u0001\r!\u0013\u0005\u0006+\u001a\u0001\rA\u0016\u0005\u00065\u001a\u0001\ra\u0017\u0005\u0006=\u001a\u0001\raX\u0001\u000bKZ,g\u000e^)vKV,W#A6\u0011\u00071\u001cX/D\u0001n\u0015\tqw.\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001]9\u0002\tU$\u0018\u000e\u001c\u0006\u0002e\u0006!!.\u0019<b\u0013\t!XNA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\r\u0005\u0002?m&\u0011q/\f\u0002\u0013'B\f'o\u001b'jgR,g.\u001a:Fm\u0016tG/A\u0006fm\u0016tG/U;fk\u0016\u0004\u0013AC3wK:$8i\\;oiV\t1\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f[\u00061\u0011\r^8nS\u000eL1!!\u0001~\u0005)\tEo\\7jG2{gnZ\u0001\fKZ,g\u000e^\"pk:$\b%\u0001\u000bee>\u0004\b/\u001a3Fm\u0016tGo]\"pk:$XM]\u0001\u0016IJ|\u0007\u000f]3e\u000bZ,g\u000e^:D_VtG/\u001a:!\u0003Ma\u0017m\u001d;SKB|'\u000f\u001e+j[\u0016\u001cH/Y7q+\t\ti\u0001E\u00029\u0003\u001fI1!!\u0005:\u0005\u0011auN\\4\u0002/1\f7\u000f\u001e*fa>\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA\f\u0003;\u00012\u0001OA\r\u0013\r\tY\"\u000f\u0002\u0005+:LG\u000fC\u0005\u0002 9\t\t\u00111\u0001\u0002\u000e\u0005\u0019\u0001\u0010J\u0019\u0002)1\f7\u000f\u001e*fa>\u0014H\u000fV5nKN$\u0018-\u001c9!Q\ry\u0011Q\u0005\t\u0004q\u0005\u001d\u0012bAA\u0015s\tAao\u001c7bi&dW-A\bm_\u001e$%o\u001c9qK\u0012,e/\u001a8u+\t\ty\u0003E\u0002}\u0003cI1!a\r~\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006\u0001Bn\\4Ee>\u0004\b/\u001a3Fm\u0016tG\u000fI\u0001\u0003g\u000e,\"!a\u000f\u0011\u0007]\u000bi$C\u0002\u0002@=\u0012Ab\u00159be.\u001cuN\u001c;fqR\faa]2`I\u0015\fH\u0003BA\f\u0003\u000bB\u0011\"a\b\u0014\u0003\u0003\u0005\r!a\u000f\u0002\u0007M\u001c\u0007%A\u0004ti\u0006\u0014H/\u001a3\u0002\u0011M$\u0018M\u001d;fI\u0002\nqa\u001d;paB,G-\u0001\u0005ti>\u0004\b/\u001a3!\u00035!'o\u001c9qK\u0012,e/\u001a8ugV\u0011\u0011Q\u000b\t\u0005\u0003/\n\u0019'\u0004\u0002\u0002Z)\u0019!,a\u0017\u000b\t\u0005u\u0013qL\u0001\tG>$\u0017\r[1mK*\u0011\u0011\u0011M\u0001\u0004G>l\u0017\u0002BA3\u00033\u0012qaQ8v]R,'/\u0001\bee>\u0004\b/\u001a3Fm\u0016tGo\u001d\u0011\u0002\u001dA\u0014xnY3tg&tw\rV5nKV\u0011\u0011Q\u000e\t\u0005\u0003/\ny'\u0003\u0003\u0002r\u0005e#!\u0002+j[\u0016\u0014\u0018a\u00049s_\u000e,7o]5oORKW.\u001a\u0011\u0002\u001d\u0011L7\u000f]1uG\"$\u0006N]3bIV\u0011\u0011\u0011\u0010\t\u0005\u0003w\n\t)\u0004\u0002\u0002~)\u0019\u0011qP9\u0002\t1\fgnZ\u0005\u0005\u0003\u0007\u000biH\u0001\u0004UQJ,\u0017\rZ\u0001\u0010I&\u001c\b/\u0019;dQRC'/Z1eA\u0005AA-[:qCR\u001c\u0007\u000e\u0006\u0002\u0002\u0018\u0005Aq-\u001a;US6,'\u000f\u0006\u0003\u0002\u0010\u0006U\u0005#\u0002\u001d\u0002\u0012\u00065\u0014bAAJs\t1q\n\u001d;j_:Dq!a&!\u0001\u0004\tI*\u0001\u0005mSN$XM\\3s!\rq\u00141T\u0005\u0004\u0003;k#AF*qCJ\\G*[:uK:,'/\u00138uKJ4\u0017mY3\u0002\u000bM$\u0018M\u001d;\u0015\t\u0005]\u00111\u0015\u0005\b\u0003o\t\u0003\u0019AA\u001e\u0003\u0011\u0019Ho\u001c9\u0002\tA|7\u000f\u001e\u000b\u0005\u0003/\tY\u000b\u0003\u0004\u0002.\u000e\u0002\r!^\u0001\u0006KZ,g\u000e^\u0001\u000fo\u0006LG/\u00168uS2,U\u000e\u001d;z)\u0011\t\u0019,!/\u0011\u0007a\n),C\u0002\u00028f\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002<\u0012\u0002\r!!\u0004\u0002\u0011\u0011,\u0017\r\u001a7j]\u0016\fQC]3n_Z,G*[:uK:,'o\u00148FeJ|'\u000f\u0006\u0003\u0002\u0018\u0005\u0005\u0007bBALK\u0001\u0007\u0011\u0011T\u0001\u0010gV\u0004XM\u001d\u0013q_N$Hk\\!mYR!\u0011qCAd\u0011\u0019\tiK\na\u0001k&!\u00111ZAg\u0003%\u0001xn\u001d;U_\u0006cG.\u0003\u0003\u0002P\u0006E'a\u0003'jgR,g.\u001a:CkNT!\u0001]\u0018\u0002\u001f\u0005\u001b\u0018P\\2Fm\u0016tG/U;fk\u0016\u0004\"A\u0010\u0015\u0014\u0005!:DCAAk\u0003-\u0001v*S*P\u001d~\u0003\u0016\n\u0014'\u0016\u0005\u0005}'\u0003BAqoU4a!a9,\u0001\u0005}'\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014\u0001\u0004)P\u0013N{ej\u0018)J\u00192\u0003\u0003")
public class AsyncEventQueue
implements SparkListenerBus {
    private final String name;
    private final LiveListenerBusMetrics metrics;
    private final LiveListenerBus bus;
    private final LinkedBlockingQueue<SparkListenerEvent> org$apache$spark$scheduler$AsyncEventQueue$$eventQueue;
    private final AtomicLong eventCount;
    private final AtomicLong droppedEventsCounter;
    private volatile long lastReportTimestamp;
    private final AtomicBoolean logDroppedEvent;
    private SparkContext org$apache$spark$scheduler$AsyncEventQueue$$sc;
    private final AtomicBoolean started;
    private final AtomicBoolean stopped;
    private final Counter droppedEvents;
    private final Timer processingTime;
    private final Thread dispatchThread;
    private final CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static SparkListenerEvent POISON_PILL() {
        return AsyncEventQueue$.MODULE$.POISON_PILL();
    }

    @Override
    public void doPostEvent(SparkListenerInterface listener, SparkListenerEvent event) {
        SparkListenerBus.doPostEvent$(this, listener, event);
    }

    @Override
    public List<SparkListenerInterface> listeners() {
        return ListenerBus.listeners$(this);
    }

    @Override
    public final void addListener(Object listener) {
        ListenerBus.addListener$(this, listener);
    }

    @Override
    public final void removeListener(Object listener) {
        ListenerBus.removeListener$(this, listener);
    }

    @Override
    public void postToAll(Object event) {
        ListenerBus.postToAll$(this, event);
    }

    @Override
    public boolean isIgnorableException(Throwable e) {
        return ListenerBus.isIgnorableException$(this, e);
    }

    @Override
    public <T extends SparkListenerInterface> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ListenerBus.findListenersByClass$(this, evidence$1);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers() {
        return this.org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    }

    @Override
    public final void org$apache$spark$util$ListenerBus$_setter_$org$apache$spark$util$ListenerBus$$listenersPlusTimers_$eq(CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> x$1) {
        this.org$apache$spark$util$ListenerBus$$listenersPlusTimers = x$1;
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private /* synthetic */ void super$postToAll(SparkListenerEvent event) {
        ListenerBus.postToAll$(this, event);
    }

    public String name() {
        return this.name;
    }

    public LinkedBlockingQueue<SparkListenerEvent> org$apache$spark$scheduler$AsyncEventQueue$$eventQueue() {
        return this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue;
    }

    private AtomicLong eventCount() {
        return this.eventCount;
    }

    private AtomicLong droppedEventsCounter() {
        return this.droppedEventsCounter;
    }

    private long lastReportTimestamp() {
        return this.lastReportTimestamp;
    }

    private void lastReportTimestamp_$eq(long x$1) {
        this.lastReportTimestamp = x$1;
    }

    private AtomicBoolean logDroppedEvent() {
        return this.logDroppedEvent;
    }

    public SparkContext org$apache$spark$scheduler$AsyncEventQueue$$sc() {
        return this.org$apache$spark$scheduler$AsyncEventQueue$$sc;
    }

    private void org$apache$spark$scheduler$AsyncEventQueue$$sc_$eq(SparkContext x$1) {
        this.org$apache$spark$scheduler$AsyncEventQueue$$sc = x$1;
    }

    private AtomicBoolean started() {
        return this.started;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private Counter droppedEvents() {
        return this.droppedEvents;
    }

    private Timer processingTime() {
        return this.processingTime;
    }

    private Thread dispatchThread() {
        return this.dispatchThread;
    }

    public void org$apache$spark$scheduler$AsyncEventQueue$$dispatch() {
        LiveListenerBus$.MODULE$.withinListenerThread().withValue((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            SparkListenerEvent next = this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().take();
            while (true) {
                SparkListenerEvent sparkListenerEvent = next;
                SparkListenerEvent sparkListenerEvent2 = AsyncEventQueue$.MODULE$.POISON_PILL();
                if (!(sparkListenerEvent == null ? sparkListenerEvent2 != null : !sparkListenerEvent.equals(sparkListenerEvent2))) break;
                Timer.Context ctx = this.processingTime().time();
                try {
                    this.super$postToAll(next);
                }
                finally {
                    ctx.stop();
                }
                this.eventCount().decrementAndGet();
                next = this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().take();
            }
            return this.eventCount().decrementAndGet();
        });
    }

    @Override
    public Option<Timer> getTimer(SparkListenerInterface listener) {
        return this.metrics.getTimerForListenerClass(listener.getClass().asSubclass(SparkListenerInterface.class));
    }

    public void start(SparkContext sc) {
        if (!this.started().compareAndSet(false, true)) {
            throw new IllegalStateException(new StringBuilder(17).append(this.name()).append(" already started!").toString());
        }
        this.org$apache$spark$scheduler$AsyncEventQueue$$sc_$eq(sc);
        this.dispatchThread().start();
    }

    public void stop() {
        block2: {
            if (!this.started().get()) {
                throw new IllegalStateException(new StringBuilder(44).append("Attempted to stop ").append(this.name()).append(" that has not yet started!").toString());
            }
            if (this.stopped().compareAndSet(false, true)) {
                this.eventCount().incrementAndGet();
                this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().put(AsyncEventQueue$.MODULE$.POISON_PILL());
            }
            Thread thread = Thread.currentThread();
            Thread thread2 = this.dispatchThread();
            if (!(thread == null ? thread2 != null : !thread.equals(thread2))) break block2;
            this.dispatchThread().join();
        }
    }

    public void post(SparkListenerEvent event) {
        block3: {
            if (this.stopped().get()) {
                return;
            }
            this.eventCount().incrementAndGet();
            if (this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().offer(event)) {
                return;
            }
            this.eventCount().decrementAndGet();
            this.droppedEvents().inc();
            this.droppedEventsCounter().incrementAndGet();
            if (this.logDroppedEvent().compareAndSet(false, true)) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(162).append("Dropping event from queue ").append(this.name()).append(". ").append("This likely means one of the listeners is too slow and cannot keep up with ").append("the rate at which tasks are being started by the scheduler.").toString());
            }
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Dropping event ").append(event).toString());
            long droppedCount = this.droppedEventsCounter().get();
            if (droppedCount <= 0L || System.currentTimeMillis() - this.lastReportTimestamp() < 60000L || !this.droppedEventsCounter().compareAndSet(droppedCount, 0L)) break block3;
            long prevLastReportTimestamp = this.lastReportTimestamp();
            this.lastReportTimestamp_$eq(System.currentTimeMillis());
            Date previous = new Date(prevLastReportTimestamp);
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Dropped ").append(droppedCount).append(" events from ").append(this.name()).append(" since ").append(previous).append(".").toString());
        }
    }

    public boolean waitUntilEmpty(long deadline) {
        while (this.eventCount().get() != 0L) {
            if (System.currentTimeMillis() > deadline) {
                return false;
            }
            Thread.sleep(10L);
        }
        return true;
    }

    @Override
    public void removeListenerOnError(SparkListenerInterface listener) {
        this.bus.removeListener(listener);
    }

    public AsyncEventQueue(String name, SparkConf conf, LiveListenerBusMetrics metrics, LiveListenerBus bus) {
        this.name = name;
        this.metrics = metrics;
        this.bus = bus;
        Logging.$init$(this);
        ListenerBus.$init$(this);
        SparkListenerBus.$init$(this);
        this.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue = new LinkedBlockingQueue(BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.LISTENER_BUS_EVENT_QUEUE_CAPACITY())));
        this.eventCount = new AtomicLong();
        this.droppedEventsCounter = new AtomicLong(0L);
        this.lastReportTimestamp = 0L;
        this.logDroppedEvent = new AtomicBoolean(false);
        this.org$apache$spark$scheduler$AsyncEventQueue$$sc = null;
        this.started = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
        this.droppedEvents = metrics.metricRegistry().counter(new StringBuilder(23).append("queue.").append(name).append(".numDroppedEvents").toString());
        this.processingTime = metrics.metricRegistry().timer(new StringBuilder(29).append("queue.").append(name).append(".listenerProcessingTime").toString());
        metrics.metricRegistry().remove(new StringBuilder(11).append("queue.").append(name).append(".size").toString());
        metrics.metricRegistry().register(new StringBuilder(11).append("queue.").append(name).append(".size").toString(), (Metric)new Gauge<Object>(this){
            private final /* synthetic */ AsyncEventQueue $outer;

            public int getValue() {
                return this.$outer.org$apache$spark$scheduler$AsyncEventQueue$$eventQueue().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.dispatchThread = new Thread(this){
            private final /* synthetic */ AsyncEventQueue $outer;

            public void run() {
                Utils$.MODULE$.tryOrStopSparkContext(this.$outer.org$apache$spark$scheduler$AsyncEventQueue$$sc(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$scheduler$AsyncEventQueue$$dispatch());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(21).append("spark-listener-group-").append($outer.name()).toString());
                this.setDaemon(true);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.AsyncEventQueue$$anon$2 )}, serializedLambda);
            }
        };
    }
}

