/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001M4AAC\u0006\u0001-!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!9\u0004A!A!\u0002\u0013A\u0004\"\u0002\u001f\u0001\t\u0003i\u0004bB\"\u0001\u0005\u0004%I\u0001\u0012\u0005\u0007\u0011\u0002\u0001\u000b\u0011B#\t\u000b%\u0003A\u0011\t&\t\u000b\u0015\u0004A\u0011\t4\t\u000b9\u0004A\u0011I8\u0003'9+G\u000f^=CY>\u001c7N\u00159d'\u0016\u0014h/\u001a:\u000b\u00051i\u0011!\u00028fiRL(B\u0001\b\u0010\u0003\u001dqW\r^<pe.T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001q#\b\t\u00031mi\u0011!\u0007\u0006\u000355\taa]3sm\u0016\u0014\u0018B\u0001\u000f\u001a\u0005)\u0011\u0006o\u0019%b]\u0012dWM\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0003A=\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003E}\u0011q\u0001T8hO&tw-A\u0003baBLE\r\u0005\u0002&]9\u0011a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0003SU\ta\u0001\u0010:p_Rt$\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R\u0013A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!\f\u0016\u0002\u0015M,'/[1mSj,'\u000f\u0005\u00024k5\tAG\u0003\u00022\u001f%\u0011a\u0007\u000e\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001\u00042m_\u000e\\W*\u00198bO\u0016\u0014\bCA\u001d;\u001b\u0005i\u0011BA\u001e\u000e\u0005A\u0011En\\2l\t\u0006$\u0018-T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0005}\u0001\u000b%\t\u0005\u0002@\u00015\t1\u0002C\u0003$\t\u0001\u0007A\u0005C\u00032\t\u0001\u0007!\u0007C\u00038\t\u0001\u0007\u0001(A\u0007tiJ,\u0017-\\'b]\u0006<WM]\u000b\u0002\u000bB\u0011\u0001DR\u0005\u0003\u000ff\u0011ac\u00148f\r>\u0014xJ\\3TiJ,\u0017-\\'b]\u0006<WM]\u0001\u000fgR\u0014X-Y7NC:\fw-\u001a:!\u0003\u001d\u0011XmY3jm\u0016$BaS(WAB\u0011A*T\u0007\u0002U%\u0011aJ\u000b\u0002\u0005+:LG\u000fC\u0003Q\u000f\u0001\u0007\u0011+\u0001\u0004dY&,g\u000e\u001e\t\u0003%Rk\u0011a\u0015\u0006\u0003!6I!!V*\u0003\u001fQ\u0013\u0018M\\:q_J$8\t\\5f]RDQaV\u0004A\u0002a\u000b!B\u001d9d\u001b\u0016\u001c8/Y4f!\tIf,D\u0001[\u0015\tYF,A\u0002oS>T\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b\u0005<\u0001\u0019\u00012\u0002\u001fI,7\u000f]8og\u0016\u001cuN\u001c;fqR\u0004\"AU2\n\u0005\u0011\u001c&a\u0005*qGJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0017!\u0004:fG\u0016Lg/Z*ue\u0016\fW\u000e\u0006\u0003hU.l\u0007C\u0001*i\u0013\tI7K\u0001\u000bTiJ,\u0017-\\\"bY2\u0014\u0017mY6XSRD\u0017\n\u0012\u0005\u0006!\"\u0001\r!\u0015\u0005\u0006Y\"\u0001\r\u0001W\u0001\u000e[\u0016\u001c8/Y4f\u0011\u0016\fG-\u001a:\t\u000b\u0005D\u0001\u0019\u00012\u0002!\u001d,Go\u0015;sK\u0006lW*\u00198bO\u0016\u0014H#\u00019\u0011\u0005a\t\u0018B\u0001:\u001a\u00055\u0019FO]3b[6\u000bg.Y4fe\u0002")
public class NettyBlockRpcServer
extends RpcHandler
implements Logging {
    private final String appId;
    private final Serializer serializer;
    private final BlockDataManager blockManager;
    private final OneForOneStreamManager streamManager;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private OneForOneStreamManager streamManager() {
        return this.streamManager;
    }

    public void receive(TransportClient client, ByteBuffer rpcMessage, RpcResponseCallback responseContext) {
        block3: {
            BlockTransferMessage blockTransferMessage;
            block4: {
                StorageLevel storageLevel;
                ClassTag classTag;
                UploadBlock uploadBlock;
                block6: {
                    Tuple2 tuple2;
                    block5: {
                        block2: {
                            BlockTransferMessage message = BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)rpcMessage);
                            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Received request: ").append(message).toString());
                            blockTransferMessage = message;
                            if (!(blockTransferMessage instanceof OpenBlocks)) break block2;
                            OpenBlocks openBlocks = (OpenBlocks)blockTransferMessage;
                            int blocksNum = openBlocks.blockIds.length;
                            SeqView blocks = (SeqView)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), blocksNum).view().map((Function1 & Serializable & scala.Serializable)i -> this.blockManager.getBlockData(BlockId$.MODULE$.apply(openBlocks.blockIds[BoxesRunTime.unboxToInt((Object)i)])), SeqView$.MODULE$.canBuildFrom());
                            long streamId = this.streamManager().registerStream(this.appId, (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(blocks.iterator()).asJava(), client.getChannel());
                            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Registered streamId ").append(streamId).append(" with ").append(blocksNum).append(" buffers").toString());
                            responseContext.onSuccess(new StreamHandle(streamId, blocksNum).toByteBuffer());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(blockTransferMessage instanceof UploadBlock)) break block4;
                        uploadBlock = (UploadBlock)blockTransferMessage;
                        tuple2 = (Tuple2)this.serializer.newInstance().deserialize(ByteBuffer.wrap(uploadBlock.metadata), ClassTag$.MODULE$.Nothing());
                        if (tuple2 == null) break block5;
                        StorageLevel level = (StorageLevel)tuple2._1();
                        classTag = (ClassTag)tuple2._2();
                        if (level == null) break block5;
                        storageLevel = level;
                        if (classTag instanceof ClassTag) break block6;
                    }
                    throw new MatchError((Object)tuple2);
                }
                ClassTag classTag2 = classTag;
                Tuple2 tuple2 = new Tuple2((Object)storageLevel, (Object)classTag2);
                Tuple2 tuple22 = tuple2;
                StorageLevel level = (StorageLevel)tuple22._1();
                ClassTag classTag3 = (ClassTag)tuple22._2();
                NioManagedBuffer data = new NioManagedBuffer(ByteBuffer.wrap(uploadBlock.blockData));
                BlockId blockId = BlockId$.MODULE$.apply(uploadBlock.blockId);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Receiving replicated block ").append(blockId).append(" with level ").append(level).append(" ").append("from ").append(client.getSocketAddress()).toString());
                this.blockManager.putBlockData(blockId, (ManagedBuffer)data, level, classTag3);
                responseContext.onSuccess(ByteBuffer.allocate(0));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                break block3;
            }
            throw new MatchError((Object)blockTransferMessage);
        }
    }

    public StreamCallbackWithID receiveStream(TransportClient client, ByteBuffer messageHeader, RpcResponseCallback responseContext) {
        StorageLevel storageLevel;
        ClassTag classTag;
        UploadBlockStream message;
        block3: {
            Tuple2 tuple2;
            block2: {
                message = (UploadBlockStream)BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)messageHeader);
                tuple2 = (Tuple2)this.serializer.newInstance().deserialize(ByteBuffer.wrap(message.metadata), ClassTag$.MODULE$.Nothing());
                if (tuple2 == null) break block2;
                StorageLevel level = (StorageLevel)tuple2._1();
                classTag = (ClassTag)tuple2._2();
                if (level == null) break block2;
                storageLevel = level;
                if (classTag instanceof ClassTag) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        ClassTag classTag2 = classTag;
        Tuple2 tuple2 = new Tuple2((Object)storageLevel, (Object)classTag2);
        Tuple2 tuple22 = tuple2;
        StorageLevel level = (StorageLevel)tuple22._1();
        ClassTag classTag3 = (ClassTag)tuple22._2();
        BlockId blockId = BlockId$.MODULE$.apply(message.blockId);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Receiving replicated block ").append(blockId).append(" with level ").append(level).append(" as stream ").append("from ").append(client.getSocketAddress()).toString());
        return this.blockManager.putBlockDataAsStream(blockId, level, classTag3);
    }

    public StreamManager getStreamManager() {
        return this.streamManager();
    }

    public NettyBlockRpcServer(String appId, Serializer serializer, BlockDataManager blockManager) {
        this.appId = appId;
        this.serializer = serializer;
        this.blockManager = blockManager;
        Logging.$init$(this);
        this.streamManager = new OneForOneStreamManager();
    }
}

