/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.metrics.MetricsConfig;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.sink.MetricsServlet;
import org.apache.spark.metrics.sink.Sink;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.metrics.source.StaticSources$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.jetty.servlet.ServletContextHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t5a!B\u0015+\u00011\u0012\u0004\u0002C \u0001\u0005\u000b\u0007I\u0011A!\t\u00115\u0003!\u0011!Q\u0001\n\tC\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\")q\u000b\u0001C\u00051\"1a\f\u0001Q\u0001\n}CqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004s\u0001\u0001\u0006I\u0001\u001a\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0011\u0019a\b\u0001)A\u0005k\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\t\u0001\u0001\u0006Ia \u0005\n\u0003'\u0001\u0001\u0019!C\u0005\u0003+A\u0011\"!\b\u0001\u0001\u0004%I!a\b\t\u0011\u0005-\u0002\u0001)Q\u0005\u0003/A\u0011\"!\f\u0001\u0001\u0004%I!a\f\t\u0013\u0005u\u0002\u00011A\u0005\n\u0005}\u0002\u0002CA\"\u0001\u0001\u0006K!!\r\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004\"CA6\u0001E\u0005I\u0011AA7\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!a\"\u0001\t\u0003\t)\t\u0003\u0005\u0002\n\u0002!\t\u0001LAF\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!!+\u0001\t\u0003\tY\u000bC\u0004\u00020\u0002!\t!!-\t\u000f\u0005U\u0006\u0001\"\u0003\u0002\u0006\"9\u0011q\u0017\u0001\u0005\n\u0005\u0015u\u0001CA]U!\u0005A&a/\u0007\u000f%R\u0003\u0012\u0001\u0017\u0002>\"1qk\bC\u0001\u0003\u007fC\u0011\"!1 \u0005\u0004%\t!a1\t\u0011\u0005Uw\u0004)A\u0005\u0003\u000bD\u0011\"a6 \u0005\u0004%\t!a1\t\u0011\u0005ew\u0004)A\u0005\u0003\u000bD\u0001\"a7 A\u0003%\u0011Q\u001c\u0005\t\u0003_|\u0002\u0015!\u0003\u0002r\"9\u0011q_\u0010\u0005\u0002\u0005e\bb\u0002B\u0002?\u0011\u0005!Q\u0001\u0002\u000e\u001b\u0016$(/[2t'f\u001cH/Z7\u000b\u0005-b\u0013aB7fiJL7m\u001d\u0006\u0003[9\nQa\u001d9be.T!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sON\u0019\u0001aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g!\tQT(D\u0001<\u0015\taD&\u0001\u0005j]R,'O\\1m\u0013\tq4HA\u0004M_\u001e<\u0017N\\4\u0002\u0011%t7\u000f^1oG\u0016\u001c\u0001!F\u0001C!\t\u0019%J\u0004\u0002E\u0011B\u0011Q)N\u0007\u0002\r*\u0011q\tQ\u0001\u0007yI|w\u000e\u001e \n\u0005%+\u0014A\u0002)sK\u0012,g-\u0003\u0002L\u0019\n11\u000b\u001e:j]\u001eT!!S\u001b\u0002\u0013%t7\u000f^1oG\u0016\u0004\u0013\u0001B2p]\u001a\u0004\"\u0001U)\u000e\u00031J!A\u0015\u0017\u0003\u0013M\u0003\u0018M]6D_:4\u0017aC:fGV\u0014\u0018\u000e^=NOJ\u0004\"\u0001U+\n\u0005Yc#aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u0011I6\fX/\u0011\u0005i\u0003Q\"\u0001\u0016\t\u000b}*\u0001\u0019\u0001\"\t\u000b9+\u0001\u0019A(\t\u000bM+\u0001\u0019\u0001+\u0002\u001b5,GO]5dg\u000e{gNZ5h!\tQ\u0006-\u0003\u0002bU\tiQ*\u001a;sS\u000e\u001c8i\u001c8gS\u001e\fQa]5oWN,\u0012\u0001\u001a\t\u0004K*dW\"\u00014\u000b\u0005\u001dD\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003SV\n!bY8mY\u0016\u001cG/[8o\u0013\tYgMA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA7q\u001b\u0005q'BA8+\u0003\u0011\u0019\u0018N\\6\n\u0005Et'\u0001B*j].\faa]5oWN\u0004\u0013aB:pkJ\u001cWm]\u000b\u0002kB\u0019QM\u001b<\u0011\u0005]TX\"\u0001=\u000b\u0005eT\u0013AB:pkJ\u001cW-\u0003\u0002|q\n11k\\;sG\u0016\f\u0001b]8ve\u000e,7\u000fI\u0001\te\u0016<\u0017n\u001d;ssV\tq\u0010\u0005\u0003\u0002\u0002\u00055QBAA\u0002\u0015\rY\u0013Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0005d_\u0012\f\u0007.\u00197f\u0015\t\tY!A\u0002d_6LA!a\u0004\u0002\u0004\tqQ*\u001a;sS\u000e\u0014VmZ5tiJL\u0018!\u0003:fO&\u001cHO]=!\u0003\u001d\u0011XO\u001c8j]\u001e,\"!a\u0006\u0011\u0007Q\nI\"C\u0002\u0002\u001cU\u0012qAQ8pY\u0016\fg.A\u0006sk:t\u0017N\\4`I\u0015\fH\u0003BA\u0011\u0003O\u00012\u0001NA\u0012\u0013\r\t)#\u000e\u0002\u0005+:LG\u000fC\u0005\u0002*9\t\t\u00111\u0001\u0002\u0018\u0005\u0019\u0001\u0010J\u0019\u0002\u0011I,hN\\5oO\u0002\na\"\\3ue&\u001c7oU3sm2,G/\u0006\u0002\u00022A)A'a\r\u00028%\u0019\u0011QG\u001b\u0003\r=\u0003H/[8o!\ri\u0017\u0011H\u0005\u0004\u0003wq'AD'fiJL7m]*feZdW\r^\u0001\u0013[\u0016$(/[2t'\u0016\u0014h\u000f\\3u?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005\u0005\u0003\"CA\u0015#\u0005\u0005\t\u0019AA\u0019\u0003=iW\r\u001e:jGN\u001cVM\u001d<mKR\u0004\u0013AE4fiN+'O\u001e7fi\"\u000bg\u000e\u001a7feN,\"!!\u0013\u0011\u000bQ\nY%a\u0014\n\u0007\u00055SGA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002R\u0005}SBAA*\u0015\u0011\t)&a\u0016\u0002\u000fM,'O\u001e7fi*!\u0011\u0011LA.\u0003\u0015QW\r\u001e;z\u0015\r\ti\u0006M\u0001\bK\u000ed\u0017\u000e]:f\u0013\u0011\t\t'a\u0015\u0003+M+'O\u001e7fi\u000e{g\u000e^3yi\"\u000bg\u000e\u001a7fe\u0006)1\u000f^1siR!\u0011\u0011EA4\u0011%\tI\u0007\u0006I\u0001\u0002\u0004\t9\"A\u000bsK\u001eL7\u000f^3s'R\fG/[2T_V\u00148-Z:\u0002\u001fM$\u0018M\u001d;%I\u00164\u0017-\u001e7uIE*\"!a\u001c+\t\u0005]\u0011\u0011O\u0016\u0003\u0003g\u0002B!!\u001e\u0002\u00005\u0011\u0011q\u000f\u0006\u0005\u0003s\nY(A\u0005v]\u000eDWmY6fI*\u0019\u0011QP\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0002\u0006]$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!1\u000f^8q)\t\t\t#\u0001\u0004sKB|'\u000f^\u0001\u0012EVLG\u000e\u001a*fO&\u001cHO]=OC6,Gc\u0001\"\u0002\u000e\")\u0011\u0010\u0007a\u0001m\u0006\u0001r-\u001a;T_V\u00148-Z:Cs:\u000bW.\u001a\u000b\u0005\u0003'\u000b)\u000bE\u0003\u0002\u0016\u0006}eO\u0004\u0003\u0002\u0018\u0006mebA#\u0002\u001a&\ta'C\u0002\u0002\u001eV\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\"\u0006\r&aA*fc*\u0019\u0011QT\u001b\t\r\u0005\u001d\u0016\u00041\u0001C\u0003)\u0019x.\u001e:dK:\u000bW.Z\u0001\u000fe\u0016<\u0017n\u001d;feN{WO]2f)\u0011\t\t#!,\t\u000beT\u0002\u0019\u0001<\u0002\u0019I,Wn\u001c<f'>,(oY3\u0015\t\u0005\u0005\u00121\u0017\u0005\u0006sn\u0001\rA^\u0001\u0010e\u0016<\u0017n\u001d;feN{WO]2fg\u0006i!/Z4jgR,'oU5oWN\fQ\"T3ue&\u001c7oU=ti\u0016l\u0007C\u0001. '\ty2\u0007\u0006\u0002\u0002<\u0006Q1+\u0013(L?J+u)\u0012-\u0016\u0005\u0005\u0015\u0007\u0003BAd\u0003#l!!!3\u000b\t\u0005-\u0017QZ\u0001\t[\u0006$8\r[5oO*\u0019\u0011qZ\u001b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003'\fIMA\u0003SK\u001e,\u00070A\u0006T\u0013:[uLU#H\u000bb\u0003\u0013\u0001D*P+J\u001bUi\u0018*F\u000f\u0016C\u0016!D*P+J\u001bUi\u0018*F\u000f\u0016C\u0006%A\tN\u0013:KU*\u0011'`!>cEjX+O\u0013R\u0003B!a8\u0002l6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/\u0001\u0006d_:\u001cWO\u001d:f]RTA!a4\u0002h*\u0011\u0011\u0011^\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002n\u0006\u0005(\u0001\u0003+j[\u0016,f.\u001b;\u0002'5Ke*S'B\u0019~\u0003v\n\u0014'`!\u0016\u0013\u0016j\u0014#\u0011\u0007Q\n\u00190C\u0002\u0002vV\u00121!\u00138u\u0003e\u0019\u0007.Z2l\u001b&t\u0017.\\1m!>dG.\u001b8h!\u0016\u0014\u0018n\u001c3\u0015\r\u0005\u0005\u00121`A\u0000\u0011\u001d\tip\na\u0001\u0003;\f\u0001\u0002]8mYVs\u0017\u000e\u001e\u0005\b\u0005\u00039\u0003\u0019AAy\u0003)\u0001x\u000e\u001c7QKJLw\u000eZ\u0001\u0014GJ,\u0017\r^3NKR\u0014\u0018nY:TsN$X-\u001c\u000b\b3\n\u001d!\u0011\u0002B\u0006\u0011\u0015y\u0004\u00061\u0001C\u0011\u0015q\u0005\u00061\u0001P\u0011\u0015\u0019\u0006\u00061\u0001U\u0001")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final SparkConf conf;
    private final SecurityManager securityMgr;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> sinks;
    private final ArrayBuffer<Source> sources;
    private final MetricRegistry registry;
    private boolean running;
    private Option<MetricsServlet> metricsServlet;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MetricsSystem createMetricsSystem(String string, SparkConf sparkConf, SecurityManager securityManager) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, sparkConf, securityManager);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String instance() {
        return this.instance;
    }

    private ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private ArrayBuffer<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private Option<MetricsServlet> metricsServlet() {
        return this.metricsServlet;
    }

    private void metricsServlet_$eq(Option<MetricsServlet> x$1) {
        this.metricsServlet = x$1;
    }

    public ServletContextHandler[] getServletHandlers() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (ServletContextHandler[])this.metricsServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class)));
    }

    public void start(boolean registerStaticSources) {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        if (registerStaticSources) {
            StaticSources$.MODULE$.allSources().foreach((Function1 & Serializable & scala.Serializable)source -> {
                this.registerSource(source);
                return BoxedUnit.UNIT;
            });
            this.registerSources();
        }
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.start();
            return BoxedUnit.UNIT;
        });
    }

    public boolean start$default$1() {
        return true;
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.stop();
                return BoxedUnit.UNIT;
            });
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.report();
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public String buildRegistryName(Source source) {
        String string;
        String defaultName;
        block7: {
            Option<String> executorId;
            Option metricsNamespace;
            block6: {
                metricsNamespace = ((Option)this.conf.get(package$.MODULE$.METRICS_NAMESPACE())).orElse((Function0 & Serializable & scala.Serializable)() -> $this.conf.getOption("spark.app.id"));
                executorId = this.conf.getOption("spark.executor.id");
                defaultName = MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
                String string2 = this.instance();
                String string3 = "driver";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block6;
                String string4 = this.instance();
                String string5 = "executor";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block7;
            }
            if (metricsNamespace.isDefined() && executorId.isDefined()) {
                string = MetricRegistry.name((String)((String)metricsNamespace.get()), (String[])new String[]{(String)executorId.get(), source.sourceName()});
                return string;
            }
            if (metricsNamespace.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Using default name ").append(defaultName).append(" for source because neither ").append(package$.MODULE$.METRICS_NAMESPACE().key()).append(" nor spark.app.id is set.").toString());
            }
            if (executorId.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Using default name ").append(defaultName).append(" for source because spark.executor.id is ").append("not set.").toString());
            }
            string = defaultName;
            return string;
        }
        string = defaultName;
        return string;
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        return (Seq)this.sources().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$5)));
    }

    public void registerSource(Source source) {
        this.sources().$plus$eq((Object)source);
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        this.sources().$minus$eq((Object)source);
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching(new MetricFilter(null, regName){
            private final String regName$1;

            public boolean matches(String name, Metric metric) {
                return name.startsWith(this.regName$1);
            }
            {
                this.regName$1 = regName$1;
            }
        });
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            BoxedUnit boxedUnit;
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                try {
                    Object sink = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, SecurityManager.class).newInstance(kv._2(), this.registry(), $this.securityMgr);
                    Object object = kv._1();
                    String string = "servlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        this.metricsServlet_$eq((Option<MetricsServlet>)new Some((Object)((MetricsServlet)sink)));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    boxedUnit = this.sinks().$plus$eq((Object)((Sink)sink));
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                    throw e;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$5) {
        String string = x$5.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Object source = Utils$.MODULE$.classForName(classPath).newInstance();
            $this.registerSource((Source)source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, SparkConf conf, SecurityManager securityMgr) {
        this.instance = instance;
        this.conf = conf;
        this.securityMgr = securityMgr;
        Logging.$init$(this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new ArrayBuffer();
        this.registry = new MetricRegistry();
        this.running = false;
        this.metricsServlet = None$.MODULE$;
        this.metricsConfig.initialize();
    }
}

