/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.StorageMemoryPool;
import org.apache.spark.memory.UnifiedMemoryManager$;
import org.apache.spark.storage.BlockId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple4;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Q4Q\u0001F\u000b\u0001/uA\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011)\u0019!C\u0001S!A\u0001\u0007\u0001B\u0001B\u0003%!\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u0003+\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004B\u0002\u001c\u0001\t\u0003)r\u0007C\u0003>\u0001\u0011%a\bC\u0003C\u0001\u0011\u0005\u0013\u0006C\u0003D\u0001\u0011\u0005\u0013\u0006\u0003\u0004E\u0001\u0011\u0005S#\u0012\u0005\u0006\u001f\u0002!\t\u0005\u0015\u0005\u0006=\u0002!\teX\u0004\u0006GVA\t\u0001\u001a\u0004\u0006)UA\t!\u001a\u0005\u0006m9!\t!\u001b\u0005\bU:\u0011\r\u0011\"\u0003l\u0011\u0019ag\u0002)A\u0005g!)QN\u0004C\u0001]\")\u0011O\u0004C\u0005e\n!RK\\5gS\u0016$W*Z7pefl\u0015M\\1hKJT!AF\f\u0002\r5,Wn\u001c:z\u0015\tA\u0012$A\u0003ta\u0006\u00148N\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7C\u0001\u0001\u001f!\ty\u0002%D\u0001\u0016\u0013\t\tSCA\u0007NK6|'/_'b]\u0006<WM]\u0001\u0005G>tgm\u0001\u0001\u0011\u0005\u00152S\"A\f\n\u0005\u001d:\"!C*qCJ\\7i\u001c8g\u00035i\u0017\r\u001f%fCBlU-\\8ssV\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0003M_:<\u0017AD7bq\"+\u0017\r]'f[>\u0014\u0018\u0010I\u0001\u0018_:DU-\u00199Ti>\u0014\u0018mZ3SK\u001eLwN\\*ju\u0016\f\u0001B\\;n\u0007>\u0014Xm\u001d\t\u0003WQJ!!\u000e\u0017\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0006qeR4\b\u0010\t\u0003?\u0001AQA\t\u0004A\u0002\u0011BQ\u0001\u000b\u0004A\u0002)BQ!\r\u0004A\u0002)BQA\r\u0004A\u0002M\n\u0001#Y:tKJ$\u0018J\u001c<be&\fg\u000e^:\u0015\u0003}\u0002\"a\u000b!\n\u0005\u0005c#\u0001B+oSR\fa#\\1y\u001f:DU-\u00199Ti>\u0014\u0018mZ3NK6|'/_\u0001\u0018[\u0006DxJ\u001a4IK\u0006\u00048\u000b^8sC\u001e,W*Z7pef\fa#Y2rk&\u0014X-\u0012=fGV$\u0018n\u001c8NK6|'/\u001f\u000b\u0005U\u0019C%\nC\u0003H\u0015\u0001\u0007!&\u0001\u0005ok6\u0014\u0015\u0010^3t\u0011\u0015I%\u00021\u0001+\u00035!\u0018m]6BiR,W\u000e\u001d;JI\")1J\u0003a\u0001\u0019\u0006QQ.Z7peflu\u000eZ3\u0011\u0005}i\u0015B\u0001(\u0016\u0005)iU-\\8ss6{G-Z\u0001\u0015C\u000e\fX/\u001b:f'R|'/Y4f\u001b\u0016lwN]=\u0015\tE#F,\u0018\t\u0003WIK!a\u0015\u0017\u0003\u000f\t{w\u000e\\3b]\")Qk\u0003a\u0001-\u00069!\r\\8dW&#\u0007CA,[\u001b\u0005A&BA-\u0018\u0003\u001d\u0019Ho\u001c:bO\u0016L!a\u0017-\u0003\u000f\tcwnY6JI\")qi\u0003a\u0001U!)1j\u0003a\u0001\u0019\u0006\u0019\u0012mY9vSJ,WK\u001c:pY2lU-\\8ssR!\u0011\u000bY1c\u0011\u0015)F\u00021\u0001W\u0011\u00159E\u00021\u0001+\u0011\u0015YE\u00021\u0001M\u0003Q)f.\u001b4jK\u0012lU-\\8ss6\u000bg.Y4feB\u0011qDD\n\u0003\u001d\u0019\u0004\"aK4\n\u0005!d#AB!osJ+g\rF\u0001e\u0003q\u0011ViU#S-\u0016#ulU-T)\u0016ku,T#N\u001fJKvLQ-U\u000bN+\u0012aM\u0001\u001e%\u0016\u001bVI\u0015,F\t~\u001b\u0016l\u0015+F\u001b~kU)T(S3~\u0013\u0015\fV#TA\u0005)\u0011\r\u001d9msR\u0019\u0001h\u001c9\t\u000b\t\u0012\u0002\u0019\u0001\u0013\t\u000bI\u0012\u0002\u0019A\u001a\u0002\u0019\u001d,G/T1y\u001b\u0016lwN]=\u0015\u0005)\u001a\b\"\u0002\u0012\u0014\u0001\u0004!\u0003")
public class UnifiedMemoryManager
extends MemoryManager {
    private final long maxHeapMemory;
    private final long onHeapStorageRegionSize;

    public static UnifiedMemoryManager apply(SparkConf sparkConf, int n) {
        return UnifiedMemoryManager$.MODULE$.apply(sparkConf, n);
    }

    public long maxHeapMemory() {
        return this.maxHeapMemory;
    }

    private void assertInvariants() {
        Predef$.MODULE$.assert(this.onHeapExecutionMemoryPool().poolSize() + this.onHeapStorageMemoryPool().poolSize() == this.maxHeapMemory());
        Predef$.MODULE$.assert(this.offHeapExecutionMemoryPool().poolSize() + this.offHeapStorageMemoryPool().poolSize() == this.maxOffHeapMemory());
    }

    @Override
    public synchronized long maxOnHeapStorageMemory() {
        return this.maxHeapMemory() - this.onHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long maxOffHeapStorageMemory() {
        return this.maxOffHeapMemory() - this.offHeapExecutionMemoryPool().memoryUsed();
    }

    @Override
    public synchronized long acquireExecutionMemory(long numBytes, long taskAttemptId, MemoryMode memoryMode) {
        Tuple4 tuple4;
        this.assertInvariants();
        Predef$.MODULE$.assert(numBytes >= 0L);
        MemoryMode memoryMode2 = memoryMode;
        if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
            tuple4 = new Tuple4((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.onHeapStorageRegionSize), (Object)BoxesRunTime.boxToLong((long)this.maxHeapMemory()));
        } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
            tuple4 = new Tuple4((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.offHeapStorageMemory()), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapMemory()));
        } else {
            throw new MatchError((Object)memoryMode2);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple42._1();
        StorageMemoryPool storagePool = (StorageMemoryPool)tuple42._2();
        long storageRegionSize = BoxesRunTime.unboxToLong((Object)tuple42._3());
        long maxMemory = BoxesRunTime.unboxToLong((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)executionPool, (Object)storagePool, (Object)BoxesRunTime.boxToLong((long)storageRegionSize), (Object)BoxesRunTime.boxToLong((long)maxMemory));
        Tuple4 tuple44 = tuple43;
        ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple44._1();
        StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple44._2();
        long storageRegionSize2 = BoxesRunTime.unboxToLong((Object)tuple44._3());
        long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple44._4());
        return executionPool2.acquireMemory(numBytes, taskAttemptId, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)extraMemoryNeeded -> UnifiedMemoryManager.maybeGrowExecutionPool$1(extraMemoryNeeded, storagePool2, storageRegionSize2, executionPool2), (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> UnifiedMemoryManager.computeMaxExecutionPoolSize$1(maxMemory2, storagePool2, storageRegionSize2));
    }

    @Override
    public synchronized boolean acquireStorageMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        StorageMemoryPool storagePool;
        block6: {
            Tuple3 tuple3;
            this.assertInvariants();
            Predef$.MODULE$.assert(numBytes >= 0L);
            MemoryMode memoryMode2 = memoryMode;
            if (((Object)((Object)MemoryMode.ON_HEAP)).equals((Object)memoryMode2)) {
                tuple3 = new Tuple3((Object)this.onHeapExecutionMemoryPool(), (Object)this.onHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOnHeapStorageMemory()));
            } else if (((Object)((Object)MemoryMode.OFF_HEAP)).equals((Object)memoryMode2)) {
                tuple3 = new Tuple3((Object)this.offHeapExecutionMemoryPool(), (Object)this.offHeapStorageMemoryPool(), (Object)BoxesRunTime.boxToLong((long)this.maxOffHeapStorageMemory()));
            } else {
                throw new MatchError((Object)memoryMode2);
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            ExecutionMemoryPool executionPool = (ExecutionMemoryPool)tuple32._1();
            StorageMemoryPool storagePool2 = (StorageMemoryPool)tuple32._2();
            long maxMemory = BoxesRunTime.unboxToLong((Object)tuple32._3());
            Tuple3 tuple33 = new Tuple3((Object)executionPool, (Object)storagePool2, (Object)BoxesRunTime.boxToLong((long)maxMemory));
            Tuple3 tuple34 = tuple33;
            ExecutionMemoryPool executionPool2 = (ExecutionMemoryPool)tuple34._1();
            storagePool = (StorageMemoryPool)tuple34._2();
            long maxMemory2 = BoxesRunTime.unboxToLong((Object)tuple34._3());
            if (numBytes > maxMemory2) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Will not store ").append(blockId).append(" as the required space (").append(numBytes).append(" bytes) exceeds our ").append("memory limit (").append(maxMemory2).append(" bytes)").toString());
                return false;
            }
            if (numBytes <= storagePool.memoryFree()) break block6;
            long memoryBorrowedFromExecution = Math.min(executionPool2.memoryFree(), numBytes - storagePool.memoryFree());
            executionPool2.decrementPoolSize(memoryBorrowedFromExecution);
            storagePool.incrementPoolSize(memoryBorrowedFromExecution);
        }
        return storagePool.acquireMemory(blockId, numBytes);
    }

    @Override
    public synchronized boolean acquireUnrollMemory(BlockId blockId, long numBytes, MemoryMode memoryMode) {
        return this.acquireStorageMemory(blockId, numBytes, memoryMode);
    }

    private static final void maybeGrowExecutionPool$1(long extraMemoryNeeded, StorageMemoryPool storagePool$1, long storageRegionSize$1, ExecutionMemoryPool executionPool$1) {
        block0: {
            long memoryReclaimableFromStorage;
            if (extraMemoryNeeded <= 0L || (memoryReclaimableFromStorage = package$.MODULE$.max(storagePool$1.memoryFree(), storagePool$1.poolSize() - storageRegionSize$1)) <= 0L) break block0;
            long spaceToReclaim = storagePool$1.freeSpaceToShrinkPool(package$.MODULE$.min(extraMemoryNeeded, memoryReclaimableFromStorage));
            storagePool$1.decrementPoolSize(spaceToReclaim);
            executionPool$1.incrementPoolSize(spaceToReclaim);
        }
    }

    private static final long computeMaxExecutionPoolSize$1(long maxMemory$1, StorageMemoryPool storagePool$1, long storageRegionSize$1) {
        return maxMemory$1 - package$.MODULE$.min(storagePool$1.memoryUsed(), storageRegionSize$1);
    }

    public UnifiedMemoryManager(SparkConf conf, long maxHeapMemory, long onHeapStorageRegionSize, int numCores) {
        this.maxHeapMemory = maxHeapMemory;
        this.onHeapStorageRegionSize = onHeapStorageRegionSize;
        super(conf, numCores, onHeapStorageRegionSize, maxHeapMemory - onHeapStorageRegionSize);
        this.assertInvariants();
    }
}

