/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.Serializable;
import java.net.URL;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkConf$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.worker.WorkerWatcher;
import org.apache.spark.deploy.worker.WorkerWatcher$;
import org.apache.spark.executor.CoarseGrainedExecutorBackend;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnv$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RetrieveSparkAppConfig$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class CoarseGrainedExecutorBackend$
implements Logging {
    public static CoarseGrainedExecutorBackend$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CoarseGrainedExecutorBackend$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private void run(String driverUrl, String executorId, String hostname, int cores, String appId, Option<String> workerUrl, Seq<URL> userClassPath) {
        Utils$.MODULE$.initDaemon(this.log());
        SparkHadoopUtil$.MODULE$.get().runAsSparkUser((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Utils$.MODULE$.checkHost(hostname);
            SparkConf executorConf = new SparkConf();
            RpcEnv fetcher = RpcEnv$.MODULE$.create("driverPropsFetcher", hostname, -1, executorConf, new SecurityManager(executorConf, SecurityManager$.MODULE$.$lessinit$greater$default$2()), true);
            RpcEndpointRef driver = fetcher.setupEndpointRefByURI(driverUrl);
            CoarseGrainedClusterMessages.SparkAppConfig cfg = (CoarseGrainedClusterMessages.SparkAppConfig)driver.askSync(CoarseGrainedClusterMessages$RetrieveSparkAppConfig$.MODULE$, ClassTag$.MODULE$.apply(CoarseGrainedClusterMessages.SparkAppConfig.class));
            Seq props = (Seq)cfg.sparkProperties().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.app.id", (Object)appId)})), Seq$.MODULE$.canBuildFrom());
            fetcher.shutdown();
            SparkConf driverConf = new SparkConf();
            props.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CoarseGrainedExecutorBackend$.$anonfun$run$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                SparkConf sparkConf = SparkConf$.MODULE$.isExecutorStartupConf(key) ? driverConf.setIfMissing(key, value) : driverConf.set(key, value);
                return sparkConf;
            });
            cfg.hadoopDelegationCreds().foreach((Function1 & Serializable & scala.Serializable)tokens -> {
                CoarseGrainedExecutorBackend$.$anonfun$run$4(driverConf, tokens);
                return BoxedUnit.UNIT;
            });
            SparkEnv env = SparkEnv$.MODULE$.createExecutorEnv(driverConf, executorId, hostname, cores, cfg.ioEncryptionKey(), false);
            env.rpcEnv().setupEndpoint("Executor", new CoarseGrainedExecutorBackend(env.rpcEnv(), driverUrl, executorId, hostname, cores, userClassPath, env));
            workerUrl.foreach((Function1 & Serializable & scala.Serializable)url -> env.rpcEnv().setupEndpoint("WorkerWatcher", new WorkerWatcher(env.rpcEnv(), (String)url, WorkerWatcher$.MODULE$.$lessinit$greater$default$3())));
            env.rpcEnv().awaitTermination();
        });
    }

    public void main(String[] args) {
        String driverUrl = null;
        String executorId = null;
        String hostname = null;
        int cores = 0;
        String appId = null;
        None$ workerUrl = None$.MODULE$;
        ListBuffer userClassPath = new ListBuffer();
        List argv = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList();
        while (!argv.isEmpty()) {
            BoxedUnit boxedUnit;
            boolean bl = false;
            .colon.colon colon2 = null;
            List list = argv;
            if (list instanceof .colon.colon) {
                bl = true;
                colon2 = (.colon.colon)list;
                String string = (String)colon2.head();
                List list2 = colon2.tl$access$1();
                if ("--driver-url".equals(string) && list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    String value = (String)colon3.head();
                    List tail = colon3.tl$access$1();
                    driverUrl = value;
                    argv = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list3 = colon2.tl$access$1();
                if ("--executor-id".equals(string) && list3 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list3;
                    String value = (String)colon4.head();
                    List tail = colon4.tl$access$1();
                    executorId = value;
                    argv = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list4 = colon2.tl$access$1();
                if ("--hostname".equals(string) && list4 instanceof .colon.colon) {
                    .colon.colon colon5 = (.colon.colon)list4;
                    String value = (String)colon5.head();
                    List tail = colon5.tl$access$1();
                    hostname = value;
                    argv = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list5 = colon2.tl$access$1();
                if ("--cores".equals(string) && list5 instanceof .colon.colon) {
                    .colon.colon colon6 = (.colon.colon)list5;
                    String value = (String)colon6.head();
                    List tail = colon6.tl$access$1();
                    cores = new StringOps(Predef$.MODULE$.augmentString(value)).toInt();
                    argv = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list6 = colon2.tl$access$1();
                if ("--app-id".equals(string) && list6 instanceof .colon.colon) {
                    .colon.colon colon7 = (.colon.colon)list6;
                    String value = (String)colon7.head();
                    List tail = colon7.tl$access$1();
                    appId = value;
                    argv = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list7 = colon2.tl$access$1();
                if ("--worker-url".equals(string) && list7 instanceof .colon.colon) {
                    .colon.colon colon8 = (.colon.colon)list7;
                    String value = (String)colon8.head();
                    List tail = colon8.tl$access$1();
                    workerUrl = new Some((Object)value);
                    argv = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (bl) {
                String string = (String)colon2.head();
                List list8 = colon2.tl$access$1();
                if ("--user-class-path".equals(string) && list8 instanceof .colon.colon) {
                    .colon.colon colon9 = (.colon.colon)list8;
                    String value = (String)colon9.head();
                    List tail = colon9.tl$access$1();
                    userClassPath.$plus$eq((Object)new URL(value));
                    argv = tail;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (Nil$.MODULE$.equals(list)) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            System.err.println(new StringBuilder(22).append("Unrecognized options: ").append(list.mkString(" ")).toString());
            this.printUsageAndExit();
            boxedUnit = BoxedUnit.UNIT;
        }
        if (hostname == null) {
            hostname = Utils$.MODULE$.localHostName();
            this.log().info(new StringBuilder(66).append("Executor hostname is not provided, will use '").append(hostname).append("' to advertise itself").toString());
        }
        if (driverUrl == null || executorId == null || cores <= 0 || appId == null) {
            this.printUsageAndExit();
        }
        this.run(driverUrl, executorId, hostname, cores, appId, (Option<String>)workerUrl, (Seq<URL>)userClassPath);
        System.exit(0);
    }

    private void printUsageAndExit() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("\n      |Usage: CoarseGrainedExecutorBackend [options]\n      |\n      | Options are:\n      |   --driver-url <driverUrl>\n      |   --executor-id <executorId>\n      |   --hostname <hostname>\n      |   --cores <cores>\n      |   --app-id <appid>\n      |   --worker-url <workerUrl>\n      |   --user-class-path <url>\n      |")).stripMargin());
        System.exit(1);
    }

    public static final /* synthetic */ boolean $anonfun$run$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$run$4(SparkConf driverConf$1, byte[] tokens) {
        SparkHadoopUtil$.MODULE$.get().addDelegationTokens(tokens, driverConf$1);
    }

    private CoarseGrainedExecutorBackend$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

