/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.ApplicationDescription;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.ExecutorState$;
import org.apache.spark.deploy.worker.CommandUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.FileAppender$;
import org.slf4j.Logger;
import org.spark_project.guava.io.Files;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b!\u0002\u001e<\u0001u*\u0005\u0002\u0003*\u0001\u0005\u000b\u0007I\u0011\u0001+\t\u0011\u0001\u0004!\u0011!Q\u0001\nUC\u0001\"\u0019\u0001\u0003\u0006\u0004%\tA\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005G\"Aq\r\u0001BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003j\u0011!q\u0007A!b\u0001\n\u0003\u0011\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011A\u0004!Q1A\u0005\u0002\tD\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\ty\u0001\u0011)\u0019!C\u0001e\"A\u0011\u0010\u0001B\u0001B\u0003%1\u000f\u0003\u0005{\u0001\t\u0015\r\u0011\"\u0001U\u0011!Y\bA!A!\u0002\u0013)\u0006\u0002\u0003?\u0001\u0005\u000b\u0007I\u0011\u0001+\t\u0011u\u0004!\u0011!Q\u0001\nUC\u0001B \u0001\u0003\u0006\u0004%\tA\u0019\u0005\t\u007f\u0002\u0011\t\u0011)A\u0005G\"I\u0011\u0011\u0001\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\n\u0003\u0007\u0001!\u0011!Q\u0001\nUC!\"!\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0004\u0011)\tI\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u00037\u0001!Q1A\u0005\u0002\u0005\u001d\u0001BCA\u000f\u0001\t\u0005\t\u0015!\u0003\u0002\n!I\u0011q\u0004\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\n\u0003C\u0001!\u0011!Q\u0001\nUC!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u0013\u0011)\ti\u0003\u0001BC\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0003\u0007\u0002!\u0011!Q\u0001\n\u0005E\u0002BCA#\u0001\t\u0005\r\u0011\"\u0001\u0002H!Q\u0011\u0011\f\u0001\u0003\u0002\u0004%\t!a\u0017\t\u0015\u0005\u001d\u0004A!A!B\u0013\tI\u0005C\u0004\u0002r\u0001!\t!a\u001d\t\u0013\u0005e\u0005A1A\u0005\n\u0005m\u0005\u0002CAT\u0001\u0001\u0006I!!(\t\u0013\u0005%\u0006\u00011A\u0005\n\u0005-\u0006\"CAZ\u0001\u0001\u0007I\u0011BA[\u0011!\tI\f\u0001Q!\n\u00055\u0006\"CA^\u0001\u0001\u0007I\u0011BA_\u0011%\t)\r\u0001a\u0001\n\u0013\t9\r\u0003\u0005\u0002L\u0002\u0001\u000b\u0015BA`\u0011%\ti\r\u0001a\u0001\n\u0013\ty\rC\u0005\u0002b\u0002\u0001\r\u0011\"\u0003\u0002d\"A\u0011q\u001d\u0001!B\u0013\t\t\u000eC\u0005\u0002j\u0002\u0001\r\u0011\"\u0003\u0002P\"I\u00111\u001e\u0001A\u0002\u0013%\u0011Q\u001e\u0005\t\u0003c\u0004\u0001\u0015)\u0003\u0002R\"A\u00111\u001f\u0001C\u0002\u0013%!\rC\u0004\u0002v\u0002\u0001\u000b\u0011B2\t\u0013\u0005]\b\u00011A\u0005\n\u0005e\b\"CA~\u0001\u0001\u0007I\u0011BA\u007f\u0011\u001d\u0011\t\u0001\u0001Q!\n\u0019C\u0001Ba\u0001\u0001\t\u0003Y$Q\u0001\u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011!\u0011)\u0002\u0001C\u0001w\t\u0015\u0001\u0002\u0003B\f\u0001\u0011\u00051H!\u0007\t\u000f\t}\u0001\u0001\"\u0003\u0003\u0006\tqQ\t_3dkR|'OU;o]\u0016\u0014(B\u0001\u001f>\u0003\u00199xN]6fe*\u0011ahP\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005\u0001\u000b\u0015!B:qCJ\\'B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001e\u001c2\u0001\u0001$M!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u0019\te.\u001f*fMB\u0011Q\nU\u0007\u0002\u001d*\u0011qjP\u0001\tS:$XM\u001d8bY&\u0011\u0011K\u0014\u0002\b\u0019><w-\u001b8h\u0003\u0015\t\u0007\u000f]%e\u0007\u0001)\u0012!\u0016\t\u0003-vs!aV.\u0011\u0005aCU\"A-\u000b\u0005i\u001b\u0016A\u0002\u001fs_>$h(\u0003\u0002]\u0011\u00061\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\ta\u0006*\u0001\u0004baBLE\rI\u0001\u0007Kb,7-\u00133\u0016\u0003\r\u0004\"a\u00123\n\u0005\u0015D%aA%oi\u00069Q\r_3d\u0013\u0012\u0004\u0013aB1qa\u0012+7oY\u000b\u0002SB\u0011!n[\u0007\u0002{%\u0011A.\u0010\u0002\u0017\u0003B\u0004H.[2bi&|g\u000eR3tGJL\u0007\u000f^5p]\u0006A\u0011\r\u001d9EKN\u001c\u0007%A\u0003d_J,7/\u0001\u0004d_J,7\u000fI\u0001\u0007[\u0016lwN]=\u0002\u000f5,Wn\u001c:zAU\t1\u000f\u0005\u0002uo6\tQO\u0003\u0002w\u007f\u0005\u0019!\u000f]2\n\u0005a,(A\u0004*qG\u0016sG\r]8j]R\u0014VMZ\u0001\bo>\u00148.\u001a:!\u0003!9xN]6fe&#\u0017!C<pe.,'/\u00133!\u0003\u0011Awn\u001d;\u0002\u000b!|7\u000f\u001e\u0011\u0002\u0013],'-V5Q_J$\u0018AC<fEVK\u0007k\u001c:uA\u0005i\u0001/\u001e2mS\u000e\fE\r\u001a:fgN\fa\u0002];cY&\u001c\u0017\t\u001a3sKN\u001c\b%A\u0005ta\u0006\u00148\u000eS8nKV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\tIwN\u0003\u0002\u0002\u0014\u0005!!.\u0019<b\u0013\u0011\t9\"!\u0004\u0003\t\u0019KG.Z\u0001\u000bgB\f'o\u001b%p[\u0016\u0004\u0013aC3yK\u000e,Ho\u001c:ESJ\fA\"\u001a=fGV$xN\u001d#je\u0002\n\u0011b^8sW\u0016\u0014XK\u001d7\u0002\u0015]|'o[3s+Jd\u0007%\u0001\u0003d_:4\u0007\u0003BA\u0014\u0003Si\u0011aP\u0005\u0004\u0003Wy$!C*qCJ\\7i\u001c8g\u00031\t\u0007\u000f\u001d'pG\u0006dG)\u001b:t+\t\t\t\u0004E\u0003\u00024\u0005uRK\u0004\u0003\u00026\u0005ebb\u0001-\u00028%\t\u0011*C\u0002\u0002<!\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0005\u0005#aA*fc*\u0019\u00111\b%\u0002\u001b\u0005\u0004\b\u000fT8dC2$\u0015N]:!\u0003\u0015\u0019H/\u0019;f+\t\tI\u0005\u0005\u0003\u0002L\u0005Ecb\u00016\u0002N%\u0019\u0011qJ\u001f\u0002\u001b\u0015CXmY;u_J\u001cF/\u0019;f\u0013\u0011\t\u0019&!\u0016\u0003\u000bY\u000bG.^3\n\u0007\u0005]\u0003JA\u0006F]VlWM]1uS>t\u0017!C:uCR,w\fJ3r)\u0011\ti&a\u0019\u0011\u0007\u001d\u000by&C\u0002\u0002b!\u0013A!\u00168ji\"I\u0011QM\u0010\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0004q\u0012\n\u0014AB:uCR,\u0007\u0005K\u0002!\u0003W\u00022aRA7\u0013\r\ty\u0007\u0013\u0002\tm>d\u0017\r^5mK\u00061A(\u001b8jiz\"\"%!\u001e\u0002z\u0005m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u00151RAG\u0003\u001f\u000b\t*a%\u0002\u0016\u0006]\u0005cAA<\u00015\t1\bC\u0003SC\u0001\u0007Q\u000bC\u0003bC\u0001\u00071\rC\u0003hC\u0001\u0007\u0011\u000eC\u0003oC\u0001\u00071\rC\u0003qC\u0001\u00071\rC\u0003=C\u0001\u00071\u000fC\u0003{C\u0001\u0007Q\u000bC\u0003}C\u0001\u0007Q\u000bC\u0003\u007fC\u0001\u00071\r\u0003\u0004\u0002\u0002\u0005\u0002\r!\u0016\u0005\b\u0003\u000b\t\u0003\u0019AA\u0005\u0011\u001d\tY\"\ta\u0001\u0003\u0013Aa!a\b\"\u0001\u0004)\u0006bBA\u0012C\u0001\u0007\u0011Q\u0005\u0005\b\u0003[\t\u0003\u0019AA\u0019\u0011\u001d\t)%\ta\u0001\u0003\u0013\naAZ;mY&#WCAAO!\u0011\ty*!*\u000e\u0005\u0005\u0005&\u0002BAR\u0003#\tA\u0001\\1oO&\u0019a,!)\u0002\u000f\u0019,H\u000e\\%eA\u0005aqo\u001c:lKJ$\u0006N]3bIV\u0011\u0011Q\u0016\t\u0005\u0003?\u000by+\u0003\u0003\u00022\u0006\u0005&A\u0002+ie\u0016\fG-\u0001\tx_J\\WM\u001d+ie\u0016\fGm\u0018\u0013fcR!\u0011QLA\\\u0011%\t)'JA\u0001\u0002\u0004\ti+A\u0007x_J\\WM\u001d+ie\u0016\fG\rI\u0001\baJ|7-Z:t+\t\ty\f\u0005\u0003\u0002 \u0006\u0005\u0017\u0002BAb\u0003C\u0013q\u0001\u0015:pG\u0016\u001c8/A\u0006qe>\u001cWm]:`I\u0015\fH\u0003BA/\u0003\u0013D\u0011\"!\u001a)\u0003\u0003\u0005\r!a0\u0002\u0011A\u0014xnY3tg\u0002\nab\u001d;e_V$\u0018\t\u001d9f]\u0012,'/\u0006\u0002\u0002RB!\u00111[Ao\u001b\t\t)N\u0003\u0003\u0002X\u0006e\u0017a\u00027pO\u001eLgn\u001a\u0006\u0004\u00037|\u0014\u0001B;uS2LA!a8\u0002V\naa)\u001b7f\u0003B\u0004XM\u001c3fe\u0006\u00112\u000f\u001e3pkR\f\u0005\u000f]3oI\u0016\u0014x\fJ3r)\u0011\ti&!:\t\u0013\u0005\u00154&!AA\u0002\u0005E\u0017aD:uI>,H/\u00119qK:$WM\u001d\u0011\u0002\u001dM$H-\u001a:s\u0003B\u0004XM\u001c3fe\u0006\u00112\u000f\u001e3feJ\f\u0005\u000f]3oI\u0016\u0014x\fJ3r)\u0011\ti&a<\t\u0013\u0005\u0015d&!AA\u0002\u0005E\u0017aD:uI\u0016\u0014(/\u00119qK:$WM\u001d\u0011\u0002;\u0015CViQ+U\u001fJ{F+\u0012*N\u0013:\u000bE+R0U\u00136+u*\u0016+`\u001bN\u000ba$\u0012-F\u0007V#vJU0U\u000bJk\u0015JT!U\u000b~#\u0016*T#P+R{Vj\u0015\u0011\u0002\u0019MDW\u000f\u001e3po:Dun\\6\u0016\u0003\u0019\u000b\u0001c\u001d5vi\u0012|wO\u001c%p_.|F%Z9\u0015\t\u0005u\u0013q \u0005\t\u0003K\u001a\u0014\u0011!a\u0001\r\u0006i1\u000f[;uI><h\u000eS8pW\u0002\nQa\u001d;beR$\"!!\u0018\u0002\u0017-LG\u000e\u001c)s_\u000e,7o\u001d\u000b\u0005\u0003;\u0012Y\u0001C\u0004\u0003\u000eY\u0002\rAa\u0004\u0002\u000f5,7o]1hKB!qI!\u0005V\u0013\r\u0011\u0019\u0002\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0002\t-LG\u000e\\\u0001\u0014gV\u00147\u000f^5ukR,g+\u0019:jC\ndWm\u001d\u000b\u0004+\nm\u0001B\u0002B\u000fq\u0001\u0007Q+\u0001\u0005be\u001e,X.\u001a8u\u0003M1W\r^2i\u0003:$'+\u001e8Fq\u0016\u001cW\u000f^8s\u0001")
public class ExecutorRunner
implements Logging {
    private final String appId;
    private final int execId;
    private final ApplicationDescription appDesc;
    private final int cores;
    private final int memory;
    private final RpcEndpointRef worker;
    private final String workerId;
    private final String host;
    private final int webUiPort;
    private final String publicAddress;
    private final File sparkHome;
    private final File executorDir;
    private final String workerUrl;
    private final SparkConf conf;
    private final Seq<String> appLocalDirs;
    private volatile Enumeration.Value state;
    private final String org$apache$spark$deploy$worker$ExecutorRunner$$fullId;
    private Thread workerThread;
    private Process process;
    private FileAppender stdoutAppender;
    private FileAppender stderrAppender;
    private final int EXECUTOR_TERMINATE_TIMEOUT_MS;
    private Object shutdownHook;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String appId() {
        return this.appId;
    }

    public int execId() {
        return this.execId;
    }

    public ApplicationDescription appDesc() {
        return this.appDesc;
    }

    public int cores() {
        return this.cores;
    }

    public int memory() {
        return this.memory;
    }

    public RpcEndpointRef worker() {
        return this.worker;
    }

    public String workerId() {
        return this.workerId;
    }

    public String host() {
        return this.host;
    }

    public int webUiPort() {
        return this.webUiPort;
    }

    public String publicAddress() {
        return this.publicAddress;
    }

    public File sparkHome() {
        return this.sparkHome;
    }

    public File executorDir() {
        return this.executorDir;
    }

    public String workerUrl() {
        return this.workerUrl;
    }

    public Seq<String> appLocalDirs() {
        return this.appLocalDirs;
    }

    public Enumeration.Value state() {
        return this.state;
    }

    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public String org$apache$spark$deploy$worker$ExecutorRunner$$fullId() {
        return this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private Process process() {
        return this.process;
    }

    private void process_$eq(Process x$1) {
        this.process = x$1;
    }

    private FileAppender stdoutAppender() {
        return this.stdoutAppender;
    }

    private void stdoutAppender_$eq(FileAppender x$1) {
        this.stdoutAppender = x$1;
    }

    private FileAppender stderrAppender() {
        return this.stderrAppender;
    }

    private void stderrAppender_$eq(FileAppender x$1) {
        this.stderrAppender = x$1;
    }

    private int EXECUTOR_TERMINATE_TIMEOUT_MS() {
        return this.EXECUTOR_TERMINATE_TIMEOUT_MS;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    private void shutdownHook_$eq(Object x$1) {
        this.shutdownHook = x$1;
    }

    public void start() {
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ ExecutorRunner $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$worker$ExecutorRunner$$fetchAndRunExecutor();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(19).append("ExecutorRunner for ").append($outer.org$apache$spark$deploy$worker$ExecutorRunner$$fullId()).toString());
            }
        });
        this.workerThread().start();
        this.shutdownHook_$eq(ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Enumeration.Value value = this.state();
            Enumeration.Value value2 = ExecutorState$.MODULE$.RUNNING();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.state_$eq(ExecutorState$.MODULE$.FAILED());
            }
            this.killProcess((Option<String>)new Some((Object)"Worker shutting down"));
        }));
    }

    private void killProcess(Option<String> message) {
        Option<Object> exitCode = None$.MODULE$;
        if (this.process() != null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Killing process!");
            if (this.stdoutAppender() != null) {
                this.stdoutAppender().stop();
            }
            if (this.stderrAppender() != null) {
                this.stderrAppender().stop();
            }
            if ((exitCode = Utils$.MODULE$.terminateProcess(this.process(), this.EXECUTOR_TERMINATE_TIMEOUT_MS())).isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Failed to terminate process: ").append(this.process()).append(". This process will likely be orphaned.").toString());
            }
        }
        try {
            this.worker().send(new DeployMessages.ExecutorStateChanged(this.appId(), this.execId(), this.state(), message, exitCode));
        }
        catch (IllegalStateException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
        }
    }

    public void kill() {
        block2: {
            if (this.workerThread() == null) break block2;
            this.workerThread().interrupt();
            this.workerThread_$eq(null);
            this.state_$eq(ExecutorState$.MODULE$.KILLED());
            try {
                ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook());
            }
            catch (IllegalStateException e) {
            }
        }
    }

    public String substituteVariables(String argument) {
        String string = argument;
        String string2 = "{{WORKER_URL}}".equals(string) ? this.workerUrl() : ("{{EXECUTOR_ID}}".equals(string) ? ((Object)BoxesRunTime.boxToInteger((int)this.execId())).toString() : ("{{HOSTNAME}}".equals(string) ? this.host() : ("{{CORES}}".equals(string) ? ((Object)BoxesRunTime.boxToInteger((int)this.cores())).toString() : ("{{APP_ID}}".equals(string) ? this.appId() : string))));
        return string2;
    }

    public void org$apache$spark$deploy$worker$ExecutorRunner$$fetchAndRunExecutor() {
        try {
            Seq subsOpts;
            Seq x$12 = subsOpts = (Seq)this.appDesc().command().javaOpts().map((Function1 & Serializable & scala.Serializable)x$1 -> Utils$.MODULE$.substituteAppNExecIds((String)x$1, this.appId(), ((Object)BoxesRunTime.boxToInteger((int)this.execId())).toString()), Seq$.MODULE$.canBuildFrom());
            String x$2 = this.appDesc().command().copy$default$1();
            Seq<String> x$3 = this.appDesc().command().copy$default$2();
            Map<String, String> x$4 = this.appDesc().command().copy$default$3();
            Seq<String> x$5 = this.appDesc().command().copy$default$4();
            Seq<String> x$6 = this.appDesc().command().copy$default$5();
            Command subsCommand = this.appDesc().command().copy(x$2, x$3, x$4, x$5, x$6, (Seq<String>)x$12);
            ProcessBuilder builder = CommandUtils$.MODULE$.buildProcessBuilder(subsCommand, new SecurityManager(this.conf, SecurityManager$.MODULE$.$lessinit$greater$default$2()), this.memory(), this.sparkHome().getAbsolutePath(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)argument -> this.substituteVariables((String)argument), CommandUtils$.MODULE$.buildProcessBuilder$default$6(), CommandUtils$.MODULE$.buildProcessBuilder$default$7());
            List<String> command = builder.command();
            String formattedCommand = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(command).asScala()).mkString("\"", "\" \"", "\"");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Launch command: ").append(formattedCommand).toString());
            builder.directory(this.executorDir());
            builder.environment().put("SPARK_EXECUTOR_DIRS", this.appLocalDirs().mkString(File.pathSeparator));
            builder.environment().put("SPARK_LAUNCH_WITH_SCALA", "0");
            String baseUrl = this.conf.getBoolean("spark.ui.reverseProxy", false) ? new StringBuilder(44).append("/proxy/").append(this.workerId()).append("/logPage/?appId=").append(this.appId()).append("&executorId=").append(this.execId()).append("&logType=").toString() : new StringBuilder(45).append("http://").append(this.publicAddress()).append(":").append(this.webUiPort()).append("/logPage/?appId=").append(this.appId()).append("&executorId=").append(this.execId()).append("&logType=").toString();
            builder.environment().put("SPARK_LOG_URL_STDERR", new StringBuilder(6).append(baseUrl).append("stderr").toString());
            builder.environment().put("SPARK_LOG_URL_STDOUT", new StringBuilder(6).append(baseUrl).append("stdout").toString());
            this.process_$eq(builder.start());
            String header = new StringOps(Predef$.MODULE$.augmentString("Spark Executor Command: %s\n%s\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedCommand, new StringOps(Predef$.MODULE$.augmentString("=")).$times(40)}));
            File stdout = new File(this.executorDir(), "stdout");
            this.stdoutAppender_$eq(FileAppender$.MODULE$.apply(this.process().getInputStream(), stdout, this.conf));
            File stderr = new File(this.executorDir(), "stderr");
            Files.write((CharSequence)header, (File)stderr, (Charset)StandardCharsets.UTF_8);
            this.stderrAppender_$eq(FileAppender$.MODULE$.apply(this.process().getErrorStream(), stderr, this.conf));
            int exitCode = this.process().waitFor();
            this.state_$eq(ExecutorState$.MODULE$.EXITED());
            String message = new StringBuilder(25).append("Command exited with code ").append(exitCode).toString();
            this.worker().send(new DeployMessages.ExecutorStateChanged(this.appId(), this.execId(), this.state(), (Option<String>)new Some((Object)message), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)exitCode))));
        }
        catch (InterruptedException interrupted) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Runner thread for executor ").append(this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId()).append(" interrupted").toString());
            this.state_$eq(ExecutorState$.MODULE$.KILLED());
            this.killProcess((Option<String>)None$.MODULE$);
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error running executor", e);
            this.state_$eq(ExecutorState$.MODULE$.FAILED());
            this.killProcess((Option<String>)new Some((Object)e.toString()));
        }
    }

    public ExecutorRunner(String appId, int execId, ApplicationDescription appDesc, int cores, int memory, RpcEndpointRef worker, String workerId, String host, int webUiPort, String publicAddress, File sparkHome, File executorDir, String workerUrl, SparkConf conf, Seq<String> appLocalDirs, Enumeration.Value state) {
        this.appId = appId;
        this.execId = execId;
        this.appDesc = appDesc;
        this.cores = cores;
        this.memory = memory;
        this.worker = worker;
        this.workerId = workerId;
        this.host = host;
        this.webUiPort = webUiPort;
        this.publicAddress = publicAddress;
        this.sparkHome = sparkHome;
        this.executorDir = executorDir;
        this.workerUrl = workerUrl;
        this.conf = conf;
        this.appLocalDirs = appLocalDirs;
        this.state = state;
        Logging.$init$(this);
        this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId = new StringBuilder(1).append(appId).append("/").append(execId).toString();
        this.workerThread = null;
        this.process = null;
        this.stdoutAppender = null;
        this.stderrAppender = null;
        this.EXECUTOR_TERMINATE_TIMEOUT_MS = 10000;
        this.shutdownHook = null;
    }
}

