/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.deploy.master.PersistenceEngine;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.Serializer;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c!B\b\u0011\u0001AQ\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u0011-\u0002!Q1A\u0005\u00021B\u0001B\r\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0006g\u0001!\t\u0001\u000e\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019\u0011\u0005\u0001)A\u0005u!91\t\u0001b\u0001\n\u0013!\u0005BB'\u0001A\u0003%Q\tC\u0003O\u0001\u0011\u0005s\nC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003k\u0001\u0011\u00053\u000eC\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u0011q\u0006\u0001\u0005\n\u0005E\"A\u0007.p_.+W\r]3s!\u0016\u00148/[:uK:\u001cW-\u00128hS:,'BA\t\u0013\u0003\u0019i\u0017m\u001d;fe*\u00111\u0003F\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c2\u0001A\u000e !\taR$D\u0001\u0011\u0013\tq\u0002CA\tQKJ\u001c\u0018n\u001d;f]\u000e,WI\\4j]\u0016\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u000b\u0002\u0011%tG/\u001a:oC2L!\u0001J\u0011\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g\u0007\u0001\u0001\"\u0001K\u0015\u000e\u0003QI!A\u000b\u000b\u0003\u0013M\u0003\u0018M]6D_:4\u0017AC:fe&\fG.\u001b>feV\tQ\u0006\u0005\u0002/a5\tqF\u0003\u0002,)%\u0011\u0011g\f\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018aC:fe&\fG.\u001b>fe\u0002\na\u0001P5oSRtDcA\u001b7oA\u0011A\u0004\u0001\u0005\u0006K\u0011\u0001\ra\n\u0005\u0006W\u0011\u0001\r!L\u0001\f/>\u00136*\u0013(H?\u0012K%+F\u0001;!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0003mC:<'\"A \u0002\t)\fg/Y\u0005\u0003\u0003r\u0012aa\u0015;sS:<\u0017\u0001D,P%.KejR0E\u0013J\u0003\u0013A\u0001>l+\u0005)\u0005C\u0001$L\u001b\u00059%B\u0001%J\u0003%1'/Y7fo>\u00148N\u0003\u0002K-\u000591-\u001e:bi>\u0014\u0018B\u0001'H\u0005A\u0019UO]1u_J4%/Y7fo>\u00148.A\u0002{W\u0002\nq\u0001]3sg&\u001cH\u000fF\u0002Q-\n\u0004\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u0013A!\u00168ji\")q+\u0003a\u00011\u0006!a.Y7f!\tI\u0006M\u0004\u0002[=B\u00111LU\u0007\u00029*\u0011QLJ\u0001\u0007yI|w\u000e\u001e \n\u0005}\u0013\u0016A\u0002)sK\u0012,g-\u0003\u0002BC*\u0011qL\u0015\u0005\u0006G&\u0001\r\u0001Z\u0001\u0004_\nT\u0007CA\u001ef\u0013\t1GH\u0001\u0004PE*,7\r^\u0001\nk:\u0004XM]:jgR$\"\u0001U5\t\u000b]S\u0001\u0019\u0001-\u0002\tI,\u0017\rZ\u000b\u0003Yf$2!\\A\u000b)\rq\u0017Q\u0001\t\u0004_R<hB\u00019s\u001d\tY\u0016/C\u0001T\u0013\t\u0019(+A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(aA*fc*\u00111O\u0015\t\u0003qfd\u0001\u0001B\u0003{\u0017\t\u00071PA\u0001U#\tax\u0010\u0005\u0002R{&\u0011aP\u0015\u0002\b\u001d>$\b.\u001b8h!\r\t\u0016\u0011A\u0005\u0004\u0003\u0007\u0011&aA!os\"I\u0011qA\u0006\u0002\u0002\u0003\u000f\u0011\u0011B\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004#BA\u0006\u0003#9XBAA\u0007\u0015\r\tyAU\u0001\be\u00164G.Z2u\u0013\u0011\t\u0019\"!\u0004\u0003\u0011\rc\u0017m]:UC\u001eDa!a\u0006\f\u0001\u0004A\u0016A\u00029sK\u001aL\u00070A\u0003dY>\u001cX\rF\u0001Q\u0003E\u0019XM]5bY&TX-\u00138u_\u001aKG.\u001a\u000b\u0006!\u0006\u0005\u0012Q\u0005\u0005\u0007\u0003Gi\u0001\u0019\u0001-\u0002\tA\fG\u000f\u001b\u0005\b\u0003Oi\u0001\u0019AA\u0015\u0003\u00151\u0018\r\\;f!\r\t\u00161F\u0005\u0004\u0003[\u0011&AB!osJ+g-A\neKN,'/[1mSj,gI]8n\r&dW-\u0006\u0003\u00024\u0005}B\u0003BA\u001b\u0003\u000f\"B!a\u000e\u0002BA)\u0011+!\u000f\u0002>%\u0019\u00111\b*\u0003\r=\u0003H/[8o!\rA\u0018q\b\u0003\u0006u:\u0011\ra\u001f\u0005\b\u0003\u0007r\u00019AA#\u0003\u0005i\u0007CBA\u0006\u0003#\ti\u0004\u0003\u0004\u0002J9\u0001\r\u0001W\u0001\tM&dWM\\1nK\u0002")
public class ZooKeeperPersistenceEngine
extends PersistenceEngine
implements Logging {
    private final Serializer serializer;
    private final String WORKING_DIR;
    private final CuratorFramework zk;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    private String WORKING_DIR() {
        return this.WORKING_DIR;
    }

    private CuratorFramework zk() {
        return this.zk;
    }

    @Override
    public void persist(String name, Object obj) {
        this.serializeIntoFile(new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(name).toString(), obj);
    }

    @Override
    public void unpersist(String name) {
        this.zk().delete().forPath(new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(name).toString());
    }

    @Override
    public <T> Seq<T> read(String prefix, ClassTag<T> evidence$1) {
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.zk().getChildren().forPath(this.WORKING_DIR())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(prefix)))).flatMap((Function1 & Serializable & scala.Serializable)filename -> Option$.MODULE$.option2Iterable(this.deserializeFromFile((String)filename, evidence$1)), Buffer$.MODULE$.canBuildFrom());
    }

    @Override
    public void close() {
        this.zk().close();
    }

    private void serializeIntoFile(String path, Object value) {
        ByteBuffer serialized = this.serializer().newInstance().serialize(value, ClassTag$.MODULE$.AnyRef());
        byte[] bytes = new byte[serialized.remaining()];
        serialized.get(bytes);
        ((PathAndBytesable)this.zk().create().withMode(CreateMode.PERSISTENT)).forPath(path, bytes);
    }

    private <T> Option<T> deserializeFromFile(String filename, ClassTag<T> m) {
        Some some;
        byte[] fileData = (byte[])this.zk().getData().forPath(new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(filename).toString());
        try {
            some = new Some(this.serializer().newInstance().deserialize(ByteBuffer.wrap(fileData), m));
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while reading persisted file, deleting", e);
            this.zk().delete().forPath(new StringBuilder(1).append(this.WORKING_DIR()).append("/").append(filename).toString());
            some = None$.MODULE$;
        }
        return some;
    }

    public ZooKeeperPersistenceEngine(SparkConf conf, Serializer serializer) {
        this.serializer = serializer;
        Logging.$init$(this);
        this.WORKING_DIR = new StringBuilder(14).append(conf.get("spark.deploy.zookeeper.dir", "/spark")).append("/master_status").toString();
        this.zk = SparkCuratorUtil$.MODULE$.newClient(conf, SparkCuratorUtil$.MODULE$.newClient$default$2());
        SparkCuratorUtil$.MODULE$.mkdir(this.zk(), this.WORKING_DIR());
    }
}

